/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import com.fasterxml.jackson.databind.JsonNode;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.type.JsonOperatorEnum;

public class JsonUtil {
    public static boolean evaluateJsonExpression(JsonNode contextNode, String attributeExpression) throws JRException {
        if (attributeExpression == null) {
            return true;
        }
        String attribute = null;
        JsonOperatorEnum operator = null;
        String value = null;
        boolean result = false;
        for (JsonOperatorEnum joe : JsonOperatorEnum.values()) {
            int indexOfOperator = attributeExpression.indexOf(joe.getValue());
            if (indexOfOperator == -1) continue;
            operator = joe;
            attribute = attributeExpression.substring(0, indexOfOperator).trim();
            value = attributeExpression.substring(indexOfOperator + joe.getValue().length()).trim();
            break;
        }
        if (operator == null) {
            StringBuffer possibleOperations = new StringBuffer();
            for (JsonOperatorEnum op : JsonOperatorEnum.values()) {
                possibleOperations.append(op.getValue()).append(",");
            }
            throw new JRException("Unknown operator in expression: " + attributeExpression + "; Operator must be one of: " + possibleOperations);
        }
        if (attribute != null && operator != null && value != null) {
            if (!contextNode.path(attribute).isValueNode()) {
                result = false;
            } else {
                String contextValue = contextNode.path(attribute).asText();
                switch (operator) {
                    case LT: {
                        try {
                            result = Double.parseDouble(contextValue) < Double.parseDouble(value);
                        }
                        catch (NumberFormatException nfe) {
                            result = false;
                        }
                        break;
                    }
                    case LE: {
                        try {
                            result = Double.parseDouble(contextValue) <= Double.parseDouble(value);
                        }
                        catch (NumberFormatException nfe) {
                            result = false;
                        }
                        break;
                    }
                    case GT: {
                        try {
                            result = Double.parseDouble(contextValue) > Double.parseDouble(value);
                        }
                        catch (NumberFormatException nfe) {
                            result = false;
                        }
                        break;
                    }
                    case GE: {
                        try {
                            result = Double.parseDouble(contextValue) >= Double.parseDouble(value);
                        }
                        catch (NumberFormatException nfe) {
                            result = false;
                        }
                        break;
                    }
                    case EQ: {
                        result = contextValue.equals(value);
                        break;
                    }
                    case NE: {
                        result = !contextValue.equals(value);
                    }
                }
            }
        }
        return result;
    }
}

