const date = require("date-and-time");
const models = require("../../../config/dbConnection").models;
const sequelize = require("../../../config/dbConnection").sequelize;
const globalData = require("../../global/globalData");
const GLOBAL_NOMENCLATURE = require("../../global/GLOBAL_NOMENCLATURE");
const clsActivityLog = require('../../model/clsActivityLog.model');
const clsCommonFun = require('../../model/Product/clsCommonInsertOperation.model');
const serverConfig = require("../../../../IncrencyV4DRLTSHConfig.json");
const objCommonFunOperation = new clsCommonFun();
const axios = require("axios");
const moment = require("moment");
const momentObj = require('moment');
const clsHmiModel = require('../../model/hmiDetail.model');
const objHmi = new clsHmiModel();
const objActivityLog = new clsActivityLog();
const clsMenuModel = require('../../model/Menu/MenuRequest.model');
const objmenu = new clsMenuModel();
const { QueryTypes } = require('sequelize');
const { electronMassDependencies } = require("mathjs");

const maths = require('mathjs')
const FormulaFunModel = require("../../model/Product/clsformulaFun.model");
const objformulaFun = new FormulaFunModel();

class PowerBackup {

  async getStatusoFTestForPowerBackup1(dataObj) {
    try {
      let dsNo = dataObj.DsNo;
      let tabIp = dataObj.TabIp;
      let tableName = "tbl_powerbackup";
      let cubicObj = dataObj.cubicObj;
      let userObj = dataObj.UserData;
      let productDetail = dataObj.SelectedMenuDetails;

      let powerbackup = await this.getPowerbackupData(dataObj);
      if (!powerbackup) {
        const _insertInpowerbackup = await models[tableName].create({

          CubicalNo: cubicObj.Sys_CubicNo,
          Sys_CubType: cubicObj.Sys_CubType,
          Sys_BFGCode: "NA",
          MPN_Code: cubicObj.Sys_MPNCode,
          Sys_Batch: cubicObj.Sys_Batch,
          WeighmentType: dataObj.typeValue,
          WeighmentName: dataObj.menuName,
          ProductType: cubicObj.ProductType,
          Userid: userObj.UserId,
          isException: dataObj.isExceptionValue,
          DsNo: dsNo,
          TabIp: tabIp,
          Incomp_RepSerNo: dataObj.Incomp_RepSerNo,
          RecSampleNo: dataObj.RecSampleNo,
          ReportType: cubicObj.Sys_RptType,

        });

        return _insertInpowerbackup;
      } else {
        await models[tableName].update({
          Incomp_RepSerNo: dataObj.Incomp_RepSerNo,
          RecSampleNo: dataObj.RecSampleNo,
          isException: dataObj.isExceptionValue
        }, {
          where: {
            CubicalNo: cubicObj.Sys_CubicNo,
            Sys_CubType: cubicObj.Sys_CubType,
            Sys_Batch: cubicObj.Sys_Batch,
            MPN_Code: cubicObj.Sys_MPNCode,
            // ProductType: productDetail.ProductType,
            ReportType: cubicObj.Sys_RptType,
            DsNo: dataObj.DsNo
          },
        });

        powerbackup = await this.getPowerbackupData(dataObj);
        return powerbackup.RecSampleNo;
      }
    } catch (error) {
      console.log(error)
      throw new Error(error)
    }
  }

  async getStatusoFTestForPowerBackup(powerbackupobj, individualDetail, tempUserObject) {
    try {
      let dsNo = powerbackupobj.DsNo;
      let tabIp = powerbackupobj.TabIp;
      let tableName = "tbl_powerbackup";
      let objSelMenu = globalData.arrSelectedMenu.find((k) => k.DsNo == dsNo && k.TabIp == tabIp);

      let _check_combination = await this._check_combination_pow(objSelMenu, powerbackupobj, tableName);
      if (_check_combination === undefined) {
        const _insertInPoerBackup = await models["tbl_powerbackup"].create({
          CubicalNo: powerbackupobj.cubicaNo,
          Sys_CubType: powerbackupobj.cubicType,
          Sys_BFGCode: powerbackupobj.cubicSysBFGcode,
          Sys_Batch: powerbackupobj.cubicBatch,
          WeighmentName: individualDetail.data.menuName,
          ProductType: powerbackupobj.productType,
          Userid: tempUserObject.UserId,
          DsNo: dsNo,
          TabIp: tabIp,
          Incomp_RepSerNo: powerbackupobj.Incomp_RepSerNo,
          RecSampleNo: powerbackupobj.RecSampleNo,
          ReportType: powerbackupobj.ReportType
        });

        let res = [_insertInPoerBackup.dataValues];
        return res[0];
        //console.log([_check_combination]);
      } else {
        await models[tableName].update({
          Incomp_RepSerNo: powerbackupobj.Incomp_RepSerNo,
          RecSampleNo: powerbackupobj.RecSampleNo
        }, {
          where: {
            CubicalNo: powerbackupobj.cubicaNo,
            Sys_CubType: powerbackupobj.cubicType,
            Sys_BFGCode: powerbackupobj.cubicSysBFGcode,
            Sys_Batch: powerbackupobj.cubicBatch,
            // ProductType: objSelMenu.selectedProductDetail.ProductType,
            ReportType: powerbackupobj.ReportType,
            DsNo: powerbackupobj.DsNo
          },
        });

        //  this.updateTestCount(objSelMenu, powerbackupobj, tableName);
        _check_combination = await this._check_combination_pow(objSelMenu, powerbackupobj, tableName);
        return _check_combination.RecSampleNo;
      }
    } catch (error) {
      console.log(error)
      throw new Error(error)
    }

  }

  async updateTestCount(objSelMenu, powerbackupobj, tableName) {
    // console.log(`updateTestCount:${JSON.stringify(powerbackupobj)}`)
    let _check_combination = await this._check_combination_pow(objSelMenu, powerbackupobj, tableName);
    if (_check_combination !== undefined) {
      let _check_update_combination = await models.tbl_powerbackup.update(
        {
          RecSampleNo: powerbackupobj.RecSampleNo,
          isException: powerbackupobj.isExceptionValue
        },
        {
          where: {
            CubicalNo: powerbackupobj.cubicaNo,
            Sys_CubType: powerbackupobj.cubicType,
            Sys_BFGCode: powerbackupobj.cubicSysBFGcode,
            Sys_Batch: powerbackupobj.cubicBatch,
            // ProductType: powerbackupobj.productType,
            DsNo: powerbackupobj.DsNo,
            ReportType: powerbackupobj.ReportType
          },
        }
      );
      //   console.log(`powerbackup ${powerbackupobj.Incomp_RepSerNo}`);
      //return powerbackupobj.Incomp_RepSerNo;
    } else {
      console.log("not found Incomp_RepSerNo");
    }
  }

  async getPowerbackupData(data) {
    try {
      let getPowerbackup = await models.tbl_powerbackup.findAll({
        where: {
          CubicalNo: data.cubicObj.Sys_CubicNo,
          Sys_CubType: data.cubicObj.Sys_CubType,
          MPN_Code: data.cubicObj.Sys_MPNCode,
          // Sys_BFGCode: data.cubicObj.Sys_BFGCode,
          Sys_Batch: data.cubicObj.Sys_Batch,
          // ProductType: data.SelectedMenuDetails.selectedProductDetail.ProductType,
          // Userid: data.UserData.UserId,
          DsNo: data.DsNo,
          ReportType: data.cubicObj.Sys_RptType,
          WeighmentName: data.menuName == GLOBAL_NOMENCLATURE.Friability ? 'FRIAB' : data.menuName
        }
      })

      return getPowerbackup[0]

    } catch (error) {
      console.log(`getPowerbackupData Error: ${error}`)
      throw new Error(error);
    }
  }

  async _check_combination_pow(objSelMenu, powerbackupobj, tableName) {
    //check if combination of product and batch is exist then start test form next
    // console.log(`_check_combination_pow:${JSON.stringify(powerbackupobj)}`)
    const _check_combination = await models[tableName].findAll({
      where: {
        CubicalNo: powerbackupobj.cubicaNo,
        Sys_CubType: powerbackupobj.cubicType,
        Sys_BFGCode: powerbackupobj.cubicSysBFGcode,
        Sys_Batch: powerbackupobj.cubicBatch,
        // ProductType: powerbackupobj.productType,
        Userid: powerbackupobj.Userid,
        DsNo: powerbackupobj.DsNo,
        // TabIp: powerbackupobj.TabIp,
        ReportType: powerbackupobj.ReportType

      },
    });
    return [_check_combination][0][0];
  }
  async _check_empty_combination_pow(objSelMenu, powerbackupobj, tableName) {
    //check if combination of product and batch is exist then start test form next
    const _check_combination = await models[tableName].findAll({
      where: {
        CubicalNo: powerbackupobj.cubicaNo,
        Sys_CubType: powerbackupobj.cubicType,
        Sys_BFGCode: powerbackupobj.cubicSysBFGcode,
        Sys_Batch: powerbackupobj.cubicBatch,
        ProductType: powerbackupobj.productType,
        Userid: powerbackupobj.Userid,
        DsNo: powerbackupobj.DsNo,
        ReportType: powerbackupobj.ReportType
      },
    });
    return [_check_combination][0][0];
  }
  async getEmptyShellStatusoFTestForPowerBackup(powerbackupobj) {
    let strHmi = powerbackupobj.Hmi;
    let strIdsNo = powerbackupobj.idsNo;
    let tableName = "tbl_powerbackup";
    let individualDetail = globalData.arrWeighmentProductData.find(
      (k) => k.Hmi == strHmi
    );
    // let _cubicalData = globalData.arrIdsInfo.find(k => k.idsNo == strIdsNo).cubicalData;
    let objSelMenu = globalData.arrSelectedMenu.find(
      (k) => k.idsNo == strIdsNo
    );
    let tempUserObject = globalData.arrUsers.find((k) => k.Hmi == strHmi);

    let _check_combination = await this._check_empty_combination_pow(
      objSelMenu,
      powerbackupobj,
      tableName
    );
    if (_check_combination === undefined) {
      const _insertInPoerBackup = await models["tbl_powerbackup"].create({
        CubicalNo: powerbackupobj.cubicaNo,
        Sys_CubType: powerbackupobj.cubicType,
        Sys_BFGCode: powerbackupobj.cubicSysBFGcode,
        Sys_Batch: powerbackupobj.cubicBatch,
        WeighmentName: individualDetail.data.menuName,
        ProductType: 0,
        Userid: tempUserObject.UserId,
        Idsno: strHmi,
        Incomp_RepSerNo: powerbackupobj.Incomp_RepSerNo,
        RecSampleNo: powerbackupobj.RecSampleNo,
        ReportType: powerbackupobj.ReportType
      });

      let res = [_insertInPoerBackup];
      return res[0][0];
      //console.log([_check_combination]);
    } else {
      //  this.updateTestCount(objSelMenu, powerbackupobj, tableName);
      _check_combination = await this._check_empty_combination_pow(
        objSelMenu,
        powerbackupobj,
        tableName
      );
      return _check_combination.Incomp_RepSerNo;
    }
  }
  async updateEmptyShellTestCount(objSelMenu, powerbackupobj, tableName) {
    let _check_combination = await this._check_empty_combination_pow(
      objSelMenu,
      powerbackupobj,
      tableName
    );
    if (_check_combination !== undefined) {
      let _check_update_combination = await models.tbl_powerbackup.update(
        {
          RecSampleNo: powerbackupobj.RecSampleNo,
        },
        {
          where: {
            CubicalNo: powerbackupobj.cubicaNo,
            Sys_CubType: powerbackupobj.cubicType,
            Sys_BFGCode: powerbackupobj.cubicSysBFGcode,
            Sys_Batch: powerbackupobj.cubicBatch,
            ProductType: 0,
            IdsNo: powerbackupobj.Hmi,
            ReportType: powerbackupobj.ReportType
          },
        }
      );
      //   console.log(`powerbackup ${powerbackupobj.Incomp_RepSerNo}`);
      //return powerbackupobj.Incomp_RepSerNo;
    } else {
      console.log("not found Incomp_RepSerNo");
    }
  }


  async updateTerminatedFlag(menuName, powerBackup, cubicObj) {
    try {
      let menuArr = [GLOBAL_NOMENCLATURE.Hardness,
      GLOBAL_NOMENCLATURE.IndividualMenu,
      GLOBAL_NOMENCLATURE.LockedLength,
      GLOBAL_NOMENCLATURE.Differential,
      GLOBAL_NOMENCLATURE.FriabilatorMenu,
      GLOBAL_NOMENCLATURE.Friability
      ]
      if (menuArr.includes(menuName)) {
        let eqpdetail = await models.tbl_otherequipment.findOne({
          where: {
            Eqp_ID: cubicObj.Sys_HardID
          }
        })

        if ((!(menuName == GLOBAL_NOMENCLATURE.Hardness && globalData.FTPHardnessModel.includes(eqpdetail?.model))) && menuArr.includes(menuName)) {

          let detailTable
          if (menuName == GLOBAL_NOMENCLATURE.IndividualMenu) {
            detailTable = 'tbl_tab_initialdetail1_incomplete'
          } else if (menuName == GLOBAL_NOMENCLATURE.LockedLength) {
            detailTable = 'tbl_tab_initialdetail5_incomplete'
          } else if (menuName == GLOBAL_NOMENCLATURE.Differential) {
            detailTable = 'tbl_tab_initialdetail3_incomplete'
          } else if (menuName == GLOBAL_NOMENCLATURE.Hardness) {
            detailTable = 'tbl_tab_initialdetailhtd_incomplete'
          } else if (menuName == GLOBAL_NOMENCLATURE.Friability ||
            menuName == GLOBAL_NOMENCLATURE.FriabilatorMenu
          ) {
            detailTable = 'tbl_tab_initialdetail8_incomplete'
          } else if (menuName == GLOBAL_NOMENCLATURE.GroupMenu && cubicObj.Sys_Area.toLowerCase() != 'coating') {
            detailTable = 'tbl_tab_initialdetail2_icomplete'
          }
          let key = menuName == GLOBAL_NOMENCLATURE.Hardness ? 'isTerminated' : 'isCompleted'
          detailTable = powerBackup.ProductType  == 2 ? detailTable.replace("tab", "cap") : detailTable
          let detailWhereCondition = {
            RepSerNo: powerBackup.Incomp_RepSerNo
          }

          if(menuName == GLOBAL_NOMENCLATURE.DT ||
             menuName == GLOBAL_NOMENCLATURE.Friability ||
             menuName == GLOBAL_NOMENCLATURE.DTTest
          ){
            detailWhereCondition.isException = 0
          }
          await models[detailTable].update({
            [key]: 1
          }, {
            where: detailWhereCondition
          })
          


        }
      }

    } catch (error) {
      console.log(error)
    }
  }
  async chkPowerBackupPresent1(data) {
    try {


      var objuser = await models["tbl_users"].findAll({ where: { UserID: data.userId } });
      objuser = objuser[0];
      var _calib_entry = await models["tbl_powerbackup"].findAll({ where: { DsNo: data.dsNo, TabIp: data.tabIp } });
      var ChangeBatch = await models.tbl_cubical.findAll({
        where: {
          Sys_DSNumber: data.dsNo,
        },
      });

      if (_calib_entry.length != 0) {
        if (_calib_entry[0].WeighmentType == "Calib") {
          let check = await models["tbl_powerbackup"].findAll({
            where: {
              // Userid: data.userId,
              DsNo: data.dsNo,
              // ReportType: ChangeBatch[0].Sys_RptType
            },
          });
          check = check[0];
          if (_calib_entry[0].Instrument_Model != ChangeBatch[0].Sys_BalID) {    //Different BalanceID
            var ExistingBatch = await models["tbl_powerbackup"].destroy({
              where: {
                DsNo: data.dsNo,
              },
            });
            check.WeighmentName = check.WeighmentName.toUpperCase()
            await objActivityLog.ActivityLogEntry({
              strUserId: data.userId,
              strUserName: objuser.UserInitials,
              batch: ChangeBatch[0].Sys_Batch,
              activity: `${check.WeighmentName} Calibration Discarded on Ds ${data.dsNo} due to Balance Change`,
            });
            await this.moveCalibrationIncompleteToFail(data.dsNo);
          }
          if (check.Userid != data.userId) {     //Different UserID
            //discard tht old user test

            await models.tbl_powerbackup.destroy({
              where: {
                DsNo: data.dsNo,
                Userid: check.Userid,
              },
            });

            check.WeighmentName = check.WeighmentName.toUpperCase()
            if (check.WeighmentName == GLOBAL_NOMENCLATURE.Daily) {
              await models.tbl_calibration_daily_master_incomplete.update({
                "Inprocess": 0,
              }, {
                where: { 'Daily_BalID': check.Instrument_Model }
              })
            }

            await objActivityLog.ActivityLogEntry({
              strUserId: data.userId,
              strUserName: objuser.UserInitials,
              batch: ChangeBatch[0].Sys_Batch,
              activity: `${check.WeighmentName} Calibration Discarded on Ds ${data.dsNo} of user ${check.Userid}`,
            });
            await this.moveCalibrationIncompleteToFail_differ_user(data.dsNo);
            return "VALIDATED";
          }
          // else {
          //   check.message = GLOBAL_NOMENCLATURE.powerBackupMessage + weightmentName;
          // }

          _calib_entry = await models["tbl_powerbackup"].findAll({
            where: {
              DsNo: data.dsNo,
            },
          });
          if (_calib_entry.length != 0) {
            if (_calib_entry[0].WeighmentType == "Calib") {
              let _Calib_data = await this._get_calib_data(data, _calib_entry[0]);
              return _Calib_data;
            }
          }

        }
      } else {
        var response = "VALIDATED";
      }
      if ((ChangeBatch[0].Sys_cubTypes != "IPQA") && (ChangeBatch[0].Sys_CubType != 'IPQC')) {
        var ExistingBatch = await models["tbl_powerbackup"].findAll({ where: { DsNo: data.dsNo, TabIp: data.tabIp } });
        if (ExistingBatch.length != 0) {
          if (ChangeBatch[0].Sys_Batch != ExistingBatch[0].Sys_Batch) {  //Different Batch 
            var check = await models.tbl_powerbackup.destroy({
              where: {
                DsNo: data.dsNo,
                TabIp: data.tabIp
              },
            });
          }
        }
        var Checkchangerpttype = await models["tbl_powerbackup"].findAll({
          where: {
            Userid: data.userId,
            DsNo: data.dsNo,
            TabIp: data.tabIp
          },
        });

        if (Checkchangerpttype.length != 0) {
          if (Checkchangerpttype[0].ReportType != ChangeBatch[0].Sys_RptType) {
            var Checkchangerpttype = await models["tbl_powerbackup"].destroy({
              where: {
                Userid: data.userId,
                TabIp: data.tabIp,
                DsNo: data.dsNo,
                ReportType: Checkchangerpttype[0].ReportType,
              },
            });
            console.log(data.dsNo, "Report Type Change");
          }
        }
      }

      var check = await models["tbl_powerbackup"].findAll({
        where: {
          // Userid: data.userId,
          DsNo: data.dsNo,
          TabIp: data.tabIp
          // ReportType: ChangeBatch[0].Sys_RptType
        },
      });
      check = check[0];

      let bind_entry = await models.tbl_ds_binding.findAll({
        where: {
          DS_NUMBER: data.dsNo,
        }
      })

      var flag = 0;

      //check is there any other Tab accessing same port
      if (bind_entry.length > 0 && check) {
        let catchArr = ['Individual', 'Group', 'FRIAB'];
        if (catchArr.includes(check.WeighmentName)) {
          let obj = {}
          catchArr.map((item, key) => obj[item] = key)
          let entry = bind_entry.filter(item => item.TAB_IP != data.tabIp && obj.hasOwnProperty(item.MenuName))
          flag = entry.length;
        } else {
          let entry = bind_entry.filter(item => item.TAB_IP != data.tabIp && item.MenuName == check.WeighmentName)
          flag = entry.length;
        }
      }

      if (check != undefined && check != null && check.length != 0 && !flag) {
        var strMenuName = check.WeighmentName;
        var masterTable = "";
        var detailTable = "";
        switch (strMenuName) {
          case `${GLOBAL_NOMENCLATURE.GroupMenu}`:
            if (ChangeBatch[0].Sys_Area == 'Coating') {
              masterTable = "tbl_tab_master2_incomplete"
            } else {
              masterTable = "tbl_tab_initialmaster_incomplete";
            }
            break;
          case GLOBAL_NOMENCLATURE.ThicknessMenu:
            masterTable = "tbl_tab_master3_incomplete";
            break;
          case GLOBAL_NOMENCLATURE.IndividualMenu:
          case GLOBAL_NOMENCLATURE.HardnessMenu:
          case GLOBAL_NOMENCLATURE.LockedLength:
          case GLOBAL_NOMENCLATURE.FriabilatorMenu:
          case GLOBAL_NOMENCLATURE.Friability:
          case GLOBAL_NOMENCLATURE.DTMenu:
          case GLOBAL_NOMENCLATURE.Differential:
          case GLOBAL_NOMENCLATURE.EmptyGroupMenu:
            masterTable = "tbl_tab_initialmaster_incomplete";
            break;
        }
        masterTable = check.ProductType == 2 ? masterTable.replace("tab", "cap") : masterTable

        var prodmaster = await models[masterTable].findOne({
          where: {
            RepSerNo: check.Incomp_RepSerNo,
          },
        });

        var weightmentName = "";
        var pre_sample = "";
        switch (check.WeighmentName) {
          case `${GLOBAL_NOMENCLATURE.IndividualMenu}`:
            weightmentName = "Individual";
            pre_sample = "DataValue";
            break;
          case `${GLOBAL_NOMENCLATURE.EmptyGroupMenu}`:
            weightmentName = "Empty Group";
            pre_sample = "DataValue";
            break;
          case `${GLOBAL_NOMENCLATURE.GroupMenu}`:
            weightmentName = "Group";
            pre_sample = "DataValue";
            break;

          case GLOBAL_NOMENCLATURE.LockedLength:
            weightmentName = GLOBAL_NOMENCLATURE.LockedLength;
            pre_sample = "DataValue";
            break;
          case GLOBAL_NOMENCLATURE.Differential:
            weightmentName = GLOBAL_NOMENCLATURE.Differential;
            pre_sample = "DataValue";
            break;
          case GLOBAL_NOMENCLATURE.HardnessMenu:
            weightmentName = "Hardness";
            pre_sample = "DataValue";
            break;

          case GLOBAL_NOMENCLATURE.HardnessMenu:
            weightmentName = "Thickness";
            pre_sample = "DataValue";
            break;


          default:
            weightmentName = check.WeighmentName.toUpperCase();
        }

        //if not same user then give msg to discard / logout or normal pending msg
        //  let sameUserId = true
        //  let otherUser = false
        if (check.Userid.toLowerCase() != data.userId.toLowerCase()) {
          //discard tht old user test

          await models.tbl_powerbackup.destroy({
            where: {
              DsNo: data.dsNo,
              TabIp: data.tabIp,
              Userid: check.Userid,
            },
          });

          this.updateTerminatedFlag(check.WeighmentName, check, ChangeBatch[0])

          if (check.WeighmentName == GLOBAL_NOMENCLATURE.IndividualMenu) {
            let objSelMenu = globalData.arrSelectedMenu.find((k) => k.DsNo == data.dsNo && k.TabIp == data.tabIp);
            // if (objSelMenu.selectedProductDetail.hasOwnProperty('isonstd') ? objSelMenu.selectedProductDetail.data[0] : 0) {
            //   var masterTable = 'tbl_tab_master1';
            //   var detailTable = 'tbl_tab_detail1';
            //   // strincomplete =  'tbl_tab_master1_incomplete'
            //   var detail_tableName = detailTable.concat("_incomplete");
            //   var master_tableName = masterTable.concat("_incomplete");
            //   var get_Datavalue = await models[detail_tableName].findAll({ where: { RepSerNo: check.Incomp_RepSerNo, } })
            //   var get_Datavalue1 = await models[master_tableName].findAll({ where: { RepSerNo: check.Incomp_RepSerNo, } })

            //   objSelMenu.selectedProductDetail.nominal = get_Datavalue1[0].AvgValue;

            //   var Nominal = objSelMenu.selectedProductDetail.nominal;
            //   Nominal = Number(Nominal).toFixed(2);

            //   var typeValue = 1;
            //   var maxLimitT1 = objformulaFun.upperLimit(objSelMenu.selectedProductDetail, 'T1');
            //   var maxLimitT2 = objformulaFun.upperLimit(objSelMenu.selectedProductDetail, 'T2');
            //   var minLimitT2 = objformulaFun.lowerLimit(objSelMenu.selectedProductDetail, 'T2');
            //   var minLimitT1 = objformulaFun.lowerLimit(objSelMenu.selectedProductDetail, 'T1');

            //   var DataValue_arr = [];

            //   get_Datavalue1[0].NoOfBelowT1 = 0;
            //   get_Datavalue1[0].NoOfAboveT1 = 0;
            //   get_Datavalue1[0].NoOfBelowT2 = 0;
            //   get_Datavalue1[0].NoOfAboveT2 = 0;

            //   DataValue_arr.push(get_Datavalue);
            //   var arr = [];
            //   for (var i = 0; i < get_Datavalue.length; i++) {
            //     var a = get_Datavalue[i].DataValue;

            //     if (Number(a) < Number(minLimitT2)) {
            //       get_Datavalue1[0].NoOfBelowT2 = Number(get_Datavalue1[0].NoOfBelowT2) + 1;
            //     } else if (Number(a) > Number(maxLimitT2)) {
            //       get_Datavalue1[0].NoOfAboveT2 = Number(get_Datavalue1[0].NoOfAboveT2) + 1;
            //     }
            //     if (maxLimitT1 != 0 && minLimitT1 != 0) {
            //       if (Number(a) < Number(minLimitT1) && Number(a) >= Number(minLimitT2)) {
            //         get_Datavalue1[0].NoOfBelowT1 = Number(get_Datavalue1[0].NoOfBelowT1) + 1;
            //       } else if (Number(a) > Number(maxLimitT1) && Number(a) <= Number(maxLimitT2)) {
            //         get_Datavalue1[0].NoOfAboveT1 = Number(get_Datavalue1[0].NoOfAboveT1) + 1;
            //       }
            //     }

            //     arr.push(Number(a));
            //     console.log(arr);
            //     var max_value = maths.max(arr);
            //     max_value = max_value.toFixed(1);
            //     var min_value = maths.min(arr);
            //     min_value = min_value.toFixed(1);
            //     var std_value = maths.std(arr);
            //     std_value = std_value.toFixed(2);
            //     var total = arr.reduce((acc, total) => {
            //       return Number(total) + Number(acc);
            //     }, 0)
            //     var avg = total / arr.length
            //     avg = maths.abs(avg).toFixed(1);
            //     var minPer_value = ((Nominal - min_value) / Nominal) * 100;
            //     minPer_value = maths.abs(minPer_value).toFixed(2)
            //     var maxPer_value = ((max_value - Nominal) / Nominal) * 100;
            //     maxPer_value = maths.abs(maxPer_value).toFixed(2)

            //     // console.log();
            //     console.log(max_value, min_value, std_value, avg, minPer_value, maxPer_value);
            //     // return arr;

            //     var get_Datavalue11 = await models[master_tableName].update({
            //       AvgValue: avg,
            //       MinValue: min_value,
            //       MaxValue: max_value,
            //       // StdDev: std_value,
            //       MinPer: minPer_value,
            //       MaxPer: maxPer_value,
            //       NoOfAboveT1: get_Datavalue1[0].NoOfAboveT1,
            //       NoOfAboveT2: get_Datavalue1[0].NoOfAboveT2,
            //       NoOfBelowT1: get_Datavalue1[0].NoOfBelowT1,
            //       NoOfBelowT2: get_Datavalue1[0].NoOfBelowT2,
            //       T1NegTol: Number(minLimitT1).toFixed(1),
            //       T1PosTol: Number(maxLimitT1).toFixed(1),
            //       T2NegTol: Number(minLimitT2).toFixed(1),
            //       T2PosTol: Number(maxLimitT2).toFixed(1),
            //     }, { where: { RepSerNo: check.Incomp_RepSerNo } });
            //   }
            // }
            await models.tbl_tab_master1_incomplete.update(
              {
                IsProcess: 0,
                PrEndDate: momentObj().format("YYYY-MM-DD"),
                PrEndTime: momentObj().format("HH:mm:ss"),
                FailedRemark: "Aborted test"
              }, {
              where: {
                RepSerNo: check.Incomp_RepSerNo,
              }
            }
            );
            var hmiDetails = await models.tbl_tab_initialmaster_incomplete.findAll({
              where: {
                RepSerNo: check.Incomp_RepSerNo,
              }
            })
            hmiDetails = hmiDetails[0]
            var act = `${weightmentName} Test Discarded on DS ${data.dsNo} of user ${check.Userid}`
            if (hmiDetails.Side != 'NA') {
              var act = `${weightmentName} Test Discarded on TSH ${data.dsNo} of user ${check.Userid} for side ${hmiDetails.Side}`
            }
          } else if (check.WeighmentName == GLOBAL_NOMENCLATURE.Hardness) {
            await models.tbl_tab_initialmaster_incomplete.update(
              {
                IsProcess: 0,
                PrEndDate: momentObj().format("YYYY-MM-DD"),
                PrEndTime: momentObj().format("HH:mm:ss"),
                FailedRemark: "Aborted test"
              }, {
              where: {
                RepSerNo: check.Incomp_RepSerNo,
              }
            }
            );
            var hmiDetails = await models.tbl_tab_initialmaster_incomplete.findAll({
              where: {
                RepSerNo: check.Incomp_RepSerNo,
              }
            })
            hmiDetails = hmiDetails[0]
            var act = `Thickness & ${weightmentName} Test Discarded on TSH ${data.dsNo} of user ${check.Userid}`
            if (hmiDetails.Side != 'NA') {
              var act = `Thickness & ${weightmentName} Test Discarded on TSH ${data.dsNo} of user ${check.Userid} for side ${hmiDetails.Side}`
            }

          } else if (check.WeighmentName == GLOBAL_NOMENCLATURE.ThicknessMenu) {
            await models.tbl_tab_master3_incomplete.update(
              {
                IsProcess: 0,
                PrEndDate: momentObj().format("YYYY-MM-DD"),
                PrEndTime: momentObj().format("HH:mm:ss"),
                FailedRemark: "Aborted test"
              }, {
              where: {
                RepSerNo: check.Incomp_RepSerNo,
              }
            }
            );
            var hmiDetails = await models.tbl_tab_master3_incomplete.findAll({
              where: {
                RepSerNo: check.Incomp_RepSerNo,
              }
            })
            hmiDetails = hmiDetails[0]
            var act = `${weightmentName} Test Discarded on TSH ${data.dsNo} of user ${check.Userid}`
            if (hmiDetails.Side != 'NA') {
              var act = `${weightmentName} Test Discarded on TSH ${data.dsNo} of user ${check.Userid} for side ${hmiDetails.Side}`
            }

          } else {

          }

          await objActivityLog.ActivityLogEntry({
            strUserId: data.userId,
            strUserName: objuser.UserInitials,
            batch: ChangeBatch[0].Sys_Batch,
            activity: act,
          });
          var Hmi = data.dsNo;
          globalData.arrWeighmentCounter.findIndex(k => k.DsNo === data.dsNo && k.TabIp == data.tabIp) == -1 ?
            globalData.arrWeighmentCounter :
            globalData.arrWeighmentCounter.splice(globalData.arrWeighmentCounter.findIndex(k => k.DsNo === data.dsNo && k.TabIp == data.tabIp), 1);

          (globalData.arrCurrentOperationStatus.findIndex((k) => k.DsNo === data.dsNo && k.TabIp == data.tabIp)) == -1 ?
            globalData.arrCurrentOperationStatus :
            globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex((k) => k.DsNo === data.dsNo && k.TabIp == data.tabIp), 1);

          (globalData.arrWeighmentCounterAfter.findIndex((k) => k.DsNo === data.dsNo && k.TabIp == data.tabIp)) == -1 ?
            globalData.arrWeighmentCounterAfter :
            globalData.arrWeighmentCounterAfter.splice(globalData.arrWeighmentCounterAfter.findIndex((k) => k.DsNo === data.dsNo && k.TabIp == data.tabIp), 1);

          (globalData.arrProtocolData.findIndex((k) => k.DsNo === data.dsNo && k.TabIp == data.tabIp)) == -1 ?
            globalData.arrProtocolData :
            globalData.arrProtocolData.splice(globalData.arrProtocolData.findIndex((k) => k.DsNo === data.dsNo && k.TabIp == data.tabIp), 1);

          (globalData.arrOutFlagForTest.findIndex((k) => k.DsNo === data.dsNo && k.TabIp == data.tabIp)) == -1 ?
            globalData.arrOutFlagForTest :
            globalData.arrOutFlagForTest.splice(globalData.arrOutFlagForTest.findIndex(k => k.DsNo === data.dsNo && k.TabIp == data.tabIp), 1);

          globalData.arrSelectedMenu.findIndex(k => k.DsNo === data.dsNo && k.TabIp == data.tabIp) == -1 ?
            globalData.arrSelectedMenu :
            globalData.arrSelectedMenu.splice(globalData.arrSelectedMenu.findIndex(k => k.Hmi == Hmi), 1);

          (globalData.HardnessMasterEntry.findIndex(k => k.DsNo === data.dsNo && k.TabIp == data.tabIp)) == -1 ?
            globalData.HardnessMasterEntry :
            globalData.HardnessMasterEntry.splice(globalData.HardnessMasterEntry.findIndex(k => k.DsNo === data.dsNo && k.TabIp == data.tabIp), 1);

          (globalData.DoubSide.findIndex(k => k.DsNo === data.dsNo && k.TabIp == data.tabIp)) == -1 ?
            globalData.DoubSide :
            globalData.DoubSide.splice(globalData.DoubSide.findIndex(k => k.DsNo === data.dsNo && k.TabIp == data.tabIp), 1);

          (globalData.arrside.findIndex(k => k.DsNo === data.dsNo && k.TabIp == data.tabIp)) == -1 ?
            globalData.arrside :
            globalData.arrside.splice(globalData.arrside.findIndex(k => k.DsNo === data.dsNo && k.TabIp == data.tabIp), 1);

          globalData.arrPushValuesOfHardness.findIndex(k => k.DsNo === data.dsNo && k.TabIp == data.tabIp) == -1 ?
            globalData.arrPushValuesOfHardness :
            globalData.arrPushValuesOfHardness.splice(globalData.arrPushValuesOfHardness.findIndex(k => k.Hmi == Hmi), 1);

          globalData.arrsampleno.findIndex(k => k.DsNo === data.dsNo && k.TabIp == data.tabIp) == -1 ?
            globalData.arrsampleno :
            globalData.arrsampleno.splice(globalData.arrsampleno.findIndex(k => k.DsNo === data.dsNo && k.TabIp == data.tabIp), 1);

          globalData.arrHardnessMT50.findIndex(k => k.DsNo === data.dsNo && k.TabIp == data.tabIp) == -1 ?
            globalData.arrHardnessMT50 :
            globalData.arrHardnessMT50.splice(globalData.arrHardnessMT50.findIndex(k => k.DsNo === data.dsNo && k.TabIp == data.tabIp), 1);

          globalData.formatching.findIndex(k => k.DsNo === data.dsNo && k.TabIp == data.tabIp) == -1 ?
            globalData.formatching :
            globalData.formatching.splice(globalData.formatching.findIndex(k => k.DsNo === data.dsNo && k.TabIp == data.tabIp), 1);

          return "VALIDATED";
          // sameUserId = false
          // otherUser = true
        } else {
          // if (weightmentName == 'Hardness') {
          //   weightmentName = 'Thickness & ' + weightmentName
          // }
          check.message = GLOBAL_NOMENCLATURE.powerBackupMessage + weightmentName;
        }


        const selectProductMaster = await models.tbl_product_master.findAll({
          where: {
            ProductName: ChangeBatch[0].Sys_ProductName,
            ProductId: ChangeBatch[0].Sys_BFGCode,
            ProductVersion: ChangeBatch[0].Sys_PVersion,
            Version: ChangeBatch[0].Sys_Version,
            MPN_Code: ChangeBatch[0].Sys_MPNCode
          },
        });
        let arrResProductMaster = [selectProductMaster];
        let productType = arrResProductMaster[0][0].ProductType;
        let TableName;
        let tableName;
        let col;
        var arrHardnessColumn = [];
        if (productType == 1) {
          switch (ChangeBatch[0].Sys_CubType) {
            case "Compression":
            case "Effervescent Compression":
            case "IPQC":
            case "IPQA":
              tableName = "tbl_product_tablet";
              TableName = models.tbl_product_tablet;
              break;
            case "Coating":
            case "Pallet Coating":
              tableName = "tbl_product_tablet_coated";
              TableName = models.tbl_product_tablet_coated;
              break;
            case "Effervescent Granulation":
            case "Granulation":
              tableName = "tbl_product_gran";
              TableName = models.tbl_product_gran;
              break;
          }
        } else if (productType == 2 && ChangeBatch[0].Sys_Area == "Capsule Filling") {
          tableName = "tbl_product_capsule";
          TableName = models.tbl_product_capsule;
        } else if (productType == 2 && ChangeBatch[0].Sys_Area == "Granulation") {
          tableName = "tbl_product_gran_cap";
          TableName = models.tbl_product_gran_cap;
        } else if (productType == 2 && ChangeBatch == "Pallet Coating") {
          tableName = "tbl_product_capsule";
          TableName = models.tbl_product_capsule;
        } else if (productType == 3 && ChangeBatch == "Multihaler") {
          tableName = "tbl_product_multihaler";
          TableName = models.tbl_product_multihaler;
        } else {
          console.log("jncjsnc");
        }
        const selectObj = await models[tableName].findAll({
          where: {
            ProductName: ChangeBatch[0].Sys_ProductName,
            ProductId: ChangeBatch[0].Sys_BFGCode,
            ProductVersion: ChangeBatch[0].Sys_PVersion,
            Version: ChangeBatch[0].Sys_Version,
          },
        });
        var productData_ = selectObj[0]
        let arrResOfProductDetail = [[selectObj[0]]];
        if (strMenuName == GLOBAL_NOMENCLATURE.Hardness) {
          arrResOfProductDetail[0][0]["Param3_T2Pos"] == (99999 || 0)
            ? 0
            : arrHardnessColumn.push("Thickness");
          arrResOfProductDetail[0][0]["Param4_Nom"] == (99999 || 0)
            ? 0
            : arrHardnessColumn.push("Breadth");
          arrResOfProductDetail[0][0]["Param5_Nom"] == (99999 || 0)
            ? 0
            : arrHardnessColumn.push("Length");
          arrResOfProductDetail[0][0]["Param6_Nom"] == (99999 || 0)
            ? 0
            : arrHardnessColumn.push("Diameter");
          arrResOfProductDetail[0][0]["Param7_T2Pos"] == (99999 || 0)
            ? 0
            : arrHardnessColumn.push("Hardness");

          let arrHardnessColumnDetail = [];
          var pl_mi_limit = 0;
          var pl_mi_limitthik = 0;
          var pl_mi_limithardness = 0;
          var unitThik = arrResOfProductDetail[0][0]['Param3_Unit']
          var unitHard = arrResOfProductDetail[0][0]['Param7_Unit']
          var unitIndi = arrResOfProductDetail[0][0]['Param1_Unit']
          if (arrResOfProductDetail[0][0]['Param1_Nom'] != 99999 && arrResOfProductDetail[0][0]['Param1_Nom'] != '') {
            if ((arrResOfProductDetail[0][0]['Param1_Nom'] - arrResOfProductDetail[0][0]['Param1_T2Neg']).toFixed(3) == (arrResOfProductDetail[0][0]['Param1_T2Pos'] - arrResOfProductDetail[0][0]['Param1_Nom']).toFixed(3)) {
              pl_mi_limit = "±" + (arrResOfProductDetail[0][0]['Param1_Nom'] - arrResOfProductDetail[0][0]['Param1_T2Neg']).toFixed(3);
            }
            else {
              pl_mi_limit = '+  ' + (arrResOfProductDetail[0][0]['Param1_T2Pos'] - arrResOfProductDetail[0][0]['Param1_Nom']).toFixed(3) + ' -' + (arrResOfProductDetail[0][0]['Param1_Nom'] - arrResOfProductDetail[0][0]['Param1_T2Neg']).toFixed(3);
            }
          }
          var Objindividual = {
            Nominal: arrResOfProductDetail[0][0]['Param1_Nom'] + " " + unitIndi,
            T1Neg: arrResOfProductDetail[0][0]['Param1_T1Neg'] + " " + unitIndi,
            T1Pos: arrResOfProductDetail[0][0]['Param1_T1Pos'] + " " + unitIndi,
            T2Pos: arrResOfProductDetail[0][0]['Param1_T2Pos'] + " " + unitIndi,
            T2Neg: arrResOfProductDetail[0][0]['Param1_T2Neg'] + " " + unitIndi,
            pl_mi_limit: pl_mi_limit
            // LimitOn: arrResOfProductDetail[0][0]['Param1_LimitOn'],

          }
          if (arrResOfProductDetail[0][0]['Param3_Nom'] != 99999 && arrResOfProductDetail[0][0]['Param3_Nom'] != '') {
            if ((arrResOfProductDetail[0][0]['Param3_Nom'] - arrResOfProductDetail[0][0]['Param3_T2Neg']).toFixed(3) == (arrResOfProductDetail[0][0]['Param3_T2Pos'] - arrResOfProductDetail[0][0]['Param3_Nom']).toFixed(3)) {
              pl_mi_limitthik = "±" + (arrResOfProductDetail[0][0]['Param3_Nom'] - arrResOfProductDetail[0][0]['Param3_T2Neg']).toFixed(3);
            }
            else {
              pl_mi_limitthik = '+  ' + (arrResOfProductDetail[0][0]['Param3_T2Pos'] - arrResOfProductDetail[0][0]['Param3_Nom']).toFixed(3) + ' -' + (arrResOfProductDetail[0][0]['Param3_Nom'] - arrResOfProductDetail[0][0]['Param3_T2Neg']).toFixed(3);
            }
          }
          var objThickness = {
            Nominal: arrResOfProductDetail[0][0]['Param3_Nom'],
            T1Neg: arrResOfProductDetail[0][0]['Param3_T1Neg'],
            T1Pos: arrResOfProductDetail[0][0]['Param3_T1Pos'],
            T2Pos: arrResOfProductDetail[0][0]['Param3_T2Pos'],
            T2Neg: arrResOfProductDetail[0][0]['Param3_T2Neg'],
            Unit: unitThik,
            pl_mi_limit: pl_mi_limitthik
            // LimitOn: arrResOfProductDetail[0][0]['Param3_LimitOn'],
          }
          if (arrResOfProductDetail[0][0]['Param7_Nom'] != 99999 && arrResOfProductDetail[0][0]['Param7_Nom'] != '') {
            if ((arrResOfProductDetail[0][0]['Param7_Nom'] - arrResOfProductDetail[0][0]['Param7_T2Neg']).toFixed(3) == (arrResOfProductDetail[0][0]['Param7_T2Pos'] - arrResOfProductDetail[0][0]['Param7_Nom']).toFixed(3)) {
              pl_mi_limithardness = "±" + (arrResOfProductDetail[0][0]['Param7_Nom'] - arrResOfProductDetail[0][0]['Param7_T2Neg']).toFixed(3);
            }
            else {
              pl_mi_limithardness = '+  ' + (arrResOfProductDetail[0][0]['Param7_T2Pos'] - arrResOfProductDetail[0][0]['Param7_Nom']).toFixed(3) + ' -' + (arrResOfProductDetail[0][0]['Param7_Nom'] - arrResOfProductDetail[0][0]['Param7_T2Neg']).toFixed(3);
            }
          }
          var objHardness = {
            Nominal: arrResOfProductDetail[0][0]['Param7_Nom'],
            T1Neg: arrResOfProductDetail[0][0]['Param7_T1Neg'],
            T1Pos: arrResOfProductDetail[0][0]['Param7_T1Pos'],
            T2Pos: arrResOfProductDetail[0][0]['Param7_T2Pos'],
            T2Neg: arrResOfProductDetail[0][0]['Param7_T2Neg'],
            Unit: unitHard,
            pl_mi_limit: pl_mi_limithardness
            // LimitOn: arrResOfProductDetail[0][0]['Param7_LimitOn'],
          }

          arrResOfProductDetail[0][0]['Param1_T2Pos'] == (99999 || 0) ? 0 : arrHardnessColumnDetail.push({ "Individual": Objindividual });
          arrResOfProductDetail[0][0]['Param3_T2Pos'] == (99999 || 0) ? 0 : arrHardnessColumnDetail.push({ "Thickness": objThickness });
          arrResOfProductDetail[0][0]['Param7_T2Pos'] == (99999 || 0) ? 0 : arrHardnessColumnDetail.push({ "Hardness": objHardness });

          check.columnDetail = arrHardnessColumnDetail;
          // check.testdata = arrHardnessColumnDetail;
          const HardnessInstrumentRes = await objmenu.getDetailOfBulkInstrumentModel(
            ChangeBatch[0].Sys_HardID
          );
          check["hardnessVarient"] = HardnessInstrumentRes.Eqp_Make == 'Pharmatest' ? 1 : 0

          if (ChangeBatch[0].Sys_RptType == 1) { check["hardnessVarient"] = 0 }
          if (check["hardnessVarient"] == 1) {
            check.T2Pos = arrResOfProductDetail[0][0]['Param1_T2Pos'] + " " + unitIndi,
              check.T2Neg = arrResOfProductDetail[0][0]['Param1_T2Neg'] + " " + unitIndi,
              check.pl_mi_limit = pl_mi_limit
            check.Nominal = arrResOfProductDetail[0][0]['Param1_Nom'] + " " + unitIndi,


              arrResOfProductDetail[0][0]["Param1_T2Pos"] == (99999 || 0)
                ? 0
                : arrHardnessColumn.push("Individual")
          }
          check.column = arrHardnessColumn
        }

        // let pendingMessage = sameUserId ? '' : ` for User ${check.Userid}`;

        // check.side = ChangeBatch[0]..Side;

        // var tmppbckupobj = globalData.DoubSide.find((k) => k.Hmi == data.Hmi);
        var response = check;
        var result = await objCommonFunOperation.getCubicalData(data.dsNo);
        result = [result];

        var detailTable = masterTable.replace("master", "detail");
        detailTable = productType == 2 ? detailTable.replace("tab", "cap") : detailTable
        if (strMenuName != 'FRIAB') {
          if (strMenuName == 'Individual') {
            detailTable = productType == 1 ? 'tbl_tab_initialdetail1_incomplete' : 'tbl_cap_initialdetail1_incomplete'
            const HardnessInstrumentRes = await objmenu.getDetailOfBulkInstrumentModel(
              ChangeBatch[0].Sys_HardID
            );
            // check["hardnessVarient"] = HardnessInstrumentRes.Eqp_Make == 'Pharmatest' ? 1 : 0

            response["isFTP"] = HardnessInstrumentRes?.Eqp_Make == 'Pharmatest' ? true : false
            if (ChangeBatch[0].Sys_RptType == 1) { check["hardnessVarient"] = 0 }
            // if (check["hardnessVarient"] == 1) {

            // }
            var limit = await models[masterTable].findOne({
              where: {
                RepSerNo: check.Incomp_RepSerNo
              }
            })
            // var dp = limit.Unit == 'mg' ? 1 : limit.DecimalPoint
            var dp = 3;
            let pl_mi_limit
            limit = productData_
            if (limit['Param1_Nom'] != 99999 && limit['Param1_Nom'] != '') {
              if ((limit['Param1_Nom'] - limit['Param1_T2Neg']).toFixed(3) == (limit['Param1_T2Pos'] - limit['Param1_Nom']).toFixed(3)) {
                pl_mi_limit = "±" + (limit['Param1_Nom'] - limit['Param1_T2Neg']).toFixed(3);
              }
              else {
                pl_mi_limit = '+  ' + (limit['Param1_T2Pos'] - limit['Param1_Nom']).toFixed(3) + ' -' + (limit['Param1_Nom'] - arrResOfProductDetail[0][0]['Param1_T2Neg']).toFixed(3);
              }
            }
            check.T2Pos = limit['Param1_T2Pos'] + " " + limit.Param1_Unit,
              check.T2Neg = limit['Param1_T2Neg'] + " " + limit.Param1_Unit,
              check.pl_mi_limit = pl_mi_limit
            check.Nominal = limit['Param1_Nom'] + " " + limit.Param1_Unit
            if (response["isFTP"] == false) {
              var detailData = await models[detailTable].findAll({
                where: {
                  RepSerNo: check.Incomp_RepSerNo,
                  isCompleted: 0
                },
              });
              var testData = await models[detailTable].findAll({
                attributes: { exclude: ['RecNo', 'RepSerNo', 'MstSerNo', 'UserId', 'UserName', 'PrDate', 'PrTime', 'PrEndDate', 'PrEndTime', 'DecimalPoint', 'Side', 'SideNo',] },
                where: {
                  RepSerNo: check.Incomp_RepSerNo,
                  isCompleted: 0
                }
              })
            }
          }
          else if (strMenuName == GLOBAL_NOMENCLATURE.HardnessMenu) {
            const HardnessInstrumentRes = await objmenu.getDetailOfBulkInstrumentModel(
              ChangeBatch[0].Sys_HardID
            );
            response["isFTP"] = HardnessInstrumentRes.Eqp_Make == 'Pharmatest' ? true : false
            if (response["isFTP"] == false) {
              var limit = await models[masterTable].findOne({
                // attributes: ['T1NegTolHard', 'T1PosTolHard', 'T2NegTolHard', 'T2PosTolHard', 'Unit', 'T1NegTolThick', 'T1PosTolThick', 'T2NegTolHard', 'T2PosTolHard', 'Side'],
                where: {
                  RepSerNo: check.Incomp_RepSerNo
                }
              })
              if (limit != undefined) {
                var detailData = await models.tbl_tab_initialdetailhtd_incomplete.findAll({
                  where: {
                    RepSerNo: check.Incomp_RepSerNo,
                  },
                });
                var testData = await models.tbl_tab_initialdetailhtd_incomplete.findAll({
                  attributes: { exclude: ['RecNo', 'RepSerNo', 'MstSerNo', 'UserId', 'UserName', 'PrDate', 'PrTime', 'PrEndDate', 'PrEndTime', 'DecimalPoint', 'Side', 'SideNo',] },
                  where: {
                    RepSerNo: check.Incomp_RepSerNo,
                    isTerminated: 0
                  }
                })
                var dp = (limit?.Param7_Unit.toLowerCase() == 'kp' && HardnessInstrumentRes.Eqp_Make == "Vankel") ? 1 : 2
                let forMatching = globalData.formatching.find(k => k.DsNo == data.dsNo);
                if (forMatching == undefined) {
                  for (var i = 0; i < testData.length; i++) {
                    if (i == 0) {
                      globalData.formatching.push({
                        DsNo: data.dsNo,
                        values: [testData[i].RecSeqNo]
                      });
                    } else {
                      forMatching = globalData.formatching.find(k => k.DsNo == data.dsNo);
                      forMatching.values.push(testData[i].RecSeqNo)
                    }
                  }
                }
              }
            }
          } else if (strMenuName == GLOBAL_NOMENCLATURE.ThicknessMenu) {
            var limit = await models[masterTable].findOne({
              attributes: ['T2NegTol', 'T2PosTol', 'Unit', 'Side'],
              where: {
                RepSerNo: check.Incomp_RepSerNo
              }
            })
            var detailData = await models[detailTable].findAll({
              where: {
                RepSerNo: check.Incomp_RepSerNo,
              },
            });
            var testData = await models[detailTable].findAll({
              attributes: { exclude: ['RecNo', 'RepSerNo', 'MstSerNo', 'UserId', 'UserName', 'PrDate', 'PrTime', 'PrEndDate', 'PrEndTime', 'DecimalPoint', 'Side', 'SideNo',] },
              where: {
                RepSerNo: check.Incomp_RepSerNo,
              }
            })
            var dp = limit.Unit == 'mm' ? 1 : 0
            let forMatching = globalData.formatching.find(k => k.DsNo == data.dsNo);
            if (forMatching == undefined) {
              for (var i = 0; i < testData.length; i++) {
                if (i == 0) {
                  globalData.formatching.push({
                    DsNo: data.dsNo,
                    values: [testData[i].RecSeqNo]
                  });
                } else {
                  forMatching = globalData.formatching.find(k => k.DsNo == data.dsNo);
                  forMatching.values.push(testData[i].RecSeqNo)
                }
              }
            }
          } else if (strMenuName == GLOBAL_NOMENCLATURE.GroupMenu) {

            detailTable = ChangeBatch[0].Sys_Area == 'Coating' ? 'tbl_tab_detail2_incomplete' : 'tbl_tab_initialdetail2_incomplete'
            detailTable = productType == 2 ? detailTable.replace("tab", "cap") : detailTable

            var limit = await models[masterTable].findOne({
              // attributes: ['T1NegTol', 'T1PosTol', 'T2NegTol', 'T2PosTol', 'Unit', 'Unit', 'Side', 'DecimalPoint'],
              where: {
                RepSerNo: check.Incomp_RepSerNo
              }
            })
            // var dp = limit.Unit == 'mg' ? 1 : limit.DecimalPoint
            var dp = limit?.Param2_DecimalPoint;
            var detailData = await models[detailTable].findAll({
              where: {
                RepSerNo: check.Incomp_RepSerNo,
              },
            });
            var testData = await models[detailTable].findAll({
              // attributes: { exclude: ['RecNo', 'RepSerNo', 'MstSerNo', 'UserId', 'UserName', 'PrDate', 'PrTime', 'PrEndDate', 'PrEndTime', 'DecimalPoint', 'Side', 'SideNo',] },
              where: {
                RepSerNo: check.Incomp_RepSerNo,
              }
            })
            if (ChangeBatch[0].Sys_Area == 'Coating' && check.WeighmentName == 'Group') {
              if (testData[0]['DataValue1']) {
                // let datavalue=testData[0].DataValue1
                testData.push({ ...testData[0] });
                testData[1].DataValue = testData[0].DataValue1;
                testData[1].RecSeqNo = testData[0].RecSeqNo + 1;
              }
              //  else if (testData[0]['DataValue2']) {
              //   let datavalue=testData[0].DataValue2
              //   testData.push(Object.assign({}, testData[0]));
              //   testData[2].DataValue=datavalue;
              // }
            }
          } else if (strMenuName == GLOBAL_NOMENCLATURE.LockedLength) {
            detailTable = productType == 1 ? 'tbl_tab_initialdetail5_incomplete' : 'tbl_cap_initialdetail5_incomplete'
            var limit = await models[masterTable].findOne({
              // attributes: ['CubicalNo' , 'WeighmentType' , 'WeighmentName','ReportType' ,'MPN_Code' , 'isException'],
              where: {
                RepSerNo: check.Incomp_RepSerNo,
              }
            })

            var testData = await models[detailTable].findAll({
              // attributes: { exclude: ['RecNo', 'RepSerNo', 'MstSerNo', 'UserId', 'UserName'] },
              where: {
                RepSerNo: check.Incomp_RepSerNo,
                isCompleted: 0
              }
            })
          } else if (strMenuName == GLOBAL_NOMENCLATURE.Differential) {
            detailTable = productType == 1 ? 'tbl_tab_initialdetail3_incomplete' : 'tbl_cap_initialdetail3_incomplete'
            var limit = await models[masterTable].findOne({
              // attributes: ['CubicalNo' , 'WeighmentType' , 'WeighmentName','ReportType' ,'MPN_Code' , 'isException'],
              where: {
                RepSerNo: check.Incomp_RepSerNo,
              }
            })

            var testData = await models[detailTable].findAll({
              // attributes: { exclude: ['RecNo', 'RepSerNo', 'MstSerNo', 'UserId', 'UserName'] },
              where: {
                RepSerNo: check.Incomp_RepSerNo,
                isCompleted: 0
              }
            })
          } else if (strMenuName == GLOBAL_NOMENCLATURE.DTMenu) {
            detailTable = productType == 1 ? 'tbl_tab_initialdetail13_incomplete' : 'tbl_cap_initialdetail13_incomplete'
            var limit = await models[masterTable].findOne({
              // attributes: ['CubicalNo' , 'WeighmentType' , 'WeighmentName','ReportType' ,'MPN_Code' , 'isException'],
              where: {
                RepSerNo: check.Incomp_RepSerNo,
              }
            })

            var testData = await models[detailTable].findAll({
              // attributes: { exclude: ['RecNo', 'RepSerNo', 'MstSerNo', 'UserId', 'UserName'] },
              where: {
                RepSerNo: check.Incomp_RepSerNo,
              }
            })
          } else if (strMenuName == GLOBAL_NOMENCLATURE.EmptyGroupMenu) {

            detailTable = 'tbl_tab_initialdetail19_incomplete'
            detailTable = productType == 2 ? detailTable.replace("tab", "cap") : detailTable

            var limit = await models[masterTable].findOne({
              // attributes: ['T1NegTol', 'T1PosTol', 'T2NegTol', 'T2PosTol', 'Unit', 'Unit', 'Side', 'DecimalPoint'],
              where: {
                RepSerNo: check.Incomp_RepSerNo
              }
            })
            // var dp = limit.Unit == 'mg' ? 1 : limit.DecimalPoint
            var dp = limit?.Param2_DecimalPoint;
            var detailData = await models[detailTable].findAll({
              where: {
                RepSerNo: check.Incomp_RepSerNo,
              },
            });
            var testData = await models[detailTable].findAll({
              // attributes: { exclude: ['RecNo', 'RepSerNo', 'MstSerNo', 'UserId', 'UserName', 'PrDate', 'PrTime', 'PrEndDate', 'PrEndTime', 'DecimalPoint', 'Side', 'SideNo',] },
              where: {
                RepSerNo: check.Incomp_RepSerNo,
              }
            })

          }

          if (testData != undefined) {
            for (var i = 0; i < testData.length; i++) {
              for (let keys in testData[i]) {
                if (keys.includes(pre_sample)) {
                  if (testData[i][keys] != 0 && testData[i][keys] != 'NULL' && strMenuName == 'Individual') {

                    testData[i].SrNo = i + 1
                    if (testData[i].isException) {
                      var OutOfLimit = true;
                      // testData[i][keys] = { value: testData[i][keys] + ` ${limit.Unit}`, OutOfLimit: OutOfLimit }
                      testData[i][keys] = { value: testData[i][keys] + ` ${testData[i].DataValueUnit}`, OutOfLimit: OutOfLimit }
                    } else {
                      var OutOfLimit = (Number(limit.Param1_T2NegTol) > Number(testData[i][keys]) || Number(testData[i][keys]) > Number(limit.Param1_T2PosTol)) ? true : false
                      testData[i][keys] = { value: Number(testData[i][keys]).toFixed(dp) + ` ${limit.Param1_Unit}`, OutOfLimit: OutOfLimit }
                    }

                  } else if (testData[i][keys] != 0 && testData[i][keys] != 'NULL' && strMenuName == 'Hardness') {
                    if (keys == 'DataValueHard') {
                      if (testData[i][keys] != "NA") {
                        // var OutOfLimit = (Number(limit.Param7_T2NegTol) > Number(testData[i][keys]) || Number(testData[i][keys]) > Number(limit.Param7_T2PosTol)) ? true : false
                        var OutOfLimit = testData[i].isException == 1 ? true : false
                        testData[i].SrNo = i + 1
                        testData[i][keys] = { value: Number(testData[i][keys]).toFixed(dp) + ` ${limit.Param7_Unit}`, OutOfLimit: OutOfLimit }
                      } else {
                        testData[i].SrNo = i + 1
                        testData[i][keys] = { value: testData[i][keys] + ` ${limit.Unit}`, OutOfLimit: false }
                      }
                    } else {
                      if (testData[i][keys] != "NA") {
                        var OutOfLimit = (Number(limit.Param3_T2NegTol) > Number(testData[i][keys]) || Number(testData[i][keys]) > Number(limit.Param3_T2PosTol)) ? true : false
                        testData[i].SrNo = i + 1
                        testData[i][keys] = { value: Number(testData[i][keys]).toFixed(2) + ` mm`, OutOfLimit: OutOfLimit }
                      } else {
                        testData[i].SrNo = i + 1
                        testData[i][keys] = { value: testData[i][keys] + ` mm`, OutOfLimit: false }
                      }
                    }
                  } else if (testData[i][keys] != 0 && testData[i][keys] != 'NULL' && strMenuName == 'Thickness') {
                    if (keys == 'DataValue') {
                      if (testData[i][keys] != "NA") {
                        var OutOfLimit = (Number(limit.Param3_T2NegTol) > Number(testData[i][keys]) || Number(testData[i][keys]) > Number(limit.Param3_T2PosTol)) ? true : false
                        testData[i].SrNo = i + 1
                        testData[i][keys] = { value: Number(testData[i][keys]).toFixed(2) + ` mm`, OutOfLimit: OutOfLimit }
                      } else {
                        testData[i].SrNo = i + 1
                        testData[i][keys] = { value: testData[i][keys] + ` mm`, OutOfLimit: false }
                      }
                    }
                  } else if (testData[i][keys] != 0 && testData[i][keys] != 'NULL' && strMenuName == 'Group') {

                    testData[i].SrNo = i + 1
                    if (testData[i].isException) {
                      var OutOfLimit = true;
                      testData[i][keys] = { value: testData[i][keys] + ` ${limit.Param2_Unit}`, OutOfLimit: OutOfLimit }
                    } else {
                      if (ChangeBatch[0].Sys_Area == 'Coating') {
                        testData[i][keys] = { value: Number(testData[i][keys]).toFixed(testData[i].DP) + ` ${testData[i].DataValueUnit}`, OutOfLimit: OutOfLimit }

                        // testData[i][keys] = { value: Number(testData[i][keys]).toFixed(dp) + ` ${testData[i].DataValueUnit}`, OutOfLimit: OutOfLimit }
                        // if (testData[i]['DataValue1']) {
                        //   testData[i]['DataValue'] = { value1: Number(testData[i]['DataValue1']).toFixed(dp) + ` ${testData[i].DataValueUnit}`, OutOfLimit: OutOfLimit }
                        // } else if (testData[i]['DataValue2']) {
                        //   testData[i]['DataValue'] = { value2: Number(testData[i]['DataValue2']).toFixed(dp) + ` ${testData[i].DataValueUnit}`, OutOfLimit: OutOfLimit }
                        // }
                      } else {
                        var OutOfLimit = (Number(limit.T2NegTol) > Number(testData[i][keys]) || Number(testData[i][keys]) > Number(limit.T2PosTol)) ? true : false
                        testData[i][keys] = { value: Number(testData[i][keys]).toFixed(dp) + ` ${limit.Param2_Unit}`, OutOfLimit: OutOfLimit }
                      }

                    }
                  } else if (testData[i][keys] != 0 && testData[i][keys] != 'NULL' && strMenuName == 'Empty Group') {

                    testData[i].SrNo = i + 1
                    if (testData[i].isException) {
                      var OutOfLimit = true;
                      testData[i][keys] = { value: testData[i][keys] + ` ${limit.Param19_Unit}`, OutOfLimit: OutOfLimit }
                    } else {

                      var OutOfLimit = (Number(limit.T2NegTol) > Number(testData[i][keys]) || Number(testData[i][keys]) > Number(limit.T2PosTol)) ? true : false
                      testData[i][keys] = { value: Number(testData[i][keys]).toFixed(dp) + ` ${limit.Param19_Unit}`, OutOfLimit: OutOfLimit }


                    }
                  } else if (testData[i][keys] != 0 && testData[i][keys] != 'NULL' && strMenuName == 'Disintegration') {

                    if (keys == 'DataValue') {
                      if (testData[i][keys] != "NA") {
                        var OutOfLimit = (testData[i][keys] > limit.Param13_Nom) || (testData[i][keys] < limit.Param13_Nom) ? true : false
                        testData[i].SrNo = i + 1
                        testData[i][keys] = { value: testData[i][keys], OutOfLimit: OutOfLimit }
                      } else {
                        testData[i].SrNo = i + 1
                        testData[i][keys] = { value: testData[i][keys] + ` mm`, OutOfLimit: false }
                      }

                    }

                  } else if (testData[i][keys] != 0 && testData[i][keys] != 'NULL' && strMenuName == 'Locked Length') {

                    testData[i].SrNo = i + 1
                    if (testData[i].isException) {
                      var OutOfLimit = true;
                      // testData[i][keys] = { value: testData[i][keys] + ` ${limit.Unit}`, OutOfLimit: OutOfLimit }
                      testData[i][keys] = { value: testData[i][keys] + ` ${testData[i].DataValueUnit}`, OutOfLimit: OutOfLimit }
                    } else {
                      var OutOfLimit = (Number(limit.Param5_T2NegTol) > Number(testData[i][keys]) || Number(testData[i][keys]) > Number(limit.Param5_T2PosTol)) ? true : false
                      testData[i][keys] = { value: Number(testData[i][keys]) + ` ${limit.Param5_Unit}`, OutOfLimit: OutOfLimit }
                    }

                  } else if (testData[i][keys] != 0 && testData[i][keys] != 'NULL' && strMenuName == 'Differential') {

                    testData[i].SrNo = i + 1
                    if (testData[i].isException) {
                      var OutOfLimit = true;
                      // testData[i][keys] = { value: testData[i][keys] + ` ${limit.Unit}`, OutOfLimit: OutOfLimit }
                      testData[i][keys] = { value: testData[i][keys] + ` ${testData[i].DataValueUnit}`, OutOfLimit: OutOfLimit }
                    } else {
                      var OutOfLimit = (Number(limit.Param5_T2NegTol) > Number(testData[i][keys]) || Number(testData[i][keys]) > Number(limit.Param3_T2PosTol)) ? true : false
                      testData[i][keys] = { value: Number(testData[i][keys]) + ` ${limit.Param3_Unit}`, OutOfLimit: OutOfLimit }
                    }

                  } else {
                    delete testData[i][keys]
                  }
                }
              }
            }

            globalData.arrHardnessMT50.findIndex(k => k.DsNo == data.dsNo && k.TabIp == data.tabIp) == -1 ? globalData.arrHardnessMT50 : globalData.arrHardnessMT50.splice(globalData.arrHardnessMT50.findIndex(k => k.DsNo == data.dsNo && k.TabIp == data.tabIp), 1);
            globalData.arrHardnessMT50.push({
              DsNo: data.dsNo,
              TabIp: data.tabIp,
              obj: testData[0]
            })
          }
          console.log(testData)
        } else {
          let InitialWt = 'InitialWt'
          let FinalWt = 'FinalWt'
          response.WeighmentName = GLOBAL_NOMENCLATURE.Friability
          if (ChangeBatch[0].Sys_RptType != undefined) {
            masterTable = 'tbl_tab_initialmaster_incomplete';
            detailTable = 'tbl_tab_initialdetail8_incomplete';
            InitialWt = 'BeforeValue'
            FinalWt = 'AfterValue'

            let currentTime = new Date(date.format(new Date(), 'YYYY-MM-DD HH:mm:ss'))
            if (currentTime < check.EntryTimeStamp) {
              var timecount = maths.round((check.EntryTimeStamp - currentTime) / (1000 * 60), 2).toFixed(0)
              response.PendingFriability = true;
            } else {
              //  timeFlag = 0
              response.PendingFriability = false;
            }

            response.message = `Operation pending for ${GLOBAL_NOMENCLATURE.Friability}`
          }
          var limit = await models[masterTable].findOne({
            where: {
              RepSerNo: check.Incomp_RepSerNo
            }
          })

          let detailData = await models[detailTable].findAll({
            where: {
              RepSerNo: check.Incomp_RepSerNo
            }
          })


          var testData = detailData[detailData.length - 1]
          var friabDetail = detailData
          // var testData = detailData.pop()
          for (var i = 0; i < testData.length; i++) {
            for (let keys in testData[i]) {
              if (keys.includes('FriabVal')) {
                if (testData[i][keys] != 0 && testData[i][keys] != 'NULL' && strMenuName == 'Friab') {
                  testData[i].SrNo = i + 1
                  testData[i][keys] = { value: Number(testData[i][keys]).toFixed(dp) + ` ${limit.Unit}`, OutOfLimit: OutOfLimit }
                }
              } else if (keys.includes(InitialWt)) {
                testData[i][keys] = { value: testData[i][keys] }
              } else if (keys.includes(FinalWt)) {
                if (check.After_Count > 0) {
                  testData[i][keys] = { value: testData[i][keys] }
                }
              }
            }
          }

          if (response.PendingFriability) testData.TimeoutTime = timecount
        }
        response.testData = testData

        response.Side = limit?.Side
        var tmpmonitobj = globalData.monitDetail.find((k) => k.DsNo == data.dsNo && k.TabIp == data.tabIp);
        // if(strMenuName == 'FRIAB'){
        //   check.Range =  "NMT 1 %"
        // }
        if (tmpmonitobj == undefined) {
          globalData.monitDetail.push({
            DsNo: data.dsNo,
            TabIp: data.tabIp,
            data: detailData,
          });
        } else {
          var index = globalData.monitDetail.findIndex((k) => k.DsNo == data.dsNo && k.TabIp == data.tabIp);
          globalData.monitDetail[index].data = detailData;
        }

        const obj = {
          dsNo: data.dsNo,
          tabIp: data.tabIp,
          userId: data.userId,
          UserName: "",
        };
        const obj1 = {
          dsNo: data.dsNo,
          tabIp: data.tabIp,
          menuName: strMenuName == 'FRIAB' ? GLOBAL_NOMENCLATURE.Friability : strMenuName,
        };

        //internalyy calling
        await objmenu.sendMenu(obj);
        var MenuDetail = await objmenu.onMenuStart(obj1);
        response.MenuDetail = MenuDetail;
        if (testData != undefined) {
          if (response.testData.length != 0) {
            response.ispowerbackupdata = true;
          } else {
            response.ispowerbackupdata = false;
          }
        } else {
          response.ispowerbackupdata = false;
        }

        response.Range = response.MenuDetail.result.Range;
        if (response.WeighmentName == "Disintegration") {
          response.WeighmentName = "Disintegration Test";
        }
        if (response.WeighmentName == GLOBAL_NOMENCLATURE.Friability) {
          if (friabDetail[friabDetail.length - 1].Remark != 'NA' && friabDetail[friabDetail.length - 1].Remark != null && friabDetail[friabDetail.length - 1].isException == 1) {
            response.isException = 0;
          }
        } else {
          if (testData[testData.length - 1]?.Remark != 'NA' && testData[testData.length - 1]?.Remark != null) {
            response.isException = 0;
          }
        }

      } else {
        var response = "VALIDATED";
      }
      // if (check != undefined) {
      //   if (check.WeighmentName == "FRIAB") {
      //     response = "VALIDATED";
      //   }
      // }



      return response;
    } catch (error) {
      console.log(error)
    }
  }
  // async chkPowerBackupPresent(data) {
  //   var objuser = await models["tbl_users"].findAll({
  //     where: {
  //       UserID: data.userId
  //     }
  //   });
  //   objuser = objuser[0];
  //   var _calib_entry = await models["tbl_powerbackup"].findAll({
  //     where: {
  //       IdsNo: data.Hmi,
  //     },
  //   });
  //   var ChangeBatch = await models.tbl_cubical.findAll({
  //     where: {
  //       Sys_IDSNo: data.Hmi,
  //     },
  //   });

  //   if (_calib_entry.length != 0) {
  //     if (_calib_entry[0].WeighmentType == "Calib") {
  //     }
  //   } else {
  //     var response = "VALIDATED";
  //   }
  //   if (ChangeBatch[0].Sys_cubTypes != "IPQA") {
  //     var ExistingBatch = await models["tbl_powerbackup"].findAll({
  //       where: {
  //         IdsNo: data.Hmi,
  //       },
  //     });
  //     if (ExistingBatch.length != 0) {
  //       if (ChangeBatch[0].Sys_Batch != ExistingBatch[0].Sys_Batch) {  //Different Batch 
  //         var check = await models.tbl_powerbackup.destroy({
  //           where: {
  //             idsNo: data.Hmi,
  //           },
  //         });
  //       }
  //     }
  //     var Checkchangerpttype = await models["tbl_powerbackup"].findAll({
  //       where: {
  //         // Userid: data.userId,
  //         idsNo: data.Hmi,
  //       },
  //     });

  //     if (Checkchangerpttype.length != 0) {
  //       if (Checkchangerpttype[0].ReportType != ChangeBatch[0].Sys_RptType) {
  //         var Checkchangerpttype = await models["tbl_powerbackup"].destroy({
  //           where: {
  //             // Userid: data.userId,
  //             idsNo: data.Hmi,
  //             ReportType: Checkchangerpttype[0].ReportType,
  //           },
  //         });
  //         console.log(data.Hmi, "Report Type Change");
  //       }
  //     }
  //   }

  //   var check = await models["tbl_powerbackup"].findAll({
  //     where: {
  //       // Userid: data.userId,
  //       idsNo: data.Hmi,
  //       // ReportType: ChangeBatch[0].Sys_RptType
  //     },
  //   });
  //   check = check[0];

  //   if (check != undefined && check != null && check.length != 0) {
  //     var strMenuName = check.WeighmentName;
  //     var masterTable = "";
  //     var detailTable = "";
  //     switch (strMenuName) {
  //       case `${GLOBAL_NOMENCLATURE.IndividualMenu}`:
  //         if (check.ProductType == 2) {
  //           masterTable = "tbl_cap_master1_incomplete";
  //         } else {
  //           masterTable = "tbl_tab_master1_incomplete";
  //         }
  //         break;
  //       case GLOBAL_NOMENCLATURE.Hardness:
  //         masterTable = "tbl_tab_master_htd_incomplete";
  //         break;
  //     }
  //     // var prodmaster = await models[masterTable].findOne({ //commented 20/01/23
  //     //   where: {
  //     //     RepSerNo: check.Incomp_RepSerNo,
  //     //   },
  //     // });

  //     var weightmentName = "";
  //     var pre_sample = "";
  //     switch (check.WeighmentName) {
  //       case `${GLOBAL_NOMENCLATURE.IndividualMenu}`:
  //         weightmentName = "Individual";
  //         pre_sample = "DataValue";
  //         break;
  //       // case GLOBAL_NOMENCLATURE.GroupIndividual:
  //       //   weightmentName = GLOBAL_NOMENCLATURE.GroupIndividual;
  //       //   break;
  //       case GLOBAL_NOMENCLATURE.Hardness:
  //         weightmentName = "Hardness";
  //         pre_sample = "DataValue";
  //         break;
  //       default:
  //         weightmentName = check.WeighmentName.toUpperCase();
  //     }

  //     //if not same user then give msg to discard / logout or normal pending msg
  //     //  let sameUserId = true
  //     //  let otherUser = false
  //     if (check.Userid != data.userId) {
  //       //discard tht old user test

  //       await models.tbl_powerbackup.destroy({
  //         where: {
  //           idsNo: data.Hmi,
  //           Userid: check.Userid,
  //         },
  //       });
  //       if (check.WeighmentName == GLOBAL_NOMENCLATURE.IndividualMenu) {
  //         let objSelMenu = globalData.arrSelectedMenu.find(
  //           (k) => k.Hmi == data.Hmi
  //         );
  //         if (objSelMenu.selectedProductDetail.isonstd.data[0] == 1) {
  //           var masterTable = 'tbl_tab_master1';
  //           var detailTable = 'tbl_tab_detail1';
  //           // strincomplete =  'tbl_tab_master1_incomplete'
  //           var detail_tableName = detailTable.concat("_incomplete");
  //           var master_tableName = masterTable.concat("_incomplete");
  //           var get_Datavalue = await models[detail_tableName].findAll({ where: { RepSerNo: check.Incomp_RepSerNo, } })
  //           var get_Datavalue1 = await models[master_tableName].findAll({ where: { RepSerNo: check.Incomp_RepSerNo, } })

  //           objSelMenu.selectedProductDetail.nominal = get_Datavalue1[0].AvgValue;

  //           var Nominal = objSelMenu.selectedProductDetail.nominal;
  //           Nominal = Number(Nominal).toFixed(2);

  //           var typeValue = 1;
  //           var maxLimitT1 = objformulaFun.upperLimit(objSelMenu.selectedProductDetail, 'T1');
  //           var maxLimitT2 = objformulaFun.upperLimit(objSelMenu.selectedProductDetail, 'T2');
  //           var minLimitT2 = objformulaFun.lowerLimit(objSelMenu.selectedProductDetail, 'T2');
  //           var minLimitT1 = objformulaFun.lowerLimit(objSelMenu.selectedProductDetail, 'T1');

  //           var DataValue_arr = [];

  //           get_Datavalue1[0].NoOfBelowT1 = 0;
  //           get_Datavalue1[0].NoOfAboveT1 = 0;
  //           get_Datavalue1[0].NoOfBelowT2 = 0;
  //           get_Datavalue1[0].NoOfAboveT2 = 0;

  //           DataValue_arr.push(get_Datavalue);
  //           var arr = [];
  //           for (var i = 0; i < get_Datavalue.length; i++) {
  //             var a = get_Datavalue[i].DataValue;

  //             if (Number(a) < Number(minLimitT2)) {
  //               get_Datavalue1[0].NoOfBelowT2 = Number(get_Datavalue1[0].NoOfBelowT2) + 1;
  //             } else if (Number(a) > Number(maxLimitT2)) {
  //               get_Datavalue1[0].NoOfAboveT2 = Number(get_Datavalue1[0].NoOfAboveT2) + 1;
  //             }
  //             if (maxLimitT1 != 0 && minLimitT1 != 0) {
  //               if (Number(a) < Number(minLimitT1) && Number(a) >= Number(minLimitT2)) {
  //                 get_Datavalue1[0].NoOfBelowT1 = Number(get_Datavalue1[0].NoOfBelowT1) + 1;
  //               } else if (Number(a) > Number(maxLimitT1) && Number(a) <= Number(maxLimitT2)) {
  //                 get_Datavalue1[0].NoOfAboveT1 = Number(get_Datavalue1[0].NoOfAboveT1) + 1;
  //               }
  //             }

  //             arr.push(Number(a));
  //             console.log(arr);
  //             var max_value = maths.max(arr);
  //             max_value = max_value.toFixed(1);
  //             var min_value = maths.min(arr);
  //             min_value = min_value.toFixed(1);
  //             var std_value = maths.std(arr);
  //             std_value = std_value.toFixed(2);
  //             var total = arr.reduce((acc, total) => {
  //               return Number(total) + Number(acc);
  //             }, 0)
  //             var avg = total / arr.length
  //             avg = maths.abs(avg).toFixed(1);
  //             var minPer_value = ((Nominal - min_value) / Nominal) * 100;
  //             minPer_value = maths.abs(minPer_value).toFixed(2)
  //             var maxPer_value = ((max_value - Nominal) / Nominal) * 100;
  //             maxPer_value = maths.abs(maxPer_value).toFixed(2)

  //             // console.log();
  //             console.log(max_value, min_value, std_value, avg, minPer_value, maxPer_value);
  //             // return arr;

  //             var get_Datavalue11 = await models[master_tableName].update({
  //               AvgValue: avg,
  //               MinValue: min_value,
  //               MaxValue: max_value,
  //               // StdDev: std_value,
  //               MinPer: minPer_value,
  //               MaxPer: maxPer_value,
  //               NoOfAboveT1: get_Datavalue1[0].NoOfAboveT1,
  //               NoOfAboveT2: get_Datavalue1[0].NoOfAboveT2,
  //               NoOfBelowT1: get_Datavalue1[0].NoOfBelowT1,
  //               NoOfBelowT2: get_Datavalue1[0].NoOfBelowT2,
  //               T1NegTol: Number(minLimitT1).toFixed(1),
  //               T1PosTol: Number(maxLimitT1).toFixed(1),
  //               T2NegTol: Number(minLimitT2).toFixed(1),
  //               T2PosTol: Number(maxLimitT2).toFixed(1),
  //             }, { where: { RepSerNo: check.Incomp_RepSerNo } });
  //           }
  //         }
  //         await models.tbl_tab_master1_incomplete.update(
  //           {
  //             IsProcess: 0,
  //             PrEndDate: momentObj().format("YYYY-MM-DD"),
  //             PrEndTime: momentObj().format("HH:mm:ss"),
  //             FailedRemarkI: "Aborted test"
  //           }, {
  //           where: {
  //             RepSerNo: check.Incomp_RepSerNo,
  //           }
  //         }
  //         );
  //         var hmiDetails = await models.tbl_tab_master1_incomplete.findAll({
  //           where: {
  //             RepSerNo: check.Incomp_RepSerNo,
  //           }
  //         })
  //         hmiDetails = hmiDetails[0]
  //         var act = `${weightmentName} Test Discarded on TSH ${data.Hmi} of user ${check.Userid}`
  //         if (hmiDetails.Side != 'NA') {
  //           var act = `${weightmentName} Test Discarded on TSH ${data.Hmi} of user ${check.Userid} for side ${hmiDetails.Side}`
  //         }
  //       } else if (check.WeighmentName == GLOBAL_NOMENCLATURE.Hardness) {
  //         await models.tbl_tab_master_htd_incomplete.update(
  //           {
  //             IsProcess: 0,
  //             PrEndDate: momentObj().format("YYYY-MM-DD"),
  //             PrEndTime: momentObj().format("HH:mm:ss"),
  //             FailedRemarkI: "Aborted test"
  //           }, {
  //           where: {
  //             RepSerNo: check.Incomp_RepSerNo,
  //           }
  //         }
  //         );
  //         var hmiDetails = await models.tbl_tab_master_htd_incomplete.findAll({
  //           where: {
  //             RepSerNo: check.Incomp_RepSerNo,
  //           }
  //         })
  //         hmiDetails = hmiDetails[0]
  //         var act = `${weightmentName}/Thickness Test Discarded on TSH ${data.Hmi} of user ${check.Userid}`
  //         if (hmiDetails.Side != 'NA') {
  //           var act = `${weightmentName}/Thickness Test Discarded on TSH ${data.Hmi} of user ${check.Userid} for side ${hmiDetails.Side}`
  //         }

  //       }

  //       await objActivityLog.ActivityLogEntry({
  //         strUserId: data.userId,
  //         strUserName: objuser.UserInitials,
  //         activity: act,
  //       });
  //       var Hmi = data.Hmi;
  //       globalData.arrWeighmentCounter.findIndex(k => k.Hmi === Hmi) == -1 ?
  //         globalData.arrWeighmentCounter :
  //         globalData.arrWeighmentCounter.splice(globalData.arrWeighmentCounter.findIndex(k => k.Hmi == Hmi), 1);

  //       (globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === Hmi)) == -1 ?
  //         globalData.arrCurrentOperationStatus :
  //         globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === Hmi), 1);

  //       (globalData.arrWeighmentCounterAfter.findIndex((element) => element.Hmi === Hmi)) == -1 ?
  //         globalData.arrWeighmentCounterAfter :
  //         globalData.arrWeighmentCounterAfter.splice(globalData.arrWeighmentCounterAfter.findIndex((element) => element.Hmi === Hmi), 1);

  //       (globalData.arrProtocolData.findIndex((element) => element.Hmi === Hmi)) == -1 ?
  //         globalData.arrProtocolData :
  //         globalData.arrProtocolData.splice(globalData.arrProtocolData.findIndex((element) => element.Hmi === Hmi), 1);

  //       (globalData.arrOutFlagForTest.findIndex((element) => element.Hmi === Hmi)) == -1 ?
  //         globalData.arrOutFlagForTest :
  //         globalData.arrOutFlagForTest.splice(globalData.arrOutFlagForTest.findIndex((element) => element.Hmi === Hmi), 1);

  //       globalData.arrSelectedMenu.findIndex(k => k.Hmi == Hmi) == -1 ?
  //         globalData.arrSelectedMenu :
  //         globalData.arrSelectedMenu.splice(globalData.arrSelectedMenu.findIndex(k => k.Hmi == Hmi), 1);

  //       (globalData.HardnessMasterEntry.findIndex((element) => element.Hmi === Hmi)) == -1 ?
  //         globalData.HardnessMasterEntry :
  //         globalData.HardnessMasterEntry.splice(globalData.HardnessMasterEntry.findIndex((element) => element.Hmi === Hmi), 1);

  //       (globalData.DoubSide.findIndex((element) => element.Hmi === Hmi)) == -1 ?
  //         globalData.DoubSide :
  //         globalData.DoubSide.splice(globalData.DoubSide.findIndex((element) => element.Hmi === Hmi), 1);

  //       (globalData.arrside.findIndex((element) => element.Hmi === Hmi)) == -1 ?
  //         globalData.arrside :
  //         globalData.arrside.splice(globalData.arrside.findIndex((element) => element.Hmi === Hmi), 1);

  //       globalData.arrPushValuesOfHardness.findIndex(k => k.Hmi == Hmi) == -1 ?
  //         globalData.arrPushValuesOfHardness :
  //         globalData.arrPushValuesOfHardness.splice(globalData.arrPushValuesOfHardness.findIndex(k => k.Hmi == Hmi), 1);

  //       globalData.arrsampleno.findIndex(k => k.Hmi == Hmi) == -1 ?
  //         globalData.arrsampleno :
  //         globalData.arrsampleno.splice(globalData.arrsampleno.findIndex(k => k.Hmi == Hmi), 1);

  //       globalData.arrHardnessMT50.findIndex(k => k.Hmi == Hmi) == -1 ?
  //         globalData.arrHardnessMT50 :
  //         globalData.arrHardnessMT50.splice(globalData.arrHardnessMT50.findIndex(k => k.Hmi == Hmi), 1);

  //       globalData.formatching.findIndex(k => k.Hmi == Hmi) == -1 ?
  //         globalData.formatching :
  //         globalData.formatching.splice(globalData.formatching.findIndex(k => k.Hmi == Hmi), 1);

  //       return "VALIDATED";
  //       // sameUserId = false
  //       // otherUser = true
  //     } else {
  //       if (weightmentName == 'Hardness') {
  //         weightmentName = weightmentName + '/Thickness'
  //       }
  //       check.message = GLOBAL_NOMENCLATURE.powerBackupMessage + weightmentName;
  //     }

  //     if (strMenuName == "TBTTST") {
  //       const selectProductMaster = await models.tbl_product_master.findAll({
  //         where: {
  //           ProductName: prodmaster.ProductName,
  //           ProductId: prodmaster.BFGCode,
  //           ProductVersion: prodmaster.PVersion,
  //           Version: prodmaster.Version,
  //         },
  //       });
  //       let arrResProductMaster = [selectProductMaster];
  //       let productType = arrResProductMaster[0][0].ProductType;
  //       let TableName;
  //       let tableName;
  //       let col;
  //       var arrHardnessColumn = [];
  //       if (productType == 1) {
  //         switch (ChangeBatch[0].Sys_CubType) {
  //           case "Compression":
  //           case "Effervescent Compression":
  //           case "IPQC":
  //           case "IPQA":
  //             tableName = "tbl_product_tablet";
  //             TableName = models.tbl_product_tablet;
  //             break;
  //           case "Coating":
  //           case "Pallet Coating":
  //             tableName = "tbl_product_tablet_coated";
  //             TableName = models.tbl_product_tablet_coated;
  //             break;
  //           case "Effervescent Granulation":
  //           case "Granulation":
  //             tableName = "tbl_product_gran";
  //             TableName = models.tbl_product_gran;
  //             break;
  //         }
  //       } else if (productType == 2 && cubicalArea == "Capsule Filling") {
  //         tableName = "tbl_product_capsule";
  //         TableName = models.tbl_product_capsule;
  //       } else if (productType == 2 && cubicalArea == "Granulation") {
  //         tableName = "tbl_product_gran_cap";
  //         TableName = models.tbl_product_gran_cap;
  //       } else if (productType == 2 && cubicalArea == "Pallet Coating") {
  //         tableName = "tbl_product_capsule";
  //         TableName = models.tbl_product_capsule;
  //       } else if (productType == 3 && cubicalArea == "Multihaler") {
  //         tableName = "tbl_product_multihaler";
  //         TableName = models.tbl_product_multihaler;
  //       } else {
  //         console.log("jncjsnc");
  //       }
  //       const selectObj = await models[tableName].findAll({
  //         where: {
  //           ProductName: prodmaster.ProductName,
  //           ProductId: prodmaster.BFGCode,
  //           ProductVersion: prodmaster.PVersion,
  //           Version: prodmaster.Version,
  //         },
  //       });

  //       let arrResOfProductDetail = [[selectObj[0]]];
  //       arrResOfProductDetail[0][0]["Param3_Nom"] == (99999 || 0)
  //         ? 0
  //         : arrHardnessColumn.push("Thickness");
  //       arrResOfProductDetail[0][0]["Param4_Nom"] == (99999 || 0)
  //         ? 0
  //         : arrHardnessColumn.push("Breadth");
  //       arrResOfProductDetail[0][0]["Param5_Nom"] == (99999 || 0)
  //         ? 0
  //         : arrHardnessColumn.push("Length");
  //       arrResOfProductDetail[0][0]["Param6_Nom"] == (99999 || 0)
  //         ? 0
  //         : arrHardnessColumn.push("Diameter");
  //       arrResOfProductDetail[0][0]["Param7_T1Pos"] == (99999 || 0)
  //         ? 0
  //         : arrHardnessColumn.push("Hardness");

  //       check.tbt = arrHardnessColumn;
  //     }

  //     // let pendingMessage = sameUserId ? '' : ` for User ${check.Userid}`;

  //     // check.side = prodmaster.Side;

  //     var tmppbckupobj = globalData.DoubSide.find((k) => k.Hmi == data.Hmi);
  //     var response = check;
  //     var result = await objCommonFunOperation.getCubicalData(data.Hmi);
  //     result = [result];

  //     var detailTable = masterTable.replace("master", "detail");
  //     if (strMenuName != 'FRIAB') {
  //       if (strMenuName == 'Individual') {
  //         var limit = await models[masterTable].findOne({
  //           attributes: ['T1NegTol', 'T1PosTol', 'T2NegTol', 'T2PosTol', 'Unit', 'DP', 'Side'],
  //           where: {
  //             RepSerNo: check.Incomp_RepSerNo
  //           }
  //         })
  //         var dp = limit.Unit == 'mg' ? 1 : limit.DP
  //         var detailData = await models[detailTable].findAll({
  //           where: {
  //             RepSerNo: check.Incomp_RepSerNo,
  //           },
  //         });
  //         var testData = await models[detailTable].findAll({
  //           attributes: { exclude: ['RecNo', 'RepSerNo', 'MstSerNo', 'UserId', 'UserName', 'PrDate', 'PrTime', 'PrEndDate', 'PrEndTime', 'DecimalPoint', 'Side', 'SideNo'] },
  //           where: {
  //             RepSerNo: check.Incomp_RepSerNo,
  //           }
  //         })
  //       } else {
  //         var limit = await models[masterTable].findOne({
  //           attributes: ['T1NegTolHard', 'T1PosTolHard', 'T2NegTolHard', 'T2PosTolHard', 'Unit', 'T1NegTolThick', 'T1PosTolThick', 'Side'],
  //           where: {
  //             RepSerNo: check.Incomp_RepSerNo
  //           }
  //         })
  //         var detailData = await models.tbl_tab_detailhtd_incomplete.findAll({
  //           where: {
  //             RepSerNo: check.Incomp_RepSerNo,
  //           },
  //         });
  //         var testData = await models.tbl_tab_detailhtd_incomplete.findAll({
  //           attributes: { exclude: ['RecNo', 'RepSerNo', 'MstSerNo', 'UserId', 'UserName', 'PrDate', 'PrTime', 'PrEndDate', 'PrEndTime', 'DecimalPoint', 'Side', 'SideNo'] },
  //           where: {
  //             RepSerNo: check.Incomp_RepSerNo,
  //           }
  //         })
  //         var dp = limit.Unit == 'Kp' ? 1 : 0
  //         let forMatching = globalData.formatching.find(k => k.Hmi == data.Hmi);
  //         if (forMatching == undefined) {
  //           for (var i = 0; i < testData.length; i++) {
  //             if (i == 0) {
  //               globalData.formatching.push({
  //                 Hmi: data.Hmi,
  //                 values: [testData[i].RecSeqNo]
  //               });
  //             } else {
  //               forMatching = globalData.formatching.find(k => k.Hmi == data.Hmi);
  //               forMatching.values.push(testData[i].RecSeqNo)
  //             }
  //           }
  //         }
  //       }

  //       for (var i = 0; i < testData.length; i++) {
  //         for (let keys in testData[i]) {
  //           if (keys.includes(pre_sample)) {
  //             if (testData[i][keys] != 0 && testData[i][keys] != 'NULL' && strMenuName == 'Individual') {
  //               var OutOfLimit = (Number(limit.T2NegTol) > Number(testData[i][keys]) || Number(testData[i][keys]) > Number(limit.T2PosTol)) ? true : false
  //               testData[i].SrNo = i + 1
  //               testData[i][keys] = { value: Number(testData[i][keys]).toFixed(dp) + ` ${limit.Unit}`, OutOfLimit: OutOfLimit }
  //             } else if (testData[i][keys] != 0 && testData[i][keys] != 'NULL' && strMenuName == 'Hardness') {
  //               if (keys == 'DataValueHard') {
  //                 if (testData[i][keys] != "NA") {
  //                   var OutOfLimit = (Number(limit.T2NegTolHard) > Number(testData[i][keys]) || Number(testData[i][keys]) > Number(limit.T2PosTolHard)) ? true : false
  //                   testData[i].SrNo = i + 1
  //                   testData[i][keys] = { value: Number(testData[i][keys]).toFixed(dp) + ` ${limit.Unit}`, OutOfLimit: OutOfLimit }
  //                 } else {
  //                   testData[i].SrNo = i + 1
  //                   testData[i][keys] = { value: testData[i][keys] + ` ${limit.Unit}`, OutOfLimit: false }
  //                 }
  //               } else {
  //                 if (testData[i][keys] != "NA") {
  //                   var OutOfLimit = (Number(limit.T2NegTolThick) > Number(testData[i][keys]) || Number(testData[i][keys]) > Number(limit.T2PosTolThick)) ? true : false
  //                   testData[i].SrNo = i + 1
  //                   testData[i][keys] = { value: Number(testData[i][keys]).toFixed(2) + ` mm`, OutOfLimit: OutOfLimit }
  //                 } else {
  //                   testData[i].SrNo = i + 1
  //                   testData[i][keys] = { value: testData[i][keys] + ` mm`, OutOfLimit: false }
  //                 }
  //               }
  //             } else {
  //               delete testData[i][keys]
  //             }
  //           }
  //         }
  //       }
  //       globalData.arrHardnessMT50.findIndex(k => k.Hmi == data.Hmi) == -1 ? globalData.arrHardnessMT50 : globalData.arrHardnessMT50.splice(globalData.arrHardnessMT50.findIndex(k => k.Hmi == data.Hmi), 1);
  //       globalData.arrHardnessMT50.push({
  //         Hmi: data.Hmi,
  //         obj: testData[0]
  //       })
  //       console.log(testData)
  //     }
  //     response.testData = testData
  //     response.Side = limit.Side
  //     var tmpmonitobj = globalData.monitDetail.find((k) => k.Hmi == data.Hmi);

  //     if (tmpmonitobj == undefined) {
  //       globalData.monitDetail.push({
  //         Hmi: data.Hmi,
  //         data: detailData,
  //       });
  //     } else {
  //       var index = globalData.monitDetail.findIndex((k) => k.Hmi == data.Hmi);
  //       globalData.monitDetail[index].data = detailData;
  //     }

  //     const obj = {
  //       Hmi: data.Hmi,
  //       UserId: data.userId,
  //       UserName: "",
  //     };
  //     const obj1 = {
  //       Hmi: data.Hmi,
  //       menuName: strMenuName,
  //     };

  //     //internalyy calling
  //     await objmenu.getMenu(obj);
  //     var MenuDetail = await objmenu.onMenuStart(obj1);
  //     response.MenuDetail = MenuDetail;
  //   } else {
  //     var response = "VALIDATED";
  //   }
  //   // if (check != undefined) {
  //   //   if (check.WeighmentName == "FRIAB") {
  //   //     response = "VALIDATED";
  //   //   }
  //   // }

  //   return response;
  // }
  async _Calib_powerBackup(_value) { }
  async get_Calib_Status_oF_Test_ForPowerBackup(powerbackupobj) {
    let strHmi = powerbackupobj.Hmi;
    let strIdsNo = powerbackupobj.TabIp;
    let tableName = "tbl_powerbackup";
    let tempUserObject = globalData.arrUsers.find((k) => k.Hmi == strHmi && TabIp == TabIp);

    let _check_combination = await this._check_calibration_entry(
      strHmi,
      strIdsNo,
      powerbackupobj,
      tableName
    );

    if (_check_combination === undefined) {
      const _insertInPoerBackup = await models["tbl_powerbackup"].create({
        WeighmentName: powerbackupobj.menuName,
        WeighmentType: "Calib",
        DsNo: strHmi,
        TabIp: powerbackupobj.TabIp,
        Userid: powerbackupobj.Userid,
        RecSampleNo: powerbackupobj.RecSampleNo,
        EntryTimeStamp: moment().format('YYYY-MM-DD HH:mm:ss'),
        Instrument_Model: powerbackupobj._bal_id,
      });

      let res = [_insertInPoerBackup];
      return res[0][0];
    } else {
      // if (powerbackupobj.RecSampleNo == 1) {
      //   await models[tableName].update({
      //     // Incomp_RepSerNo: powerbackupobj.Incomp_RepSerNo,
      //     RecSampleNo: powerbackupobj.RecSampleNo
      //   }, {
      //     where: {
      //       Instrument_Model : powerbackupobj._bal_id,
      //       IdsNo:strHmi
      //     },
      //   });
      // }

      this._update_Calib_Test_Count(
        strHmi,
        strIdsNo,
        powerbackupobj,
        powerbackupobj.RecSampleNo,
        tableName
      );
      _check_combination = await this._check_calibration_entry(
        strHmi,
        strIdsNo,
        powerbackupobj,
        tableName
      );
      return _check_combination.RecSampleNo;
    }
  }
  async _check_calibration_entry(strDsNo, strTabIp, _value1, _table_) {
    const _check_combination = await models[_table_].findAll({
      where: {
        WeighmentName: _value1.menuName,
        DsNo: strDsNo,
        TabIp: strTabIp
      },
    });
    return [_check_combination][0][0];
  }

  async _update_Calib_Test_Count(_hmi, TabIp, powerbackupobj, _Sample_No, tableName) {
    // console.log(`updateTestCount:${JSON.stringify(powerbackupobj)}`)
    let _check_combination = await this._check_calibration_entry(
      _hmi,
      TabIp,
      powerbackupobj,
      "tbl_powerbackup"
    );
    if (_check_combination !== undefined) {
      let _check_update_combination = await models.tbl_powerbackup.update(
        {
          RecSampleNo: _Sample_No,
        },
        {
          where: {
            WeighmentName: powerbackupobj.menuName,
            DsNo: _hmi,
          },
        }
      );
      //   console.log(`powerbackup ${powerbackupobj.Incomp_RepSerNo}`);
      //return powerbackupobj.Incomp_RepSerNo;
    } else {
      console.log("not found Incomp_RepSerNo");
    }
  }
  async _get_calib_data(value, powerBackupData, userObj, cubicalData) {
    try {

      var strHmi = value.dsNo;

      var tabIp = value.tabIp;

      var menuName = powerBackupData.WeighmentName

      var repNo = powerBackupData.Incomp_RepSerNo;

      var balId = powerBackupData.Instrument_Model;

      menuName = menuName == GLOBAL_NOMENCLATURE.Periodic ? 'periodic' : menuName

      if (menuName == "Accuracy") {
        menuName = "periodic"
      }
      var table_name = menuName == 'Uncertainty' ? 'uncertinity' : menuName

      var inCompDetail = `tbl_calibration_${table_name.toLowerCase()}_detail_incomplete`

      // if (menuName == "periodic") {
      //   menuName = "Accuracy"
      // }
      // if (powerBackupData.Userid != userObj.userId || balId != cubicalData.Sys_BalID) {

      //     if (menuName != GLOBAL_NOMENCLATURE.Daily) await objCalbCommon.caibrationFails(table_name[0], repNo, balId, table_name)

      //     if (menuName == GLOBAL_NOMENCLATURE.Uncertainty) {

      //         await models.tbl_calibration_periodic_master_incomplete.destroy({
      //             where: {
      //                 periodic_RepNo: repNo
      //             }
      //         })

      //         await models.tbl_calibration_periodic_detail_incomplete.destroy({
      //             where: {
      //                 periodic_RepNo: repNo
      //             }
      //         })

      //         await models.tbl_calibration_status.update({
      //             P: 0,
      //             U: 0,
      //         }, {
      //             where: {
      //                 BalID: balId
      //             }
      //         });

      //     }

      //     await models.tbl_powerbackup.destroy({
      //         where: {
      //             IdsNo: strHmi,
      //         }
      //     })

      //     await models.tbl_activity_log.create({
      //         dt: objMoment().format('YYYY-MM-DD'),
      //         tm: objMoment().format('HH:mm:ss'),
      //         userid: userObj.userId,
      //         username: userObj.userName,
      //         activity: `${menuName} Calibration Discarded on TSH ${strHmi} of user ${powerBackupData.Userid}`
      //     })

      //     console.log(`${menuName} Calibration Discarded on TSH ${strHmi}, PowerBackup Api Called`)

      //     return {
      //         status: 'success',
      //         isIncomplete: false
      //     }

      // }

      var balance = await models.tbl_balance.findOne({
        attributes: ['Bal_Unit', 'Bal_DP'],
        where: {
          Bal_ID: balId
        }
      })

      var Bal_Unit = balance.Bal_Unit

      if (Bal_Unit == 'gm') Bal_Unit = 'g'

      var Bal_Dp = 3
      if (menuName == 'Eccentricity') {
        menuName = "Eccent"
        table_name = "Eccent"
      }
      if (menuName == 'Repeatability') {
        menuName = "Repet"
        table_name = "Repet"
        inCompDetail = 'tbl_calibration_repetability_detail_incomplete'
      }
      if (menuName != 'Uncertainty') {

        var calibData = await models[inCompDetail].findAll({
          attributes: { exclude: [`${menuName}_RepNo`, `${menuName}_StdWtBoxID`, `${menuName}_StdWt`, `${menuName}_WtIdentification`, `${menuName}_WeightBox_certfctNo`, 'PercentofCapacity', 'Decimal_Point', `${menuName}_ValDate`, `${menuName}_CertDate`] },
          where: {
            [`${table_name}_RepNo`]: repNo
          },
          order: [[`${menuName}_RecNo`, 'ASC']]
        })
      } else {
        menuName = 'uncertinity'
        var calibData = await models[inCompDetail].findAll({
          attributes: { exclude: [`${menuName}_RepNo`, `${menuName}_StdWtID`, `${menuName}_StdWt`, `${menuName}_WtIdentification`, `${menuName}_WeightBox_certfctNo`, 'PercentofCapacity', 'Uncertinity_DP', `${menuName}_ValDate`] },
          where: {
            [`${menuName}_RepNo`]: repNo
          },
          order: [[`${menuName}_RecNo`, 'ASC']]
        })
        menuName = 'Uncertainty'
      }

      var obj = {}
      var arr_sampleData = []

      if (menuName == 'DAILY') {

        let i = 1;
        for (let keys in calibData[0]) {

          if (Number(calibData[0][`Daily_ActualWt${i}`]) == 0) break;

          obj.SrNo = i
          obj.StdWt = Number(calibData[0][`Daily_BalStdWt${i}`]).toFixed(Bal_Dp) + ' ' + 'g'
          obj.NegTol = Number(calibData[0][`Daily_BalNegTol${i}`]).toFixed(Bal_Dp) + ' ' + 'g'
          obj.PosTol = Number(calibData[0][`Daily_BalPosTol${i}`]).toFixed(Bal_Dp) + ' ' + 'g'
          obj.ActualWt = Number(calibData[0][`Daily_ActualWt${i}`]).toFixed(Bal_Dp) + ' ' + 'g'

          arr_sampleData.push(obj)

          obj = {}

          i++

        }

      } else {

        for (let i in calibData) {

          if (table_name == "periodic") {
            table_name = "Periodic"
          }
          if (table_name == "uncertinity") {
            table_name = "Uncertinity"
          }

          obj.SrNo = Number(i) + 1
          obj.StdWt = Number(calibData[i][`${table_name}_BalStdWt`]).toFixed(Bal_Dp) + ' ' + 'g'
          obj.NegTol = Number(calibData[i][`${table_name}_BalNegTol`]).toFixed(Bal_Dp) + ' ' + 'g'
          obj.PosTol = Number(calibData[i][`${table_name}_BalPosTol`]).toFixed(Bal_Dp) + ' ' + 'g'
          obj.ActualWt = Number(calibData[i][`${table_name}_ActualWt`]).toFixed(Bal_Dp) + ' ' + 'g'

          arr_sampleData.push(obj)

          obj = {}
        }

      }
      if (menuName == "Eccent") {
        menuName = "Eccentricity"

      }
      if (menuName == "Repet") {
        menuName = "Repeatability"

      }

      var obj = {
        status: 'success',
        pendingCalibData: arr_sampleData,
        WeighmentName: menuName,
        isIncomplete: true,
        instrumentId: balId,
        CalibType: menuName,
        WeighmentType: powerBackupData.WeighmentType
      }

      const responses = await axios.post(
        `http://${serverConfig.hostApi}:${serverConfig.port}/INTERFACE/CalibrationStatus/getAllBalListOfConnectedResbPie`,
        {
          dsNo: strHmi,
          tabIp: tabIp,
          UserId: value.userId,
        }
      )

      // if (!responses.data.status || !responses.data.ValidCalibration) return responses.

      obj.message = GLOBAL_NOMENCLATURE.powerBackupMessage_calib + menuName + ' ' + 'Calibration';
      obj.isException = 0
      obj.ispowerbackupdata = true
      return obj

    } catch (error) {
      console.log(error)
    }

  }
  async moveCalibrationIncompleteToFail(dsNo) {
    try {
      //check bal connected..//take balid//fetch status
      //reset calib

      let strTableName, repNo, strColName, calibAlphabet, calibType;
      let strBalId, pendingMessage;
      const pendingCalib = globalData.glbArrListOfBalWithCalibPending.find(
        (k) => k.DsNo == dsNo
      );

      if (pendingCalib == undefined) {
        return;
      }

      strBalId = pendingCalib.PendingCalibStatus[0].BalId;
      pendingMessage = pendingCalib.PendingCalibStatus[0].Message;
      pendingMessage = pendingMessage.split(" ")[0];
      if (pendingMessage.includes("No")) {
        return;
      }

      // const calibTypeArr = globalData.arrcalibType.find(k => k.Hmi == strHmi);
      // const selectedBal = globalData.arrSelectedBalWithHmi.find(k => k.Hmi == strHmi);

      // if (selectedBal != undefined) {
      //     var strBalId = selectedBal.selectedBal;
      // }

      // if (selectedBal == undefined) {

      //     console.log("return from moveCalibrationIncompleteToFail");
      //     return
      // }
      //get repNo from status table;
      let statusResp = await models.tbl_calibration_status.findOne({
        where: {
          BalID: strBalId,
        },
      });

      let calibrepNo = statusResp.RepNo;

      let calibCounter = globalData.arrCalibCounterApi.find(
        (k) => k.Hmi == strHmi
      );

      // if (calibCounter != undefined) {
      //     if (calibTypeArr != undefined) {
      // switch (calibTypeArr.calibType) {
      switch (pendingMessage.toLowerCase()) {
        case GLOBAL_NOMENCLATURE.Periodic.toLowerCase():
          calibAlphabet = "P";
          // var bln_isPresent = await objCommonCalib.checkIfRecordInIncomplete(calibAlphabet, strBalId)
          strTableName = "tbl_calibration_periodic_master_incomplete";
          repNo = "Periodic_RepNo";
          strColName = "Periodic_BalID";
          calibType = "Monthly";
          break;
        case GLOBAL_NOMENCLATURE.Eccentricity.toLowerCase():
          calibAlphabet = "E";
          // var bln_isPresent = await objCommonCalib.checkIfRecordInIncomplete(calibAlphabet, strBalId)
          strTableName = "tbl_calibration_eccentricity_master_incomplete";
          repNo = "Eccent_RepNo";
          strColName = "Eccent_BalID";
          calibType = "Monthly";
          break;
        case GLOBAL_NOMENCLATURE.Uncertainty.toLowerCase():
          calibAlphabet = "U";
          // var bln_isPresent = await objCommonCalib.checkIfRecordInIncomplete(calibAlphabet, strBalId)
          strTableName = "tbl_calibration_uncertinity_master_incomplete";
          repNo = "Uncertinity_RepNo";
          strColName = "Uncertinity_BalID";
          calibType = "Yearly";
          break;
        case GLOBAL_NOMENCLATURE.Repetability.toLowerCase():
          calibAlphabet = "R";
          // var bln_isPresent = await objCommonCalib.checkIfRecordInIncomplete(calibAlphabet, strBalId)
          strTableName = "tbl_calibration_repetability_master_incomplete";
          repNo = "Repet_RepNo";
          strColName = "Repet_BalID";
          calibType = "Monthly";
          break;
        case "Linearity".toLowerCase():
          calibAlphabet = "L";
          // var bln_isPresent = await objCommonCalib.checkIfRecordInIncomplete(calibAlphabet, strBalId)
          strTableName = "tbl_calibration_linearity_master_incomplete";
          repNo = "linear_RepNo";
          strColName = "linear_BalID";
          calibType = "Yearly";
          break;
        default:
          return;
      }
      // if (calibCounter.counterApi != 0) {
      await this.caibrationFails(
        calibAlphabet,
        calibrepNo,
        strBalId,
        calibType,
        true
      );
      // }

      //     }
      // }
    } catch (error) {
      console.log(error);
      throw new Error(error);
    }
  }

  async caibrationFails(CalibrationType, RepNo, strBalId, calibType, deleteEntry = false) {
    try {
      // CalibrationType is like 'P', 'R', 'E', 'U'..etc
      // strBalId holds the balance associated with that cubicle
      // RepNo holds the report sr no of incomplete tables
      var tempCaibStatus = globalData.calibrationStatus.find(k => k.BalId == strBalId);
      // getting position of current caibration in sorted array of calibrations
      let sortedArray = await sort.sortedSeqArray(globalData.arrSortedCalib, strBalId); //globalData.arrSortedCalib tbl_calibration_sequnce
      var int_curentCalibrationIndex = sortedArray.indexOf(CalibrationType);
      // calculating first caalibration
      // var str_first_calibration = sortedArray[0];
      //var str_first_calibration = CalibrationType;
      if (calibType == "Yearly") {
        var str_first_calibration = "P"
      } else if (calibType == "Monthly") {
        var str_first_calibration = "P"
      }
      var fRerSrNo = await this.getFrepSrNo(str_first_calibration);
      // fRerSrNo is failed repSrNo which will insert in all failed tables
      var arr_CalibArray = []; // array holds calibration which done and one which failed
      for (let i = 0; i < int_curentCalibrationIndex + 1; i++) {
        arr_CalibArray.push(sortedArray[i])
      }
      // console.log('arr_CalibArray', arr_CalibArray);

      // v holds value such as 'P', 'U', 'E' .....etc

      switch (calibType) {
        case 'Monthly': {
          {
            var objPeriodic = await copyObjects.periodic('tbl_calibration_periodic_master_incomplete'
              , 'tbl_calibration_periodic_master_failed', RepNo, 0, 'master')
            // Copying Incomplete master to failed master

            let columNames = objPeriodic.data.map(obj => obj.str_colName).toString();
            var str_Query = `insert into tbl_calibration_periodic_master_failed (${columNames}) select ${columNames} from tbl_calibration_periodic_master_incomplete where Periodic_RepNo = ${RepNo}`
            let resultPeriodic = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

            // last inserted Id got here form querymasterInsert[0]
            var lastInsertedIdPeriodic = resultPeriodic[0];
            // Updating the report serial number in failed master
            if (lastInsertedIdPeriodic != 0) {

              await models.tbl_calibration_periodic_master_failed.update({
                "Periodic_RepNo": fRerSrNo,
                "Periodic_CalbTime": moment(new Date()).format('HH:mm:ss')
              }, {
                where: {
                  "srNo": lastInsertedIdPeriodic
                }
              })


              // selecting data from incomplete details for copying
              var resultP = await models.tbl_calibration_periodic_detail_incomplete.findAll({
                where: {
                  "Periodic_RepNo": RepNo
                }
              }); // selected
              let res = [{}]
              res[0].Periodic_RepNo = resultP[0].Periodic_RepNo
              res[0].Periodic_RecNo = resultP[0].Periodic_RecNo
              let i = 0;
              for (let obj of resultP) {
                obj.Periodic_RecNo = resultP[i].Periodic_RecNo
                // as we have multiple entries i n details table so we need 
                // Async loop



                let objCopyPeriodic = await copyObjects.periodic('tbl_calibration_periodic_detail_incomplete'
                  , 'tbl_calibration_periodic_detail_failed', obj.Periodic_RepNo, obj.Periodic_RecNo, 'detail');

                columNames = objCopyPeriodic.data.map(obj => obj.str_colName).toString();
                str_Query = `insert into tbl_calibration_periodic_detail_failed (${columNames}) select ${columNames} from tbl_calibration_periodic_detail_incomplete where Periodic_RepNo = ${obj.Periodic_RepNo} AND Periodic_RecNo = ${obj.Periodic_RecNo}`
                let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

                var lastInsertedIdP = detailInsert[0];


                await models.tbl_calibration_periodic_detail_failed.update({
                  "Periodic_RepNo": fRerSrNo
                }, {
                  where: {
                    "srNo": lastInsertedIdP
                    // "Periodic_RepNo": res[0].Periodic_RepNo
                  }
                })

                // updated repSrNo in failed details 
                // console.log('P Copy')
                // If ongoing calibration is failed ('Periodic') then only we have to delete
                // records from incomplete tables for new entries

                i++;
              }

              if (tempCaibStatus.status['P'].readIntLE() == 0) {
                await models.tbl_calibration_periodic_master_incomplete.destroy({
                  where: {
                    "Periodic_RepNo": RepNo
                  }
                })
                await models.tbl_calibration_periodic_detail_incomplete.destroy({
                  where: {
                    "Periodic_RepNo": RepNo
                  }
                })
              }
            }
          }

          {
            var objEccen = await copyObjects.eccentricity('tbl_calibration_eccentricity_master_incomplete'
              , 'tbl_calibration_eccentricity_master_failed', RepNo, 0, 'master');
            // console.log(obj)
            let columNames = objEccen.data.map(obj => obj.str_colName).toString();
            var str_Query = `insert into tbl_calibration_eccentricity_master_failed (${columNames}) select ${columNames} from tbl_calibration_eccentricity_master_incomplete where Eccent_RepNo = ${RepNo}`
            let resultEccen = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
            // console.log(result)
            var lastInsertedIdEccen = resultEccen[0];

            if (lastInsertedIdEccen != 0) {
              await models.tbl_calibration_eccentricity_master_failed.update({
                "Eccent_RepNo": fRerSrNo,
                "Eccent_CalbTime": moment(new Date()).format('HH:mm:ss')
              }, {
                where: {
                  "srNo": lastInsertedIdEccen
                }
              })

              var resultP = await models.tbl_calibration_eccentricity_detail_incomplete.findAll({
                where: {
                  "Eccent_RepNo": RepNo
                }
              }); // selected
              let res = [{}]
              res[0].Eccent_RepNo = resultP[0].Eccent_RepNo
              res[0].Eccent_RecNo = resultP[0].Eccent_RecNo
              // console.log(result[0])
              let i = 0;
              for (let obj of resultP) {
                obj.Eccent_RecNo = resultP[i].Eccent_RecNo
                let objCopyEccen = await copyObjects.eccentricity('tbl_calibration_eccentricity_detail_incomplete'
                  , 'tbl_calibration_eccentricity_detail_failed', obj.Eccent_RepNo, obj.Eccent_RecNo, 'detail');
                columNames = objCopyEccen.data.map(obj => obj.str_colName).toString();
                str_Query = `insert into tbl_calibration_eccentricity_detail_failed (${columNames}) select ${columNames} from tbl_calibration_eccentricity_detail_incomplete where Eccent_RepNo = ${obj.Eccent_RepNo} AND Eccent_RecNo = ${obj.Eccent_RecNo}`
                let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

                var lastInsertedIdU = detailInsert[0];

                await models.tbl_calibration_eccentricity_detail_failed.update({
                  "Eccent_RepNo": fRerSrNo,
                  "Eccent_CalbTime": moment(new Date()).format('HH:mm:ss')
                }, {
                  where: {
                    "srNo": lastInsertedIdU
                    // "Eccent_RepNo":  res[0].Eccent_RepNo
                  }
                })
                i++

              }

              if (tempCaibStatus.status['E'].readIntLE() == 0) {
                await models.tbl_calibration_eccentricity_master_incomplete.destroy({
                  where: {
                    "Eccent_RepNo": RepNo
                  }
                });
                await models.tbl_calibration_eccentricity_detail_incomplete.destroy({
                  where: {
                    "Eccent_RepNo": RepNo
                  }
                });
              }


            }


          }
          {
            var objReap = await copyObjects.repetability('tbl_calibration_repetability_master_incomplete'
              , 'tbl_calibration_repetability_master_failed', RepNo, 0, 'master');
            // Copying Incomplete master to failed master
            let columNames = objReap.data.map(obj => obj.str_colName).toString();
            var str_Query = `insert into tbl_calibration_repetability_master_failed (${columNames}) select ${columNames} from tbl_calibration_repetability_master_incomplete where Repet_RepNo = ${RepNo}`
            let resultReap = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
            // last inserted Id got here form query
            var lastInsertedIdReap = resultReap[0];
            // Updating the report serial number in failed master
            if (lastInsertedIdReap != 0) {
              await models.tbl_calibration_repetability_master_failed.update({
                "Repet_RepNo": fRerSrNo,
                "Repet_CalbTime": moment(new Date()).format('HH:mm:ss')
              }, {
                where: {
                  "srNo": lastInsertedIdReap
                }
              }) // failed master report number updated
              // selecting data from incomplete details for copying

              var resultP = await models.tbl_calibration_repetability_detail_incomplete.findAll({
                where: {
                  "Repet_RepNo": RepNo
                }
              }); // selected
              let res = [{}]
              res[0].Repet_RepNo = resultP[0].Repet_RepNo
              res[0].Repet_RecNo = resultP[0].Repet_RecNo
              // as we have multiple entries i n details table so we need 
              // Async loop
              let i = 0;
              for (let obj of resultP) {
                obj.Repet_RecNo = resultP[i].Repet_RecNo
                let objCopyReap = await copyObjects.repetability('tbl_calibration_repetability_detail_incomplete'
                  , 'tbl_calibration_repetability_detail_failed', obj.Repet_RepNo, obj.Repet_RecNo, 'detail');

                columNames = objCopyReap.data.map(obj => obj.str_colName).toString();
                str_Query = `insert into tbl_calibration_repetability_detail_failed (${columNames}) select ${columNames} from tbl_calibration_repetability_detail_incomplete where Repet_RecNo = ${obj.Repet_RecNo} AND Repet_RecNo = ${obj.Repet_RecNo}`
                let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

                var lastInsertedIdU = detailInsert[0];

                await models.tbl_calibration_repetability_detail_failed.update({
                  "Repet_RepNo": fRerSrNo
                }, {
                  where: {
                    "srNo": lastInsertedIdU
                    // "Repet_RepNo": res[0].Repet_RepNo
                  }
                });
                i++;
              }
              if (tempCaibStatus.status['R'].readIntLE() == 0) {
                await models.tbl_calibration_repetability_master_incomplete.destroy({
                  where: {
                    "Repet_RepNo": RepNo
                  }
                });
                await models.tbl_calibration_repetability_detail_incomplete.destroy({
                  where: {
                    "Repet_RepNo": RepNo
                  }
                });
              }
            }
          }

          if (deleteEntry) {

            await models.tbl_calibration_periodic_master_incomplete.destroy({
              where: {
                "Periodic_RepNo": RepNo
              }
            });
            await models.tbl_calibration_periodic_detail_incomplete.destroy({
              where: {
                "Periodic_RepNo": RepNo
              }
            });

            await models.tbl_calibration_eccentricity_master_incomplete.destroy({
              where: {
                "Eccent_RepNo": RepNo
              }
            });
            await models.tbl_calibration_eccentricity_detail_incomplete.destroy({
              where: {
                "Eccent_RepNo": RepNo
              }
            });

            await models.tbl_calibration_repetability_master_incomplete.destroy({
              where: {
                "Repet_RepNo": RepNo
              }
            });
            await models.tbl_calibration_repetability_detail_incomplete.destroy({
              where: {
                "Repet_RepNo": RepNo
              }
            });

            let arrselectBalData = await models.tbl_balance.findOne({
              where: {
                'Bal_ID': strBalId
              }
            });
            arrselectBalData = [[arrselectBalData]]



            const bln_storeType = arrselectBalData[0][0].Bal_CalbStoreType.readUIntLE()
            // if (bln_storeType == 1) {
            //     // await models.tbl_calibration_status.update({
            //     //     // 'P': 0,
            //     //     // // 'E': 0,
            //     //     // 'R': 0,
            //     //     // 'U': 0,
            //     //     // 'L': 0
            //     // }, {
            //     //     where: {
            //     //         'BalID': strBalId
            //     //     }
            //     // });
            // } else {
            await models.tbl_calibration_status.update({
              'P': 0,
              'E': 0,
              'R': 0,

              // 'U': 0,
              // 'L': 0
            }, {
              where: {
                'BalID': strBalId
              }
            });
          }
          // }



        }
          break;
        case 'Yearly': {
          // First copying data
          {
            var objUnccen = await copyObjects.uncertinity('tbl_calibration_uncertinity_master_incomplete'
              , 'tbl_calibration_uncertinity_master_failed', RepNo, 0, 'master');
            // console.log(obj)
            let columNames = objUnccen.data.map(obj => obj.str_colName).toString();
            var str_Query = `insert into tbl_calibration_uncertinity_master_failed (${columNames}) select ${columNames} from tbl_calibration_uncertinity_master_incomplete where Uncertinity_RepNo = ${RepNo}`
            let resultUnccen = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
            // console.log(result)
            var lastInsertedIdUnccen = resultUnccen[0];
            if (lastInsertedIdUnccen != 0) {
              await models.tbl_calibration_uncertinity_master_failed.update({
                "Uncertinity_RepNo": fRerSrNo,
                "Uncertinity_CalbTime": moment(new Date()).format('HH:mm:ss')
              }, {
                where: {
                  "srNo": lastInsertedIdUnccen
                }
              })
              var selectDetailObjUnccen = {
                str_tableName: 'tbl_calibration_uncertinity_detail_incomplete',
                data: 'Uncertinity_RepNo,Uncertinity_RecNo',
                condition: [
                  { str_colName: 'Uncertinity_RepNo', value: RepNo, comp: 'eq' }
                ]
              }
              var resultU = await models.tbl_calibration_uncertinity_detail_incomplete.findAll({
                where: {
                  "Uncertinity_RepNo": RepNo
                }
              }); // selected
              let res = [{}]
              res[0].Uncertinity_RepNo = resultU[0].Uncertinity_RepNo
              res[0].Uncertinity_RecNo = resultU[0].Uncertinity_RecNo
              // console.log(result[0])
              let i = 0;
              for (let obj of resultU) {
                obj.Uncertinity_RecNo = resultU[i].Uncertinity_RecNo
                let objCopyUnccen = await copyObjects.uncertinity('tbl_calibration_uncertinity_detail_incomplete', 'tbl_calibration_uncertinity_detail_failed', obj.Uncertinity_RepNo, obj.Uncertinity_RecNo, 'detail');
                columNames = objCopyUnccen.data.map(obj => obj.str_colName).toString();
                str_Query = `insert into tbl_calibration_uncertinity_detail_failed (${columNames}) select ${columNames} from tbl_calibration_uncertinity_detail_incomplete where Uncertinity_RepNo = ${obj.Uncertinity_RepNo} AND Uncertinity_RecNo = ${obj.Uncertinity_RecNo}`
                let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

                var lastInsertedIdU = detailInsert[0];

                await models.tbl_calibration_uncertinity_detail_failed.update({
                  "Uncertinity_RepNo": fRerSrNo
                }, {
                  where: {
                    "srNo": lastInsertedIdU
                    // "Uncertinity_RepNo": obj.Uncertinity_RepNo
                  }
                })
                i++
              }
              if (tempCaibStatus.status['U'].readIntLE() == 0) {
                await models.tbl_calibration_uncertinity_master_incomplete.destroy({
                  where: {
                    "Uncertinity_RepNo": RepNo
                  }
                });
                await models.tbl_calibration_uncertinity_detail_incomplete.destroy({
                  where: {
                    "Uncertinity_RepNo": RepNo
                  }
                });
              }

            }


          }

          // {
          //     var objEccen = await copyObjects.eccentricity('tbl_calibration_eccentricity_master_incomplete'
          //         , 'tbl_calibration_eccentricity_master_failed', RepNo, 0, 'master');
          //     // console.log(obj)
          //     let columNames = objEccen.data.map(obj => obj.str_colName).toString();
          //     var str_Query = `insert into tbl_calibration_eccentricity_master_failed (${columNames}) select ${columNames} from tbl_calibration_eccentricity_master_incomplete where Eccent_RepNo = ${RepNo}`
          //     let resultEccen = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
          //     // console.log(result)
          //     var lastInsertedIdEccen = resultEccen[0];

          //     if (lastInsertedIdEccen != 0) {
          //         await models.tbl_calibration_eccentricity_master_failed.update({
          //             "Eccent_RepNo": fRerSrNo,
          //             "Eccent_CalbTime": moment(new Date()).format('HH:mm:ss')
          //         }, {
          //             where: {
          //                 "srNo": lastInsertedIdEccen
          //             }
          //         })

          //         var resultP = await models.tbl_calibration_eccentricity_detail_incomplete.findAll({
          //             where: {
          //                 "Eccent_RepNo": RepNo
          //             }
          //         }); // selected
          //         let res = [{}]
          //         res[0].Eccent_RepNo = resultP[0].Eccent_RepNo
          //         res[0].Eccent_RecNo = resultP[0].Eccent_RecNo
          //         // console.log(result[0])
          //         let i = 0;
          //         for (let obj of resultP) {
          //             obj.Eccent_RecNo = resultP[i].Eccent_RecNo
          //             let objCopyEccen = await copyObjects.eccentricity('tbl_calibration_eccentricity_detail_incomplete'
          //                 , 'tbl_calibration_eccentricity_detail_failed', obj.Eccent_RepNo, obj.Eccent_RecNo, 'detail');
          //             columNames = objCopyEccen.data.map(obj => obj.str_colName).toString();
          //             str_Query = `insert into tbl_calibration_eccentricity_detail_failed (${columNames}) select ${columNames} from tbl_calibration_eccentricity_detail_incomplete where Eccent_RepNo = ${obj.Eccent_RepNo} AND Eccent_RecNo = ${obj.Eccent_RecNo}`
          //             let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

          //             var lastInsertedIdU = detailInsert[0];

          //             await models.tbl_calibration_eccentricity_detail_failed.update({
          //                 "Eccent_RepNo": fRerSrNo,
          //                 "Eccent_CalbTime": moment(new Date()).format('HH:mm:ss')
          //             }, {
          //                 where: {
          //                     "srNo": lastInsertedIdU
          //                     // "Eccent_RepNo":  res[0].Eccent_RepNo
          //                 }
          //             })
          //             i++

          //         }

          //         if (tempCaibStatus.status['E'].readIntLE() == 0) {
          //             await models.tbl_calibration_eccentricity_master_incomplete.destroy({
          //                 where: {
          //                     "Eccent_RepNo": RepNo
          //                 }
          //             });
          //             await models.tbl_calibration_eccentricity_detail_incomplete.destroy({
          //                 where: {
          //                     "Eccent_RepNo": RepNo
          //                 }
          //             });
          //         }


          //     }


          // }
          {
            var objLinear = await copyObjects.linearity('tbl_calibration_linearity_master_incomplete'
              , 'tbl_calibration_linearity_master_failed', RepNo, 0, 'master');
            // Copying Incomplete master to failed master
            let columNames = objLinear.data.map(obj => obj.str_colName).toString();
            var str_Query = `insert into tbl_calibration_linearity_master_failed (${columNames}) select ${columNames} from tbl_calibration_linearity_master_incomplete where Linear_RepNo = ${RepNo}`
            let resultLinear = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
            // last inserted Id got here form query
            var lastInsertedIdLinear = resultLinear[0];
            // Updating the report serial number in failed master

            if (lastInsertedIdLinear != 0) {

              await models.tbl_calibration_linearity_master_failed.update({
                "Linear_RepNo": fRerSrNo,
                "Linear_CalbTime": moment(new Date()).format('HH:mm:ss')
              }, {
                where: {
                  "srNo": lastInsertedIdLinear
                }
              }) // failed master report number updated
              // selecting data from incomplete details for copying

              var resultP = await models.tbl_calibration_linearity_detail_incomplete.findAll({
                where: {
                  "Linear_RepNo": RepNo
                }
              }); // selected
              let res = [{}]
              res[0].Linear_RepNo = resultP[0].Linear_RepNo
              res[0].Linear_RecNo = resultP[0].Linear_RecNo
              // as we have multiple entries i n details table so we need 
              // Async loop
              let i = 0;
              for (let obj of resultP) {
                obj.Linear_RecNo = resultP[i].Linear_RecNo
                let objCopyLinear = await copyObjects.linearity('tbl_calibration_linearity_detail_incomplete'
                  , 'tbl_calibration_linearity_detail_failed', obj.Linear_RepNo, obj.Linear_RecNo, 'detail');

                columNames = objCopyLinear.data.map(obj => obj.str_colName).toString();
                str_Query = `insert into tbl_calibration_linearity_detail_failed (${columNames}) select ${columNames} from tbl_calibration_linearity_detail_incomplete where Linear_RepNo = ${obj.Linear_RepNo} AND Linear_RecNo = ${obj.Linear_RecNo}`
                let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

                var lastInsertedIdU = detailInsert[0];

                await models.tbl_calibration_linearity_detail_failed.update({
                  "Linear_RepNo": fRerSrNo
                }, {
                  where: {
                    "srNo": lastInsertedIdU
                    // "Linear_RepNo": res[0].Linear_RepNo
                  }
                })
                i++;
              }

              if (tempCaibStatus.status['L'].readIntLE() == 0) {
                await models.tbl_calibration_linearity_master_incomplete.destroy({
                  where: {
                    "Linear_RepNo": RepNo
                  }
                })
                await models.tbl_calibration_linearity_detail_incomplete.destroy({
                  where: {
                    "Linear_RepNo": RepNo
                  }
                })
              }

            }
          }

          if (deleteEntry) {
            await models.tbl_calibration_uncertinity_master_incomplete.destroy({
              where: {
                "Uncertinity_RepNo": RepNo
              }
            });
            await models.tbl_calibration_uncertinity_detail_incomplete.destroy({
              where: {
                "Uncertinity_RepNo": RepNo
              }
            });

            // await models.tbl_calibration_eccentricity_master_incomplete.destroy({
            //     where: {
            //         "Eccent_RepNo": RepNo
            //     }
            // });
            // await models.tbl_calibration_eccentricity_detail_incomplete.destroy({
            //     where: {
            //         "Eccent_RepNo": RepNo
            //     }
            // });

            await models.tbl_calibration_linearity_master_incomplete.destroy({
              where: {
                "Linear_RepNo": RepNo
              }
            });
            await models.tbl_calibration_linearity_detail_incomplete.destroy({
              where: {
                "Linear_RepNo": RepNo
              }
            });

            let arrselectBalData = await models.tbl_balance.findOne({
              where: {
                'Bal_ID': strBalId
              }
            });
            arrselectBalData = [[arrselectBalData]]



            const bln_storeType = arrselectBalData[0][0].Bal_CalbStoreType.readUIntLE()
            // if (bln_storeType == 1) {
            await models.tbl_calibration_status.update({

              // 'E': 0,

              'U': 0,
              'L': 0
            }, {
              where: {
                'BalID': strBalId
              }
            })
            // } else {
            //     await models.tbl_calibration_status.update({

            //         'E': 0,

            //         'U': 0,
            //         'L': 0
            //     }, {
            //         where: {
            //             'BalID': strBalId
            //         }
            //     })
            // }



          }

        }
      }


      // switch (CalibrationType) {
      //     // For case PERIODIC CALIBRATION
      //     case 'P': {
      //         var objPeriodic = await copyObjects.periodic('tbl_calibration_periodic_master_incomplete'
      //             , 'tbl_calibration_periodic_master_failed', RepNo, 0, 'master')
      //         // Copying Incomplete master to failed master

      //         let columNames = objPeriodic.data.map(obj => obj.str_colName).toString();
      //         var str_Query = `insert into tbl_calibration_periodic_master_failed (${columNames}) select ${columNames} from tbl_calibration_periodic_master_incomplete where Periodic_RepNo = ${RepNo}`
      //         let resultPeriodic = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

      //         // last inserted Id got here form querymasterInsert[0]
      //         var lastInsertedIdPeriodic = resultPeriodic[0];
      //         // Updating the report serial number in failed master

      //         await models.tbl_calibration_periodic_master_failed.update({
      //             "Periodic_RepNo": fRerSrNo,
      //             "Periodic_EndTime": moment(new Date()).format('HH:mm:ss')
      //         }, {
      //             where: {
      //                 "srNo": lastInsertedIdPeriodic
      //             }
      //         })


      //         // selecting data from incomplete details for copying
      //         var resultP = await models.tbl_calibration_periodic_detail_incomplete.findAll({
      //             where: {
      //                 "Periodic_RepNo": RepNo
      //             }
      //         }); // selected
      //         let res = [{}]
      //         res[0].Periodic_RepNo = resultP[0].Periodic_RepNo
      //         res[0].Periodic_RecNo = resultP[0].Periodic_RecNo
      //         let i = 0;
      //         for (let obj of resultP) {
      //             obj.Periodic_RecNo = resultP[i].Periodic_RecNo
      //             // as we have multiple entries i n details table so we need 
      //             // Async loop



      //             let objCopyPeriodic = await copyObjects.periodic('tbl_calibration_periodic_detail_incomplete'
      //                 , 'tbl_calibration_periodic_detail_failed', obj.Periodic_RepNo, obj.Periodic_RecNo, 'detail');

      //             columNames = objCopyPeriodic.data.map(obj => obj.str_colName).toString();
      //             str_Query = `insert into tbl_calibration_periodic_detail_failed (${columNames}) select ${columNames} from tbl_calibration_periodic_detail_incomplete where Periodic_RepNo = ${obj.Periodic_RepNo} AND Periodic_RecNo = ${obj.Periodic_RecNo}`
      //             let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

      //             var lastInsertedIdP = detailInsert[0];


      //             await models.tbl_calibration_periodic_detail_failed.update({
      //                 "Periodic_RepNo": fRerSrNo
      //             }, {
      //                 where: {
      //                     "srNo": lastInsertedIdP
      //                     // "Periodic_RepNo": res[0].Periodic_RepNo
      //                 }
      //             })

      //             // updated repSrNo in failed details 
      //             // console.log('P Copy')
      //             // If ongoing calibration is failed ('Periodic') then only we have to delete
      //             // records from incomplete tables for new entries

      //             i++;
      //         }
      //         // for (let obj of res) {
      //         //     obj.Periodic_RecNo = resultU[i].Periodic_RecNo
      //         //     // as we have multiple entries i n details table so we need 
      //         //     // Async loop



      //         //     let objCopyPeriodic = await copyObjects.periodic('tbl_calibration_periodic_detail_incomplete'
      //         //         , 'tbl_calibration_periodic_detail_failed', obj.Periodic_RepNo, obj.Periodic_RecNo, 'detail');

      //         //     columNames = objCopyPeriodic.data.map(obj => obj.str_colName).toString();
      //         //     str_Query = `insert into tbl_calibration_periodic_detail_failed (${columNames}) select ${columNames} from tbl_calibration_periodic_detail_incomplete where Periodic_RepNo = ${obj.Periodic_RepNo}`
      //         //     let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

      //         //     var lastInsertedIdP = detailInsert[0];


      //         //     await models.tbl_calibration_periodic_detail_failed.update({
      //         //         "Periodic_RepNo": fRerSrNo
      //         //     }, {
      //         //         where: {
      //         //             // "srNo": lastInsertedIdP
      //         //             "Periodic_RepNo": res[0].Periodic_RepNo
      //         //         }
      //         //     })

      //         //     // updated repSrNo in failed details 
      //         //     // console.log('P Copy')
      //         //     // If ongoing calibration is failed ('Periodic') then only we have to delete
      //         //     // records from incomplete tables for new entries

      //         // i++;
      //         // }

      //         if (sortedArray.indexOf('P') == int_curentCalibrationIndex) {
      //             // delete records from incomplete tables

      //             await models.tbl_calibration_periodic_master_incomplete.destroy({
      //                 where: {
      //                     "Periodic_RepNo": RepNo
      //                 }
      //             })
      //             await models.tbl_calibration_periodic_detail_incomplete.destroy({
      //                 where: {
      //                     "Periodic_RepNo": RepNo
      //                 }
      //             })


      //         }
      //     }
      //         break;
      //     // For case UNCERTINITY CALIBRATION
      //     case 'U': {
      //         // First copying data
      //         var objUnccen = await copyObjects.uncertinity('tbl_calibration_uncertinity_master_incomplete'
      //             , 'tbl_calibration_uncertinity_master_failed', RepNo, 0, 'master');
      //         // console.log(obj)
      //         let columNames = objUnccen.data.map(obj => obj.str_colName).toString();
      //         var str_Query = `insert into tbl_calibration_uncertinity_master_failed (${columNames}) select ${columNames} from tbl_calibration_uncertinity_master_incomplete where Uncertinity_RepNo = ${RepNo}`
      //         let resultUnccen = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
      //         // console.log(result)
      //         var lastInsertedIdUnccen = resultUnccen[0];

      //         await models.tbl_calibration_uncertinity_master_failed.update({
      //             "Uncertinity_RepNo": fRerSrNo,
      //             "Uncertinity_EndTime": moment(new Date()).format('HH:mm:ss')
      //         }, {
      //             where: {
      //                 "srNo": lastInsertedIdUnccen
      //             }
      //         })
      //         var selectDetailObjUnccen = {
      //             str_tableName: 'tbl_calibration_uncertinity_detail_incomplete',
      //             data: 'Uncertinity_RepNo,Uncertinity_RecNo',
      //             condition: [
      //                 { str_colName: 'Uncertinity_RepNo', value: RepNo, comp: 'eq' }
      //             ]
      //         }
      //         var resultU = await models.tbl_calibration_uncertinity_detail_incomplete.findAll({
      //             where: {
      //                 "Uncertinity_RepNo": RepNo
      //             }
      //         }); // selected
      //         let res = [{}]
      //         res[0].Uncertinity_RepNo = resultU[0].Uncertinity_RepNo
      //         res[0].Uncertinity_RecNo = resultU[0].Uncertinity_RecNo
      //         // console.log(result[0])
      //         let i = 0;
      //         for (let obj of resultU) {
      //             obj.Uncertinity_RecNo = resultU[i].Uncertinity_RecNo
      //             let objCopyUnccen = await copyObjects.uncertinity('tbl_calibration_uncertinity_detail_incomplete', 'tbl_calibration_uncertinity_detail_failed', obj.Uncertinity_RepNo, obj.Uncertinity_RecNo, 'detail');
      //             columNames = objCopyUnccen.data.map(obj => obj.str_colName).toString();
      //             str_Query = `insert into tbl_calibration_uncertinity_detail_failed (${columNames}) select ${columNames} from tbl_calibration_uncertinity_detail_incomplete where Uncertinity_RepNo = ${obj.Uncertinity_RepNo} AND Uncertinity_RecNo = ${obj.Uncertinity_RecNo}`
      //             let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

      //             var lastInsertedIdU = detailInsert[0];

      //             await models.tbl_calibration_uncertinity_detail_failed.update({
      //                 "Uncertinity_RepNo": fRerSrNo
      //             }, {
      //                 where: {
      //                     "srNo": lastInsertedIdU
      //                     // "Uncertinity_RepNo": obj.Uncertinity_RepNo
      //                 }
      //             })
      //             i++
      //         }

      //         if (sortedArray.indexOf('U') == int_curentCalibrationIndex) {
      //             // delete records from incomplete tables
      //             console.log('inside delete')

      //             await models.tbl_calibration_uncertinity_master_incomplete.destroy({
      //                 where: {
      //                     "Uncertinity_RepNo": RepNo
      //                 }
      //             })
      //             await models.tbl_calibration_uncertinity_detail_incomplete.destroy({
      //                 where: {
      //                     "Uncertinity_RepNo": RepNo
      //                 }
      //             })
      //         }
      //     }
      //         break;
      //     // For case ECCENTRICITY CALIBRATION
      //     case 'E': {
      //         // First copying data
      //         var objEccen = await copyObjects.eccentricity('tbl_calibration_eccentricity_master_incomplete'
      //             , 'tbl_calibration_eccentricity_master_failed', RepNo, 0, 'master');
      //         // console.log(obj)
      //         let columNames = objEccen.data.map(obj => obj.str_colName).toString();
      //         var str_Query = `insert into tbl_calibration_eccentricity_master_failed (${columNames}) select ${columNames} from tbl_calibration_eccentricity_master_incomplete where Eccent_RepNo = ${RepNo}`
      //         let resultEccen = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
      //         // console.log(result)
      //         var lastInsertedIdEccen = resultEccen[0]

      //         await models.tbl_calibration_eccentricity_master_failed.update({
      //             "Eccent_RepNo": fRerSrNo,
      //             "Eccent_EndTime": moment(new Date()).format('HH:mm:ss')
      //         }, {
      //             where: {
      //                 "srNo": lastInsertedIdEccen
      //             }
      //         })

      //         var resultP = await models.tbl_calibration_eccentricity_detail_incomplete.findAll({
      //             where: {
      //                 "Eccent_RepNo": RepNo
      //             }
      //         }); // selected
      //         let res = [{}]
      //         res[0].Eccent_RepNo = resultP[0].Eccent_RepNo
      //         res[0].Eccent_RecNo = resultP[0].Eccent_RecNo
      //         // console.log(result[0])
      //         let i = 0;
      //         for (let obj of resultP) {
      //             obj.Eccent_RecNo = resultP[i].Eccent_RecNo
      //             let objCopyEccen = await copyObjects.eccentricity('tbl_calibration_eccentricity_detail_incomplete'
      //                 , 'tbl_calibration_eccentricity_detail_failed', obj.Eccent_RepNo, obj.Eccent_RecNo, 'detail');
      //             columNames = objCopyEccen.data.map(obj => obj.str_colName).toString();
      //             str_Query = `insert into tbl_calibration_eccentricity_detail_failed (${columNames}) select ${columNames} from tbl_calibration_eccentricity_detail_incomplete where Eccent_RepNo = ${obj.Eccent_RepNo} AND Eccent_RecNo = ${obj.Eccent_RecNo}`
      //             let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

      //             var lastInsertedIdU = detailInsert[0];

      //             await models.tbl_calibration_uncertinity_detail_failed.update({
      //                 "Eccent_RepNo": fRerSrNo,
      //                 "Linear_EndTime": moment(new Date()).format('HH:mm:ss')
      //             }, {
      //                 where: {
      //                     "srNo": lastInsertedIdU
      //                     // "Eccent_RepNo":  res[0].Eccent_RepNo
      //                 }
      //             })
      //             i++

      //         }
      //         if (sortedArray.indexOf('E') == int_curentCalibrationIndex) {
      //             // delete records from incomplete tables
      //             console.log('inside delete')

      //             await models.tbl_calibration_eccentricity_master_incomplete.destroy({
      //                 where: {
      //                     "Eccent_RepNo": RepNo
      //                 }
      //             })
      //             await models.tbl_calibration_eccentricity_detail_incomplete.destroy({
      //                 where: {
      //                     "Eccent_RepNo": RepNo
      //                 }
      //             })
      //         }
      //     }
      //         break;
      //     // For case REPETABILITY CALIBRATION
      //     case 'R': {
      //         var objReap = await copyObjects.repetability('tbl_calibration_repetability_master_incomplete'
      //             , 'tbl_calibration_repetability_master_failed', RepNo, 0, 'master');
      //         // Copying Incomplete master to failed master
      //         let columNames = objReap.data.map(obj => obj.str_colName).toString();
      //         var str_Query = `insert into tbl_calibration_repetability_master_failed (${columNames}) select ${columNames} from tbl_calibration_repetability_master_incomplete where Repet_RepNo = ${RepNo}`
      //         let resultReap = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
      //         // last inserted Id got here form query
      //         var lastInsertedIdReap = resultReap[0];
      //         // Updating the report serial number in failed master

      //         await models.tbl_calibration_repetability_master_failed.update({
      //             "Repet_RepNo": fRerSrNo,
      //             "Repet_EndTime": moment(new Date()).format('HH:mm:ss')
      //         }, {
      //             where: {
      //                 "srNo": lastInsertedIdReap
      //             }
      //         }) // failed master report number updated
      //         // selecting data from incomplete details for copying

      //         var resultP = await models.tbl_calibration_repetability_detail_incomplete.findAll({
      //             where: {
      //                 "Repet_RepNo": RepNo
      //             }
      //         }); // selected
      //         let res = [{}]
      //         res[0].Repet_RepNo = resultP[0].Repet_RepNo
      //         res[0].Repet_RecNo = resultP[0].Repet_RecNo
      //         // as we have multiple entries i n details table so we need 
      //         // Async loop
      //         let i = 0;
      //         for (let obj of resultP) {
      //             obj.Repet_RecNo = resultP[i].Repet_RecNo
      //             let objCopyReap = await copyObjects.repetability('tbl_calibration_repetability_detail_incomplete'
      //                 , 'tbl_calibration_repetability_detail_failed', obj.Repet_RepNo, obj.Repet_RecNo, 'detail');

      //             columNames = objCopyReap.data.map(obj => obj.str_colName).toString();
      //             str_Query = `insert into tbl_calibration_repetability_detail_failed (${columNames}) select ${columNames} from tbl_calibration_repetability_detail_incomplete where Repet_RecNo = ${obj.Repet_RecNo} AND Repet_RecNo = ${obj.Repet_RecNo}`
      //             let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

      //             var lastInsertedIdU = detailInsert[0];

      //             await models.tbl_calibration_uncertinity_detail_failed.update({
      //                 "Repet_RepNo": fRerSrNo
      //             }, {
      //                 where: {
      //                     "srNo": lastInsertedIdU
      //                     // "Repet_RepNo": res[0].Repet_RepNo
      //                 }
      //             })
      //             i++
      //         }

      //         if (sortedArray.indexOf('R') == int_curentCalibrationIndex) {
      //             // delete records from incomplete tables
      //             console.log('inside delete')

      //             await models.tbl_calibration_repetability_master_incomplete.destroy({
      //                 where: {
      //                     "Repet_RepNo": RepNo
      //                 }
      //             })
      //             await models.tbl_calibration_repetability_detail_incomplete.destroy({
      //                 where: {
      //                     "Repet_RepNo": RepNo
      //                 }
      //             })

      //         }
      //     }
      //         break;

      //     // For case Linearity CALIBRATION
      //     case 'L': {
      //         var objLinear = await copyObjects.linearity('tbl_calibration_linearity_master_incomplete'
      //             , 'tbl_calibration_linearity_master_failed', RepNo, 0, 'master');
      //         // Copying Incomplete master to failed master
      //         let columNames = objLinear.data.map(obj => obj.str_colName).toString();
      //         var str_Query = `insert into tbl_calibration_linearity_master_failed (${columNames}) select ${columNames} from tbl_calibration_linearity_master_incomplete where Linear_RepNo = ${RepNo}`
      //         let resultLinear = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
      //         // last inserted Id got here form query
      //         var lastInsertedIdLinear = resultLinear[0];
      //         // Updating the report serial number in failed master

      //         await models.tbl_calibration_linearity_master_failed.update({
      //             "Linear_RepNo": fRerSrNo,
      //             "Linear_EndTime": moment(new Date()).format('HH:mm:ss')
      //         }, {
      //             where: {
      //                 "srNo": lastInsertedIdLinear
      //             }
      //         }) // failed master report number updated
      //         // selecting data from incomplete details for copying

      //         var resultP = await models.tbl_calibration_linearity_detail_incomplete.findAll({
      //             where: {
      //                 "Linear_RepNo": RepNo
      //             }
      //         }); // selected
      //         let res = [{}]
      //         res[0].Linear_RepNo = resultP[0].Linear_RepNo
      //         res[0].Linear_RecNo = resultP[0].Linear_RecNo
      //         // as we have multiple entries i n details table so we need 
      //         // Async loop
      //         let i = 0;
      //         for (let obj of res) {
      //             obj.Linear_RecNo = resultP[i].Linear_RecNo
      //             let objCopyLinear = await copyObjects.linearity('tbl_calibration_linearity_detail_incomplete'
      //                 , 'tbl_calibration_linearity_detail_failed', obj.Linear_RepNo, obj.Linear_RecNo, 'detail');

      //             columNames = objCopyLinear.data.map(obj => obj.str_colName).toString();
      //             str_Query = `insert into tbl_calibration_linearity_detail_failed (${columNames}) select ${columNames} from tbl_calibration_linearity_detail_incomplete where Linear_RecNo = ${obj.Linear_RecNo} AND Linear_RecNo = ${obj.Linear_RecNo}`
      //             let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })

      //             var lastInsertedIdU = detailInsert[0];

      //             await models.tbl_calibration_linearity_detail_failed.update({
      //                 "Linear_RepNo": fRerSrNo
      //             }, {
      //                 where: {
      //                     "srNo": lastInsertedIdU
      //                     // "Linear_RepNo": res[0].Linear_RepNo
      //                 }
      //             })
      //             i++;
      //         }

      //         if (sortedArray.indexOf('L') == int_curentCalibrationIndex) {
      //             // delete records from incomplete tables
      //             console.log('inside delete')

      //             await models.tbl_calibration_linearity_master_incomplete.destroy({
      //                 where: {
      //                     "Linear_RepNo": RepNo
      //                 }
      //             })
      //             await models.tbl_calibration_linearity_detail_incomplete.destroy({
      //                 where: {
      //                     "Linear_RepNo": RepNo
      //                 }
      //             })

      //         }
      //     }
      //         break;

      // }
    } catch (error) {
      console.log(error)
    }
  }

  async getFrepSrNo(str_first_calibration) {
    // str_first_calibration : - is the first calibration in the process

    switch (str_first_calibration) {
      case "P":
        var str_FailedTable = "tbl_calibration_periodic_master_failed"; // tableName
        var strRepNoColName = "Periodic_RepNo"; //column name
        var fRerSrNo = await this.calculateFrepSr(
          str_FailedTable,
          strRepNoColName
        ); // function call
        return fRerSrNo; // returning promise

      case "U":
        var str_FailedTable = "tbl_calibration_uncertinity_master_failed"; // tableName
        var strRepNoColName = "Uncertinity_RepNo"; //column name
        var fRerSrNo = await this.calculateFrepSr(
          str_FailedTable,
          strRepNoColName
        ); // function call
        return fRerSrNo; // returning promise
      case "R":
        var str_FailedTable = "tbl_calibration_repetability_master_failed"; // tableName
        var strRepNoColName = "Repet_RepNo"; //column name
        var fRerSrNo = await this.calculateFrepSr(
          str_FailedTable,
          strRepNoColName
        ); // function call
        return fRerSrNo; // returning promise
      case "E":
        var str_FailedTable = "tbl_calibration_eccentricity_master_failed"; // tableName
        var strRepNoColName = "Eccent_RepNo"; //column name
        var fRerSrNo = await this.calculateFrepSr(
          str_FailedTable,
          strRepNoColName
        ); // function call
        return fRerSrNo; // returning promise
      case "L":
        var str_FailedTable = "tbl_calibration_linearity_master_failed"; // tableName
        var strRepNoColName = "Linear_RepNo"; //column name
        var fRerSrNo = await this.calculateFrepSr(
          str_FailedTable,
          strRepNoColName
        ); // function call
        return fRerSrNo; // returning promise
      case "V":
        var str_FailedTable = "tbl_calibration_positional_master_failed";
        var strRepNoColName = "Positional_RepNo"; //column name
        var fRerSrNo = await this.calculateFrepSr(
          str_FailedTable,
          strRepNoColName
        ); // function call
        return fRerSrNo; // returning promise
    }
  }

  async calculateFrepSr(str_FailedTable, strRepNoColName) {
    let result = await models[str_FailedTable].findAll({
      attributes: [
        [sequelize.fn("max", sequelize.col(strRepNoColName)), "FRepSrNo"],
      ],
    });

    var FrepSrNo;
    // If entries not present
    if (result[0].FRepSrNo == null) {
      FrepSrNo = 1;
    } else {
      // If there are some records
      FrepSrNo = result[0].FRepSrNo + 1;
    }
    return FrepSrNo;
  }
  async check_validaty(_calib_entry) {
    let da_te = _calib_entry[0].EntryTimeStamp
    let valid_diff = moment()
    let start_Time = moment(da_te, 'HH:mm:ss');
    let end_Time = moment(valid_diff, 'HH:mm:ss');
    let total_time = moment.utc(moment(end_Time, "HH:mm:ss")
      .diff(moment(start_Time, "HH:mm:ss"))).format("HH:mm:ss")
    if (GLOBAL_NOMENCLATURE.Powerback_validtime < total_time) {
      return true
    } else {
      return false
    }

  }

}


module.exports = PowerBackup;
