const Joi = require('joi');
const requestIp = require('ip');

const clsCalibration = require('../model/Calibration/getCalibrationForBal.model');
const clsHmi = require('../model/hmiDetail.model');
const clsHmiSchema = require('../validation/hmiDetails/hmiDetail.Schema');
const clsCalibrationSchema = require('../validation/calibration/calbration.Schema');

const objCalibration = new clsCalibration();


const objHmi = new clsHmi();
const date = require('date-and-time');
const loggers = require('../model/winstonLogger');

exports.getAllBalListOfConnectedResbPie = (req, res) => {
    // const { error, value } = LoginSchema.ValidateApiLogin().validate(req.body);

    const { err, value } = clsCalibrationSchema.ValidateGetAllBalListOfConnectedResbPie().validate(req.body);


    // Joi.validate(req.body, clsCalibrationSchema.ValidateGetAllBalListOfConnectedResbPie(), (err, value) => {
    if (err) {
        res.statusCode = 400;
        let responseObj = {}
        Object.assign(responseObj, {
            status: 'fail',
            message: err.details[0].message.replace(/"/g, "")
        })
        res.send(responseObj);
    } else {
        objCalibration.getBallList(req.body).then((result) => {
            res.statusCode = 200;
            res.send(result);
        }).catch((err) => {
            console.log(err);
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail',
                message: 'Internal server error'
            })
            res.send(responseObj);
        })
    }
    // })

}

exports.calibOfSelectedBal = (req, res) => {
    var Ip = requestIp.address();
    objCalibration.doCalibrationOfSelectedBal(req.body, Ip).then((result) => {
        res.statusCode = 200;
        res.send(result);
    }).catch((err) => {
        console.log(err);
    })
}

exports.selPendigCalib = (req, res) => {
    let responseObj = {};

    const { err, value } = clsCalibrationSchema.ValidateSelectPendingCalib().validate(req.body);

    // Joi.validate(req.body, clsCalibrationSchema.ValidateSelectPendingCalib(), (err, value) => {
    if (err) {
        res.statusCode = 400;
        let responseObj = {}
        loggers.calibrationApiLogger.info(JSON.stringify({ apiCalled: 'Perform Calibration', responseObj }));
        Object.assign(responseObj, {
            status: 'fail',
            message: err.details[0].message.replace(/"/g, "")
        })
        res.send(responseObj);
    } else {
        objCalibration.selectPendingCalib(value).then((result) => {

            loggers.calibrationApiLogger.info(JSON.stringify({ apiCalled: 'Perform Calibration', objectSendByAndriod: req.body, resObj: result }));
            res.statusCode = 200;
            res.send(result);
        }).catch((err) => {
            console.log(err);
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail',
                message: 'Internal server error'
            })
            res.send(responseObj);
        })
    }
    // })
}

exports.getDetailOfConnectedHmi = (req, res) => {
    let objDetailOfConntedHmi = clsHmiSchema.ValidateHmiStatus(req.query);
    if (objDetailOfConntedHmi.hasOwnProperty('error')) {
        res.statusCode = 400;
        Object.assign(responseObj, { status: 'fail' }, { result: objDetailOfConntedHmi.error.details })
        res.send(responseObj);
    } else {
        objHmi.getHMIStatus(req.query).then(result => {
            res.statusCode = 200;
            res.send(result);
        }).catch(err => {
            console.log(err)
            res.statusCode = 500;
            let responseObj = {}
            Object.assign(responseObj, { status: 'fail' }, { result: 'Internal server error' })
            res.send(responseObj);
        })
    }


}






