const clsMesModel = require("../model/mes_api.model")
const mesModel = new clsMesModel()
const globalData = require("../global/globalData")
const path = require("path")
const NetworkLogs = require("../global/network.logger")
const mesValidation = require('../validation/MES/mes.Schema')

exports.batchEnd = (req, res) => {
    const obj = {}
    const {error, value} = mesValidation.ValidateBatchEnd().validate(req.body)
    NetworkLogs(req)
    if (error) {
        res.statusCode = 400
        res.send({
            status: "fail",
            message: error.message.replace(/"/g, "")
        })
    }
    mesModel.batchEnd(req.body).then( (data) => {
        NetworkLogs(req,res, data)
        res.send(data)
    }).catch(err => {
        res.statusCode = 500;
        NetworkLogs(req,res, err)
        res.send({
            status: "fail",
            message: "Internal Server Error"
        })
    })
}