// ***************************************************************************************************
class CopyObject {
    constructor() {
    }
    // periodic copy object for master and details
    async periodic(fromCopyTblName, toCopyTableName, oldRepSrNo, RecSrNo, type) { //tbl_calibration_periodic_master_incomplete //tbl_calibration_periodic_master_failed RepNo(65) 0 master

        if (type == 'master') {
            var copyObj = {
                fromCopyTblName: fromCopyTblName,
                toCopyTableName: toCopyTableName,
                data: [
                    { str_colName: "Periodic_CalbDate" },
                    { str_colName: "Periodic_DueDate  " },
                    { str_colName: "Periodic_CalbTime" },
                    { str_colName: "Periodic_CubicalNo" },
                    { str_colName: "Periodic_CubicalName" },
                    { str_colName: "Periodic_Area" },
                    { str_colName: "Periodic_IDSNo" },
                    { str_colName: "Periodic_BalID" },
                    { str_colName: "Periodic_Serial" },
                    { str_colName: "Periodic_Make" },
                    { str_colName: "Periodic_Model" },
                    { str_colName: "Periodic_Unit" },
                    { str_colName: "Periodic_Dept" },
                    { str_colName: "Periodic_MassWeight" },
                    { str_colName: "Periodic_LeastCnt" },
                    { str_colName: "Periodic_MaxCap" },
                    { str_colName: "Periodic_MinCap" },
                    { str_colName: "Periodic_Bal_MinOR" },
                    { str_colName: "Periodic_Bal_MaxOR" },
                    { str_colName: "Periodic_ZeroError" },
                    { str_colName: "Periodic_SpritLevel" },
                    { str_colName: "Periodic_GeneralCare" },
                    { str_colName: "Periodic_UserID" },
                    { str_colName: "Periodic_UserName" },
                    { str_colName: "Periodic_VerifyID" },
                    { str_colName: "Periodic_VerifyName" },
                    { str_colName: "Periodic_VerifyDate" },
                    { str_colName: "Periodic_PrintNo" },
                    { str_colName: "Periodic_IsRecalib" },
                    { str_colName: "Periodic_DP" },
                    { str_colName: "Periodic_StdWeight" },
                    { str_colName: "Periodic_NegTol" },
                    { str_colName: "Periodic_PosTol" },
                    { str_colName: "Periodic_Remark" },
                    { str_colName: "Periodic_AllWeightboxID" },
                    { str_colName: "Periodic_AllWeightboxCert" },
                    { str_colName: "Periodic_AllWeightboxValidUpto" },
                    { str_colName: "Periodic_IsBinBalance" },
                    { str_colName: "Periodic_Location" },
                    { str_colName: "Periodic_RoomNo" },
                    { str_colName: "Periodic_CalbReason" },
                    { str_colName: "Periodic_Pattern" },
                    { str_colName: "Periodic_Frequency" },
                    { str_colName: "Periodic_calibStatus" },
                    { str_colName: "Tolerance" },
                    { str_colName: "Periodic_Bal_Cert_No" },

                ],
                condition: [
                    { str_colName: 'Periodic_RepNo', value: oldRepSrNo }
                ]
            }
            return copyObj;
        } else {
            var copyObj = {
                fromCopyTblName: fromCopyTblName,
                toCopyTableName: toCopyTableName,
                data: [
                    { str_colName: 'Periodic_RecNo' },
                    { str_colName: 'Periodic_BalStdWt' },
                    { str_colName: 'Periodic_BalNegTol' },
                    { str_colName: 'Periodic_BalPosTol' },
                    { str_colName: 'Periodic_ActualWt' },
                    { str_colName: 'Periodic_StdWtBoxID' },
                    { str_colName: 'Periodic_StdWt' },
                    { str_colName: 'Periodic_WtIdentification' },
                    { str_colName: 'Periodic_WeightBox_certfctNo' },
                    { str_colName: 'PercentofCapacity' },
                    { str_colName: 'Periodic_ValDate' },
                    { str_colName: 'Periodic_DP' },
                    { str_colName: 'Periodic_Tolerance' },
                    
                ],
                condition: [
                    { str_colName: 'Periodic_RepNo', value: oldRepSrNo },
                    { str_colName: 'Periodic_RecNo', value: RecSrNo }
                ]
            }
            return copyObj;
        }

    }
    //********************************************************************************** */
    // repetability copy object for master and details
    async repetability(fromCopyTblName, toCopyTableName, oldRepSrNo, RecSrNo, type) {

        if (type == 'master') {
            var copyObj = {
                fromCopyTblName: fromCopyTblName,
                toCopyTableName: toCopyTableName,
                data: [
                    { str_colName: "Repet_CalbDate" },
                    { str_colName: "Repet_DueDate" },
                    { str_colName: "Repet_CalbTime" },
                    { str_colName: "Repet_CubicalNo" },
                    { str_colName: "Repet_CubicalName" },
                    { str_colName: "Repet_Area" },
                    { str_colName: "Repet_IDSNo" },
                    { str_colName: "Repet_BalID" },
                    { str_colName: "Repet_Serial" },
                    { str_colName: "Repet_Make" },
                    { str_colName: "Repet_Model" },
                    { str_colName: "Repet_Unit" },
                    { str_colName: "Repet_Dept" },
                    { str_colName: "Repet_MassWeight" },
                    { str_colName: "Repet_LeastCnt" },
                    { str_colName: "Repet_MaxCap" },
                    { str_colName: "Repet_MinCap" },
                    { str_colName: "Repet_Bal_MinOR" },
                    { str_colName: "Repet_Bal_MaxOR" },
                    { str_colName: "Repet_ZeroError" },
                    { str_colName: "Repet_SpritLevel" },
                    { str_colName: "Repet_GeneralCare" },
                    { str_colName: "Repet_UserID" },
                    { str_colName: "Repet_UserName" },
                    { str_colName: "Repet_VerifyID" },
                    { str_colName: "Repet_VerifyName" },
                    { str_colName: "Repet_VerifyDate" },
                    { str_colName: "Repet_PrintNo" },
                    { str_colName: "Repet_IsRecalib" },
                    { str_colName: "Repet_DP" },
                    { str_colName: "Repet_StdWeight" },
                    { str_colName: "Repet_NegTol" },
                    { str_colName: "Repet_PosTol" },
                    { str_colName: "Repet_Remark" },
                    { str_colName: "Repet_AllWeightboxID" },
                    { str_colName: "Repet_AllWeightboxCert" },
                    { str_colName: "Repet_AllWeightboxValidUpto" },
                    { str_colName: "Repet_IsBinBalance" },
                    { str_colName: "Repet_Per" },
                    { str_colName: "Repet_Deviation" },
                    { str_colName: "Repet_Mean" },




                ],
                condition: [
                    { str_colName: 'Repet_RepNo', value: oldRepSrNo }
                ]
            }
            return copyObj;
        } else {
            var copyObj = {
                fromCopyTblName: fromCopyTblName,
                toCopyTableName: toCopyTableName,
                data: [
                    { str_colName: 'Repet_RecNo' },
                    { str_colName: 'Repet_BalStdWt' },
                    { str_colName: 'Repet_BalNegTol' },
                    { str_colName: 'Repet_BalPosTol' },
                    { str_colName: 'Repet_ActualWt' },
                    { str_colName: 'Repet_StdWtID' },
                    { str_colName: 'Repet_StdWt' },
                    { str_colName: 'Repet_WtIdentification' },
                    { str_colName: 'Repet_WeightBox_certfctNo' },
                    { str_colName: 'PercentofCapacity' },
                    { str_colName: "Repet_Remark" },
                    { str_colName: 'Repet_DP' },
                    { str_colName: 'Repet_ValDate' },
                ],
                condition: [
                    { str_colName: 'Repet_RepNo', value: oldRepSrNo },
                    { str_colName: 'Repet_RecNo', value: RecSrNo }
                ]
            }
            return copyObj;
        }

    }
    //********************************************************************************** */
    // uncertinity copy object for master and details
    async uncertinity(fromCopyTblName, toCopyTableName, oldRepSrNo, RecSrNo, type) {

        if (type == 'master') {
            var copyObj = {
                fromCopyTblName: fromCopyTblName,
                toCopyTableName: toCopyTableName,
                data: [
                    { str_colName: 'Uncertinity_CalbDate' },
                    { str_colName: 'Uncertinity_CalbTime' },
                    { str_colName: 'Uncertinity_DueDate' },
                    { str_colName: 'Uncertinity_BalID' },
                    { str_colName: 'Uncertinity_CubicalNo' },
                    { str_colName: 'Uncertinity_CubicalName' },
                    { str_colName: 'Uncertinity_Area' },
                    { str_colName: 'Uncertinity_IDSNo' },
                    { str_colName: 'Uncertinity_Serial' },
                    { str_colName: 'Uncertinity_Make' },
                    { str_colName: 'Uncertinity_Model' },
                    { str_colName: 'Uncertinity_Unit' },
                    { str_colName: 'Uncertinity_Dept' },
                    { str_colName: 'Uncertinity_MassWeight' },
                    { str_colName: 'Uncertinity_LeastCnt' },
                    { str_colName: 'Uncertinity_MaxCap' },
                    { str_colName: 'Uncertinity_MinCap' },
                    { str_colName: 'Uncertinity_Bal_MinOR' },
                    { str_colName: 'Uncertinity_Bal_MaxOR' },
                    { str_colName: 'Uncertinity_ZeroError' },
                    { str_colName: 'Uncertinity_SpritLevel' },
                    { str_colName: 'Uncertinity_GeneralCare' },
                    { str_colName: 'Uncertinity_UserID' },
                    { str_colName: 'Uncertinity_UserName' },
                    { str_colName: 'Uncertinity_VerifyID' },
                    { str_colName: 'Uncertinity_VerifyName' },
                    { str_colName: 'Uncertinity_VerifyDate' },
                    { str_colName: 'Uncertinity_PrintNo' },
                    { str_colName: 'Uncertinity_IsRecalib' },
                    { str_colName: 'Uncertinity_DP' },
                    { str_colName: 'Uncertinity_StdWeight' },
                    { str_colName: 'Uncertinity_NegTol' },
                    { str_colName: 'Uncertinity_PosTol' },
                    { str_colName: 'Uncertinity_Remark' },
                    { str_colName: 'Uncertinity_AllWeightboxID' },
                    { str_colName: 'Uncertinity_AllWeightboxCert' },
                    { str_colName: 'Uncertinity_AllWeightboxValidUpto' },
                    { str_colName: 'Uncertinity_IsBinBalance' },
                    { str_colName: 'Uncertinity_SD' },
                    { str_colName: 'Uncertinity_Mean' },
                    { str_colName: 'Uncertinity_Per' },

                ],
                condition: [
                    { str_colName: 'Uncertinity_RepNo', value: oldRepSrNo }
                ]
            }
            return copyObj;
        } else {
            var copyObj = {
                fromCopyTblName: fromCopyTblName,
                toCopyTableName: toCopyTableName,
                data: [
                    { str_colName: 'Uncertinity_RecNo' },
                    { str_colName: 'Uncertinity_BalStdWt' },
                    { str_colName: 'Uncertinity_BalNegTol' },
                    { str_colName: 'Uncertinity_BalPosTol' },
                    { str_colName: 'Uncertinity_ActualWt' },
                    { str_colName: 'Uncertinity_StdWtID' },
                    { str_colName: 'Uncertinity_StdWt' },
                    { str_colName: 'Uncertinity_WtIdentification' },
                    { str_colName: 'Uncertinity_WeightBox_certfctNo' },
                    { str_colName: 'PercentofCapacity' },
                    { str_colName: 'Uncertinity_ValDate' },
                    { str_colName: 'Uncertinity_DP' },
                    { str_colName: 'Uncertinity_Remark' },
                    { str_colName: 'Uncertinity_Deviation' },
                ],
                condition: [
                    { str_colName: 'Uncertinity_RepNo', value: oldRepSrNo },
                    { str_colName: 'Uncertinity_RecNo', value: RecSrNo }
                ]
            }
            return copyObj;
        }

    }
    //********************************************************************************** */
    // eccentricity copy object for master and details
    async eccentricity(fromCopyTblName, toCopyTableName, oldRepSrNo, RecSrNo, type) {

        if (type == 'master') {
            var copyObj = {
                fromCopyTblName: fromCopyTblName,
                toCopyTableName: toCopyTableName,
                data: [

                    { str_colName: "Eccent_RepNo" },
                    { str_colName: "Eccent_CalbDate" },
                    { str_colName: "Eccent_DueDate" },
                    { str_colName: "Eccent_CalbTime" },
                    { str_colName: "Eccent_CubicalNo" },
                    { str_colName: "Eccent_CubicalName" },
                    { str_colName: "Eccent_Area" },
                    { str_colName: "Eccent_IDSNo" },
                    { str_colName: "Eccent_BalID" },
                    { str_colName: "Eccent_Serial" },
                    { str_colName: "Eccent_Make" },
                    { str_colName: "Eccent_Model" },
                    { str_colName: "Eccent_Unit" },
                    { str_colName: "Eccent_Dept" },
                    { str_colName: "Eccent_MassWeight" },
                    { str_colName: "Eccent_LeastCnt" },
                    { str_colName: "Eccent_MaxCap" },
                    { str_colName: "Eccent_MinCap" },
                    { str_colName: "Eccent_Bal_MinOR" },
                    { str_colName: "Eccent_Bal_MaxOR" },
                    { str_colName: "Eccent_ZeroError" },
                    { str_colName: "Eccent_SpritLevel" },
                    { str_colName: "Eccent_GeneralCare" },
                    { str_colName: "Eccent_UserID" },
                    { str_colName: "Eccent_UserName" },
                    { str_colName: "Eccent_VerifyID" },
                    { str_colName: "Eccent_VerifyName" },
                    { str_colName: "Eccent_VerifyDate" },
                    { str_colName: "Eccent_PrintNo" },
                    { str_colName: "Eccent_IsRecalib" },
                    { str_colName: "Eccent_DP" },
                    { str_colName: "Eccent_StdWeight" },
                    { str_colName: "Eccent_NegTol" },
                    { str_colName: "Eccent_PosTol" },
                    { str_colName: "Eccent_Remark" },
                    { str_colName: "Eccent_AllWeightboxID" },
                    { str_colName: "Eccent_AllWeightboxCert " },
                    { str_colName: "Eccent_AllWeightboxValidUpto" },
                    { str_colName: "Eccent_IsBinBalance" },
                    { str_colName: "Eccent_PerDeviation" },



                ],
                condition: [
                    { str_colName: 'Eccent_RepNo', value: oldRepSrNo }
                ]
            }
            return copyObj;
        } else {
            var copyObj = {
                fromCopyTblName: fromCopyTblName,
                toCopyTableName: toCopyTableName,
                data: [
                    { str_colName: 'Eccent_RecNo' },
                    { str_colName: 'Eccent_BalStdWt' },
                    { str_colName: 'Eccent_BalNegTol' },
                    { str_colName: 'Eccent_BalPosTol' },
                    { str_colName: 'Eccent_ActualWt' },
                    { str_colName: 'Eccent_StdWtID' },
                    { str_colName: 'Eccent_StdWt' },
                    { str_colName: 'Eccent_WtIdentification' },
                    { str_colName: 'Eccent_WeightBox_certfctNo' },
                    { str_colName: 'PercentofCapacity' },
                    { str_colName: 'Eccent_DP' },
                    { str_colName: 'Eccent_Remark' },
                    { str_colName: "Eccent_Deviation" },
                    { str_colName: "Eccent_ValDate" }

                ],
                condition: [
                    { str_colName: 'Eccent_RepNo', value: oldRepSrNo },
                    { str_colName: 'Eccent_RecNo', value: RecSrNo }
                ]
            }
            return copyObj;
        }

    }
    //********************************************************************************** */
    // linearity copy object for master and details
    async linearity(fromCopyTblName, toCopyTableName, oldRepSrNo, RecSrNo, type) {

        if (type == 'master') {
            var copyObj = {
                fromCopyTblName: fromCopyTblName,
                toCopyTableName: toCopyTableName,
                data: [
                    { str_colName: 'Linear_CalbDate' },
                    { str_colName: 'Linear_CalbTime' },
                    { str_colName: 'Linear_BalID' },
                    { str_colName: 'Linear_BalSrNo' },
                    { str_colName: 'Linear_Make' },
                    { str_colName: 'Linear_Model' },
                    { str_colName: 'Linear_Unit' },
                    { str_colName: 'Linear_Dept' },
                    { str_colName: 'Linear_LeastCnt' },
                    { str_colName: 'Linear_MaxCap' },
                    { str_colName: 'Linear_MinCap' },
                    { str_colName: 'Linear_ZeroError' },
                    { str_colName: 'Linear_SpritLevel' },
                    { str_colName: 'Linear_GerneralCare' },
                    { str_colName: 'Linear_UserID' },
                    { str_colName: 'Linear_UserName' },
                    { str_colName: 'Linear_VerifyID' },
                    { str_colName: 'Linear_VerifyName' },
                    { str_colName: 'Linear_VerifyDate' },
                    { str_colName: 'Linear_PrintNo' },
                    { str_colName: 'Linear_IsRecalib' },
                    { str_colName: 'Linear_Location' },
                    { str_colName: 'Linear_RoomNo' },
                    { str_colName: 'Decimal_Point' },
                    { str_colName: 'Linear_DueDate' },
                    { str_colName: 'Linear_StdWeight' },
                    { str_colName: 'Linear_NegTol' },
                    { str_colName: 'Linear_PosTol' },
                ],
                condition: [
                    { str_colName: 'Linear_RepNo', value: oldRepSrNo }
                ]
            }
            return copyObj;
        } else {
            var copyObj = {
                fromCopyTblName: fromCopyTblName,
                toCopyTableName: toCopyTableName,
                data: [
                    { str_colName: 'Linear_RecNo' },
                    { str_colName: 'Linear_BalStdWt' },
                    { str_colName: 'Linear_BalNegTol' },
                    { str_colName: 'Linear_BalPosTol' },
                    { str_colName: 'Linear_ActualWt' },
                    { str_colName: 'Linear_StdWtBoxID' },
                    { str_colName: 'Linear_StdWt' },
                    { str_colName: 'Linear_WtIdentification' },
                    { str_colName: 'Linear_WeightBox_certfctNo' },
                    { str_colName: 'PercentofCapacity' },
                    { str_colName: 'Linear_ValDate' },
                ],
                condition: [
                    { str_colName: 'Linear_RepNo', value: oldRepSrNo },
                    { str_colName: 'Linear_RecNo', value: RecSrNo }
                ]
            }
            return copyObj;
        }

    }

    async vaccumCrimp(fromCopyTblName, toCopyTableName, oldRepSrNo, RecSrNo, type) {
        var copyObj = {
            fromCopyTblName: fromCopyTblName,
            toCopyTableName: toCopyTableName,
            data: [
                { str_colName: 'RepSerno' },
                { str_colName: 'SeqNo' },
                { str_colName: 'dt' },
                { str_colName: 'tm' },
                { str_colName: 'InitialWt' },
                { str_colName: 'AfterWt' },
                { str_colName: 'DiffInitialAfter' },
                { str_colName: 'DoneBy' },
                { str_colName: 'MachinID' },
                { str_colName: 'LineID' },
                { str_colName: 'UserName' },
                { str_colName: 'DF_DetailVaccumCrimping_FlgOutOfLimit' },
                { str_colName: 'DF_DetailVaccumCrimping_Incomplete' },
                { str_colName: 'Dp' },

            ],
            condition: [
                { str_colName: 'RepSerno', value: oldRepSrNo },
                { str_colName: 'SeqNo', value: RecSrNo }
            ]
        }
        return copyObj;
    }

    async diameterCrimp(fromCopyTblName, toCopyTableName, oldRepSrNo, RecSrNo, type) {
        var copyObj = {
            fromCopyTblName: fromCopyTblName,
            toCopyTableName: toCopyTableName,
            data: [
                { str_colName: 'RepSerNo' },
                { str_colName: 'dt' },
                { str_colName: 'tm' },
                { str_colName: 'CalibVernierStatus' },
                { str_colName: 'DataValue_H1' },
                { str_colName: 'DataValue_H2' },
                { str_colName: 'DataValue_H3' },
                { str_colName: 'DataValue_H4' },
                { str_colName: 'DataValue_H5' },
                { str_colName: 'DataValue_H6' },
                { str_colName: 'DoneBy' },
                { str_colName: 'UserName' },
                { str_colName: 'FlgOutOfLimit' },
                { str_colName: 'SeqNo' },
                { str_colName: 'Incomplete' },
                { str_colName: 'Dp' },
            ],
            condition: [
                { str_colName: 'RepSerno', value: oldRepSrNo },
                { str_colName: 'SeqNo', value: RecSrNo }
            ]
        }
        return copyObj;
    }

    async heightCrimp(fromCopyTblName, toCopyTableName, oldRepSrNo, RecSrNo, type) {
        var copyObj = {
            fromCopyTblName: fromCopyTblName,
            toCopyTableName: toCopyTableName,
            data: [
                { str_colName: 'RepSerNo' },
                { str_colName: 'dt' },
                { str_colName: 'tm' },
                { str_colName: 'CalibVernierStatus' },
                { str_colName: 'DataValue_H1' },
                { str_colName: 'DataValue_H2' },
                { str_colName: 'DataValue_H3' },
                { str_colName: 'DataValue_H4' },
                { str_colName: 'DataValue_H5' },
                { str_colName: 'DataValue_H6' },
                { str_colName: 'DoneBy' },
                { str_colName: 'UserName' },
                { str_colName: 'FlgOutOfLimit' },
                { str_colName: 'SeqNo' },
                { str_colName: 'Incomplete' },
                { str_colName: 'Dp' },
            ],
            condition: [
                { str_colName: 'RepSerno', value: oldRepSrNo },
                { str_colName: 'SeqNo', value: RecSrNo }
            ]
        }
        return copyObj;
    }


    async suspensionPilot(fromCopyTblName, toCopyTableName, oldRepSrNo, RecSrNo, type) {
        var copyObj = {
            fromCopyTblName: fromCopyTblName,
            toCopyTableName: toCopyTableName,
            data: [
                { str_colName: 'RepSerno' },
                { str_colName: 'SeqNo' },
                { str_colName: 'dt' },
                { str_colName: 'tm' },
                { str_colName: 'DoneBy' },
                { str_colName: 'Can1' },
                { str_colName: 'Can2' },
                { str_colName: 'Can3' },
                { str_colName: 'Can4' },
                { str_colName: 'Can5' },
                { str_colName: 'MachinID' },
                { str_colName: 'LineID' },
                { str_colName: 'UserName' },
                { str_colName: 'DF_DetailSuspension_FlgOutOfLimit' },
                { str_colName: 'DF_DetailSuspension_Incomplete' },
                { str_colName: 'Dp' },
            ],
            condition: [
                { str_colName: 'RepSerno', value: oldRepSrNo },
                { str_colName: 'SeqNo', value: RecSrNo }
            ]
        }
        return copyObj;
    }

}
// CLASS ENDS
module.exports = CopyObject;