const clsQueryProcessor = require('../../database/clsQueryProcess');
const database = new clsQueryProcessor();
const date = require('date-and-time');
const globalData = require('../../global/globalData');
var checkForPenCal = require('./checkForPendingCalib');
const GlobalProtocol = require("../../global/CalibrationProtocol");
const FormulaFunction = require('../Product/clsformulaFun.model'); //make this function
const objFormulaFunction = new FormulaFunction();
const dbCon = require('../../global/dbCon');
const MqttModel = require('../Mqtt/mqttSender.class');
const mqttSender = new MqttModel();
const clsActivityLog = require('../clsActivityLog.model');
const objActivityLog = new clsActivityLog();
const InstrumentUsage = require('../clsInstrumentUsageLog');
const objInstrumentUsage = new InstrumentUsage();
const loggers = require('../winstonLogger');
const mqttProtocol = require('../../global/GLOBAL_NOMENCLATURE');
const clsHmi = require('../hmiDetail.model');
const objHmiModel = new clsHmi();
const PowerBackup = require("../../Utills/powerBackUp/powerbackup");
const objPowerBackup = new PowerBackup();
const clsCommomInsertOperation = require('../Product/clsCommonInsertOperation.model')
const serverConfig = require("../../../../IncrencyV4DRLTSHConfig.json");
// const clsAlert = require('../../../Interface/model/Alert/alert.model')
const objClsInsertOp = new clsCommomInsertOperation();
// const objAlert = new clsAlert();
const GlobalNomenclature = require('../../global/GLOBAL_NOMENCLATURE');
const sequelize = require('../../../config/dbConnection').sequelize
const models = require('../../../config/dbConnection').models;
const { QueryTypes } = require('sequelize');
const moment = require('moment');

const clsMonit = require('../MonitorSocket/clsMonitSocket')
const objMonit = new clsMonit();

class CalibrationModel {
    // ***********************************************************************************************************//
    // Below function checks if daily calibration is pending or not                                               //
    //*********************************************************************************************************** */
    async checkDailyCalibrationPending(strBalID, Hmi, balType,flag = false,TabIp) {
        try {
            let now = new Date();
            // fetching Current cubicle information
            var strBalId = strBalID;
            var strHmi = Hmi;
            let resobj = {};
            var arrResbPiNo = await objHmiModel.getResbPiNoFromHmi(strHmi);
            var strIdsNo = arrResbPiNo[0].DS_IP;

            const tempCubicInfo = globalData.arrIdsInfo.find(k => k.DsNo == strHmi && TabIp == TabIp);
            var objOwner = globalData.arrPreWeighCalibOwner.find(k => k.Hmi == strHmi && TabIp == TabIp);
            var tableName, globalArray
            if (balType == 'analytical') {
                var strBalId = tempCubicInfo.cubicalData.Sys_BalID;
                tableName = "tbl_calibration_status",
                    globalArray = 'arrBalanceRecalibStatus'
            } else {
                var strBalId = tempCubicInfo.cubicalData.Sys_BinBalID;
                tableName = "tbl_calibration_status_bin",
                    globalArray = "arrBalanceRecalibStatusIPC"
            }

            var todayDate = moment().format('YYYY-MM-DD')
            var selectDailyRes = await models.tbl_calibration_daily_master.findAll({
                where: {
                    Daily_BalID: strBalId,
                    Daily_CalbDate: todayDate
                },
            });
            selectDailyRes = [selectDailyRes];
            var found = globalData.calibrationStatus.some(function (el) {
                return el.BalId == strBalId;
            });
            let result = await models[tableName].findOne({
                where: {
                    'BalID': strBalId
                }
            });
            if(flag == true){
                selectDailyRes[0].length = 1
            }
            // fetch new balanvce
            let newbalance = await models.tbl_balance.findOne({
                where: {
                    'Bal_ID': strBalId
                }
            });
            var new_bala_flag = newbalance.IsNewBalance
        //     if (new_bala_flag == 1) {
        //         // selectDailyRes[0].length = 1
            
        //     let check_periodic_entry = await models.tbl_calibration_periodic_master.findAll({
        //         where: {
        //             Periodic_CalbDate: todayDate,
        //             'Periodic_BalID': strBalId
        //         }
        //     });

        //     if(check_periodic_entry.length == 0){
        //         selectDailyRes[0].length = 1
        //     }
        // }
            //END
            var result_1 = result.P
            if (result_1 == 1) {
                selectDailyRes[0].length = 1
            }

            const BalanceRecalibStatusObject =
                globalData[globalArray].find((k) => k.Bal_ID == strBalId);
            // if (balType == 'IPC Balance') {
            //     selectDailyRes[0].length = 1 
            // }
            if (selectDailyRes[0].length == 0 || BalanceRecalibStatusObject.DailyBalRecalib == 1) {
                // var obj = globalData.flagCalibWeighment.find((k) => k.idsNo == strHmi)
                // if (obj == undefined){
                //     globalData.flagCalibWeighment.push({
                //         idsNo: strHmi,
                //         alertFlag: true
                //     });
                // }else{
                //     obj.idsNo = strHmi,
                //     obj.alertFlag = true
                // }

                return GlobalProtocol.Daily;
            } else {
                var Response = await checkForPenCal.checkIfTodayIsPeriodicCalib(
                    strBalId,
                    strHmi,
                    TabIp
                    
                );
                if (
                    Response.askPeriodic == true ||
                    BalanceRecalibStatusObject.PeriodicBalRecalib == 1

                ) {
                    if (found) {
                        var resultFound = await checkForPenCal.checkForPendingCalib(
                            strBalId,
                            strHmi,
                            Response.calibMessage,
                            Response.calibType,
                            Response.isNewBal,
                            Response.isPeriodic,
                            Response.Due,
                            balType,
                            TabIp
                        );
                        return resultFound;
                    } else {
                        return GlobalProtocol.No;
                    }
                }
                else {
                    return GlobalProtocol.No;
                }
            }
        } catch (err) {

            console.log(err.stack);

        }
    }

    //********************************************************************************************************** */
    // This function called when We recives CP protocol also here we send first weight for calibration
    //********************************************************************************************************** */
    async getCalibWeights(strBalId, strHmi, rasbpi,TabIp) {
        try {
            var strBalId = strBalId;
            let srNo = 0;
            let resObj = {};
            let hmiDetails = globalData.arrSelectedBalWithHmi.find(k => k.Hmi == strHmi && TabIp ==TabIp);
            let TempCalibType = globalData.arrcalibType.find(k => k.DsNo == strHmi && TabIp == TabIp);

            var objDelay = globalData.delayApi.find(k => k.Hmi == strHmi && TabIp == TabIp)
            if (objDelay == undefined) {
                globalData.arrCalibInsertCounter.findIndex((element) => element.Hmi === strHmi && TabIp == TabIp) == -1 ? globalData.arrCalibInsertCounter : globalData.arrCalibInsertCounter.splice(globalData.arrCalibInsertCounter.findIndex((element) => element.Hmi === strHmi&& TabIp == TabIp), 1);
                (globalData.arrCalibCounterApi.findIndex((element) => element.Hmi === strHmi&& TabIp == TabIp)) == -1 ? globalData.arrCalibCounterApi : globalData.arrCalibCounterApi.splice(globalData.arrCalibCounterApi.findIndex((element) => element.Hmi === strHmi&& TabIp == TabIp), 1);
                (globalData.arrCalibCounter.findIndex((element) => element.Hmi === strHmi&& TabIp == TabIp)) == -1 ? globalData.arrCalibCounter : globalData.arrCalibCounter.splice(globalData.arrCalibCounter.findIndex((element) => element.Hmi === strHmi&& TabIp == TabIp), 1);
            }

            if (TempCalibType != undefined) {
                TempCalibType.calibType = 'daily';
            } else {
                globalData.arrcalibType.push({ DsNo: strHmi,TabIp:TabIp ,calibType: 'daily' })
            }
            let strPortNo = globalData.arrOfBalListWithPortNumber.find(k => k.Hmi == strHmi&& TabIp == TabIp).BalList.find(i => i.BalanceId == strBalId).PortNo;
            await objMonit.monit({ case: 'Calibration', Hmi: strHmi, data: { calibType: mqttProtocol.Daily } });

            if (hmiDetails == undefined) {
                globalData.arrSelectedBalWithHmi.push({
                    "DsNo": strHmi,
                    "rasbpi": rasbpi,
                    TabIp:TabIp,
                    "selectedBal": strBalId,
                    "portNo": strPortNo,
                    "InstrumentType": "Balance",
                })
            } else {
                hmiDetails.rasbpi = rasbpi;
                hmiDetails.selectedBal = strBalId;
                hmiDetails.port = strPortNo;
                hmiDetails.InstrumentType = "Balance";
            }


            // get all the balance details form 'tbl_balance' in global array :arrBalance
            var result = await models.tbl_balance.findAll({
                where: {
                    'Bal_ID': strBalId
                }
            })

            result = [result]

            let Dp = serverConfig.plant == 'PUI' ? result[0][0].Bal_DP : 3;

            let arrBal = globalData.arrBalance.find(k => k.Hmi == strHmi  && TabIp == TabIp);
            if (arrBal == undefined) {
                globalData.arrBalance.push({
                    Hmi: strHmi,
                    balId: strBalId,
                    TabIp:TabIp,
                    balance_info: result[0]
                });
            } else {
                arrBal.balId = strBalId,
                    arrBal.balance_info = result[0]
            }

            var tempBalace = globalData.arrBalance.find(k => k.Hmi == strHmi&& TabIp == TabIp)

            result = await models.tbl_balance_weights.findAll({

                where: {
                    'Bal_ID': strBalId,
                    'Bal_Daily': 1
                },
                order: [['Bal_StdWt', 'ASC']]
            })
            result = [result];

            //compare gm and send g 
            var strUnitOfBal = globalData.arrBalance.find(k => k.Hmi == strHmi&& TabIp == TabIp);
            var strUnitAccordingDb;
            if (strUnitOfBal.balance_info[0].Bal_Unit.toLowerCase() == "gm") {
                strUnitAccordingDb = "g";
            } else {
                strUnitAccordingDb = strUnitOfBal.balance_info[0].Bal_Unit;
            }


            // If Array of weights is Already present in globalData then we have to update this so we first remove 
            // and push new one OR Else if not present then we add new one
            var found = globalData.arrBalCalibWeights.some(function (el) {
                return el.Hmi == strHmi;
            });
            if (found) {
                const tempObj = globalData.arrBalCalibWeights.find(k => k.Hmi == strHmi&& TabIp == TabIp);
                // removing Current obj
                var index = globalData.arrBalCalibWeights.indexOf(tempObj);
                if (index !== -1) globalData.arrBalCalibWeights.splice(index, 1);
                globalData.arrBalCalibWeights.push({
                    Hmi: strHmi,
                    balId: strBalId,
                   TabIp :TabIp,
                    calibWt: result[0] // array
                })
            } else {
                globalData.arrBalCalibWeights.push({
                    Hmi: strHmi,
                    TabIp :TabIp,
                    balId: strBalId,
                    calibWt: result[0] // array
                })
            }

            let tempCounter = globalData.arrCalibCounterApi.find(k => k.Hmi == strHmi&& TabIp == TabIp);
            if (tempCounter == undefined) {
                globalData.arrCalibCounterApi.push({ 'Hmi': strHmi,TabIp : TabIp ,'BalId': strBalId, 'counterApi': srNo })
            }

            const tempUserObject = globalData.arrUsers.find(k => k.DsNo == strHmi&& TabIp == TabIp);
            let _calib_count = tempCounter == undefined ? 0 : tempCounter.counterApi
            //28-05-2022 _calibration powerbakup implement --kai.....:>
            var _powerbackupCalib = {
                strTableName: 'tbl_calibration_daily_master_incomplete',
                strDetailTbl: 'tbl_calibration_daily_detail_incomplete',
                cubicaNo: 'NUll',
                cubicType: 'NUll',
                cubicSysBFGcode: 'NUll',
                cubicBatch: 'NUll',
                menuName: 'DAILY',
                productType: 'NUll',
                Userid: tempUserObject.UserId,
                idsNo: rasbpi,
                Hmi: strHmi,
                RecSampleNo: _calib_count,
                ReportType: 'NUll',
                _bal_id: strBalId,
                TabIp:TabIp

            }
            let _check_combination = await objPowerBackup._check_calibration_entry(strHmi,TabIp, _powerbackupCalib, "tbl_powerbackup");
            if (_check_combination !== undefined) {
                if (tempCounter == undefined) {
                    tempCounter = globalData.arrCalibCounterApi.find(k => k.Hmi == strHmi && TabIp== TabIp);
                }
                tempCounter.counterApi = _check_combination.RecSampleNo;
                _powerbackupCalib.RecSampleNo = tempCounter.counterApi
                tempCounter.counterApi = tempCounter.counterApi
            }
            else {
                if (tempCounter != undefined) {
                    tempCounter.counterApi += 1;
                    _powerbackupCalib.RecSampleNo = tempCounter.counterApi
                    tempCounter.counterApi = tempCounter.counterApi
                }
            }

            if (tempCounter == undefined) {
                let strResbPi = globalData.arrOfBalListWithPortNumber.find(k => k.Hmi == strHmi && TabIp == TabIp).ResbPi;

                let intsend = globalData.arrsendWt.find(k => k.Hmi == strHmi&& TabIp == TabIp);
                if (intsend == undefined) {
                    globalData.arrsendWt.push({ 'Hmi': strHmi, TabIp:TabIp, 'BalId': strBalId, 'sendWt': objFormulaFunction.FormatNumberString(result[0][0].Bal_StdWt, tempBalace.balance_info[0].Bal_DP) });
                }
                else {
                    intsend.strBalId = strBalId;
                    intsend.sendWt = objFormulaFunction.FormatNumberString(result[0][0].Bal_StdWt, tempBalace.balance_info[0].Bal_DP)
                }

                let data = {
                    Srno: 0,
                    Bal_StdWt: parseFloat(result[0][0].Bal_StdWt).toFixed(Dp) + " " + strUnitAccordingDb, // objFormulaFunction.FormatNumberString(result[0][0].Bal_StdWt,tempBalace.balance_info[0].Bal_DP)
                    Bal_NegTol: parseFloat(result[0][0].Bal_NegTol).toFixed(Dp) + " " + strUnitAccordingDb,
                    Bal_PosTol: parseFloat(result[0][0].Bal_PosTol).toFixed(Dp) + " " + strUnitAccordingDb,
                }
                var objBalRelWt = globalData.arrBalCalibWeights.find(k => k.Hmi == strHmi&& TabIp == TabIp); //get the current wt. 
                if(objBalRelWt != undefined){
                    objBalRelWt.ID = result[0][0].Id
                }
                globalData.arrsendWt.push({ 'Hmi': strHmi,TabIp:TabIp,'BalId': strBalId, 'sendWt': objFormulaFunction.FormatNumberString(result[0][0].Bal_StdWt, tempBalace.balance_info[0].Bal_DP) });
                return Object.assign(resObj, {//{ 'Hmi': strHmi, 'BalId' :  strBalId , 'counter': srNo   objFormulaFunction.FormatNumberString(result[0][0].Bal_StdWt, tempBalace.balance_info[0].Bal_DP}
                    status: 'success',
                    result: data
                });
            }
            else {
                if (tempCounter.counterApi >= result[0].length) {
                    await objMonit.monit({ case: 'CalibDone', Hmi: strHmi, data: { calibType: mqttProtocol.Daily } });

                    (globalData.arrCalibInsertCounter.findIndex((element) => element.Hmi === strHmi&& TabIp == TabIp)) == -1 ? globalData.arrCalibInsertCounter : globalData.arrCalibInsertCounter.splice(globalData.arrCalibInsertCounter.findIndex((element) => element.Hmi === strHmi&& TabIp == TabIp), 1);
                    (globalData.arrcalibType.findIndex((element) => element.DsNo === strHmi&& TabIp == TabIp)) == -1 ? globalData.arrcalibType : globalData.arrcalibType.splice(globalData.arrcalibType.findIndex((element) => element.DsNo === strHmi&& TabIp == TabIp), 1);
                    (globalData.arrCalibCounter.findIndex((element) => element.Hmi === strHmi&& TabIp == TabIp)) == -1 ? globalData.arrCalibCounter : globalData.arrCalibCounter.splice(globalData.arrCalibCounter.findIndex((element) => element.Hmi === strHmi&& TabIp == TabIp), 1);
                    (globalData.arrCalibCounterApi.findIndex((element) => element.Hmi === strHmi&& TabIp == TabIp)) == -1 ? globalData.arrCalibCounterApi : globalData.arrCalibCounterApi.splice(globalData.arrCalibCounterApi.findIndex((element) => element.Hmi === strHmi&& TabIp == TabIp), 1);
                    (globalData.arrsendWt.findIndex((element) => element.Hmi === strHmi&& TabIp == TabIp)) == -1 ? globalData.arrsendWt : globalData.arrsendWt.splice(globalData.arrsendWt.findIndex((element) => element.Hmi === strHmi&& TabIp == TabIp), 1);
                    (globalData.delayApi.findIndex((element) => element.Hmi === strHmi&& TabIp == TabIp)) == -1 ? globalData.delayApi : globalData.delayApi.splice(globalData.delayApi.findIndex((element) => element.Hmi === strHmi&& TabIp == TabIp), 1);
                    await models.tbl_powerbackup.destroy({
                        where: {
                            WeighmentName: 'DAILY',
                            DsNo: strHmi,
                            TabIp:TabIp
                        }
                    })
                    await objMonit.monit({
                        case: 'ReportStatus',
                        Hmi: strHmi,
                        data: {
                            message: 'Daily calibration done'
                        }
                    });
                    return Object.assign(resObj, {
                        status: 'success',
                        message: 'Calibration Successful'
                    });
                }
                let intsendWt = globalData.arrsendWt.find(k => k.Hmi == strHmi&& TabIp == TabIp);
                if (_check_combination !== undefined) {
                    globalData.arrsendWt.push({
                        'Hmi': strHmi,TabIp :TabIp,'BalId': strBalId, 'sendWt': objFormulaFunction.FormatNumberString(result[0][tempCounter.counterApi].Bal_StdWt, tempBalace.balance_info[0].Bal_DP)
                    }
                    )
                    intsendWt = globalData.arrsendWt.find(k => k.Hmi == strHmi&& TabIp == TabIp);
                }
                if (intsendWt == undefined) {
                    globalData.arrsendWt.push({ 'Hmi': strHmi,TabIp: TabIp, 'BalId': strBalId, 'sendWt': objFormulaFunction.FormatNumberString(result[0][0].Bal_StdWt, tempBalace.balance_info[0].Bal_DP) });
                }
                else {
                    intsendWt.strBalId = strBalId;
                    intsendWt.sendWt = objFormulaFunction.FormatNumberString(result[0][tempCounter.counterApi].Bal_StdWt, tempBalace.balance_info[0].Bal_DP)
                }
                let data = {
                    Srno: tempCounter.counterApi,
                    Bal_StdWt: parseFloat(result[0][tempCounter.counterApi].Bal_StdWt).toFixed(Dp) + " " + strUnitAccordingDb,
                    Bal_NegTol: parseFloat(result[0][tempCounter.counterApi].Bal_NegTol).toFixed(Dp) + " " + strUnitAccordingDb,
                    Bal_PosTol: parseFloat(result[0][tempCounter.counterApi].Bal_PosTol).toFixed(Dp) + " " + strUnitAccordingDb,
                }               
                 var objBalRelWt = globalData.arrBalCalibWeights.find(k => k.Hmi == strHmi&& TabIp == TabIp); //get the current wt. 
                if(objBalRelWt != undefined){
                    objBalRelWt.ID = result[0][tempCounter.counterApi].Id
                }else{
                    objBalRelWt.ID = result[0][tempCounter.counterApi].Id
                }
                return Object.assign(resObj, {
                    status: 'success',
                    result: data
                });
            }


            // }
        } catch (err) {
            console.log("Error from getCalibWeights of Daily", err)
            return `Error from getCalibWeights of Daily ${err}`;
        }
    }
    //**************************************************************************************************************** */
    // Below function verifies recived weights is in range of tolerences and stores in database as in given situation
    // Also send next weights for calibrations
    //**************************************************************************************************************** */
    async verifyWeights(str_Protocol, strResberryPi, ProtocolData, ProtocolDecPoint,TabIp) {
        try {
            let tempstrResPiNo = strResberryPi;
            let strHmi = strResberryPi
            var TabIp = TabIp
            strResberryPi = strResberryPi
            let removeBalOfThatHmi = globalData.arrSelectedBalWithHmi.find(k => k.DsNo == strHmi && k.TabIp == TabIp);
            let strBalId = removeBalOfThatHmi.selectedBal;
            let now = new Date();
            var str_ProtocolData = str_Protocol;
            str_ProtocolData.split(':');
            let ProtocolName = str_ProtocolData.split(":")[0];
            let ProtocolPortNo = str_ProtocolData.split(":")[1];
            let resObj = {};
            let data = str_ProtocolData.split(":");
            var new_string = data[2].substr(data[2].search(/\d/));
            new_string = new_string.trim();
            let ProtocolDataAndUnit = new_string.split(" ");
            let recieveWt = ProtocolData;
            let arrRemoveUnit = ProtocolDataAndUnit.filter(item => item);
            let unit = arrRemoveUnit[1];

            var srNo = 0;
            var insertingDetailCounter = 1;

            var objBalRelWt = globalData.arrBalCalibWeights.find(k => k.Hmi == strHmi&& k.TabIp == TabIp); //get the current wt. 
            var cubicaldata =globalData.arrIdsInfo.find(k => k.DsNo == strHmi&& k.TabIp == TabIp) 
            //current send wt
            let tempSendWt = globalData.arrsendWt.find(k => k.Hmi == strHmi&& k.TabIp == TabIp);
            const objSendWt = objBalRelWt.calibWt.find(j => j.Id == parseFloat(objBalRelWt.ID))
            var tempObj = globalData.arrCalibCounter.find(k => k.Hmi == strHmi&& k.TabIp == TabIp);
            var tempDetailCounterObj = globalData.arrCalibInsertCounter.find(k => k.Hmi == strHmi&& k.TabIp == TabIp);
            const tempBalObject = globalData.arrBalance.find(k => k.Hmi == strHmi&& k.TabIp == TabIp);
            let balanceInfo = tempBalObject.balance_info[0];

            let arr = globalData.arrOfBalListWithPortNumber.find(k => k.Hmi == strHmi&& k.TabIp == TabIp).BalList;
            let removeBalType = arr.filter(k => k.BalanceId == balanceInfo.Bal_ID)


            // if (balanceInfo.Bal_Model.includes('MS304TS') && balanceInfo.Bal_Make == 'METTLER TOLEDO') {
            //     let d = str_ProtocolData.slice(str_ProtocolData.indexOf('N') + 1).trim();
            //     let c = d.match(/\(.*?\)/)?.[0] || '';
            //     d = d.replace(c, '').trim();
            //     ProtocolDataAndUnit = d.split(" ").filter(item => item);

            //     // let ProtocolDataAndUnit = new_string.split(" ");
            //     //  recieveWt = ProtocolData;
            //      arrRemoveUnit = ProtocolDataAndUnit.filter(item => item);
            //      recieveWt = arrRemoveUnit[0]
            //      unit = arrRemoveUnit[1];
    
            // }


            var strUnitAccordingDb;

            if (tempBalObject.balance_info[0].Bal_Unit.startsWith('gm')) {
                strUnitAccordingDb = "g";
            } else {
                strUnitAccordingDb = tempBalObject.balance_info[0].Bal_Unit;
            }

            var perferUnit;
            if (unit == undefined) {
                perferUnit = "g";
            } else {
                if (unit.toLowerCase() === "gm" || unit.toLowerCase() === "g")
                    perferUnit = "g";
                else
                    perferUnit = unit.toLowerCase();
            }

            if (strUnitAccordingDb.toLowerCase() !== perferUnit) {
                return mqttSender.sendData(strHmi, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Please Check the Balance Setting`);
            } else {
                if (tempObj === undefined) {
                    globalData.arrCalibCounter.push({ 'Hmi': strHmi,TabIp:TabIp,'BalId': strBalId, 'counter': srNo });
                    //counter for inserting data
                    globalData.arrCalibInsertCounter.push({ 'Hmi': strHmi, TabIp:TabIp,'BalId': strBalId, 'insertingDetailCounter': insertingDetailCounter })
                }
                else {
                    tempObj.BalId = strBalId
                    tempObj.counter = tempObj.counter + 1;

                    tempDetailCounterObj.BalId = strBalId;
                    tempDetailCounterObj.insertingDetailCounter = tempDetailCounterObj.insertingDetailCounter + 1;
                }
            }

            if (parseInt(srNo) <= objBalRelWt.calibWt.length) {
                var intDaily_RepNo;
                // fetching here all necessory information to send the next weight and storing incoming data
                var RepFromPC = "";
                let BalanceRecalibStatusObject;
                if (removeBalType[0].type == "analytical") {
                    BalanceRecalibStatusObject = globalData.arrBalanceRecalibStatus.find(k => k.Bal_ID == strBalId);
                } else {
                    BalanceRecalibStatusObject = globalData.arrBalanceRecalibStatusIPC.find(k => k.Bal_ID == strBalId);
                }

                var tempCounter = globalData.arrCalibCounter.find(k => k.Hmi == strHmi && TabIp == TabIp);
                var tempDetailCounterObjInsert = globalData.arrCalibInsertCounter.find(k => k.Hmi == strHmi && TabIp == TabIp);
                const tempUserObject = globalData.arrUsers.find(k => k.DsNo == strHmi && TabIp == TabIp);


                //29/05/22
                var _powerbackupCalib = {
                    strTableName: 'tbl_calibration_daily_master_incomplete',
                    strDetailTbl: 'tbl_calibration_daily_detail_incomplete',
                    cubicaNo: 'NUll',
                    cubicType: 'NUll',
                    cubicSysBFGcode: 'NUll',
                    cubicBatch: 'NUll',
                    menuName: GlobalNomenclature.Daily,
                    productType: 'NUll',
                    Userid: tempUserObject.UserId,
                    idsNo: strHmi,
                    Hmi: strHmi,
                    RecSampleNo: tempCounter.counter,
                    ReportType: 'NUll',
                    _bal_id: strBalId,
                    TabIp:TabIp

                }
                let _check_combination = await objPowerBackup._check_calibration_entry(strHmi,TabIp, _powerbackupCalib, "tbl_powerbackup");
                if (_check_combination !== undefined) {

                    tempCounter.counter = _check_combination.RecSampleNo + 1;
                    if (tempDetailCounterObjInsert.insertingDetailCounter == 1) {
                        tempDetailCounterObjInsert.insertingDetailCounter = tempCounter.counter
                    }
                    _powerbackupCalib.RecSampleNo = tempCounter.counter
                } else {
                    _powerbackupCalib.RecSampleNo = tempCounter.counter + 1;
                }
                await objPowerBackup.get_Calib_Status_oF_Test_ForPowerBackup(_powerbackupCalib);


                var resArrOfDecimal = globalData.glbArrOfDecimal.find(k => k.Hmi == strHmi && TabIp == TabIp);
                if (resArrOfDecimal == undefined) {

                    globalData.glbArrOfDecimal.push({
                        Hmi: strHmi,
                        TabIp:TabIp,
                        decimalPoint: ProtocolDecPoint
                    })
                }
                else {
                    var resArrOfDecimal1 = globalData.glbArrOfDecimal.find(k => k.Hmi == strHmi && TabIp == TabIp);
                    if (resArrOfDecimal1.decimalPoint >= ProtocolDecPoint) {
                        resArrOfDecimal1.decimalPoint = resArrOfDecimal1.decimalPoint;
                    } else {
                        resArrOfDecimal1.decimalPoint = ProtocolDecPoint;
                    }
                }
                var select_certi_vali = await models.tbl_precalibration_daily.findAll({
                    attributes:['CalibrationBox_ID','CalibrationBox_Validity_Date','CalibrationBox_Calibration_CertificateNo'],
                    where: {
                        'Equipment_ID': strBalId,
                        'Equipment_Type': removeBalType[0].type == "analytical" ? "Balance" : "IPC Balance"
                    }
                })
                var periodic_precalib_certi = select_certi_vali;
                var weight_cer_id = "";
                var weight_cer_id_vali = "";
                var result_certificate = "";
                var result_certificate_vali = "";
                for (let i of periodic_precalib_certi) {
                    weight_cer_id = i.CalibrationBox_Calibration_CertificateNo.split(',')
                    for(let j = 0 ;j<= weight_cer_id.length;j++){
                       if(result_certificate == ''){
                        result_certificate = result_certificate + weight_cer_id[j] ;
                       }else{
                           if(weight_cer_id[j] != undefined){
                        if(!result_certificate.includes(weight_cer_id[j])){
                            result_certificate = result_certificate + "," + weight_cer_id[j];
                         }
                        }
                       }
                    }
                    for(let j = 0 ;j<= weight_cer_id_vali.length;j++){
                        weight_cer_id_vali = i.CalibrationBox_Validity_Date.split(',')
                       if(result_certificate_vali == ''){
                        result_certificate_vali = result_certificate_vali + weight_cer_id_vali[j] ;
                       }else{
                           if(weight_cer_id_vali[j] != undefined){
                        if(!result_certificate_vali.includes(weight_cer_id_vali[j])){
                            result_certificate_vali = result_certificate_vali + "," + weight_cer_id_vali[j];
                         }
                        }
                       }
                    }

                }
                let Dp = serverConfig.plant != 'FT03' ? 4 : 3;
                var selectPrecalibSelWtObj = await models.tbl_precalibration_daily.findAll({
                    attributes:[
                        [sequelize.fn('DISTINCT', sequelize.col('CalibrationBox_ID')) ,'CalibrationBox_ID'],
                
                       ],
                    where: {
                        'Equipment_ID': strBalId,
                        // 'UID': objSendWt.Id,
                        // 'Standard_Weight_Block': objSentWt.Bal_StdWt,
                        'Equipment_Type': removeBalType[0].type == "analytical" ? "Balance" : "IPC Balance"
                    }
                })

                var result1 = selectPrecalibSelWtObj
                // var calbox = await models.tbl_calibrationbox.findAll({
                //     where: {
                //         'CB_ID': result1[0].CalibrationBox_ID,
                //         'CB_Wt': result1[0].Standard_Weight_Block,
                //     }
                // })
                // var rescalbox = calbox
                var periodic_precalib_weights = result1;
                var weight_box_id = "";
                var result_weightboc = "";
                for (let i of periodic_precalib_weights) {
                    weight_box_id = i.CalibrationBox_ID.split(',')
                    for(let j = 0 ;j<= weight_box_id.length;j++){
                       if(result_weightboc == ''){
                        result_weightboc = result_weightboc + weight_box_id[j] ;
                       }else{
                           if(weight_box_id[j] != undefined){
                        if(!result_weightboc.includes(weight_box_id[j])){
                            result_weightboc = result_weightboc + "," + weight_box_id[j];
                         }
                        }
                       }
                    }

                }


                if (parseInt(tempCounter.counter) == 0) {

                    /** code for storing all the wgt in column of std wgt ,neg tol and pos tol */
                    var combineStdWt = "";
                    var combineLowerLimit = "";
                    var combineUpperLimit = "";
                    var combineTolernace = "";
                    var minimumVal;
                    var maximumval;
                    for (let i of objBalRelWt.calibWt) {
                        combineStdWt = combineStdWt + Number(i.Bal_StdWt).toFixed(Dp) + ",";
                        combineLowerLimit = combineLowerLimit + Number(i.Bal_NegTol).toFixed(Dp) + ",";
                        combineUpperLimit = combineUpperLimit + Number(i.Bal_PosTol).toFixed(Dp) + ",";
                        minimumVal = i.Bal_StdWt - i.Bal_NegTol,
                            maximumval = i.Bal_PosTol - i.Bal_StdWt
                            if (Number(minimumVal).toFixed(Dp) == Number(maximumval).toFixed(Dp)) {
                                combineTolernace = combineTolernace + '± ' + minimumVal.toFixed(Dp) + ",";
                            } else {
                                combineTolernace = combineTolernace + '- ' + minimumVal.toFixed(Dp) + ' + ' + maximumval.toFixed(Dp) + ",";
                            }


                    }
                    combineStdWt = combineStdWt.slice(0, -1);
                    
                    combineLowerLimit = combineLowerLimit.slice(0, -1);
                    
                    combineUpperLimit = combineUpperLimit.slice(0, -1);
                  
                    var resulCubicleNo = await objClsInsertOp.getCubicalData(strResberryPi);

                    // Inserting entries in master table for daily calibration
                    // Object for inserting data for Incommplete master
                    var Daily_CalibChange = await models.tbl_calibration_daily_master.findAll({
                        attributes: [
                            [sequelize.fn('max', sequelize.col('Daily_CalibChange')), "Daily_CalibChange"]

                        ],
                        where: {
                            "Daily_BalID": balanceInfo.Bal_ID
                        },
                        raw: true
                    })
                    if (Daily_CalibChange[0].Daily_CalibChange == null) {
                        Daily_CalibChange[0].Daily_CalibChange = 0
                    }
                    if (balanceInfo.Bal_ChangeWt == 1) {
                        Daily_CalibChange[0].Daily_CalibChange = Daily_CalibChange[0].Daily_CalibChange + 1
                    }
                    let result = await models.tbl_calibration_daily_master_incomplete.create({
                        'Daily_CalbDate': moment().format('YYYY-MM-DD'),
                        'Daily_CalbTime': moment().format('HH:mm:ss'),
                        'Daily_BalID': balanceInfo.Bal_ID,
                        'Daily_BalSrNo': balanceInfo.Bal_SrNo,
                        'Daly_Make': balanceInfo.Bal_Make,
                        'Daily_Model': balanceInfo.Bal_Model,
                        'Daily_Unit': balanceInfo.Bal_Unit,
                        // 'Daily_Dept': resulCubicleNo[0].Sys_dept,
                        'Daily_LeastCnt': balanceInfo.Bal_LeastCnt.toFixed(Dp),
                        'Daily_MaxCap': balanceInfo.Bal_MaxCap.toFixed(Dp),
                        'Daily_MinCap': balanceInfo.Bal_MinCap,
                        'Daily_ZeroError': 0,
                        'Daily_SpiritLevel': 0,
                        'Daily_GeneralCare': 0,
                        'Daily_UserID': tempUserObject.UserId,
                        'Daily_UserName': tempUserObject.UserName,
                        'Daily_PrintNo': 0,
                        'Daily_IsRecalib': BalanceRecalibStatusObject.DailyBalRecalib,
                        'Daily_Location': resulCubicleNo[0].Sys_CubicName =='NULL' ? 'NA' : resulCubicleNo[0].Sys_CubicName,
                        'Daily_CubicalNo': resulCubicleNo[0].Sys_CubicNo,
                        'Daily_Bal_MaxoptRange': Number(balanceInfo.Bal_MaxoptRange).toFixed(Dp),
                        'Daily_Bal_MinoptRange': Number(balanceInfo.Bal_MinoptRange).toFixed(Dp),
                        'Decimal_Point': balanceInfo.Bal_DP,
                        'Daily_RoomNo': resulCubicleNo[0].Sys_RoomNo,
                        'Daily_StdWeight': combineStdWt,
                        'Daily_NegTol': combineLowerLimit,
                        'Daily_PosTol': combineUpperLimit,
                        "Daily_FormNo": balanceInfo.Bal_FormNo,
                        "Daily_VersionNo": balanceInfo.Bal_VersionNo,
                        // "CalibrationStatus": balanceInfo.Bal_Status,
                        'Daily_AllWeightboxID': result_weightboc,
                        'Daily_AllWeightboxCert': result_certificate,
                        'Daily_AllWeightboxValidUpto': result_certificate_vali,
                        "Daily_IsBinBalance": balanceInfo.IsBinBalance,
                        "Daily_CalibChange": Daily_CalibChange[0].Daily_CalibChange,
                        "Daily_Pattern": "Circular/Square/Rectangular",
                        "Daily_FormNo": balanceInfo.Bal_FormNo,
                        "Daily_VersionNo": balanceInfo.Bal_VersionNo,
                        "Daily_Status": balanceInfo.Bal_Status,
                        "Daily_Remark": "Not OK",
                        "Tolerance": combineTolernace,
                        "Daily_Dept": resulCubicleNo[0].Sys_CubType =='NULL' ? 'NA' : resulCubicleNo[0].Sys_CubType,
                        "Daily_Bal_Cert_No":balanceInfo.Bal_Cert_No,
                        "Inprocess" : 1
                    })
                    var result1 = await models.tbl_precalibration_daily.findAll({
                        where: {
                            'Equipment_ID': strBalId,
                            'Standard_Weight_Block': objSendWt.Bal_StdWt,
                            'Equipment_Type': removeBalType[0].type == "analytical" ? "Balance" : "IPC Balance"
                        }
                    })

                    const daily_precalib_weight = result1[0];
                    // Inserting 1st weight data in  tbl_calibration_periodic_detail_incomplete
                    // Inserting data in databse 
                    // intDaily_RepNo is Last inserted Id
                    intDaily_RepNo = result.Daily_RepNo;
                    // selecting data from precalibSelectedWeights
                    // Object for inserting in incomplete detail
                    await models.tbl_calibration_daily_detail_incomplete.create({
                        'Daily_RepNo': intDaily_RepNo,
                        'Daily_RecNo': 1,
                        [`Daily_BalStdWt${tempDetailCounterObjInsert.insertingDetailCounter}`]: objSendWt.Bal_StdWt, //objSentWt
                        [`Daily_BalNegTol${tempDetailCounterObjInsert.insertingDetailCounter}`]: objSendWt.Bal_NegTol,
                        [`Daily_BalPosTol${tempDetailCounterObjInsert.insertingDetailCounter}`]: objSendWt.Bal_PosTol,
                        [`Daily_ActualWt${tempDetailCounterObjInsert.insertingDetailCounter}`]: Number(recieveWt).toFixed(Dp),
                        [`Daily_StdWtBoxID${tempDetailCounterObjInsert.insertingDetailCounter}`]: daily_precalib_weight.CalibrationBox_ID,
                        [`Daily_StdWtIDNo${tempDetailCounterObjInsert.insertingDetailCounter}`]: daily_precalib_weight.CalibrationBox_Elements_IDNo,
                        [`Daily_WeightBox_certfctNo${tempDetailCounterObjInsert.insertingDetailCounter}`]: daily_precalib_weight.CalibrationBox_Calibration_CertificateNo,
                        [`Daily_ValDate${tempDetailCounterObjInsert.insertingDetailCounter}`]: daily_precalib_weight.CalibrationBox_Validity_Date,
                        [`Daily_StdWt${tempDetailCounterObjInsert.insertingDetailCounter}`]: daily_precalib_weight.CalibrationBox_Selected_Elements,
                        [`PercentofCapacity${tempDetailCounterObjInsert.insertingDetailCounter}`]: 0,
                        [`Decimal_Point`]: ProtocolDecPoint
                    },
                    )
                    await models.tbl_powerbackup.update({
                        Incomp_RepSerNo: intDaily_RepNo
                    }, {
                        where: {
                            DsNo: strHmi,
                            TabIp:TabIp
                        }
                    });
                    var objSentWtBal_StdWt = parseFloat(objSendWt.Bal_StdWt).toFixed(Dp);

                    var objDelay = globalData.delayApi.find(k => k.Hmi == strHmi &&  TabIp == TabIp)
                    if (objDelay == undefined) {
                        globalData.delayApi.push({
                            Flag: 1,
                            Hmi: strHmi,
                            TabIp:TabIp
                        })
                    }
                    var objActivity = {};
                    Object.assign(objActivity,
                        { strUserId: tempUserObject.UserId },
                        { strUserName: tempUserObject.UserName },
                        { activity: `${GlobalNomenclature.Daily} Calibration Started On TSH ` + strHmi }
                    );
                    await objActivityLog.ActivityLogEntry(objActivity);
                    await objInstrumentUsage.InstrumentUsage('Balance', strHmi, 'tbl_instrumentlog_balance', 'Daily Calibration', 'started',TabIp,tempUserObject, cubicaldata);

                } else {

                    var Daily_RecNo1;

                    var resultRepserNo = await models.tbl_calibration_daily_master_incomplete.findAll({
                        attributes: [[sequelize.fn('max', sequelize.col('Daily_RepNo')), "Daily_RepNo"]],
                        where: {
                            "Daily_BalID": strBalId
                        },
                        raw: true
                    })



                    let intDaily_RepNo = resultRepserNo[0].Daily_RepNo;

                    var resultRecNo = await models.tbl_calibration_daily_detail_incomplete.findAll({
                        attributes: [
                            [sequelize.fn('max', sequelize.col('Daily_RecNo')), "Daily_RecNo"]

                        ],
                        where: {
                            "Daily_RepNo": intDaily_RepNo
                        },
                        raw: true
                    })

                    const Daily_RecNo = resultRecNo[0].Daily_RecNo;
                    Daily_RecNo1 = Daily_RecNo + 1;

                    var resultpre = await models.tbl_precalibration_daily.findAll({
                        where: {
                            'Equipment_ID': strBalId,
                            'Standard_Weight_Block': objSendWt.Bal_StdWt,
                            'Equipment_Type': removeBalType[0].type == "analytical" ? "Balance" : "IPC Balance"
                        }
                    })
                    const daily_precalib_weight = resultpre[0]



                    await models.tbl_calibration_daily_detail_incomplete.update({
                        [`Daily_BalStdWt${tempDetailCounterObjInsert.insertingDetailCounter}`]: objSendWt.Bal_StdWt, //objSentWt
                        [`Daily_BalNegTol${tempDetailCounterObjInsert.insertingDetailCounter}`]: objSendWt.Bal_NegTol,
                        [`Daily_BalPosTol${tempDetailCounterObjInsert.insertingDetailCounter}`]: objSendWt.Bal_PosTol,
                        [`Daily_ActualWt${tempDetailCounterObjInsert.insertingDetailCounter}`]: Number(recieveWt).toFixed(Dp),
                        [`Daily_StdWtBoxID${tempDetailCounterObjInsert.insertingDetailCounter}`]: daily_precalib_weight.CalibrationBox_ID,
                        [`Daily_StdWtIDNo${tempDetailCounterObjInsert.insertingDetailCounter}`]: daily_precalib_weight.CalibrationBox_Elements_IDNo,
                        [`Daily_WeightBox_certfctNo${tempDetailCounterObjInsert.insertingDetailCounter}`]: daily_precalib_weight.CalibrationBox_Calibration_CertificateNo,
                        [`Daily_ValDate${tempDetailCounterObjInsert.insertingDetailCounter}`]: daily_precalib_weight.CalibrationBox_Validity_Date,
                        [`Daily_StdWt${tempDetailCounterObjInsert.insertingDetailCounter}`]: daily_precalib_weight.CalibrationBox_Selected_Elements,
                        [`PercentofCapacity${tempDetailCounterObjInsert.insertingDetailCounter}`]: 0,
                    }, {
                        where: {
                            "Daily_RepNo": intDaily_RepNo
                        }
                    }
                    );

                    var objSentWtBal_StdWt = parseFloat(objSendWt.Bal_StdWt).toFixed(Dp);

                }


                let hmiEntryinConfig = globalData.arrConfigSettings.find(k => k.DsNo == strHmi&&  TabIp == TabIp).configSetting;
                let autoTare = hmiEntryinConfig[0].AutoTare;
                let tareCommand = hmiEntryinConfig[0].Tare_Command.concat(`\r\n`);

                if (objSendWt.Bal_NegTol <= parseFloat(recieveWt) && (parseFloat(recieveWt) <= objSendWt.Bal_PosTol)) {
                    mqttSender.sendData(strHmi, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayResult}${_powerbackupCalib.RecSampleNo}:${Number(objSentWtBal_StdWt).toFixed(Dp) + " " + strUnitAccordingDb}:${Number(recieveWt).toFixed(Dp) + " " + perferUnit}`);
                    if (autoTare) {
                        mqttSender.sendData(strHmi, `Port ${ProtocolPortNo}:${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`);
                    }
                    await objMonit.monit({ case: 'CalibWeight', Hmi: strHmi, data: { Weight: recieveWt } });

                    if (parseInt(tempCounter.counter) == objBalRelWt.calibWt.length) {
                        let tempC = globalData.arrCalibCounterApi.find(k => k.Hmi == strHmi && TabIp == TabIp);
                        tempC.counterApi = tempC.counterApi + 1;

                        //remove max decimal from globalData.glbArrOfDecimal
                        var removedArrOfDecimal = globalData.glbArrOfDecimal.find(k => k.Hmi == strHmi && TabIp == TabIp);
                        let decimalNumber = removedArrOfDecimal.decimalPoint;
                        let result = await models.tbl_calibration_daily_master_incomplete.findAll({
                            attributes: [[sequelize.fn('max', sequelize.col('Daily_RepNo')), "Daily_RepNo"]],
                            where: {
                                "Daily_BalID": strBalId
                            }
                        });

                        let intDaily_RepNo = result[0].Daily_RepNo;

                        result = await models.tbl_calibration_daily_master_incomplete.update({
                            "Decimal_Point": decimalNumber
                        }, {
                            where: {
                                "Daily_RepNo": intDaily_RepNo
                            }
                        })


                        globalData.glbArrOfDecimal.splice(globalData.glbArrOfDecimal.findIndex((element) => element.Hmi === strHmi && TabIp == TabIp), 1)
                        //end update

                        await this.saveToCompleteTable(strBalId, strHmi);
                        if (balanceInfo.Bal_ChangeWt == 1) {
                        await models.tbl_balance.update({
                            Bal_ChangeWt:0},{where:{'Bal_ID': strBalId}
                        });
                    }
                        await models.tbl_powerbackup.destroy({
                            where: {
                                WeighmentName: GlobalNomenclature.Daily,
                                DsNo: strHmi,
                                TabIp:TabIp
                            }
                        });
                        var objActivity = {};
                        Object.assign(objActivity,
                            { strUserId: tempUserObject.UserId },
                            { strUserName: tempUserObject.UserName },
                            { activity: `${GlobalNomenclature.Daily} Calibration Completed On TSH ` + strHmi }
                        );
                        await objActivityLog.ActivityLogEntry(objActivity);
                        await objInstrumentUsage.InstrumentUsage('Balance', strHmi, 'tbl_instrumentlog_balance', '', 'completed',TabIp,tempUserObject, cubicaldata);

                        BalanceRecalibStatusObject.DailyBalRecalib = 0;
                        return mqttSender.sendData(strHmi, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage} Calibration Successful`);
                    }
                    else {
                        var tempCounter = globalData.arrCalibCounterApi.find(k => k.Hmi == strHmi && TabIp == TabIp);
                        tempCounter.counterApi = tempCounter.counterApi; //{ 'Hmi': strHmi, 'BalId' :  strBalId , 'counterApi': srNo }
                    }
                } else {
                    (globalData.arrCalibInsertCounter.findIndex((element) => element.Hmi === strHmi&& TabIp == TabIp)) == -1 ? globalData.arrCalibInsertCounter : globalData.arrCalibInsertCounter.splice(globalData.arrCalibInsertCounter.findIndex((element) => element.Hmi === strHmi&& TabIp == TabIp), 1);
                    (globalData.arrCalibCounterApi.findIndex((element) => element.Hmi === strHmi&& TabIp == TabIp)) == -1 ? globalData.arrCalibCounterApi : globalData.arrCalibCounterApi.splice(globalData.arrCalibCounterApi.findIndex((element) => element.Hmi === strHmi&& TabIp == TabIp), 1);
                    (globalData.arrCalibCounter.findIndex((element) => element.Hmi === strHmi&& TabIp == TabIp)) == -1 ? globalData.arrCalibCounter : globalData.arrCalibCounter.splice(globalData.arrCalibCounter.findIndex((element) => element.Hmi === strHmi&& TabIp == TabIp), 1);
                    globalData.arrCurrentOperationStatus.findIndex(k => k.Hmi === strHmi&& TabIp == TabIp) == -1 ? globalData.arrCurrentOperationStatus : globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex(k => k.Hmi === strHmi&& TabIp == TabIp), 1)
                        (globalData.arrcalibType.findIndex((element) => element.DsNo === strHmi&& TabIp == TabIp)) == -1 ? globalData.arrcalibType : globalData.arrcalibType.splice(globalData.arrcalibType.findIndex((element) => k.DsNo === strHmi&& TabIp == TabIp), 1)
                            (globalData.delayApi.findIndex((element) => element.Hmi === strHmi&& TabIp == TabIp)) == -1 ? globalData.delayApi : globalData.delayApi.splice(globalData.delayApi.findIndex((element) => element.Hmi === strHmi&& TabIp == TabIp), 1);

                    await models.tbl_powerbackup.destroy({
                        where: {
                            WeighmentName: GlobalNomenclature.Daily,
                            DsNo: strHmi,
                            TabIp:TabIp
                        }
                    })
                    await models.tbl_calibration_daily_master_incomplete.update ({
                        "Inprocess" : 0,},{where:{'Daily_BalID': strBalId}
                    })
                    await models.tbl_balance.update({
                        "IsNewBalance": 0
                    }, {
                        where: {
                            "Bal_ID": strBalId
                        }
                    });
                    var objActivity = {};
                    Object.assign(objActivity,
                        { strUserId: tempUserObject.UserId },
                        { strUserName: tempUserObject.UserName },
                        { activity: `${mqttProtocol.Daily} Calibration Failed on TSH ${strHmi}` }
                    );
                    await objActivityLog.ActivityLogEntry(objActivity);
                    mqttSender.sendData(strHmi, `Port ${ProtocolPortNo}:DisplayResult:${_powerbackupCalib.RecSampleNo}:${Number(objSentWtBal_StdWt).toFixed(Dp) + " " + strUnitAccordingDb}:${Number(recieveWt).toFixed(Dp) + " " + perferUnit}:Calibration Failed`);
                    if (autoTare) {
                        mqttSender.sendData(strHmi, `Port ${ProtocolPortNo}:${mqttProtocol.ComWrite}${ProtocolPortNo}:${tareCommand}`);
                    }
                }

            }

        } catch (error) {
            throw new Error(error)
        }



    }
    // **************************************************************************************//
    // Asynchronous function for storing data from incomplete to complete daily tables and 
    // deleting entries from incomplete tables
    //************************************************************************************** */
    async saveToCompleteTable(strBalId, strHmi) {
        let oldRepSrNo = await this.getRepSrNo(strBalId);
        await this.copyFromIncomleteToCompleteMaster(oldRepSrNo, strHmi, strBalId);
        await this.deleteEntriesFromIncomplete(oldRepSrNo);
        await this.UpdateRecalibFLagDaily(strBalId);
    }
    //*************************************************************************************** */
    // getting repSrNo for incomplete tables
    //************************************************************************************** */
    async getRepSrNo(strBalId) {
        try {

            let result = await models.tbl_calibration_daily_master_incomplete.findAll({
                attributes: [
                    [sequelize.fn('max', sequelize.col('Daily_RepNo')), 'Daily_RepNo'],

                ],
                where: {
                    "Daily_BalID": strBalId
                },

            })

            return result[0].Daily_RepNo

        } catch (error) {
            throw new Error(error)
        }
    }
    //****************************************************************************************** */
    // Copyind data from incomplte daily table to complete tables
    // Condition  - Column name of both column must be same
    //********************************************************************************************* */
    async copyFromIncomleteToCompleteMaster(oldRepSrNo, strHmi, strBalId) {
        try {
            const copyMasterObj = {
                fromCopyTblName: 'tbl_calibration_daily_master_incomplete',
                toCopyTableName: 'tbl_calibration_daily_master',
                data: [
                    { str_colName: 'Daily_CalbDate' },
                    { str_colName: 'Daily_CalbTime' },
                    { str_colName: 'Daily_BalID' },
                    { str_colName: 'Daily_BalSrNo' },
                    { str_colName: 'Daly_Make' },
                    { str_colName: 'Daily_Model' },
                    { str_colName: 'Daily_Unit' },
                    { str_colName: 'Daily_Dept' },
                    { str_colName: 'Daily_LeastCnt' },
                    { str_colName: 'Daily_MaxCap' },
                    { str_colName: 'Daily_MinCap' },
                    { str_colName: 'Daily_ZeroError' },
                    { str_colName: 'Daily_SpiritLevel' },
                    { str_colName: 'Daily_GeneralCare' },
                    { str_colName: 'Daily_UserID' },
                    { str_colName: 'Daily_UserName' },
                    { str_colName: 'Daily_VerifyID' },
                    { str_colName: 'Daily_VerifyName' },
                    { str_colName: 'Daily_PrintNo' },
                    { str_colName: 'Daily_Reason' },
                    { str_colName: 'Daily_IsRecalib' },
                    { str_colName: 'Daily_Location' },
                    { str_colName: 'Daily_CubicalNo' },
                    { str_colName: 'Daily_Bal_MaxoptRange' },
                    { str_colName: 'Daily_Bal_MinoptRange' },
                    { str_colName: 'Decimal_Point' },
                    { str_colName: 'Daily_RoomNo' },
                    { str_colName: 'Daily_StdWeight' },
                    { str_colName: 'Daily_NegTol' },
                    { str_colName: 'Daily_PosTol' },
                    { str_colName: 'Daily_FormNo' },
                    { str_colName: 'Daily_VersionNo' },
                    { str_colName: 'Daily_Status' },
                    { str_colName: 'Daily_Remark' },
                    { str_colName: 'Tolerance' },
                    { str_colName: 'Daily_Pattern' },
                    { str_colName: 'Daily_CalibChange' },
                    { str_colName: 'Daily_AllWeightboxID' },
                    { str_colName: 'Daily_AllWeightboxCert' },
                    { str_colName: 'Daily_AllWeightboxValidUpto' },
                    { str_colName: 'Daily_Bal_Cert_No' },

                ],
                condition: [
                    { str_colName: 'Daily_RepNo', value: oldRepSrNo }
                ]
            }
            const copyDetailObj = {
                fromCopyTblName: 'tbl_calibration_daily_detail_incomplete',
                toCopyTableName: 'tbl_calibration_daily_detail',
                data: [
                    { str_colName: 'Daily_RecNo' }, { str_colName: 'Daily_BalStdWt1' },
                    { str_colName: 'Daily_BalNegTol1' }, { str_colName: 'Daily_BalPosTol1' },
                    { str_colName: 'Daily_ActualWt1' }, { str_colName: 'Daily_StdWtBoxID1' },
                    { str_colName: 'Daily_StdWtIDNo1' }, { str_colName: 'Daily_WeightBox_certfctNo1' },
                    { str_colName: 'Daily_ValDate1' }, { str_colName: 'Daily_StdWt1' },
                    { str_colName: 'PercentofCapacity1' }, { str_colName: 'Daily_BalStdWt2' },
                    { str_colName: 'Daily_BalNegTol2' }, { str_colName: 'Daily_BalPosTol2' },
                    { str_colName: 'Daily_ActualWt2' }, { str_colName: 'Daily_StdWtBoxID2' },
                    { str_colName: 'Daily_StdWtIDNo2' }, { str_colName: 'Daily_StdWt2' },
                    { str_colName: 'Daily_WeightBox_certfctNo2' }, { str_colName: 'Daily_ValDate2' },
                    { str_colName: 'PercentofCapacity2' }, { str_colName: 'Daily_BalStdWt3' },
                    { str_colName: 'Daily_BalNegTol3' }, { str_colName: 'Daily_BalPosTol3' },
                    { str_colName: 'Daily_ActualWt3' },
                    { str_colName: 'Daily_StdWtBoxID3' }, { str_colName: 'Daily_StdWtIDNo3' },
                    { str_colName: 'Daily_StdWt3' }, { str_colName: 'Daily_WeightBox_certfctNo3' },
                    { str_colName: 'Daily_ValDate3' }, { str_colName: 'PercentofCapacity3' },
                    { str_colName: 'Daily_BalStdWt4' }, { str_colName: 'Daily_BalNegTol4' },
                    { str_colName: 'Daily_BalPosTol4' }, { str_colName: 'Daily_ActualWt4' },
                    { str_colName: 'Daily_StdWtBoxID4' }, { str_colName: 'Daily_StdWtIDNo4' },
                    { str_colName: 'Daily_StdWt4' }, { str_colName: 'PercentofCapacity4' },
                    { str_colName: 'Daily_WeightBox_certfctNo4' }, { str_colName: 'Daily_ValDate4' },
                    { str_colName: 'Daily_BalStdWt5' }, { str_colName: 'Daily_BalNegTol5' },
                    { str_colName: 'Daily_BalPosTol5' }, { str_colName: 'Daily_ActualWt5' },
                    { str_colName: 'Daily_StdWtBoxID5' }, { str_colName: 'Daily_StdWtIDNo5' },
                    { str_colName: 'Daily_StdWt5' }, { str_colName: 'PercentofCapacity5' },
                    { str_colName: 'Daily_WeightBox_certfctNo5' }, { str_colName: 'Daily_ValDate5' },
                    { str_colName: 'Decimal_Point' },

                ],
                condition: [
                    { str_colName: 'Daily_RepNo', value: oldRepSrNo }
                ]
            }

            let columNames = copyMasterObj.data.map(obj => obj.str_colName).toString();
            var str_Query = `insert into tbl_calibration_daily_master (${columNames}) select ${columNames} from tbl_calibration_daily_master_incomplete where Daily_RepNo = ${oldRepSrNo}`
            let masterInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
            columNames = copyDetailObj.data.map(obj => obj.str_colName).toString();
            str_Query = `insert into tbl_calibration_daily_detail (${columNames}) select ${columNames} from tbl_calibration_daily_detail_incomplete where Daily_RepNo = ${oldRepSrNo}`
            let detailInsert = await sequelize.query(str_Query, { type: QueryTypes.INSERT })
            let findrep = await models.tbl_calibration_daily_master.findAll({
                attributes: [[sequelize.fn('max', sequelize.col('Daily_RepNo')), 'Daily_RepNo']],
                where: {
                    Daily_BalID: strBalId
                }
            })
            findrep = findrep[0].Daily_RepNo
            await models.tbl_calibration_daily_master.update({
                "Daily_Remark": 'OK'
            }, {
                where: {
                    Daily_RepNo: findrep
                }
            });
            await models.tbl_calibration_daily_detail.update({
                "Daily_RepNo": findrep
            }, {
                where: {
                    SeqNo: findrep
                }
            })

            return { activity: 'Daily Calibration Completed on Hmi' + strHmi };
        } catch (error) {
            throw new Error(error)
        }


    }
    //*************************************************************************************************** */
    // Below function deletes the data from incomplete tables (daily)
    //***************************************************************************************************** */
    async deleteEntriesFromIncomplete(oldRepSrNo) {

        await models.tbl_calibration_daily_master_incomplete.destroy({
            where: {
                "Daily_RepNo": oldRepSrNo
            }
        })
        await models.tbl_calibration_daily_detail_incomplete.destroy({
            where: {
                "Daily_RepNo": oldRepSrNo
            }
        })

    }
    //***************************************************************************************************8 */
    //Below function is to update the Recalibration flag of Daily
    //****************************************************************************************** */
    UpdateRecalibFLagDaily(strBalId) {


        models.tbl_recalibration_balance_status.update({
            'DailyBalRecalib': 0,
            'RecalibSetDt_daily': null,
        }, {
            where: {
                "Bal_ID": strBalId
            }
        })

    }

    async RaspberryDetailsWithHmi(strRasPi) {
        try {
            const obj = {
                str_tableName: 'tbl_idsport_details',
                data: '*',
                condition: [
                    { str_colName: 'Sys_IDSNo', value: strRasPi }
                ]
            }

            let arrRes = await database.select(obj);
            return arrRes[0][0].HMI
        } catch (error) {
            throw new Error(error)
        }
    }

    async precision(a) {
        if (!isFinite(a)) return 0;
        var e = 1, p = 0;
        while (Math.round(a * e) / e !== a) { e *= 10; p++; }
        return p;
    }
    async checkAllWeighAssing(Daily, Linearity, Uncertainty, Repetability) {
        // if(Daily.length == 3 && Linearity.length == 5 && Uncertainty.length == 1  && Repetability.length == 1){
        if (
            Daily.length != 5||
            Linearity.length != 9 ||
            Uncertainty.length != 1 ||
            Repetability.length != 1
        ) {
            let Flag = "false";
            return Flag;
        } else if (
            Daily.length == 5 ||
            Linearity.length == 9 ||
            Uncertainty.length == 1 ||
            Repetability.length == 1
        ) {
            let Flag = "false";
            return Flag;
        }
        // }
    }
}

module.exports = CalibrationModel;