

const globalData = require('../../global/globalData');
const Database = require('../../database/clsQueryProcess');
const database = new Database();
const mqttProtocol = require('../../global/GLOBAL_NOMENCLATURE');
const MqttModel = require('../Mqtt/mqttSender.class');
const clsMenu = require('../Menu/MenuRequest.model');
const objMenuRequest = new clsMenu();
const clsHmi = require('../hmiDetail.model');
const sequelize = require('../../../config/dbConnection').sequelize;
const GLOBAL_NOMENCLATURE = require('../../global/GLOBAL_NOMENCLATURE');
const { QueryTypes } = require('sequelize');
const PowerBackup = require("../../Utills/powerBackUp/powerbackup");
const clsCalibCommonOperation = require('../Calibration/clsCalibCommonFunction.model');
const clsActivityLog = require('../clsActivityLog.model');
const objCalibCommonOperation = new clsCalibCommonOperation();

const objHmi = new clsHmi();
const mqttSender = new MqttModel();
const objPowerBackup = new PowerBackup();
const objActivityLog = new clsActivityLog();

const databaseUtill = require('../../Utills/db');
const { models } = require('../../../config/dbConnection');
const { Console } = require('winston/lib/winston/transports');
class IPQC {

    async processIPQC(strIdsIP, AreaSelectedFromIDS = "") {

        // finding area of logged in Ids
        var CubicalData = globalData.arrIdsInfo.find(k => k.idsNo == strIdsIP).cubicalData;
        // var sysArea = CubicalData.Sys_Area;
        var sys_cubType = CubicalData.Sys_cubType;
        if (AreaSelectedFromIDS != "") {
            sys_cubType = AreaSelectedFromIDS;
            var areaRelated = globalData.arrAreaRelated.find(k => k.idsNo == strIdsIP);
            if (areaRelated == undefined) {
                globalData.arrAreaRelated.push({ idsNo: strIdsIP, selectedArea: sys_cubType });
            } else {
                areaRelated.idsNo = strIdsIP;
                areaRelated.selectedArea = sys_cubType;
            }
        }
        var query;
        if (sys_cubType == 'IPQC') {
            /** For RB Project they have single IPQC for All areas. so we are showing all areas IPQC list at one go
        * @description As in database for IPQC i-e SysCubicType = 'IPQC' and SysArea = 'IPQC'
        */
            query = `SELECT * FROM tbl_cubical WHERE 
            Sys_BFGCode != 'NULL' AND Sys_BFGCode != 'None' AND Sys_Batch != 'None'
            AND Sys_Batch != 'NULL' AND Sys_IDSNo != '0' AND Sys_CubType != 'IPC'`;
        } else if (sys_cubType.includes('IPQA') || sys_cubType == 'IPQA') {
            sys_cubType = CubicalData.Sys_IPQCType;
            query = `SELECT * FROM tbl_cubical WHERE (Sys_Area LIKE '${sys_cubType}%'|| Sys_Area LIKE 'IPQA%') 
            AND Sys_BFGCode != 'NULL' AND Sys_BFGCode != 'None' AND Sys_Batch != 'None'
            AND Sys_Batch != 'NULL' AND Sys_IDSNo != '0' AND Sys_CubType != 'IPC'`;
        } else {
            query = `SELECT * FROM tbl_cubical WHERE Sys_Area LIKE '${sys_cubType}%' 
            AND Sys_BFGCode != 'NULL' AND Sys_BFGCode != 'None' AND Sys_Batch != 'None'
            AND Sys_Batch != 'NULL' AND Sys_IDSNo != '0' AND Sys_CubType != 'IPC'`;
        }
        // var result = await databaseUtill.execute(query);

        var result = await sequelize.query(query, {
            type: QueryTypes.SELECT
        });
        //var result = await database.select(selectObj);
        var arrCubicalIPCQ = [];
        var arrCubicleArray = result[0];
        if (arrCubicleArray.length > 0) {
            var strProtocol;
            arrCubicleArray.forEach(element => {
                // strProtocol = element.Sys_CubicNo + ':' + element.Sys_IDSNo + ':' + element.Sys_Batch;
                arrCubicalIPCQ.push({
                    cubicalNo: element.Sys_CubicNo,
                    idsNo: element.Sys_IDSNo,
                    BFGCode: element.Sys_BFGCode,
                    ProdName: element.Sys_ProductName,
                    ProdVersion: element.Sys_PVersion,
                    Version: element.Sys_Version,
                    batch: element.Sys_Batch,
                    area: element.Sys_Area,
                    cubType: element.Sys_CubType
                });
            });
            // strProtocol += ';';
            // var strProtocol1 = await this.areaSelection(strIdsIP);
            let objIPQC = {
                status: 'success',
                arrCubical: arrCubicalIPCQ
            }
            return objIPQC;
        } else {
            //var strProtocol = 'LEP';

            var arrArea = await this.areaSelection(strIdsIP);
            let objArea = {
                result: 'success',
                area: arrArea
            }
            return objArea;
        }
        // return strProtocol;
    }

    /**
     * @param {*} Hmi 
     * @returns get all Cubical Area
     */
    async areaSelection(data) {
        try {
            const dsNo = data.dsNo;
            const tabIp = data.tabIp;
            // var arrResbPiNo = await objHmi.getResbPiNoFromHmi(strHmi);
            // var strIdsNo = arrResbPiNo[0].Sys_IDSNo;
            let arrCubicalArea = [];
            let objArea;
            let arrAllArea = globalData.glbArrCubArea.find(k => k.DsNo == dsNo && k.TabIp == tabIp);

            var result = await models.tbl_cubicle_area.findAll({ where: { Flag: 1 } });
            var result_area = await models.tbl_cubical.findAll({ where: { Sys_DSNumber: dsNo } });

            var arrCubicleArray = result;
            if (arrCubicleArray.length > 0) {
                arrCubicleArray.forEach(element => {
                    if ((element.Area != 'IPQC-I') && (element.Area != 'IPQC-II')) {
                        arrCubicalArea.push(element.Area)
                    }
                });

            } else {
                arrCubicalArea = [];
            }
            // if (!arrCubicalArea.includes(result_area[0].Sys_Area) && result_area[0].Sys_CubType != "IPQC") {
            //     arrCubicalArea.push(result_area[0].Sys_Area)
            // }
            if (!arrCubicalArea.includes(result_area[0].Sys_Area)) {
                arrCubicalArea.push(result_area[0].Sys_Area)
            }
            if (arrAllArea == undefined) {
                globalData.glbArrCubArea.push({
                    DsNo: dsNo,
                    TabIp: tabIp,
                    area: arrCubicalArea
                });
            } else {
                arrAllArea.area = arrCubicalArea
            }

            objArea = {
                status: 'success',
                data: arrCubicalArea
            }

            return objArea;

        } catch (err) {
            throw new Error(err);
        }

    }

    async onSelectionOfArea(dataObj) {
        let strHmi = dataObj.Hmi;
        var arrResbPiNo = await objHmi.getResbPiNoFromHmi(strHmi);
        var strIdsNo = arrResbPiNo[0].IDSNo;
        let strSelectedArea = dataObj.Area;

        return await this.processIPQC(strIdsNo, strSelectedArea);

    }

    async selectedList(dataObj) {
        const strDsNo = dataObj.dsNo;
        const userId = dataObj.userId;
        const userName = dataObj.userName;
        const tabIp = dataObj.tabIp;
        const selectedDs = dataObj.selectedDs;
        const selectedDsNo = selectedDs.dsNo
        const selectedBatch = selectedDs.batch
        // var arrResbPiNo = await objHmi.getResbPiNoFromHmi(strHmi);
        // var strIdsNo = arrResbPiNo[0].IDSNo;

        // Need to check IP
        /*
        var tempArrRightsObj = globalData.arrUserRights.find(k => k.Hmi == strHmi);
        if (tempArrRightsObj != undefined) {
            if (tempArrRightsObj.length != 0) {
                globalData.arrUserRights.splice(0, tempArrRightsObj.length)
            }
        }
        */
        // Need to check IP

        // var arrHmiNo = await objHmi.getHmiNoFromResbPi(selectedList.idsNo);
        // var arrHmiNo = await objHmi.getHmiNoFromResbPi(selectedIdsNo);
        // var selectedHmi = await arrHmiNo;
        /*
        PowerBakcup not implemented
        let _check_changePowerbackup = await models.tbl_powerbackup.findAll({
            where: {
                IdsNo: strHmi,
            }
        })
        if (_check_changePowerbackup.length != 0) {
            if (_check_changePowerbackup[0].WeighmentName == "FRIAB" && _check_changePowerbackup[0].SelectedIds != selIds) {
                let _check_changePowerbackupdestroy = await models.tbl_powerbackup.destroy({
                    where: {
                        Idsno: strHmi,
                        WeighmentName: "FRIAB"
                    }
                });
                await objActivityLog.ActivityLogEntry({
                    strUserId: userId,
                    strUserName: userName,
                    activity: `${_check_changePowerbackup[0].WeighmentName} Test Discarded on IDS ${strHmi}`
                });
                console.log(`Change area Friab on ${strHmi}`)
                globalData.arrWeighmentProductData.findIndex(k => k.Hmi == strHmi) == -1 ?
                    globalData.arrWeighmentProductData :
                    globalData.arrWeighmentProductData.splice(globalData.arrWeighmentProductData.findIndex(k => k.Hmi == strHmi), 1);

                globalData.arrProductTypeArray.findIndex(k => k.Hmi == strHmi) == -1 ?
                    globalData.arrProductTypeArray :
                    globalData.arrProductTypeArray.splice(globalData.arrProductTypeArray.findIndex(k => k.Hmi == strHmi), 1);

                // globalData.arrWeighmentCounterForFriab.findIndex(k => k.Hmi == strHmi) == -1 ?
                //     globalData.arrWeighmentCounterForFriab :
                //     globalData.arrWeighmentCounterForFriab.splice(globalData.arrWeighmentCounterForFriab.findIndex(k => k.Hmi == strHmi), 1);

                (globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCurrentOperationStatus :
                    globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi), 1);
                //test splice if rotarty is not double
                globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi) == -1 ?
                    globalData.arrSelectedMenu :
                    globalData.arrSelectedMenu.splice(globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi), 1);

                globalData.arrWeighmentCounterAfter.findIndex(k => k.Hmi == strHmi) == -1 ?
                    globalData.arrWeighmentCounterAfter :
                    globalData.arrWeighmentCounterAfter.splice(globalData.arrWeighmentCounterAfter.findIndex(k => k.Hmi == strHmi), 1);
                globalData.DoubSideForFriab.findIndex(k => k.Hmi == strHmi) == -1 ? globalData.DoubSideForFriab : globalData.DoubSideForFriab.splice(globalData.DoubSideForFriab.findIndex(k => k.Hmi == strHmi), 1);
            }
        }

        let _check_PowerBackupEntry = await models.tbl_powerbackup.findAll({
            where: {
                Idsno: selIds,
                Sys_Batch: Batch
            }
        })
        */


        let objMenu = {
            dsNo: strDsNo,
            tabIp,
            userId: userId,
            UserName: userName
        }

        // tempArrRightsObj = globalData.arrUserRights.find(k => k.Hmi == strHmi);
        // if (tempArrRightsObj != undefined) {
        //     if (tempArrRightsObj.Hmi == strHmi) {
        //         // tempArrRightsObj.Hmi = selIds
        //         tempArrRightsObj.selectedIds = selIds
        //     } else {
        //         tempArrRightsObj.selectedIds = selIds
        //     }
        // }
        // let tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);
        // if (tempUserObject != undefined) {
        //     if (tempUserObject.Hmi == strHmi) {
        //         tempUserObject.Hmi = selIds
        //         tempUserObject.mainHmi = strHmi
        //     } else {
        //         tempUserObject.Hmi = selIds
        //     }
        // }

        let arrIPQC = globalData.arr_IPQCRelIds.find(k => k.DsNo == strDsNo && k.tabIp == tabIp);
        if (arrIPQC == undefined) {
            // globalData.arr_IPQCRelIds.push({ idsNo: strIdsNo, selectedIds: selectedList.idsNo });
            globalData.arr_IPQCRelIds.push({ DsNo: strDsNo, tabIp, selectedDs });

        } else {
            arrIPQC.selectedDs = selectedDs;
            // arrIPQC.DsNo = strDsNo;
            // tabIp
        }
        // if (_check_PowerBackupEntry.length != 0) {
        //     if(_check_PowerBackupEntry[0].WeighmentName != 'FRIAB'){
        //         strHmi =  selIds
        //         objMenu.Hmi = strHmi
        //     var response = await objPowerBackup.chkPowerBackupPresent(objMenu)
        //     let obj = {
        //         status: 'success',
        //         result: response

        //     }

        //     return obj
        // }
        // }

        let getMenu = await objMenuRequest.sendMenu(objMenu)

        return getMenu;

    }

    async getAllBatchesForCubical(strDSNumber, strIdsIP) {
        const currentCubicRes = await models.tbl_cubical.findOne({
            where: {
                Sys_DSNumber: strDSNumber
            }
        })
        // var CubicalData = globalData.arrIdsInfo.find(k => k.idsNo == strIdsIP).cubicalData;

        var sysArea = currentCubicRes.Sys_Area;
        await this.lockedWeighingStatus(currentCubicRes.Sys_CubicNo)
        let arrBatchs = await this.getIPQCBatches(strDSNumber, sysArea);
        return arrBatchs;
    }

    async getIPQCBatches(strHmi, sysArea) {
        // var sqlquery = `SELECT Sys_IDSNo,Sys_Batch FROM tbl_cubical WHERE Sys_Area = 'IPQA-1-OLD' AND Sys_Batch != 'NULL'`;
        const CubicalData = await models.tbl_cubical.findOne({
            where: {
                Sys_DSNumber: strHmi
            }
        })

        // var CubicalData = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData;
        var Instrument = CubicalData.Sys_Port1
        var Sys_IPQCType = CubicalData.Sys_IPQCType
        // await this.lockedWeighingStatus(CubicalData.Sys_CubicNo)
        await objCalibCommonOperation.releaseCalibrationInProcess(CubicalData.Sys_CubicNo)
        // CubicleArea
        // CubicleType
        if (CubicalData.Sys_CubType == 'IPQC') {
            if (sysArea != 'Granulation') {
                // sysArea = "Compression"
                // var sqlquery = ` SELECT Sys_IDSNo,Sys_Batch FROM tbl_cubical WHERE Sys_Area ='${sysArea}'AND Sys_Batch != 'NULL' AND Sys_IDSNo !='NA'AND Sys_rpi != 'Null'AND Sys_CubType != 'IPQC'`;
                // var sqlquery = `SELECT Sys_IDSNo,Sys_Batch FROM tbl_cubical WHERE Sys_Area = '${sysArea}' AND Sys_Batch != 'NULL'`;
                // var sqlquery = ` SELECT Sys_DSNumber, Sys_Batch FROM tbl_cubical WHERE Sys_Area ='${sysArea}' AND Sys_Batch != 'NULL' AND Sys_DSNumber !='NA' AND Sys_CubType != 'IPQC'`;
                var sqlquery = `SELECT DS_Number, BatchID FROM tbl_mes_data WHERE CubicleArea='${sysArea}' AND BatchID != 'NULL' AND DS_Number !='NA'`; // For DRL (Checking Data in MES table)
                // var sqlquery = ` SELECT Sys_DSNumber, Sys_Batch FROM tbl_cubical WHERE Sys_Area ='${sysArea}' AND Sys_DSNumber !='NA' AND Sys_DSNumber !='NULL' AND Sys_CubType != 'IPQC'`; // For DRL (Only DS Number is important)
                var resBatch = await sequelize.query(sqlquery, {
                    type: QueryTypes.SELECT
                });
                console.log('resBatch: ', resBatch);
            } else {
                // Query for Granulation IPQC Area
                // var sqlquery = ` SELECT Sys_DSNumber, Sys_Batch FROM tbl_cubical WHERE Sys_Area ='${sysArea}'AND Sys_Batch != 'NULL' AND Sys_DSNumber !='NA'AND Sys_rpi != 'Null'`;
                // var sqlquery = `SELECT Sys_IDSNo,Sys_Batch FROM tbl_cubical WHERE Sys_Area = '${sysArea}' AND Sys_Batch != 'NULL'`;
                var sqlquery = `SELECT DS_Number, BatchID FROM tbl_mes_data WHERE CubicleArea='${sysArea}' AND BatchID != 'NULL' AND DS_Number !='NA'`; // For DRL (Checking Data in MES table)
                // var sqlquery = ` SELECT Sys_DSNumber, Sys_Batch FROM tbl_cubical WHERE Sys_Area ='${sysArea}' AND Sys_Batch != 'NULL' AND Sys_DSNumber !='NA' AND Sys_DSNumber !='NULL'`; // For DRL (Checking Data in MES table)
                var resBatch = await sequelize.query(sqlquery, {
                    type: QueryTypes.SELECT
                });
                console.log('resBatch: ', resBatch);
            }
            // var nextQueryForIpqA = `SELECT Sys_IDSNo,Sys_Batch FROM tbl_cubical WHERE Sys_IDSNo = '${strHmi}' AND Sys_Area ='${sysArea}'AND Sys_Batch != 'NULL'`
            // var IpQaBAtch = await sequelize.query(nextQueryForIpqA, {
            //     type: QueryTypes.SELECT
            // });
            // if (IpQaBAtch.length != 0) {
            //     resBatch = resBatch.concat(IpQaBAtch[0])
            // }
        } else {
            // var sqlquery =  ` SELECT Sys_IDSNo,Sys_Batch FROM tbl_cubical WHERE Sys_Area ='${sysArea}'AND Sys_Batch != 'NULL' AND Sys_IDSNo !='NA'AND Sys_rpi != 'Null' AND Sys_Port1 = '${Instrument}'`;
            // var sqlquery = ` SELECT Sys_DSNumber, Sys_Batch FROM tbl_cubical WHERE Sys_Area ='${sysArea}'AND Sys_Batch != 'NULL' AND Sys_DSNumber !='NA' AND Sys_rpi != 'Null'`;
            // var sqlquery = `SELECT Sys_IDSNo,Sys_Batch FROM tbl_cubical WHERE Sys_Area = '${sysArea}' AND Sys_Batch != 'NULL'`;
            var sqlquery = `SELECT DS_Number, BatchID FROM tbl_mes_data WHERE CubicleArea ='${sysArea}'AND BatchID != 'NULL' AND DS_Number !='NA'`; // For DRL (Checking Data in MES table)
            // var sqlquery = ` SELECT Sys_DSNumber, Sys_Batch FROM tbl_cubical WHERE Sys_Area ='${sysArea}' AND Sys_DSNumber !='NA' AND Sys_DSNumber !='NULL'`; // For DRL (Only DS Number is important)
            var resBatch = await sequelize.query(sqlquery, {
                type: QueryTypes.SELECT
            });

            var ObjBatch = await models.tbl_batches.findAll({
                where: {
                    Status: 'S'
                }
            })
            // var reBatch = resBatch.map(k=>k.Sys_Batch)
            //  var ObBatch = ObjBatch.map(k => k.Batch)
            //  resBatch  =    ObBatch.filter(k=>k == reBatch)
        }
        //return all batches
        return resBatch;
    }

    async getIPQCBatchesForMES(strHmi, sysArea) {
        // var sqlquery = `SELECT Sys_IDSNo,Sys_Batch FROM tbl_cubical WHERE Sys_Area = 'IPQA-1-OLD' AND Sys_Batch != 'NULL'`;
        const CubicalData = await models.tbl_cubical.findOne({
            where: {
                Sys_DSNumber: strHmi
            }
        })

        // var CubicalData = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData;
        var Instrument = CubicalData.Sys_Port1
        var Sys_IPQCType = CubicalData.Sys_IPQCType
        // await this.lockedWeighingStatus(CubicalData.Sys_CubicNo)
        await objCalibCommonOperation.releaseCalibrationInProcess(CubicalData.Sys_CubicNo)
        // CubicleArea
        // CubicleType
        if (CubicalData.Sys_CubType == 'IPQC') {
            if (sysArea != 'Granulation') {
                sysArea = "Compression"
                // var sqlquery = ` SELECT Sys_IDSNo,Sys_Batch FROM tbl_cubical WHERE Sys_Area ='${sysArea}'AND Sys_Batch != 'NULL' AND Sys_IDSNo !='NA'AND Sys_rpi != 'Null'AND Sys_CubType != 'IPQC'`;
                // var sqlquery = `SELECT Sys_IDSNo,Sys_Batch FROM tbl_cubical WHERE Sys_Area = '${sysArea}' AND Sys_Batch != 'NULL'`;
                // var sqlquery = ` SELECT Sys_DSNumber, Sys_Batch FROM tbl_cubical WHERE Sys_Area ='${sysArea}' AND Sys_Batch != 'NULL' AND Sys_DSNumber !='NA' AND Sys_CubType != 'IPQC'`;
                var sqlquery = ` SELECT DS_Number, BatchID FROM tbl_mes_data WHERE CubicleArea ='${sysArea}' AND BatchID != 'NULL' AND DS_Number !='NA' AND CubicleType != 'IPQC'`; // For DRL
                var resBatch = await sequelize.query(sqlquery, {
                    type: QueryTypes.SELECT
                });
            } else {
                // Query for Granulation IPQC Area
                // var sqlquery = ` SELECT Sys_DSNumber, Sys_Batch FROM tbl_cubical WHERE Sys_Area ='${sysArea}'AND Sys_Batch != 'NULL' AND Sys_DSNumber !='NA'AND Sys_rpi != 'Null'`;
                // var sqlquery = `SELECT Sys_IDSNo,Sys_Batch FROM tbl_cubical WHERE Sys_Area = '${sysArea}' AND Sys_Batch != 'NULL'`;
                var sqlquery = ` SELECT DS_Number, BatchID FROM tbl_mes_data WHERE CubicleArea ='${sysArea}'AND BatchID != 'NULL' AND DS_Number !='NA'`; // For DRL
                var resBatch = await sequelize.query(sqlquery, {
                    type: QueryTypes.SELECT
                });
            }
            // var nextQueryForIpqA = `SELECT Sys_IDSNo,Sys_Batch FROM tbl_cubical WHERE Sys_IDSNo = '${strHmi}' AND Sys_Area ='${sysArea}'AND Sys_Batch != 'NULL'`
            // var IpQaBAtch = await sequelize.query(nextQueryForIpqA, {
            //     type: QueryTypes.SELECT
            // });
            // if (IpQaBAtch.length != 0) {
            //     resBatch = resBatch.concat(IpQaBAtch[0])
            // }
        } else {
            // var sqlquery =  ` SELECT Sys_IDSNo,Sys_Batch FROM tbl_cubical WHERE Sys_Area ='${sysArea}'AND Sys_Batch != 'NULL' AND Sys_IDSNo !='NA'AND Sys_rpi != 'Null' AND Sys_Port1 = '${Instrument}'`;
            // var sqlquery = ` SELECT Sys_DSNumber, Sys_Batch FROM tbl_cubical WHERE Sys_Area ='${sysArea}'AND Sys_Batch != 'NULL' AND Sys_DSNumber !='NA' AND Sys_rpi != 'Null'`;
            // var sqlquery = `SELECT Sys_IDSNo,Sys_Batch FROM tbl_cubical WHERE Sys_Area = '${sysArea}' AND Sys_Batch != 'NULL'`;
            var sqlquery = ` SELECT DS_Number, BatchID FROM tbl_mes_data WHERE CubicleArea ='${sysArea}'AND BatchID != 'NULL' AND DS_Number !='NA'`; // For DRL
            var resBatch = await sequelize.query(sqlquery, {
                type: QueryTypes.SELECT
            });

            var ObjBatch = await models.tbl_batches.findAll({
                where: {
                    Status: 'S'
                }
            })
            // var reBatch = resBatch.map(k=>k.Sys_Batch)
            //  var ObBatch = ObjBatch.map(k => k.Batch)
            //  resBatch  =    ObBatch.filter(k=>k == reBatch)
        }
        //return all batches
        return resBatch;
    }


    //10/11/2021 after selecting
    async getBatchlistAccordingToArea(dataObj) {
        let arrBatches = [];
        let DsNo = dataObj.dsNo;
        let TabIp = dataObj.tabIp;
        let strArea = dataObj.selectedArea;
        let strBatch = await this.getIPQCBatches(DsNo, strArea);
        // var CubicalData = globalData.arrIdsInfo.find(k => k.Hmi == strHmi);
        // if(CubicalData != undefined){
        //     if(CubicalData.cubicalData != undefined ){
        //         if(CubicalData.cubicalData.Sys_Area != strArea){
        //     let tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);
        //         let __activityObj = {
        //             strUserId: tempUserObject.UserId,
        //             strUserName: tempUserObject.UserName,
        //             activity: `Area: ${strArea} Selected by user`
        //         }
        //         await objActivityLog.ActivityLogEntry(__activityObj);
        //     }
        // }

        // }
        var arrIPQC = globalData.arr_IPQCRelIds.find(k => k.dsNo == DsNo);
        if (arrIPQC != undefined) {
            var weighmentStatusObj = globalData.weighmentstatus.find(k => k.DsNo == DsNo && k.tabIp == TabIp);
            for (let i = 0; i <= globalData.weighmentstatus.length; i++) {
                weighmentStatusObj = globalData.weighmentstatus.find(k => k.DsNo == DsNo && k.tabIp == TabIp)
                if (weighmentStatusObj != undefined) {
                    await models.tbl_system_weighingstatus.update({
                        Status: 0,
                        BatchNo: "NULL",
                        CubType: "NULL"
                    }, {
                        where: {
                            CubicleNo: weighmentStatusObj.status,
                        }
                    })
                    globalData.weighmentstatus.findIndex(k => k.DsNo == DsNo && k.tabIp == TabIp) == -1 ? globalData.weighmentstatus : globalData.weighmentstatus.splice(globalData.weighmentstatus.findIndex(k => k.DsNo == DsNo && k.tabIp == TabIp), 1);
                }
            }
        }
        // (globalData.Emptyobj.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.Emptyobj : globalData.Emptyobj.splice(globalData.Emptyobj.findIndex((element) => element.Hmi === strHmi), 1);
        for (let obj in strBatch) {
            // arrBatches.push({ dsNo: strBatch[obj].Sys_DSNumber, batch: strBatch[obj].Sys_Batch })
            arrBatches.push({ dsNo: strBatch[obj].DS_Number, batch: strBatch[obj].BatchID })
        }
        console.log('arrBatches: ', arrBatches);

        const IPQCList = globalData.IPQCList.find((k) => k.dsNo == DsNo && k.tabIp == TabIp);
        if (!IPQCList) {
            globalData.IPQCList.push({
                bathces: arrBatches,
                tabIp: TabIp,
                dsNo: DsNo,
                area: strArea
            })
        } else {
            // IPQCList
            IPQCList.bathces = arrBatches;
            IPQCList.tabIp = TabIp;
            IPQCList.dsNo = DsNo;
            IPQCList.area = strArea;
        }

        let resObj = {
            status: 'success',
            Area: strArea,
            batch: arrBatches,
            tabIp: TabIp,
            isUpdated: false
        }

        console.log("Batches has been send through function getBatchlistAccordingToArea.", JSON.stringify(resObj));
        mqttSender.sendData(DsNo, `onAreaSelectionGetBatch:${JSON.stringify(resObj)}`)
    }
    //15-01-2022
    async getAreaAndABatchwhenCont(dataObj) {

        try {
            var CurrentCubicInfo = await models.tbl_cubical.findAll({
                where: {
                    Sys_IDSNo: dataObj.Hmi
                }
            })
            CurrentCubicInfo = CurrentCubicInfo[0]
            var strHmi = dataObj.Hmi
            if (CurrentCubicInfo.Sys_CubType == "IPQA" || CurrentCubicInfo.Sys_CubType == "IPQC") {
                // return await objIpqc.processIPQC(strResbPiNo);
                // let strBatch = await this.getAllBatchesForCubical(strHmi);
                // var CubicalData = globalData.arrIdsInfo.find(k => k.Hmi == strHmi).cubicalData;
                var sysArea = CurrentCubicInfo.Sys_Area;
                // //for loop the batches and then show the response Without Sys_Batch
                // for (let obj in strBatch) {
                //     arrBatches.push({Idsno : strBatch[obj].Sys_IDSNo,batch : strBatch[obj].Sys_Batch})
                // }

                let resObj = {
                    status: 'success',
                    Hmi: strHmi,
                    selectedArea: sysArea
                }
                return resObj;

                //send response as a Batchs according to that Area after compeletion of calibration 
            }
            else {
                let obj = {
                    status: 'success',
                    result: 'menu'
                }
                return obj
            }
        } catch (error) {
            console.log(error)
            return 'Something went Wrong'

        }
    }
    async lockedWeighingStatus(cubicalNo, BatchNo, CubType, Sys_Area, Sys_CubicName) {
        try {
            await models.tbl_system_weighingstatus.update({
                Status: 1,
                BatchNo: 'NULL',
                CubType: 'NULL'
            }, {
                where: {
                    CubicleNo: cubicalNo,
                    // BatchNo:BatchNo,
                    // CubicleNo:cubicalNo,
                    // CubicleNo:cubicalNo,

                }
            })
        } catch (error) {
            console.log(error)
        }
    }
}

module.exports = IPQC;