const ClassweighmentData = require('../clsProcessWeighment.model');
const mqttProtocol = require('../../global/GLOBAL_NOMENCLATURE');
const classHmi = require('../hmiDetail.model');
const loggers = require('../winstonLogger');
const globalData = require('../../global/globalData');
const clsMqttSender = require('../Mqtt/mqttSender.class');
const clsActivityLog = require("../clsActivityLog.model");
const clsInstrumentUsage = require("../clsInstrumentUsageLog");
const mqttProtocols = require('../../global/GLOBAL_NOMENCLATURE');
const objWeighmentData = new ClassweighmentData();
const clsMenuRequest = require('../Menu/MenuRequest.model');

const objHmi = new classHmi();
const mqttSender = new clsMqttSender();
const objMenuRequest = new clsMenuRequest();
const objActivityLog = new clsActivityLog();
const objInstrumentUsage = new clsInstrumentUsage();
const { create, all } = require("mathjs");
const config = {};
const mathj = create(all, config);
const moment = require("moment");


class FriabilityParsing {
    async parsingFriabilityData(dataObj) {
        try {
            let {
                Str_Protocol,
                ProtocolPortNo,
                instrumentId,
                ProtocolName,
            } = dataObj;
            let strResberryPi = dataObj.currentOpStatus.DsNo;
            let strHmi = dataObj.TabIp;
            // let data,actualWtf,actualWts,ProtocolDecPoint1,ProtocolDecPoint2,ProtocolUnit1,ProtocolUnit2,
            // negativeWeightCheck1,negativeWeightCheck2,arrProtocolDataAndUnitfirstWt,arrProtocolDataAndUnitSecondWt,strInstrumentType,
            let data,


                weight_before_drum1,
                weight_before_drum2,
                weight_after_drum1,
                weight_after_drum2,
                friability_drum1,
                friability_drum2;
            let type;
            if (
                Str_Protocol.search("DRUM-1") != -1 &&
                Str_Protocol.search("DRUM-2") != -1
            ) {
                type = "Double";
            } else {
                type = "Single";
            }

            // let strInstrumentType;
            const arrCurrentOperation = globalData.arrCurrentOperationStatus.find(
                (k) => k.DsNo == strResberryPi
            );
            const arrCalibInProcess = globalData.arrcalibType.find(
                (k) => k.DsNo == strResberryPi
            );

            if (arrCurrentOperation != undefined) {
                const arrSelectedMenu = globalData.arrSelectedMenu.find(
                    (k) => k.TabIp == strHmi
                );
                var intPortNo1 = arrSelectedMenu.portNo;
                var strInstrumentType = arrSelectedMenu.InstrumentType;
                var strInstrumentId = arrSelectedMenu.instrumentId;
            } else if (arrCalibInProcess != undefined) {
                let hmiDetails = globalData.arrSelectedBalWithHmi.find(
                    (k) => k.Hmi == strHmi
                );
                var intPortNo1 = hmiDetails.portNo;
                var strInstrumentType = hmiDetails.InstrumentType;
                var strInstrumentId = hmiDetails.selectedBal;
            }
            let hmiDetailsInPMenu = globalData.arrIdsInfo.find(
                (k) => k.DsNo == strResberryPi
            ).cubicalData;
            let data_array, __parameterWeighmentObj;
            // currentOpStatus, tempCailibType, __parameterWeighmentObj;
            let drum_found = false;
            var weight_before_drum2_array;
            var friability_drum2_array;
            var weight_after_drum2_array;
            var actualCount;
            var actualRpm;
            var drum1, drum2, drum3, drum4, per1, per2;

            // if (serverConfig.friabilityType == "OF") {
            //data_array.slice(data_array.map(k=>k.trim()).findIndex(l=>l.includes("CALCULATIONS")))
            data_array = Str_Protocol.split("\n");
            data_array = Str_Protocol.split("\n");
            for (let i = 0; i < data_array.length; i++) {
                data = data_array[i].trim();
                if (data == "" || data == null) continue;
                if (data.search("DRUM-") != -1) {
                    drum_found = true;
                    continue;
                }
                if (drum_found === true && data.search("WEIGHT BEFORE TEST") != -1) {
                    let weight_before_array = data.split("|");
                    let weight_before_drum1_array = weight_before_array[0].split(":");
                    if (weight_before_array[1] != undefined) {
                        weight_before_drum2_array = weight_before_array[1].split(":");
                    }
                    weight_before_drum1 = weight_before_drum1_array[1].trim();
                    drum1 = weight_before_drum1.split(/\s+/gi);
                    // if(drum1.includes('gm')){
                    if (
                        isNaN(Number(drum1[0])) ||
                        Number(drum1[0]) <= 0 ||
                        (drum1[1] != "gm" && drum1[1] != "g")
                    ) {
                       return mqttSender.sendData(strResberryPi, `Port ${intPortNo1}:${mqttProtocols.DisplayMessage}Invalid Weight Recieved`)
                    }
                    // }
                    if (weight_before_array[1] != undefined) {
                        weight_before_drum2 =
                            weight_before_drum2_array[1] == undefined
                                ? ""
                                : weight_before_drum2_array[1].trim();
                        if (weight_before_drum2_array[1] !== undefined) {
                            drum2 = weight_before_drum2.split(/\s+/gi);
                            if (
                                isNaN(Number(drum2[0])) ||
                                Number(drum2[0]) <= 0 ||
                                (drum2[1] !== "gm" && drum2[1] !== "g")
                            ) {
                                return mqttSender.sendData(strResberryPi, `Port ${intPortNo1}:${mqttProtocols.DisplayMessage}Invalid Weight Recieved`)
                            }
                        }
                        // // if(drum2.includes('gm')){
                        //     if(drum2[0] == ''){
                        //         return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid Weight Recieved`)
                        //     }
                        // }
                    }
                    console.log(
                        `weight_before_drum1 : ${weight_before_drum1} ; weight_before_drum2 :  ${weight_before_drum2}`
                    );
                } else if (
                    drum_found === true &&
                    data.search("WEIGHT AFTER TEST") != -1
                ) {
                    let weight_after_array = data.split("|");
                    let weight_after_drum1_array = weight_after_array[0].split(":");

                    if (weight_after_array[1] != undefined) {
                        weight_after_drum2_array = weight_after_array[1].split(":");
                    }

                    weight_after_drum1 = weight_after_drum1_array[1].trim();
                    drum3 = weight_after_drum1.split(/\s+/gi);
                    if (
                        isNaN(Number(drum3[0])) ||
                        Number(drum3[0]) <= 0 ||
                        (drum3[1] != "gm" && drum3[1] != "g")
                    ) {
                       return mqttSender.sendData(strResberryPi, `Port ${intPortNo1}:${mqttProtocols.DisplayMessage}Invalid Weight Recieved`)
                    }

                    if (weight_after_array[1] != undefined) {
                        weight_after_drum2 =
                            weight_after_drum2_array[1] == undefined
                                ? ""
                                : weight_after_drum2_array[1].trim();
                        // drum4 = weight_after_drum2.split('gm')
                        // if()
                        if (weight_after_drum2_array[1] !== undefined) {
                            drum4 = weight_after_drum2.split(/\s+/gi);
                            if (
                                isNaN(Number(drum4[0])) ||
                                Number(drum4[0]) <= 0 ||
                                (drum4[1] != "gm" &&
                                    drum4[1] != "g")
                            ) {
                                // mqttSender.sendData(
                                //     strResberryPi,
                                //     `${mqttProtocols.DisplayMessage}Invalid Weight Recieved`
                                // );
                            return mqttSender.sendData(strResberryPi, `Port ${intPortNo1}:${mqttProtocols.DisplayMessage}Invalid Weight Recieved`)
                            }
                        }
                    }
                    console.log(
                        `weight_after_drum1 : ${weight_after_drum1} ; weight_after_drum2 : ${weight_after_drum2}`
                    );
                } else if (drum_found === true && data.search("FRIABILITY") !== -1) {
                    let friability_array = data.split("|");
                    let friability_drum1_array = friability_array[0].split(":");
                    if (friability_array[1] != undefined) {
                        friability_drum2_array = friability_array[1].split(":");
                    }
                    friability_drum1 = friability_drum1_array[1].trim();
                    let drum5 = friability_drum1.split(/\s+/gi)
                    if (
                        isNaN(Number(drum5[0])) ||
                        Number(drum5[0]) < 0
                    ) {
                        // return mqttSender.sendData(
                        //   strHmi,
                        //   `${mqttProtocols.DisplayMessage}Invalid Weight Recieved`
                        // );
                    }
                    if (friability_array[1] != undefined) {
                        friability_drum2 =
                            friability_drum2_array[1] == undefined
                                ? ""
                                : friability_drum2_array[1].trim();
                        if (friability_drum2_array[1] !== undefined) {
                            let drum6 = friability_drum2.split(/\s+/gi);
                            if (
                                isNaN(Number(drum6[0])) ||
                                Number(drum6[0]) < 0
                            ) {
                                // return mqttSender.sendData(
                                //   strHmi,
                                //   `${mqttProtocols.DisplayMessage}Invalid Weight Recieved`
                                // );
                            }
                        }
                        // per2 = friability_drum2.split('%')
                        // // if(per2.includes('%')){
                        //     if(per2[0] == ''){
                        //         return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid Weight Recieved`)
                        //     }
                        // }
                    }
                    console.log(
                        `friability_drum1 : ${friability_drum1}; 2 : ${friability_drum2}`
                    );
                } else {
                    // console.log('invalid string recived');
                }
            }
            // for (let i = 0; i < data_array.length; i++) {
            //     data = data_array[i].trim();
            //     if (data == "" || data == null)
            //         continue;
            //     if (data.search("DRUM-") != -1) {
            //         drum_found = true;
            //         continue;
            //     }
            //     if (data.search('SET RPM') !== -1 || data.search('SET COUNT') !== -1){
            //         // var pattern = /^SET RPM(\s*)?:(\s*)?\d{1,}(\s*)?SET COUNT(\s*)?:(\s*)?\d{1,}(\s*)?$/i
            //         var pattern = /^(SET RPM|SET COUNT)(\s*)?:(\s*)?\d{1,}/i
            //         if (data.startsWith("SET COUNT") && actualCount !== undefined ||
            //             data.startsWith("SET RPM") && actualRpm !== undefined ||
            //             pattern.test(data) === undefined) return this.invalidMqttSendData(strHmi)
            //         var value = data.split(":")
            //             if(data.startsWith("SET RPM"))
            //             {actualRpm = Number(value[1].trim())
            //             if (actualRpm <= 0) return this.invalidMqttSendData(strHmi)}
            //             else{actualCount = Number(value[1].trim())
            //             if (actualCount <= 0) return this.invalidMqttSendData(strHmi)}
            //     }
            //     if (drum_found === true && (data.search("WGT BEFORE TEST") != -1)) {
            //         let weight_before_array = data.split("|");
            //         let weight_before_drum1_array = weight_before_array[0].split(":");
            //         if (weight_before_array[1] != undefined) {
            //             weight_before_drum2_array = weight_before_array[1].split(":");
            //         }
            //         weight_before_drum1 = weight_before_drum1_array[1].trim();
            //         if (weight_before_array[1] != undefined) {
            //             weight_before_drum2 = weight_before_drum2_array[1] == undefined ? '' : weight_before_drum2_array[1].trim();
            //         }
            //         console.log(`weight_before_drum1 : ${weight_before_drum1} ; weight_before_drum2 :  ${weight_before_drum2}`)
            //     }
            //     else if (drum_found === true && (data.search("WGT AFTER TEST") != -1)) {
            //         let weight_after_array = data.split("|");
            //         let weight_after_drum1_array = weight_after_array[0].split(":");
            //         if (weight_after_array[1] != undefined) {
            //             weight_after_drum2_array = weight_after_array[1].split(":");
            //         }
            //         weight_after_drum1 = weight_after_drum1_array[1].trim();
            //         if (weight_after_array[1] != undefined) {
            //             weight_after_drum2 = weight_after_drum2_array[1] == undefined ? '' : weight_after_drum2_array[1].trim();
            //         }
            //         console.log(`weight_after_drum1 : ${weight_after_drum1} ; weight_after_drum2 : ${weight_after_drum2}`)
            //     }
            //     else if (drum_found === true && data.search("FRIABILITY") != -1) {
            //         let friability_array = data.split("|");
            //         let friability_drum1_array = friability_array[0].split(":");
            //         if (friability_array[1] != undefined) {
            //             friability_drum2_array = friability_array[1].split(":");
            //         }
            //         friability_drum1 = Number(friability_drum1_array[1].slice(0,-1).trim());
            //         if (friability_array[1] != undefined) {
            //             friability_drum2 = friability_drum2_array[1] == undefined ? '' : Number(friability_drum2_array[1].slice(0,-1).trim());
            //         }
            //         console.log(`friability_drum1 : ${friability_drum1}; 2 : ${friability_drum2}`)
            //     }
            //     else {
            //         //console.log('invalid string recived');
            //     }
            // }
            //data = Str_Protocol.search("DRUM-1")
            console.log(data);

            // }

            const setRpmRegex =
                /SET RPM(\s*)?:(\s*)?(\d+)(\s*)SET COUNT(\s*)?:(\s*)?(\d+)/gi;
            // const setCountRegex = /SET COUNT\s+:\s+(\d+)/gi;

            const setRpmMatch = Str_Protocol.match(setRpmRegex);
            // const setCountMatch = Str_Protocol.match(setCountRegex);
            
           if (!setRpmMatch) {
                return mqttSender.sendData(
                    strResberryPi,
                    `Port ${ProtocolPortNo}:${mqttProtocols.DisplayMessage}Invalid String Recieved`
                );
            }

            if (setRpmMatch) {
                var actualRpmAndCount = setRpmMatch[0].split(":");

                actualRpm = actualRpmAndCount[1].split(/SET COUNT/gi)[0].trim();
                actualCount = actualRpmAndCount[2].trim();

                console.log(`SET RPM: ${actualRpm} SET COUNT: ${actualCount}`);
                if (isNaN(Number(actualRpm)) || isNaN(Number(actualCount)))
                    return mqttSender.sendData(
                        strHmi,
                        `${mqttProtocols.DisplayMessage}Invalid String Recieved`
                    );
                actualRpm = Number(actualRpm).toFixed();
                actualCount = Number(actualCount).toFixed();
            }

            // if (setCountMatch) {
            //      actualCount = setCountMatch[0];
            //     if( isNaN(Number(actualCount))) return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid String Recieved`)
            //     console.log(`SET COUNT: ${actualCount}`);
            //     actualCount = Number(actualCount).toFixed()
            // }

            __parameterWeighmentObj = {
                DsNo: dataObj.currentOpStatus.DsNo,
                DsIp: dataObj.SelectedMenuDetails.DsIp,
                actualWtBeforeDrum1: weight_before_drum1,
                actualWtBeforeDrum2: weight_before_drum2,
                actualWtAfterDrum1: weight_after_drum1,
                actualWtAfterDrum2: weight_after_drum2,
                friability_drum1: friability_drum1,
                friability_drum2: friability_drum2,
                instrumentId: strInstrumentId,
                recived_string_type: type,
                actualCount,
                actualRpm,
                TabIp: dataObj.currentOpStatus.TabIp,
                menuName: strInstrumentType,
                SelectedMenuDetails:dataObj.SelectedMenuDetails,
            };

            let a = weight_before_drum1;
            let b = weight_before_drum2;
            let c = weight_after_drum1;
            let d = weight_after_drum2;

            weight_before_drum1 = weight_before_drum1.split(" "); //WBD1
            console.log(weight_after_drum1);
            // if (weight_before_drum1[0].endsWith('g') || weight_before_drum1[0].endsWith('gm') || weight_before_drum1[0].endsWith('mm') || weight_before_drum1[0].endsWith('kg')) {
            //     //log protocol in file
            //     loggers.MqttProtocolLogger.info(`protocol : ${mqttProtocols.DisplayMessage}Invalid Weight Recieved sended to device ${strHmi}`)
            //     return mqttSender.sendData(strHmi, `${mqttProtocols.DisplayMessage}Invalid Weight Recieved`)
            // }

            if (
                weight_before_drum1 == undefined ||
                weight_before_drum1 == "" ||
                weight_before_drum1 == 0
            ) {
                //log protocol in file
                loggers.MqttProtocolLogger.info(
                    `protocol : ${mqttProtocols.DisplayMessage}Invalid Weight Recieved sended to device ${strHmi}`
                );
                return mqttSender.sendData(
                    strHmi,
                    `${mqttProtocols.DisplayMessage}Invalid Weight Recieved`
                );
            }
            if (
                weight_after_drum1 == undefined ||
                weight_after_drum1 == "" ||
                weight_after_drum1 == 0 ||
                weight_after_drum1.includes("gm") == true
            ) {
                //log protocol in file
                loggers.MqttProtocolLogger.info(
                    `protocol : ${mqttProtocols.DisplayMessage}Invalid Weight Recieved sended to device ${strHmi}`
                );
                return mqttSender.sendData(
                    strHmi,
                    `${mqttProtocols.DisplayMessage}Invalid Weight Recieved`
                );
            }
            // if (
            //   friability_drum1 == undefined ||
            //   friability_drum1 == "" ||
            //   friability_drum1 == 0 
            // ) {
            //   //log protocol in file
            //   loggers.MqttProtocolLogger.info(
            //     `protocol : ${mqttProtocols.DisplayMessage}Invalid Weight Recieved sended to device ${strHmi}`
            //   );
            //   return mqttSender.sendData(
            //     strHmi,
            //     `${mqttProtocols.DisplayMessage}Invalid Weight Recieved`
            //   );
            // }
            if (hmiDetailsInPMenu.Sys_RotaryType == "Double") {
                if (
                    weight_before_drum2 == undefined ||
                    weight_before_drum2 == "" ||
                    weight_before_drum2 == 0 ||
                    weight_before_drum2.includes("gm") == false
                ) {
                    //log protocol in file
                    loggers.MqttProtocolLogger.info(
                        `protocol : ${mqttProtocols.DisplayMessage}Invalid Weight Recieved sended to device ${strHmi}`
                    );
                    return mqttSender.sendData(
                        strHmi,
                        `${mqttProtocols.DisplayMessage}Invalid Weight Recieved`
                    );
                }
                if (
                    weight_after_drum2 == undefined ||
                    weight_after_drum2 == "" ||
                    weight_after_drum2 == 0 ||
                    weight_after_drum2.includes("gm") == false
                ) {
                    //log protocol in file
                    loggers.MqttProtocolLogger.info(
                        `protocol : ${mqttProtocols.DisplayMessage}Invalid Weight Recieved sended to device ${strHmi}`
                    );
                    return mqttSender.sendData(
                        strHmi,
                        `${mqttProtocols.DisplayMessage}Invalid Weight Recieved`
                    );
                }
                // if (
                //   friability_drum2 == undefined ||
                //   friability_drum2 == "" ||
                //   friability_drum2 == 0 
                // ) {
                //   //log protocol in file
                //   loggers.MqttProtocolLogger.info(
                //     `protocol : ${mqttProtocols.DisplayMessage}Invalid Weight Recieved sended to device ${strHmi}`
                //   );
                //   return mqttSender.sendData(
                //     strHmi,
                //     `${mqttProtocols.DisplayMessage}Invalid Weight Recieved`
                //   );
                // }
            }

            if (data_array !== "") {
                if (weight_before_drum1.length < 1 || weight_before_drum1[1] == "") {
                    //log protocol in file
                    loggers.MqttProtocolLogger.info(
                        `protocol : ${mqttProtocols.DisplayMessage}Invalid Weight Recieved sended to device ${strHmi}`
                    );
                    return mqttSender.sendData(
                        strHmi,
                        `${mqttProtocols.DisplayMessage}Invalid Weight Recieved`
                    );
                }

                if (weight_before_drum1[1] === "A") {
                    return;
                } else {
                    if (strInstrumentType == mqttProtocols.Friability) {
                        if (weight_before_drum1[1] == undefined) {
                            weight_before_drum1[1] =
                                weight_before_drum1[1] == undefined
                                    ? "g"
                                    : weight_before_drum1[1];
                        } else {
                            if (
                                weight_before_drum1[1] != "g" &&
                                weight_before_drum1[1] != "kg" &&
                                weight_before_drum1[1] != "mg" &&
                                weight_before_drum1[1] != "gm"
                            ) {
                                //log protocol in file
                                loggers.MqttProtocolLogger.info(
                                    `protocol : ${mqttProtocols.DisplayMessage}Invalid Data String sended to device ${strHmi}`
                                );
                                return mqttSender.sendData(
                                    strHmi,
                                    `${mqttProtocols.DisplayMessage}Invalid Data String`
                                );
                            } else {
                                // if (ProtocolUnit1 == "mg") {
                                //     actualWt = actualWt / 1000;
                                // } else if (ProtocolUnit == ("kg" || "Kg" || "KG")) {
                                //     actualWt = actualWt * 1000;
                                // }
                                // ProtocolUnit = ProtocolUnit == undefined ? "g" : ProtocolUnit;
                                console.log("convert unit if needed");
                            }
                        }
                    } else {
                        //log protocol in file
                        loggers.MqttProtocolLogger.info(`unknown instrument`);
                        console.log("unknown instrument");
                    }

                    //decision making
                    if (arrCalibInProcess == undefined) {
                        if (arrCurrentOperation == undefined) {
                            loggers.MqttProtocolLogger.info(
                                `Weight recieve without any api called`
                            );
                            console.log("wt recieve without any api called");
                            return;
                        } else if (
                            arrCurrentOperation.Weighment == 1 &&
                            arrCurrentOperation.testType == "Weighment"
                        ) {
                            await objWeighmentData.ParsingTestData(strInstrumentType, __parameterWeighmentObj);
                        }
                    } else {
                        console.log("calibration will not do here");
                    }
                }
            }
        } catch (error) {
            throw new Error(error);
        }
    }

}

module.exports = FriabilityParsing