const ClassweighmentData = require('../clsProcessWeighment.model');
const mqttProtocol = require('../../global/GLOBAL_NOMENCLATURE');
const classHmi = require('../hmiDetail.model');
const loggers = require('../winstonLogger');
const globalData = require('../../global/globalData');
const clsMqttSender = require('../Mqtt/mqttSender.class');
const clsActivityLog = require("../clsActivityLog.model");
const clsInstrumentUsage = require("../clsInstrumentUsageLog");

const objWeighmentData = new ClassweighmentData();
const clsMenuRequest = require('../Menu/MenuRequest.model');

const objHmi = new classHmi();
const mqttSender = new clsMqttSender();
const objMenuRequest = new clsMenuRequest();
const objActivityLog = new clsActivityLog();
const objInstrumentUsage = new clsInstrumentUsage();
const { create, all } = require("mathjs");
const config = {};
const mathj = create(all, config);
const moment = require("moment");

class LeakParsing {

    async parsingLeakData(dataObj) {
        try {
            let { InstrumentId } = dataObj
            //const EQUIP_MODEL_NAME = await this.getDetailOfBulkInstrumentModel(instrumentId);
            // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == dataObj.strHmi);
            // if (IPQCObject != undefined) {
            //     selectedIdsNo = IPQCObject.selectedIds.idsNo;
            // } else {
            //     selectedIdsNo = strIdsNo;
            // }
            let MoistModel = await objMenuRequest.getDetailOfBulkInstrumentModel(InstrumentId);

            if (MoistModel.Eqp_Model == 'ELT-201WP') {
                let getStringAccToEquip = this.getStringAccToEquip(MoistModel.Eqp_Model);
                await this.parseLeakTest(dataObj, getStringAccToEquip, MoistModel.Eqp_Model, MoistModel.Eqp_Make);
                return
            }
        } catch (error) {
            throw new Error(error)
        }
    }

    async parseLeakTest(dataObj, getStringAccToEquip, model, eqpMake) {
        try {
            let { Str_Protocol, ProtocolPortNo, SelectedMenuDetails, currentOpStatus, tempCailibType, InstrumentType, InstrumentId } = dataObj;
            var dsNo = SelectedMenuDetails.DsNo;
            var dsIp = SelectedMenuDetails.DsIp;
            let tabIp = SelectedMenuDetails.TabIp
            let menuName = SelectedMenuDetails.menuName || 'Leak Test';
            // let unitObj = objWeighmentData.getUnitObj(menuName);
            // let decPoint = unitObj.decPoint;
            var actualProtocol = Str_Protocol.trim();
            let str_1 = actualProtocol.split("\n");
            let arr = [];
            let currentData = {};
            let isTestAborted = false;

            const tempUserObject = globalData.arrUsers.find(k => k.DsNo == dsNo);
            let cubicObjData = globalData.arrIdsInfo.find((k) => k.DsNo == dsNo);
            let weightTempParsingObj = {};

            str_1[0] = str_1[0].replace(/comread/i, "COMREAD");
            if (str_1[0].includes("COMREAD")) {
                str_1[0] = str_1[0].replace(`COMREAD:${ProtocolPortNo}:`, '');
            }

            var modelNoIndex = str_1.findIndex(p => p.includes(getStringAccToEquip.modelNo));
            var startDateIndex = str_1.findIndex(p => p.includes(getStringAccToEquip.startDate));
            var testIdIndex = str_1.findIndex(p => p.includes(getStringAccToEquip.testId));
            var testStatusIndex = str_1.findIndex(p => p.includes(getStringAccToEquip.testStatus));
            var instruNoIndex = str_1.findIndex(p => p.includes(getStringAccToEquip.instruNo));
            // var limitIndex = str_1.findIndex(p => p.includes(getStringAccToEquip.limit));
            var methodNameIndex = str_1.findIndex(p => p.includes(getStringAccToEquip.methodName));
            var noOfPackageIndex = str_1.findIndex(p => p.includes(getStringAccToEquip.noOfPackage));
            var desicatorSizeIndex = str_1.findIndex(p => p.includes(getStringAccToEquip.desicatorSize));
            if(desicatorSizeIndex == -1){
                desicatorSizeIndex = str_1.findIndex(p => p.includes('Desicator Size'));
            }
            var packageTypeIndex = str_1.findIndex(p => p.includes(getStringAccToEquip.packageType));
            var dosageUnitIndex = str_1.findIndex(p => p.includes(getStringAccToEquip.dosageUnit));
            var resultIndex = str_1.findIndex(p => p.includes(getStringAccToEquip.result));
            var eort_vacuum_levelIndex = str_1.findIndex(p => p.includes(getStringAccToEquip.EORT_vacuum_level))
            let vaccumeBuildIndex = str_1.findIndex(p => p.includes(getStringAccToEquip.vaccumeBuildTm))
            let productDescriptionIndex = str_1.findIndex(p => p.includes(getStringAccToEquip.ProductDescription));
            let productNameIndex = str_1.findIndex(p => p.includes(getStringAccToEquip.productName));
            let vaccumeReleaseTmIndex = str_1.findIndex(p => p.includes(getStringAccToEquip.vaccumeReleaseTm));
            let vaccumeLevelIndex = str_1.findIndex(p => (p.includes(getStringAccToEquip.EORT_vacuum_level) !== p.includes(getStringAccToEquip.vaccumeLevel)))
            let vaccumeRetentionTmIndex = str_1.findIndex(p => p.includes(getStringAccToEquip.vaccumeRetentionTm));
            let vaccumePenetrationTmIndex = str_1.findIndex(p => p.includes(getStringAccToEquip.vaccumePenetrationTm));
            let dosageFormIndex = str_1.findIndex(p => p.includes(getStringAccToEquip.dosageForm));
            let startTimeIndex = str_1.findIndex(p => p.includes(getStringAccToEquip.startTime))
            let serialNoIndex = str_1.findIndex(p => p.includes(getStringAccToEquip.serialNo));
            let groupNameIndex = str_1.findIndex(p => p.includes(getStringAccToEquip.groupName));

            // if ((modelNoIndex == -1) || (instruNoIndex == -1) || (startDateIndex == -1) || (testIdIndex == -1) || 
            //     (eort_vacuum_levelIndex == -1) || (vaccumeBuildIndex == -1) || (testStatusIndex == -1) || (methodNameIndex == -1) || 
            //     (noOfPackageIndex == -1) || (desicatorSizeIndex == -1) || (packageTypeIndex == -1) || 
            //     (dosageUnitIndex == -1) || (resultIndex == -1) || (productDescriptionIndex == -1) || (productNameIndex == -1) || 
            //     (vaccumeReleaseTmIndex == -1) || (vaccumeLevelIndex == -1) || (vaccumeRetentionTmIndex == -1) || (vaccumePenetrationTmIndex == -1) || (dosageFormIndex == -1) || (startTimeIndex == -1) || (serialNoIndex == -1) ||
            //     (groupNameIndex == -1)
            // ) {
            //     return mqttSender.sendData(dsNo, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Invalid String Received`);
            // }

            // (eort_vacuum_levelIndex == -1) || (vaccumeBuildIndex == -1) || (vaccumeReleaseTmIndex == -1) 

            if ((modelNoIndex == -1) || (instruNoIndex == -1) || (testIdIndex == -1) || (testStatusIndex == -1) ||
                (methodNameIndex == -1) || (noOfPackageIndex == -1) || (desicatorSizeIndex == -1) || (packageTypeIndex == -1) ||
                (dosageUnitIndex == -1) || (resultIndex == -1) || (productDescriptionIndex == -1) || (productNameIndex == -1) ||
                (vaccumeLevelIndex == -1) || (vaccumeRetentionTmIndex == -1) || (vaccumePenetrationTmIndex == -1) ||
                (dosageFormIndex == -1) || (serialNoIndex == -1) || (groupNameIndex == -1)
            ) {
                return mqttSender.sendData(dsNo, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Invalid String Received`);
            }

            if (modelNoIndex != -1) weightTempParsingObj.modelNo = str_1[modelNoIndex].trim();
            if (serialNoIndex != -1) weightTempParsingObj.serialNo = str_1[serialNoIndex].trim();
            if (instruNoIndex != -1) weightTempParsingObj.instruNo = str_1[instruNoIndex].trim();
            // if (startDateIndex != -1) weightTempParsingObj.startDate = str_1[startDateIndex].trim();
            if (testIdIndex != -1) weightTempParsingObj.testId = str_1[testIdIndex].trim();
            if (eort_vacuum_levelIndex != -1) weightTempParsingObj.EORT_vacuum_level = str_1[eort_vacuum_levelIndex].trim();
            if (vaccumeBuildIndex != -1) weightTempParsingObj.vaccumeBuildTm = str_1[vaccumeBuildIndex].trim();
            if (testStatusIndex != -1) weightTempParsingObj.testStatus = str_1[testStatusIndex].trim();
            if (methodNameIndex != -1) weightTempParsingObj.methodName = str_1[methodNameIndex].trim();
            if (noOfPackageIndex != -1) weightTempParsingObj.noOfPackage = str_1[noOfPackageIndex].trim();
            if (desicatorSizeIndex != -1) weightTempParsingObj.desicatorSize = str_1[desicatorSizeIndex].trim();
            // if (limitIndex != -1) weightTempParsingObj.limit = str_1[limitIndex].trim();
            if (packageTypeIndex != -1) weightTempParsingObj.packageType = str_1[packageTypeIndex].trim();
            if (dosageUnitIndex != -1) weightTempParsingObj.dosageUnit = str_1[dosageUnitIndex].trim();
            if (dosageFormIndex != -1) weightTempParsingObj.dosageForm = str_1[dosageFormIndex].trim();
            if (resultIndex != -1) weightTempParsingObj.result = str_1[resultIndex].trim();
            if (productDescriptionIndex != -1) weightTempParsingObj.ProductDescription = str_1[productDescriptionIndex].trim();
            if (productNameIndex != -1) weightTempParsingObj.productName = str_1[productNameIndex].trim();
            if (groupNameIndex != -1) weightTempParsingObj.groupName = str_1[groupNameIndex].trim();
            if (vaccumeReleaseTmIndex != -1) weightTempParsingObj.vaccumeReleaseTm = str_1[vaccumeReleaseTmIndex].trim();
            if (vaccumeLevelIndex != -1) weightTempParsingObj.vaccumeLevel = str_1[vaccumeLevelIndex].trim();
            if (vaccumeRetentionTmIndex != -1) weightTempParsingObj.vaccumeRetentionTm = str_1[vaccumeRetentionTmIndex].trim();
            if (vaccumePenetrationTmIndex != -1) weightTempParsingObj.vaccumePenetrationTm = str_1[vaccumePenetrationTmIndex].trim();
            // if (startTimeIndex != -1) weightTempParsingObj.startTime = str_1[startTimeIndex].trim();

            let serialNo = weightTempParsingObj.serialNo.trim().slice(weightTempParsingObj.serialNo.indexOf(getStringAccToEquip.serialNo))
            let instruNo = weightTempParsingObj.instruNo.trim().slice(weightTempParsingObj.instruNo.indexOf(getStringAccToEquip.instruNo))
            // let startTime = weightTempParsingObj.startTime.trim().slice(weightTempParsingObj.startTime.indexOf(getStringAccToEquip.startTime))
            let eort_vacuum_level = (weightTempParsingObj.EORT_vacuum_level) ? weightTempParsingObj.EORT_vacuum_level.trim().slice(weightTempParsingObj.EORT_vacuum_level.indexOf(getStringAccToEquip.EORT_vacuum_level)) : 'NA'
            let vaccumeLevel = weightTempParsingObj.vaccumeLevel.trim().slice(weightTempParsingObj.vaccumeLevel.indexOf(getStringAccToEquip.vaccumeLevel))
            let vaccumeBuildTm = (weightTempParsingObj.vaccumeBuildTm) ? weightTempParsingObj.vaccumeBuildTm.trim().slice(weightTempParsingObj.vaccumeBuildTm.indexOf(getStringAccToEquip.vaccumeBuildTm)) : 'NA'
            let vaccumeReleaseTm = (weightTempParsingObj.vaccumeReleaseTm) ? weightTempParsingObj.vaccumeReleaseTm.trim().slice(weightTempParsingObj.vaccumeReleaseTm.indexOf(getStringAccToEquip.vaccumeReleaseTm)) : 'NA';
            let vaccumeRetentionTm = weightTempParsingObj.vaccumeRetentionTm.trim().slice(weightTempParsingObj.vaccumeRetentionTm.indexOf(getStringAccToEquip.vaccumeRetentionTm))
            let vaccumePenetrationTm = weightTempParsingObj.vaccumePenetrationTm.trim().slice(weightTempParsingObj.vaccumePenetrationTm.indexOf(getStringAccToEquip.vaccumePenetrationTm))
            let packageType = weightTempParsingObj.packageType.trim().slice(weightTempParsingObj.packageType.indexOf(getStringAccToEquip.packageType))
            let dosageUnit = weightTempParsingObj.dosageUnit.trim().slice(weightTempParsingObj.dosageUnit.indexOf(getStringAccToEquip.dosageUnit))
            let dosageForm = weightTempParsingObj.dosageForm.trim().slice(weightTempParsingObj.dosageForm.indexOf(getStringAccToEquip.dosageForm))

            let modelNo = weightTempParsingObj.modelNo.trim().slice(0, weightTempParsingObj.modelNo.indexOf(getStringAccToEquip.serialNo))
            // let startDate = weightTempParsingObj.startDate.trim().slice(0, weightTempParsingObj.startDate.indexOf(getStringAccToEquip.startTime))
            let testId = weightTempParsingObj.testId.trim().slice(0, weightTempParsingObj.testId.indexOf('Weighing Balance'))
            let groupName = weightTempParsingObj.groupName.trim().slice(0, weightTempParsingObj.groupName.indexOf(getStringAccToEquip.vaccumeBuildTm))
            let testStatus = weightTempParsingObj.testStatus.trim().slice(0, weightTempParsingObj.testStatus.indexOf(getStringAccToEquip.vaccumeReleaseTm))
            let methodName = weightTempParsingObj.methodName.trim().slice(0, weightTempParsingObj.methodName.indexOf(getStringAccToEquip.vaccumeLevel))
            let noOfPackage = weightTempParsingObj.noOfPackage.trim().slice(0, weightTempParsingObj.noOfPackage.indexOf(getStringAccToEquip.vaccumeRetentionTm))
            let desicatorSize = weightTempParsingObj.desicatorSize.trim().slice(0, weightTempParsingObj.desicatorSize.indexOf(getStringAccToEquip.vaccumePenetrationTm))
            // let limit = weightTempParsingObj.limit.trim().slice(0, weightTempParsingObj.limit.indexOf(getStringAccToEquip.dosageForm))
            let ProductDescription = weightTempParsingObj.ProductDescription.trim().slice(0, weightTempParsingObj.ProductDescription.indexOf(getStringAccToEquip.dosageUnit))
            let productName = weightTempParsingObj.productName.trim().slice(0, weightTempParsingObj.productName.indexOf(getStringAccToEquip.packageType))

            if (testStatus) {
                let validTestStatusArr = ['aborted', 'completed', 'complete', 'abort'];
                let abortTestStatusArr = ['aborted', 'abort'];
                let testStatusValue = testStatus.split(":")[1].trim().split(/[\sN]+/g)[0]
                if (!validTestStatusArr.includes(testStatusValue.toLowerCase())) {
                    return mqttSender.sendData(dsNo, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Invalid String Received`);
                }
                if(abortTestStatusArr.includes(testStatusValue.toLowerCase())) {
                    isTestAborted = true
                }
                currentData['testStatus'] = testStatusValue;
            }

            let validateNoArr = [];
            // validateNoArr.push({ testStatus: testStatus })
            validateNoArr.push({ EORT_vacuum_level: eort_vacuum_level })
            validateNoArr.push({ vaccumeLevel: vaccumeLevel })
            // validateNoArr.push({ limit: limit })
            validateNoArr.push({ noOfPackage: noOfPackage })
            validateNoArr.push({ dosageUnit: dosageUnit })
            // validateNoArr.push({ startDate: startDate })
            console.log(validateNoArr);

            let timeArr = []
            // timeArr.push({ startTime: startTime })
            timeArr.push({ vaccumeBuildTm: vaccumeBuildTm })
            timeArr.push({ vaccumeReleaseTm: vaccumeReleaseTm })
            timeArr.push({ vaccumeRetentionTm: vaccumeRetentionTm })
            timeArr.push({ vaccumePenetrationTm: vaccumePenetrationTm })

            let withoutValidationStr = [];
            withoutValidationStr.push({ serialNo: serialNo })
            withoutValidationStr.push({ modelNo: modelNo })
            withoutValidationStr.push({ instruNo: instruNo })
            withoutValidationStr.push({ testId: testId })
            withoutValidationStr.push({ groupName: groupName })
            // withoutValidationStr.push({ testStatus: testStatus })
            withoutValidationStr.push({ methodName: methodName })
            withoutValidationStr.push({ packageType: packageType })
            withoutValidationStr.push({ dosageForm: dosageForm })
            withoutValidationStr.push({ desicatorSize: desicatorSize })
            withoutValidationStr.push({ ProductDescription: ProductDescription })
            withoutValidationStr.push({ productName: productName })

            let avoidValidationtestAbortArr = ['EORT_vacuum_level', 'EORT_vacuum_level_unit', 'vaccumeBuildTm', 'vaccumeReleaseTm']

            for (let i = 0; i < validateNoArr.length; i++) {
                let e = validateNoArr[i];
                let keyName = Object.keys(validateNoArr[i])[0];
                let data = e[keyName].split(":")[1].trim().split(/[\sN]+/g)
                let value = data[0]
                if (keyName == "startDate") {
                    if (!moment(value, 'DD/MM/YYYY', true).isValid()) {
                        return mqttSender.sendData(dsNo, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Invalid String Received`);
                    }
                } else {
                    if (isTestAborted) {
                        if(avoidValidationtestAbortArr.includes(keyName) && isTestAborted && (value == '' || value == null || value == undefined)) {
                            currentData[keyName] = 'NA';
                            currentData[`${keyName}_unit`] = 'NA';
                            continue
                        }
                        if (isNaN(value) == true || value == '' || value == undefined) {
                            return mqttSender.sendData(dsNo, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Invalid String Received`);
                        }
                    }
                }

                let unit;
                if (data.length > 1) { unit = data[1] }
                if (unit) {
                    let unitKey = `${keyName}_unit`
                    console.log(unitKey);
                    if (unit != getStringAccToEquip[unitKey]) {
                        return mqttSender.sendData(dsNo, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Invalid String Received`);
                    }
                    currentData[unitKey] = unit
                }
                currentData[keyName] = value
            }

            if (!isTestAborted) {
                if ((eort_vacuum_levelIndex == -1)) {
                    return mqttSender.sendData(dsNo, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Invalid String Received`);
                }
            }
            
            for (let i = 0; i < timeArr.length; i++) {
                let e = timeArr[i];
                let keyName = Object.keys(timeArr[i])[0];
                let tm = e[keyName].slice(e[keyName].indexOf(":") + 1).trim().split(" ")[0];
                if (avoidValidationtestAbortArr.includes(keyName) && isTestAborted && (tm == '' || tm == null || tm == undefined)) {
                    currentData[keyName] = 'NA';
                    continue;
                }
                if (tm) {
                    let timeReg = /^([0-5]?\d):([0-5]?\d)$/;
                    if (keyName == 'startTime') timeReg = /^([0-5]?\d):([0-5]?\d):([0-5]?\d)?$/
                    let splitTime = tm.split(":");
                    let timeFormat = splitTime.map(item => {
                        if (item.length < 2) {
                            return '0' + item;
                        } else {
                            return item;
                        }
                    });
                    let duration = timeFormat.join(':');

                    if (timeReg.test(duration) == false) {
                        return mqttSender.sendData(dsNo, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Invalid String Received`);
                    }

                    currentData[keyName] = duration;
                } else {
                    return mqttSender.sendData(dsNo, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Invalid String Received`);
                }
            }

            for (let i = 0; i < withoutValidationStr.length; i++) {
                let e = withoutValidationStr[i];
                let keyName = Object.keys(withoutValidationStr[i])[0];
                let value = e[keyName].split(":")[1].trim()
                if (value == '' || value == undefined || value == null) {
                    return mqttSender.sendData(dsNo, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage} Invalid String Received`);
                }
                currentData[keyName] = value
            }

            currentData.result = weightTempParsingObj.result.slice(weightTempParsingObj.result.indexOf(":") + 1).trim()
            arr.push(currentData);

            if (arr.length > 0) {
                let index = globalData.arrProtocolData.findIndex(k => k.DsNo == dsNo);
                if (index != -1) {
                    globalData.arrProtocolData[index] = Object.assign(globalData.arrProtocolData[index], ...arr);
                } else {
                    currentData["DsNo"] = dsNo;
                    var objLOD = Object.assign(...arr, { "DsNo": dsNo });
                    globalData.arrProtocolData.push(objLOD);
                }
            }

            let allStringDataObj = globalData.arrProtocolData.find(k => k.DsNo == dsNo);
            let keys1 = Object.keys(getStringAccToEquip);
            let keys2 = Object.keys(allStringDataObj);
            if(isTestAborted) {
                keys1 = keys1.filter(e => !avoidValidationtestAbortArr.includes(e));
            }

            allStringDataObj.startDate = moment().format("DD/MM/YYYY")

            allStringDataObj.startTime = moment().format("HH:mm:ss")

            let isAllKeyPresent = keys1.filter(item => !keys2.includes(item));

            if (isAllKeyPresent.length != 0) {
                return mqttSender.sendData(dsNo, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage} Invalid String Received`);
            }

            const __parameterWeighmentObj = {
                DsIp: dsIp,
                DsNo: dsNo,
                TabIp: tabIp,
                stringObj: allStringDataObj,
                instrumentId: InstrumentId,
                instrumentMake: eqpMake,
                ProtocolPortNo: ProtocolPortNo,
                // decPoint: decPoint,
                // unitObj: unitObj,
                SelectedMenuDetails: SelectedMenuDetails,
                menuName: SelectedMenuDetails.menuName,
                UserData: tempUserObject,
                cubicObjData: cubicObjData,
                isTestAborted: isTestAborted
            }

            if (tempCailibType == undefined) {
                if (currentOpStatus == undefined) {
                    loggers.MqttProtocolLogger.info(`Weight recieve without any api called`)
                    console.log('wt recieve without any api called');
                    return;
                } else if (currentOpStatus.Weighment == 1 && currentOpStatus.testType == "Weighment") {
                    console.log("-----------ParsingTestData--------------------------");
                    await objWeighmentData.ParsingTestData(InstrumentType, __parameterWeighmentObj);
                }
            } else {
                console.log('calibration is on and dt weighment part has clash')
            }

            return

        } catch (err) {
            throw new Error(err);
        }
    }

    getStringAccToEquip(model) {
        try {
            let obj = {};
            switch (model) {
                case "ELT-201WP":
                    obj.modelNo = "Model No.";
                    obj.serialNo = "Serial No.";
                    obj.instruNo = "Instrument No."; // Not Storing
                    // obj.startDate = "Start Date";
                    // obj.startTime = "Start Time";
                    obj.testStatus = "Test Status";
                    obj.testId = "Test ID";
                    obj.EORT_vacuum_level = "EORT Vacuum Level";
                    obj.EORT_vacuum_level_unit = "mmHg";
                    obj.vaccumeBuildTm = "Vacuum Build Time";
                    obj.vaccumeReleaseTm = "Vacuum Release Time";
                    obj.methodName = "Method Name";
                    obj.vaccumeLevel = "Vacuum Level";
                    obj.vaccumeLevel_unit = "mmHg";
                    obj.noOfPackage = "No. of Packages";
                    obj.vaccumeRetentionTm = "Vacuum Retention Time";
                    obj.vaccumePenetrationTm = "Vacuum Penetration Time";
                    obj.desicatorSize = "Desiccator Size";
                    // obj.limit = "Limit";
                    // obj.limit_unit = "mg";
                    obj.packageType = "Package Type";
                    obj.dosageUnit = "Dosage Units";
                    obj.dosageForm = "Dosage Form";
                    obj.result = "Result";
                    obj.groupName = "Group Name";
                    obj.ProductDescription = "Product Description";
                    obj.productName = "Product Name";
                    break;
                default:
                    obj = {};
                    break;
            }

            return obj
        } catch (err) {
            throw new Error(error)
        }
    }
}

module.exports = LeakParsing;