const moment = require('moment');


const ClassweighmentData = require('../clsProcessWeighment.model');
const mqttProtocol = require('../../global/GLOBAL_NOMENCLATURE');
const classHmi = require('../hmiDetail.model');
const loggers = require('../winstonLogger');
const globalData = require('../../global/globalData');
const clsMqttSender = require('../Mqtt/mqttSender.class');
const clsActivityLog = require("../clsActivityLog.model");
const clsInstrumentUsage = require("../clsInstrumentUsageLog");

const objWeighmentData = new ClassweighmentData();
const clsMenuRequest = require('../Menu/MenuRequest.model');

const objHmi = new classHmi();
const mqttSender = new clsMqttSender();
const objMenuRequest = new clsMenuRequest();
const objActivityLog = new clsActivityLog();
const objInstrumentUsage = new clsInstrumentUsage();
const { create, all } = require("mathjs");
const { models } = require('../../../config/dbConnection');
const { date } = require('joi');
const { DateTime } = require('mssql');
const config = {};
const mathj = create(all, config);

class MoistureAnalyserParsing {

    precision(a) {
        if (!isFinite(a)) return 0;
        var e = 1, p = 0;
        while (Math.round(a * e) / e !== a) { e *= 10; p++; }
        return p;
    }

    async parsingMoistData(dataObj) {
        try {
            let { InstrumentId , InstrumentType} = dataObj
            //const EQUIP_MODEL_NAME = await this.getDetailOfBulkInstrumentModel(instrumentId);
            // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == dataObj.strHmi);
            // if (IPQCObject != undefined) {
            //     selectedIdsNo = IPQCObject.selectedIds.idsNo;
            // } else {
            //     selectedIdsNo = strIdsNo;
            // }
            let MoistModel = await objMenuRequest.getDetailOfBulkInstrumentModel(InstrumentId , InstrumentType);
            // var mainmodels = DTModel.Eqp_Model 
            // dataObj.mainmodels = mainmodels
            // if (MoistModel.Eqp_Model == 'MA150') {
            //     // await this.parseBulkWeighmentDT(dataObj);
            //     await this.parseMoistureAnalyserData(dataObj);
            //     return
            // }
            if (MoistModel.Eqp_Model == 'HX204') {
                await this.parseMoistureAnalyserDataHX204(dataObj);
                return
            } else if (MoistModel.Eqp_Model == 'MA160-1' || MoistModel.Eqp_Model == 'MA150') {
                let getStringAccToEquip = this.getStringAccToEquip(MoistModel.Eqp_Model);
                await this.parseMoistureAnalyserDataMA160(dataObj, getStringAccToEquip, MoistModel.Eqp_Model);
                return
            } else if (MoistModel.Eqp_Model == 'HB-43') {
                await this.parseMoistureAnalyserDataHB43(dataObj);
                return
            } else if (MoistModel.Eqp_Model == 'HB43-S') {
                await this.parseMoistureAnalyserDataHB43S(dataObj);
                return
            }

        } catch (error) {
            throw new Error(error)
        }
    }

    getStringAccToEquip(model) {
        try {
            let obj = {};
            switch (model) {
                case 'MA160-1':
                    obj.mod = "Mod.",
                        obj.temp = "Temperature";
                    obj.strtWt = "Start weight";
                    obj.time = "Measurement time";
                    obj.endWt = "Final weight";
                    obj.index = 1;
                    obj.timeSeparator = ":";
                    break;
                case "MA150":
                    obj.mod = "Mod.",
                        obj.temp = "Fin. temp.";
                    obj.strtWt = "IniWt";
                    obj.time = "Time";
                    obj.endWt = "FinWt";
                    obj.index = 0;
                    obj.timeSeparator = ".";
                    break;
                default:
                    obj = {};
                    break;
            }

            return obj
        } catch (err) {
            throw new Error(err)
        }
    }

    // async parseMoistureAnalyserDataMA160(dataObj, getStringAccToEquip, model) {
    //     try {
    //         let { Str_Protocol, ProtocolPortNo, SelectedMenuDetails, currentOpStatus, tempCailibType, InstrumentType } = dataObj;
    //         var dsNo = SelectedMenuDetails.DsNo;
    //         var dsIp = SelectedMenuDetails.DsIp;
    //         let tabIp = SelectedMenuDetails.TabIp
    //         let menuName = SelectedMenuDetails.menuName
    //         let unitObj = objWeighmentData.getUnitObj(menuName);
    //         let decPoint = unitObj.decPoint;
    //         var actualProtocol = Str_Protocol.trim();
    //         let str_1 = actualProtocol.split("\n");
    //         let arr = [];
    //         let currentData = {}

    //         const tempUserObject = globalData.arrUsers.find(k => k.DsNo == dsNo);
    //         let cubicObjData = globalData.arrIdsInfo.find((k) => k.DsNo == dsNo);

    //         str_1[0] = str_1[0].replace(/comread/i, "COMREAD");
    //         if (str_1[0].includes("COMREAD")) {
    //             str_1[0] = str_1[0].replace(`COMREAD:${ProtocolPortNo}:`, '');
    //         }

    //         // var typeIndex = str_1.findIndex(p => p.includes(getStringAccToEquip.mod));
    //         var dryingTempIndex = str_1.findIndex(p => p.includes(getStringAccToEquip.temp));
    //         var startWeightIndex = str_1.findIndex(p => p.includes(getStringAccToEquip.strtWt));
    //         var totalTimeIndex = str_1.findIndex(p => p.includes(getStringAccToEquip.time));
    //         var dryWeightIndex = str_1.findIndex(p => p.includes(getStringAccToEquip.endWt));

    //         let weightTempParsingArr = [];
    //         // if (typeIndex != -1) var type = str_1[typeIndex];
    //         if (dryingTempIndex != -1) weightTempParsingArr.push({ temp: str_1[dryingTempIndex + getStringAccToEquip.index] });
    //         if (startWeightIndex != -1) weightTempParsingArr.push({ strtWt: str_1[startWeightIndex + getStringAccToEquip.index] });
    //         if (dryWeightIndex != -1) weightTempParsingArr.push({ endWt: str_1[dryWeightIndex + getStringAccToEquip.index] });
    //         if (totalTimeIndex != -1) var totalTime = str_1[totalTimeIndex + getStringAccToEquip.index];

    //         // if (type) {
    //         //     let Modal = type.replace(getStringAccToEquip.mod, ' ').trim().split();
    //         //     Modal = Modal[0]
    //         //     // if (Modal != LodModel) {
    //         //     //   return mqttSender.sendData(dsNo, `${mqttProtocol.DisplayMessage}Invalid String Received`);
    //         //     // }
    //         //     obj["Modal"] = Modal;
    //         //     arr.push({ "Modal": Modal })
    //         // }
    //         let isInvalidString = false;
    //         let unitArr = ["g", "gm"];
    //         for (let i = 0; i < weightTempParsingArr.length; i++) {
    //             let e = weightTempParsingArr[i];
    //             let keyName = Object.keys(weightTempParsingArr[i])[0];
    //             let result = e[keyName].trim().split(/[\sN]+/g).filter((k) => k != "" && k != '+')
    //             let unit = result[result.length - 1];
    //             let value = result.filter(e => !isNaN(e))[0];
    //             if (isNaN(value) == true || value == '' || value == undefined) {
    //                 isInvalidString = true
    //                 break;
    //             }
    //             if (keyName == "temp") {
    //                 if (unit && unit != `'C`) {
    //                     isInvalidString = true
    //                     break;
    //                 }
    //                 result = value;
    //             } else {
    //                 if (unit && !unitArr.includes(unit)) {
    //                     isInvalidString = true
    //                     break;
    //                 }
    //                 result = Number(mathj.round(value, decPoint)).toFixed(decPoint);
    //             }

    //             result = { [keyName]: result };
    //             if ([keyName] == 'strtWt') {
    //                 result.PrDate = moment().format('YYYY-MM-DD');
    //                 result.PrTime = moment().format('HH:mm:ss');
    //                 if (arr.length == 0) {
    //                     let findModel = globalData.arrProtocolData.find(e => e.Hmi == dsNo);
    //                     if (findModel) { result.Modal = findModel.Modal }
    //                 } else {
    //                     result.Modal = arr[0].Modal
    //                 }
    //             }
    //             if ([keyName] == "endWt") {
    //                 result.PrEndDate = moment().format('YYYY-MM-DD');
    //                 result.PrEndTime = moment().format('HH:mm:ss');
    //             }
    //             currentData[keyName] = result;
    //             arr.push({ [keyName]: result })
    //             console.log(keyName);
    //         }

    //         if (isInvalidString) {
    //             return mqttSender.sendData(dsNo, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Invalid String Received`);
    //         }

    //         if (totalTime) {
    //             if (!/[1-9]/.test(totalTime)) {
    //                 return mqttSender.sendData(dsNo, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Invalid String Received`);
    //             }

    //             const timeRegex = new RegExp(`(\\d+${getStringAccToEquip.timeSeparator}\\d+)`);
    //             const match = totalTime.match(timeRegex);

    //             if (match) {
    //                 var timeString = match[1];
    //                 const [hours, minutes] = timeString.split(getStringAccToEquip.timeSeparator).map(Number);
    //                 const totalTimeInMinutes = hours * 60 + minutes;
    //                 console.log('Total time in minutes:', totalTimeInMinutes);
    //             } else {
    //                 return mqttSender.sendData(dsNo, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Invalid String Received`);
    //             }
    //             var Total_Time = totalTime.replace(getStringAccToEquip.time, ' ').trim().split();
    //             Total_Time = Total_Time[0]
    //             var time_data = Total_Time.trim().split(' min')[0];
    //             var time = /^([0-1]?\d|2[0-3])(?::([0-5]?\d))?(?::([0-5]?\d))?$/

    //             let splitTime = time_data.split(getStringAccToEquip.timeSeparator);
    //             if (splitTime.length <= 2) splitTime.unshift("00");
    //             let timeFormat = splitTime.map(item => {
    //                 if (item.length < 2) {
    //                     return '0' + item;
    //                 } else {
    //                     return item;
    //                 }
    //             });
    //             let duration = timeFormat.join(':');

    //             if (time.test(duration) == false) {
    //                 return mqttSender.sendData(dsNo, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Invalid String Received`);
    //             }

    //             timeString = { 'time': duration, 'flag': true };
    //             currentData["time"] = duration;
    //             arr.push({ "time": duration })
    //         }

    //         if (arr.length > 0) {
    //             let index = globalData.arrProtocolData.findIndex(k => k.DsNo == dsNo);
    //             if (index != -1) {
    //                 globalData.arrProtocolData[index] = Object.assign(globalData.arrProtocolData[index], ...arr);
    //             } else {
    //                 currentData["DsNo"] = dsNo;
    //                 // var objLOD = Object.assign(...arr, { "DsNo": dsNo });
    //                 globalData.arrProtocolData.push(currentData);
    //                 if (currentData.hasOwnProperty("strtWt")) {
    //                     let activity_msg = `${menuName} Test Started on DS ${dsNo}`
    //                     let __activityObj = {
    //                         strUserId: tempUserObject.UserId,
    //                         strUserName: tempUserObject.UserName,
    //                         activity: activity_msg,
    //                     };

    //                     await objActivityLog.ActivityLogEntry(__activityObj);
    //                     await objInstrumentUsage.InstrumentUsage(
    //                         'LOD',
    //                         dsNo,
    //                         `tbl_instrumentlog_lod`,
    //                         menuName,
    //                         "started",
    //                         tabIp,
    //                         tempUserObject,
    //                         cubicObjData,
    //                     );
    //                 }
    //             }

    //             let allStringDataObj = globalData.arrProtocolData.find(k => k.DsNo == dsNo);
    //             dataObj.CurrentDataReceivedFromStr = arr;
    //             let keys1 = Object.keys(getStringAccToEquip);
    //             let keys2 = Object.keys(allStringDataObj);
    //             keys1 = keys1.filter(e => e != "mod" && e != "index" && e != "timeSeparator");
    //             keys2 = keys2.filter(e => e != "DsNo" && e != "unit");

    //             if (model == "MA150") {
    //                 if (!allStringDataObj.hasOwnProperty("temp") || !allStringDataObj.hasOwnProperty("time") || !allStringDataObj.hasOwnProperty("strtWt")) {
    //                     let indexToDelete = globalData.arrProtocolData.findIndex(k => k.DsNo == dsNo);
    //                     if (indexToDelete != -1) { globalData.arrProtocolData.splice(indexToDelete, 1) }
    //                     return mqttSender.sendData(dsNo, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage} Invalid String Received`);
    //                 } else if (!allStringDataObj.hasOwnProperty("temp") && !allStringDataObj.hasOwnProperty("time") && !allStringDataObj.hasOwnProperty("strtWt") && !obj.hasOwnProperty("endWt")) {
    //                     return mqttSender.sendData(dsNo, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage} Invalid String Received`);
    //                 }
    //             }

    //             if (keys1.length === keys2.length && keys1.every(key => keys2.includes(key))) {
    //                 let strInstrumentId = dataObj.InstrumentId;

    //                 let finalObj = {
    //                     temp: allStringDataObj.temp,
    //                     strtWt: allStringDataObj.strtWt,
    //                     endWt: allStringDataObj.endWt,
    //                     time: allStringDataObj.time,
    //                     DsNo: allStringDataObj.DsNo,
    //                 }

    //                 const __parameterWeighmentObj = {
    //                     DsIp: dsIp,
    //                     DsNo: dsNo,
    //                     TabIp: tabIp,
    //                     actualWt: finalObj,
    //                     instrumentId: strInstrumentId,
    //                     ProtocolPortNo: ProtocolPortNo,
    //                     decPoint: decPoint,
    //                     unitObj: unitObj,
    //                     SelectedMenuDetails: SelectedMenuDetails,
    //                     menuName: SelectedMenuDetails.menuName,
    //                     UserData: tempUserObject,
    //                     cubicObjData: cubicObjData
    //                     // unit: ProtocolUnit,
    //                 }

    //                 if (tempCailibType == undefined) {
    //                     if (currentOpStatus == undefined) {
    //                         loggers.MqttProtocolLogger.info(`Weight recieve without any api called`)
    //                         console.log('wt recieve without any api called');
    //                         return;
    //                     } else if (currentOpStatus.Weighment == 1 && currentOpStatus.testType == "Weighment") {
    //                         console.log("-----------ParsingTestData--------------------------");
    //                         await objWeighmentData.ParsingTestData(InstrumentType, __parameterWeighmentObj);
    //                     }
    //                 } else {
    //                     console.log('calibration is on and dt weighment part has clash')
    //                 }
    //             } else {
    //                 if (model == "MA150") {
    //                     return mqttSender.sendData(dsNo, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage} received`);
    //                 } else {
    //                     let indexToDelete = globalData.arrProtocolData.findIndex(k => k.DsNo == dsNo);
    //                     if (indexToDelete != -1) { globalData.arrProtocolData.splice(indexToDelete, 1) }
    //                     return mqttSender.sendData(dsNo, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage} Invalid String Received`);
    //                 }
    //             }
    //         } else {
    //             return mqttSender.sendData(dsNo, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage} Invalid String Received`)
    //         }


    //         // if (arr == "") {
    //         //     return mqttSender.sendData(dsNo, "Invalid String Recieved")
    //         // } else {
    //         //     //decision making 
    //         //     if (tempCailibType == undefined) {
    //         //         if (currentOpStatus == undefined) {
    //         //             loggers.MqttProtocolLogger.info(`Weight recieve without any api called`)
    //         //             console.log('wt recieve without any api called');
    //         //             return;
    //         //         } else if (currentOpStatus.Weighment == 1 && currentOpStatus.testType == "Weighment") {
    //         //             console.log("-----------ParsingTestData--------------------------");
    //         //             await objWeighmentData.ParsingTestData(__parameterWeighmentObj);
    //         //         }
    //         //     } else {
    //         //         console.log('calibration is on and dt weighment part has clash')
    //         //     }
    //         // }
    //     } catch (error) {
    //         throw new Error(error)
    //     }
    // }

    //     async parseMoistureAnalyserData(dataObj) {
    //         try {
    //             let { str_Protocol, strResberryPi, strHmi, Ip, ProtocolPortNo, instrumentId, ProtocolName } = dataObj;
    //             //here also different balance have different parsing logic
    //             let data_array = str_Protocol.split("\n");
    //             let data = str_Protocol.split(":")[2].trim();
    //             let test_duration_found = false;
    //             var InitalWt, FinalWt, FinTemp, Time
    //             let arm_found = false;
    //             let arr = [];
    //             let obj = {}


    //             let main = globalData.dataMoist.find(k => k.Ip == Ip)

    //             if (main == undefined) {
    //                 let obj = globalData.dataMoist.push({
    //                     hmi: strHmi,
    //                     IniWt: InitalWt,
    //                     FinWt: FinalWt,
    //                     Fin: FinTemp,
    //                     Time: Time,
    //                     Ip: Ip

    //                 })
    //             }
    //             for (let i = 0; i < data_array.length; i++) {
    //                 // data = data_array[i].trim();
    //                 if (data == "" || data == null)
    //                     continue;
    //                 if (data_array[i].includes("IniWt +")) {
    //                     let InitalWt = data_array[i].replace('IniWt +', ' ').trim().split();
    //                     InitalWt = InitalWt[0];
    //                     obj["IniWt"] = InitalWt;
    //                     // arr.push({ SWunit: SWunit })
    //                     let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
    //                     globalData.dataMoist[index].IniWt = InitalWt
    //                     continue;
    //                 }
    //                 if (data_array[i].includes("FinWt +")) {
    //                     let FinalWt = data_array[i].replace('FinWt +', ' ').trim().split();
    //                     FinalWt = FinalWt[0];
    //                     obj["FinWt"] = FinalWt;
    //                     // arr.push({ SWterminal: SWterminal })
    //                     let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
    //                     globalData.dataMoist[index].FinWt = FinalWt
    //                     continue;
    //                 }
    //                 if (data_array[i].includes("Fin. temp.")) {
    //                     let FinTemp = data_array[i].replace('Fin. temp.', ' ').trim().split();
    //                     FinTemp = FinTemp[0];
    //                     obj["Fin. temp."] = FinTemp
    //                     let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
    //                     globalData.dataMoist[index].Fin = FinTemp
    //                     // arr.push({ DryTemp: DryTemp })
    //                     continue;
    //                 }
    //                 if (data_array[i].includes("Time")) {
    //                     let Time = data_array[i].replace('Time', ' ').trim().split();
    //                     Time = Time[0];
    //                     obj["Time"] = Time;
    //                     // arr.push({ SWterminal: SWterminal })
    //                     let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
    //                     globalData.dataMoist[index].Time = Time
    //                     continue;
    //                 }
    //             }
    //             let index1 = globalData.dataMoist.find(k => k.Ip == Ip)
    //             if (index1 != undefined) {
    //                 if (index1.IniWt == undefined && index1.Fin == undefined) {
    //                     globalData.dataMoist.findIndex((k) => k.Ip == Ip) == -1
    //                         ? globalData.dataMoist
    //                         : globalData.dataMoist.splice(
    //                             globalData.dataMoist.findIndex(
    //                                 (k) => k.Ip == Ip), 1
    //                         );
    //                     mqttSender.sendData(Ip, `${mqttProtocol.DisplayMessage}Invalid String recieved`)
    //                     return
    //                 }
    //                 if (index1.IniWt != undefined && index1.FinWt == undefined && index1.Fin != undefined) {
    //                     return mqttSender.sendData(Ip, "received")
    //                 }
    //             }
    //             arr.push(obj);
    //             // const TimeFormat = "HH:mm:ss";

    //             console.log(arr)
    //             if (arr.length == 0) {
    //                 globalData.dataMoist.findIndex((k) => k.Ip == Ip) == -1
    //                     ? globalData.dataMoist
    //                     : globalData.dataMoist.splice(
    //                         globalData.dataMoist.findIndex(
    //                             (k) => k.Ip == Ip), 1
    //                     );
    //                 mqttSender.sendData(Ip, `${mqttProtocol.DisplayMessage}Invalid String recieved`)
    //                 return
    //             }
    //             let dtData = globalData.arrWeighmentProductData.find(k => k.Ip == Ip).data;


    //             let currentOpStatus = globalData.arrCurrentOperationStatus.find(k => k.Ip == Ip);
    //             let tempCailibType = globalData.arrcalibType.find(k => k.Hmi == strHmi);
    //             // let arrPortDetailForStart1 = await objHmi.idsPortSetting(strHmi)
    //             let intPortNo1 = dataObj.ProtocolPortNo;
    //             let strInstrumentType = dataObj.InstrumentType;
    //             let strInstrumentId = dataObj.InstrumentId;
    //             const __parameterWeighmentObj = {
    //                 idsNo: strResberryPi,
    //                 Hmi: strHmi,
    //                 actualWt: arr[0],
    //                 instrumentId: strInstrumentId,
    //                 Ip: Ip
    //             }
    //             if (arr == "") {
    //                 globalData.dataMoist.findIndex((k) => k.Ip == Ip) == -1
    //                     ? globalData.dataMoist
    //                     : globalData.dataMoist.splice(
    //                         globalData.dataMoist.findIndex(
    //                             (k) => k.Ip == Ip), 1
    //                     );
    //                 mqttSender.sendData(Ip, `${mqttProtocol.DisplayMessage}Invalid String recieved`)
    //                 return
    //             } else {
    //                 // if (strInstrumentType == GLOBAL_NOMENCLATURE.Balance) {
    //                 //     if (ProtocolUnit == undefined) {
    //                 //         ProtocolUnit = ProtocolUnit == undefined ? "g" : ProtocolUnit;
    //                 //     } else {
    //                 //         if ((ProtocolUnit != "g") && (ProtocolUnit != "kg") && (ProtocolUnit != "mg")) {
    //                 //             //log protocol in file
    //                 //             loggers.MqttProtocolLogger.info(`protocol : ${mqttProtocol.DisplayMessage}Invalid Data String sended to device ${strHmi}`)
    //                 //             return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid Data String`);
    //                 //         } else {
    //                 //             if (ProtocolUnit == "mg") {
    //                 //                 actualWt = actualWt / 1000;
    //                 //             } else if (ProtocolUnit == ("kg" || "Kg" || "KG")) {
    //                 //                 actualWt = actualWt * 1000;
    //                 //             }
    //                 //             ProtocolUnit = ProtocolUnit == undefined ? "g" : ProtocolUnit;

    //                 //         }
    //                 //     }

    //                 // } else {
    //                 //     //log protocol in file
    //                 //     loggers.MqttProtocolLogger.info(`unknown instrument`)
    //                 //     console.log('unknown instrument');
    //                 // }

    //                 //decision making 
    //                 if (tempCailibType == undefined) {
    //                     if (currentOpStatus == undefined) {
    //                         loggers.MqttProtocolLogger.info(`Weight recieve without any api called`)
    //                         console.log('wt recieve without any api called');
    //                         return;
    //                     } else if (currentOpStatus.Weighment == 1 && currentOpStatus.testType == "Weighment") {

    //                         var instrumentData = str_Protocol.split(":").splice(2).toString()
    //                         await objWeighmentData.ParsingTestData(__parameterWeighmentObj, instrumentData);
    //                     }
    //                 } else {
    //                     console.log('calibration is on and dt weighment part has clash')
    //                 }
    //             }
    //             // }
    //         } catch (error) {
    //             throw new Error(error)
    //         }
    //     }

    async parseMoistureAnalyserDataHX204(dataObj) {
        try {
            let { Str_Protocol, strResberryPi, strHmi, Ip, ProtocolPortNo, SelectedMenuDetails, instrumentId, ProtocolName } = dataObj;
            //here also different balance have different parsing logic
            let data_array = Str_Protocol.split("\n");
            let data = Str_Protocol.split(":")[2].trim();
            Ip = dataObj.TabIp
            strResberryPi = dataObj.currentOpStatus.DsNo
            let test_duration_found = false;
            let arm_found = false;
            var DryTemp, StrWeight, EndRes, Totaltime, FinalWt
            let arr = [];
            let obj = {}

            let main = globalData.dataMoist.find(k => k.Ip == Ip)

            if (main == undefined) {
                let obj = globalData.dataMoist.push({
                    hmi: strHmi,
                    DryingTemp: DryTemp,
                    StartWeight: StrWeight,
                    FinWt: FinalWt,
                    EndResult: EndRes,
                    Total: Totaltime,
                    Ip: Ip

                })
            }
            var isAborted = 0;

            obj["IPQC Instrument ID"] = dataObj.InstrumentId

            let cubicaldata = await models.tbl_cubical.findOne({
                where: {
                    Sys_DSNumber: dataObj.currentOpStatus.DsNo
                }
            })

            var cubicObj = {}
            cubicObj.cubicalData = cubicaldata

            for (let i = 0; i < data_array.length; i++) {
                // data = data_array[i].trim();
                if (data == "" || data == null)
                    continue;
                if (data_array[i].includes("SNR(Terminal)")) {
                    let srNo = data_array[i].replace('SNR(Terminal)', ' ').trim().split();
                    srNo = srNo[0];
                    obj["SNR"] = srNo;
                    // arr.push({ SWunit: SWunit })
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].srno = srNo
                    continue;
                }
                if (data_array[i].includes("SW(Drying Unit)")) {
                    let SWunit = data_array[i].replace('SW(Drying Unit)', ' ').trim().split();
                    SWunit = SWunit[0];
                    obj["SW (Drying Unit)"] = SWunit;
                    // arr.push({ SWunit: SWunit })
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].SW = SWunit
                    continue;
                }
                if (data_array[i].includes("SW(Terminal)")) {
                    let SWterminal = data_array[i].replace('SW(Terminal)', ' ').trim().split();
                    SWterminal = SWterminal[0];
                    obj["SW (Terminal)"] = SWterminal;
                    // arr.push({ SWterminal: SWterminal })
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].SW = SWterminal
                    continue;
                }
                if (data_array[i].includes("Method Name")) {

                    // var newStringData = data_array.join('\n');

                    // var tempdata = newStringData.slice(
                    //     newStringData.lastIndexOf("Method Name"),
                    //     newStringData.lastIndexOf("Drying Prog"),
                    // );

                    // let Pname = data_array[i+1].replace('Method Name', ' ').trim().split();
                    let Pname = data_array[i].replace('Method Name', ' ').trim().split();
                    if (Pname[0] == '') {
                        Pname = data_array[i + 1].replace('Method Name', ' ').trim().split();
                        if (!data_array[i + 2].includes("Drying Prog")) {
                            var tempname = data_array[i + 2].replace('Method Name', ' ').trim().split();
                            Pname = Pname[0] + tempname[0]
                            Pname = [Pname]
                        }
                    }
                    Pname = Pname[0];
                    obj["Product Name"] = Pname;
                    // arr.push({ SWterminal: SWterminal })
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].Pname = Pname
                    continue;
                }
                if (data_array[i].includes("Drying Prog")) {
                    let DryProg = data_array[i].replace('Drying Prog', ' ').trim().split();
                    DryProg = DryProg[0];
                    obj["Drying Prog"] = DryProg ? DryProg : "NA";
                    // arr.push({ DryTemp: DryTemp })
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].DryProg = DryProg
                    continue;
                }
                if (data_array[i].includes("Switch Off")) {
                    let Switchoff = data_array[i].replace('Switch Off', ' ').trim().split();
                    Switchoff = Switchoff[0];
                    obj["Switch Off"] = Switchoff;
                    // arr.push({ SWterminal: SWterminal })
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].SWoff = Switchoff
                    continue;
                }
                if (data_array[i].includes("Drying Temp")) {
                    let DryTemp = data_array[i].replace('Drying Temp', ' ').trim().split();
                    DryTemp = DryTemp[0].split(" ")[0];
                    obj["Drying Temp"] = DryTemp
                    // arr.push({ DryTemp: DryTemp })
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].DryingTemp = DryTemp
                    continue;
                }
                if (data_array[i].includes("Start Weight")) {
                    let StrWeight = data_array[i].replace('Start Weight', ' ').trim().split();
                    StrWeight = StrWeight[0];
                    obj["Start Weight"] = StrWeight
                    // arr.push({ StrWeight: StrWeight })
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].StartWeight = StrWeight
                    continue;
                }
                if (data_array[i].includes("Dry Weight")) {
                    let FinalWt = data_array[i].replace('Dry Weight', ' ').trim().split();
                    FinalWt = FinalWt[0];
                    obj["Dry Weight"] = FinalWt;
                    // arr.push({ SWterminal: SWterminal })
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].FinWt = FinalWt
                    continue;
                }
                if (data_array[i].includes("Total time")) {
                    let Totaltime = data_array[i].replace('Total time', ' ').trim().split();
                    // Totaltime = "00:" + Totaltime[0].split(" ")[0] + ' ' + Totaltime[0].split(" ")[1]
                    Totaltime = Totaltime[0];
                    obj["Total time"] = Totaltime
                    // arr.push({ Totaltime: Totaltime })
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].Total = Totaltime
                    continue;
                }
                if (data_array[i].includes("End Result")) {
                    let EndRes = data_array[i].replace('End Result', ' ').trim().split();
                    EndRes = EndRes[0].split('%')[0] + "%W/W";
                    // EndRes = EndRes[0];
                    obj["End Result"] = EndRes
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].EndResult = EndRes
                    // arr.push({ EndRes: EndRes })
                    continue;
                }
                if (data_array[i].includes("Measurement end")) {
                    let Measurementend = data_array[i + 1].replace('Measurement end', ' ').trim().split(" ");
                    Measurementend = Measurementend[0] + ' ' + Measurementend[1];
                    obj["Measurement end"] = Measurementend
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].Measurementend = Measurementend
                    // arr.push({ EndRes: EndRes })
                    continue;
                }
                if (data_array[i].includes("ABORTED")) {
                    isAborted = 1
                    continue;
                }
                if (data_array[i].includes("Batch No")) {
                    let batchNo = data_array[i].replace('Batch No', ' ').trim().split();

                    if (batchNo != cubicaldata[0].Sys_Batch) {
                        isAborted = 1
                    }
                    continue;
                }
            }

            // var cubicObj = globalData.arrIdsInfo.find(k => k.TabIp == Ip);

            var userInfo = globalData.arrUsers.find(k => k.TabIp == Ip);

            isAborted = this.isAbort(obj, isAborted);

            if (isAborted == 1) {
                mqttSender.sendData(strResberryPi, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Invalid String received`)
                let _activityObj = {
                    strUserId: userInfo.UserId,
                    strUserName: userInfo.UserName,
                    batch: cubicObj.cubicalData.Sys_Batch,
                    activity: `Invalid String received`
                };

                await objActivityLog.ActivityLogEntry(_activityObj);
                return
            }

            let index1 = globalData.dataMoist.find(k => k.Ip == Ip)
            if (index1 != undefined) {
                if (index1.StartWeight == undefined || index1.EndResult == undefined || index1.DryingTemp == undefined) {
                    mqttSender.sendData(strResberryPi, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Invalid String recieved`)
                    return
                }
                if (index1.StartWeight != undefined && index1.EndResult == undefined && index1.DryingTemp != undefined) {
                    return mqttSender.sendData(strResberryPi, "received")
                }
            }

            arr.push(obj);
            // const TimeFormat = "HH:mm:ss";

            console.log(arr)
            if (arr.length == 0) {
                mqttSender.sendData(strResberryPi, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Invalid String recieved`)
                return
            }
            let dtData = globalData.arrWeighmentProductData.find(k => k.TabIp == Ip).data;


            // let currentOpStatus = globalData.arrCurrentOperationStatus.find(k => k.TabIp == Ip);
            // let tempCailibType = globalData.arrcalibType.find(k => k.Hmi == strHmi);
            let currentOpStatus = globalData.arrCurrentOperationStatus.find(k => k.DsNo == SelectedMenuDetails.DsNo && k.TabIp == Ip);
            let tempCailibType = globalData.arrcalibType.find(k => k.DsNo == SelectedMenuDetails.DsNo && k.TabIp == Ip);

            // let arrPortDetailForStart1 = await objHmi.idsPortSetting(strHmi)
            let intPortNo1 = dataObj.ProtocolPortNo;
            let strInstrumentType = dataObj.InstrumentType;
            let strInstrumentId = dataObj.InstrumentId;

            var __parameterWeighmentObj = {
                DsNo: SelectedMenuDetails.DsNo,
                TabIp: SelectedMenuDetails.TabIp,
                DsIp: SelectedMenuDetails.DsIp,
                instrumentId: strInstrumentId,
                ProtocolPortNo: intPortNo1,
                SelectedMenuDetails: SelectedMenuDetails,
                menuName: SelectedMenuDetails.menuName,
                idsNo: strResberryPi,
                Hmi: strHmi,
                actualWt: arr[0],
                instrumentId: strInstrumentId,
                Ip: Ip,
                cubicObjData: cubicObj
            }

            if (arr == "") {
                mqttSender.sendData(strResberryPi, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Invalid String recieved`)
                return
            } else {
                // if (strInstrumentType == GLOBAL_NOMENCLATURE.Balance) {
                //     if (ProtocolUnit == undefined) {
                //         ProtocolUnit = ProtocolUnit == undefined ? "g" : ProtocolUnit;
                //     } else {
                //         if ((ProtocolUnit != "g") && (ProtocolUnit != "kg") && (ProtocolUnit != "mg")) {
                //             //log protocol in file
                //             loggers.MqttProtocolLogger.info(`protocol : ${mqttProtocol.DisplayMessage}Invalid Data String sended to device ${strHmi}`)
                //             return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid Data String`);
                //         } else {
                //             if (ProtocolUnit == "mg") {
                //                 actualWt = actualWt / 1000;
                //             } else if (ProtocolUnit == ("kg" || "Kg" || "KG")) {
                //                 actualWt = actualWt * 1000;
                //             }
                //             ProtocolUnit = ProtocolUnit == undefined ? "g" : ProtocolUnit;

                //         }
                //     }

                // } else {
                //     //log protocol in file
                //     loggers.MqttProtocolLogger.info(`unknown instrument`)
                //     console.log('unknown instrument');
                // }

                //decision making 
                if (tempCailibType == undefined) {
                    if (currentOpStatus == undefined) {
                        loggers.MqttProtocolLogger.info(`Weight recieve without any api called`)
                        console.log('wt recieve without any api called');
                        return;
                    } else if (currentOpStatus.Weighment == 1 && currentOpStatus.testType == "Weighment") {

                        // var instrumentData = `-MOISTURE DETERMINATION-

                        // End Result      ${obj["End Result"]}
                        // Measurement end
                        //         ${moment().format("DD.MM.YYYY HH:mm")}

                        // ---------- END ---------`

                        //                         var instrumentData = `Start Weight     ${obj["Start Weight"]}
                        // Dry Weight     ${obj["Dry Weight"]}
                        // End Result      ${obj["End Result"]}
                        //  `

                        // var instrumentData = `Start Weight     ${obj["Start Weight"]}
                        // Total time      ${obj["Total time"]}
                        // Dry Weight     ${obj["Dry Weight"]}
                        // End Result      ${obj["End Result"]}` 


                        // var instrumentData = `Dry Weight     ${obj["Dry Weight"]}`;
                        await objWeighmentData.ParsingTestData(mqttProtocol.LODMenu, __parameterWeighmentObj);
                    }
                } else {
                    console.log('calibration is on and dt weighment part has clash')
                }
            }
            // }
        } catch (error) {
            throw new Error(error)
        }
    }

    async parseMoistureAnalyserDataHB43(dataObj) {
        try {
            let { Str_Protocol, strResberryPi, strHmi, Ip, ProtocolPortNo, SelectedMenuDetails, instrumentId, ProtocolName } = dataObj;
            //here also different balance have different parsing logic
            // Str_Protocol.repl
            let data = Str_Protocol.split(":")[2].trim();
            Str_Protocol = Str_Protocol.replace(`ComRead:${ProtocolPortNo}:`, '');
            let data_array = Str_Protocol.split("\n");

            Ip = dataObj.TabIp
            strResberryPi = dataObj.currentOpStatus.DsNo
            let test_duration_found = false;
            let arm_found = false;
            var DryTemp, StrWeight, EndRes, Totaltime, FinalWt
            let arr = [];
            let obj = {}

            let main = globalData.dataMoist.find(k => k.Ip == Ip && k.DsNo == SelectedMenuDetails.DsNo)

            if (main == undefined) {
                let obj = globalData.dataMoist.push({
                    hmi: strHmi,
                    DryingTemp: DryTemp,
                    StartWeight: StrWeight,
                    FinWt: FinalWt,
                    EndResult: EndRes,
                    Total: Totaltime,
                    DsNo: SelectedMenuDetails.DsNo,
                    Ip: Ip,
                    data: {},
                    Ip: Ip

                })

                main = globalData.dataMoist.find(k => k.Ip == Ip && k.DsNo == SelectedMenuDetails.DsNo);
            }
            var isAborted = 0;

            obj["IPQC Instrument ID"] = dataObj.InstrumentId

            let cubicaldata = await models.tbl_cubical.findOne({
                where: {
                    Sys_DSNumber: dataObj.currentOpStatus.DsNo
                }
            })

            var cubicObj = {}
            cubicObj.cubicalData = cubicaldata

            for (let i = 0; i < data_array.length; i++) {
                // data = data_array[i].trim();
                if (data == "" || data == null)
                    continue;
                if (data_array[i].includes("SNR(Terminal)")) {
                    let srNo = data_array[i].replace('SNR(Terminal)', ' ').trim().split();
                    srNo = srNo[0];
                    obj["SNR"] = 'NA';
                    // arr.push({ SWunit: SWunit })
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].srno = srNo
                    continue;
                }
                if (data_array[i].includes("SW(Drying Unit)")) {
                    let SWunit = data_array[i].replace('SW(Drying Unit)', ' ').trim().split();
                    SWunit = SWunit[0];
                    obj["SW (Drying Unit)"] = 'NA';
                    // arr.push({ SWunit: SWunit })
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].SW = SWunit
                    continue;
                }
                if (data_array[i].includes("SW(Terminal)")) {
                    let SWterminal = data_array[i].replace('SW(Terminal)', ' ').trim().split();
                    SWterminal = SWterminal[0];
                    obj["SW (Terminal)"] = 'NA';
                    // arr.push({ SWterminal: SWterminal })
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].SW = SWterminal
                    continue;
                }
                if (data_array[i].includes("Method Name")) {

                    // var newStringData = data_array.join('\n');

                    // var tempdata = newStringData.slice(
                    //     newStringData.lastIndexOf("Method Name"),
                    //     newStringData.lastIndexOf("Drying Prog"),
                    // );

                    // let Pname = data_array[i+1].replace('Method Name', ' ').trim().split();
                    let Pname = data_array[i].replace('Method Name', ' ').trim().split();
                    if (Pname[0] == '') {
                        Pname = data_array[i + 1].replace('Method Name', ' ').trim().split();
                        if (!data_array[i + 2].includes("Drying Prog")) {
                            var tempname = data_array[i + 2].replace('Method Name', ' ').trim().split();
                            Pname = Pname[0] + tempname[0]
                            Pname = [Pname]
                        }
                    }
                    Pname = Pname[0];
                    obj["Product Name"] = Pname;
                    // arr.push({ SWterminal: SWterminal })
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].Pname = Pname
                    continue;
                }
                if (data_array[i].includes("Drying Prog")) {
                    let DryProg = data_array[i].replace('Drying Prog', ' ').trim().split();
                    DryProg = DryProg[0];
                    obj["Drying Prog"] = DryProg ? DryProg : "NA";
                    // arr.push({ DryTemp: DryTemp })
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].DryProg = DryProg
                    continue;
                }
                if (data_array[i].includes("Switchoff mode")) {
                    let Switchoff = data_array[i].replace('Switchoff mode', ' ').trim().split();
                    Switchoff = Switchoff[0];
                    obj["Switch Off"] = Switchoff;
                    // arr.push({ SWterminal: SWterminal })
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].SWoff = Switchoff
                    continue;
                }
                if (data_array[i].includes("Drying temp.")) {
                    let DryTemp = data_array[i].replace('Drying temp.', ' ').trim().split();
                    DryTemp = DryTemp[0].split(" ")[0];
                    obj["Drying Temp"] = DryTemp
                    // arr.push({ DryTemp: DryTemp })
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].DryingTemp = DryTemp
                    continue;
                }
                if (data_array[i].includes("Wet weight")) {
                    let StrWeight = data_array[i].replace('Wet weight', ' ').trim().split();
                    StrWeight = StrWeight[0];
                    obj["Start Weight"] = StrWeight
                    // arr.push({ StrWeight: StrWeight })
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].StartWeight = StrWeight
                    continue;
                }
                if (data_array[i].includes("Dry weight")) {
                    let FinalWt = data_array[i].replace('Dry weight', ' ').trim().split();
                    FinalWt = FinalWt[0];
                    obj["Dry Weight"] = FinalWt;
                    // arr.push({ SWterminal: SWterminal })
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].FinWt = FinalWt
                    continue;
                }
                if (data_array[i].includes("Total time")) {
                    let Totaltime = data_array[i].replace('Total time', ' ').trim().split();
                    // Totaltime = "00:" + Totaltime[0].split(" ")[0] + ' ' + Totaltime[0].split(" ")[1]
                    Totaltime = Totaltime[0];
                    obj["Total time"] = Totaltime
                    // arr.push({ Totaltime: Totaltime })
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].Total = Totaltime
                    continue;
                }
                if (data_array[i].includes("End result")) {
                    let EndRes = data_array[i].replace('End result', ' ').trim().split();
                    EndRes = EndRes[0].split('%')[0] + "%W/W";
                    // EndRes = EndRes[0];
                    obj["End Result"] = EndRes
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].EndResult = EndRes
                    // arr.push({ EndRes: EndRes })
                    continue;
                }
                if (data_array[i].includes("Measurement end")) {
                    // let Measurementend = data_array[i + 1].replace('Measurement end', ' ').trim().split(" ");
                    let Measurementend = moment().format('YYYY-MM-DD') + moment(DateTime()).format('HH:mm')
                    // Measurementend = Measurementend[0] + ' ' + Measurementend[1];
                    obj["Measurement end"] = Measurementend
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].Measurementend = Measurementend
                    // arr.push({ EndRes: EndRes })
                    continue;
                }
                if (data_array[i].includes("ABORTED")) {
                    isAborted = 1
                    continue;
                }
                // if (data_array[i].includes("Batch No")) {
                //     let batchNo = data_array[i].replace('Batch No', ' ').trim().split();

                //     if(batchNo != cubicaldata[0].Sys_Batch){
                //         isAborted = 1
                //     }
                //     continue;
                // }
            }

            let validArrData = ["Dry Weight", "Drying Temp", "End Result", "IPQC Instrument ID", "Total time", "Switchoff mode"];
            Object.assign(main.data, obj)
            let validatingFlag = this.isAbort(main.data, isAborted);
            if (Object.keys(main.data).length >= validArrData.length && validatingFlag == false) {
                Object.assign(obj, main.data)
                let Measurementend = moment().format('DD.MM.YYYY') + ' ' + moment().format('HH:mm')

                obj["Measurement end"] = Measurementend

                obj["SW (Drying Unit)"] = 'NA';
                obj["SW (Terminal)"] = 'NA';

                obj["Drying Prog"] = 'NA';

                // var cubicObj = globalData.arrIdsInfo.find(k => k.TabIp == Ip);

                var userInfo = globalData.arrUsers.find(k => k.TabIp == Ip);


                isAborted = this.isAbort(obj, isAborted);


                if (isAborted == 1) {
                    mqttSender.sendData(strResberryPi, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Invalid String received`)
                    let _activityObj = {
                        strUserId: userInfo.UserId,
                        strUserName: userInfo.UserName,
                        batch: cubicObj.cubicalData.Sys_Batch,
                        activity: `Invalid String received`
                    };

                    await objActivityLog.ActivityLogEntry(_activityObj);
                    return
                }

                let index1 = globalData.dataMoist.find(k => k.Ip == Ip)
                if (index1 != undefined) {
                    if (index1.StartWeight == undefined || index1.EndResult == undefined || index1.DryingTemp == undefined) {
                        mqttSender.sendData(strResberryPi, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Invalid String recieved`)
                        return
                    }
                    if (index1.StartWeight != undefined && index1.EndResult == undefined && index1.DryingTemp != undefined) {
                        return mqttSender.sendData(strResberryPi, "received")
                    }
                }

                arr.push(obj);
                // const TimeFormat = "HH:mm:ss";

                console.log(arr)
                if (arr.length == 0) {
                    mqttSender.sendData(strResberryPi, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Invalid String recieved`)
                    return
                }
                let dtData = globalData.arrWeighmentProductData.find(k => k.TabIp == Ip).data;


                // let currentOpStatus = globalData.arrCurrentOperationStatus.find(k => k.TabIp == Ip);
                // let tempCailibType = globalData.arrcalibType.find(k => k.Hmi == strHmi);
                let currentOpStatus = globalData.arrCurrentOperationStatus.find(k => k.DsNo == SelectedMenuDetails.DsNo && k.TabIp == Ip);
                let tempCailibType = globalData.arrcalibType.find(k => k.DsNo == SelectedMenuDetails.DsNo && k.TabIp == Ip);

                // let arrPortDetailForStart1 = await objHmi.idsPortSetting(strHmi)
                let intPortNo1 = dataObj.ProtocolPortNo;
                let strInstrumentType = dataObj.InstrumentType;
                let strInstrumentId = dataObj.InstrumentId;

                var __parameterWeighmentObj = {
                    DsNo: SelectedMenuDetails.DsNo,
                    TabIp: SelectedMenuDetails.TabIp,
                    DsIp: SelectedMenuDetails.DsIp,
                    instrumentId: strInstrumentId,
                    ProtocolPortNo: intPortNo1,
                    SelectedMenuDetails: SelectedMenuDetails,
                    menuName: SelectedMenuDetails.menuName,
                    idsNo: strResberryPi,
                    Hmi: strHmi,
                    actualWt: arr[0],
                    instrumentId: strInstrumentId,
                    Ip: Ip,
                    cubicObjData: cubicObj
                }

                if (arr == "") {
                    mqttSender.sendData(strResberryPi, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Invalid String recieved`)
                    return
                } else {
                    // if (strInstrumentType == GLOBAL_NOMENCLATURE.Balance) {
                    //     if (ProtocolUnit == undefined) {
                    //         ProtocolUnit = ProtocolUnit == undefined ? "g" : ProtocolUnit;
                    //     } else {
                    //         if ((ProtocolUnit != "g") && (ProtocolUnit != "kg") && (ProtocolUnit != "mg")) {
                    //             //log protocol in file
                    //             loggers.MqttProtocolLogger.info(`protocol : ${mqttProtocol.DisplayMessage}Invalid Data String sended to device ${strHmi}`)
                    //             return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid Data String`);
                    //         } else {
                    //             if (ProtocolUnit == "mg") {
                    //                 actualWt = actualWt / 1000;
                    //             } else if (ProtocolUnit == ("kg" || "Kg" || "KG")) {
                    //                 actualWt = actualWt * 1000;
                    //             }
                    //             ProtocolUnit = ProtocolUnit == undefined ? "g" : ProtocolUnit;

                    //         }
                    //     }

                    // } else {
                    //     //log protocol in file
                    //     loggers.MqttProtocolLogger.info(`unknown instrument`)
                    //     console.log('unknown instrument');
                    // }

                    //decision making 
                    if (tempCailibType == undefined) {
                        if (currentOpStatus == undefined) {
                            loggers.MqttProtocolLogger.info(`Weight recieve without any api called`)
                            console.log('wt recieve without any api called');
                            return;
                        } else if (currentOpStatus.Weighment == 1 && currentOpStatus.testType == "Weighment") {

                            // var instrumentData = `-MOISTURE DETERMINATION-

                            // End Result      ${obj["End Result"]}
                            // Measurement end
                            //         ${moment().format("DD.MM.YYYY HH:mm")}

                            // ---------- END ---------`

                            //                         var instrumentData = `Start Weight     ${obj["Start Weight"]}
                            // Dry Weight     ${obj["Dry Weight"]}
                            // End Result      ${obj["End Result"]}
                            //  `

                            // var instrumentData = `Start Weight     ${obj["Start Weight"]}
                            // Total time      ${obj["Total time"]}
                            // Dry Weight     ${obj["Dry Weight"]}
                            // End Result      ${obj["End Result"]}` 


                            // var instrumentData = `Dry Weight     ${obj["Dry Weight"]}`;
                            await objWeighmentData.ParsingTestData(mqttProtocol.LODMenu, __parameterWeighmentObj);
                        }
                    } else {
                        console.log('calibration is on and dt weighment part has clash')
                    }
                }
            }
        } catch (error) {
            throw new Error(error)
        }
    }

    // async parseMoistureAnalyserDataHB43S(dataObj) {
    //     try {
    //         let { Str_Protocol, strResberryPi, strHmi, Ip, ProtocolPortNo, SelectedMenuDetails, instrumentId, ProtocolName } = dataObj;
    //         //here also different balance have different parsing logic
    //         let data_array = Str_Protocol.split("\n");
    //         let data = Str_Protocol.split(":")[2].trim();
    //         Ip = dataObj.TabIp
    //         strResberryPi = dataObj.currentOpStatus.DsNo
    //         let test_duration_found = false;
    //         let arm_found = false;
    //         var DryTemp, StrWeight, EndRes, Totaltime, FinalWt
    //         let arr = [];
    //         let obj = {}

    //         let main = globalData.dataMoist.find(k => k.Ip == Ip)

    //         if (main == undefined) {
    //             let obj = globalData.dataMoist.push({
    //                 hmi: strHmi,
    //                 DryingTemp: DryTemp,
    //                 StartWeight: StrWeight,
    //                 FinWt: FinalWt,
    //                 EndResult: EndRes,
    //                 Total: Totaltime,
    //                 Ip: Ip

    //             })
    //         }
    //         var isAborted = 0;

    //         obj["IPQC Instrument ID"] = dataObj.InstrumentId

    //         let cubicaldata = await models.tbl_cubical.findOne({
    //             where: {
    //                 Sys_DSNumber: dataObj.currentOpStatus.DsNo
    //             }
    //         })

    //         var cubicObj = {}
    //         cubicObj.cubicalData = cubicaldata

    //         for (let i = 0; i < data_array.length; i++) {
    //             // data = data_array[i].trim();
    //             if (data == "" || data == null)
    //                 continue;
    //             if (data_array[i].includes("SNR")) {
    //                 let srNo = data_array[i].replace('SNR', ' ').trim().split();
    //                 srNo = srNo[0];
    //                 obj["SNR"] = 'NA';
    //                 // arr.push({ SWunit: SWunit })
    //                 let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
    //                 globalData.dataMoist[index].srno = srNo
    //                 continue;
    //             }
    //             if (data_array[i].includes("SW(Drying Unit)")) {
    //                 let SWunit = data_array[i].replace('SW(Drying Unit)', ' ').trim().split();
    //                 SWunit = SWunit[0];
    //                 obj["SW (Drying Unit)"] = 'NA';
    //                 // arr.push({ SWunit: SWunit })
    //                 let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
    //                 globalData.dataMoist[index].SW = SWunit
    //                 continue;
    //             }
    //             if (data_array[i].includes("SW(Terminal)")) {
    //                 let SWterminal = data_array[i].replace('SW(Terminal)', ' ').trim().split();
    //                 SWterminal = SWterminal[0];
    //                 obj["SW (Terminal)"] = 'NA';
    //                 // arr.push({ SWterminal: SWterminal })
    //                 let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
    //                 globalData.dataMoist[index].SW = SWterminal
    //                 continue;
    //             }
    //             if (data_array[i].includes("Method Name")) {

    //                 // var newStringData = data_array.join('\n');

    //                 // var tempdata = newStringData.slice(
    //                 //     newStringData.lastIndexOf("Method Name"),
    //                 //     newStringData.lastIndexOf("Drying Prog"),
    //                 // );

    //                 // let Pname = data_array[i+1].replace('Method Name', ' ').trim().split();
    //                 let Pname = data_array[i].replace('Method Name', ' ').trim().split();
    //                 if (Pname[0] == '') {
    //                     Pname = data_array[i + 1].replace('Method Name', ' ').trim().split();
    //                     if (!data_array[i + 2].includes("Drying Prog")) {
    //                         var tempname = data_array[i + 2].replace('Method Name', ' ').trim().split();
    //                         Pname = Pname[0] + tempname[0]
    //                         Pname = [Pname]
    //                     }
    //                 }
    //                 Pname = Pname[0];
    //                 obj["Product Name"] = Pname;
    //                 // arr.push({ SWterminal: SWterminal })
    //                 let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
    //                 globalData.dataMoist[index].Pname = Pname
    //                 continue;
    //             }
    //             if (data_array[i].includes("Drying program")) {
    //                 let DryProg = data_array[i].replace('Drying program', ' ').trim().split();
    //                 DryProg = DryProg[0];
    //                 obj["Drying Prog"] = DryProg ? DryProg : 'NA';
    //                 // arr.push({ DryTemp: DryTemp })
    //                 let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
    //                 globalData.dataMoist[index].DryProg = DryProg
    //                 continue;
    //             }
    //             if (data_array[i].includes("Switch-off mode")) {
    //                 let Switchoff = data_array[i].replace('Switch-off mode', ' ').trim().split();
    //                 Switchoff = Switchoff[0];
    //                 obj["Switch Off"] = Switchoff;
    //                 // arr.push({ SWterminal: SWterminal })
    //                 let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
    //                 globalData.dataMoist[index].SWoff = Switchoff
    //                 continue;
    //             }
    //             if (data_array[i].includes("Temperature")) {
    //                 let DryTemp = data_array[i].replace('Temperature', ' ').trim().split();
    //                 DryTemp = DryTemp[0].split(" ")[0];
    //                 obj["Drying Temp"] = DryTemp
    //                 // arr.push({ DryTemp: DryTemp })
    //                 let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
    //                 globalData.dataMoist[index].DryingTemp = DryTemp
    //                 continue;
    //             }
    //             if (data_array[i].includes("Initial wt.")) {
    //                 let StrWeight = data_array[i].replace('Initial wt.', ' ').trim().split();
    //                 StrWeight = StrWeight[0];
    //                 obj["Start Weight"] = StrWeight
    //                 // arr.push({ StrWeight: StrWeight })
    //                 let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
    //                 globalData.dataMoist[index].StartWeight = StrWeight
    //                 continue;
    //             }
    //             if (data_array[i].includes("Dry weight")) {
    //                 let FinalWt = data_array[i].replace('Dry weight', ' ').trim().split();
    //                 FinalWt = FinalWt[0];
    //                 obj["Dry Weight"] = FinalWt;
    //                 // arr.push({ SWterminal: SWterminal })
    //                 let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
    //                 globalData.dataMoist[index].FinWt = FinalWt
    //                 continue;
    //             }
    //             if (data_array[i].includes("Total time")) {
    //                 let Totaltime = data_array[i].replace('Total time', ' ').trim().split();
    //                 // Totaltime = "00:" + Totaltime[0].split(" ")[0] + ' ' + Totaltime[0].split(" ")[1]
    //                 Totaltime = Totaltime[0];
    //                 obj["Total time"] = Totaltime
    //                 // arr.push({ Totaltime: Totaltime })
    //                 let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
    //                 globalData.dataMoist[index].Total = Totaltime
    //                 continue;
    //             }
    //             if (data_array[i].includes("Result")) {
    //                 let EndRes = data_array[i].replace('Result', ' ').trim().split();
    //                 EndRes = EndRes[0].split('%')[0] + "%W/W";
    //                 obj["End Result"] = EndRes
    //                 let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
    //                 globalData.dataMoist[index].EndResult = EndRes
    //                 // arr.push({ EndRes: EndRes })
    //                 continue;
    //             }
    //             if (data_array[i].includes("Measurement end")) {
    //                 // let Measurementend = data_array[i + 1].replace('Measurement end', ' ').trim().split(" ");
    //                 let Measurementend = moment().format('YYYY-MM-DD') + ' ' + moment().format('hh:mm:ss')
    //                 // Measurementend = Measurementend[0] + ' ' + Measurementend[1];
    //                 obj["Measurement end"] = Measurementend
    //                 let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
    //                 globalData.dataMoist[index].Measurementend = Measurementend
    //                 // arr.push({ EndRes: EndRes })
    //                 continue;
    //             }
    //             if (data_array[i].includes("ABORTED")) {
    //                 isAborted = 1
    //                 continue;
    //             }
    //             // if (data_array[i].includes("Batch No")) {
    //             //     let batchNo = data_array[i].replace('Batch No', ' ').trim().split();

    //             //     if(batchNo != cubicaldata[0].Sys_Batch){
    //             //         isAborted = 1
    //             //     }
    //             //     continue;
    //             // }
    //         }

    //         let Measurementend = moment().format('DD.MM.YYYY') + ' ' + moment().format('hh:mm')
    //         // Measurementend = Measurementend[0] + ' ' + Measurementend[1];
    //         obj["Measurement end"] = Measurementend

    //         obj["SW (Drying Unit)"] = 'NA';
    //         obj["SW (Terminal)"] = 'NA';
    //         // obj["Switch Off"] = 'NA';
    //         // obj["Drying Prog"] = 'NA';

    //         // var cubicObj = globalData.arrIdsInfo.find(k => k.TabIp == Ip);

    //         var userInfo = globalData.arrUsers.find(k => k.TabIp == Ip);

    //         isAborted = this.isAbort(obj, isAborted);


    //         if (isAborted == 1) {
    //             mqttSender.sendData(strResberryPi, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Invalid String received`)
    //             let _activityObj = {
    //                 strUserId: userInfo.UserId,
    //                 strUserName: userInfo.UserName,
    //                 batch: cubicObj.cubicalData.Sys_Batch,
    //                 activity: `Invalid String received`
    //             };

    //             await objActivityLog.ActivityLogEntry(_activityObj);
    //             return
    //         }

    //         let index1 = globalData.dataMoist.find(k => k.Ip == Ip)
    //         if (index1 != undefined) {
    //             if (index1.StartWeight == undefined || index1.EndResult == undefined || index1.DryingTemp == undefined) {
    //                 mqttSender.sendData(strResberryPi, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Invalid String recieved`)
    //                 return
    //             }
    //             if (index1.StartWeight != undefined && index1.EndResult == undefined && index1.DryingTemp != undefined) {
    //                 return mqttSender.sendData(strResberryPi, "received")
    //             }
    //         }

    //         arr.push(obj);
    //         // const TimeFormat = "HH:mm:ss";

    //         console.log(arr)
    //         if (arr.length == 0) {
    //             mqttSender.sendData(strResberryPi, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Invalid String recieved`)
    //             return
    //         }
    //         let dtData = globalData.arrWeighmentProductData.find(k => k.TabIp == Ip).data;


    //         let currentOpStatus = globalData.arrCurrentOperationStatus.find(k => k.TabIp == Ip);
    //         let tempCailibType = globalData.arrcalibType.find(k => k.Hmi == strHmi);
    //         // let arrPortDetailForStart1 = await objHmi.idsPortSetting(strHmi)
    //         let intPortNo1 = dataObj.ProtocolPortNo;
    //         let strInstrumentType = dataObj.InstrumentType;
    //         let strInstrumentId = dataObj.InstrumentId;

    //         var __parameterWeighmentObj = {
    //             DsNo: SelectedMenuDetails.DsNo,
    //             TabIp: SelectedMenuDetails.TabIp,
    //             DsIp: SelectedMenuDetails.DsIp,
    //             instrumentId: strInstrumentId,
    //             ProtocolPortNo: intPortNo1,
    //             SelectedMenuDetails: SelectedMenuDetails,
    //             menuName: SelectedMenuDetails.menuName,
    //             idsNo: strResberryPi,
    //             Hmi: strHmi,
    //             actualWt: arr[0],
    //             instrumentId: strInstrumentId,
    //             Ip: Ip,
    //             cubicObjData: cubicObj
    //         }

    //         if (arr == "") {
    //             mqttSender.sendData(strResberryPi, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Invalid String recieved`)
    //             return
    //         } else {
    //             // if (strInstrumentType == GLOBAL_NOMENCLATURE.Balance) {
    //             //     if (ProtocolUnit == undefined) {
    //             //         ProtocolUnit = ProtocolUnit == undefined ? "g" : ProtocolUnit;
    //             //     } else {
    //             //         if ((ProtocolUnit != "g") && (ProtocolUnit != "kg") && (ProtocolUnit != "mg")) {
    //             //             //log protocol in file
    //             //             loggers.MqttProtocolLogger.info(`protocol : ${mqttProtocol.DisplayMessage}Invalid Data String sended to device ${strHmi}`)
    //             //             return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid Data String`);
    //             //         } else {
    //             //             if (ProtocolUnit == "mg") {
    //             //                 actualWt = actualWt / 1000;
    //             //             } else if (ProtocolUnit == ("kg" || "Kg" || "KG")) {
    //             //                 actualWt = actualWt * 1000;
    //             //             }
    //             //             ProtocolUnit = ProtocolUnit == undefined ? "g" : ProtocolUnit;

    //             //         }
    //             //     }

    //             // } else {
    //             //     //log protocol in file
    //             //     loggers.MqttProtocolLogger.info(`unknown instrument`)
    //             //     console.log('unknown instrument');
    //             // }

    //             //decision making 
    //             if (tempCailibType == undefined) {
    //                 if (currentOpStatus == undefined) {
    //                     loggers.MqttProtocolLogger.info(`Weight recieve without any api called`)
    //                     console.log('wt recieve without any api called');
    //                     return;
    //                 } else if (currentOpStatus.Weighment == 1 && currentOpStatus.testType == "Weighment") {

    //                     // var instrumentData = `-MOISTURE DETERMINATION-

    //                     // End Result      ${obj["End Result"]}
    //                     // Measurement end
    //                     //         ${moment().format("DD.MM.YYYY HH:mm")}

    //                     // ---------- END ---------`

    //                     //                         var instrumentData = `Start Weight     ${obj["Start Weight"]}
    //                     // Dry Weight     ${obj["Dry Weight"]}
    //                     // End Result      ${obj["End Result"]}
    //                     //  `

    //                     // var instrumentData = `Start Weight     ${obj["Start Weight"]}
    //                     // Total time      ${obj["Total time"]}
    //                     // Dry Weight     ${obj["Dry Weight"]}
    //                     // End Result      ${obj["End Result"]}` 


    //                     // var instrumentData = `Dry Weight     ${obj["Dry Weight"]}`;
    //                     await objWeighmentData.ParsingTestData(mqttProtocol.LODMenu, __parameterWeighmentObj);
    //                 }
    //             } else {
    //                 console.log('calibration is on and dt weighment part has clash')
    //             }
    //         }
    //         // }
    //     } catch (error) {
    //         throw new Error(error)
    //     }
    // }

    async parseMoistureAnalyserDataHB43S(dataObj) {
        try {
            let { Str_Protocol, strResberryPi, strHmi, Ip, ProtocolPortNo, SelectedMenuDetails, instrumentId, ProtocolName } = dataObj;
            //here also different balance have different parsing logic
            // let tempStrprotocol = Str_Protocol.split(":")[2].trim();
            let data_array = Str_Protocol.split("\n");
            // let data_array = tempStrprotocol.split("\n");
            let data = Str_Protocol.split(":")[2].trim();
            Ip = dataObj.TabIp
            strResberryPi = dataObj.currentOpStatus.DsNo
            let test_duration_found = false;
            let arm_found = false;
            var DryTemp, StrWeight, EndRes, Totaltime, FinalWt
            let arr = [];
            let obj = {}

            let main = globalData.dataMoist.find(k => k.Ip == Ip && k.DsNo == SelectedMenuDetails.DsNo)

            if (main == undefined) {
                let obj = globalData.dataMoist.push({
                    hmi: strHmi,
                    DsNo: SelectedMenuDetails.DsNo,
                    DryingTemp: DryTemp,
                    StartWeight: StrWeight,
                    FinWt: FinalWt,
                    EndResult: EndRes,
                    Total: Totaltime,
                    Ip: Ip,
                    data: {}
                })

                main = globalData.dataMoist.find(k => k.Ip == Ip && k.DsNo == SelectedMenuDetails.DsNo)
            }
            var isAborted = 0;

            obj["IPQC Instrument ID"] = dataObj.InstrumentId

            let cubicaldata = await models.tbl_cubical.findOne({
                where: {
                    Sys_DSNumber: dataObj.currentOpStatus.DsNo
                }
            })

            var cubicObj = {}
            cubicObj.cubicalData = cubicaldata

            for (let i = 0; i < data_array.length; i++) {
                // data = data_array[i].trim();
                if (data == "" || data == null)
                    continue;
                if (data_array[i].includes("SNR")) {
                    let srNo = data_array[i].replace('SNR', ' ').trim().split();
                    srNo = srNo[0];
                    obj["SNR"] = 'NA';
                    // arr.push({ SWunit: SWunit })
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].srno = srNo
                    continue;
                }
                if (data_array[i].includes("SW(Drying Unit)")) {
                    let SWunit = data_array[i].replace('SW(Drying Unit)', ' ').trim().split();
                    SWunit = SWunit[0];
                    obj["SW (Drying Unit)"] = 'NA';
                    // arr.push({ SWunit: SWunit })
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].SW = SWunit
                    continue;
                }
                if (data_array[i].includes("SW(Terminal)")) {
                    let SWterminal = data_array[i].replace('SW(Terminal)', ' ').trim().split();
                    SWterminal = SWterminal[0];
                    obj["SW (Terminal)"] = 'NA';
                    // arr.push({ SWterminal: SWterminal })
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].SW = SWterminal
                    continue;
                }
                if (data_array[i].includes("Method Name")) {

                    // var newStringData = data_array.join('\n');

                    // var tempdata = newStringData.slice(
                    //     newStringData.lastIndexOf("Method Name"),
                    //     newStringData.lastIndexOf("Drying Prog"),
                    // );

                    // let Pname = data_array[i+1].replace('Method Name', ' ').trim().split();
                    let Pname = data_array[i].replace('Method Name', ' ').trim().split();
                    if (Pname[0] == '') {
                        Pname = data_array[i + 1].replace('Method Name', ' ').trim().split();
                        if (!data_array[i + 2].includes("Drying Prog")) {
                            var tempname = data_array[i + 2].replace('Method Name', ' ').trim().split();
                            Pname = Pname[0] + tempname[0]
                            Pname = [Pname]
                        }
                    }
                    Pname = Pname[0];
                    obj["Product Name"] = Pname;
                    // arr.push({ SWterminal: SWterminal })
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].Pname = Pname
                    continue;
                }
                if (data_array[i].includes("Drying program")) {
                    let DryProg = data_array[i].replace('Drying program', ' ').trim().split();
                    DryProg = DryProg[0];
                    obj["Drying Prog"] = DryProg ? DryProg : 'NA';
                    // arr.push({ DryTemp: DryTemp })
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].DryProg = DryProg
                    continue;
                }
                if (data_array[i].includes("Switch-off mode")) {
                    let Switchoff = data_array[i].replace('Switch-off mode', ' ').trim().split();
                    Switchoff = Switchoff[0];
                    obj["Switch Off"] = Switchoff;
                    // arr.push({ SWterminal: SWterminal })
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].SWoff = Switchoff
                    continue;
                }
                if (data_array[i].includes("Temperature")) {
                    let DryTemp = data_array[i].replace('Temperature', ' ').trim().split();
                    DryTemp = DryTemp[0].split(" ")[0];
                    obj["Drying Temp"] = DryTemp
                    // arr.push({ DryTemp: DryTemp })
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].DryingTemp = DryTemp
                    continue;
                }
                if (data_array[i].includes("Initial wt.")) {
                    let StrWeight = data_array[i].replace('Initial wt.', ' ').trim().split();
                    StrWeight = StrWeight[0];
                    obj["Start Weight"] = StrWeight
                    // arr.push({ StrWeight: StrWeight })
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].StartWeight = StrWeight
                    continue;
                }
                if (data_array[i].includes("Dry weight")) {
                    let FinalWt = data_array[i].replace('Dry weight', ' ').trim().split();
                    FinalWt = FinalWt[0];
                    obj["Dry Weight"] = FinalWt;
                    // arr.push({ SWterminal: SWterminal })
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].FinWt = FinalWt
                    continue;
                }
                if (data_array[i].includes("Total time")) {
                    let Totaltime = data_array[i].replace('Total time', ' ').trim().split();
                    // Totaltime = "00:" + Totaltime[0].split(" ")[0] + ' ' + Totaltime[0].split(" ")[1]
                    Totaltime = Totaltime[0];
                    obj["Total time"] = Totaltime
                    // arr.push({ Totaltime: Totaltime })
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].Total = Totaltime
                    continue;
                }
                if (data_array[i].includes("Result")) {
                    let EndRes = data_array[i].replace('Result', ' ').trim().split();
                    EndRes = EndRes[0].split('%')[0] + "%W/W";
                    obj["End Result"] = EndRes
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].EndResult = EndRes
                    // arr.push({ EndRes: EndRes })
                    continue;
                }
                if (data_array[i].includes("Measurement end")) {
                    // let Measurementend = data_array[i + 1].replace('Measurement end', ' ').trim().split(" ");
                    let Measurementend = moment().format('YYYY-MM-DD') + ' ' + moment().format('HH:mm')
                    // Measurementend = Measurementend[0] + ' ' + Measurementend[1];
                    obj["Measurement end"] = Measurementend
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].Measurementend = Measurementend
                    // arr.push({ EndRes: EndRes })
                    continue;
                }
                if (data_array[i].includes("ABORTED")) {
                    isAborted = 1
                    continue;
                }
                // if (data_array[i].includes("Batch No")) {
                //     let batchNo = data_array[i].replace('Batch No', ' ').trim().split();

                //     if(batchNo != cubicaldata[0].Sys_Batch){
                //         isAborted = 1
                //     }
                //     continue;
                // }
            }





            var userInfo = globalData.arrUsers.find(k => k.TabIp == Ip);



            let validArrData = ["Start Weight", "Total time", "Dry Weight", "Drying Temp", "End Result", "IPQC Instrument ID"]


            Object.assign(main.data, obj)
            let validatingFlag = this.isAbort(main.data, isAborted);
            if (Object.keys(main.data).length >= validArrData.length && validatingFlag == false) {
                Object.assign(obj, main.data)

                let Measurementend = moment().format('DD.MM.YYYY') + ' ' + moment().format('HH:mm')
                // Measurementend = Measurementend[0] + ' ' + Measurementend[1];
                obj["Measurement end"] = Measurementend

                obj["SW (Drying Unit)"] = 'NA';
                obj["SW (Terminal)"] = 'NA';
                // obj["Switch Off"] = 'NA';
                // obj["Drying Prog"] = 'NA';

                // var cubicObj = globalData.arrIdsInfo.find(k => k.TabIp == Ip);
                isAborted = this.isAbort(obj, isAborted);
                if (isAborted == 1) {
                    mqttSender.sendData(strResberryPi, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Invalid String received`)
                    let _activityObj = {
                        strUserId: userInfo.UserId,
                        strUserName: userInfo.UserName,
                        batch: cubicObj.cubicalData.Sys_Batch,
                        activity: `Invalid String received`
                    };

                    await objActivityLog.ActivityLogEntry(_activityObj);
                    return
                }

                let index1 = globalData.dataMoist.find(k => k.Ip == Ip)
                if (index1 != undefined) {
                    if (index1.StartWeight == undefined || index1.EndResult == undefined || index1.DryingTemp == undefined) {
                        mqttSender.sendData(strResberryPi, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Invalid String recieved`)
                        return
                    }
                    if (index1.StartWeight != undefined && index1.EndResult == undefined && index1.DryingTemp != undefined) {
                        return mqttSender.sendData(strResberryPi, "received")
                    }
                }

                arr.push(obj);
                // const TimeFormat = "HH:mm:ss";

                console.log(arr)
                if (arr.length == 0) {
                    mqttSender.sendData(strResberryPi, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Invalid String recieved`)
                    return
                }
                let dtData = globalData.arrWeighmentProductData.find(k => k.TabIp == Ip).data;


                let currentOpStatus = globalData.arrCurrentOperationStatus.find(k => k.DsNo == SelectedMenuDetails.DsNo && k.TabIp == Ip);
                let tempCailibType = globalData.arrcalibType.find(k => k.DsNo == SelectedMenuDetails.DsNo && k.TabIp == Ip);
                // let arrPortDetailForStart1 = await objHmi.idsPortSetting(strHmi)
                let intPortNo1 = dataObj.ProtocolPortNo;
                let strInstrumentType = dataObj.InstrumentType;
                let strInstrumentId = dataObj.InstrumentId;

                var __parameterWeighmentObj = {
                    DsNo: SelectedMenuDetails.DsNo,
                    TabIp: SelectedMenuDetails.TabIp,
                    DsIp: SelectedMenuDetails.DsIp,
                    instrumentId: strInstrumentId,
                    ProtocolPortNo: intPortNo1,
                    SelectedMenuDetails: SelectedMenuDetails,
                    menuName: SelectedMenuDetails.menuName,
                    idsNo: strResberryPi,
                    Hmi: strHmi,
                    actualWt: arr[0],
                    instrumentId: strInstrumentId,
                    Ip: Ip,
                    cubicObjData: cubicObj
                }

                if (arr == "") {
                    mqttSender.sendData(strResberryPi, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Invalid String recieved`)
                    return
                } else {
                    // if (strInstrumentType == GLOBAL_NOMENCLATURE.Balance) {
                    //     if (ProtocolUnit == undefined) {
                    //         ProtocolUnit = ProtocolUnit == undefined ? "g" : ProtocolUnit;
                    //     } else {
                    //         if ((ProtocolUnit != "g") && (ProtocolUnit != "kg") && (ProtocolUnit != "mg")) {
                    //             //log protocol in file
                    //             loggers.MqttProtocolLogger.info(`protocol : ${mqttProtocol.DisplayMessage}Invalid Data String sended to device ${strHmi}`)
                    //             return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid Data String`);
                    //         } else {
                    //             if (ProtocolUnit == "mg") {
                    //                 actualWt = actualWt / 1000;
                    //             } else if (ProtocolUnit == ("kg" || "Kg" || "KG")) {
                    //                 actualWt = actualWt * 1000;
                    //             }
                    //             ProtocolUnit = ProtocolUnit == undefined ? "g" : ProtocolUnit;

                    //         }
                    //     }

                    // } else {
                    //     //log protocol in file
                    //     loggers.MqttProtocolLogger.info(`unknown instrument`)
                    //     console.log('unknown instrument');
                    // }

                    //decision making 
                    if (tempCailibType == undefined) {
                        if (currentOpStatus == undefined) {
                            loggers.MqttProtocolLogger.info(`Weight recieve without any api called`)
                            console.log('wt recieve without any api called');
                            return;
                        } else if (currentOpStatus.Weighment == 1 && currentOpStatus.testType == "Weighment") {

                            // var instrumentData = `-MOISTURE DETERMINATION-

                            // End Result      ${obj["End Result"]}
                            // Measurement end
                            //         ${moment().format("DD.MM.YYYY HH:mm")}

                            // ---------- END ---------`

                            //                         var instrumentData = `Start Weight     ${obj["Start Weight"]}
                            // Dry Weight     ${obj["Dry Weight"]}
                            // End Result      ${obj["End Result"]}
                            //  `

                            // var instrumentData = `Start Weight     ${obj["Start Weight"]}
                            // Total time      ${obj["Total time"]}
                            // Dry Weight     ${obj["Dry Weight"]}
                            // End Result      ${obj["End Result"]}` 


                            // var instrumentData = `Dry Weight     ${obj["Dry Weight"]}`;
                            await objWeighmentData.ParsingTestData(mqttProtocol.LODMenu, __parameterWeighmentObj);
                        }
                    } else {
                        console.log('calibration is on and dt weighment part has clash')
                    }
                }
            }




            // }
        } catch (error) {
            throw new Error(error)
        }
    }

    async parseMoistureAnalyserDataMA160(dataObj) {
        try {
            let { Str_Protocol, strResberryPi, strHmi, Ip, ProtocolPortNo, SelectedMenuDetails, instrumentId, ProtocolName } = dataObj;
            //here also different balance have different parsing logic
            // let tempStrprotocol = Str_Protocol.split(":")[2].trim();
            // let data_array = tempStrprotocol.split("\n");
            let data_array = Str_Protocol.split("\n");
            let data = Str_Protocol.split(":")[2].trim();
            Ip = dataObj.TabIp
            strResberryPi = dataObj.currentOpStatus.DsNo
            let test_duration_found = false;
            let arm_found = false;
            var DryTemp, StrWeight, EndRes, Totaltime, FinalWt
            let arr = [];
            let obj = {}

            let main = globalData.dataMoist.find(k => k.Ip == Ip && k.DsNo == SelectedMenuDetails.DsNo);

            if (main == undefined) {
                let obj = globalData.dataMoist.push({
                    hmi: strHmi,
                    DryingTemp: DryTemp,
                    StartWeight: StrWeight,
                    FinWt: FinalWt,
                    EndResult: EndRes,
                    Total: Totaltime,
                    DsNo: SelectedMenuDetails.DsNo,
                    data: {},
                    Ip: Ip

                })

                main = globalData.dataMoist.find(k => k.Ip == Ip && k.DsNo == SelectedMenuDetails.DsNo);
            }
            var isAborted = 0;

            obj["IPQC Instrument ID"] = dataObj.InstrumentId

            for (let i = 0; i < data_array.length; i++) {
                // data = data_array[i].trim();
                if (data == "" || data == null)
                    continue;
                if (data_array[i].includes("SerNo")) {
                    let srNo = data_array[i].replace('SerNo.', ' ').trim().split();
                    srNo = srNo[0];
                    obj["SNR"] = srNo;
                    // arr.push({ SWunit: SWunit })
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].srno = srNo
                    continue;
                }
                if (data_array[i].includes("SW(Drying Unit)")) {
                    let SWunit = data_array[i].replace('SW(Drying Unit)', ' ').trim().split();
                    SWunit = SWunit[0];
                    obj["SW (Drying Unit)"] = SWunit;
                    // arr.push({ SWunit: SWunit })
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].SW = SWunit
                    continue;
                }
                if (data_array[i].includes("SW(Terminal)")) {
                    let SWterminal = data_array[i].replace('SW(Terminal)', ' ').trim().split();
                    SWterminal = SWterminal[0];
                    obj["SW (Terminal)"] = SWterminal;
                    // arr.push({ SWterminal: SWterminal })
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].SW = SWterminal
                    continue;
                }
                if (data_array[i].includes("Method Name")) {

                    // var newStringData = data_array.join('\n');

                    // var tempdata = newStringData.slice(
                    //     newStringData.lastIndexOf("Method Name"),
                    //     newStringData.lastIndexOf("Drying Prog"),
                    // );

                    // let Pname = data_array[i+1].replace('Method Name', ' ').trim().split();
                    // let Pname = data_array[i].replace('Method Name', ' ').trim().split();
                    let Pname = data_array[i + 1].trim().split();
                    if (Pname[0] == '') {
                        Pname = data_array[i + 1].replace('Method Name', ' ').trim().split();
                        if (!data_array[i + 2].includes("Drying Prog")) {
                            var tempname = data_array[i + 2].replace('Method Name', ' ').trim().split();
                            Pname = Pname[0] + tempname[0]
                            Pname = [Pname]
                        }
                    }
                    Pname = Pname[0];
                    obj["Product Name"] = Pname;
                    // arr.push({ SWterminal: SWterminal })
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].Pname = Pname
                    continue;
                }
                if (data_array[i].includes("Drying Prog")) {
                    let DryProg = data_array[i].replace('Drying Prog', ' ').trim().split();
                    DryProg = DryProg[0];
                    obj["Drying Prog"] = DryProg
                    // arr.push({ DryTemp: DryTemp })
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].DryProg = DryProg
                    continue;
                }
                if (data_array[i].includes("Switch Off")) {
                    let Switchoff = data_array[i].replace('Switch Off', ' ').trim().split();
                    Switchoff = Switchoff[0];
                    obj["Switch Off"] = Switchoff;
                    // arr.push({ SWterminal: SWterminal })
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].SWoff = Switchoff
                    continue;
                }
                if (data_array[i].includes("Temperature")) {
                    // let DryTemp = data_array[i].replace('Drying Temp', ' ').trim().split();
                    let DryTemp = data_array[i + 1].trim().split()
                    DryTemp = DryTemp[0].split(" ")[0];
                    obj["Drying Temp"] = DryTemp
                    // arr.push({ DryTemp: DryTemp })
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].DryingTemp = DryTemp
                    continue;
                }
                if (data_array[i].includes("Start weight")) {
                    let StrWeight = data_array[i + 1].replace('+', '').trim().split();
                    // StrWeight = data_array[i+1].trim().split();
                    let StartWeight = StrWeight[0]
                    obj["Start Weight"] = StartWeight
                    // arr.push({ StrWeight: StrWeight })
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].StartWeight = StrWeight
                    continue;
                }
                if (data_array[i].includes("Final weight")) {
                    // let FinalWt = data_array[i].replace('Dry Weight', ' ').trim().split();
                    let FinalWt = data_array[i + 1].replace('+', '').trim().split();
                    FinalWt = FinalWt[0];
                    obj["Dry Weight"] = FinalWt;
                    // arr.push({ SWterminal: SWterminal })
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].FinWt = FinalWt
                    continue;
                }
                if (data_array[i].includes("Measurement time")) {
                    // let Totaltime = data_array[i].replace('Total time', ' ').trim().split();
                    let Totaltime = data_array[i + 1].trim().split();
                    // Totaltime = "00:" + Totaltime[0].split(" ")[0] + ' ' + Totaltime[0].split(" ")[1]
                    Totaltime = Totaltime[0];
                    obj["Total time"] = Totaltime
                    // arr.push({ Totaltime: Totaltime })
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].Total = Totaltime
                    continue;
                }
                if (data_array[i].trim() == 'Result') {
                    // let EndRes = data_array[i].replace('End Result', ' ').trim().split();
                    let EndRes = data_array[i + 1].trim().split();
                    EndRes = EndRes[0].split('%')[0] + "%W/W";
                    // EndRes = EndRes[0];
                    obj["End Result"] = EndRes
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].EndResult = EndRes
                    // arr.push({ EndRes: EndRes })
                    continue;
                }
                if (data_array[i].includes("Measurement end")) {
                    // let Measurementend = data_array[i + 1].replace('Measurement end', ' ').trim().split(" ");
                    // Measurementend = Measurementend[0] + ' ' + Measurementend[1];
                    let Measurementend = moment().format('YYYY-MM-DD') + ' ' + moment().format('HH:mm')
                    obj["Measurement end"] = Measurementend
                    let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                    globalData.dataMoist[index].Measurementend = Measurementend
                    // arr.push({ EndRes: EndRes })
                    continue;
                }
                if (data_array[i].includes("ABORTED")) {
                    isAborted = 1
                    continue;
                }
                if (data_array[i].includes("Measurement canceled")) {
                    mqttSender.sendData(strResberryPi, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Invalid String received`);
                    return;
                }
            }

            // var cubicObj = globalData.arrIdsInfo.find(k => k.TabIp == Ip);
            let validArrData = ["Start Weight", "Dry Weight", "Drying Temp", "End Result", "IPQC Instrument ID", "Total time", "SNR"];
            Object.assign(main.data, obj)
            let validatingFlag = this.isAbort(main.data, isAborted);
            if (Object.keys(main.data).length >= validArrData.length && validatingFlag == false) {
                Object.assign(obj, main.data)
                let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
                globalData.dataMoist[index].SWoff = 'NA'
                globalData.dataMoist[index].DryProg = 'NA'
                globalData.dataMoist[index].SW = 'NA'
                globalData.dataMoist[index].Measurementend = moment().format('DD.MM.YYYY') + ' ' + moment().format('HH:mm')
                obj["Measurement end"] = moment().format('DD.MM.YYYY') + ' ' + moment().format('HH:mm')
                obj["SW (Drying Unit)"] = 'NA';
                obj["SW (Terminal)"] = 'NA';
                obj["Switch Off"] = 'NA';
                obj["Drying Prog"] = 'NA';
                let cubicaldata = await models.tbl_cubical.findOne({
                    where: {
                        Sys_DSNumber: dataObj.currentOpStatus.DsNo
                    }
                })


                var cubicObj = {}
                cubicObj.cubicalData = cubicaldata
                var userInfo = globalData.arrUsers.find(k => k.TabIp == Ip);

                isAborted = this.isAbort(obj, isAborted);

                if (isAborted == 1) {
                    mqttSender.sendData(strResberryPi, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Invalid String received`)
                    let _activityObj = {
                        strUserId: userInfo.UserId,
                        strUserName: userInfo.UserName,
                        batch: cubicObj.cubicalData.Sys_Batch,
                        activity: `Invalid String received`
                    };

                    await objActivityLog.ActivityLogEntry(_activityObj);
                    return
                }

                let index1 = globalData.dataMoist.find(k => k.Ip == Ip)
                if (index1 != undefined) {
                    if (index1.StartWeight == undefined || index1.EndResult == undefined || index1.DryingTemp == undefined) {
                        mqttSender.sendData(strResberryPi, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Invalid String recieved`)
                        return
                    }
                    if (index1.StartWeight != undefined && index1.EndResult == undefined && index1.DryingTemp != undefined) {
                        return mqttSender.sendData(strResberryPi, "received")
                    }
                }

                arr.push(obj);
                // const TimeFormat = "HH:mm:ss";

                console.log(arr)
                if (arr.length == 0) {
                    mqttSender.sendData(strResberryPi, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Invalid String recieved`)
                    return
                }
                let dtData = globalData.arrWeighmentProductData.find(k => k.TabIp == Ip).data;


                // let currentOpStatus = globalData.arrCurrentOperationStatus.find(k => k.TabIp == Ip);
                // let tempCailibType = globalData.arrcalibType.find(k => k.Hmi == strHmi);
                let currentOpStatus = globalData.arrCurrentOperationStatus.find(k => k.DsNo == SelectedMenuDetails.DsNo && k.TabIp == Ip);
                let tempCailibType = globalData.arrcalibType.find(k => k.DsNo == SelectedMenuDetails.DsNo && k.TabIp == Ip);

                // let arrPortDetailForStart1 = await objHmi.idsPortSetting(strHmi)
                let intPortNo1 = dataObj.ProtocolPortNo;
                let strInstrumentType = dataObj.InstrumentType;
                let strInstrumentId = dataObj.InstrumentId;

                var __parameterWeighmentObj = {
                    DsNo: SelectedMenuDetails.DsNo,
                    TabIp: SelectedMenuDetails.TabIp,
                    DsIp: SelectedMenuDetails.DsIp,
                    instrumentId: strInstrumentId,
                    ProtocolPortNo: intPortNo1,
                    SelectedMenuDetails: SelectedMenuDetails,
                    menuName: SelectedMenuDetails.menuName,
                    idsNo: strResberryPi,
                    Hmi: strHmi,
                    actualWt: arr[0],
                    instrumentId: strInstrumentId,
                    Ip: Ip,
                    cubicObjData: cubicObj
                }

                if (arr == "") {
                    mqttSender.sendData(strResberryPi, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Invalid String recieved`)
                    return
                } else {
                    // if (strInstrumentType == GLOBAL_NOMENCLATURE.Balance) {
                    //     if (ProtocolUnit == undefined) {
                    //         ProtocolUnit = ProtocolUnit == undefined ? "g" : ProtocolUnit;
                    //     } else {
                    //         if ((ProtocolUnit != "g") && (ProtocolUnit != "kg") && (ProtocolUnit != "mg")) {
                    //             //log protocol in file
                    //             loggers.MqttProtocolLogger.info(`protocol : ${mqttProtocol.DisplayMessage}Invalid Data String sended to device ${strHmi}`)
                    //             return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid Data String`);
                    //         } else {
                    //             if (ProtocolUnit == "mg") {
                    //                 actualWt = actualWt / 1000;
                    //             } else if (ProtocolUnit == ("kg" || "Kg" || "KG")) {
                    //                 actualWt = actualWt * 1000;
                    //             }
                    //             ProtocolUnit = ProtocolUnit == undefined ? "g" : ProtocolUnit;

                    //         }
                    //     }

                    // } else {
                    //     //log protocol in file
                    //     loggers.MqttProtocolLogger.info(`unknown instrument`)
                    //     console.log('unknown instrument');
                    // }

                    //decision making 
                    if (tempCailibType == undefined) {
                        if (currentOpStatus == undefined) {
                            loggers.MqttProtocolLogger.info(`Weight recieve without any api called`)
                            console.log('wt recieve without any api called');
                            return;
                        } else if (currentOpStatus.Weighment == 1 && currentOpStatus.testType == "Weighment") {

                            // var instrumentData = `-MOISTURE DETERMINATION-

                            // End Result      ${obj["End Result"]}
                            // Measurement end
                            //         ${moment().format("DD.MM.YYYY HH:mm")}

                            // ---------- END ---------`

                            //                         var instrumentData = `Start Weight     ${obj["Start Weight"]}
                            // Dry Weight     ${obj["Dry Weight"]}
                            // End Result      ${obj["End Result"]}
                            //  `

                            // var instrumentData = `Start Weight     ${obj["Start Weight"]}
                            // Total time      ${obj["Total time"]}
                            // Dry Weight     ${obj["Dry Weight"]}
                            // End Result      ${obj["End Result"]}` 


                            // var instrumentData = `Dry Weight     ${obj["Dry Weight"]}`;
                            await objWeighmentData.ParsingTestData(mqttProtocol.LODMenu, __parameterWeighmentObj);
                        }
                    } else {
                        console.log('calibration is on and dt weighment part has clash')
                    }
                }
            }






        } catch (error) {
            throw new Error(error)
        }
    }

    // async parseMoistureAnalyserDataMA160(dataObj) {
    //     try {
    //         let { Str_Protocol, strResberryPi, strHmi, Ip, ProtocolPortNo, SelectedMenuDetails, instrumentId, ProtocolName } = dataObj;
    //         //here also different balance have different parsing logic
    //         let data_array = Str_Protocol.split("\n");
    //         let data = Str_Protocol.split(":")[2].trim();
    //         Ip = dataObj.TabIp
    //         strResberryPi = dataObj.currentOpStatus.DsNo
    //         let test_duration_found = false;
    //         let arm_found = false;
    //         var DryTemp, StrWeight, EndRes, Totaltime, FinalWt
    //         let arr = [];
    //         let obj = {}

    //         let main = globalData.dataMoist.find(k => k.Ip == Ip)

    //         if (main == undefined) {
    //             let obj = globalData.dataMoist.push({
    //                 hmi: strHmi,
    //                 DryingTemp: DryTemp,
    //                 StartWeight: StrWeight,
    //                 FinWt: FinalWt,
    //                 EndResult: EndRes,
    //                 Total: Totaltime,
    //                 Ip: Ip

    //             })
    //         }
    //         var isAborted = 0;

    //         obj["IPQC Instrument ID"] = dataObj.InstrumentId

    //         for (let i = 0; i < data_array.length; i++) {
    //             // data = data_array[i].trim();
    //             if (data == "" || data == null)
    //                 continue;
    //             if (data_array[i].includes("SerNo")) {
    //                 let srNo = data_array[i].replace('SerNo.', ' ').trim().split();
    //                 srNo = srNo[0];
    //                 obj["SNR"] = srNo;
    //                 // arr.push({ SWunit: SWunit })
    //                 let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
    //                 globalData.dataMoist[index].srno = srNo
    //                 continue;
    //             }
    //             if (data_array[i].includes("SW(Drying Unit)")) {
    //                 let SWunit = data_array[i].replace('SW(Drying Unit)', ' ').trim().split();
    //                 SWunit = SWunit[0];
    //                 obj["SW (Drying Unit)"] = SWunit;
    //                 // arr.push({ SWunit: SWunit })
    //                 let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
    //                 globalData.dataMoist[index].SW = SWunit
    //                 continue;
    //             }
    //             if (data_array[i].includes("SW(Terminal)")) {
    //                 let SWterminal = data_array[i].replace('SW(Terminal)', ' ').trim().split();
    //                 SWterminal = SWterminal[0];
    //                 obj["SW (Terminal)"] = SWterminal;
    //                 // arr.push({ SWterminal: SWterminal })
    //                 let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
    //                 globalData.dataMoist[index].SW = SWterminal
    //                 continue;
    //             }
    //             if (data_array[i].includes("Method Name")) {

    //                 // var newStringData = data_array.join('\n');

    //                 // var tempdata = newStringData.slice(
    //                 //     newStringData.lastIndexOf("Method Name"),
    //                 //     newStringData.lastIndexOf("Drying Prog"),
    //                 // );

    //                 // let Pname = data_array[i+1].replace('Method Name', ' ').trim().split();
    //                 // let Pname = data_array[i].replace('Method Name', ' ').trim().split();
    //                 let Pname = data_array[i + 1].trim().split();
    //                 if (Pname[0] == '') {
    //                     Pname = data_array[i + 1].replace('Method Name', ' ').trim().split();
    //                     if (!data_array[i + 2].includes("Drying Prog")) {
    //                         var tempname = data_array[i + 2].replace('Method Name', ' ').trim().split();
    //                         Pname = Pname[0] + tempname[0]
    //                         Pname = [Pname]
    //                     }
    //                 }
    //                 Pname = Pname[0];
    //                 obj["Product Name"] = Pname;
    //                 // arr.push({ SWterminal: SWterminal })
    //                 let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
    //                 globalData.dataMoist[index].Pname = Pname
    //                 continue;
    //             }
    //             if (data_array[i].includes("Drying Prog")) {
    //                 let DryProg = data_array[i].replace('Drying Prog', ' ').trim().split();
    //                 DryProg = DryProg[0];
    //                 obj["Drying Prog"] = DryProg
    //                 // arr.push({ DryTemp: DryTemp })
    //                 let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
    //                 globalData.dataMoist[index].DryProg = DryProg
    //                 continue;
    //             }
    //             if (data_array[i].includes("Switch Off")) {
    //                 let Switchoff = data_array[i].replace('Switch Off', ' ').trim().split();
    //                 Switchoff = Switchoff[0];
    //                 obj["Switch Off"] = Switchoff;
    //                 // arr.push({ SWterminal: SWterminal })
    //                 let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
    //                 globalData.dataMoist[index].SWoff = Switchoff
    //                 continue;
    //             }
    //             if (data_array[i].includes("Temperature")) {
    //                 // let DryTemp = data_array[i].replace('Drying Temp', ' ').trim().split();
    //                 let DryTemp = data_array[i + 1].trim().split()
    //                 DryTemp = DryTemp[0].split(" ")[0];
    //                 obj["Drying Temp"] = DryTemp
    //                 // arr.push({ DryTemp: DryTemp })
    //                 let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
    //                 globalData.dataMoist[index].DryingTemp = DryTemp
    //                 continue;
    //             }
    //             if (data_array[i].includes("Start weight")) {
    //                 let StrWeight = data_array[i + 1].replace('+', '').trim().split();
    //                 // StrWeight = data_array[i+1].trim().split();
    //                 let StartWeight = StrWeight[0]
    //                 obj["Start Weight"] = StartWeight
    //                 // arr.push({ StrWeight: StrWeight })
    //                 let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
    //                 globalData.dataMoist[index].StartWeight = StrWeight
    //                 continue;
    //             }
    //             if (data_array[i].includes("Final weight")) {
    //                 // let FinalWt = data_array[i].replace('Dry Weight', ' ').trim().split();
    //                 let FinalWt = data_array[i + 1].replace('+', '').trim().split();
    //                 FinalWt = FinalWt[0];
    //                 obj["Dry Weight"] = FinalWt;
    //                 // arr.push({ SWterminal: SWterminal })
    //                 let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
    //                 globalData.dataMoist[index].FinWt = FinalWt
    //                 continue;
    //             }
    //             if (data_array[i].includes("Measurement time")) {
    //                 // let Totaltime = data_array[i].replace('Total time', ' ').trim().split();
    //                 let Totaltime = data_array[i + 1].trim().split();
    //                 // Totaltime = "00:" + Totaltime[0].split(" ")[0] + ' ' + Totaltime[0].split(" ")[1]
    //                 Totaltime = Totaltime[0];
    //                 obj["Total time"] = Totaltime
    //                 // arr.push({ Totaltime: Totaltime })
    //                 let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
    //                 globalData.dataMoist[index].Total = Totaltime
    //                 continue;
    //             }
    //             if (data_array[i] == 'Result') {
    //                 // let EndRes = data_array[i].replace('End Result', ' ').trim().split();
    //                 let EndRes = data_array[i + 1].trim().split();
    //                 EndRes = EndRes[0].split('%')[0] + "%W/W";
    //                 // EndRes = EndRes[0];
    //                 obj["End Result"] = EndRes
    //                 let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
    //                 globalData.dataMoist[index].EndResult = EndRes
    //                 // arr.push({ EndRes: EndRes })
    //                 continue;
    //             }
    //             if (data_array[i].includes("Measurement end")) {
    //                 // let Measurementend = data_array[i + 1].replace('Measurement end', ' ').trim().split(" ");
    //                 // Measurementend = Measurementend[0] + ' ' + Measurementend[1];
    //                 let Measurementend = moment().format('YYYY-MM-DD') + ' ' + moment().format('hh:mm:ss')
    //                 obj["Measurement end"] = Measurementend
    //                 let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
    //                 globalData.dataMoist[index].Measurementend = Measurementend
    //                 // arr.push({ EndRes: EndRes })
    //                 continue;
    //             }
    //             if (data_array[i].includes("ABORTED")) {
    //                 isAborted = 1
    //                 continue;
    //             }
    //         }

    //         // var cubicObj = globalData.arrIdsInfo.find(k => k.TabIp == Ip);

    //         let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
    //         globalData.dataMoist[index].SWoff = 'NA'
    //         globalData.dataMoist[index].DryProg = 'NA'
    //         globalData.dataMoist[index].SW = 'NA'
    //         globalData.dataMoist[index].Measurementend = moment().format('DD.MM.YYYY') + ' ' + moment().format('hh:mm')
    //         obj["Measurement end"] = moment().format('DD.MM.YYYY') + ' ' + moment().format('hh:mm')
    //         obj["SW (Drying Unit)"] = 'NA';
    //         obj["SW (Terminal)"] = 'NA';
    //         obj["Switch Off"] = 'NA';
    //         obj["Drying Prog"] = 'NA';



    //         let cubicaldata = await models.tbl_cubical.findOne({
    //             where: {
    //                 Sys_DSNumber: dataObj.currentOpStatus.DsNo
    //             }
    //         })

    //         var cubicObj = {}
    //         cubicObj.cubicalData = cubicaldata
    //         var userInfo = globalData.arrUsers.find(k => k.TabIp == Ip);

    //         isAborted = this.isAbort(obj, isAborted);

    //         if (isAborted == 1) {
    //             mqttSender.sendData(strResberryPi, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Invalid String received`)
    //             let _activityObj = {
    //                 strUserId: userInfo.UserId,
    //                 strUserName: userInfo.UserName,
    //                 batch: cubicObj.cubicalData.Sys_Batch,
    //                 activity: `Invalid String received`
    //             };

    //             await objActivityLog.ActivityLogEntry(_activityObj);
    //             return
    //         }

    //         let index1 = globalData.dataMoist.find(k => k.Ip == Ip)
    //         if (index1 != undefined) {
    //             if (index1.StartWeight == undefined || index1.EndResult == undefined || index1.DryingTemp == undefined) {
    //                 mqttSender.sendData(strResberryPi, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Invalid String recieved`)
    //                 return
    //             }
    //             if (index1.StartWeight != undefined && index1.EndResult == undefined && index1.DryingTemp != undefined) {
    //                 return mqttSender.sendData(strResberryPi, "received")
    //             }
    //         }

    //         arr.push(obj);
    //         // const TimeFormat = "HH:mm:ss";

    //         console.log(arr)
    //         if (arr.length == 0) {
    //             mqttSender.sendData(strResberryPi, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Invalid String recieved`)
    //             return
    //         }
    //         let dtData = globalData.arrWeighmentProductData.find(k => k.TabIp == Ip).data;


    //         let currentOpStatus = globalData.arrCurrentOperationStatus.find(k => k.TabIp == Ip);
    //         let tempCailibType = globalData.arrcalibType.find(k => k.Hmi == strHmi);
    //         // let arrPortDetailForStart1 = await objHmi.idsPortSetting(strHmi)
    //         let intPortNo1 = dataObj.ProtocolPortNo;
    //         let strInstrumentType = dataObj.InstrumentType;
    //         let strInstrumentId = dataObj.InstrumentId;

    //         var __parameterWeighmentObj = {
    //             DsNo: SelectedMenuDetails.DsNo,
    //             TabIp: SelectedMenuDetails.TabIp,
    //             DsIp: SelectedMenuDetails.DsIp,
    //             instrumentId: strInstrumentId,
    //             ProtocolPortNo: intPortNo1,
    //             SelectedMenuDetails: SelectedMenuDetails,
    //             menuName: SelectedMenuDetails.menuName,
    //             idsNo: strResberryPi,
    //             Hmi: strHmi,
    //             actualWt: arr[0],
    //             instrumentId: strInstrumentId,
    //             Ip: Ip,
    //             cubicObjData: cubicObj
    //         }

    //         if (arr == "") {
    //             mqttSender.sendData(strResberryPi, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayMessage}Invalid String recieved`)
    //             return
    //         } else {
    //             // if (strInstrumentType == GLOBAL_NOMENCLATURE.Balance) {
    //             //     if (ProtocolUnit == undefined) {
    //             //         ProtocolUnit = ProtocolUnit == undefined ? "g" : ProtocolUnit;
    //             //     } else {
    //             //         if ((ProtocolUnit != "g") && (ProtocolUnit != "kg") && (ProtocolUnit != "mg")) {
    //             //             //log protocol in file
    //             //             loggers.MqttProtocolLogger.info(`protocol : ${mqttProtocol.DisplayMessage}Invalid Data String sended to device ${strHmi}`)
    //             //             return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid Data String`);
    //             //         } else {
    //             //             if (ProtocolUnit == "mg") {
    //             //                 actualWt = actualWt / 1000;
    //             //             } else if (ProtocolUnit == ("kg" || "Kg" || "KG")) {
    //             //                 actualWt = actualWt * 1000;
    //             //             }
    //             //             ProtocolUnit = ProtocolUnit == undefined ? "g" : ProtocolUnit;

    //             //         }
    //             //     }

    //             // } else {
    //             //     //log protocol in file
    //             //     loggers.MqttProtocolLogger.info(`unknown instrument`)
    //             //     console.log('unknown instrument');
    //             // }

    //             //decision making 
    //             if (tempCailibType == undefined) {
    //                 if (currentOpStatus == undefined) {
    //                     loggers.MqttProtocolLogger.info(`Weight recieve without any api called`)
    //                     console.log('wt recieve without any api called');
    //                     return;
    //                 } else if (currentOpStatus.Weighment == 1 && currentOpStatus.testType == "Weighment") {

    //                     // var instrumentData = `-MOISTURE DETERMINATION-

    //                     // End Result      ${obj["End Result"]}
    //                     // Measurement end
    //                     //         ${moment().format("DD.MM.YYYY HH:mm")}

    //                     // ---------- END ---------`

    //                     //                         var instrumentData = `Start Weight     ${obj["Start Weight"]}
    //                     // Dry Weight     ${obj["Dry Weight"]}
    //                     // End Result      ${obj["End Result"]}
    //                     //  `

    //                     // var instrumentData = `Start Weight     ${obj["Start Weight"]}
    //                     // Total time      ${obj["Total time"]}
    //                     // Dry Weight     ${obj["Dry Weight"]}
    //                     // End Result      ${obj["End Result"]}` 


    //                     // var instrumentData = `Dry Weight     ${obj["Dry Weight"]}`;
    //                     await objWeighmentData.ParsingTestData(mqttProtocol.LODMenu, __parameterWeighmentObj);
    //                 }
    //             } else {
    //                 console.log('calibration is on and dt weighment part has clash')
    //             }
    //         }
    //         // }
    //     } catch (error) {
    //         throw new Error(error)
    //     }
    // }

    // async parseMoistureAnalyserDataHX204(dataObj) {
    //     try {
    //         let { str_Protocol, strResberryPi, strHmi, Ip, ProtocolPortNo, instrumentId, ProtocolName } = dataObj;
    //         //here also different balance have different parsing logic
    //         let data_array = str_Protocol.split("\n");
    //         let data = str_Protocol.split(":")[2].trim();
    //         let test_duration_found = false;
    //         let arm_found = false;
    //         var DryTemp, StrWeight, EndRes, Totaltime
    //         let arr = [];
    //         let obj = {}

    //         let main = globalData.dataMoist.find(k => k.Ip == Ip)

    //         if (main == undefined) {
    //             let obj = globalData.dataMoist.push({
    //                 hmi: strHmi,
    //                 DryingTemp: DryTemp,
    //                 StartWeight: StrWeight,
    //                 EndResult: EndRes,
    //                 Total: Totaltime,
    //                 Ip: Ip

    //             })
    //         }

    //         for (let i = 0; i < data_array.length; i++) {
    //             // data = data_array[i].trim();
    //             if (data == "" || data == null)
    //                 continue;
    //             if (data_array[i].includes("SW (Drying Unit )")) {
    //                 let SWunit = data_array[i].replace('SW (Drying Unit )', ' ').trim().split();
    //                 SWunit = SWunit[0];
    //                 obj["SW (Drying Unit)"] = SWunit;
    //                 // arr.push({ SWunit: SWunit })
    //                 let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
    //                 globalData.dataMoist[index].SW = SWunit
    //                 continue;
    //             }
    //             if (data_array[i].includes("SW (Terminal )")) {
    //                 let SWterminal = data_array[i].replace('SW (Terminal )', ' ').trim().split();
    //                 SWterminal = SWterminal[0];
    //                 obj["SW (Terminal)"] = SWterminal;
    //                 // arr.push({ SWterminal: SWterminal })
    //                 let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
    //                 globalData.dataMoist[index].SW = SWterminal
    //                 continue;
    //             }
    //             if (data_array[i].includes("Drying Temp")) {
    //                 let DryTemp = data_array[i].replace('Drying Temp', ' ').trim().split();
    //                 DryTemp = DryTemp[0];
    //                 obj["Drying Temp"] = DryTemp
    //                 // arr.push({ DryTemp: DryTemp })
    //                 let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
    //                 globalData.dataMoist[index].DryingTemp = DryTemp
    //                 continue;
    //             }
    //             if (data_array[i].includes("Start Weight")) {
    //                 let StrWeight = data_array[i].replace('Start Weight', ' ').trim().split();
    //                 StrWeight = StrWeight[0];
    //                 obj["Start Weight"] = StrWeight
    //                 // arr.push({ StrWeight: StrWeight })
    //                 let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
    //                 globalData.dataMoist[index].StartWeight = StrWeight
    //                 continue;
    //             }
    //             if (data_array[i].includes("Total time")) {
    //                 let Totaltime = data_array[i].replace('Total time', ' ').trim().split();
    //                 Totaltime = Totaltime[0];
    //                 obj["Total time"] = Totaltime
    //                 // arr.push({ Totaltime: Totaltime })
    //                 let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
    //                 globalData.dataMoist[index].Total = Totaltime
    //                 continue;
    //             }
    //             if (data_array[i].includes("End Result")) {
    //                 let EndRes = data_array[i].replace('End Result', ' ').trim().split();
    //                 EndRes = EndRes[0];
    //                 obj["End Result"] = EndRes
    //                 let index = globalData.dataMoist.findIndex(k => k.Ip == Ip)
    //                 globalData.dataMoist[index].EndResult = EndRes
    //                 // arr.push({ EndRes: EndRes })
    //                 continue;
    //             }
    //         }

    //         let index1 = globalData.dataMoist.find(k => k.Ip == Ip)
    //         if (index1 != undefined) {
    //             if (index1.StartWeight == undefined || index1.EndResult == undefined || index1.DryingTemp == undefined) {
    //                 mqttSender.sendData(Ip, `${mqttProtocol.DisplayMessage}Invalid String recieved`)
    //                 return
    //             }
    //             if (index1.StartWeight != undefined && index1.EndResult == undefined && index1.DryingTemp != undefined) {
    //                 return mqttSender.sendData(Ip, "received")
    //             }
    //         }

    //         arr.push(obj);
    //         // const TimeFormat = "HH:mm:ss";

    //         console.log(arr)
    //         if (arr.length == 0) {
    //             mqttSender.sendData(Ip, `${mqttProtocol.DisplayMessage}Invalid String recieved`)
    //             return
    //         }
    //         let dtData = globalData.arrWeighmentProductData.find(k => k.Ip == Ip).data;


    //         let currentOpStatus = globalData.arrCurrentOperationStatus.find(k => k.Ip == Ip);
    //         let tempCailibType = globalData.arrcalibType.find(k => k.Hmi == strHmi);
    //         // let arrPortDetailForStart1 = await objHmi.idsPortSetting(strHmi)
    //         let intPortNo1 = dataObj.ProtocolPortNo;
    //         let strInstrumentType = dataObj.InstrumentType;
    //         let strInstrumentId = dataObj.InstrumentId;
    //         const __parameterWeighmentObj = {
    //             idsNo: strResberryPi,
    //             Hmi: strHmi,
    //             actualWt: arr[0],
    //             instrumentId: strInstrumentId,
    //             Ip: Ip
    //         }
    //         if (arr == "") {
    //             mqttSender.sendData(Ip, `${mqttProtocol.DisplayMessage}Invalid String recieved`)
    //             return
    //         } else {
    //             // if (strInstrumentType == GLOBAL_NOMENCLATURE.Balance) {
    //             //     if (ProtocolUnit == undefined) {
    //             //         ProtocolUnit = ProtocolUnit == undefined ? "g" : ProtocolUnit;
    //             //     } else {
    //             //         if ((ProtocolUnit != "g") && (ProtocolUnit != "kg") && (ProtocolUnit != "mg")) {
    //             //             //log protocol in file
    //             //             loggers.MqttProtocolLogger.info(`protocol : ${mqttProtocol.DisplayMessage}Invalid Data String sended to device ${strHmi}`)
    //             //             return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid Data String`);
    //             //         } else {
    //             //             if (ProtocolUnit == "mg") {
    //             //                 actualWt = actualWt / 1000;
    //             //             } else if (ProtocolUnit == ("kg" || "Kg" || "KG")) {
    //             //                 actualWt = actualWt * 1000;
    //             //             }
    //             //             ProtocolUnit = ProtocolUnit == undefined ? "g" : ProtocolUnit;

    //             //         }
    //             //     }

    //             // } else {
    //             //     //log protocol in file
    //             //     loggers.MqttProtocolLogger.info(`unknown instrument`)
    //             //     console.log('unknown instrument');
    //             // }

    //             //decision making 
    //             if (tempCailibType == undefined) {
    //                 if (currentOpStatus == undefined) {
    //                     loggers.MqttProtocolLogger.info(`Weight recieve without any api called`)
    //                     console.log('wt recieve without any api called');
    //                     return;
    //                 } else if (currentOpStatus.Weighment == 1 && currentOpStatus.testType == "Weighment") {

    //                     var instrumentData = `-MOISTURE DETERMINATION-

    //                     End Result      ${obj["End Result"]}
    //                     Measurement end
    //                             ${moment().format("DD.MM.YYYY HH:mm")}

    //                     ---------- END ---------`
    //                     await objWeighmentData.ParsingTestData(__parameterWeighmentObj, instrumentData);
    //                 }
    //             } else {
    //                 console.log('calibration is on and dt weighment part has clash')
    //             }
    //         }
    //         // }
    //     } catch (error) {
    //         throw new Error(error)
    //     }
    // }

    // if (tempCailibType == undefined) {
    //     if (currentOpStatus == undefined) {
    //         loggers.MqttProtocolLogger.info(`Weight recieve without any api called`)
    //         console.log('wt recieve without any api called');
    //         return;
    //     } else if (currentOpStatus.Weighment == 1 && currentOpStatus.testType == "Weighment") {

    //         var instrumentData = `-MOISTURE DETERMINATION-

    //         End Result      ${obj["End Result"]}
    //         Measurement end
    //                 ${moment().format("DD.MM.YYYY HH:mm")}

    //         ---------- END ---------`
    //         await objWeighmentData.ParsingTestData(__parameterWeighmentObj, instrumentData);
    //     }
    // } else {
    //     console.log('calibration is on and dt weighment part has clash')
    // }



    isAbort(obj, isAborted) {


        if (!obj.hasOwnProperty("Start Weight") || obj["Start Weight"] == undefined || obj["Start Weight"] == null || obj["Start Weight"] == "") {
            console.log("Start Weight is Missing");
            isAborted = 1;
        } else if (!obj.hasOwnProperty("Total time") || obj["Total time"] == undefined || obj["Total time"] == null || obj["Total time"] == "") {
            console.log("Total time is Missing");
            isAborted = 1;
        } else if (!obj.hasOwnProperty("Dry Weight") || obj["Dry Weight"] == undefined || obj["Dry Weight"] == null || obj["Dry Weight"] == "") {
            console.log("Dry Weight is Missing");
            isAborted = 1;
        } else if (!obj.hasOwnProperty("Drying Temp") || obj["Drying Temp"] == undefined || obj["Drying Temp"] == null || obj["Drying Temp"] == "") {
            console.log("Drying Temp is Missing");
            isAborted = 1;
        } else if (!obj.hasOwnProperty("End Result") || obj["End Result"] == undefined || obj["End Result"] == null || obj["End Result"] == "" || obj["End Result"] == '%') {
            console.log("End Result is Missing");
            isAborted = 1;

        } else if (!obj.hasOwnProperty("IPQC Instrument ID") || obj["IPQC Instrument ID"] == undefined || obj["IPQC Instrument ID"] == null || obj["IPQC Instrument ID"] == "") {
            console.log("IPQC Instrument ID is missing");
            isAborted = 1;
        }

        return isAborted;


    }


}

module.exports = MoistureAnalyserParsing;