//packages
const date = require("date-and-time");
const moment = require("moment");
//modules
const clsHmiModel = require("../hmiDetail.model");
const Database = require("../../database/clsQueryProcess");
const globalData = require("../../global/globalData");
const PreWeighmentCheck = require("../preWeighmentCheck");
// const clsMesModel = require('../../MES/mes.model')
const serverConfig = require("../../global/serverConfig");
const clsFormulaFun = require("../Product/clsformulaFun.model");
const GLOBAL_NOMENCLATURE = require("../../global/GLOBAL_NOMENCLATURE");
const clsCommonOperation = require("../Product/clsCommonInsertOperation.model");
const { length, unique } = require("joi/lib/types/array");
const models = require("../../../config/dbConnection").models;
const sequelize = require("../../../config/dbConnection").sequelize;
// const { QueryTypes, where } = require("sequelize");
const Hmi = require("../hmiDetail.model");
const MQTTSender = require("../Mqtt/mqttSender.class");
// const mesModel = require("../../../INTERFACE/MES/mes.model")
const { Numeric } = require("mssql");
const requestIp = require("request-ip");
const { Op } = require("sequelize");
const tbl_cubical = require("../../../../IncrencyV4_DRL_Model/models/Setting/System Setting/tbl_cubical");
const configFile = require('../../../../IncrencyV4DRLTSHConfig.json');
const tbl_powerbackup = require("../../../../IncrencyV4_DRL_Model/models/Report/Common Tablet-Capsule/tbl_powerbackup");
const maths = require('mathjs');
const clsCommonWeightment = require("../Product/clsCommonWeightment");
const tbl_tab_initialmaster = require("../../../../IncrencyV4_DRL_Model/models/Report/Tablet/tbl_tab_initialmaster");
const tbl_machine = require("../../../../IncrencyV4_DRL_Model/models/Master/Machine/tbl_machine");
//instances of classes
const objCommonWeightment = new clsCommonWeightment();
const objHmiModel = new clsHmiModel();
const database = new Database();
const objPreCheck = new PreWeighmentCheck();
const objFormulaFun = new clsFormulaFun();
const objCommonOperation = new clsCommonOperation();
let now = new Date();
const mqttSender = new MQTTSender();
// const objmesModel = new mesModel();
// const objMesModel = new clsMesModel();

class Menu {
  async getMenu(values) {
    try {
      let resObj = {};
      let strHmi = values.Hmi;
      let strUserId = values.UserId;
      let strUserName = values.UserName;
      var Ip = values.Ip;
      let objIdsNo = await objHmiModel.getResbPiNoFromHmi(strHmi);
      let IdsNo = objIdsNo[0].Sys_IDSNo;
      let selectedIdsNo;
      let bulkReceived = globalData.bulkFlag.find((k) => k.Ip == Ip);
      if (bulkReceived == undefined) {
        globalData.bulkFlag.push({
          Hmi: strHmi,
          bulkFlag: false,
          Ip: Ip,
        });
      } else {
        bulkReceived.bulkFlag = false;
      }

      let objCalibratedBal = globalData.glbArrListOfCalibratedBal.find(
        (k) => k.Ip == Ip
      );
      if (objCalibratedBal == undefined) {
        globalData.glbArrListOfCalibratedBal.push({
          idsNo: IdsNo,
          Hmi: strHmi,
          CalibratedBalList: [" "],
          Ip: Ip,
        });
      } else {
        objCalibratedBal.CalibratedBalList = [" "];
      }

      var IPQCObject = globalData.arr_IPQCRelIds.find((k) => k.idsNo == IdsNo);
      if (IPQCObject != undefined) {
        selectedIdsNo = IPQCObject.selectedIds;
      } else {
        selectedIdsNo = IdsNo;
      }

      var selectedHmi = await objHmiModel.getHmiNoFromResbPi(selectedIdsNo);

      let checkFri = globalData.arrBFBO.find((k) => k.Ip == Ip);

      if (checkFri == undefined) {
        globalData.arrBFBO.push({
          idsNo: IdsNo,
          before: false,
          setParam: false,
          after: false,
          Ip: Ip,
        });
      } else {
        checkFri.idsNo = IdsNo;
      }

      globalData.arrcalibType.findIndex((element) => element.Ip === strHmi) ==
        -1
        ? globalData.arrcalibType
        : globalData.arrcalibType.splice(
          globalData.arrcalibType.findIndex((element) => element.Ip === Ip),
          1
        );

      globalData.arrCurrentOperationStatus.findIndex(
        (element) => element.Ip === Ip
      ) == -1
        ? globalData.arrCurrentOperationStatus
        : globalData.arrCurrentOperationStatus.splice(
          globalData.arrCurrentOperationStatus.findIndex(
            (element) => element.Ip === Ip
          ),
          1
        );

      var tempArrRightsObj = globalData.arrUserRights.find((k) => k.Ip == Ip);
      if (tempArrRightsObj != undefined) {
        if (tempArrRightsObj.removeRights.includes("Test")) {
          return Object.assign(resObj, {
            status: "fail",
            message: "Test Right Not Assigned",
          });
        }
        if (!tempArrRightsObj.rights.includes("Test")) {
          return Object.assign(resObj, {
            status: "fail",
            message: "Test Right Not Assigned",
          });
        }
      }

      const cubicalObj = await models.tbl_cubical.findAll({
        where: {
          Sys_IDSNo: selectedHmi,
        },
      });
      let arrResCubicalObj = [[cubicalObj[0]]];

      if (arrResCubicalObj[0].length < 0) {
        //return with error message
        console.log("no entry in cubical");
      }

      let cubicObj = globalData.arrIdsInfo.find((k) => k.Ip == Ip);
      if (cubicObj == undefined) {
        globalData.arrIdsInfo.push({
          Hmi: selectedHmi,
          idsNo: selectedIdsNo,
          cubicalData: arrResCubicalObj[0][0],
          Ip: Ip,
          IPAddress: arrResCubicalObj[0][0].IPAddress
        });
      } else {
        cubicObj.idsNo = selectedIdsNo;
        cubicObj.cubicalData = arrResCubicalObj[0][0];
        cubicObj.Ip = Ip;
        cubicObj.IPAddress = arrResCubicalObj[0][0].IPAddress
      }

      let checkIfProductSet = await objPreCheck.CheckProductSet(
        selectedHmi,
        Ip
      );
      if (!checkIfProductSet) {
        return Object.assign(resObj, {
          status: "fail",
          message: "Product not set",
        });
      }

      let checkBatchStatus = await objPreCheck.CheckBatchStatus(
        selectedIdsNo,
        selectedHmi,
        Ip
      );
      if (!checkBatchStatus.status) {
        return Object.assign(resObj, {
          status: "fail",
          message: checkBatchStatus.message,
        });
      }

      await this.lockedWeighingStatus(
        arrResCubicalObj[0][0].Sys_CubicNo,
        arrResCubicalObj[0][0].Sys_Batch,
        arrResCubicalObj[0][0].Sys_CubType
      );
      const Product = {
        ProductId: arrResCubicalObj[0][0].Sys_BFGCode,
        ProductName: arrResCubicalObj[0][0].Sys_ProductName,
        ProductVersion: arrResCubicalObj[0][0].Sys_PVersion,
        Version: arrResCubicalObj[0][0].Sys_Version,
      };

      const selectProductMaster = await models.tbl_product_master.findAll({
        where: {
          ProductName: Product.ProductName,
          ProductId: Product.ProductId,
          ProductVersion: Product.ProductVersion,
          Version: Product.Version,
        },
      });

      var productType = selectProductMaster[0].ProductType;

      let cubicObjCurrent = globalData.arrIdsInfo.find(
        (k) => k.Ip == Ip
      ).cubicalData;

      const __parameterObj = {
        Product: Product,
        IdsNo: IdsNo,
        CubicalType: cubicObjCurrent.Sys_CubType,
        AreaInCubical: cubicObjCurrent.Sys_Area,
        AllCubicalData: cubicObjCurrent,
        Hmi: strHmi,
      };

      let processMenu = await this.processCubical(__parameterObj, IdsNo, Ip);

      let hardnessMasterEntryArr = globalData.HardnessMasterEntry.find(
        (k) => k.Ip == Ip
      );
      if (hardnessMasterEntryArr == undefined) {
        globalData.HardnessMasterEntry.push({
          Hmi: strHmi,
          masterEntryDone: false,
          savedToMaster: false,
          Ip: Ip,
        });
      } else {
        hardnessMasterEntryArr.masterEntryDone = false;
        hardnessMasterEntryArr.savedToMaster = false;
      }

      var selectRepSrNoObj = await models.tbl_powerbackup.findAll({
        where: {
          CubicalNo: cubicObjCurrent.Sys_CubicNo,
        },
      });

      let powerbacc = [selectRepSrNoObj];
      powerbacc = powerbacc[0].pop();
      let time;
      if (powerbacc == undefined) {
        time = 0;
      } else {
        time = moment(powerbacc.EntryTimeStamp).format("hh:mm");
      }
      cubicObjCurrent.Sys_Port1;
      cubicObjCurrent.Sys_Port2;
      cubicObjCurrent.Sys_Port3;
      cubicObjCurrent.Sys_Port4;
      let i = 1;
      var idsmenu = [];
      for (let obj in cubicObjCurrent) {
        if (
          cubicObjCurrent[`Sys_Port${i}`] == undefined ||
          cubicObjCurrent[`Sys_Port${i}`] == "None" ||
          cubicObjCurrent[`Sys_Port${i}`] == "NULL" ||
          cubicObjCurrent[`Sys_Port${i}`] == null
        ) {
          i++;
          continue;
        } else {
          let type = cubicObjCurrent[`Sys_Port${i}`];
          if (cubicObjCurrent[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.Balance) {
            if (processMenu.includes("Individual")) {
              idsmenu.push(`Port ${i} : Individual`);
            }
            if (processMenu.includes("Group")) {
              idsmenu.push(`Port ${i} : Group`);
            }
          } else if (
            cubicObjCurrent[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.Hardness
          ) {
            // InstrumentType = GLOBAL_NOMENCLATURE.Balance;
            idsmenu.push(`Port ${i} : Hardness`);
          } else if (
            cubicObjCurrent[`Sys_Port${i}`] ==
            GLOBAL_NOMENCLATURE.MoistureAnalyzer
          ) {
            // InstrumentType = GLOBAL_NOMENCLATURE.Balance;
            if (processMenu.includes("LOD")) {
              idsmenu.push(`Port ${i} : LOD`);
            }
          }
          i++;
        }
        //console.log(arrAllListOfBal);
      }
      // if(cubicObjCurrent.Sys_Port1 != "NULL"){

      // }
      // if(cubicObjCurrent.Sys_Port2 != "NULL"){

      // }
      // if(cubicObjCurrent.Sys_Port3 != "NULL"){

      // }
      // if(cubicObjCurrent.Sys_Port4 != "NULL"){

      // }
      //         //need to check it once
      processMenu = idsmenu;
      if (powerbacc) {
        let date1 = new Date();
        // let initSampletime = new Date(date.format(new Date(this.DateFormat(now, time)), 'YYYY-MM-DD HH:mm:ss')).toLocaleString().replace(',', ' ');
        let initSampletime = moment(powerbacc.EntryTimeStamp)
          .add(4, "minutes")
          .format("YYYY-MM-DD HH:mm:ss")
          .toLocaleString()
          .replace(",", " ");
        let currentTime = new Date(
          date.format(new Date(), "YYYY-MM-DD HH:mm:ss")
        )
          .toLocaleString()
          .replace(",", " ");
        console.log(this.DateFormat(now, time));

        if (
          Date.parse(currentTime) >= Date.parse(initSampletime) ||
          initSampletime == "Invalid Date"
        ) {
          console.log("time match or excced");
          return Object.assign(resObj, {
            status: "success",
            result: processMenu,
          });
        } else {
          console.log("time not match");
          let hideMenu = processMenu.filter((k) => k != "FRIAB");
          return Object.assign(resObj, {
            status: "success",
            result: hideMenu,
          });
        }
      } else {
        return Object.assign(resObj, {
          status: "success",
          result: idsmenu,
        });
      }
    } catch (error) {
      throw new Error(error);
    }
  }

  async getBarcodeData(values) {
    console.log("Get Barcode data after it has been scanned");

    const DsNo = values.dsNo;
    const TabIp = values.tabIp;
    const userId = values.userId;
    // const productId = values.productId;
    // const productName = values.productName;
    const batch = values.batch;
    const sfoId = values.sfoId;
    let MPN = values.mpr;
    // MPN = "MPN_2"
    // MPN instead of productId
    // SFOID

    await models.tbl_cubical.update({
      // Sys_BFGCode: productId,
      // Sys_ProductName: productName,
      Sys_MPNCode: MPN,
      Sys_Batch: batch,
      isManual: 1,
      Sys_SFOID: sfoId
    }, {
      where: {
        Sys_DSNumber: DsNo
      }
    })

    const cubicalRes = await models.tbl_cubical.findOne({
      where: {
        Sys_DSNumber: DsNo,
      },
    });
    console.log('cubicalRes: ', cubicalRes);

    if (cubicalRes.Sys_LeakID == "None" && cubicalRes.Sys_LeakID == "") {
      const productMasterRes = await models.tbl_product_master.findOne({
        where: {
          MPN_Code: MPN
          // ProductId: productId,
          // ProductName: productName
        }
      })

      if (!productMasterRes) {
        console.log("No product found in tbl_product_master");
        return {
          status: "fail",
          message: "Product not found"
        };
      }
    }


    await this.getMannualMenu({
      dsNo: DsNo,
      tabIp: TabIp,
      userId,
      // productId,
      // productName,
      MPN,
      batch
    })

    return {
      status: "success"
    }
  }

  async getMannualMenu(values) {
    try {
      const TabIp = values.tabIp;
      const DsNo = values.dsNo;
      let selectedDsNo = values.dsNo;
      let selectedBatch = "";
      const userId = values.userId;
      // const productId = values.productId;
      // const productName = values.productName;
      let MPN = values.MPN;
      MPN = "MPN_12";
      const batch = values.batch;
      let resObj = {};

      let arrIPQC = globalData.arr_IPQCRelIds.find(k => k.DsNo == DsNo && k.tabIp == TabIp);
      if (arrIPQC != undefined) {
        selectedDsNo = arrIPQC.selectedDs.dsNo
        selectedBatch = arrIPQC.selectedDs.batch
      }

      await models.tbl_ds_binding.update({
        MenuName: "NULL",
        PortNo: "NULL",
      }, {
        where: {
          DS_NUMBER: DsNo,
          TAB_IP: TabIp
        }
      })

      const tblRpiRes = await models.tbl_rpi.findOne({
        where: {
          DS_NUMBER: selectedDsNo
        }
      })
      const DsIp = tblRpiRes.DS_IP;

      const cubicalRes = await models.tbl_cubical.findOne({
        where: {
          Sys_DSNumber: selectedDsNo,
        },
      });
      const testType = cubicalRes.Sys_RptType;

      // Leak Test
      if (cubicalRes.Sys_LeakID && cubicalRes.Sys_LeakID != "None") {
        const arrIdsInfo = globalData.arrIdsInfo.find(k => k.DsNo == DsNo && k.TabIp == TabIp)
        if (!arrIdsInfo) {
          globalData.arrIdsInfo.push({
            DsNo,
            TabIp,
            userId,
            cubicalData: cubicalRes,
            isMannual: true,
            IPAddress: cubicalRes.IPAddress
          })
        } else {
          arrIdsInfo.DsNo = DsNo;
          arrIdsInfo.TabIp = TabIp;
          arrIdsInfo.cubicalData = cubicalRes;
          arrIdsInfo.userId = userId;
          arrIdsInfo.isMannual = true;
          arrIdsInfo.IPAddress = cubicalRes.IPAddress
        }

        // Create menu for Leak Test
        let menuObj = {};
        const filteredMenu = [];
        if ((cubicalRes.Sys_LeakID != null || cubicalRes.Sys_LeakID != "None")) {
          menuObj["Leak Test"] = {};
          filteredMenu.push("Leak Test")
        } else {
          console.log("Cubical and MES data conflict");
          return
        }
        console.log('menuObj: ', menuObj);

        let tempArrLimits = globalData.arr_limits.find((k) => k.DsNo == DsNo && k.TabIp == TabIp);
        if (!tempArrLimits) {
          globalData.arr_limits.push({
            DsNo,
            TabIp,
            BatchId: cubicalRes.Sys_Batch,
            Menus: menuObj
          })
        } else {
          tempArrLimits.DsNo = DsNo;
          tempArrLimits.TabIp = TabIp;
          tempArrLimits.BatchId = cubicalRes.Sys_Batch;
          tempArrLimits.Menus = menuObj;
        }

        let tempObjProdType = globalData.arrProductTypeArray.find((k) => k.DsNo == DsNo && TabIp == TabIp);
        if (tempObjProdType == undefined) {
          globalData.arrProductTypeArray.push({
            DsNo,
            TabIp,
            productType: {},
            productDetail: {},
          });
        } else {
          tempObjProdType.DsNo = DsNo;
          tempObjProdType.TabIp = TabIp;
          tempObjProdType.productType = {};
          tempObjProdType.productDetail = {};
        }

        let newMenu = [];
        const tempUserRights = [];
        const userRights = globalData.arrUserRights.find(k => k.DsNo == DsNo && k.TabIp == TabIp).rights;
        for (let i = 0; i < userRights.length; i++) {
          tempUserRights.push(userRights[i].replace("Test", "").trim().toLowerCase())
        }

        for (let i = 0; i < filteredMenu.length; i++) {
          if (tempUserRights.includes(filteredMenu[i].replace("Test", "").trim().toLowerCase())) {
            newMenu.push(filteredMenu[i])
          } else {
            console.log(`User does not have ${filteredMenu[i]} right`)
            resObj = {
              status: "Fail",
              tabIp: TabIp,
              testType,
              message: "User does not have any test rights"
            }
            return mqttSender.sendData(DsNo, `GetMenuRes:${JSON.stringify(resObj)}`)
          }
        }

        const originalDSRes = await models.tbl_cubical.findOne({
          where: {
            Sys_DSNumber: DsNo
          }
        })

        let i = 1;
        var idsmenu = [];
        for (let obj in originalDSRes) {
          if (
            originalDSRes[`Sys_Port${i}`] == undefined ||
            originalDSRes[`Sys_Port${i}`] == "None" ||
            originalDSRes[`Sys_Port${i}`] == "NULL" ||
            originalDSRes[`Sys_Port${i}`] == null
          ) {
            i++;
            continue;
          } else {
            let type = originalDSRes[`Sys_Port${i}`];
            if (originalDSRes[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.Balance) {
              if (newMenu.includes("Individual")) {
                idsmenu.push(`Port ${i} : Individual`);
              }
              if (newMenu.includes("Group")) {
                idsmenu.push(`Port ${i} : Group`);
              }
              if (newMenu.includes("Friability") && configFile.friabilityType == "OB") {
                idsmenu.push(`Port ${i} : Friability`);
              }
            } else if (originalDSRes[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.Hardness) {
              if (newMenu.includes("Hardness")) {
                idsmenu.push(`Port ${i} : Hardness`);
              }
            } else if (originalDSRes[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.MoistureAnalyzer) {
              if (newMenu.includes("Loss on Dry")) {
                idsmenu.push(`Port ${i} : Loss on Dry`);
              }
            }
            else if (originalDSRes[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.Vernier) {
              if (newMenu.includes("Thickness")) {
                idsmenu.push(`Port ${i} : Thickness`);
              }
              if (newMenu.includes("Diameter")) {
                idsmenu.push(`Port ${i} : Diameter`);
              }
              if (newMenu.includes("Length")) {
                idsmenu.push(`Port ${i} : Length`);
              }
            } else if (originalDSRes[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.Friability && configFile.friabilityType == "OF") {
              if (newMenu.includes("Friability")) {
                idsmenu.push(`Port ${i} : Friability`);
              }
            } else if (originalDSRes[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.LeakTester) {
              if (newMenu.includes("Leak Test")) {
                idsmenu.push(`Port ${i} : Leak Test`);
              }
            }

            i++;
          }
        }

        if (newMenu.length > 0) {
          await this.lockedWeighingStatus(
            cubicalRes.Sys_CubicNo,
            cubicalRes.Sys_Batch,
            cubicalRes.Sys_CubType
          );

          resObj = {
            status: "Success",
            tabIp: TabIp,
            testType,
            data: idsmenu
          }
        }

        console.log("Menu has been send through MQTT. ", JSON.stringify(resObj));
        return mqttSender.sendData(DsNo, `GetMenuRes:${JSON.stringify(resObj)}`)
      }

      // For LOD Test
      // if (cubicalRes.Sys_MoistID && cubicalRes.Sys_MoistID != "None") {
      //   const arrIdsInfo = globalData.arrIdsInfo.find(k => k.DsNo == DsNo && k.TabIp == TabIp)
      //   if (!arrIdsInfo) {
      //     globalData.arrIdsInfo.push({
      //       DsNo,
      //       TabIp,
      //       userId,
      //       cubicalData: cubicalRes,
      //       isMannual: true
      //     })
      //   } else {
      //     arrIdsInfo.DsNo = DsNo;
      //     arrIdsInfo.TabIp = TabIp;
      //     arrIdsInfo.cubicalData = cubicalRes;
      //     arrIdsInfo.userId = userId;
      //     arrIdsInfo.isMannual = true
      //   }

      //   // Create menu for Leak Test
      //   let menuObj = {};
      //   const filteredMenu = [];
      //   if ((cubicalRes.Sys_MoistID != null || cubicalRes.Sys_MoistID != "None")) {
      //     menuObj["Loss on Dry"] = {};
      //     filteredMenu.push("Loss on Dry")
      //   } else {
      //     console.log("Cubical and MES data conflict");
      //     return
      //   }
      //   console.log('menuObj: ', menuObj);

      //   let tempArrLimits = globalData.arr_limits.find((k) => k.DsNo == DsNo && k.TabIp == TabIp);
      //   if (!tempArrLimits) {
      //     globalData.arr_limits.push({
      //       DsNo,
      //       TabIp,
      //       BatchId: cubicalRes.Sys_Batch,
      //       Menus: menuObj
      //     })
      //   } else {
      //     tempArrLimits.DsNo = DsNo;
      //     tempArrLimits.TabIp = TabIp;
      //     tempArrLimits.BatchId = cubicalRes.Sys_Batch;
      //     tempArrLimits.Menus = menuObj;
      //   }

      //   let tempObjProdType = globalData.arrProductTypeArray.find((k) => k.DsNo == DsNo && TabIp == TabIp);
      //   if (tempObjProdType == undefined) {
      //     globalData.arrProductTypeArray.push({
      //       DsNo,
      //       TabIp,
      //       productType: {},
      //       productDetail: {},
      //     });
      //   } else {
      //     tempObjProdType.DsNo = DsNo;
      //     tempObjProdType.TabIp = TabIp;
      //     tempObjProdType.productType = {};
      //     tempObjProdType.productDetail = {};
      //   }

      //   let newMenu = [];
      //   const tempUserRights = [];
      //   const userRights = globalData.arrUserRights.find(k => k.DsNo == DsNo && k.TabIp == TabIp).rights;
      //   for (let i = 0; i < userRights.length; i++) {
      //     tempUserRights.push(userRights[i].replace("Test", "").trim().toLowerCase())
      //   }

      //   for (let i = 0; i < filteredMenu.length; i++) {
      //     if (tempUserRights.includes(filteredMenu[i].replace("Test", "").trim().toLowerCase())) newMenu.push(filteredMenu[i])
      //   }

      //   const originalDSRes = await models.tbl_cubical.findOne({
      //     where: {
      //       Sys_DSNumber: DsNo
      //     }
      //   })

      //   let i = 1;
      //   var idsmenu = [];
      //   for (let obj in originalDSRes) {
      //     if (
      //       originalDSRes[`Sys_Port${i}`] == undefined ||
      //       originalDSRes[`Sys_Port${i}`] == "None" ||
      //       originalDSRes[`Sys_Port${i}`] == "NULL" ||
      //       originalDSRes[`Sys_Port${i}`] == null
      //     ) {
      //       i++;
      //       continue;
      //     } else {
      //       let type = originalDSRes[`Sys_Port${i}`];
      //       if (originalDSRes[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.Balance) {
      //         if (newMenu.includes("Individual")) {
      //           idsmenu.push(`Port ${i} : Individual`);
      //         }
      //         if (newMenu.includes("Group")) {
      //           idsmenu.push(`Port ${i} : Group`);
      //         }
      //         if (newMenu.includes("Friability") && configFile.friabilityType == "OB") {
      //           idsmenu.push(`Port ${i} : Friability`);
      //         }
      //       } else if (originalDSRes[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.Hardness) {
      //         if (newMenu.includes("Hardness")) {
      //           idsmenu.push(`Port ${i} : Hardness`);
      //         }
      //       } else if (originalDSRes[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.MoistureAnalyzer) {
      //         if (newMenu.includes("Loss on Dry")) {
      //           idsmenu.push(`Port ${i} : Loss on Dry`);
      //         }
      //       }
      //       else if (originalDSRes[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.Vernier) {
      //         if (newMenu.includes("Thickness")) {
      //           idsmenu.push(`Port ${i} : Thickness`);
      //         }
      //         if (newMenu.includes("Diameter")) {
      //           idsmenu.push(`Port ${i} : Diameter`);
      //         }
      //         if (newMenu.includes("Length")) {
      //           idsmenu.push(`Port ${i} : Length`);
      //         }
      //       } else if (originalDSRes[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.Friability && configFile.friabilityType == "OF") {
      //         if (newMenu.includes("Friability")) {
      //           idsmenu.push(`Port ${i} : Friability`);
      //         }
      //       } else if (originalDSRes[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.LeakTester) {
      //         if (newMenu.includes("Leak Test")) {
      //           idsmenu.push(`Port ${i} : Leak Test`);
      //         }
      //       }

      //       i++;
      //     }
      //   }

      //   if (newMenu.length > 0) {
      //     await this.lockedWeighingStatus(
      //       cubicalRes.Sys_CubicNo,
      //       cubicalRes.Sys_Batch,
      //       cubicalRes.Sys_CubType
      //     );

      //     resObj = {
      //       status: "Success",
      //       tabIp: TabIp,
      //       testType,
      //       data: idsmenu
      //     }
      //   } else {
      //     resObj = {
      //       status: "Fail",
      //       tabIp: TabIp,
      //       testType,
      //       message: "User does not have any test rights"
      //     }
      //   }
      //   globalData.PendingRequest.findIndex((e) => e.DsNo === DsNo && e.TabIp == TabIp) !== -1 ? globalData.PendingRequest.splice(globalData.PendingRequest.findIndex((k) => k.DsNo == DsNo && k.TabIp == TabIp), 1) : globalData.PendingRequest;

      //   console.log("Menu has been send through MQTT. ", JSON.stringify(resObj));
      //   return mqttSender.sendData(DsNo, `GetMenuRes:${JSON.stringify(resObj)}`)
      // }

      // Except Leak and DT Test
      if ((cubicalRes.Sys_MPNCode != "NULL" && cubicalRes.Sys_MPNCode)) {
        const productMasterRes = await models.tbl_product_master.findOne({
          where: {
            MPN_Code: MPN,
          }
        })

        if (!productMasterRes) {
          console.log("Product not set");
          console.log('MQTT Response: ', DsNo, `GetMenuRes:${JSON.stringify(resObj)}`);
          return mqttSender.sendData(DsNo, `GetMenuRes:${JSON.stringify(resObj)}`)
        }

        // if (productMasterRes.isLimitChanged) {
        //   resObj = {
        //     status: "Fail",
        //     tabIp: TabIp,
        //     testType,
        //     message: "Product limits has been changed"
        //   }
        //   console.log("Product limits has been changed");
        //   console.log('MQTT Response: ', DsNo, `GetMenuRes:${JSON.stringify(resObj)}`);
        //   return mqttSender.sendData(DsNo, `GetMenuRes:${JSON.stringify(resObj)}`)
        // }

        let productTable = "tbl_product_tablet"
        if (productMasterRes.ProductType == 2) {
          productTable = "tbl_product_capsule"
        }

        const productDetailsRes = await models[productTable].findOne({
          where: {
            MPN_Code: MPN
          }
        })

        if (!productDetailsRes) {
          console.log(`Product limits not found in ${productTable}`);
          return
        }

        const productSampleRes = await models.tbl_cubicle_product_sample.findOne({
          where: {
            Sys_CubicNo: cubicalRes.Sys_CubicNo,
          }
        });

        const menuAccordingToLimit = await this.makeMannualMenu(cubicalRes, productMasterRes, productDetailsRes, productSampleRes, TabIp, DsNo, selectedDsNo);
        if (Object.keys(menuAccordingToLimit).length == 0) {
          resObj = {
            status: "Fail",
            tabIp: TabIp,
            testType,
            message: "No product limits found"
          }
          console.log("No product limits found to create menu");
          console.log('MQTT Response: ', DsNo, `GetMenuRes:${JSON.stringify(resObj)}`);
          return mqttSender.sendData(DsNo, `GetMenuRes:${JSON.stringify(resObj)}`)
        }
        const filteredMenu = Object.keys(menuAccordingToLimit).filter(key => typeof menuAccordingToLimit[key] === 'object');

        let newMenu = [];
        const tempUserRights = [];
        const userRights = globalData.arrUserRights.find(k => k.DsNo == DsNo && k.TabIp == TabIp).rights;
        for (let i = 0; i < userRights.length; i++) {
          tempUserRights.push(userRights[i].replace("Test", "").trim().toLowerCase())
        }

        for (let i = 0; i < filteredMenu.length; i++) {
          if (tempUserRights.includes(filteredMenu[i].replace("Test", "").trim().toLowerCase())) {
            newMenu.push(filteredMenu[i])
          } else {
            console.log(`User does not have ${filteredMenu[i]} right`)
            resObj = {
              status: "Fail",
              tabIp: TabIp,
              testType,
              message: "User does not have any test rights"
            }
            return mqttSender.sendData(DsNo, `GetMenuRes:${JSON.stringify(resObj)}`)
          }
        }
        console.log('tempUserRights: ', tempUserRights);

        /**************** START Implementation of Initial flow of Menu ****************/
        let initialTestStatus = "";
        if (cubicalRes.Sys_RptType) {
          initialTestStatus = "started"
          newMenu = await this.setInitialMenu(DsNo, newMenu, TabIp, userId, initialTestStatus)
        }
        /**************** END Implementation of Initial flow of Menu ****************/

        // Comment it after Length Test has been added
        // newMenu.push("Length")
        // newMenu.push("LOD")
        // newMenu.push("Leak")
        console.log('newMenu: ', newMenu);

        const originalDSRes = await models.tbl_cubical.findOne({
          where: {
            Sys_DSNumber: DsNo
          }
        })

        let i = 1;
        var idsmenu = [];
        for (let obj in originalDSRes) {
          if (
            originalDSRes[`Sys_Port${i}`] == undefined ||
            originalDSRes[`Sys_Port${i}`] == "None" ||
            originalDSRes[`Sys_Port${i}`] == "NULL" ||
            originalDSRes[`Sys_Port${i}`] == null
          ) {
            i++;
            continue;
          } else {
            let type = originalDSRes[`Sys_Port${i}`];
            if (originalDSRes[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.Balance) {
              if (newMenu.includes("Individual")) {
                idsmenu.push(`Port ${i} : Individual`);
              }
              if (newMenu.includes("Group")) {
                idsmenu.push(`Port ${i} : Group`);
              }
              if (newMenu.includes("Differential")) {
                idsmenu.push(`Port ${i} : Differential`);
              }
              if (newMenu.includes("Friability") && configFile.friabilityType == "OB") {
                idsmenu.push(`Port ${i} : Friability`);
              }
            } else if (originalDSRes[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.Hardness) {
              if (newMenu.includes("Hardness")) {
                idsmenu.push(`Port ${i} : Hardness`);
              }
            } else if (originalDSRes[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.MoistureAnalyzer) {
              if (newMenu.includes("Loss on Dry")) {
                idsmenu.push(`Port ${i} : Loss on Dry`);
              }
            }
            else if (originalDSRes[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.Vernier) {
              if (newMenu.includes("Thickness")) {
                idsmenu.push(`Port ${i} : Thickness`);
              }
              if (newMenu.includes("Diameter")) {
                idsmenu.push(`Port ${i} : Diameter`);
              }
              if (newMenu.includes("Length")) {
                idsmenu.push(`Port ${i} : Length`);
              }
              if (newMenu.includes("Locked Length")) {
                idsmenu.push(`Port ${i} : Locked Length`);
              }
            } else if (originalDSRes[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.Friability && configFile.friabilityType == "OF") {
              if (newMenu.includes("Friability")) {
                idsmenu.push(`Port ${i} : Friability`);
              }
            } else if (originalDSRes[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.LeakTester) {
              if (newMenu.includes("Leak Test")) {
                idsmenu.push(`Port ${i} : Leak Test`);
              }
            }

            i++;
          }
        }

        if (newMenu.length > 0) {
          await this.lockedWeighingStatus(
            cubicalRes.Sys_CubicNo,
            cubicalRes.Sys_Batch,
            cubicalRes.Sys_CubType
          );

          resObj = {
            status: "Success",
            tabIp: TabIp,
            testType,
            data: idsmenu
          }
        } else {
          var message
          if (configFile.plant != 'PUI') {

            if (cubicalRes.Sys_RptType == 0) {

              message = 'Inprocess'
            } else {
              message = 'StartUp'
            }
          } else {
            message = cubicalRes.Sys_Batch_Status;
          }

          if (initialTestStatus == "completed") {
            resObj = {
              status: "Fail",
              tabIp: TabIp,
              testType,
              message: `${message} Test Completed`
            }
          } else {
            resObj = {
              status: "Fail",
              tabIp: TabIp,
              testType,
              message: "User does not have any test rights"
            }
          }
        }

        const arrIdsInfo = globalData.arrIdsInfo.find(k => k.DsNo == DsNo && k.TabIp == TabIp)
        if (!arrIdsInfo) {
          globalData.arrIdsInfo.push({
            DsNo,
            TabIp,
            userId,
            cubicalData: cubicalRes,
            isMannual: false,
            IPAddress: cubicalRes.IPAddress
          })
        } else {
          arrIdsInfo.DsNo = DsNo;
          arrIdsInfo.TabIp = TabIp;
          arrIdsInfo.cubicalData = cubicalRes;
          arrIdsInfo.userId = userId;
          arrIdsInfo.isMannual = false;
          arrIdsInfo.IPAddress = cubicalRes.IPAddress;
        }
        globalData.PendingRequest.findIndex((e) => e.DsNo === DsNo && e.TabIp == TabIp) !== -1 ? globalData.PendingRequest.splice(globalData.PendingRequest.findIndex((k) => k.DsNo == DsNo && k.TabIp == TabIp), 1) : globalData.PendingRequest;

        console.log("Menu has been send through MQTT. ", JSON.stringify(resObj));
        return mqttSender.sendData(DsNo, `GetMenuRes:${JSON.stringify(resObj)}`)
      }


    } catch (error) {
      console.log('error: ', error);
    }
  }

  async sendMenu(values) {
    try {
      const TabIp = values.tabIp;
      const DsNo = values.dsNo;
      let selectedDsNo = values.dsNo;
      let selectedBatch = "";
      const userId = values.userId;
      let resObj = {};
      (globalData.arrcalibType.findIndex((element) => element.DsNo === DsNo && TabIp == TabIp)) == -1 ?
        globalData.arrcalibType : globalData.arrcalibType.splice(globalData.arrcalibType.findIndex((element) => element.DsNo === DsNo && TabIp == TabIp), 1);

      (globalData.arrCurrentOperationStatus.findIndex((element) => element.DsNo === DsNo && TabIp == TabIp)) == -1 ?
        globalData.arrCurrentOperationStatus :
        globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex((element) => element.DsNo === DsNo && TabIp == TabIp), 1);

      let arrIPQC = globalData.arr_IPQCRelIds.find(k => k.DsNo == DsNo && k.tabIp == TabIp);
      if (arrIPQC != undefined) {
        selectedDsNo = arrIPQC.selectedDs.dsNo
        selectedBatch = arrIPQC.selectedDs.batch
      }

      await models.tbl_ds_binding.update({
        MenuName: "NULL",
        PortNo: "NULL",
      }, {
        where: {
          DS_NUMBER: DsNo,
          TAB_IP: TabIp
        }
      })

      const tblRpiRes = await models.tbl_rpi.findOne({
        where: {
          DS_NUMBER: selectedDsNo
        }
      })
      const DsIp = tblRpiRes.DS_IP;

      let cubicalRes = await models.tbl_cubical.findOne({
        where: {
          Sys_DSNumber: selectedDsNo,
        },
      });

      if (!cubicalRes) {
        resObj = {
          status: "Fail",
          tabIp: TabIp,
          testType,
          prestart,
          message: "DS not configured"
        }
        console.log("DS not configured");
        console.log('MQTT Response: ', DsNo, `GetMenuRes:${JSON.stringify(resObj)}`);
        return mqttSender.sendData(DsNo, `GetMenuRes:${JSON.stringify(resObj)}`)
      }
      const testType = cubicalRes.Sys_RptType;
      var prestart = cubicalRes.isPreStart;

      const menuSequence = await models.tbl_menu_sequence.findOne({
        where: {
          DS_Number: DsNo,
        }
      });

      let keysToRemove = ['DS_Number', 'UserId', 'RecNo', 'RepSerNo', 'TabIp'];
      if (menuSequence) {
        let newMenuSeqObj = Object.keys(menuSequence).reduce((acc, key) => {
          if (!keysToRemove.includes(key)) {
            acc[key] = menuSequence[key];
          }
          return acc;
        }, {})

        console.log(`newMenuSeqObj: ${newMenuSeqObj}`);
        let testStatusArr = Object.values(newMenuSeqObj).map(e => e === '0' ? 0 : e);
        if (!testStatusArr.includes(0) && menuSequence.RepSerNo != 0) {
          await models.tbl_menu_sequence.destroy({ where: { DS_Number: DsNo, TabIp: TabIp } })
          await models.tbl_mes_data.destroy({ where: { DS_Number: DsNo, isSetInCubical: 1, isTestCompleted: 1 } })
          globalData.MESArray.splice(globalData.MESArray.findIndex(k => k.isPosted == false && k.isCompleted == true && k.DsNo == DsNo), 1)
          console.log(globalData.MESArray)

          resObj = {
            status: "Fail",
            tabIp: TabIp,
            testType,
            prestart,
            isMannual: cubicalRes.isManual,
            message: configFile.plant == 'PUI' ? `${cubicalRes.Sys_Batch_Status} Test Completed for ${cubicalRes.Sys_RotaryType}` : (cubicalRes.Sys_RptType == 1) ? "Startup Test Completed" : "InProcess Test Completed"
          }

          console.log("Delete Menu Sequence Entry All Test are Completed in sendMenu");
          return mqttSender.sendData(DsNo, `GetMenuRes:${JSON.stringify(resObj)}`)
        }
      }

      let mesArrRes = await models.tbl_mes_data.findAll({
        where: {
          DS_Number: cubicalRes.Sys_DSNumber,
          isSetInCubical: 1,
          // isTestCompleted: 0
        },
      });



      let mesRes = null;
      if (mesArrRes.length > 0) {


        mesRes = mesArrRes[0]

        let finddataMpn = await objCommonWeightment.checkProductAccordingArea(mesRes.MPN, cubicalRes.Sys_Area);
        if (finddataMpn.length == 0) {
          resObj = {
            status: "Fail",
            tabIp: TabIp,
            testType,
            prestart,
            message: 'Invalid MPR Number'
          }
          return mqttSender.sendData(cubicalRes.Sys_DSNumber, `GetMenuRes:${JSON.stringify(resObj)}`)
        }


        if(cubicalRes.Sys_ProductName != finddataMpn[0].ProductName || cubicalRes.Sys_BFGCode != finddataMpn[0].ProductId){
          objCommonWeightment.updateCubical1(mesRes,cubicalRes,{Sys_ProductName: finddataMpn[0].ProductName,
            Sys_BFGCode :finddataMpn[0].ProductId
           })
        }


        if (mesRes.BatchID != cubicalRes.Sys_Batch && mesRes.TestType != cubicalRes.Sys_RptType && mesRes.Repetition != cubicalRes.Sys_Repetition) {
          resObj = {
            status: "Fail",
            tabIp: TabIp,
            testType,
            prestart,
            message: `Please Set the Batch ${mesRes.BatchID}  in Area Setting`
          }
          console.log(`Please Set the Batch ${mesRes.BatchID}  in Area Setting`);
          console.log('MQTT Response: ', DsNo, `GetMenuRes:${JSON.stringify(resObj)}`);
          return mqttSender.sendData(DsNo, `GetMenuRes:${JSON.stringify(resObj)}`)
        }
         let isPreStartup = false;
         let isInProcess = true;
        //  isPreStartup = (cubicalRes.MesTestType.toLowerCase().includes("pre") && cubicalRes.Sys_Batch_Status.toLowerCase.includes("pre") && cubicalRes.isPreStart == 1) ? true : isPreStartup
         isPreStartup = (cubicalRes.Sys_Area == "Compression" && (configFile.plant == "PUI" && cubicalRes.Sys_Batch_Status != mesRes.MesTestType ) && !mesRes.MesTestType.toLowerCase().includes('hrs')) ? true : isPreStartup;
         isInProcess = (configFile.plant == 'PUI' && cubicalRes.Sys_Area == "Compression" &&(  ( (mesRes.MesTestType.toLowerCase().includes('2 hrs') || mesRes.MesTestType.toLowerCase().includes('4 hrs')) && ((cubicalRes.MesTestType.toLowerCase().includes('pd') || (cubicalRes.Sys_Batch_Status.toLowerCase().includes('pd'))) && !(cubicalRes.Sys_Batch_Status.toLowerCase().includes('qa')))) || ((mesRes.MesTestType.toLowerCase().includes('8 hrs')) && (cubicalRes.MesTestType.toLowerCase().includes('qa') || cubicalRes.Sys_Batch_Status.toLowerCase().includes('qa')) && !(cubicalRes.Sys_Batch_Status.toLowerCase().includes('pd'))))) ? false : isInProcess; //  if it is false then we have the right data
        if (cubicalRes.Sys_Area == "Compression" && ((mesRes.BatchID == cubicalRes.Sys_Batch && mesRes.TestType != cubicalRes.Sys_RptType) || (configFile.plant == "PUI" && (!(cubicalRes.MesTestType.toLowerCase().includes('hrs')) ? (mesRes.MesTestType != cubicalRes.MesTestType && isInProcess) : isInProcess)) || (isPreStartup))) {
          let mode;
          mesRes.MesTestType = (configFile.plant == 'PUI'&& (mesRes.MesTestType.toLowerCase().includes('2 hrs') || mesRes.MesTestType.toLowerCase().includes('4 hrs'))) ? "PD Inprocess" : (configFile.plant == 'PUI'&& (mesRes.MesTestType.toLowerCase().includes('8 hrs'))) ? "QA Inprocess" : mesRes.MesTestType ;
          mode = configFile.plant == 'PUI' ? mesRes.MesTestType : mesRes.TestType == 0 ? 'Inprocess' : 'Startup';


          resObj = {
            status: "Fail",
            tabIp: TabIp,
            testType,
            prestart,
            // mode : mesPendingRequest[0].TestType == 0 ? 'Inprocess' : 'Startup',
            message: `Please set the Mode  ${mode} in Area Setting`
          }
          console.log(`Please set the Mode  ${mode} in Area Setting`);
          console.log('MQTT Response: ', DsNo, `GetMenuRes:${JSON.stringify(resObj)}`);
          return mqttSender.sendData(DsNo, `GetMenuRes:${JSON.stringify(resObj)}`)
        }

      } else {
        let mesPendingRequest = await models.tbl_mes_data.findAll({
          where: {
            isSetInCubical: 0,
            // DS_Number: cubicalRes.Sys_DSNumber,
            CubicleArea: cubicalRes.Sys_Area,
            [Op.or]: [
              { DS_Number: cubicalRes.Sys_DSNumber },
              { BatchID: cubicalRes.Sys_Batch }
            ],
          }
        })


        if (mesPendingRequest.length > 0) {
          let finddataMpn = await objCommonWeightment.checkProductAccordingArea(mesPendingRequest[0]?.MPN, cubicalRes.Sys_Area);
          if (finddataMpn.length == 0) {
            resObj = {
              status: "Fail",
              tabIp: TabIp,
              testType,
              prestart,
              message: 'Invalid MPR Number'
            }
            return mqttSender.sendData(cubicalRes.Sys_DSNumber, `GetMenuRes:${JSON.stringify(resObj)}`)
          }

          if (mesPendingRequest[0].BatchID == cubicalRes.Sys_Batch) {
            let isSameModeIsPresentInCubical = false;
            if (mesPendingRequest[0].LTID != 'NA') {
              if (mesPendingRequest[0].TestType == cubicalRes.Sys_RptType && (mesPendingRequest[0].MesTestType == cubicalRes.MesTestType || mesPendingRequest[0].MesTestType == cubicalRes.Sys_Batch_Status)) {
                isSameModeIsPresentInCubical = true
              }
            } else {
              if (mesPendingRequest[0].TestType == cubicalRes.Sys_RptType) { isSameModeIsPresentInCubical = true }
            }

            if (isSameModeIsPresentInCubical) {
              let data = await objCommonWeightment.saveMESBatchinCubical(cubicalRes, mesPendingRequest[0]);
              if (data.status == 'fail') {
                resObj = {
                  status: "Fail",
                  tabIp: TabIp,
                  testType,
                  prestart,
                  message: data.message
                }
                console.log(data.message);
                console.log('MQTT Response: ', DsNo, `GetMenuRes:${JSON.stringify(resObj)}`);
                return mqttSender.sendData(DsNo, `GetMenuRes:${JSON.stringify(resObj)}`)
              }
              await this.sendMenu(values);
            }
            else {
              let mode;
              if (mesPendingRequest[0].LTID != "NA") {
                mode = mesPendingRequest[0].MesTestType
              } else {
                if (configFile.plant == 'PUI') {
                  mode = mesPendingRequest[0].MesTestType
                } else {
                  mode = mesPendingRequest[0].TestType == 0 ? 'Inprocess' : 'Startup';
                }
              }

              resObj = {
                status: "Fail",
                tabIp: TabIp,
                testType,
                prestart,
                // mode : mesPendingRequest[0].TestType == 0 ? 'Inprocess' : 'Startup',
                message: `Please set the Mode  ${mode} in Area Setting`
              }
              console.log(`Please set the Mode  ${mode} in Area Setting`);
              console.log('MQTT Response: ', DsNo, `GetMenuRes:${JSON.stringify(resObj)}`);
              return mqttSender.sendData(DsNo, `GetMenuRes:${JSON.stringify(resObj)}`)
            }
          } else {
            resObj = {
              status: "Fail",
              tabIp: TabIp,
              testType,
              prestart,
              message: `Please set the Batch  ${mesPendingRequest[0].BatchID} in Area Setting`
            }
            console.log(`Please set the Batch  ${mesPendingRequest[0].BatchID} in Area Setting`);
            console.log('MQTT Response: ', DsNo, `GetMenuRes:${JSON.stringify(resObj)}`);
            return mqttSender.sendData(DsNo, `GetMenuRes:${JSON.stringify(resObj)}`)
          }
        } else {
          let isBatchNull = await objCommonOperation.isNullOrStringNull(cubicalRes.Sys_Batch);
          if (isBatchNull) {
            resObj = {
              status: "Fail",
              tabIp: TabIp,
              testType,
              prestart,
              message: "Please Set the Batch In Area Setting"
            }
            console.log("Please Set the Batch In Area Setting");
            console.log('MQTT Response: ', DsNo, `GetMenuRes:${JSON.stringify(resObj)}`);
            return mqttSender.sendData(DsNo, `GetMenuRes:${JSON.stringify(resObj)}`)
          }

          const checkPendingRequest = globalData.PendingRequest.find(k => k.DsNo == DsNo && k.TabIp == TabIp);
          if (!checkPendingRequest) {
            globalData.PendingRequest.push({
              DsNo,
              DsIp,
              TabIp,
              userId,
            })
          } else {
            checkPendingRequest.userId = userId
          }
          console.log(`Waiting for MES Data, TAB_IP:${TabIp}, DS_IP:${DsIp}`);
          return
        }
      }

      // Check instrument received from MES is available in cubicle
      console.log('mesRes: ', mesRes);
      console.log('cubicalRes: ', cubicalRes);
      console.log('menuSequence: ', menuSequence);

      let instrumentFound = true;
      let Instrument = ''
      // Check for Balance
      if ((mesRes.AWBID != "NA" && mesRes.AWBID != 'None') && (mesRes.AWBID != cubicalRes.Sys_BalID)) {
        cubicalRes.Sys_BalID = 'NA'
        console.log("Balance is not set in cubicle");
        instrumentFound = false;
        Instrument = `Balance: ${mesRes.AWBID}`
      }

      // Check for DT
      if ((mesRes.DTID != "NA" && mesRes.DTID != 'None') && (mesRes.DTID != cubicalRes.Sys_DTID)) {
        cubicalRes.Sys_DTID = 'NA';
        console.log("DT is not set in cubicle");
        instrumentFound = false;
        Instrument = `Disintigration Tester: ${mesRes.DTID}`
      }
      // Check for Friability
      if ((mesRes.FTID != "None" && mesRes.FTID != 'NA') && (mesRes.FTID != cubicalRes.Sys_FriabID)) {
        console.log("Friability is not set in cubicle");
        instrumentFound = false;
        Instrument = `Friabilator: ${mesRes.FTID}`
      }
      // Check for Hardness
      if ((mesRes.HTID != "NA" && mesRes.HTID != 'None') && (mesRes.HTID != cubicalRes.Sys_HardID)) {
        cubicalRes.Sys_HardID = 'NA';
        console.log("Hardness is not set in cubicle");
        instrumentFound = false;
        Instrument = `Hardness: ${mesRes.HTID}`
      }
      // Check for Leak Tester
      if ((mesRes.LTID != "NA" && mesRes.LTID != 'None') && (mesRes.LTID != cubicalRes.Sys_LeakID)) {
        cubicalRes.Sys_LeakID = 'NA';
        console.log("Leak Tester is not set in cubicle");
        instrumentFound = false;
        Instrument = `Leak Tester: ${mesRes.LTID}`
      }
      // Check for Mositure Analyzer
      if ((mesRes.MAID != "NA" && mesRes.MAID != 'None') && (mesRes.MAID != cubicalRes.Sys_MoistID)) {
        cubicalRes.Sys_MoistID = 'NA';
        console.log("Mositure Analyzer is not set in cubicle");
        instrumentFound = false;
        Instrument = `Mositure Analyzer: ${mesRes.MAID}`
      }
      // Check for Vernier
      if ((mesRes.VerId != "NA" && mesRes.VerId != 'None') && (mesRes.VerId != cubicalRes.Sys_VernierID)) {
        cubicalRes.Sys_VernierID = 'NA';
        console.log("Vernier is not set in cubicle");
        instrumentFound = false;
        Instrument = `Vernier: ${mesRes.VerId}`
      }

      if (!instrumentFound) {
        resObj = {
          status: "Fail",
          tabIp: TabIp,
          testType,
          message: `Instrument ${Instrument} received from MES is not set in cubicle`
        }
        console.log(`Instrument ${Instrument} received from MES is not set in cubicle`);
        console.log('MQTT Response: ', DsNo, `GetMenuRes:${JSON.stringify(resObj)}`);
        return mqttSender.sendData(DsNo, `GetMenuRes:${JSON.stringify(resObj)}`)
      }

      cubicalRes.Sys_BalID = (mesRes?.AWBID && mesRes?.AWBID != 'NA') ? mesRes?.AWBID : 'None';
      cubicalRes.Sys_DTID = (mesRes?.DTID && mesRes?.DTID != 'NA') ? mesRes?.DTID : 'None';
      cubicalRes.Sys_HardID = (mesRes?.HTID && mesRes?.HTID != 'NA') ? mesRes?.HTID : 'None';
      cubicalRes.Sys_LeakID = (mesRes?.LTID && mesRes?.LTID != 'NA') ? mesRes?.LTID : 'None';
      cubicalRes.Sys_MoistID = (mesRes?.MAID && mesRes?.MAID != 'NA') ? mesRes?.MAID : 'None';
      cubicalRes.Sys_VernierID = (mesRes?.VerId && mesRes?.VerId != 'NA') ? mesRes?.VerId : 'None';
      cubicalRes.Sys_FriabID = (mesRes?.FTID && mesRes?.FTID != 'NA') ? mesRes?.FTID : 'None';

      objCommonWeightment.updateCubical1(mesRes, cubicalRes, { isManual: mesRes.isManual })
      // For Leak Test
      if (cubicalRes.Sys_LeakID && cubicalRes.Sys_LeakID != "None" && mesRes && (cubicalRes.Sys_LeakID == mesRes.LTID)) {
        const arrIdsInfo = globalData.arrIdsInfo.find(k => k.DsNo == DsNo && k.TabIp == TabIp)
        if (!arrIdsInfo) {
          globalData.arrIdsInfo.push({
            DsNo,
            TabIp,
            userId,
            cubicalData: cubicalRes,
            isMannual: false,
            IPAddress: cubicalRes.IPAddress
          })
        } else {
          arrIdsInfo.DsNo = DsNo;
          arrIdsInfo.TabIp = TabIp;
          arrIdsInfo.cubicalData = cubicalRes;
          arrIdsInfo.userId = userId;
          arrIdsInfo.isMannual = false;
          arrIdsInfo.IPAddress = cubicalRes.IPAddress
        }

        // Create menu for Leak Test
        let menuObj = {};
        const filteredMenu = [];
        if ((cubicalRes.Sys_LeakID != null || cubicalRes.Sys_LeakID != "None") && (cubicalRes.Sys_LeakID == mesRes.LTID)) {
          menuObj["Leak Test"] = {};
          filteredMenu.push("Leak Test")
        } else {
          console.log("Cubical and MES data conflict");
          return
        }
        console.log('menuObj: ', menuObj);

        let tempArrLimits = globalData.arr_limits.find((k) => k.DsNo == DsNo && k.TabIp == TabIp);
        if (!tempArrLimits) {
          globalData.arr_limits.push({
            DsNo,
            TabIp,
            BatchId: cubicalRes.Sys_Batch,
            Menus: menuObj
          })
        } else {
          tempArrLimits.DsNo = DsNo;
          tempArrLimits.TabIp = TabIp;
          tempArrLimits.BatchId = cubicalRes.Sys_Batch;
          tempArrLimits.Menus = menuObj;
        }

        let tempObjProdType = globalData.arrProductTypeArray.find((k) => k.DsNo == DsNo && TabIp == TabIp);
        if (tempObjProdType == undefined) {
          globalData.arrProductTypeArray.push({
            DsNo,
            TabIp,
            productType: {},
            productDetail: {},
          });
        } else {
          tempObjProdType.DsNo = DsNo;
          tempObjProdType.TabIp = TabIp;
          tempObjProdType.productType = {};
          tempObjProdType.productDetail = {};
        }

        let newMenu = [];
        const tempUserRights = [];
        const userRights = globalData.arrUserRights.find(k => k.DsNo == DsNo && k.TabIp == TabIp).rights;
        for (let i = 0; i < userRights.length; i++) {
          tempUserRights.push(userRights[i].replace("Test", "").trim().toLowerCase())
        }

        for (let i = 0; i < filteredMenu.length; i++) {
          if (tempUserRights.includes(filteredMenu[i].replace("Test", "").trim().toLowerCase())) {
            newMenu.push(filteredMenu[i])
          } else {
            console.log(`User does not have ${filteredMenu[i]} right`)
            resObj = {
              status: "Fail",
              tabIp: TabIp,
              testType,
              prestart,
              message: "User does not have any test rights"
            }
            return mqttSender.sendData(DsNo, `GetMenuRes:${JSON.stringify(resObj)}`)
          }
        }

        const originalDSRes = await models.tbl_cubical.findOne({
          where: {
            Sys_DSNumber: DsNo
          }
        })

        let i = 1;
        var idsmenu = [];
        for (let obj in originalDSRes) {
          if (
            originalDSRes[`Sys_Port${i}`] == undefined ||
            originalDSRes[`Sys_Port${i}`] == "None" ||
            originalDSRes[`Sys_Port${i}`] == "NULL" ||
            originalDSRes[`Sys_Port${i}`] == null
          ) {
            i++;
            continue;
          } else {
            let type = originalDSRes[`Sys_Port${i}`];
            if (originalDSRes[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.Balance) {
              if (newMenu.includes("Individual")) {
                idsmenu.push(`Port ${i} : Individual`);
              }
              if (newMenu.includes("Group")) {
                idsmenu.push(`Port ${i} : Group`);
              }
              if (newMenu.includes("Friability") && configFile.friabilityType == "OB") {
                idsmenu.push(`Port ${i} : Friability`);
              }
            } else if (originalDSRes[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.Hardness) {
              if (newMenu.includes("Hardness")) {
                idsmenu.push(`Port ${i} : Hardness`);
              }
            } else if (originalDSRes[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.MoistureAnalyzer) {
              if (newMenu.includes("Loss on Dry") || newMenu.includes("Loss on Drying")) {
                idsmenu.push(`Port ${i} : Loss on Dry`);
              }
            }
            else if (originalDSRes[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.Vernier) {
              if (newMenu.includes("Thickness")) {
                idsmenu.push(`Port ${i} : Thickness`);
              }
              if (newMenu.includes("Diameter")) {
                idsmenu.push(`Port ${i} : Diameter`);
              }
              if (newMenu.includes("Length")) {
                idsmenu.push(`Port ${i} : Length`);
              }
            } else if (originalDSRes[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.Friability && configFile.friabilityType == "OF") {
              if (newMenu.includes("Friability")) {
                idsmenu.push(`Port ${i} : Friability`);
              }
            } else if (originalDSRes[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.LeakTester) {
              if (newMenu.includes("Leak Test")) {
                idsmenu.push(`Port ${i} : Leak Test`);
              }
            }

            i++;
          }
        }

        if (newMenu.length > 0) {
          await this.lockedWeighingStatus(
            cubicalRes.Sys_CubicNo,
            cubicalRes.Sys_Batch,
            cubicalRes.Sys_CubType
          );

          resObj = {
            status: "Success",
            tabIp: TabIp,
            testType,
            prestart,
            isMannual: cubicalRes.isManual,
            data: idsmenu
          }
        } else {
          resObj = {
            status: "Fail",
            tabIp: TabIp,
            testType,
            prestart,
            isMannual: cubicalRes.isManual,
            message: "User does not have any test rights"
          }
        }
        globalData.PendingRequest.findIndex((e) => e.DsNo === DsNo && e.TabIp == TabIp) !== -1 ? globalData.PendingRequest.splice(globalData.PendingRequest.findIndex((k) => k.DsNo == DsNo && k.TabIp == TabIp), 1) : globalData.PendingRequest;

        console.log("Menu has been send through MQTT. ", JSON.stringify(resObj));
        return mqttSender.sendData(DsNo, `GetMenuRes:${JSON.stringify(resObj)}`)
      }

      // For LOD Test
      if (cubicalRes.Sys_MoistID && cubicalRes.Sys_MoistID != "None" && mesRes && (cubicalRes.Sys_MoistID == mesRes.MAID)) {
        const arrIdsInfo = globalData.arrIdsInfo.find(k => k.DsNo == DsNo && k.TabIp == TabIp)
        if (!arrIdsInfo) {
          globalData.arrIdsInfo.push({
            DsNo,
            TabIp,
            userId,
            cubicalData: cubicalRes,
            isMannual: false,
            IPAddress: cubicalRes.IPAddress


          })
        } else {
          arrIdsInfo.DsNo = DsNo;
          arrIdsInfo.TabIp = TabIp;
          arrIdsInfo.cubicalData = cubicalRes;
          arrIdsInfo.userId = userId;
          arrIdsInfo.isMannual = false;
          arrIdsInfo.IPAddress = cubicalRes.IPAddress
        }



        const productMasterRes = await models.tbl_product_master.findOne({
          where: {
            MPN_Code: mesRes.MPN,
          }
        })

        if (!productMasterRes) {
          console.log("Product not set");
          console.log('MQTT Response: ', DsNo, `GetMenuRes:${JSON.stringify(resObj)}`);
          return mqttSender.sendData(DsNo, `GetMenuRes:${JSON.stringify(resObj)}`)
        }

        if (productMasterRes.isLimitChanged) {
          resObj = {
            status: "Fail",
            tabIp: TabIp,
            testType,
            prestart,
            isMannual: cubicalRes.isManual,
            message: "Product limits has been changed"
          }
          console.log("Product limits has been changed");
          console.log('MQTT Response: ', DsNo, `GetMenuRes:${JSON.stringify(resObj)}`);
          return mqttSender.sendData(DsNo, `GetMenuRes:${JSON.stringify(resObj)}`)
        }

        // Create menu for LOAD Test
        let menuObj = {};
        const filteredMenu = [];
        if ((cubicalRes.Sys_MoistID != null || cubicalRes.Sys_MoistID != "None") && (cubicalRes.Sys_MoistID == mesRes.MAID)) {
          menuObj["Loss on Dry"] = { T2Neg: mesArrRes[0].LODHigh };
          // filteredMenu.push("Loss on Dry")
          filteredMenu.push("Loss on Drying")
        } else {
          console.log("Cubical and MES data conflict");
          return
        }
        console.log('menuObj: ', menuObj);

        let tempArrLimits = globalData.arr_limits.find((k) => k.DsNo == DsNo && k.TabIp == TabIp);
        if (!tempArrLimits) {
          globalData.arr_limits.push({
            DsNo,
            TabIp,
            BatchId: cubicalRes.Sys_Batch,
            Menus: menuObj
          })
        } else {
          tempArrLimits.DsNo = DsNo;
          tempArrLimits.TabIp = TabIp;
          tempArrLimits.BatchId = cubicalRes.Sys_Batch;
          tempArrLimits.Menus = menuObj;
        }

        let tempObjProdType = globalData.arrProductTypeArray.find((k) => k.DsNo == DsNo && TabIp == TabIp);
        if (tempObjProdType == undefined) {
          globalData.arrProductTypeArray.push({
            DsNo,
            TabIp,
            productType: {},
            productDetail: {},
          });
        } else {
          tempObjProdType.DsNo = DsNo;
          tempObjProdType.TabIp = TabIp;
          tempObjProdType.productType = {};
          tempObjProdType.productDetail = {};
        }

        let newMenu = [];
        const tempUserRights = [];
        const userRights = globalData.arrUserRights.find(k => k.DsNo == DsNo && k.TabIp == TabIp).rights;
        for (let i = 0; i < userRights.length; i++) {
          tempUserRights.push(userRights[i].replace("Test", "").trim().toLowerCase())
        }

        for (let i = 0; i < filteredMenu.length; i++) {
          if (tempUserRights.includes(filteredMenu[i].replace("Test", "").trim().toLowerCase())) {
            newMenu.push(filteredMenu[i])
          } else {
            console.log(`User does not have ${filteredMenu[i]} right`)
            resObj = {
              status: "Fail",
              tabIp: TabIp,
              testType,
              prestart,
              message: "User does not have any test rights"
            }
            return mqttSender.sendData(DsNo, `GetMenuRes:${JSON.stringify(resObj)}`)
          }
        }

        const originalDSRes = await models.tbl_cubical.findOne({
          where: {
            Sys_DSNumber: DsNo
          }
        })

        let i = 1;
        var idsmenu = [];
        for (let obj in originalDSRes) {
          if (
            originalDSRes[`Sys_Port${i}`] == undefined ||
            originalDSRes[`Sys_Port${i}`] == "None" ||
            originalDSRes[`Sys_Port${i}`] == "NULL" ||
            originalDSRes[`Sys_Port${i}`] == null
          ) {
            i++;
            continue;
          } else {
            let type = originalDSRes[`Sys_Port${i}`];
            if (originalDSRes[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.Balance) {
              if (newMenu.includes("Individual")) {
                idsmenu.push(`Port ${i} : Individual`);
              }
              if (newMenu.includes("Group")) {
                idsmenu.push(`Port ${i} : Group`);
              }
              if (newMenu.includes("Friability") && configFile.friabilityType == "OB") {
                idsmenu.push(`Port ${i} : Friability`);
              }
            } else if (originalDSRes[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.Hardness) {
              if (newMenu.includes("Hardness")) {
                idsmenu.push(`Port ${i} : Hardness`);
              }
            } else if (originalDSRes[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.MoistureAnalyzer) {
              if (newMenu.includes("Loss on Dry") || newMenu.includes("Loss on Drying")) {
                idsmenu.push(`Port ${i} : Loss on Dry`);
              }
            }
            else if (originalDSRes[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.Vernier) {
              if (newMenu.includes("Thickness")) {
                idsmenu.push(`Port ${i} : Thickness`);
              }
              if (newMenu.includes("Diameter")) {
                idsmenu.push(`Port ${i} : Diameter`);
              }
              if (newMenu.includes("Length")) {
                idsmenu.push(`Port ${i} : Length`);
              }
            } else if (originalDSRes[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.Friability && configFile.friabilityType == "OF") {
              if (newMenu.includes("Friability")) {
                idsmenu.push(`Port ${i} : Friability`);
              }
            } else if (originalDSRes[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.LeakTester) {
              if (newMenu.includes("Leak Test")) {
                idsmenu.push(`Port ${i} : Leak Test`);
              }
            }

            i++;
          }
        }

        if (newMenu.length > 0) {
          await this.lockedWeighingStatus(
            cubicalRes.Sys_CubicNo,
            cubicalRes.Sys_Batch,
            cubicalRes.Sys_CubType
          );

          resObj = {
            status: "Success",
            tabIp: TabIp,
            testType,
            prestart,
            isMannual: cubicalRes.isManual,
            data: idsmenu
          }
        } else {
          resObj = {
            status: "Fail",
            tabIp: TabIp,
            testType,
            prestart,
            isMannual: cubicalRes.isManual,
            message: "User does not have any test rights"
          }
        }
        globalData.PendingRequest.findIndex((e) => e.DsNo === DsNo && e.TabIp == TabIp) !== -1 ? globalData.PendingRequest.splice(globalData.PendingRequest.findIndex((k) => k.DsNo == DsNo && k.TabIp == TabIp), 1) : globalData.PendingRequest;

        console.log("Menu has been send through MQTT. ", JSON.stringify(resObj));
        return mqttSender.sendData(DsNo, `GetMenuRes:${JSON.stringify(resObj)}`)
      }

      // Except Leak and DT Test
      if ((cubicalRes.Sys_MPNCode != "NULL" && cubicalRes.Sys_MPNCode) && mesRes) {
        const productMasterRes = await models.tbl_product_master.findOne({
          where: {
            MPN_Code: mesRes.MPN,
          }
        })

        if (!productMasterRes) {
          console.log("Product not set");
          console.log('MQTT Response: ', DsNo, `GetMenuRes:${JSON.stringify(resObj)}`);
          return mqttSender.sendData(DsNo, `GetMenuRes:${JSON.stringify(resObj)}`)
        }

        if (productMasterRes.isLimitChanged) {
          resObj = {
            status: "Fail",
            tabIp: TabIp,
            testType,
            prestart,
            isMannual: cubicalRes.isManual,
            message: "Product limits has been changed"
          }
          console.log("Product limits has been changed");
          console.log('MQTT Response: ', DsNo, `GetMenuRes:${JSON.stringify(resObj)}`);
          return mqttSender.sendData(DsNo, `GetMenuRes:${JSON.stringify(resObj)}`)
        }

        let productTable = "tbl_product_tablet"
        if (productMasterRes.ProductType == 2) {
          productTable = "tbl_product_capsule"
        }

        const productDetailsRes = await models[productTable].findOne({
          where: {
            MPN_Code: mesRes.MPN
          }
        })

        if (!productDetailsRes) {
          console.log(`Product limits not found in ${productTable}`);

          resObj = {
            status: "Fail",
            tabIp: TabIp,
            testType,
            prestart,
            isMannual: cubicalRes.isManual,
            message: "Product limits not found"
          }
          console.log("Product limits not found");
          console.log('MQTT Response: ', DsNo, `GetMenuRes:${JSON.stringify(resObj)}`);
          return mqttSender.sendData(DsNo, `GetMenuRes:${JSON.stringify(resObj)}`)
        }

        const productSampleRes = await models.tbl_cubicle_product_sample.findOne({
          where: {
            Sys_CubicNo: cubicalRes.Sys_CubicNo,
          }
        });

        if ((cubicalRes?.isManual != 1 && cubicalRes?.Sys_Area == 'Compression') && configFile.plant != 'PUI') {
          let machineSamples = await models.tbl_machine.findOne({
            attributes: ['Machine_Sample'],
            where: {
              Machine_ID: cubicalRes.Sys_MachineCode
            }
          })
          console.log(machineSamples)
          let rotaryChange = false
          let msg
          if (((machineSamples?.Machine_Rotary == 'Single' || machineSamples?.Machine_Rotary == 'NA') && mesRes.Side != 'NA')) {
            rotaryChange = true;
            msg = 'Please Set Double Rotary'
          } else if (((machineSamples?.Machine_Rotary == 'Double') && mesRes.Side == 'NA')) {
            rotaryChange = true;
            msg = 'Please Set Single Rotary'
          }

          if (machineSamples?.Machine_Sample < mesRes.GroupSampleCount || rotaryChange) {

            if (!rotaryChange) {
              msg = 'Sample numbers mismatched'
            }
            await models.tbl_cubical.update({
              ToggleSample: 1
            },
              {
                where: {
                  Sys_DSNumber: cubicalRes.Sys_DSNumber
                }
              }
            )

            resObj = {
              status: "Fail",
              tabIp: TabIp,
              testType,
              prestart,
              isMannual: cubicalRes.isManual,
              message: msg
            }
            return mqttSender.sendData(DsNo, `GetMenuRes:${JSON.stringify(resObj)}`)
          }
        }


        const menuAccordingToLimit = await this.makeMenu(cubicalRes, mesRes, productMasterRes, productDetailsRes, productSampleRes, TabIp, DsNo, selectedDsNo);
        if (Object.keys(menuAccordingToLimit).length == 0) {
          // Product or Instrumnet both can be absent
          resObj = {
            status: "Fail",
            tabIp: TabIp,
            testType,
            prestart,
            isMannual: cubicalRes.isManual,
            message: "No product limits found"
          }
          console.log("No product limits found to create menu");
          console.log('MQTT Response: ', DsNo, `GetMenuRes:${JSON.stringify(resObj)}`);
          return mqttSender.sendData(DsNo, `GetMenuRes:${JSON.stringify(resObj)}`)
        }
        var filteredMenu = Object.keys(menuAccordingToLimit).filter(key => typeof menuAccordingToLimit[key] === 'object');
        const hardnessInstrumentRes = await models.tbl_otherequipment.findOne({
          where: {
            Eqp_ID: cubicalRes.Sys_HardID
          }
        })
        // if (hardnessInstrumentRes?.Eqp_Make == 'Pharmatest' && mesRes.HTID != 'NA' && cubicalRes.Sys_RptType == 0) {
        if (hardnessInstrumentRes?.Eqp_Make == 'Pharmatest' && mesRes.HTID != 'NA' && cubicalRes.Sys_RptType != 1) {
          filteredMenu = filteredMenu.filter(item => item !== 'Individual');
        }
        let newMenu = [];
        const tempUserRights = [];
        var userRights = globalData.arrUserRights.find(k => k.DsNo == DsNo && k.TabIp == TabIp)?.rights;
        for (let i = 0; i < userRights.length; i++) {
          if (userRights[i].toLowerCase().includes("hardness")) {
            userRights[i] = "Hardness Test"
          }
          tempUserRights.push(userRights[i].replace("Test", "").trim().toLowerCase())
        }

        let checkUserRight = [];
        for (let i = 0; i < filteredMenu.length; i++) {
          if (tempUserRights.includes(filteredMenu[i].replace("Test", "").trim().toLowerCase())) {
            // let obj = {};
            // obj[filteredMenu[i]] = 
            newMenu.push(filteredMenu[i])
          } else {
            console.log(`User does not have ${filteredMenu[i]} right`)
            resObj = {
              status: "Fail",
              tabIp: TabIp,
              testType,
              prestart,
              message: "User does not have any test rights"
            }
            return mqttSender.sendData(DsNo, `GetMenuRes:${JSON.stringify(resObj)}`)
          }
        }

        // if(newMenu.length != filteredMenu.length) {
        //   resObj = {
        //     status: "Fail",
        //     tabIp: TabIp,
        //     testType,
        //     message: "User does not have any test rights"
        //   }
        // }

        // console.log();
        // return mqttSender.sendData(DsNo, `GetMenuRes:${JSON.stringify(resObj)}`)
        // }
        console.log('tempUserRights: ', tempUserRights);

        /**************** START Implementation of Initial flow of Menu ****************/
        const startUpTest = true;
        let initialTestStatus = "started";
        // if (cubicalRes.Sys_RptType == 1 || startTest) {
        if (startUpTest) {
          initialTestStatus = "started"
          newMenu = await this.setInitialMenu(DsNo, newMenu, TabIp, userId, initialTestStatus)
          if (cubicalRes.isManual == 1 && newMenu.initialTestStatus == "completed") {
            resObj = {
              status: "Fail",
              tabIp: TabIp,
              testType,
              prestart,
              isMannual: cubicalRes.isManual,
              message: `Sequence completed   (relogin again)`
            }
            return mqttSender.sendData(DsNo, `GetMenuRes:${JSON.stringify(resObj)}`)
          }
        }
        initialTestStatus = newMenu.initialTestStatus
        newMenu = newMenu.tempNewMenu
        /**************** END Implementation of Initial flow of Menu ****************/

        // Comment it after Length Test has been added
        // newMenu.push("Length")
        // newMenu.push("LOD")
        // newMenu.push("Leak")
        console.log('newMenu: ', newMenu);

        const originalDSRes = await models.tbl_cubical.findOne({
          where: {
            Sys_DSNumber: DsNo
          }
        })

        let i = 1;
        var idsmenu = [];
        for (let obj in originalDSRes) {
          if (
            originalDSRes[`Sys_Port${i}`] == undefined ||
            originalDSRes[`Sys_Port${i}`] == "None" ||
            originalDSRes[`Sys_Port${i}`] == "NULL" ||
            originalDSRes[`Sys_Port${i}`] == null
          ) {
            i++;
            continue;
          } else {
            let type = originalDSRes[`Sys_Port${i}`];
            if (originalDSRes[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.Balance) {
              if (newMenu.includes("Empty Group")) {
                idsmenu.push(`Port ${i} : Empty Group`);
              }
              if (newMenu.includes("Group")) {
                idsmenu.push(`Port ${i} : Group`);
              }
              if (newMenu.includes("Individual")) {
                idsmenu.push(`Port ${i} : Individual`);
              }
              if (newMenu.includes("Differential")) {
                idsmenu.push(`Port ${i} : Differential`);
              }
              if (newMenu.includes("Friability") && configFile.friabilityType == "OB") {
                idsmenu.push(`Port ${i} : Friability`);
              }
            } else if (originalDSRes[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.Hardness) {
              if (newMenu.includes("Hardness")) {
                idsmenu.push(`Port ${i} : Hardness`);
              }
            } else if (originalDSRes[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.MultiTester) {
              if (newMenu.includes("Hardness")) {
                idsmenu.push(`Port ${i} : Hardness`);
              }
            } else if (originalDSRes[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.MoistureAnalyzer) {
              if (newMenu.includes("Loss on Dry")) {
                idsmenu.push(`Port ${i} : Loss on Dry`);
              }
            }
            else if (originalDSRes[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.Vernier) {
              if (newMenu.includes("Thickness")) {
                idsmenu.push(`Port ${i} : Thickness`);
              }
              if (newMenu.includes("Diameter")) {
                idsmenu.push(`Port ${i} : Diameter`);
              }
              if (newMenu.includes("Length")) {
                idsmenu.push(`Port ${i} : Length`);
              }
              if (newMenu.includes("Locked Length")) {
                idsmenu.push(`Port ${i} : Locked Length`);
              }
            } else if ((originalDSRes[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.Friability || originalDSRes[`Sys_Port${i}`] == 'Friabilator') && configFile.friabilityType == "OF") {
              if (newMenu.includes("Friability")) {
                idsmenu.push(`Port ${i} : Friability`);
              }
            } else if (originalDSRes[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.LeakTester) {
              if (newMenu.includes("Leak Test")) {
                idsmenu.push(`Port ${i} : Leak Test`);
              }
            } else if (originalDSRes[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.DT) {
              if (newMenu.includes("Disintegration")) {
                idsmenu.push(`Port ${i} : Disintegration Test`);
              }
            }

            i++;
          }
        }

        let matchFlag = 0
        let BeforeWeight = 'NA'
        let timeFlag = 0
        let timecount;
        if (originalDSRes.Sys_RptType != undefined) {
          const pattern = /\bFriability\b/;
          idsmenu.forEach(item => {
            const match = item.match(pattern);
            if (match) {
              matchFlag = 1
            }
          });

          if (matchFlag) {
            let powerEntry = await models.tbl_powerbackup.findAll({
              where: {
                WeighmentName: 'FRIAB',
                DsNo: DsNo,
                TabIp: TabIp,
                MPN_Code: originalDSRes.Sys_MPNCode,
                Userid: userId,
              }
            })

            if (powerEntry.length > 0) {
              let powerbacc = powerEntry.pop()

              let detailData = await models.tbl_tab_initialdetail8_incomplete.findAll({
                where: {
                  RepSerNo: powerbacc.Incomp_RepSerNo
                }
              })

              if (detailData[detailData.length - 1].BeforeValue) {
                BeforeWeight = `${detailData[detailData.length - 1].BeforeValue} ${detailData[detailData.length - 1].DataValueUnit}`
              } else {
                BeforeWeight = 'NA'
              }

              let currentTime = new Date(date.format(new Date(), 'YYYY-MM-DD HH:mm:ss'))

              if (currentTime < powerbacc.EntryTimeStamp) {
                let tm = (powerbacc.EntryTimeStamp - currentTime) / 1000;
                let min = maths.floor(tm / 60);
                let sec = tm % 60;
                timecount = `${min}min : ${sec}sec`
                console.log(timecount)


                timeFlag = 1
              } else {
                timeFlag = 0
              }

              console.log(detailData[0].BeforeValue)
            }
          }
        }

        if (newMenu.length > 0) {
          await this.lockedWeighingStatus(
            cubicalRes.Sys_CubicNo,
            cubicalRes.Sys_Batch,
            cubicalRes.Sys_CubType
          );

          let containerFlag = await this.getContainerFlag(cubicalRes, newMenu[0], DsNo, TabIp, mesRes)
          // containerFlag = (testType == 1) ? false : containerFlag

          if (cubicalRes.Sys_RptType == 1) {
            containerFlag = false;
          }

          if (matchFlag) {
            if (!timeFlag) {
              resObj = {
                status: "Success",
                tabIp: TabIp,
                testType,
                prestart,
                data: idsmenu,
                isMannual: cubicalRes.isManual,
                BeforeWeight: BeforeWeight,
                containerField: containerFlag,
                Area: cubicalRes.Sys_Area
              }
            } else {
              resObj = {
                status: "Fail",
                tabIp: TabIp,
                testType,
                prestart,
                isMannual: cubicalRes.isManual,
                // data: idsmenu,
                // BeforeWeight: BeforeWeight,
                message: `Friability in process please wait for ${timecount}`
              }
            }
          } else {
            resObj = {
              status: "Success",
              tabIp: TabIp,
              testType,
              prestart,
              data: idsmenu,
              isMannual: cubicalRes.isManual,
              BeforeWeight: BeforeWeight,
              containerField: containerFlag,
              Area: cubicalRes.Sys_Area
            }
          }
        }
        const arrIdsInfo = globalData.arrIdsInfo.find(k => k.DsNo == DsNo && k.TabIp == TabIp)
        if (!arrIdsInfo) {
          globalData.arrIdsInfo.push({
            DsNo,
            TabIp,
            userId,
            cubicalData: cubicalRes,
            isMannual: false,
            IPAddress: cubicalRes.IPAddress
          })
        } else {
          arrIdsInfo.DsNo = DsNo;
          arrIdsInfo.TabIp = TabIp;
          arrIdsInfo.cubicalData = cubicalRes;
          arrIdsInfo.userId = userId;
          arrIdsInfo.isMannual = false;
          arrIdsInfo.IPAddress = cubicalRes.IPAddress
        }
        globalData.PendingRequest.findIndex((e) => e.DsNo === DsNo && e.TabIp == TabIp) !== -1 ? globalData.PendingRequest.splice(globalData.PendingRequest.findIndex((k) => k.DsNo == DsNo && k.TabIp == TabIp), 1) : globalData.PendingRequest;

        console.log("Menu has been send through MQTT. ", JSON.stringify(resObj));
        return mqttSender.sendData(DsNo, `GetMenuRes:${JSON.stringify(resObj)}`)
      }
    } catch (error) {
      console.log('error: ', error);
    }
  }

  async setInitialMenu(DsNo, newMenu, TabIp, userId, initialTestStatus) {
    let tempNewMenu = newMenu;

    let mesArrRes = await models.tbl_mes_data.findOne({
      where: {
        DS_Number: DsNo,
        isSetInCubical: 1
      },
    });
    var menuSequence = await models.tbl_menu_sequence.findOne({
      where: {
        DS_Number: 0,
      }
    });

    var menuSeqRes = await models.tbl_menu_sequence.findOne({
      where: {
        DS_Number: DsNo,
        // TabIp: TabIp
      }
    })


    // if (menuSeqRes.length && menuSeqRes.UserId != userId) {
    //   await models.tbl_menu_sequence.destroy({
    //     where: {
    //       DS_Number: DsNo
    //     }
    //   })
    // }
    if (menuSeqRes != null) {

      tempNewMenu = await this.sortInitialMenu(tempNewMenu, menuSequence, menuSeqRes, mesArrRes.ProductType)
    }

    if (!menuSeqRes) {
      const cubicalRes = await models.tbl_cubical.findOne({
        where: {
          Sys_DSNumber: DsNo,
        },
      });


      if (menuSeqRes != null) {
        await models.tbl_menu_sequence.update({ TabIp: TabIp }, { where: { DS_Number: cubicalRes.Sys_DSNumber } })
      } else {
        if (cubicalRes.Sys_Area !== 'Coating') {
          let setIND = (newMenu.includes(GLOBAL_NOMENCLATURE.IndividualMenu) && menuSequence.IND) ? 0 : null
          let setGRP = (newMenu.includes(GLOBAL_NOMENCLATURE.GroupMenu) && menuSequence.GRP) ? 0 : null
          let setEGRP = (newMenu.includes(GLOBAL_NOMENCLATURE.EmptyGroupMenu) && menuSequence.EGRP) ? 0 : null
          let setHARD = (newMenu.includes(GLOBAL_NOMENCLATURE.Hardness) && menuSequence.HARD) ? 0 : null
          let setLOD = (newMenu.includes(GLOBAL_NOMENCLATURE.LODMenu) && menuSequence.LOD) ? 0 : null
          let setTHICK = (newMenu.includes(GLOBAL_NOMENCLATURE.ThicknessMenu) && menuSequence.THICK) ? 0 : null
          let setLEN = ((newMenu.includes(GLOBAL_NOMENCLATURE.LengthMenu) || newMenu.includes(GLOBAL_NOMENCLATURE.LockedLength)) && menuSequence.LEN) ? 0 : null
          let setDIA = (newMenu.includes(GLOBAL_NOMENCLATURE.DiameterMenu) && menuSequence.DIA) ? 0 : null
          let setNET = (newMenu.includes(GLOBAL_NOMENCLATURE.Differential) && menuSequence.NET) ? 0 : null
          let setFRIAB = (newMenu.includes(GLOBAL_NOMENCLATURE.Friability) && menuSequence.FRIAB && !cubicalRes.isPreStart) ? 0 : null
          let setDT = (newMenu.includes(GLOBAL_NOMENCLATURE.DTMenu) && menuSequence.DT && !cubicalRes.isPreStart) ? 0 : null

          await models.tbl_menu_sequence.create({
            DS_Number: DsNo,
            TabIp: TabIp,
            UserId: userId,
            // IND: 0,
            // GRP: 0,
            // HARD: 0,
            // LOD: 0,
            // THICK: 0,
            // LEN: 0,
            // DIA: 0,
            // FRIAB: 0,
            // DT: 0,

            // IND: (!menuSequence.IND) ? menuSequence.IND : 0,
            // GRP: (!menuSequence.GRP) ? menuSequence.GRP : 0,
            // HARD: (!menuSequence.HARD) ? menuSequence.HARD : 0,
            // LOD: (!menuSequence.LOD) ? menuSequence.LOD : 0,
            // THICK: (!menuSequence.THICK) ? menuSequence.THICK : 0,
            // LEN: (!menuSequence.LEN) ? menuSequence.LEN : 0,
            // DIA: (!menuSequence.DIA) ? menuSequence.DIA : 0,
            // FRIAB: (!menuSequence.FRIAB) ? menuSequence.FRIAB : 0,
            // DT: (!menuSequence.DT) ? menuSequence.DT : 0,

            IND: setIND,
            GRP: setGRP,
            EGRP: setEGRP,
            HARD: setHARD,
            LOD: setLOD,
            THICK: setTHICK,
            LEN: setLEN,
            DIA: setDIA,
            FRIAB: setFRIAB,
            DT: setDT,
            NET: setNET
          });

        }

      }
      menuSeqRes = await models.tbl_menu_sequence.findOne({
        where: {
          DS_Number: DsNo,
          TabIp: TabIp
        }
      })

      if (cubicalRes.Sys_Area !== 'Coating') {
        tempNewMenu = await this.sortInitialMenu(tempNewMenu, menuSequence, menuSeqRes, mesArrRes.ProductType)
      }
    } else {
      var count = 0
      if (menuSeqRes != null) {
        let cubicalRes_ = await models.tbl_cubical.findOne({
          where: {
            Sys_DSNumber: DsNo,
          },
        });
        await models.tbl_menu_sequence.update({ TabIp: TabIp }, { where: { DS_Number: cubicalRes_.Sys_DSNumber } });
      }
      delete menuSeqRes.RepSerNo;
      for (let ele in menuSeqRes) {
        if (ele == 'UserId' || ele == 'DSNumber' || ele == 'RecNo' || ele == 'TabIp') continue;

        if (menuSeqRes[ele] == 0) count++
      }

      if (count == 0) {
        initialTestStatus = "completed"
        await models.tbl_menu_sequence.destroy({
          where: {
            DS_Number: DsNo
          }
        })
      }
    }

    return { tempNewMenu, initialTestStatus }
  }

  async sortInitialMenu(newMenu, menuSequence, menuSeqRes, prdType) {
    try {
      var arr = []
      var k = 1;
      delete menuSequence["RecNo"]

      for (let i in menuSequence) {
        var ind = Object.keys(menuSequence).find(e => menuSequence[e] == k)
        if (ind == 'UserId' || ind == 'DSNumber' || ind == 'RecNo' || ind == 'TabIp') continue;
        var menu = '';

        switch (ind) {
          case "IND":
            if (!menuSeqRes) {
              menu = GLOBAL_NOMENCLATURE.IndividualMenu
            } else if (menuSeqRes.IND == 0) {
              menu = GLOBAL_NOMENCLATURE.IndividualMenu
            }

            break;

          case "GRP":
            if (!menuSeqRes) {
              menu = GLOBAL_NOMENCLATURE.GroupMenu
            } else if (menuSeqRes.GRP == 0) {
              menu = GLOBAL_NOMENCLATURE.GroupMenu
            }

            break;
          case "EGRP":
            if (!menuSeqRes) {
              menu = GLOBAL_NOMENCLATURE.EmptyGroupMenu
            } else if (menuSeqRes.EGRP == 0) {
              menu = GLOBAL_NOMENCLATURE.EmptyGroupMenu
            }

            break;

          case "HARD":
            if (!menuSeqRes) {
              menu = GLOBAL_NOMENCLATURE.HardnessMenu
            } else if (menuSeqRes.HARD == 0) {
              menu = GLOBAL_NOMENCLATURE.HardnessMenu
            }
            break;

          case "LOD":
            if (!menuSeqRes) {
              menu = GLOBAL_NOMENCLATURE.LODMenu
            } else if (menuSeqRes.LOD == 0) {
              menu = GLOBAL_NOMENCLATURE.LODMenu
            }
            break;

          case "THICK":
            if (!menuSeqRes) {
              menu = GLOBAL_NOMENCLATURE.ThicknessMenu
            } else if (menuSeqRes.THICK == 0) {
              menu = GLOBAL_NOMENCLATURE.ThicknessMenu
            }
            break;

          case "LEN":
            if (!menuSeqRes) {
              menu = GLOBAL_NOMENCLATURE.LengthMenu
            } else if (menuSeqRes.LEN == 0) {
              menu = prdType == 2 ? GLOBAL_NOMENCLATURE.LockedLength : GLOBAL_NOMENCLATURE.LengthMenu
            }
            break;

          case "DIA":
            if (!menuSeqRes) {
              menu = GLOBAL_NOMENCLATURE.DiameterMenu
            } else if (menuSeqRes.DIA == 0) {
              menu = GLOBAL_NOMENCLATURE.DiameterMenu
            }
            break;

          case "FRIAB":
            if (!menuSeqRes) {
              menu = GLOBAL_NOMENCLATURE.FriabilatorMenu
            } else if (menuSeqRes.FRIAB == 0) {
              menu = GLOBAL_NOMENCLATURE.Friability
            }
            break;

          case "DT":
            if (!menuSeqRes) {
              menu = GLOBAL_NOMENCLATURE.DTMenu
            } else if (menuSeqRes.DT == 0) {
              menu = GLOBAL_NOMENCLATURE.DTMenu
            }
            break;
          case "NET":
            if (!menuSeqRes) {
              menu = GLOBAL_NOMENCLATURE.Differential
            } else if (menuSeqRes.NET == 0) {
              menu = GLOBAL_NOMENCLATURE.Differential
            }
            break;
        }
        if (newMenu.includes(menu)) arr.push(menu)
        if (arr.length == 1 && prdType != 2) break;
        k++
      }

      return arr
    } catch (error) {
      throw new Error(error)
    }
  }


  async makeMenu(cubicalRes, mesRes, productMasterRes, productDetailsRes, productSampleRes, TabIp, DsNo, selectedDsNo) {
    let menuObj = {}
    const arrHardnessColumn = [];
    const arrHardnessColumnDetail = [];
    const BatchId = mesRes.BatchID;
    const productType = productMasterRes.ProductType;

    // get all Instrument of selected DS
    const originalDS = await models.tbl_cubical.findOne({
      where: {
        Sys_DSNumber: DsNo
      }
    })

    // Check for Hardness equipment model
    const hardnessInstrumentRes = await models.tbl_otherequipment.findOne({
      where: {
        Eqp_ID: originalDS.Sys_HardID
      }
    })

    const balObj = await models.tbl_balance.findOne({
      where: {
        Bal_ID: originalDS.Sys_BalID
      }
    })
    let Dp = configFile.plant == "PUI" ? (balObj?.Bal_DP || 3) : 3;


    let FTPInstrumentFound = false;

    let isValid;
    let resObj;

    // Group Coating
    if ((originalDS.Sys_BalID != "None" && mesRes.AWBID != "NA") && (originalDS.Sys_BalID == mesRes.AWBID) && (originalDS.Sys_CubType == "Coating" && originalDS.Sys_BalID != "None")) {
      menuObj["Group"] = {
        dp: Dp,
        Unit: productDetailsRes.Param2_Unit,
        noOfSamples: productSampleRes.Group
      };
    }

    // Group Filled
    if ((((originalDS.Sys_BalID != "None" && mesRes.AWBID != "NA") && (originalDS.Sys_BalID == mesRes.AWBID)) || (originalDS.Sys_CubType == "IPQC" && originalDS.Sys_BalID != "None")) && (Number(productDetailsRes.Param2_T2Neg) != 99999 && Number(productDetailsRes.Param2_T2Neg) > 0) && (Number(productDetailsRes.Param2_T2Pos) != 99999 && Number(productDetailsRes.Param2_T2Pos) > 0)) {
      if ((Number(mesRes.GrpWtLow) != 99999 && Number(mesRes.GrpWtLow) > 0) && (Number(mesRes.GrpWtHigh) != 99999 && Number(mesRes.GrpWtHigh) > 0)) {
        var pl_mi_limit = 0;
        if (productDetailsRes.Param2_Nom != 99999 && productDetailsRes.Param2_Nom != '') {
          if ((productDetailsRes.Param2_Nom - productDetailsRes.Param2_T2Neg).toFixed(Dp) == (productDetailsRes.Param2_T2Pos - productDetailsRes.Param2_Nom).toFixed(Dp)) {
            pl_mi_limit = "±" + (productDetailsRes.Param2_Nom - productDetailsRes.Param2_T2Neg).toFixed(Dp);
          }
          else {
            pl_mi_limit = '+  ' + (productDetailsRes.Param2_T2Pos - productDetailsRes.Param2_Nom).toFixed(Dp) + ' -' + (productDetailsRes.Param2_Nom - productDetailsRes.Param2_T2Neg).toFixed(Dp);
          }
        }
        if ((!mesRes.MesTestType.includes('4') && !mesRes.MesTestType.includes('8')) || configFile.plant == 'PUI' || mesRes.ProductType == 2) {

          menuObj["Group"] = {
            T2Neg: productDetailsRes.Param2_T2Neg.toFixed(Dp),
            T2Pos: productDetailsRes.Param2_T2Pos.toFixed(Dp),
            Nom: productDetailsRes.Param2_Nom,
            plmiLimit: pl_mi_limit,
            dp: Dp,
            Unit: productDetailsRes.Param2_Unit,
            noOfSamples: cubicalRes.isPreStart == 1 ? 20 : productSampleRes.Group
          };
        }


      }
    }

    //Empty Group
    if ((((originalDS.Sys_BalID != "None" && mesRes.AWBID != "NA") && (originalDS.Sys_BalID == mesRes.AWBID)) || (originalDS.Sys_CubType == "IPQC" && originalDS.Sys_BalID != "None")) && (Number(productDetailsRes.Param19_T2Neg) != 99999 && Number(productDetailsRes.Param19_T2Neg) > 0) && (Number(productDetailsRes.Param19_T2Pos) != 99999 && Number(productDetailsRes.Param19_T2Pos) > 0)) {
      if ((Number(mesRes.EmptGrpWtLow) != 99999 && Number(mesRes.EmptGrpWtLow) > 0) && (Number(mesRes.EmptGrpWtHigh) != 99999 && Number(mesRes.EmptGrpWtHigh) > 0)) {
        var pl_mi_limit = 0;
        if (productDetailsRes.Param19_Nom != 99999 && productDetailsRes.Param19_Nom != '') {
          if ((productDetailsRes.Param19_Nom - productDetailsRes.Param19_T2Neg).toFixed(Dp) == (productDetailsRes.Param19_T2Pos - productDetailsRes.Param19_Nom).toFixed(Dp)) {
            pl_mi_limit = "±" + (productDetailsRes.Param19_Nom - productDetailsRes.Param19_T2Neg).toFixed(Dp);
          }
          else {
            pl_mi_limit = '+  ' + (productDetailsRes.Param19_T2Pos - productDetailsRes.Param19_Nom).toFixed(Dp) + ' -' + (productDetailsRes.Param19_Nom - productDetailsRes.Param19_T2Neg).toFixed(Dp);
          }
        }

        if (originalDS.Sys_CubType == "Capsule Filling" && originalDS.Sys_RptType != 0) {
          menuObj["Empty Group"] = {
            T2Neg: productDetailsRes.Param19_T2Neg.toFixed(Dp),
            T2Pos: productDetailsRes.Param19_T2Pos.toFixed(Dp),
            Nom: productDetailsRes.Param19_Nom,
            plmiLimit: pl_mi_limit,
            dp: Dp,
            Unit: productDetailsRes.Param2_Unit,
            noOfSamples: 50
          };
        }
      }
    }


    if (hardnessInstrumentRes && mesRes.HTID != 'NA') {
      if ((hardnessInstrumentRes.Eqp_Model == "WHT 4" || hardnessInstrumentRes.Eqp_Model == "WHT4") && (hardnessInstrumentRes.Eqp_Make == 'Pharmatest') && hardnessInstrumentRes.Eqp_Type == "Multi Tester") {
        if (hardnessInstrumentRes) await this.isValidCertification(hardnessInstrumentRes?.Eqp_validDt, originalDS.Sys_HardID, TabIp, DsNo);
        if ((Number(mesRes.IndWtHigh) != 99999 && Number(mesRes.IndWtHigh) > 0) && (Number(mesRes.IndWtLow) != 99999 && Number(mesRes.IndWtLow) > 0)) {

          var pl_mi_limit = 0;
          if (productDetailsRes.Param1_Nom != 99999 && productDetailsRes.Param1_Nom != '') {
            if ((productDetailsRes.Param1_Nom - productDetailsRes.Param1_T2Neg).toFixed(3) == (productDetailsRes.Param1_T2Pos - productDetailsRes.Param1_Nom).toFixed(3)) {
              pl_mi_limit = "±" + (productDetailsRes.Param1_Nom - productDetailsRes.Param1_T2Neg).toFixed(3);
            }
            else {
              pl_mi_limit = '+  ' + (productDetailsRes.Param1_T2Pos - productDetailsRes.Param1_Nom).toFixed(3) + ' -' + (productDetailsRes.Param1_Nom - productDetailsRes.Param1_T2Neg).toFixed(3);
            }
          }

          menuObj["Individual"] = {
            T2Neg: productDetailsRes.Param1_T2Neg,
            T2Pos: productDetailsRes.Param1_T2Pos,
            Nom: productDetailsRes.Param1_Nom,
            plmiLimit: pl_mi_limit,
            dp: 3,
            Unit: productDetailsRes.Param1_Unit,
            noOfSamples: productSampleRes.Individual
          };
        }
        if ((hardnessInstrumentRes.Eqp_Model == "WHT 4" || hardnessInstrumentRes.Eqp_Model == "WHT4") && originalDS.Sys_RptType != 1) {
          const menuSequence = await models.tbl_menu_sequence.update({
            IND: null
          }, {
            where: {
              DS_Number: DsNo,
            }

          });
          // FTPInstrumentFound = true;
        }
      }
    }

    // Indivdual 
    // Includes check : => IN PUI PRE_STARTUP MODE => CAN BE PERFORM BY BALANCE ONLY
    if (originalDS.Sys_HardID != "None" || configFile.plant == 'PUI' || originalDS.Sys_Area == 'Capsule Filling') {
      if ((((originalDS.Sys_BalID != "None" && mesRes.AWBID != "NA") && (originalDS.Sys_BalID == mesRes.AWBID)) || (originalDS.Sys_CubType == "IPQC" && originalDS.Sys_BalID != "None")) && (Number(productDetailsRes.Param1_T2Neg) != 99999 && Number(productDetailsRes.Param1_T2Neg) > 0) && (Number(productDetailsRes.Param1_T2Pos) != 99999 && Number(productDetailsRes.Param1_T2Pos) > 0) && !FTPInstrumentFound) {
        if ((Number(mesRes.IndWtHigh) != 99999 && Number(mesRes.IndWtHigh) > 0) && (Number(mesRes.IndWtLow) != 99999 && Number(mesRes.IndWtLow) > 0)) {

          var pl_mi_limit = 0;
          if (productDetailsRes.Param1_Nom != 99999 && productDetailsRes.Param1_Nom != '') {
            if ((productDetailsRes.Param1_Nom - productDetailsRes.Param1_T2Neg).toFixed(Dp) == (productDetailsRes.Param1_T2Pos - productDetailsRes.Param1_Nom).toFixed(Dp)) {
              pl_mi_limit = "±" + (productDetailsRes.Param1_Nom - productDetailsRes.Param1_T2Neg).toFixed(Dp);
            }
            else {
              pl_mi_limit = '+  ' + (productDetailsRes.Param1_T2Pos - productDetailsRes.Param1_Nom).toFixed(Dp) + ' -' + (productDetailsRes.Param1_Nom - productDetailsRes.Param1_T2Neg).toFixed(Dp);
            }
          }

          // if (((hardnessInstrumentRes?.Eqp_Model != 'VK200' || mesRes.MesTestType.includes('QA') || mesRes.MesTestType.toLowerCase().includes('startup')) && !mesRes.MesTestType.includes('2') && !mesRes.MesTestType.includes('8')) || configFile.plant == 'PUI' || mesRes.ProductType == 2) {
          if ((!mesRes.MesTestType.includes('2') && !mesRes.MesTestType.includes('8')) || configFile.plant == 'PUI' || mesRes.ProductType == 2) {

            menuObj["Individual"] = {
              T2Neg: productDetailsRes.Param1_T2Neg.toFixed(Dp),
              T2Pos: productDetailsRes.Param1_T2Pos.toFixed(Dp),
              Nom: productDetailsRes.Param1_Nom,
              plmiLimit: pl_mi_limit,
              dp: Dp,
              Unit: productDetailsRes.Param1_Unit,
              noOfSamples: productSampleRes.Individual
            };
          }
        }
      }
    }

    // Differemtial
    if ((((originalDS.Sys_BalID != "None" && mesRes.AWBID != "NA") && (originalDS.Sys_BalID == mesRes.AWBID)) || (originalDS.Sys_CubType == "IPQC" && originalDS.Sys_BalID != "None")) && (Number(productDetailsRes.Param3_T2Neg) != 99999 && Number(productDetailsRes.Param3_T2Neg) > 0) && (Number(productDetailsRes.Param3_T2Pos) != 99999 && Number(productDetailsRes.Param3_T2Pos) > 0) && productType == 2) {
      if ((Number(mesRes.DiffWtLow) != 99999 && Number(mesRes.DiffWtLow) > 0) && (Number(mesRes.DiffWtHigh) != 99999 && Number(mesRes.DiffWtHigh) > 0)) {
        var pl_mi_limit = 0;
        if (productDetailsRes.Param3_Nom != 99999 && productDetailsRes.Param3_Nom != '') {
          if ((productDetailsRes.Param3_Nom - productDetailsRes.Param3_T2Neg).toFixed(3) == (productDetailsRes.Param3_T2Pos - productDetailsRes.Param3_Nom).toFixed(3)) {
            pl_mi_limit = "±" + (productDetailsRes.Param3_Nom - productDetailsRes.Param3_T2Neg).toFixed(3);
          }
          else {
            pl_mi_limit = '+  ' + (productDetailsRes.Param3_T2Pos - productDetailsRes.Param3_Nom).toFixed(3) + ' -' + (productDetailsRes.Param3_Nom - productDetailsRes.Param3_T2Neg).toFixed(3);
          }
        }
        menuObj["Differential"] = {
          T2Neg: productDetailsRes.Param3_T2Neg,
          T2Pos: productDetailsRes.Param3_T2Pos,
          Nom: productDetailsRes.Param3_Nom,
          plmiLimit: pl_mi_limit,
          dp: 3,
          Unit: productDetailsRes.Param3_Unit,
          noOfSamples: productSampleRes.Differential
        };
      }
    }

    // Hardness
    if ((((originalDS.Sys_HardID != "None" && mesRes.HTID != "NA") && (originalDS.Sys_HardID == mesRes.HTID)) || (originalDS.Sys_CubType == "IPQC" && originalDS.Sys_HardID != "None")) && (Number(productDetailsRes.Param7_T2Neg) != 99999 && Number(productDetailsRes.Param7_T2Neg) > 0) && (Number(productDetailsRes.Param7_T2Pos) != 99999 && Number(productDetailsRes.Param7_T2Pos) > 0) && productType == 1) {
      if (hardnessInstrumentRes) await this.isValidCertification(hardnessInstrumentRes?.Eqp_validDt, originalDS, TabIp, DsNo);
      if ((Number(mesRes.HardnessLow) != 99999 && Number(mesRes.HardnessLow) > 0) && (Number(mesRes.HardnessHigh) != 99999 && Number(mesRes.HardnessHigh) > 0)) {

        var pl_mi_limit = 0;
        if (productDetailsRes.Param7_Nom != 99999 && productDetailsRes.Param7_Nom != '') {
          if ((productDetailsRes.Param7_Nom - productDetailsRes.Param7_T2Neg).toFixed(3) == (productDetailsRes.Param7_T2Pos - productDetailsRes.Param7_Nom).toFixed(3)) {
            pl_mi_limit = "±" + (productDetailsRes.Param7_Nom - productDetailsRes.Param7_T2Neg).toFixed(3);
          }
          else {
            pl_mi_limit = '+  ' + (productDetailsRes.Param7_T2Pos - productDetailsRes.Param7_Nom).toFixed(3) + ' -' + (productDetailsRes.Param7_Nom - productDetailsRes.Param7_T2Neg).toFixed(3);
          }
        }
        if ((!mesRes.MesTestType.includes('2') && !mesRes.MesTestType.includes('8')) || configFile.plant == 'PUI' || mesRes.ProductType == 2) {

          menuObj["Hardness"] = {
            T2Neg: productDetailsRes.Param7_T2Neg.toFixed(Dp),
            T2Pos: productDetailsRes.Param7_T2Pos.toFixed(Dp),
            Nom: productDetailsRes.Param7_Nom,
            plmiLimit: pl_mi_limit,
            dp: productDetailsRes.Param7_Unit == "N" ? 0 : (configFile.plant == "PUI") ? 2 : 1,
            Unit: productDetailsRes.Param7_Unit,
            noOfSamples: productSampleRes.Hardness
          };
        }
      }

    }

    // Thickness

    if ((Number(productDetailsRes.Param3_T2Neg) != 99999 && Number(productDetailsRes.Param3_T2Neg) > 0) && (Number(productDetailsRes.Param3_T2Pos) != 99999 && Number(productDetailsRes.Param3_T2Pos) > 0) && productType == 1) {
      if (hardnessInstrumentRes) await this.isValidCertification(hardnessInstrumentRes?.Eqp_validDt, originalDS.Sys_HardID, TabIp, DsNo);
      if ((Number(mesRes.ThicknessLow) != 99999 && Number(mesRes.ThicknessLow) > 0) && (Number(mesRes.ThicknessHigh) != 99999 && Number(mesRes.ThicknessHigh) > 0)) {
        var pl_mi_limit = 0;
        if (productDetailsRes.Param3_Nom != 99999 && productDetailsRes.Param3_Nom != '') {
          if ((productDetailsRes.Param3_Nom - productDetailsRes.Param3_T2Neg).toFixed(3) == (productDetailsRes.Param3_T2Pos - productDetailsRes.Param3_Nom).toFixed(3)) {
            pl_mi_limit = "±" + (productDetailsRes.Param3_Nom - productDetailsRes.Param3_T2Neg).toFixed(3);
          }
          else {
            pl_mi_limit = '+  ' + (productDetailsRes.Param3_T2Pos - productDetailsRes.Param3_Nom).toFixed(3) + ' -' + (productDetailsRes.Param3_Nom - productDetailsRes.Param3_T2Neg).toFixed(3);
          }
        }
        if ((!mesRes.MesTestType.includes('8') && !mesRes.MesTestType.includes('2')) || configFile.plant == 'PUI') {
          menuObj["Thickness"] = {
            T2Neg: productDetailsRes.Param3_T2Neg,
            T2Pos: productDetailsRes.Param3_T2Pos,
            Nom: productDetailsRes.Param3_Nom,
            plmiLimit: pl_mi_limit,
            dp: 2,
            Unit: productDetailsRes.Param3_Unit,
            noOfSamples: productSampleRes.Thickness
          };
        }
      }
    }

    // Diameter
    if ((Number(productDetailsRes.Param6_T2Neg) != 99999 && Number(productDetailsRes.Param6_T2Neg) > 0) && (Number(productDetailsRes.Param6_T2Pos) != 99999 && Number(productDetailsRes.Param6_T2Pos) > 0) && productType == 1) {
      if ((Number(mesRes.DiameterLow) != 99999 && Number(mesRes.DiameterLow) > 0) && (Number(mesRes.DiameterHigh) != 99999 && Number(mesRes.DiameterHigh) > 0)) {
        menuObj["Diameter"] = {
          T2Neg: productDetailsRes.Param6_T2Neg,
          T2Pos: productDetailsRes.Param6_T2Pos,
          Nom: productDetailsRes.Param6_Nom,
          dp: 2,
          Unit: productDetailsRes.Param6_Unit,
          noOfSamples: productSampleRes.Diameter
        };
      }
    }

    // Length
    if ((Number(productDetailsRes.Param5_T2Neg) != 99999 && Number(productDetailsRes.Param5_T2Neg) > 0) && (Number(productDetailsRes.Param5_T2Pos) != 99999 && Number(productDetailsRes.Param5_T2Pos) > 0)) {
      let tempMenuName = "Length";
      if (productType == 2) {
        tempMenuName = "Locked Length";
        if ((Number(mesRes.LengthLow) != 99999 && Number(mesRes.LengthLow) > 0) && (Number(mesRes.LengthHigh) != 99999 && Number(mesRes.LengthHigh) > 0) && (originalDS.Sys_VernierID != "None" && mesRes.Sys_VernierID != "NA")) {
          const VernierInstrument = await models.tbl_otherequipment.findOne({
            where: {
              Eqp_ID: originalDS.Sys_VernierID,
            }
          })
          if (VernierInstrument) await this.isValidCertification(VernierInstrument?.Eqp_validDt, originalDS.Sys_VernierID, TabIp, DsNo);
          var pl_mi_limit = 0;
          if (productDetailsRes.Param5_Nom != 99999 && productDetailsRes.Param5_Nom != '') {
            if ((productDetailsRes.Param5_Nom - productDetailsRes.Param5_T2Neg).toFixed(3) == (productDetailsRes.Param5_T2Pos - productDetailsRes.Param5_Nom).toFixed(3)) {
              pl_mi_limit = "±" + (productDetailsRes.Param5_Nom - productDetailsRes.Param5_T2Neg).toFixed(3);
            }
            else {
              pl_mi_limit = '+  ' + (productDetailsRes.Param5_T2Pos - productDetailsRes.Param5_Nom).toFixed(3) + ' -' + (productDetailsRes.Param5_Nom - productDetailsRes.Param5_T2Neg).toFixed(3);
            }
          }
          menuObj[tempMenuName] = {
            T2Neg: productDetailsRes.Param5_T2Neg,
            T2Pos: productDetailsRes.Param5_T2Pos,
            Nom: productDetailsRes.Param5_Nom,
            dp: 2,
            pl_mi_limit: pl_mi_limit,
            Unit: productDetailsRes.Param5_Unit,
            noOfSamples: productSampleRes.Length
          };
        }
      } else {

        if ((Number(mesRes.LengthLow) != 99999 && Number(mesRes.LengthLow) > 0) && (Number(mesRes.LengthHigh) != 99999 && Number(mesRes.LengthHigh) > 0)) {
          var pl_mi_limit = 0;
          if (productDetailsRes.Param5_Nom != 99999 && productDetailsRes.Param5_Nom != '') {
            if ((productDetailsRes.Param5_Nom - productDetailsRes.Param5_T2Neg).toFixed(3) == (productDetailsRes.Param5_T2Pos - productDetailsRes.Param5_Nom).toFixed(3)) {
              pl_mi_limit = "±" + (productDetailsRes.Param5_Nom - productDetailsRes.Param5_T2Neg).toFixed(3);
            }
            else {
              pl_mi_limit = '+  ' + (productDetailsRes.Param5_T2Pos - productDetailsRes.Param5_Nom).toFixed(3) + ' -' + (productDetailsRes.Param5_Nom - productDetailsRes.Param5_T2Neg).toFixed(3);
            }
          }
          menuObj[tempMenuName] = {
            T2Neg: productDetailsRes.Param5_T2Neg,
            T2Pos: productDetailsRes.Param5_T2Pos,
            Nom: productDetailsRes.Param5_Nom,
            dp: 2,
            pl_mi_limit: pl_mi_limit,
            Unit: productDetailsRes.Param5_Unit,
            noOfSamples: productSampleRes.Length
          };
        }
      }
    }
    if ((!mesRes.MesTestType.includes('4') && !mesRes.MesTestType.includes('2')) || configFile.plant == 'PUI' || mesRes.ProductType == 2) {

      // Friability
      if (productType == 1) {
        let isFriab = false;
        if (configFile.friabilityType == "OB" && (((originalDS.Sys_BalID != "None" && mesRes.AWBID != "NA") && (originalDS.Sys_FriabID != "None" && mesRes.FTID != 'NA')) || (originalDS.Sys_CubType == "IPQC" && originalDS.Sys_BalID != "None"))) {
          isFriab = true;
        } else {
          // if (((originalDS.Sys_FriabID != "None" && mesRes.FTID != "NA") && (originalDS.Sys_FriabID == mesRes.FTID)) && (Number(productDetailsRes.Param8_T1Neg) != 99999 && Number(productDetailsRes.Param8_T1Neg) > 0) && (Number(productDetailsRes.Param8_T1Pos) != 99999 && Number(productDetailsRes.Param8_T1Pos) > 0) && configFile.friabilityType == "OF") {
          if (((originalDS.Sys_FriabID != "None" && mesRes.FTID != "NA") && (originalDS.Sys_FriabID == mesRes.FTID)) && configFile.friabilityType == "OF") {
            isFriab = true;
          }
        }
        if (isFriab) {
          if (mesRes.Friabilityrange != 0 && mesRes.FriabilityRPM != null) {
            const FriabInstrument = await models.tbl_otherequipment.findOne({
              where: {
                Eqp_ID: originalDS.Sys_FriabID,
              }
            })
            if (FriabInstrument) await this.isValidCertification(FriabInstrument?.Eqp_validDt, originalDS.Sys_FriabID, TabIp, DsNo);
            menuObj["Friability"] = {
              // T2Neg: productDetailsRes.Param8_T1Neg,
              // T2Pos: productDetailsRes.Param8_T1Pos,
              Nominal: productDetailsRes?.Param8_Nom,
              RPM: mesRes?.FriabilityRPM,
              dp: 3,
              // unit: productDetailsRes?.Param8_Unit,
              unit: "gm",
              noOfSamples: productSampleRes?.Friability
            };
          }
        }
      }

      // DT
      let nom = 'Param13_Nom'
      if (productType == 2) {
        nom = 'Param6_Nom'
      }
      if ((((originalDS.Sys_DTID != "None" && mesRes.DTID != "NA") && (originalDS.Sys_DTID == mesRes.DTID)) || (originalDS.Sys_CubType == "IPQC" && originalDS.Sys_DTID != "None")) && ((productDetailsRes[nom] != "NA" && productDetailsRes[nom] != "NULL" && productDetailsRes[nom] != "0.00000"))) {
        const DTInstrument = await models.tbl_otherequipment.findOne({
          where: {
            Eqp_ID: originalDS.Sys_DTID,
          }
        })
        if (DTInstrument) await this.isValidCertification(DTInstrument?.Eqp_validDt, originalDS.Sys_DTID, TabIp, DsNo);
        if (mesRes.DisintegrationRange != 0 && mesRes.DisintegrationRange != 'NA') {
          menuObj["Disintegration"] = {
            Nom: productDetailsRes[nom],
            dp: 3,
            unit: productDetailsRes.Param13_Unit,
            noOfSamples: productSampleRes.DT
          };
        }
      }
    }
    // LOD
    if (((originalDS.Sys_MoistID != "None" && mesRes.MAID != "NA") && (originalDS.Sys_MoistID == mesRes.MAID)) || (originalDS.Sys_CubType == "IPQC" && originalDS.Sys_DTID != "None")) {
      const MoistInstrument = await models.tbl_otherequipment.findOne({
        where: {
          Eqp_ID: originalDS.Sys_MoistID,
        }
      })
      if (MoistInstrument) await this.isValidCertification(MoistInstrument?.Eqp_validDt, originalDS.Sys_MoistID, TabIp, DsNo);
      menuObj["LOD"] = {
        Nom: productDetailsRes.Param16_Nom,
        T2Neg: productDetailsRes.Param16_T2Neg,
        dp: 3,
        unit: "%",
        noOfSamples: productSampleRes.DT
      };
    }

    if (menuObj.hasOwnProperty("Hardness")) {
      arrHardnessColumn.push("Hardness")
      arrHardnessColumnDetail.push({ Hardness: menuObj.Hardness })

      if (menuObj.hasOwnProperty("Thickness")) {
        arrHardnessColumn.push("Thickness")
        arrHardnessColumnDetail.push({ Thickness: menuObj.Thickness })
      }
      if (hardnessInstrumentRes.Eqp_Make != 'Pharmatest' && hardnessInstrumentRes.Eqp_Type != "Multi Tester") {
        if (menuObj.hasOwnProperty("Diameter")) {
          arrHardnessColumn.push("Diameter")
          arrHardnessColumnDetail.push({ Diameter: menuObj.Diameter })
        }

        if (menuObj.hasOwnProperty("Length")) {
          arrHardnessColumn.push("Length")
          arrHardnessColumnDetail.push({ Length: menuObj.Length })
        }
      }

      menuObj["Hardness"] = {
        arrHardnessColumn,
        arrHardnessColumnDetail
      }
    }

    if ((originalDS.Sys_VernierID == null || originalDS.Sys_VernierID == "None") || (originalDS.Sys_VernierID != mesRes.VerId) || (originalDS.Sys_CubType == "IPQC" && originalDS.Sys_VernierID == "None")) {
      delete menuObj["Thickness"];
      delete menuObj["Diameter"];
      delete menuObj["Length"];
    }

    if ((originalDS.Sys_LeakID != null && originalDS.Sys_LeakID != "None" && originalDS.Sys_LeakID != "NULL") && productType == 1) {
      const LeakInstrument = await models.tbl_otherequipment.findOne({
        where: {
          Eqp_ID: originalDS.Sys_LeakID,
        }
      })
      if (LeakInstrument) await this.isValidCertification(LeakInstrument?.Eqp_validDt, originalDS.Sys_LeakID, TabIp, DsNo);
      menuObj["Leak Test"] = {};
    }

    console.log('menuObj: ', menuObj);

    let tempArrLimits = globalData.arr_limits.find((k) => k.DsNo == DsNo && k.TabIp == TabIp);
    if (!tempArrLimits) {
      globalData.arr_limits.push({
        DsNo,
        TabIp,
        BatchId,
        Menus: menuObj
      })
    } else {
      tempArrLimits.DsNo = DsNo;
      tempArrLimits.TabIp = TabIp;
      tempArrLimits.BatchId = BatchId;
      tempArrLimits.Menus = menuObj;
    }

    let tempObjProdType = globalData.arrProductTypeArray.find((k) => k.DsNo == DsNo && TabIp == TabIp);
    if (tempObjProdType == undefined) {
      globalData.arrProductTypeArray.push({
        DsNo,
        TabIp,
        productType: productMasterRes,
        productDetail: productDetailsRes,
      });
    } else {
      tempObjProdType.DsNo = DsNo;
      tempObjProdType.TabIp = TabIp;
      tempObjProdType.productType = productMasterRes;
      tempObjProdType.productDetail = productDetailsRes;
    }

    if (hardnessInstrumentRes && mesRes.HTID != 'NA') {
      if ((hardnessInstrumentRes.Eqp_Model == "WHT 4" || hardnessInstrumentRes.Eqp_Model == "WHT4") && originalDS.Sys_RptType != 1 && (hardnessInstrumentRes.Eqp_Make == 'Pharmatest') && hardnessInstrumentRes.Eqp_Type == "Multi Tester") {
        const menuSequence = await models.tbl_menu_sequence.update({
          IND: null
        }, {
          where: {
            DS_Number: DsNo,
          }

        });
        // FTPInstrumentFound = true;
      }
    }
    return menuObj;
  }

  async makeMannualMenu(cubicalRes, productMasterRes, productDetailsRes, productSampleRes, TabIp, DsNo, selectedDsNo) {
    let menuObj = {}
    const arrHardnessColumn = [];
    const arrHardnessColumnDetail = [];
    // const BatchId = mesRes.BatchID;
    const productType = productMasterRes.ProductType;

    // get all Instrument of selected DS
    const originalDS = await models.tbl_cubical.findOne({
      where: {
        Sys_DSNumber: DsNo
      }
    })

    // Indivdual
    if (((cubicalRes.Sys_BalID != "None" && cubicalRes.Sys_BalID != null) || (originalDS.Sys_CubType == "IPQC" && originalDS.Sys_BalID != "None")) && (Number(productDetailsRes.Param1_T2Neg) != 99999 && Number(productDetailsRes.Param1_T2Neg) > 0) && (Number(productDetailsRes.Param1_T2Pos) != 99999 && Number(productDetailsRes.Param1_T2Pos) > 0)) {
      menuObj["Individual"] = {
        T2Neg: productDetailsRes.Param1_T2Neg,
        T2Pos: productDetailsRes.Param1_T2Pos,
        dp: 3,
        Unit: productDetailsRes.Param1_Unit,
        noOfSamples: productSampleRes.Individual
      };
    }

    // Group
    if (((cubicalRes.Sys_BalID != "None" && cubicalRes.Sys_BalID != null) || (originalDS.Sys_CubType == "Coating" && originalDS.Sys_BalID != "None"))) {
      menuObj["Group"] = {
        T2Neg: productDetailsRes?.Param2_T2Neg,
        T2Pos: productDetailsRes?.Param2_T2Pos,
        dp: 3,
        Unit: productDetailsRes?.Param2_Unit,
        noOfSamples: productSampleRes.Group
      };
    }

    if (((cubicalRes.Sys_BalID != "None" && cubicalRes.Sys_BalID != null) || (originalDS.Sys_CubType == "IPQC" && originalDS.Sys_BalID != "None")) && (Number(productDetailsRes.Param2_T2Neg) != 99999 && Number(productDetailsRes.Param2_T2Neg) > 0) && (Number(productDetailsRes.Param2_T2Pos) != 99999 && Number(productDetailsRes.Param2_T2Pos) > 0)) {
      menuObj["Group"] = {
        T2Neg: productDetailsRes.Param2_T2Neg,
        T2Pos: productDetailsRes.Param2_T2Pos,
        dp: 3,
        Unit: productDetailsRes.Param2_Unit,
        noOfSamples: productSampleRes.Group
      };
    }

    // Differemtial
    if (((cubicalRes.Sys_BalID != "None" && cubicalRes.Sys_BalID != null) || (originalDS.Sys_CubType == "IPQC" && originalDS.Sys_BalID != "None")) && (Number(productDetailsRes.Param3_T2Neg) != 99999 && Number(productDetailsRes.Param3_T2Neg) > 0) && (Number(productDetailsRes.Param3_T2Pos) != 99999 && Number(productDetailsRes.Param3_T2Pos) > 0)) {
      menuObj["Differential"] = {
        T2Neg: productDetailsRes.Param3_T2Neg,
        T2Pos: productDetailsRes.Param3_T2Pos,
        dp: 3,
        Unit: productDetailsRes.Param3_Unit,
        noOfSamples: productSampleRes.Group
      };
    }

    // Hardness
    if (((cubicalRes.Sys_HardID != "None" && cubicalRes.Sys_HardID != null) || (originalDS.Sys_CubType == "IPQC" && originalDS.Sys_HardID != "None")) && (Number(productDetailsRes.Param7_T2Neg) != 99999 && Number(productDetailsRes.Param7_T2Neg) > 0) && (Number(productDetailsRes.Param7_T2Pos) != 99999 && Number(productDetailsRes.Param7_T2Pos) > 0) && productType == 1) {
      menuObj["Hardness"] = {
        T2Neg: productDetailsRes.Param7_T2Neg,
        T2Pos: productDetailsRes.Param7_T2Pos,
        dp: productDetailsRes.Param7_Unit == "N" ? 0 : 1,
        Unit: productDetailsRes.Param7_Unit,
        noOfSamples: productSampleRes.Hardness
      };
    }

    // Thickness
    if ((Number(productDetailsRes.Param3_T2Neg) != 99999 && Number(productDetailsRes.Param3_T2Neg) > 0) && (Number(productDetailsRes.Param3_T2Pos) != 99999 && Number(productDetailsRes.Param3_T2Pos) > 0) && productType == 1) {
      menuObj["Thickness"] = {
        T2Neg: productDetailsRes.Param3_T2Neg,
        T2Pos: productDetailsRes.Param3_T2Pos,
        dp: 2,
        Unit: productDetailsRes.Param3_Unit,
        noOfSamples: productSampleRes.Thickness
      };
    }

    // Diameter
    if ((Number(productDetailsRes.Param6_T2Neg) != 99999 && Number(productDetailsRes.Param6_T2Neg) > 0) && (Number(productDetailsRes.Param6_T2Pos) != 99999 && Number(productDetailsRes.Param6_T2Pos) > 0) && productType == 1) {
      menuObj["Diameter"] = {
        T2Neg: productDetailsRes.Param6_T2Neg,
        T2Pos: productDetailsRes.Param6_T2Pos,
        dp: 2,
        Unit: productDetailsRes.Param6_Unit,
        noOfSamples: productSampleRes.Diameter
      };
    }

    // Length
    if ((Number(productDetailsRes.Param5_T2Neg) != 99999 && Number(productDetailsRes.Param5_T2Neg) > 0) && (Number(productDetailsRes.Param5_T2Pos) != 99999 && Number(productDetailsRes.Param5_T2Pos) > 0)) {
      let tempMenuName = "Length";
      if (productType == 2) {
        tempMenuName = "Locked Length";
      }
      menuObj[tempMenuName] = {
        T2Neg: productDetailsRes.Param5_T2Neg,
        T2Pos: productDetailsRes.Param5_T2Pos,
        dp: 2,
        Unit: productDetailsRes.Param5_Unit,
        noOfSamples: productSampleRes.Length
      };
    }

    // Friability
    if (productType == 1) {
      let isFriab = false;
      if (configFile.friabilityType == "OB" && ((cubicalRes.Sys_BalID != "None" && cubicalRes.Sys_BalID != null) || (originalDS.Sys_CubType == "IPQC" && originalDS.Sys_BalID != "None"))) {
        isFriab = true;
      } else {
        if (cubicalRes.Sys_FriabID != "None" && (Number(productDetailsRes.Param8_T1Neg) != 99999 && Number(productDetailsRes.Param8_T1Neg) > 0) && (Number(productDetailsRes.Param8_T1Pos) != 99999 && Number(productDetailsRes.Param8_T1Pos) > 0) && configFile.friabilityType == "OF") {
          isFriab = true;
        }
      }
      if (isFriab) {
        menuObj["Friability"] = {
          T2Neg: productDetailsRes.Param8_T1Neg,
          T2Pos: productDetailsRes.Param8_T1Pos,
          dp: 3,
          unit: productDetailsRes.Param8_Unit,
          noOfSamples: productSampleRes.Friability
        };
      }
    }

    // DT
    if (((cubicalRes.Sys_DTID != "None" && cubicalRes.Sys_DTID != null) || (originalDS.Sys_CubType == "IPQC" && originalDS.Sys_DTID != "None")) && (Number(productDetailsRes.Param13_T1Neg) != 99999 && Number(productDetailsRes.Param13_T1Neg) > 0) && (Number(productDetailsRes.Param13_T1Pos) != 99999 && Number(productDetailsRes.Param13_T1Pos) > 0) && productType == 1) {
      menuObj["DT"] = {
        T2Neg: productDetailsRes.Param13_T1Neg,
        T2Pos: productDetailsRes.Param13_T1Pos,
        dp: 3,
        unit: productDetailsRes.Param13_Unit,
        noOfSamples: productSampleRes.DT
      };
    }

    // LOD
    if ((cubicalRes.Sys_MoistID != "None" && cubicalRes.Sys_MoistID != null) || (originalDS.Sys_CubType == "IPQC" && originalDS.Sys_DTID != "None")) {
      menuObj["Loss on Dry"] = {
        dp: 3,
        unit: "g",
        // noOfSamples: productSampleRes.LOD
        noOfSamples: 0
      };
    }

    if (menuObj.hasOwnProperty("Hardness")) {
      arrHardnessColumn.push("Hardness")
      arrHardnessColumnDetail.push({ Hardness: menuObj.Hardness })

      if (menuObj.hasOwnProperty("Thickness")) {
        arrHardnessColumn.push("Thickness")
        arrHardnessColumnDetail.push({ Thickness: menuObj.Thickness })
      }

      if (menuObj.hasOwnProperty("Diameter")) {
        arrHardnessColumn.push("Diameter")
        arrHardnessColumnDetail.push({ Diameter: menuObj.Diameter })
      }

      if (menuObj.hasOwnProperty("Length")) {
        arrHardnessColumn.push("Length")
        arrHardnessColumnDetail.push({ Length: menuObj.Length })
      }

      menuObj["Hardness"] = {
        arrHardnessColumn,
        arrHardnessColumnDetail
      }
    }

    if ((cubicalRes.Sys_VernierID == null || cubicalRes.Sys_VernierID == "None") || (originalDS.Sys_CubType == "IPQC" && originalDS.Sys_VernierID == "None")) {
      delete menuObj["Thickness"];
      delete menuObj["Diameter"];
      delete menuObj["Length"];
    }

    if ((cubicalRes.Sys_LeakID != null || cubicalRes.Sys_LeakID != "None") && productType == 1) {
      menuObj["Leak Test"] = {};
    }

    console.log('menuObj: ', menuObj);

    let tempArrLimits = globalData.arr_limits.find((k) => k.DsNo == DsNo && k.TabIp == TabIp);
    if (!tempArrLimits) {
      globalData.arr_limits.push({
        DsNo,
        TabIp,
        BatchId: cubicalRes.Sys_Batch,
        Menus: menuObj
      })
    } else {
      tempArrLimits.DsNo = DsNo;
      tempArrLimits.TabIp = TabIp;
      tempArrLimits.BatchId = cubicalRes.Sys_Batch;
      tempArrLimits.Menus = menuObj;
    }

    let tempObjProdType = globalData.arrProductTypeArray.find((k) => k.DsNo == DsNo && TabIp == TabIp);
    if (tempObjProdType == undefined) {
      globalData.arrProductTypeArray.push({
        DsNo,
        TabIp,
        productType: productMasterRes,
        productDetail: productDetailsRes,
      });
    } else {
      tempObjProdType.DsNo = DsNo;
      tempObjProdType.TabIp = TabIp;
      tempObjProdType.productType = productMasterRes;
      tempObjProdType.productDetail = productDetailsRes;
    }

    return menuObj;
  }

  // async makeMannualMenu(cubicalRes, productMasterRes, productDetailsRes, productSampleRes, TabIp, DsNo) {
  //   let menuObj = {}
  //   const arrHardnessColumn = [];
  //   const arrHardnessColumnDetail = [];
  //   const BatchId = cubicalRes.Sys_Batch;

  //   // Indivdual
  //   if (cubicalRes.Sys_BalID != "None" && (Number(productDetailsRes.Param1_T2Neg) != 99999 && Number(productDetailsRes.Param1_T2Neg) > 0) && (Number(productDetailsRes.Param1_T2Pos) != 99999 && Number(productDetailsRes.Param1_T2Pos) > 0)) {
  //     menuObj["Individual"] = {
  //       T2Neg: productDetailsRes.Param1_T2Neg,
  //       T2Pos: productDetailsRes.Param1_T2Pos,
  //       dp: 3,
  //       Unit: productDetailsRes.Param1_Unit,
  //       noOfSamples: productSampleRes.Individual
  //     };
  //   }

  //   // Group
  //   if (cubicalRes.Sys_BalID != "None" && (Number(productDetailsRes.Param2_T2Neg) != 99999 && Number(productDetailsRes.Param2_T2Neg) > 0) && (Number(productDetailsRes.Param2_T2Pos) != 99999 && Number(productDetailsRes.Param2_T2Pos) > 0)) {
  //     menuObj["Group"] = {
  //       T2Neg: productDetailsRes.Param2_T2Neg,
  //       T2Pos: productDetailsRes.Param2_T2Pos,
  //       dp: 3,
  //       Unit: productDetailsRes.Param2_Unit,
  //       noOfSamples: productSampleRes.Group
  //     };
  //   }

  //   // Hardness
  //   if (cubicalRes.Sys_HardID != "None" && (Number(productDetailsRes.Param7_T2Neg) != 99999 && Number(productDetailsRes.Param7_T2Neg) > 0) && (Number(productDetailsRes.Param7_T2Pos) != 99999 && Number(productDetailsRes.Param7_T2Pos) > 0)) {
  //     menuObj["Hardness"] = {
  //       T2Neg: productDetailsRes.Param7_T2Neg,
  //       T2Pos: productDetailsRes.Param7_T2Pos,
  //       dp: productDetailsRes.Param7_Unit == "N" ? 0 : 1,
  //       Unit: productDetailsRes.Param7_Unit,
  //       noOfSamples: productSampleRes.Hardness
  //     };
  //   }

  //   // Thickness
  //   if ((Number(productDetailsRes.Param3_T2Neg) != 99999 && Number(productDetailsRes.Param3_T2Neg) > 0) && (Number(productDetailsRes.Param3_T2Pos) != 99999 && Number(productDetailsRes.Param3_T2Pos) > 0)) {
  //     menuObj["Thickness"] = {
  //       T2Neg: productDetailsRes.Param3_T2Neg,
  //       T2Pos: productDetailsRes.Param3_T2Pos,
  //       dp: 2,
  //       Unit: productDetailsRes.Param3_Unit,
  //       noOfSamples: productSampleRes.Thickness
  //     };
  //   }

  //   // Diameter
  //   if ((Number(productDetailsRes.Param6_T2Neg) != 99999 && Number(productDetailsRes.Param6_T2Neg) > 0) && (Number(productDetailsRes.Param6_T2Pos) != 99999 && Number(productDetailsRes.Param6_T2Pos) > 0)) {
  //     menuObj["Diameter"] = {
  //       T2Neg: productDetailsRes.Param6_T2Neg,
  //       T2Pos: productDetailsRes.Param6_T2Pos,
  //       dp: 2,
  //       Unit: productDetailsRes.Param6_Unit,
  //       noOfSamples: productSampleRes.Diameter
  //     };
  //   }

  //   // Length
  //   if ((Number(productDetailsRes.Param5_T2Neg) != 99999 && Number(productDetailsRes.Param5_T2Neg) > 0) && (Number(productDetailsRes.Param5_T2Pos) != 99999 && Number(productDetailsRes.Param5_T2Pos) > 0)) {
  //     menuObj["Length"] = {
  //       T2Neg: productDetailsRes.Param5_T2Neg,
  //       T2Pos: productDetailsRes.Param5_T2Pos,
  //       dp: 2,
  //       Unit: productDetailsRes.Param5_Unit,
  //       noOfSamples: productSampleRes.Length
  //     };
  //   }

  //   // Friability
  //   let isFriab = false;
  //   if (configFile.friabilityType == "OB" && cubicalRes.Sys_BalID != "None") {
  //     isFriab = true;
  //   } else {
  //     if (cubicalRes.Sys_FriabID != "None" && (Number(productDetailsRes.Param8_T1Neg) != 99999 && Number(productDetailsRes.Param8_T1Neg) > 0) && (Number(productDetailsRes.Param8_T1Pos) != 99999 && Number(productDetailsRes.Param8_T1Pos) > 0) && configFile.friabilityType == "OF") {
  //       isFriab = true;
  //     }
  //   }
  //   if (isFriab) {
  //     menuObj["Friability"] = {
  //       T2Neg: productDetailsRes.Param8_T1Neg,
  //       T2Pos: productDetailsRes.Param8_T1Pos,
  //       dp: 3,
  //       unit: productDetailsRes.Param8_Unit,
  //       noOfSamples: productSampleRes.Friability
  //     };
  //   }

  //   // Disintegration Test
  //   if (cubicalRes.Sys_FriabID != "None" && (Number(productDetailsRes.Param13_T1Neg) != 99999 && Number(productDetailsRes.Param13_T1Neg) > 0) && (Number(productDetailsRes.Param13_T1Pos) != 99999 && Number(productDetailsRes.Param13_T1Pos) > 0)) {
  //     menuObj["DT"] = {
  //       T2Neg: productDetailsRes.Param13_T1Neg,
  //       T2Pos: productDetailsRes.Param13_T1Pos,
  //       dp: 3,
  //       unit: productDetailsRes.Param13_Unit,
  //       noOfSamples: productSampleRes.DT
  //     };
  //   }

  //   // LOD
  //   if (cubicalRes.Sys_MoistID != "None" && cubicalRes.Sys_MoistID) {
  //     menuObj["LOD"] = {
  //       dp: 3,
  //       unit: "g",
  //       noOfSamples: productSampleRes.DT
  //     };
  //   }

  //   if (menuObj.hasOwnProperty("Hardness")) {
  //     arrHardnessColumn.push("Hardness")
  //     arrHardnessColumnDetail.push({ Hardness: menuObj.Hardness })

  //     if (menuObj.hasOwnProperty("Thickness")) {
  //       arrHardnessColumn.push("Thickness")
  //       arrHardnessColumnDetail.push({ Thickness: menuObj.Thickness })
  //     }

  //     if (menuObj.hasOwnProperty("Diameter")) {
  //       arrHardnessColumn.push("Diameter")
  //       arrHardnessColumnDetail.push({ Diameter: menuObj.Diameter })
  //     }

  //     if (menuObj.hasOwnProperty("Length")) {
  //       arrHardnessColumn.push("Length")
  //       arrHardnessColumnDetail.push({ Length: menuObj.Length })
  //     }

  //     menuObj["Hardness"] = {
  //       arrHardnessColumn,
  //       arrHardnessColumnDetail
  //     }
  //   }

  //   if (cubicalRes.Sys_VernierID == "None" || !cubicalRes.Sys_VernierID) {
  //     delete menuObj["Thickness"];
  //     delete menuObj["Diameter"];
  //     delete menuObj["Length"];
  //   }

  //   console.log('menuObj: ', menuObj);

  //   let tempArrLimits = globalData.arr_limits.find((k) => k.DsNo == DsNo && k.TabIp == TabIp);
  //   if (!tempArrLimits) {
  //     globalData.arr_limits.push({
  //       DsNo,
  //       TabIp,
  //       BatchId,
  //       Menus: menuObj
  //     })
  //   } else {
  //     tempArrLimits.DsNo = DsNo;
  //     tempArrLimits.TabIp = TabIp;
  //     tempArrLimits.BatchId = BatchId;
  //     tempArrLimits.Menus = menuObj;
  //   }

  //   let tempObjProdType = globalData.arrProductTypeArray.find((k) => k.DsNo == DsNo && TabIp == TabIp);
  //   if (tempObjProdType == undefined) {
  //     globalData.arrProductTypeArray.push({
  //       DsNo,
  //       TabIp,
  //       productType: productMasterRes,
  //       productDetail: productDetailsRes,
  //     });
  //   } else {
  //     tempObjProdType.DsNo = DsNo;
  //     tempObjProdType.TabIp = TabIp;
  //     tempObjProdType.productType = productMasterRes;
  //     tempObjProdType.productDetail = productDetailsRes;
  //   }

  //   return menuObj;
  // }

  // async updateProductLimits(productMasterResponse, mesDataResponse) {
  //   try {
  //     await models.tbl_product_tablet.update(
  //       {
  //         // Individual
  //         Param1_T2Neg: Number(mesDataResponse.IndWtLow) != 99999 ? mesDataResponse.IndWtLow : 99999,
  //         Param1_T2Pos: Number(mesDataResponse.IndWtHigh) != 99999 ? mesDataResponse.IndWtHigh : 99999,
  //         // Group
  //         Param2_T2Neg: Number(mesDataResponse.GrpWtLow) != 99999 ? mesDataResponse.GrpWtLow : 99999,
  //         Param2_T2Pos: Number(mesDataResponse.GrpWtHigh) != 99999 ? mesDataResponse.GrpWtHigh : 99999,
  //         // Thickness
  //         Param3_T2Neg: Number(mesDataResponse.ThicknessLow) != 99999 ? mesDataResponse.ThicknessLow : 99999,
  //         Param3_T2Pos: Number(mesDataResponse.ThicknessHigh) != 99999 ? mesDataResponse.ThicknessHigh : 99999,
  //         // Diameter
  //         Param6_T2Pos: Number(mesDataResponse.HardDiameterLow) != 99999 ? mesDataResponse.HardDiameterLow : 99999,
  //         Param6_T2Neg: Number(mesDataResponse.HardDiameterHigh) != 99999 ? mesDataResponse.HardDiameterHigh : 99999,
  //         // Length
  //         Param5_T2Pos: Number(mesDataResponse.LengthLow) != 99999 ? mesDataResponse.LengthLow : 99999,
  //         Param5_T2Neg: Number(mesDataResponse.LengthHigh) != 99999 ? mesDataResponse.LengthHigh : 99999,
  //         // Hardness
  //         Param7_T2Neg: Number(mesDataResponse.HardnessLow) != 99999 ? mesDataResponse.HardnessLow : 99999,
  //         Param7_T2Pos: Number(mesDataResponse.HardnessHigh) != 99999 ? mesDataResponse.HardnessHigh : 99999,
  //         // LOD
  //         Param16_T1Neg: Number(mesDataResponse.InitialWeight) != 99999 ? mesDataResponse.InitialWeight : 99999,
  //         Param16_T1Pos: Number(mesDataResponse.FinalWeight) != 99999 ? mesDataResponse.FinalWeight : 99999,
  //       }, {
  //       where: {
  //         // tab_id: productMasterResponse.Id,
  //         ProductId: productMasterResponse.ProductId,
  //         ProductName: productMasterResponse.ProductName,
  //       }
  //     });
  //   } catch (error) {
  //     console.log('error: ', error);
  //   }
  // }

  // async sendMenu(topic) {
  //   try {
  //     var productInfo = globalData.postMessageData;
  //     if (productInfo !== undefined) {
  //       var BatchId = productInfo.BatchId;
  //       var processMenu = [];
  //       var obj = {};
  //       var idsInfo = globalData.arrIdsInfo.find((k) => k.Hmi === strHmi);
  //       await this.lockedWeighingStatus(arrResCubicalObj[0][0].Sys_CubicNo, arrResCubicalObj[0][0].Sys_Batch, arrResCubicalObj[0][0].Sys_CubType)
  //       var menuAccordingToLimit = this.MesDataMenuMaking(productInfo);
  //       processMenu = menuAccordingToLimit;
  //       globalData.arr_limits.push(LimitObj);
  //       MQTTSender.sendData(topic, `menu:${processMenu.toString()}`);
  //     }
  //   } catch (error) {
  //     throw new Error(error);
  //   }
  // }

  // async MesDataMenuMaking() {
  //   var arrLimits = globalData.arr_limits.find((k) => k.BatchId === BatchId);

  //   globalData.arr_limits.findIndex(
  //     (element) => element.BatchId === BatchId
  //   ) !== -1
  //     ? globalData.arr_limits.splice(
  //       globalData.arr_limits.findIndex((k) => k.BatchId === BatchId),
  //       1
  //     )
  //     : globalData.arr_limits;
  //   var LimitObj = Object.assign(obj, {
  //     BatchId: BatchId,
  //   });

  //   var postMessageData = globalData.postMessageData;

  //   var MenuAccordingToParamsSet = Promise.all(
  //     Object.keys(postMessageData).map(async (data) => {
  //       let obj = {};
  //       let objCalibratedBal = globalData.glbArrListOfCalibratedBal.find(
  //         (k) => k.Hmi == strHmi
  //       );
  //       switch (data) {
  //         // case "MoistureEquipmentId":
  //         //   if (
  //         //     productInfo["MoistureEquipmentId"] !== undefined &&
  //         //     productInfo["MoistureEquipmentId"] !== null &&
  //         //     productInfo["MoistureEquipmentId"].length !== 0 &&
  //         //     productInfo["MoistureEquipmentId"].toUpperCase() !== "NULL" &&
  //         //     productInfo["MoistureEquipmentId"].toUpperCase() !== "NA"
  //         //   ) {
  //         //     obj["LOD"] = {};
  //         //   }
  //         //   break;
  //         case "IndWtEqmID":
  //           if (
  //             productInfo["IndWtEqmID"] !== undefined &&
  //             productInfo["IndWtEqmID"] !== null &&
  //             productInfo["IndWtEqmID"].length !== 0 &&
  //             productInfo["IndWtEqmID"].toUpperCase() !== "NULL" &&
  //             productInfo["IndWtEqmID"].toUpperCase() !== "NA"
  //           ) {
  //             if (
  //               productInfo["IndWtLow"] !== undefined &&
  //               productInfo["IndWtLow"] !== null &&
  //               productInfo["IndWtLow"].length !== 0 &&
  //               productInfo["IndWtLow"].toUpperCase() !== "NULL" &&
  //               productInfo["IndWtLow"].toUpperCase() !== "NA" &&
  //               Number(productInfo["IndWtLow"]) > 0 &&
  //               productInfo["IndWtHigh"] !== undefined &&
  //               productInfo["IndWtHigh"] !== null &&
  //               productInfo["IndWtHigh"].length !== 0 &&
  //               productInfo["IndWtHigh"].toUpperCase() !== "NULL" &&
  //               productInfo["IndWtHigh"].toUpperCase() !== "NA" &&
  //               Number(productInfo["IndWtHigh"]) > 0 &&
  //               Number(productInfo["IndWtHigh"]) >
  //               Number(productInfo["IndWtLow"])
  //             ) {
  //               obj["Individual"] = {
  //                 T2Neg: productInfo["IndWtLow"],
  //                 T2Pos: productInfo["IndWtHigh"],
  //                 DP: 3,
  //               };
  //             }
  //           }
  //           break;
  //         case "GrpWtEqmID":
  //           if (
  //             productInfo["GrpWtEqmID"] !== undefined &&
  //             productInfo["GrpWtEqmID"] !== null &&
  //             productInfo["GrpWtEqmID"].length !== 0 &&
  //             productInfo["GrpWtEqmID"].toUpperCase() !== "NULL" &&
  //             productInfo["GrpWtEqmID"].toUpperCase() !== "NA"
  //           ) {
  //             if (
  //               productInfo["GrpWtLow"] !== undefined &&
  //               productInfo["GrpWtLow"] !== null &&
  //               productInfo["GrpWtLow"].length !== 0 &&
  //               productInfo["GrpWtLow"].toUpperCase() !== "NULL" &&
  //               productInfo["GrpWtLow"].toUpperCase() !== "NA" &&
  //               Number(productInfo["GrpWtLow"]) > 0 &&
  //               productInfo["GrpWtHigh"] !== undefined &&
  //               productInfo["GrpWtHigh"] !== null &&
  //               productInfo["GrpWtHigh"].length !== 0 &&
  //               productInfo["GrpWtHigh"].toUpperCase() !== "NULL" &&
  //               productInfo["GrpWtHigh"].toUpperCase() !== "NA" &&
  //               Number(productInfo["GrpWtHigh"]) > 0 &&
  //               Number(productInfo["GrpWtHigh"]) >
  //               Number(productInfo["GrpWtLow"])
  //             ) {
  //               obj["Group"] = {
  //                 T2Neg: productInfo["GrpWtLow"],
  //                 T2Pos: productInfo["GrpWtHigh"],
  //                 DP: 3,
  //               };
  //             }
  //           }
  //           break;
  //         case "HTID":
  //           if (
  //             productInfo["HTID"] !== undefined &&
  //             productInfo["HTID"] !== null &&
  //             productInfo["HTID"].length !== 0 &&
  //             productInfo["HTID"].toUpperCase() !== "NULL" &&
  //             productInfo["HTID"].toUpperCase() !== "NA"
  //           ) {
  //             if (
  //               productInfo["ThicknessLow"] !== undefined &&
  //               productInfo["ThicknessLow"] !== null &&
  //               productInfo["ThicknessLow"].length !== 0 &&
  //               productInfo["ThicknessLow"].toUpperCase() !== "NULL" &&
  //               productInfo["ThicknessLow"].toUpperCase() !== "NA" &&
  //               Number(productInfo["ThicknessLow"]) > 0 &&
  //               productInfo["ThicknessHigh"] !== undefined &&
  //               productInfo["ThicknessHigh"] !== null &&
  //               productInfo["ThicknessHigh"].length !== 0 &&
  //               productInfo["ThicknessHigh"].toUpperCase() !== "NULL" &&
  //               productInfo["ThicknessHigh"].toUpperCase() !== "NA" &&
  //               productInfo["GrpWtHigh"].toUpperCase() !== "NA" &&
  //               Number(productInfo["ThicknessHigh"]) > 0 &&
  //               Number(productInfo["ThicknessHigh"]) >
  //               Number(productInfo["ThicknessLow"])
  //             ) {
  //               obj["Thickness"] = {
  //                 T2Neg: productInfo["ThicknessLow"],
  //                 T2Pos: productInfo["ThicknessHigh"],
  //                 DP: 2,
  //               };
  //             }
  //           }
  //           break;
  //         case "HTID":
  //           if (
  //             productInfo["HTID"] !== undefined &&
  //             productInfo["HTID"] !== null &&
  //             productInfo["HTID"].length !== 0 &&
  //             productInfo["HTID"].toUpperCase() !== "NULL" &&
  //             productInfo["HTID"].toUpperCase() !== "NA"
  //           ) {
  //             if (
  //               productInfo["HardnessLow"] !== undefined &&
  //               productInfo["HardnessLow"] !== null &&
  //               productInfo["HardnessLow"].length !== 0 &&
  //               productInfo["HardnessLow"].toUpperCase() !== "NULL" &&
  //               productInfo["HardnessLow"].toUpperCase() !== "NA" &&
  //               Number(productInfo["HardnessLow"]) > 0 &&
  //               productInfo["HardnessHigh"] !== undefined &&
  //               productInfo["HardnessHigh"] !== null &&
  //               productInfo["HardnessHigh"].length !== 0 &&
  //               productInfo["HardnessHigh"].toUpperCase() !== "NULL" &&
  //               productInfo["HardnessHigh"].toUpperCase() !== "NA" &&
  //               Number(productInfo["HardnessHigh"]) > 0 &&
  //               Number(productInfo["HardnessHigh"]) >
  //               Number(productInfo["HardnessLow"])
  //             ) {
  //               obj["Hardness"] = {
  //                 T2Neg: productInfo["HardnessLow"],
  //                 T2Pos: productInfo["HardnessHigh"],
  //                 DP: 2,
  //               };
  //             }
  //           }
  //           break;
  //         case "DTID":
  //           if (
  //             productInfo["DTID"] !== undefined &&
  //             productInfo["DTID"] !== null &&
  //             productInfo["DTID"].length !== 0 &&
  //             productInfo["DTID"].toUpperCase() !== "NULL" &&
  //             productInfo["DTID"].toUpperCase() !== "NA"
  //           ) {
  //             if (
  //               productInfo["DisintegrationLow"] !== undefined &&
  //               productInfo["DisintegrationLow"] !== null &&
  //               productInfo["DisintegrationLow"].length !== 0 &&
  //               productInfo["DisintegrationLow"].toUpperCase() !== "NULL" &&
  //               productInfo["DisintegrationLow"].toUpperCase() !== "NA" &&
  //               Number(productInfo["DisintegrationLow"]) > 0 &&
  //               productInfo["DisintegrationHigh"] !== undefined &&
  //               productInfo["DisintegrationHigh"] !== null &&
  //               productInfo["DisintegrationHigh"].length !== 0 &&
  //               productInfo["DisintegrationHigh"].toUpperCase() !== "NULL" &&
  //               productInfo["DisintegrationHigh"].toUpperCase() !== "NA" &&
  //               Number(productInfo["DisintegrationHigh"]) > 0 &&
  //               Number(productInfo["DisintegrationHigh"]) >
  //               Number(productInfo["DisintegrationLow"])
  //             ) {
  //               obj["DT"] = {
  //                 T2Neg: productInfo["DisintegrationLow"],
  //                 T2Pos: productInfo["DisintegrationHigh"],
  //                 DP: 2,
  //               };
  //             }
  //           }
  //           break;
  //       }

  //       // if (Object.keys(obj).length != 0 && obj.constructor === Object) {
  //       //   return obj;
  //       // }

  //       return obj;
  //     })
  //   );

  //   return MenuAccordingToParamsSet;
  // }

  async processCubical(objCubicalData, strIdsNo, Ip) {
    try {
      let Product = objCubicalData.Product;
      let cubicalObj = globalData.arrIdsInfo.find(
        (k) => k.Ip == Ip
      ).cubicalData; //current
      let strHmi = objCubicalData.Hmi;
      let idsNo = objCubicalData.IdsNo;
      let selectedIdsNo;
      var IPQCObject = globalData.arr_IPQCRelIds.find((k) => k.idsNo == idsNo);
      if (IPQCObject != undefined) {
        selectedIdsNo = IPQCObject.selectedIds;
      } else {
        selectedIdsNo = strIdsNo;
      }
      let objCubicalData1 = globalData.arrIdsInfo.find(
        (k) => k.Ip == Ip
      ).cubicalData;
      let cubicalArea = objCubicalData1.Sys_Area;
      var selectedHmi = await objHmiModel.getHmiNoFromResbPi(selectedIdsNo);

      //check cubical product combination in product master
      const selectProductMaster = await models.tbl_product_master.findAll({
        where: {
          ProductName: Product.ProductName,
          ProductId: Product.ProductId,
          ProductVersion: Product.ProductVersion,
          Version: Product.Version,
        },
      });
      let arrResProductMaster = [selectProductMaster];
      if (arrResProductMaster[0].length < 0) {
        console.log("Cubical product does not match in product master ");
        return;
      }
      let productType = arrResProductMaster[0][0].ProductType;
      //check productType
      let tableName;
      let TableName;
      let tableGran;
      if (productType == 1) {
        switch (cubicalArea) {
          case "Compression":
          case "Effervescent Compression":
          case "IPQC":
          case "IPC":
          case "Granulation":
            tableName = "tbl_product_tablet";
            TableName = models.tbl_product_tablet;
            tableGran = models.tbl_product_gran;
            break;

          // case 'Effervescent Granulation':
          // case 'Granulation':
          //     tableName = 'tbl_product_gran';
          //     TableName = models.tbl_product_gran
          //     break;
        }
      }
      const selectObj = await TableName.findAll({
        where: {
          ProductName: Product.ProductName,
          ProductId: Product.ProductId,
          ProductVersion: Product.ProductVersion,
          Version: Product.Version,
        },
      });

      var Obj = await tableGran.findAll({
        where: {
          ProductName: Product.ProductName,
          ProductId: Product.ProductId,
          ProductVersion: Product.ProductVersion,
          Version: Product.Version,
        },
      });
      if (Obj.length != 0 && selectObj.length != 0) {
        delete Obj[0].Param1_Nom;
        delete Obj[0].Param2_Nom;
        var detail = Object.assign(selectObj[0], Obj[0]);
        var arrResOfProductDetail = [[detail]];
      } else {
        var arrResOfProductDetail = [[selectObj[0]]];
        if (arrResOfProductDetail[0][0] == undefined) {
          var Obj = await tableGran.findAll({
            where: {
              ProductName: Product.ProductName,
              ProductId: Product.ProductId,
              ProductVersion: Product.ProductVersion,
              Version: Product.Version,
            },
          });
          var arrResOfProductDetail = [[Obj[0]]];
        }
      }

      // const selectObj = await TableName.findAll({
      //     where: {
      //         ProductName: Product.ProductName,
      //         ProductId: Product.ProductId,
      //         ProductVersion: Product.ProductVersion,
      //         Version: Product.Version
      //     }
      // })
      // let arrResOfProductDetail = [[selectObj[0]]];
      let tempObjProdType = globalData.arrProductTypeArray.find(
        (k) => k.Ip == Ip
      );
      if (tempObjProdType == undefined) {
        globalData.arrProductTypeArray.push({
          Hmi: selectedHmi,
          idsNo: selectedIdsNo,
          productType: arrResProductMaster[0][0],
          productDetail: arrResOfProductDetail,
          Ip: Ip,
        });
      } else {
        tempObjProdType.productType = arrResProductMaster[0][0];
        tempObjProdType.productDetail = arrResOfProductDetail;
      }

      const selctProductSamples =
        await models.tbl_cubicle_product_sample.findAll({
          where: {
            Sys_CubicNo: objCubicalData1.Sys_CubicNo,
          },
        });
      let arrProductSample = [selctProductSamples];

      //according to instrument connect give menu
      let port1 = cubicalObj.Sys_Port1;
      let port2 = cubicalObj.Sys_Port2;
      let port3 = cubicalObj.Sys_Port3;
      let port4 = cubicalObj.Sys_Port4;
      let uniqueSet;
      let tempPortsArr = [port1, port2, port3, port4];
      let removedNoneFromArr = tempPortsArr.filter((f) => f !== "None");

      let MenusToBeShown = await Promise.all(
        removedNoneFromArr.map((instrument, index) => {
          let __Paramsobj = {
            instrument: instrument,
            ProductDetail: arrResOfProductDetail,
            Hmi: strHmi,
            idsNo: idsNo,
            prdType: productType,
            PortNo: index + 1,
            Samples: arrProductSample[0][0],
          };
          return this.CheckParamsSet(__Paramsobj, strIdsNo, Ip);
        })
      );

      MenusToBeShown = [].concat.apply([], MenusToBeShown);
      MenusToBeShown = MenusToBeShown.filter((menu) => menu != undefined);
      MenusToBeShown = MenusToBeShown.map(JSON.stringify);
      /**
       * Set will remove Duplicate obj from array.
       */
      uniqueSet = [...new Set(MenusToBeShown)];
      //to put groupind last

      var element = uniqueSet.filter((k) => k.indexOf("GRPIND") !== -1);
      if (element != undefined && element.length != 0) {
        var CutIndx = uniqueSet.findIndex((x) => x == element);
        var PutIndx = Object.keys(uniqueSet).length;
        uniqueSet.splice(CutIndx, 1);
        uniqueSet.splice(PutIndx, 0, element);
      }
      //
      MenusToBeShown = Array.from(uniqueSet).map(JSON.parse);

      // console.log(MenusToBeShown);

      let glbArr = globalData.arr_limits.find((k) => k.Ip == Ip);
      if (glbArr == undefined) {
        globalData.arr_limits.push({
          Hmi: strHmi,
          idsNo: idsNo,
          Menus: MenusToBeShown,
          Ip: Ip,
        });
      } else {
        glbArr.idsNo = idsNo;
        glbArr.Menus = MenusToBeShown;
      }
      MenusToBeShown = MenusToBeShown.map((e, index) => {
        if (Object.keys(e).length > 1) {
          return Object.getOwnPropertyNames(e).toString().split(",");
        } else {
          return Object.getOwnPropertyNames(e)[0];
        }
      });
      return MenusToBeShown.toString().split(",");
    } catch (error) {
      throw new Error(error);
    }
  }

  async CheckParamsSet(values, strIdsNo, Ip) {
    try {
      let strInstrument = values.instrument;
      let result;
      switch (strInstrument.toUpperCase()) {
        case "BALANCE":
        case "IPC BALANCE":
          result = await this.streamDataMenuMaking(values, strIdsNo, Ip);
          break;
        case "VERNIER":
          result = await this.streamDataMenuMaking(values, strIdsNo);
          break;
        case "TBTTST":
        case "TABLET TESTER":
        case "HARDNESS":
          result = await this.bulkDataMenuMaking(values, strIdsNo, Ip);
          break;
        case "FRIABILATOR":
          result = await this.bulkDataMenuMaking(values, strIdsNo);
          break;
        case "DISINTEGRATION TESTER":
          result = this.bulkDataMenuMaking(values, strIdsNo);
          break;
        case "MOISTURE ANALYZER":
          result = this.bulkDataMenuMaking(values, strIdsNo, Ip);
          break;
        case "TAPPED DENSITY":
          result = this.bulkDataMenuMaking(values, strIdsNo);
          break;
        case "EMPTY SHELL":
          result = this.EmptyShellStart(values, strIdsNo);
      }
      return result;
    } catch (error) {
      throw new Error(error);
    }
  }

  async streamDataMenuMaking(values, currentIdsNo, Ip) {
    try {
      let strInstrument = values.instrument;
      let strHmi = values.Hmi;
      let intPortNo = values.PortNo;
      let arrProductDetail = values.ProductDetail;
      let objSamples = values.Samples;
      let intProductType = values.prdType;
      const cubicObj = globalData.arrIdsInfo.find((k) => k.Ip == Ip);
      let IdsNo = cubicObj.idsNo;
      let objCalibratedBalIPC;
      let objCalibratedBalAnalytical;
      let selectedIdsNo;
      var IPQCObject = globalData.arr_IPQCRelIds.find((k) => k.idsNo == IdsNo);
      if (IPQCObject != undefined) {
        selectedIdsNo = IPQCObject.selectedIds;
      } else {
        selectedIdsNo = IdsNo;
      }
      let MenuAccordingToParamsSet = await Promise.all(
        Object.keys(arrProductDetail[0][0]).map(async (data) => {
          let obj = {};
          let objCalibratedBal = globalData.glbArrListOfCalibratedBal.find(
            (k) => k.idsNo == currentIdsNo
          );
          if (objCalibratedBal != undefined) {
            objCalibratedBalAnalytical =
              objCalibratedBal.CalibratedBalList.filter(
                (k) => k.balType != "IPC Balance"
              );
            objCalibratedBalIPC = objCalibratedBal.CalibratedBalList.filter(
              (k) => k.balType == "IPC Balance"
            );
          } else {
            objCalibratedBalAnalytical = [];
            objCalibratedBalIPC = [];
          }

          switch (data) {
            case "Param1_Nom": //Individual
              if (
                parseFloat(arrProductDetail[0][0][data]) > 0 &&
                parseFloat(arrProductDetail[0][0][data]) != 99999
              ) {
                if (
                  (intProductType == 1 || intProductType == 2) &&
                  cubicObj.cubicalData.Sys_BalID != "None" &&
                  strInstrument == "Balance"
                ) {
                  let unit = await this.getBalanceUnit(
                    cubicObj.cubicalData.Sys_BalID
                  );
                  console.log(unit);
                  obj[`${GLOBAL_NOMENCLATURE.IndividualMenu}`] = {
                    nominal: arrProductDetail[0][0].Param1_Nom,
                    T1Neg: arrProductDetail[0][0].Param1_T1Neg,
                    T1Pos: arrProductDetail[0][0].Param1_T1Pos,
                    T2Neg: arrProductDetail[0][0].Param1_T2Neg,
                    T2Pos: arrProductDetail[0][0].Param1_T2Pos,
                    LimitOn: arrProductDetail[0][0].Param1_LimitOn,
                    dp: arrProductDetail[0][0].Param1_DP,
                    isonstd: arrProductDetail[0][0].Param1_IsOnStd,
                    noOfSamples: objSamples.Individual,
                    NMT: arrProductDetail[0][0].Param1_NMTTab,
                    ProductType: intProductType,
                    unit: arrProductDetail[0][0].Param1_Unit,
                  };
                } else if (
                  intProductType == 3 &&
                  cubicObj.cubicalData.Sys_BalID != "None" &&
                  strInstrument == "Balance"
                ) {
                  if (arrProductDetail[0][0].MutihalerType[0] == 1) {
                    (obj[GLOBAL_NOMENCLATURE.dryCart] = {
                      nominal: arrProductDetail[0][0].Param1_Nom,
                      T1Neg: arrProductDetail[0][0].Param1_T1Neg,
                      T1Pos: arrProductDetail[0][0].Param1_T1Pos,
                      T2Neg: arrProductDetail[0][0].Param1_T2Neg,
                      T2Pos: arrProductDetail[0][0].Param1_T2Pos,
                      LimitOn: arrProductDetail[0][0].Param1_LimitOn,
                      dp: arrProductDetail[0][0].Param1_DP,
                      isonstd: arrProductDetail[0][0].Param1_IsOnStd,
                      noOfSamples: objSamples.Individual,
                      NMT: arrProductDetail[0][0].Param1_NMTTab,
                      ProductType: intProductType,
                    }),
                      (obj[GLOBAL_NOMENCLATURE.netCart] = {
                        nominal: arrProductDetail[0][0].Param1_Nom,
                        T1Neg: arrProductDetail[0][0].Param1_T1Neg,
                        T1Pos: arrProductDetail[0][0].Param1_T1Pos,
                        T2Neg: arrProductDetail[0][0].Param1_T2Neg,
                        T2Pos: arrProductDetail[0][0].Param1_T2Pos,
                        LimitOn: arrProductDetail[0][0].Param1_LimitOn,
                        dp: arrProductDetail[0][0].Param1_DP,
                        isonstd: arrProductDetail[0][0].Param1_IsOnStd,
                        noOfSamples: objSamples.Individual,
                        NMT: arrProductDetail[0][0].Param1_NMTTab,
                        ProductType: intProductType,
                      });
                  } else {
                    //for Dpi Strip
                    let unit = await this.getBalanceUnit(
                      cubicObj.cubicalData.Sys_BalID
                    );
                    // console.log(unit)
                    obj[GLOBAL_NOMENCLATURE.dryPowder] = {
                      nominal: arrProductDetail[0][0].Param1_Nom,
                      T1Neg: arrProductDetail[0][0].Param1_T1Neg,
                      T1Pos: arrProductDetail[0][0].Param1_T1Pos,
                      T2Neg: arrProductDetail[0][0].Param1_T2Neg,
                      T2Pos: arrProductDetail[0][0].Param1_T2Pos,
                      LimitOn: arrProductDetail[0][0].Param1_LimitOn,
                      dp: arrProductDetail[0][0].Param1_DP,
                      isonstd: arrProductDetail[0][0].Param1_IsOnStd,
                      noOfSamples: objSamples.Individual,
                      NMT: arrProductDetail[0][0].Param1_NMTTab,
                      ProductType: intProductType,
                      unit: unit,
                    };
                  }
                }
              }
              break;
            case "Param2_Nom": //group
              if (
                parseFloat(arrProductDetail[0][0][data]) > 0 &&
                parseFloat(arrProductDetail[0][0][data]) != 99999
              ) {
                let menuName =
                  intProductType == 1 || intProductType == 2
                    ? GLOBAL_NOMENCLATURE.GroupMenu
                    : intProductType == 3 &&
                      arrProductDetail[0][0].MutihalerType[0] == 1
                      ? GLOBAL_NOMENCLATURE.sealedcart
                      : undefined;

                if (
                  cubicObj.cubicalData.Sys_BalID != "None" &&
                  strInstrument == "Balance"
                ) {
                  let unit = await this.getBalanceUnit(
                    cubicObj.cubicalData.Sys_BalID
                  );

                  obj[menuName] = {
                    nominal: arrProductDetail[0][0].Param2_Nom,
                    T1Neg: arrProductDetail[0][0].Param2_T1Neg,
                    T1Pos: arrProductDetail[0][0].Param2_T1Pos,
                    T2Neg: arrProductDetail[0][0].Param2_T2Neg,
                    T2Pos: arrProductDetail[0][0].Param2_T2Pos,
                    LimitOn: arrProductDetail[0][0].Param2_LimitOn,
                    dp: arrProductDetail[0][0].Param2_DP,
                    isonstd: arrProductDetail[0][0].Param2_IsOnStd,
                    noOfSamples: objSamples.Group,
                    NMT: arrProductDetail[0][0].Param2_NMTTab,
                    ProductType: intProductType,
                    unit: arrProductDetail[0][0].Param2_Unit,
                  };
                }
              }
              break;
            case "Param3_Nom": //thickness or differntial
              if (
                parseFloat(arrProductDetail[0][0][data]) > 0 &&
                parseFloat(arrProductDetail[0][0][data]) != 99999
              ) {
                if (
                  cubicObj.cubicalData.Sys_VernierID != "None" &&
                  intProductType == 1 &&
                  strInstrument == "Vernier"
                ) {
                  let unit = await this.getVerinerUnit(
                    cubicObj.cubicalData.Sys_VernierID
                  );
                  obj[GLOBAL_NOMENCLATURE.ThicknessMenu] = {
                    nominal: arrProductDetail[0][0].Param3_Nom,
                    T1Neg: arrProductDetail[0][0].Param3_T1Neg,
                    T1Pos: arrProductDetail[0][0].Param3_T1Pos,
                    T2Neg: arrProductDetail[0][0].Param3_T2Neg,
                    T2Pos: arrProductDetail[0][0].Param3_T2Pos,
                    LimitOn: arrProductDetail[0][0].Param3_LimitOn,
                    dp: arrProductDetail[0][0].Param3_Dp,
                    isonstd: arrProductDetail[0][0].Param3_IsOnStd,
                    noOfSamples: objSamples.Individual,
                    NMT: arrProductDetail[0][0].Param3_NMTTab,
                    ProductType: intProductType,
                    unit: unit,
                  };
                }

                if (
                  cubicObj.cubicalData.Sys_BalID != "None" &&
                  intProductType == 2 &&
                  strInstrument == "Balance"
                ) {
                  let unit = await this.getBalanceUnit(
                    cubicObj.cubicalData.Sys_BalID
                  );

                  obj[`${GLOBAL_NOMENCLATURE.Differential}`] = {
                    nominal: arrProductDetail[0][0].Param3_Nom,
                    T1Neg: arrProductDetail[0][0].Param3_T1Neg,
                    T1Pos: arrProductDetail[0][0].Param3_T1Pos,
                    T2Neg: arrProductDetail[0][0].Param3_T2Neg,
                    T2Pos: arrProductDetail[0][0].Param3_T2Pos,
                    LimitOn: arrProductDetail[0][0].Param3_LimitOn,
                    dp: arrProductDetail[0][0].Param3_Dp,
                    isonstd: arrProductDetail[0][0].Param3_IsOnStd,
                    noOfSamples: objSamples.Individual,
                    NMT: arrProductDetail[0][0].Param3_NMTTab,
                    ProductType: intProductType,
                    unit: unit,
                  };
                }
              }
              break;
            case "Param4_Nom": //diameter or breadth
              if (
                parseFloat(arrProductDetail[0][0][data]) > 0 &&
                parseFloat(arrProductDetail[0][0][data]) != 99999
              ) {
                let menuName =
                  intProductType == 1
                    ? GLOBAL_NOMENCLATURE.BreadthMenu
                    : intProductType == 2
                      ? GLOBAL_NOMENCLATURE.DiameterMenu
                      : undefined;

                if (
                  cubicObj.cubicalData.Sys_VernierID != "None" &&
                  strInstrument == "Vernier"
                ) {
                  let unit = await this.getVerinerUnit(
                    cubicObj.cubicalData.Sys_VernierID
                  );
                  obj[menuName] = {
                    nominal: arrProductDetail[0][0].Param4_Nom,
                    T1Neg: arrProductDetail[0][0].Param4_T1Neg,
                    T1Pos: arrProductDetail[0][0].Param4_T1Pos,
                    T2Neg: arrProductDetail[0][0].Param4_T2Neg,
                    T2Pos: arrProductDetail[0][0].Param4_T2Pos,
                    LimitOn: arrProductDetail[0][0].Param4_LimitOn,
                    dp: arrProductDetail[0][0].Param4_Dp,
                    isonstd: arrProductDetail[0][0].Param4_IsOnStd,
                    noOfSamples: objSamples.Individual,
                    NMT: arrProductDetail[0][0].Param4_NMTTab,
                    ProductType: intProductType,
                    unit: unit,
                  };
                }
              }
              break;
            case "Param5_Nom": //length
              if (
                parseFloat(arrProductDetail[0][0][data]) > 0 &&
                parseFloat(arrProductDetail[0][0][data]) != 99999
              ) {
                if (
                  (intProductType == 1 || intProductType == 2) &&
                  cubicObj.cubicalData.Sys_VernierID != "None" &&
                  strInstrument == "Vernier"
                ) {
                  let unit = await this.getVerinerUnit(
                    cubicObj.cubicalData.Sys_VernierID
                  );
                  obj["Length"] = {
                    nominal: arrProductDetail[0][0].Param5_Nom,
                    T1Neg: arrProductDetail[0][0].Param5_T1Neg,
                    T1Pos: arrProductDetail[0][0].Param5_T1Pos,
                    T2Neg: arrProductDetail[0][0].Param5_T2Neg,
                    T2Pos: arrProductDetail[0][0].Param5_T2Pos,
                    LimitOn: arrProductDetail[0][0].Param5_LimitOn,
                    dp: arrProductDetail[0][0].Param5_Dp,
                    isonstd: arrProductDetail[0][0].Param5_IsOnStd,
                    noOfSamples: objSamples.Individual,
                    NMT: arrProductDetail[0][0].Param5_NMTTab,
                    ProductType: intProductType,
                    unit: unit,
                  };
                }
              }
              break;
            case "Param6_Nom": //diameter
              if (
                parseFloat(arrProductDetail[0][0][data]) > 0 &&
                parseFloat(arrProductDetail[0][0][data]) != 99999
              ) {
                if (
                  intProductType == 1 &&
                  cubicObj.cubicalData.Sys_VernierID != "None" &&
                  strInstrument == "Vernier"
                ) {
                  let unit = await this.getVerinerUnit(
                    cubicObj.cubicalData.Sys_VernierID
                  );
                  obj[GLOBAL_NOMENCLATURE.DiameterMenu] = {
                    nominal: arrProductDetail[0][0].Param6_Nom,
                    T1Neg: arrProductDetail[0][0].Param6_T1Neg,
                    T1Pos: arrProductDetail[0][0].Param6_T1Pos,
                    T2Neg: arrProductDetail[0][0].Param6_T2Neg,
                    T2Pos: arrProductDetail[0][0].Param6_T2Pos,
                    LimitOn: arrProductDetail[0][0].Param6_LimitOn,
                    dp: arrProductDetail[0][0].Param6_Dp,
                    isonstd: arrProductDetail[0][0].Param6_IsOnStd,
                    noOfSamples: objSamples.Individual,
                    NMT: arrProductDetail[0][0].Param6_NMTTab,
                    ProductType: intProductType,
                    unit: unit,
                  };
                }
              }
              break;
            case "Param9_Nom": //Individual layer
              if (
                parseFloat(arrProductDetail[0][0][data]) > 0 &&
                parseFloat(arrProductDetail[0][0][data]) != 99999
              ) {
                if (
                  intProductType == 1 &&
                  cubicObj.cubicalData.Sys_BalID != "None" &&
                  strInstrument == "Balance" &&
                  objCalibratedBalAnalytical.length != 0
                ) {
                  let unit = await this.getBalanceUnit(
                    cubicObj.cubicalData.Sys_BalID
                  );
                  obj[`${GLOBAL_NOMENCLATURE.IndLayerMenu}`] = {
                    nominal: arrProductDetail[0][0].Param9_Nom,
                    T1Neg: arrProductDetail[0][0].Param9_T1Neg,
                    T1Pos: arrProductDetail[0][0].Param9_T1Pos,
                    T2Neg: arrProductDetail[0][0].Param9_T2Neg,
                    T2Pos: arrProductDetail[0][0].Param9_T2Pos,
                    LimitOn: arrProductDetail[0][0].Param9_LimitOn,
                    dp: arrProductDetail[0][0].Param9_Dp,
                    isonstd: arrProductDetail[0][0].Param9_IsOnStd,
                    noOfSamples: objSamples.Individual,
                    NMT: arrProductDetail[0][0].Param9_NMTTab,
                    ProductType: intProductType,
                    unit: unit,
                  };
                }
              }
              break;
            case "Param10_Nom": //Group layer
              if (
                parseFloat(arrProductDetail[0][0][data]) > 0 &&
                parseFloat(arrProductDetail[0][0][data]) != 99999
              ) {
                if (
                  intProductType == 1 &&
                  cubicObj.cubicalData.Sys_BalID != "None" &&
                  strInstrument == "Balance" &&
                  objCalibratedBalAnalytical.length != 0
                ) {
                  let unit = await this.getBalanceUnit(
                    cubicObj.cubicalData.Sys_BalID
                  );
                  obj[`${GLOBAL_NOMENCLATURE.GroupLayerMenu}`] = {
                    nominal: arrProductDetail[0][0].Param10_Nom,
                    T1Neg: arrProductDetail[0][0].Param10_T1Neg,
                    T1Pos: arrProductDetail[0][0].Param10_T1Pos,
                    T2Neg: arrProductDetail[0][0].Param10_T2Neg,
                    T2Pos: arrProductDetail[0][0].Param10_T2Pos,
                    LimitOn: arrProductDetail[0][0].Param10_LimitOn,
                    dp: arrProductDetail[0][0].Param10_Dp,
                    isonstd: arrProductDetail[0][0].Param10_IsOnStd,
                    noOfSamples: objSamples.Group,
                    NMT: arrProductDetail[0][0].Param10_NMTTab,
                    ProductType: intProductType,
                    unit: unit,
                  };
                }
              }
              break;
            case "Param11_Nom": //Individual layer 1
              if (
                parseFloat(arrProductDetail[0][0][data]) > 0 &&
                parseFloat(arrProductDetail[0][0][data]) != 99999
              ) {
                if (
                  intProductType == 1 &&
                  cubicObj.cubicalData.Sys_BalID != "None" &&
                  strInstrument == "Balance" &&
                  objCalibratedBalAnalytical.length != 0
                ) {
                  let unit = await this.getBalanceUnit(
                    cubicObj.cubicalData.Sys_BalID
                  );
                  obj[`${GLOBAL_NOMENCLATURE.IndLayer1Menu}`] = {
                    nominal: arrProductDetail[0][0].Param11_Nom,
                    T1Neg: arrProductDetail[0][0].Param11_T1Neg,
                    T1Pos: arrProductDetail[0][0].Param11_T1Pos,
                    T2Neg: arrProductDetail[0][0].Param11_T2Neg,
                    T2Pos: arrProductDetail[0][0].Param11_T2Pos,
                    LimitOn: arrProductDetail[0][0].Param11_LimitOn,
                    dp: arrProductDetail[0][0].Param11_Dp,
                    isonstd: arrProductDetail[0][0].Param11_IsOnStd,
                    noOfSamples: objSamples.Individual,
                    NMT: arrProductDetail[0][0].Param11_NMTTab,
                    ProductType: intProductType,
                    unit: unit,
                  };
                }
              }
              break;
            case "Param12_Nom": //Group layer 1
              if (
                parseFloat(arrProductDetail[0][0][data]) > 0 &&
                parseFloat(arrProductDetail[0][0][data]) != 99999
              ) {
                if (
                  intProductType == 1 &&
                  cubicObj.cubicalData.Sys_BalID != "None" &&
                  strInstrument == "Balance" &&
                  objCalibratedBalAnalytical.length != 0
                ) {
                  let unit = await this.getBalanceUnit(
                    cubicObj.cubicalData.Sys_BalID
                  );

                  obj[`${GLOBAL_NOMENCLATURE.GroupLayer1Menu}`] = {
                    nominal: arrProductDetail[0][0].Param12_Nom,
                    T1Neg: arrProductDetail[0][0].Param12_T1Neg,
                    T1Pos: arrProductDetail[0][0].Param12_T1Pos,
                    T2Neg: arrProductDetail[0][0].Param12_T2Neg,
                    T2Pos: arrProductDetail[0][0].Param12_T2Pos,
                    LimitOn: arrProductDetail[0][0].Param12_LimitOn,
                    dp: arrProductDetail[0][0].Param12_Dp,
                    isonstd: arrProductDetail[0][0].Param12_IsOnStd,
                    noOfSamples: objSamples.Group,
                    NMT: arrProductDetail[0][0].Param12_NMTTab,
                    ProductType: intProductType,
                    unit: unit,
                  };
                }
              }
              break;
            case "Param8_Nom": //Friability
              if (
                parseFloat(arrProductDetail[0][0][data]) > 0 &&
                parseFloat(arrProductDetail[0][0][data]) != 99999
              ) {
                if (
                  serverConfig.friabilityType == "OB" ||
                  serverConfig.friabilityType == "BFBO" ||
                  serverConfig.friabilityType == "BFBT"
                ) {
                  if (
                    intProductType == 1 &&
                    cubicObj.cubicalData.Sys_BalID != "None" &&
                    strInstrument == "Balance"
                  ) {
                    let unit = await this.getBalanceUnit(
                      cubicObj.cubicalData.Sys_BalID
                    );
                    //arr
                    let checkFri = globalData.arrBFBO.find(
                      (k) => k.idsNo == IdsNo
                    );
                    let friabMenu = `${GLOBAL_NOMENCLATURE.FriabilityMenu}`;
                    // before: false, setParam: false, after: false
                    if (checkFri.before && !checkFri.setParam) {
                      friabMenu = "Friability";
                    }

                    obj[friabMenu] = {
                      nominal: arrProductDetail[0][0].Param8_Nom,
                      T1Neg: arrProductDetail[0][0].Param8_T1Neg,
                      T1Pos: arrProductDetail[0][0].Param8_T1Pos,

                      LimitOn: arrProductDetail[0][0].Param8_LimitOn,
                      dp: arrProductDetail[0][0].Param8_Dp,
                      isonstd: arrProductDetail[0][0].Param8_IsOnStd,
                      noOfSamples: objSamples.Group,
                      NMT: arrProductDetail[0][0].Param8_NMTTab,
                      ProductType: intProductType,
                      unit: unit,
                    };
                  }
                }
              }
              break;
            case "Param8_Upp": // for % fine and from tab_gran
              if (
                parseFloat(arrProductDetail[0][0][data]) > 0 &&
                parseFloat(arrProductDetail[0][0][data]) != 99999
              ) {
                // check for product type and check LOD is set
                if (
                  (intProductType == 1 || intProductType == 2) &&
                  cubicObj.cubicalData.Sys_BalID != "None" &&
                  strInstrument == "Balance"
                  // && (CubicInfo.Sys_Area == 'Effervescent Granulation' || CubicInfo.Sys_Area == 'Granulation')
                ) {
                  let unit = await this.getBalanceUnit(
                    cubicObj.cubicalData.Sys_BalID
                  );
                  obj[GLOBAL_NOMENCLATURE.PercentageFine] = {
                    nominal: arrProductDetail[0][0].Param8_Nom,
                    T1Neg: arrProductDetail[0][0].Param8_Low,
                    T1Pos: arrProductDetail[0][0].Param8_Upp,
                    LimitOn: 1,
                    dp: arrProductDetail[0][0].Param8_Dp,
                    isonstd: 1,
                    noOfSamples: 2, //In % Fine we cant edit sample
                    ProductType: intProductType,
                    unit: unit,
                  };
                }
              }
              break;
            case "Param9_Upp": // for particalsizing and from tab_gran
              if (
                parseFloat(arrProductDetail[0][0][data]) > 0 &&
                parseFloat(arrProductDetail[0][0][data]) != 99999
              ) {
                // check for product type and check LOD is set
                if (
                  (intProductType == 1 || intProductType == 2) &&
                  cubicObj.cubicalData.Sys_BalID != "None" &&
                  strInstrument == "Balance"
                  // && (CubicInfo.Sys_Area == 'Effervescent Granulation' || CubicInfo.Sys_Area == 'Granulation')
                ) {
                  let unit = await this.getBalanceUnit(
                    cubicObj.cubicalData.Sys_BalID
                  );
                  obj[GLOBAL_NOMENCLATURE.ParticalSizing] = {
                    nominal: arrProductDetail[0][0].Param9_Nom,
                    T1Neg: arrProductDetail[0][0].Param9_Low,
                    T1Pos: arrProductDetail[0][0].Param9_Upp,
                    LimitOn: 1,
                    dp: arrProductDetail[0][0].Param9_DP,
                    isonstd: 1,
                    noOfSamples: 7,
                    ProductType: intProductType,
                    unit: unit,
                  };
                }
              }
            default:
              if (
                objCalibratedBalIPC.length > 0 &&
                cubicObj.cubicalData.Sys_BinBalID != "None"
              ) {
                obj["IPCWC"] = {};
              }
          }

          if (Object.keys(obj).length != 0 && obj.constructor === Object) {
            return obj;
          }
        })
      );
      let removeUndefinedFromArray = MenuAccordingToParamsSet.filter(
        (v) => v != undefined
      );
      return removeUndefinedFromArray;
    } catch (error) {
      throw new Error(error);
    }
  }

  async getBalanceUnit(BalId) {
    try {
      let selctBalanceDetail = await models.tbl_balance.findAll({
        where: {
          Bal_ID: BalId,
        },
      });
      let arrProductSample = [selctBalanceDetail];
      if (arrProductSample[0][0] != undefined) {
        return arrProductSample[0][0].Bal_Unit;
      } else {
        return "gm";
      }
    } catch (error) {
      throw new Error(error);
    }
  }

  async getVerinerUnit(VerId) {
    try {
      let selctVernierDetail = await models.tbl_vernier.findAll({
        where: {
          VernierID: VerId,
        },
      });
      let arrProductSample = [selctVernierDetail];
      return arrProductSample[0][0].RangeUnit;
    } catch (error) {
      throw new Error(error);
    }
  }

  async bulkDataMenuMaking(values, currentIdsNo, Ip) {
    try {
      let strInstrument = values.instrument;
      let strHmi = values.Hmi;
      let strIdsNo = values.idsNo;
      let intPortNo = values.PortNo;
      let arrProductDetail = values.ProductDetail;
      let objSamples = values.Samples;
      let intProductType = values.prdType;
      const cubicObj = globalData.arrIdsInfo.find((k) => k.Ip == Ip);
      let strHardnessModel;
      let arrHardnessColumn = [];
      let arrHardnessColumnDetail = [];
      let objThickness = {};
      let objBreadth = {};
      let objDiameter = {};
      let objHardness = {};

      let MenuAccordingToParamsSet = await Promise.all(
        Object.keys(arrProductDetail[0][0]).map(async (data) => {
          let obj = {};
          let objCalibratedBal = globalData.glbArrListOfCalibratedBal.find(
            (k) => k.Hmi == strHmi
          );
          switch (data) {
            case "Param6_T1Neg": //DT
              if (
                parseFloat(arrProductDetail[0][0][data]) > 0 &&
                parseFloat(arrProductDetail[0][0][data]) != 99999
              ) {
                if (
                  (intProductType == 1 || intProductType == 2) &&
                  cubicObj.cubicalData.Sys_DTID != "None" &&
                  strInstrument == "DT"
                ) {
                  obj["DT"] = {
                    nominal: arrProductDetail[0][0].Param6_Nom,
                    T1Neg: arrProductDetail[0][0].Param6_T1Neg,
                    T1Pos: arrProductDetail[0][0].Param6_T1Pos,
                    T2Neg: arrProductDetail[0][0].Param6_T2Neg,
                    T2Pos: arrProductDetail[0][0].Param6_T2Pos,
                    LimitOn: arrProductDetail[0][0].Param6_LimitOn,
                    dp: arrProductDetail[0][0].Param6_Dp,
                    isonstd: arrProductDetail[0][0].Param6_IsOnStd,
                    noOfSamples: objSamples.Individual,
                    NMT: arrProductDetail[0][0].Param6_NMTTab,
                    ProductType: intProductType,
                    unit: "mm",
                  };
                }
              }
              break;
            case "Param7_Nom": // hardness
              if (
                parseFloat(arrProductDetail[0][0][data]) > 0 &&
                parseFloat(arrProductDetail[0][0][data]) != 99999
              ) {
                if (
                  cubicObj.cubicalData.Sys_HardID != "None" &&
                  (strInstrument == "Hardness" ||
                    strInstrument == "Tablet Tester") &&
                  intProductType == 1
                ) {
                  obj[`${GLOBAL_NOMENCLATURE.HardnessMenu}`] = {
                    Hard_nominal: arrProductDetail[0][0].Param7_Nom,
                    Hard_T1Neg: arrProductDetail[0][0].Param7_T1Neg,
                    Hard_T1Pos: arrProductDetail[0][0].Param7_T1Pos,
                    Hard_T2Neg: arrProductDetail[0][0].Param7_T2Neg,
                    Hard_T2Pos: arrProductDetail[0][0].Param7_T2Pos,
                    Thick_nominal: arrProductDetail[0][0].Param3_Nom,
                    Thick_T1Neg: arrProductDetail[0][0].Param3_T1Neg,
                    Thick_T1Pos: arrProductDetail[0][0].Param3_T1Pos,
                    Thick_T2Neg: arrProductDetail[0][0].Param3_T2Neg,
                    Thick_T2Pos: arrProductDetail[0][0].Param3_T2Pos,
                    LimitOn: arrProductDetail[0][0].Param7_LimitOn,
                    dp: arrProductDetail[0][0].Param7_Dp,
                    isonstd: arrProductDetail[0][0].Param7_IsOnStd,
                    noOfSamples: objSamples.Hardness,
                    // 'NMT': arrProductDetail[0][0].Param7_NMTTab,
                    ProductType: intProductType,
                    Hard_unit: arrProductDetail[0][0].Param7_Unit,
                    Thick_unit: "mm",
                  };

                  strHardnessModel = await this.CheckHardnessModel(strIdsNo);
                  let strMt50Type = strHardnessModel.Eqp_HT_Type;
                  if (strHardnessModel.Eqp_Make == "Sotax MT50") {
                    if (strMt50Type == "HTOHL") {
                      obj[`${GLOBAL_NOMENCLATURE.TabletTesterMenu}`]["column"] =
                        ["Hardness"];
                    } else if (strMt50Type == "HTALL") {
                      objThickness = {
                        Nom: arrProductDetail[0][0]["Param3_Nom"],
                        T1Neg: arrProductDetail[0][0]["Param3_T1Neg"],
                        T1Pos: arrProductDetail[0][0]["Param3_T1Pos"],
                        T2Pos: arrProductDetail[0][0]["Param3_T2Pos"],
                        T2Neg: arrProductDetail[0][0]["Param3_T2Neg"],
                      };

                      objBreadth = {
                        Nom: arrProductDetail[0][0]["Param3_Nom"],
                        T1Neg: arrProductDetail[0][0]["Param3_T1Neg"],
                        T1Pos: arrProductDetail[0][0]["Param3_T1Pos"],
                        T2Pos: arrProductDetail[0][0]["Param3_T2Pos"],
                        T2Neg: arrProductDetail[0][0]["Param3_T2Neg"],
                      };

                      objDiameter = {
                        Nom: arrProductDetail[0][0]["Param3_Nom"],
                        T1Neg: arrProductDetail[0][0]["Param3_T1Neg"],
                        T1Pos: arrProductDetail[0][0]["Param3_T1Pos"],
                        T2Pos: arrProductDetail[0][0]["Param3_T2Pos"],
                        T2Neg: arrProductDetail[0][0]["Param3_T2Neg"],
                      };

                      objHardness = {
                        Nom: arrProductDetail[0][0]["Param3_Nom"],
                        T1Neg: arrProductDetail[0][0]["Param3_T1Neg"],
                        T1Pos: arrProductDetail[0][0]["Param3_T1Pos"],
                      };

                      arrProductDetail[0][0]["Param3_Nom"] == (99999 && 0)
                        ? 0
                        : arrHardnessColumn.push("Thickness");
                      arrProductDetail[0][0]["Param4_Nom"] == (99999 && 0)
                        ? 0
                        : arrHardnessColumn.push("Breadth");
                      arrProductDetail[0][0]["Param6_Nom"] == (99999 && 0)
                        ? 0
                        : arrHardnessColumn.push("Diameter");
                      arrProductDetail[0][0]["Param7_T1Pos"] == (99999 && 0)
                        ? 0
                        : arrHardnessColumn.push("Hardness");

                      //for column detail
                      arrProductDetail[0][0]["Param3_Nom"] == (99999 && 0)
                        ? 0
                        : arrHardnessColumnDetail.push({
                          Thickness: objThickness,
                        });
                      arrProductDetail[0][0]["Param4_Nom"] == (99999 && 0)
                        ? 0
                        : arrHardnessColumnDetail.push({ Breadth: objBreadth });
                      arrProductDetail[0][0]["Param6_Nom"] == (99999 && 0)
                        ? 0
                        : arrHardnessColumnDetail.push({
                          Diameter: objDiameter,
                        });
                      arrProductDetail[0][0]["Param7_T1Pos"] == (99999 && 0)
                        ? 0
                        : arrHardnessColumnDetail.push({
                          Hardness: objHardness,
                        });

                      obj[`${GLOBAL_NOMENCLATURE.HardnessMenu}`].column =
                        arrHardnessColumn;
                      obj[`${GLOBAL_NOMENCLATURE.HardnessMenu}`].columnDetail =
                        arrHardnessColumnDetail;
                    }
                  }
                  if (strHardnessModel.Eqp_Make == "Sotax ST50") {
                    objThickness = {
                      Nom: arrProductDetail[0][0]["Param3_Nom"],
                      T1Neg: arrProductDetail[0][0]["Param3_T1Neg"],
                      T1Pos: arrProductDetail[0][0]["Param3_T1Pos"],
                      T2Pos: arrProductDetail[0][0]["Param3_T2Pos"],
                      T2Neg: arrProductDetail[0][0]["Param3_T2Neg"],
                    };

                    objBreadth = {
                      Nom: arrProductDetail[0][0]["Param3_Nom"],
                      T1Neg: arrProductDetail[0][0]["Param3_T1Neg"],
                      T1Pos: arrProductDetail[0][0]["Param3_T1Pos"],
                      T2Pos: arrProductDetail[0][0]["Param3_T2Pos"],
                      T2Neg: arrProductDetail[0][0]["Param3_T2Neg"],
                    };

                    objDiameter = {
                      Nom: arrProductDetail[0][0]["Param3_Nom"],
                      T1Neg: arrProductDetail[0][0]["Param3_T1Neg"],
                      T1Pos: arrProductDetail[0][0]["Param3_T1Pos"],
                      T2Pos: arrProductDetail[0][0]["Param3_T2Pos"],
                      T2Neg: arrProductDetail[0][0]["Param3_T2Neg"],
                    };

                    objHardness = {
                      Nom: arrProductDetail[0][0]["Param3_Nom"],
                      T1Neg: arrProductDetail[0][0]["Param3_T1Neg"],
                      T1Pos: arrProductDetail[0][0]["Param3_T1Pos"],
                    };

                    arrProductDetail[0][0]["Param3_Nom"] == (99999 && 0)
                      ? 0
                      : arrHardnessColumn.push("Thickness");
                    arrProductDetail[0][0]["Param4_Nom"] == (99999 && 0)
                      ? 0
                      : arrHardnessColumn.push("Breadth");
                    arrProductDetail[0][0]["Param6_Nom"] == (99999 && 0)
                      ? 0
                      : arrHardnessColumn.push("Diameter");
                    arrProductDetail[0][0]["Param7_T1Pos"] == (99999 && 0)
                      ? 0
                      : arrHardnessColumn.push("Hardness");

                    //for column detail
                    arrProductDetail[0][0]["Param3_Nom"] == (99999 && 0)
                      ? 0
                      : arrHardnessColumnDetail.push({
                        Thickness: objThickness,
                      });
                    arrProductDetail[0][0]["Param4_Nom"] == (99999 && 0)
                      ? 0
                      : arrHardnessColumnDetail.push({ Breadth: objBreadth });
                    arrProductDetail[0][0]["Param6_Nom"] == (99999 && 0)
                      ? 0
                      : arrHardnessColumnDetail.push({ Diameter: objDiameter });
                    arrProductDetail[0][0]["Param7_T1Pos"] == (99999 && 0)
                      ? 0
                      : arrHardnessColumnDetail.push({ Hardness: objHardness });
                    obj[`${GLOBAL_NOMENCLATURE.HardnessMenu}`].column =
                      arrHardnessColumn;
                    obj[`${GLOBAL_NOMENCLATURE.HardnessMenu}`].columnDetail =
                      arrHardnessColumnDetail;
                  }
                }
              }
              break;
            case "Param8_Nom": // for Friability
              if (
                parseFloat(arrProductDetail[0][0][data]) > 0 &&
                parseFloat(arrProductDetail[0][0][data]) != 99999
              ) {
                if (
                  cubicObj.cubicalData.Sys_FriabID != "None" &&
                  (strInstrument == "Friability" ||
                    strInstrument == "Friabilator") &&
                  intProductType == 1 &&
                  cubicObj.cubicalData.Sys_CubType != "Granulation" &&
                  serverConfig.friabilityType == "OF"
                ) {
                  obj[GLOBAL_NOMENCLATURE.FriabilatorMenu] = {
                    nominal: arrProductDetail[0][0].Param8_Nom,
                    T1Neg: arrProductDetail[0][0].Param8_T1Neg,
                    T1Pos: arrProductDetail[0][0].Param8_T1Pos,
                    LimitOn: arrProductDetail[0][0].Param8_LimitOn,
                    dp: arrProductDetail[0][0].Param8_Dp,
                    isonstd: arrProductDetail[0][0].Param8_IsOnStd,
                    noOfSamples: objSamples.Individual,
                    NMT: arrProductDetail[0][0].Param8_NMTTab,
                    ProductType: intProductType,
                    unit: "g",
                  };
                }
              }
              break;
            case "Param13_T1Neg":
              if (
                parseFloat(arrProductDetail[0][0][data]) > 0 &&
                parseFloat(arrProductDetail[0][0][data]) != 99999
              ) {
                if (
                  intProductType == 1 &&
                  cubicObj.cubicalData.Sys_DTID != "None" &&
                  (strInstrument == "Disintegration Tester" ||
                    strInstrument == "DT")
                ) {
                  obj[GLOBAL_NOMENCLATURE.DTMenu] = {
                    nominal: arrProductDetail[0][0].Param13_Nom,
                    T1Neg: arrProductDetail[0][0].Param13_T1Neg,
                    T1Pos: arrProductDetail[0][0].Param13_T1Pos,
                    LimitOn: arrProductDetail[0][0].Param13_LimitOn,
                    dp: arrProductDetail[0][0].Param13_DP,
                    isonstd: arrProductDetail[0][0].Param13_IsOnStd,
                    noOfSamples: undefined,
                    NMT: arrProductDetail[0][0].Param13_NMTTab,
                    ProductType: intProductType,
                    unit: "",
                  };
                }
              }
              break;
            case "Param6_T1Neg":
              if (
                parseFloat(arrProductDetail[0][0][data]) > 0 &&
                parseFloat(arrProductDetail[0][0][data]) != 99999
              ) {
                if (
                  intProductType == 2 &&
                  cubicObj.cubicalData.Sys_DTID != "None" &&
                  (strInstrument == "Disintegration Tester" ||
                    strInstrument == "DT")
                ) {
                  obj[GLOBAL_NOMENCLATURE.DTMenu] = {
                    nominal: arrProductDetail[0][0].Param6_Nom,
                    T1Neg: arrProductDetail[0][0].Param6_T1Neg,
                    T1Pos: arrProductDetail[0][0].Param6_T1Pos,
                    LimitOn: arrProductDetail[0][0].Param6_LimitOn,
                    dp: arrProductDetail[0][0].Param6_DP,
                    isonstd: arrProductDetail[0][0].Param6_IsOnStd,
                    noOfSamples: undefined,
                    NMT: arrProductDetail[0][0].Param6_NMTTab,
                    ProductType: intProductType,
                    unit: "",
                  };
                }
              }
              break;
            case "Param16_T1Pos":
              if (
                parseFloat(arrProductDetail[0][0][data]) > 0 &&
                parseFloat(arrProductDetail[0][0][data]) != 99999
              ) {
                if (
                  intProductType == 1 &&
                  cubicObj.cubicalData.Sys_MoistID != "None" &&
                  (strInstrument == "Moisture Analyzer" ||
                    strInstrument == "LOD")
                ) {
                  obj["LOD"] = {
                    nominal: arrProductDetail[0][0].Param16_Nom,
                    T1Neg: arrProductDetail[0][0].Param16_T1Neg,
                    T1Pos: arrProductDetail[0][0].Param16_T1Pos,
                    LimitOn: arrProductDetail[0][0].Param16_LimitOn,
                    dp: arrProductDetail[0][0].Param16_DP,
                    isonstd: arrProductDetail[0][0].Param16_IsOnStd,
                    noOfSamples: objSamples.Individual,
                    NMT: arrProductDetail[0][0].Param16_NMTTab,
                    ProductType: intProductType,
                    unit: "",
                  };
                }
              }
              break;
            case "Param15_T1Neg":
              if (
                parseFloat(arrProductDetail[0][0][data]) > 0 &&
                parseFloat(arrProductDetail[0][0][data]) != 99999
              ) {
                if (
                  intProductType == 1 &&
                  cubicObj.cubicalData.Sys_TapDensityID != "None" &&
                  (strInstrument == "TDT" ||
                    strInstrument == "Tapped Density") &&
                  cubicObj.cubicalData.Sys_CubType != "Granulation" &&
                  cubicObj.cubicalData.Sys_Area != "Granulation"
                ) {
                  obj["Tapped_Density"] = {
                    nominal: arrProductDetail[0][0].Param15_Nom,
                    T1Neg: arrProductDetail[0][0].Param15_T1Neg,
                    T1Pos: arrProductDetail[0][0].Param15_T1Pos,
                    LimitOn: arrProductDetail[0][0].Param15_LimitOn,
                    dp: arrProductDetail[0][0].Param15_DP,
                    ProductType: intProductType,
                    unit: "",
                  };
                }
              }
              break;
            case "Param7_Upp": // for tab density and from tab_gran
              if (
                parseFloat(arrProductDetail[0][0][data]) > 0 &&
                parseFloat(arrProductDetail[0][0][data]) != 99999
              ) {
                if (
                  (intProductType == 1 || intProductType == 2) &&
                  cubicObj.cubicalData.Sys_TapDensityID != "None" &&
                  cubicObj.cubicalData.Sys_Area == "Effervescent Granulation"
                ) {
                  obj[GLOBAL_NOMENCLATURE.TappedDensity] = {
                    nominal: arrProductDetail[0][0].Param7_Nom,
                    T1Neg: arrProductDetail[0][0].Param7_Low,
                    T1Pos: arrProductDetail[0][0].Param7_Upp,
                    LimitOn: 1,
                    dp: arrProductDetail[0][0].Param7_DP,
                    ProductType: intProductType,
                    isonstd: 1,
                    unit: "",
                  };
                }
              }
              break;
            case "Param1_Upp": // for lod and from tab_gran
            case "Param2_Upp":
            case "Param3_Upp":
            case "Param4_Upp":
            case "Param5_Upp":
            case "Param6_Upp":
              if (
                parseFloat(arrProductDetail[0][0][data]) > 0 &&
                parseFloat(arrProductDetail[0][0][data]) != 99999
              ) {
                if (
                  (intProductType == 1 || intProductType == 2) &&
                  cubicObj.cubicalData.Sys_MoistID != "None" &&
                  strInstrument == GLOBAL_NOMENCLATURE.MoistureAnalyzer
                ) {
                  obj["LOD"] = {
                    nominal: arrProductDetail[0][0].Param1_Nom,
                    T1Neg: arrProductDetail[0][0].Param1_Low,
                    T1Pos: arrProductDetail[0][0].Param1_Upp,
                    LimitOn: 1,
                    dp: arrProductDetail[0][0].Param1_DP,
                    isonstd: 1,
                    noOfSamples: objSamples.Individual,
                    ProductType: intProductType,
                    isonstd: 1,
                    unit: "",
                  };
                }
              }
              // break;
              // for lod and from tab_gran
              if (
                parseFloat(arrProductDetail[0][0][data]) > 0 &&
                parseFloat(arrProductDetail[0][0][data]) != 99999
              ) {
                if (
                  (intProductType == 1 || intProductType == 2) &&
                  cubicObj.cubicalData.Sys_MoistID != "None" &&
                  strInstrument == "LOD"
                ) {
                  obj["GRNLUB"] = {
                    nominal: arrProductDetail[0][0].Param2_Nom,
                    T1Neg: arrProductDetail[0][0].Param2_Low,
                    T1Pos: arrProductDetail[0][0].Param2_Upp,
                    LimitOn: 1,
                    dp: arrProductDetail[0][0].Param2_DP,
                    isonstd: 1,
                    noOfSamples: objSamples.Individual,
                    ProductType: intProductType,
                    isonstd: 1,
                    unit: "",
                  };
                }
              }
              // break;
              // for lod and from tab_gran
              if (
                parseFloat(arrProductDetail[0][0][data]) > 0 &&
                parseFloat(arrProductDetail[0][0][data]) != 99999
              ) {
                if (
                  (intProductType == 1 || intProductType == 2) &&
                  cubicObj.cubicalData.Sys_MoistID != "None" &&
                  strInstrument == "LOD"
                ) {
                  obj["LAY1DRY"] = {
                    nominal: arrProductDetail[0][0].Param3_Nom,
                    T1Neg: arrProductDetail[0][0].Param3_Low,
                    T1Pos: arrProductDetail[0][0].Param3_Upp,
                    LimitOn: 1,
                    dp: arrProductDetail[0][0].Param3_DP,
                    isonstd: 1,
                    noOfSamples: objSamples.Individual,
                    ProductType: intProductType,
                    isonstd: 1,
                    unit: "",
                  };
                }
              }
              // break;
              // for lod and from tab_gran
              if (
                parseFloat(arrProductDetail[0][0][data]) > 0 &&
                parseFloat(arrProductDetail[0][0][data]) != 99999
              ) {
                if (
                  (intProductType == 1 || intProductType == 2) &&
                  cubicObj.cubicalData.Sys_MoistID != "None" &&
                  strInstrument == "LOD"
                ) {
                  obj["LAY1LUB"] = {
                    nominal: arrProductDetail[0][0].Param4_Nom,
                    T1Neg: arrProductDetail[0][0].Param4_Low,
                    T1Pos: arrProductDetail[0][0].Param4_Upp,
                    LimitOn: 1,
                    dp: arrProductDetail[0][0].Param4_DP,
                    isonstd: 1,
                    noOfSamples: objSamples.Individual,
                    ProductType: intProductType,
                    isonstd: 1,
                    unit: "",
                  };
                }
              }
              // break;
              // for lod and from tab_gran
              if (
                parseFloat(arrProductDetail[0][0][data]) > 0 &&
                parseFloat(arrProductDetail[0][0][data]) != 99999
              ) {
                if (
                  (intProductType == 1 || intProductType == 2) &&
                  cubicObj.cubicalData.Sys_MoistID != "None" &&
                  strInstrument == "LOD"
                ) {
                  obj["LAY2DRY"] = {
                    nominal: arrProductDetail[0][0].Param5_Nom,
                    T1Neg: arrProductDetail[0][0].Param5_Low,
                    T1Pos: arrProductDetail[0][0].Param5_Upp,
                    LimitOn: 1,
                    dp: arrProductDetail[0][0].Param5_DP,
                    isonstd: 1,
                    noOfSamples: objSamples.Individual,
                    ProductType: intProductType,
                    isonstd: 1,
                    unit: "",
                  };
                }
              }
              // break;
              // for lod and from tab_gran
              if (
                parseFloat(arrProductDetail[0][0][data]) > 0 &&
                parseFloat(arrProductDetail[0][0][data]) != 99999
              ) {
                if (
                  (intProductType == 1 || intProductType == 2) &&
                  cubicObj.cubicalData.Sys_MoistID != "None" &&
                  strInstrument == "LOD"
                ) {
                  obj["LAY2LUB"] = {
                    nominal: arrProductDetail[0][0].Param6_Nom,
                    T1Neg: arrProductDetail[0][0].Param6_Low,
                    T1Pos: arrProductDetail[0][0].Param6_Upp,
                    LimitOn: 1,
                    dp: arrProductDetail[0][0].Param6_DP,
                    isonstd: 1,
                    noOfSamples: objSamples.Individual,
                    ProductType: intProductType,
                    isonstd: 1,
                    unit: "",
                  };
                }
              }
              break;
          }
          if (Object.keys(obj).length != 0 && obj.constructor === Object) {
            return obj;
          }
        })
      );
      let removeUndefinedFromArray = MenuAccordingToParamsSet.filter(
        (v) => v != undefined
      );
      return removeUndefinedFromArray;
    } catch (error) {
      throw new Error(error);
    }
  }

  async onMenuStart(value) {
    try {
      let menuName = value.menuName;
      const DsNo = value.dsNo;
      const TabIp = value.tabIp;
      let resObj = {};
      let strInstrumentType, instrumentId, portNo, unit, Nomunit;
      let selectedDsNo = null;
      // let strHmi = value.Hmi;
      // let objIdsNo = await objHmiModel.getResbPiNoFromHmi(strHmi);
      // let strIdsNo = objIdsNo[0].Sys_IDSNo;
      // let selectedIdsNo;

      const rpiTblRes = await models.tbl_rpi.findOne({
        where: {
          DS_NUMBER: DsNo
        }
      });
      const DsIp = rpiTblRes.DS_IP;

      // As client need Start time to be captured on Test Start
      var arrUsers = globalData.arrUsers.find((k) => k.TabIp == TabIp && k.DsNo == DsNo);
      if (arrUsers != undefined) {
        arrUsers.Time = moment().format("HH:mm:ss");
      }

      var IPQCObject = globalData.arr_IPQCRelIds.find(
        (k) => k.DsNo == DsNo && k.tabIp == TabIp
      );
      if (IPQCObject != undefined) {
        selectedDsNo = IPQCObject.selectedDs.dsNo;
      } else {
        selectedDsNo = DsNo;
      }

      var obj = {
        DsNo,
        TabIp,
        menuType: menuName,
      };

      let prodtDetail1 = globalData.arr_limits.find((k) => k.DsNo == DsNo && k.TabIp == TabIp); //not current idsno

      let CubicInfo = globalData.arrIdsInfo.find(
        (k) => k.DsNo == DsNo && k.TabIp == TabIp
      ).cubicalData;
      // let CurrentCubicInfo = globalData.arrIdsInfo.find(k => k.idsNo == strIdsNo).cubicalData;

      let intRptType = CubicInfo.Sys_RptType;
      let sysArea = CubicInfo.Sys_Area;
      let MPN = CubicInfo.Sys_MPNCode;
      let productName = CubicInfo.Sys_ProductName;
      let productId = CubicInfo.Sys_BFGCode;
      let StrBatch = CubicInfo.Sys_Batch;
      let ProductVersion = CubicInfo.Sys_PVersion;
      let Version = CubicInfo.Sys_Version;
      let StrRotaryType = CubicInfo.Sys_RotaryType;
      let obj1;
      let arr = [];
      let i = 1;
      let isFTP = false;
      // let MPNCode = CubicInfo.Sys_MPNCode

      globalData.arrcalibType.findIndex((element) => element.TabIp === TabIp && element.DsNo == DsNo) == -1
        ? globalData.arrcalibType
        : globalData.arrcalibType.splice(
          globalData.arrcalibType.findIndex((element) => element.TabIp === TabIp && element.DsNo == DsNo),
          1
        );

      globalData.arrCurrentOperationStatus.findIndex(
        (element) => element.TabIp === TabIp && element.DsNo == DsNo
      ) == -1
        ? globalData.arrCurrentOperationStatus
        : globalData.arrCurrentOperationStatus.splice(
          globalData.arrCurrentOperationStatus.findIndex(
            (element) => element.TabIp === TabIp && element.DsNo == DsNo
          ),
          1
        );

      let arrBal = await objCommonOperation.getCubicalData(DsNo);
      let objdetails = arrBal[0];

      for (let obj in objdetails) {
        if (
          objdetails[`Sys_Port${i}`] == undefined ||
          objdetails[`Sys_Port${i}`] == "NULL" ||
          objdetails[`Sys_Port${i}`] == "None" ||
          objdetails[`Sys_Port${i}`] == null
        ) {
          i++;
          continue;
        } else {
          if (objdetails[`Sys_Port${i}`] == "Balance") {
            arr.push({
              BalanceId: objdetails["Sys_BalID"],
              PortNo: i,
              Type: objdetails[`Sys_Port${i}`],
            });
          } else if (objdetails[`Sys_Port${i}`] == "Vernier") {
            arr.push({
              VernierId: objdetails["Sys_VernierID"],
              PortNo: i,
              Type: objdetails[`Sys_Port${i}`],
            });
          } else if (
            objdetails[`Sys_Port${i}`] == "Hardness" ||
            objdetails[`Sys_Port${i}`] == "TBTTST" ||
            objdetails[`Sys_Port${i}`] == "Tablet Tester" ||
            objdetails[`Sys_Port${i}`] == "Multi Tester"
          ) {
            arr.push({
              HardnessId: objdetails["Sys_HardID"],
              PortNo: i,
              Type: objdetails[`Sys_Port${i}`],
            });
          } else if (
            objdetails[`Sys_Port${i}`] == "Friabilator" ||
            objdetails[`Sys_Port${i}`] == "Friability"
          ) {
            arr.push({
              FriabilityId: objdetails["Sys_FriabID"],
              PortNo: i,
              Type: objdetails[`Sys_Port${i}`],
            });
          } else if (
            objdetails[`Sys_Port${i}`] == "Disintegration Tester" ||
            objdetails[`Sys_Port${i}`] == "DT"
          ) {
            arr.push({
              DTId: objdetails["Sys_DTID"],
              PortNo: i,
              Type: objdetails[`Sys_Port${i}`],
            });
          } else if (
            objdetails[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.MoistureAnalyzer
          ) {
            arr.push({
              MoistureAnalyserId: objdetails["Sys_MoistID"],
              PortNo: i,
              Type: objdetails[`Sys_Port${i}`],
            });
          } else if (objdetails[`Sys_Port${i}`] == "Tapped Density") {
            arr.push({
              TappedDensityId: objdetails["Sys_TapDensityID"],
              PortNo: i,
              Type: objdetails[`Sys_Port${i}`],
            });
          } else if (objdetails[`Sys_Port${i}`] == GLOBAL_NOMENCLATURE.LeakTester) {
            arr.push({
              LeakTestId: objdetails["Sys_LeakID"],
              PortNo: i,
              Type: objdetails[`Sys_Port${i}`],
            });
          }
          i++;
        }
      }
      menuName = menuName == "FRIAB" ? 'Friability' : menuName;

      switch (menuName) {
        case GLOBAL_NOMENCLATURE.IndividualMenu:
          {
            menuName = GLOBAL_NOMENCLATURE.IndividualMenu;
            // strInstrumentType = GLOBAL_NOMENCLATURE.Balance;
            // instrumentId = arr.find((k) => k.BalanceId).BalanceId;
            // portNo = arr.find((k) => k.BalanceId).PortNo;

            if (isFTP == 1) {

              strInstrumentType = GLOBAL_NOMENCLATURE.Hardness;
              instrumentId = arr.find((k) => k.HardnessId).HardnessId;
              portNo = arr.find((k) => k.HardnessId).PortNo;
            } else {
              strInstrumentType = GLOBAL_NOMENCLATURE.Balance;
              instrumentId = arr.find((k) => k.BalanceId).BalanceId;
              portNo = arr.find((k) => k.BalanceId).PortNo;
            }
          }
          break;
        case GLOBAL_NOMENCLATURE.IndLayerMenu:
          {
            menuName = GLOBAL_NOMENCLATURE.IndLayerMenu;
            strInstrumentType = GLOBAL_NOMENCLATURE.Balance;
            instrumentId = arr.find((k) => k.BalanceId).BalanceId;
            portNo = arr.find((k) => k.BalanceId).PortNo;
          }
          break;
        case GLOBAL_NOMENCLATURE.IndLayer1Menu:
          {
            menuName = GLOBAL_NOMENCLATURE.IndLayer1Menu;
            strInstrumentType = GLOBAL_NOMENCLATURE.Balance;
            instrumentId = arr.find((k) => k.BalanceId).BalanceId;
            portNo = arr.find((k) => k.BalanceId).PortNo;
          }
          break;
        case GLOBAL_NOMENCLATURE.GroupIndividual:
          {
            menuName = GLOBAL_NOMENCLATURE.GroupIndividual;
            strInstrumentType = GLOBAL_NOMENCLATURE.Balance;
            instrumentId = arr.find((k) => k.BalanceId).BalanceId;
            portNo = arr.find((k) => k.BalanceId).PortNo;
          }
          break;
        case GLOBAL_NOMENCLATURE.GroupMenu:
          {
            menuName = GLOBAL_NOMENCLATURE.GroupMenu;
            strInstrumentType = GLOBAL_NOMENCLATURE.Balance;
            instrumentId = arr.find((k) => k.BalanceId).BalanceId;
            portNo = arr.find((k) => k.BalanceId).PortNo;
          }
          break;
        case GLOBAL_NOMENCLATURE.EmptyGroupMenu:
          {
            menuName = GLOBAL_NOMENCLATURE.EmptyGroupMenu;
            strInstrumentType = GLOBAL_NOMENCLATURE.Balance;
            instrumentId = arr.find((k) => k.BalanceId).BalanceId;
            portNo = arr.find((k) => k.BalanceId).PortNo;
          }
          break;
        case GLOBAL_NOMENCLATURE.GroupLayer1Menu:
          {
            menuName = GLOBAL_NOMENCLATURE.GroupLayer1Menu;
            strInstrumentType = GLOBAL_NOMENCLATURE.Balance;
            instrumentId = arr.find((k) => k.BalanceId).BalanceId;
            portNo = arr.find((k) => k.BalanceId).PortNo;
          }
          break;
        case GLOBAL_NOMENCLATURE.ThicknessMenu:
          {
            menuName = GLOBAL_NOMENCLATURE.ThicknessMenu;
            strInstrumentType = GLOBAL_NOMENCLATURE.Vernier;
            instrumentId = arr.find((k) => k.VernierId).VernierId;
            portNo = arr.find((k) => k.VernierId).PortNo;
          }
          break;
        case GLOBAL_NOMENCLATURE.DiameterMenu:
          {
            menuName = GLOBAL_NOMENCLATURE.DiameterMenu;
            strInstrumentType = GLOBAL_NOMENCLATURE.Vernier;
            instrumentId = arr.find((k) => k.VernierId).VernierId;
            portNo = arr.find((k) => k.VernierId).PortNo;
          }
          break;
        case GLOBAL_NOMENCLATURE.BreadthMenu:
          {
            menuName = GLOBAL_NOMENCLATURE.BreadthMenu;
            strInstrumentType = GLOBAL_NOMENCLATURE.Vernier;
            instrumentId = arr.find((k) => k.VernierId).VernierId;
            portNo = arr.find((k) => k.VernierId).PortNo;
          }
          break;
        case GLOBAL_NOMENCLATURE.LengthMenu:
          {
            menuName = GLOBAL_NOMENCLATURE.LengthMenu;
            strInstrumentType = GLOBAL_NOMENCLATURE.Vernier;
            instrumentId = arr.find((k) => k.VernierId).VernierId;
            portNo = arr.find((k) => k.VernierId).PortNo;
          }
          break;
        case GLOBAL_NOMENCLATURE.LockedLength:
          {
            menuName = GLOBAL_NOMENCLATURE.LockedLength;
            strInstrumentType = GLOBAL_NOMENCLATURE.Vernier;
            instrumentId = arr.find((k) => k.VernierId).VernierId;
            portNo = arr.find((k) => k.VernierId).PortNo;
          }
          break;
        case GLOBAL_NOMENCLATURE.MoistureAnalyzer:
        case "LOD":
        case "Loss on Dry":
          {
            menuName = menuName;
            strInstrumentType = GLOBAL_NOMENCLATURE.MoistureAnalyzer;
            instrumentId = arr.find(
              (k) => k.MoistureAnalyserId
            ).MoistureAnalyserId;
            portNo = arr.find((k) => k.MoistureAnalyserId).PortNo;
          }
          break;
        case GLOBAL_NOMENCLATURE.TabletTesterMenu:
        case GLOBAL_NOMENCLATURE.HardnessMenu:
          {
            // menuName = GLOBAL_NOMENCLATURE.TabletTester;
            menuName = menuName;
            strInstrumentType = GLOBAL_NOMENCLATURE.Hardness;
            instrumentId = arr.find((k) => k.HardnessId).HardnessId;
            portNo = arr.find((k) => k.HardnessId).PortNo;
          }
          break;
        case GLOBAL_NOMENCLATURE.FriabilityMenu:
        case GLOBAL_NOMENCLATURE.FriabilatorMenu:
        case GLOBAL_NOMENCLATURE.Friability:
          {
            if (menuName == GLOBAL_NOMENCLATURE.FriabilatorMenu) {
              menuName = GLOBAL_NOMENCLATURE.FriabilatorMenu;
              strInstrumentType = GLOBAL_NOMENCLATURE.FriabilatorMenu;
              portNo = arr.find((k) => k.FriabilityId).PortNo;
              instrumentId = arr.find((k) => k.FriabilityId).FriabilityId;
            } else {
              menuName = GLOBAL_NOMENCLATURE.Friability;
              if (serverConfig.friabilityType == "OF") {
                strInstrumentType = GLOBAL_NOMENCLATURE.Friability;
                portNo = arr.find((k) => k.FriabilityId).PortNo;
                instrumentId = arr.find((k) => k.FriabilityId).FriabilityId;
              } else {
                strInstrumentType = GLOBAL_NOMENCLATURE.Balance;
                portNo = arr.find((k) => k.BalanceId).PortNo;
                // instrumentId = arr.find(k => k.FriabilityId).FriabilityId;
                instrumentId = arr.find((k) => k.BalanceId).BalanceId;
              }
            }
          }
          break;
        case GLOBAL_NOMENCLATURE.LeakTestMenu:
          {
            menuName = GLOBAL_NOMENCLATURE.LeakTestMenu;
            strInstrumentType = GLOBAL_NOMENCLATURE.LeakTester;
            instrumentId = arr.find((k) => k.LeakTestId).LeakTestId;
            portNo = arr.find((k) => k.LeakTestId).PortNo;
          }
          break;
        case GLOBAL_NOMENCLATURE.Disintegration:
        case "Disintegration Test":
          {
            menuName = GLOBAL_NOMENCLATURE.Disintegration;
            strInstrumentType = GLOBAL_NOMENCLATURE.DT;
            instrumentId = arr.find((k) => k.DTId).DTId;
            portNo = arr.find((k) => k.DTId).PortNo;
          }
          break;

        case GLOBAL_NOMENCLATURE.Differential:
          {
            menuName = GLOBAL_NOMENCLATURE.Differential;
            strInstrumentType = GLOBAL_NOMENCLATURE.Balance;
            instrumentId = arr.find((k) => k.BalanceId).BalanceId;
            portNo = arr.find((k) => k.BalanceId).PortNo;
          }
          break;
      }

      const DSBindingRes = await models.tbl_ds_binding.findAll({
        where: {
          DS_NUMBER: DsNo,
        }
      })

      const checkPort = DSBindingRes.filter((k) => k.PortNo == portNo)

      // if (DSBindingRes?.PortNo == portNo && DSBindingRes?.TAB_IP != TabIp) {
      if (checkPort.length > 0 && checkPort[0].TAB_IP != TabIp) {
        return Object.assign(resObj, {
          status: "fail",
          message: "Instrument is already in use",
        });
      } else {
        await models.tbl_ds_binding.update({
          MenuName: menuName,
          PortNo: portNo,
        }, {
          where: {
            DS_NUMBER: DsNo,
            TAB_IP: TabIp
          }
        })
      }


      const dynamicKey = Object.keys(prodtDetail1.Menus).find(key => key === menuName); // Modify condition as needed
      let dynamicData = null
      if (dynamicKey) {
        dynamicData = prodtDetail1.Menus[dynamicKey];

        // if (dynamicKey == "Leak Test") {
        //   dynamicData = {
        //     T2Neg: 0,
        //     T2Pos: 0,
        //     DP: 0
        //   }
        // }

        console.log(dynamicData); // Output: { T2Neg: 7, T2Pos: 8, DP: 3 }
      }

      let productDetail = dynamicData;

      const machineRes = await models.tbl_machine.findOne({
        where: {
          Machine_ID: objdetails.Sys_MachineCode
        }
      });

      const mesData = await models.tbl_mes_data.findOne({
        where: {
          BatchID: objdetails.Sys_Batch
        }
      })

      let noOfSamples = 0;
      if (objdetails.isManual == 1 && configFile.plant == 'PUI') {
        // manual flow
        // manual flow if startup -> Grp = 20 && Individual  will be from tbl_machine(no. of samples)
        if (objdetails.Sys_RptType == 1 && objdetails.isPreStart == 0) {
          if (menuName == GLOBAL_NOMENCLATURE.IndividualMenu) {
            noOfSamples = machineRes?.Machine_Sample;
          } else if (menuName == GLOBAL_NOMENCLATURE.GroupMenu) {
            noOfSamples = mesData.SampleCount;
          } else if (menuName == GLOBAL_NOMENCLATURE.Hardness) {
            noOfSamples = mesData.StartSampleCount;
          } else {
            noOfSamples = productDetail.noOfSamples;
          }
        } else {
          if (menuName == GLOBAL_NOMENCLATURE.IndividualMenu) {
            noOfSamples = mesData.GroupSampleCount;
          } else if (menuName == GLOBAL_NOMENCLATURE.GroupMenu) {
            noOfSamples = mesData.SampleCount;
          } else if (menuName == GLOBAL_NOMENCLATURE.Hardness) {
            noOfSamples = mesData.StartSampleCount;
          } else if (menuName == "Loss on Drying") {
            noOfSamples;
          } else {
            noOfSamples = productDetail.noOfSamples;
          }
        }

      } else {
        // for FT03
        if (menuName == GLOBAL_NOMENCLATURE.Hardness) {
          if (productDetail.arrHardnessColumn.includes("Hardness")) {
            noOfSamples =
              productDetail.arrHardnessColumnDetail[0].Hardness.noOfSamples;
          }
        } else if (menuName == "Loss on Drying") {
          noOfSamples;
        } else if (menuName == "Empty Group") {
          noOfSamples = productDetail.noOfSamples;
        } else if (menuName == GLOBAL_NOMENCLATURE.Differential) {
          noOfSamples = productDetail.noOfSamples
        } else if (menuName == GLOBAL_NOMENCLATURE.LockedLength) {
          noOfSamples = productDetail.noOfSamples
        }else if(objdetails.Sys_Area == 'Coating'){
          noOfSamples = productDetail.noOfSamples
        }
        else {
          noOfSamples = objdetails.isManual == 1 ? machineRes?.Machine_Sample : productDetail.noOfSamples;
        }
      }
      if (menuName == GLOBAL_NOMENCLATURE.Friability) noOfSamples = `${noOfSamples} *`;


      const originalDS = await models.tbl_cubical.findOne({
        where: {
          Sys_DSNumber: DsNo
        }
      })
      var instruID
      if (menuName == GLOBAL_NOMENCLATURE.Hardness) {
        instruID = originalDS.Sys_HardID
      } else {
        instruID = originalDS.Sys_LeakID
      }
      const instrumentRes = await models.tbl_otherequipment.findOne({
        where: {
          Eqp_ID: instruID
        }
      })
      const productSampleRes = await models.tbl_cubicle_product_sample.findOne({
        where: {
          Sys_CubicNo: originalDS.Sys_CubicNo,
        }
      });
      var groupQty = CubicInfo.isPreStart == 1 ? 20 : productSampleRes.Group
      productDetail.groupQty = groupQty
      var individualsamplecount = productSampleRes.Individual
      //storing menu stype globally
      let objSelMenu = globalData.arrSelectedMenu.find((k) => k.TabIp == TabIp && k.DsNo == DsNo);
      if (objSelMenu == undefined) {
        globalData.arrSelectedMenu.push({
          SFOID: CubicInfo.Sys_SFOID,
          testType: CubicInfo.Sys_Area == "Coating" ? CubicInfo.MesTestType : CubicInfo.Sys_RptType,
          batchStatus: CubicInfo.Sys_Batch_Status,
          repetition: CubicInfo.Sys_Repetition,
          menuName: menuName,
          selectedProductDetail: productDetail,
          instrumentId: instrumentId,
          InstrumentType: strInstrumentType,
          EquipmentCode: originalDS.Sys_MachineCode,
          noOfSamples,
          individualsamplecount: individualsamplecount,
          groupQty: groupQty,
          rotary: StrRotaryType,
          Side: StrRotaryType,
          EGSampleCount: mesData.EGSampleCount,
          CISampleCount: mesData.CISampleCount,
          portNo: portNo,
          DsNo,
          DsIp,
          TabIp,
          MPN,
          StartSampleCount: productSampleRes.Hardness,
          // MPR: CubicInfo.BFGCode,
          // Make: (instrumentRes?.Eqp_Model) ? instrumentRes.Eqp_Model : "",
          Make: (instrumentRes?.Eqp_Make) ? instrumentRes.Eqp_Make : "",
          Model: (instrumentRes?.Eqp_Model) ? instrumentRes.Eqp_Model : ""
        });
      } else {
        objSelMenu.SFOID = CubicInfo.Sys_SFOID;
        objSelMenu.testType = CubicInfo.Sys_Area == "Coating" ? CubicInfo.MesTestType : CubicInfo.Sys_RptType;
        objSelMenu.repetition = CubicInfo.Sys_Repetition;
        objSelMenu.batchStatus = CubicInfo.Sys_Batch_Status
        objSelMenu.menuName = menuName;
        objSelMenu.selectedProductDetail = productDetail;
        objSelMenu.instrumentId = instrumentId;
        objSelMenu.InstrumentType = strInstrumentType;
        objSelMenu.portNo = portNo;
        objSelMenu.TabIp;
        objSelMenu.noOfSamples = noOfSamples;
        objSelMenu.groupQty = groupQty;
        objSelMenu.EGSampleCount = mesData.EGSampleCount;
        objSelMenu.CISampleCount = mesData.CISampleCount;
        objSelMenu.individualsamplecount = individualsamplecount
        objSelMenu.rotary = StrRotaryType;
        objSelMenu.Side = StrRotaryType;
        objSelMenu.EquipmentCode = originalDS.Sys_MachineCode
        objSelMenu.DsNo = DsNo
        objSelMenu.MPN = MPN
        // objSelMenu.MPR = CubicInfo.BFGCode
        objSelMenu.Make = (instrumentRes?.Eqp_Make) ? instrumentRes.Eqp_Make : ""
        objSelMenu.Model = (instrumentRes?.Eqp_Model) ? instrumentRes.Eqp_Model : ""
        objSelMenu.prestart = CubicInfo.isPreStart
      }

      objSelMenu = globalData.arrSelectedMenu.find((k) => k.TabIp == TabIp && k.DsNo == DsNo);
      let T1_Pos_ActualValue,
        T1_Neg_ActualValue,
        T2_Pos_ActualValue,
        T2_Neg_ActualValue;

      /**
       * getting uppper and lower value.
       */
      var dp;
      if (productDetail != null) {
        if (productDetail.unit == "mg") {
          dp = 3;
        } else if (productDetail.unit == "gm") {
          dp = 3;
        } else if (productDetail.unit == undefined) {
          dp = 3;
        }
      }

      // let editableSide = StrRotaryType == "Double" ? true : false;
      let editableSide = false;
      let editableSampleNo = false;


      if (menuName != GLOBAL_NOMENCLATURE.HardnessMenu) {
        let nominal;
        if (productDetail.Nominal) {
          nominal = productDetail.Nominal
        } else {
          nominal = productDetail?.Nom ? productDetail.Nom : "NA"
        }
        if (menuName == GLOBAL_NOMENCLATURE.Friability) { nominal = `NMT ${nominal} %` }
        if (menuName == GLOBAL_NOMENCLATURE.DTMenu) { nominal = `NMT ${nominal} mm:ss` }
        if (menuName == GLOBAL_NOMENCLATURE.LODMenu) { nominal = `${productDetail.T2Neg}` }

        if (productDetail?.Unit) {
          productDetail.Unit = productDetail.Unit.toLowerCase() == 'gm' ? 'g' : productDetail.Unit
        }

        obj1 = {
          menuName: menuName.replace(/\_/g, " "),
          noOfSample:
            productDetail.noOfSamples == undefined
              ? undefined
              : productDetail.noOfSamples.toString(),
          Rotary: StrRotaryType,
          // ProductId: StrBFGCode,
          // ProductName: productName,
          MPN: MPN,
          ProductVersion: ProductVersion,
          Version: Version,
          Batch: StrBatch,
          Nominal:
            productDetail.nominal == null
              ? productDetail.Nom == null ? null : Number(productDetail.Nom).toFixed(productDetail.dp).concat(` ${productDetail.Unit}`)
              : productDetail.nominal.toString().includes(":")
                ? productDetail.nominal
                : Number(productDetail.nominal)
                  .toFixed(productDetail.dp)
                  .concat(` ${productDetail.unit}`),
          Dp: productDetail.dp,
          T1Neg:
            T1_Neg_ActualValue != undefined
              ? T1_Neg_ActualValue.trim()
              : Number(productDetail.T1Neg)
                .toFixed(productDetail.dp)
                .concat(` ${productDetail.unit}`)
                .trim(),
          T1Pos:
            T1_Pos_ActualValue != undefined
              ? T1_Pos_ActualValue.trim()
              : Number(productDetail.T1Pos)
                .toFixed(productDetail.dp)
                .concat(` ${productDetail.unit}`)
                .trim(),
          T2Neg:
            T2_Neg_ActualValue = Number(productDetail.T2Neg).toFixed(productDetail.dp).concat(` ${productDetail.Unit}`).trim(),
          T2Pos:
            T2_Pos_ActualValue = Number(productDetail.T2Pos).toFixed(productDetail.dp).concat(` ${productDetail.Unit}`).trim(),
          pl_mi_limit: productDetail.plmiLimit,
          AirVibrationLimit: "0.014",
          Range: nominal
          // Side: ["NA"],
        };
      }

      if (menuName == GLOBAL_NOMENCLATURE.HardnessMenu) {
        obj1 = {
          menuName: menuName.replace(/\_/g, " "),
          noOfSample: productDetail.noOfSamples == undefined ? undefined : productDetail.noOfSamples.toString(),
          Rotary: StrRotaryType,
          // ProductId: StrBFGCode,
          // ProductName: productName,
          MPN: MPN,
          ProductVersion: ProductVersion,
          Version: Version,
          Batch: StrBatch,
          Dp: productDetail.dp,
          // Side: ["NA"],
          // Hard_T2Neg: productDetail.T2_Neg_ActualValuehard != undefined ? hardnessthickness.T2_Neg_ActualValuehard : 0,
          // Hard_T2Pos: hardnessthickness.T2_Pos_ActualValuehard != undefined ? hardnessthickness.T2_Pos_ActualValuehard : 0,
          // "Thick_T2Neg(mm)": T2_Neg_ActualValue != undefined ? T2_Neg_ActualValue : 0,
          // "Thick_T2Pos(mm)": T2_Pos_ActualValue != undefined ? T2_Pos_ActualValue : 0,
          // column: productDetail.arrHardnessColumn,
          // columnDetail: productDetail.arrHardnessColumnDetail,
          AirVibrationLimit: "0.014",
        };
      }

      if (menuName == GLOBAL_NOMENCLATURE.DT || menuName == 'Disintegration Test' || menuName == 'Disintegration') {
        let DTRes = await models.tbl_otherequipment.findOne({
          where: {
            Eqp_ID: CubicInfo.Sys_DTID
          }
        })

        let ManualDt = 0; // PUI Changes Manual flow Enabled the manual form.
        obj1["isManual"] = ManualDt;
      }

      if (menuName == GLOBAL_NOMENCLATURE.Friability) {
        let FTRes = await models.tbl_otherequipment.findOne({
          where: {
            Eqp_ID: CubicInfo.Sys_FriabID
          }
        })

        let ManualFriab = FTRes.Eqp_Model == "EF2-W" ? 1 : 0;
        obj1["isManual"] = ManualFriab;
      }

      if (
        menuName.replace(/\_/g, " ") ==
        (GLOBAL_NOMENCLATURE.TabletTesterMenu ||
          GLOBAL_NOMENCLATURE.HardnessMenu)
      ) {
        const HardnessType = await this.getDetailOfBulkInstrumentModel(
          instrumentId
        );
        obj1["type"] = HardnessType.Eqp_HT_Type;
      }

      let FTPModel = "";

      if (menuName.replace(/\_/g, " ") == GLOBAL_NOMENCLATURE.TabletTesterMenu ||
        menuName.replace(/\_/g, " ") == GLOBAL_NOMENCLATURE.HardnessMenu) {
        obj1["column"] = productDetail.arrHardnessColumn;
        obj1["columnDetail"] = productDetail.arrHardnessColumnDetail;

        const HardnessInstrumentRes = await this.getDetailOfBulkInstrumentModel(
          instrumentId
        );
        console.log('HardnessInstrumentRes: ', HardnessInstrumentRes);

        if (globalData.FTPHardnessModel.includes(HardnessInstrumentRes.Eqp_Model)) {
          FTPModel = HardnessInstrumentRes.Eqp_Model
          isFTP = true
        }
        // if (
        //   menuName.replace(/\_/g, " ") ==
        //   (GLOBAL_NOMENCLATURE.TabletTesterMenu ||
        //     GLOBAL_NOMENCLATURE.HardnessMenu)
        // ) {
        obj1["hardnessVarient"] = HardnessInstrumentRes.Eqp_Make == 'Pharmatest' ? 1 : 0
        if (originalDS.Sys_RptType == 1) { obj1["hardnessVarient"] = 0 }
        if (obj1["hardnessVarient"] == 1 && menuName == GLOBAL_NOMENCLATURE.HardnessMenu && CubicInfo.Sys_RptType == 0) {
          var Indidata = globalData.arr_limits.find((k) => k.DsNo == DsNo && k.TabIp == TabIp)
          Indidata = Indidata.Menus.Individual
          if (Indidata != undefined) {
            // return Object.assign(resObj, {
            //   status: "fail",
            //   result: 'For pharmaTest individual range not found',
            // });
            obj1["Nominal"] = Number(Indidata.Nom).toFixed(Indidata.dp).concat(` ${Indidata.Unit}`).trim()
            obj1["pl_mi_limit"] = Indidata.plmiLimit.trim()
            obj1["T2Neg"] = Number(Indidata.T2Neg).toFixed(Indidata.dp).concat(` ${Indidata.Unit}`).trim()
            obj1["T2Pos"] = Number(Indidata.T2Pos).toFixed(Indidata.dp).concat(` ${Indidata.Unit}`).trim()
            obj1["Unit"] = Indidata.Unit
            obj1["dp"] = Indidata.dp
          }
        }
        objSelMenu.isFTP = isFTP
        // }

      }
      if (menuName == GLOBAL_NOMENCLATURE.IndividualMenu && CubicInfo.Sys_RptType == 1) {
        let checkPharmaTest = await models.tbl_otherequipment.findOne({
          attributes: ['Eqp_Model'],
          where: {
            Eqp_ID: originalDS.Sys_HardID
          }
        })
        // if (checkPharmaTest?.Eqp_Model == 'Pharmatest') isFTP = true
        if (checkPharmaTest?.Eqp_Make == 'Pharmatest') isFTP = true
        // FTPModel = HardnessInstrumentRes.Eqp_Model
      }
      const arrIdsInfo = globalData.arrIdsInfo.find(k => k.DsNo == DsNo && k.TabIp == TabIp)
      let containerId = 'NA';
      let getTableName = objCommonWeightment.getTableName(CubicInfo, menuName, DsNo, TabIp)
      if (CubicInfo.Sys_RptType == 1) {
        let isEntryPresentInMaster = await models[getTableName.masterTable].count({
          where: {
            BatchNo: CubicInfo.Sys_Batch,
            ...(CubicInfo.Sys_Repetition ? { Repetition: CubicInfo.Sys_Repetition } : {}),
            ReportType: CubicInfo.Sys_RptType,
            MesSide: CubicInfo?.MesSide,
            MesTestType: CubicInfo.MesTestType,
            SFOID: CubicInfo.Sys_SFOID,
          }
        })
        containerId = (isEntryPresentInMaster == 0) ? containerId = 'NA' : '';
      }
      let menuSequence = await models.tbl_menu_sequence.findOne({ where: { DS_Number: DsNo, TabIp: TabIp, RepSerNo: { [Op.ne]: 0 } } })
      if (menuSequence) {
        let getContainerId = await models[getTableName.masterTableIncomplete].findOne({
          attributes: ['LHSContainerNo', 'RHSContainerNo'],
          where: {
            RepSerNo: menuSequence.RepSerNo
          }
        })
        if (getContainerId) {
          if (getContainerId.RHSContainerNo != 'NA' || getContainerId.LHSContainerNo != 'NA') {
            containerId = (getContainerId.RHSContainerNo == 'NA') ? getContainerId.LHSContainerNo : getContainerId.RHSContainerNo;
          }
        }
      }

      if (CubicInfo.MesTestType == 'Startup' || CubicInfo.MesTestType.includes("Pre")) {
        containerId = "NA";
      }

      obj1["SFOID"] = objSelMenu.SFOID;
      obj1["testType"] = dynamicKey == "Leak Test" ? 0 : objSelMenu.testType;
      obj1["repetition"] = dynamicKey == "Leak Test" ? "NA" : objSelMenu.repetition;
      obj1["equipment"] = objSelMenu.EquipmentCode;
      obj1["instrument"] = instrumentId;
      obj1['noOfSample'] = noOfSamples;
      // obj1['isFTP'] = false;
      obj1['isFTP'] = isFTP;
      obj1["FTPModel"] = isFTP ? FTPModel : ""
      obj1['batchStatus'] = dynamicKey == "Leak Test" ? arrIdsInfo.isMannual ? ["Initial Setup", "Start Of Batch", "QA In Process", "End Of Batch"] : [objSelMenu.batchStatus] : []
      obj1['isBatchEditable'] = dynamicKey == "Leak Test" ? arrIdsInfo.isMannual ? true : false : "";
      obj1["editableSide"] = editableSide;
      obj1["editableSampleNo"] = editableSampleNo;
      obj1["Side"] = [StrRotaryType ? StrRotaryType : 'NA'];
      obj1["MPR"] = objSelMenu.MPN;
      obj1["MPN"] = objSelMenu.MPN;
      obj1["make"] = objSelMenu.Make;
      obj1["model"] = objSelMenu.Model,
        obj1["productId"] = productId;
      obj1["productName"] = productName;
      obj1["containerId"] = containerId;
      obj1['Area'] = CubicInfo.Sys_Area ? CubicInfo.Sys_Area : CubicInfo.Sys_CubType;
      obj1['LotNo'] = CubicInfo.Sys_LotNo
      obj1['prestart'] = CubicInfo.isPreStart
      obj1['TT'] = CubicInfo.MesTestType
      return Object.assign(resObj, {
        status: "success",
        result: obj1,
      });

    } catch (error) {
      throw new Error(error);
    }
  }

  /**
   * @description:function will give jars or basket according to model
   *
   */
  async getDetailOfBulkInstrumentModel(instrumentId , InstrumentType) {
    try {
      const obj = await models.tbl_otherequipment.findAll({
        where: {
          Eqp_ID: instrumentId,
          ...(InstrumentType ? {Eqp_Type : InstrumentType} : {})
        },
      });
      let res = [obj];
      if (res[0].length <= 0) {
        return undefined;
      }
      return res[0][0];
    } catch (error) {
      throw new Error(error);
    }
  }

  async checkFriabilityStatus(IdsNo) {
    var IPQCObject = globalData.arr_IPQCRelIds.find((k) => k.idsNo == IdsNo);
    var selectedIds;
    var returnResult = {};
    if (IPQCObject != undefined) {
      selectedIds = IPQCObject.selectedIds;
    } else {
      selectedIds = IdsNo;
    }
    var tempCubic = globalData.arrIdsInfo.find(
      (k) => k.idsNo == selectedIds
    ).cubicalData;
    const checkData = await models.tbl_tab_friability.findAll({
      attributes: [[sequelize.fn("max", sequelize.col("RepSerNo")), "SeqNo"]],
      where: {
        BFGCode: tempCubic.Sys_BFGCode,
        ProductName: tempCubic.Sys_ProductName,
        PVersion: tempCubic.Sys_PVersion,
        Version: tempCubic.Sys_Version,
        BatchNo: tempCubic.Sys_Batch,
        IdsNo: selectedIds,
      },
    });
    // {
    //     str_tableName: 'tbl_tab_friability',
    //     data: 'MAX(RepSerNo) AS SeqNo',
    //     condition: [
    //         { str_colName: 'BFGCode', value: tempCubic.Sys_BFGCode, comp: 'eq' },
    //         { str_colName: 'ProductName', value: tempCubic.Sys_ProductName, comp: 'eq' },
    //         { str_colName: 'PVersion', value: tempCubic.Sys_PVersion, comp: 'eq' },
    //         { str_colName: 'Version', value: tempCubic.Sys_Version, comp: 'eq' },
    //         { str_colName: 'BatchNo', value: tempCubic.Sys_Batch, comp: 'eq' },
    //         { str_colName: 'IdsNo', value: selectedIds, comp: 'eq' },
    //     ]
    // }
    var checkFlag = 0;
    var chkResult = [checkData];
    var result = [];
    if (chkResult[0][0].SeqNo == null) {
      checkFlag = 0;
    } else {
      checkFlag = 1;
    }
    if (checkFlag == 1) {
      var fraibData = await models.tbl_tab_friability.findAll({
        where: {
          RepSerNo: chkResult[0][0].SeqNo,
        },
      });
      //  {
      //     str_tableName: 'tbl_tab_friability',
      //     data: '*',
      //     condition: [
      //         { str_colName: 'RepSerNo', value: chkResult[0][0].SeqNo, comp: 'eq' },
      //     ]
      // }
      result = [fraibData];
      result = result[0];
    }
    if (result.length > 0) {
      if (tempCubic.Sys_RotaryType == "Double") {
        if (
          result[0].LWtBeforeTest != 0 &&
          result[0].LWtAfterTest != 0 &&
          result[0].RWtBeforeTest != 0 &&
          result[0].RWtAfterTest != 0
        ) {
          Object.assign(returnResult, {
            status: "before",
            sqNo: result[0].RepSerNo,
          });
        } else if (
          result[0].LWtBeforeTest != 0 &&
          result[0].LWtAfterTest == 0 &&
          result[0].RWtBeforeTest == 0 &&
          result[0].RWtAfterTest == 0
        ) {
          Object.assign(returnResult, {
            status: "before",
            sqNo: result[0].RepSerNo,
          });
        } else if (
          result[0].LWtBeforeTest != 0 &&
          result[0].LWtAfterTest != 0 &&
          result[0].RWtBeforeTest != 0 &&
          result[0].RWtAfterTest == 0
        ) {
          Object.assign(returnResult, {
            status: "after",
            sqNo: result[0].RepSerNo,
          });
        } else if (
          result[0].LWtBeforeTest != 0 &&
          result[0].LWtAfterTest == 0 &&
          result[0].RWtBeforeTest != 0 &&
          result[0].RWtAfterTest == 0
        ) {
          Object.assign(returnResult, {
            status: "after",
            sqNo: result[0].RepSerNo,
          });
        } else if (
          result[0].LWtBeforeTest == 0 &&
          result[0].LWtAfterTest == 0 &&
          result[0].RWtBeforeTest == 0 &&
          result[0].RWtAfterTest == 0
        ) {
          Object.assign(returnResult, {
            status: "before",
            sqNo: result[0].RepSerNo,
          });
        }
      } else {
        if (result[0].NWtBeforeTest != 0 && result[0].NWtAfterTest != 0) {
          Object.assign(returnResult, {
            status: "before",
            sqNo: result[0].RepSerNo,
          });
        } else if (
          result[0].NWtBeforeTest != 0 &&
          result[0].NWtAfterTest == 0
        ) {
          Object.assign(returnResult, {
            status: "after",
            sqNo: result[0].RepSerNo,
          });
        } else if (
          result[0].NWtBeforeTest == 0 &&
          result[0].NWtAfterTest == 0
        ) {
          Object.assign(returnResult, {
            status: "before",
            sqNo: result[0].RepSerNo,
          });
        }
      }
    } else {
      Object.assign(returnResult, { status: "before", sqNo: 0 });
    }
    return returnResult;
  }

  DateFormat(date, time) {
    var days = date.getDate();
    var year = date.getFullYear();
    var month = date.getMonth() + 1;

    // minutes = minutes < 10 ? '0' + minutes : minutes;
    var strTime = month + "/" + days + "/" + year + " " + time;
    //var strTime = hours + ':' + minutes;
    return strTime;
  }
  async CheckHardnessModel(idsNo) {
    try {
      var cubicInfo = globalData.arrIdsInfo.find(
        (k) => k.idsNo == idsNo
      ).cubicalData;
      var hardnessId = cubicInfo.Sys_HardID;
      var selectOtherEquip = await models.tbl_otherequipment.findAll({
        where: {
          Eqp_ID: hardnessId,
        },
      });
      var result = [selectOtherEquip];
      return result[0][0];
    } catch (error) {
      throw new Error(error);
    }
  }

  async lockedWeighingStatus(cubicalNo, BatchNo, CubType) {
    try {
      await models.tbl_system_weighingstatus.update(
        {
          Status: 1,
          BatchNo: BatchNo,
          CubType: CubType,
        },
        {
          where: {
            CubicleNo: cubicalNo,
          },
        }
      );
    } catch (error) {
      console.log(error);
    }
  }
  async calculateHardThick(data) {
    var objSelMenu = data;

    if (data.Hard_nominal != 0) {
      var T1_Pos_ActualValuehard = Number(
        objFormulaFun.HardnessupperLimit(objSelMenu, "T1")
      )
        .toFixed(objSelMenu.dp)
        .concat(` ${objSelMenu.Hard_unit}`);

      var T1_Neg_ActualValuehard = Number(
        objFormulaFun.HardnesslowerLimit(objSelMenu, "T1")
      )
        .toFixed(objSelMenu.dp)
        .concat(` ${objSelMenu.Hard_unit}`);

      var T2_Pos_ActualValuehard = Number(
        objFormulaFun.HardnessupperLimit(objSelMenu, "T2")
      )
        .toFixed(objSelMenu.dp)
        .concat(` ${objSelMenu.Hard_unit}`);

      var T2_Neg_ActualValuehard = Number(
        objFormulaFun.HardnesslowerLimit(objSelMenu, "T2")
      )
        .toFixed(objSelMenu.dp)
        .concat(` ${objSelMenu.Hard_unit}`);
      var obj = {
        T1_Pos_ActualValuehard: T1_Pos_ActualValuehard,
        T1_Neg_ActualValuehard: T1_Neg_ActualValuehard,
        T2_Pos_ActualValuehard: T2_Pos_ActualValuehard,
        T2_Neg_ActualValuehard: T2_Neg_ActualValuehard,
      };

      return obj;
    }
    // if(data.Thick_nominal != 0){
    //     T1_Pos_ActualValue = Number(objFormulaFun.upperLimit(objSelMenu.selectedProductDetail, "T1"))
    //     .toFixed(dp).concat(` ${productDetail.unit == undefined ? productDetail.Thick_unit : productDetail.unit}`);

    // T1_Neg_ActualValue = Number(objFormulaFun.lowerLimit(objSelMenu.selectedProductDetail, "T1"))
    //     .toFixed(dp).concat(` ${productDetail.unit == undefined ? productDetail.Thick_unit : productDetail.unit}`);

    // T2_Pos_ActualValue = Number(objFormulaFun.upperLimit(objSelMenu.selectedProductDetail, "T2"))
    //     .toFixed(dp).concat(` ${productDetail.unit == undefined ? productDetail.Thick_unit : productDetail.unit}`);

    // T2_Neg_ActualValue = Number(objFormulaFun.lowerLimit(objSelMenu.selectedProductDetail, "T2"))
    //     .toFixed(dp).concat(` ${productDetail.unit == undefined ? productDetail.Thick_unit : productDetail.unit}`);
    // }
  }

  async getContainerFlag(cubicalRes, menuName, dsNo, tabIp, mesRes) {
    let container = false;
    var menuSequenceTable = await models.tbl_menu_sequence.findOne({
      attributes: { exclude: ['DS_Number', 'UserId', 'RecNo', 'TabIp'] },
      where: {
        DS_Number: dsNo,
        TabIp: tabIp
      }
    })
    var count = 0;
    for (let ele in menuSequenceTable) {
      if (menuSequenceTable[`${ele}`] == 1) count++
      if (ele == 'FRIAB') {
        let powerbacc = await models.tbl_powerbackup.findAll({
          where: {
            WeighmentName: 'FRIAB',
            CubicalNo: cubicalRes.Sys_CubicNo,
            Sys_Batch: cubicalRes.Sys_Batch,
            WeighmentName: 'FRIAB',
            DsNo: dsNo,
            TabIp: tabIp,
            MPN_Code: cubicalRes.Sys_MPNCode,
            Incomp_RepSerNo: menuSequenceTable[`RepSerNo`]
          }
        })

        if (powerbacc.length > 0) return false
      }
    }

    if (count == 0) {
      if (cubicalRes.Sys_RptType == 1 && mesRes.ProductType ==1) {
        let isEntryPresentInMaster = await models.tbl_tab_initialmaster.count({
          where: {
            BatchNo: mesRes.BatchID,
            // Repetition: obj.Repetition,
            ReportType: mesRes.TestType,
            MesSide: mesRes?.MesSide,
            MesTestType: mesRes.MesTestType
          }
        })

        if (isEntryPresentInMaster == 0) {
          container = false
        } else {
          container = true
        }
        return container
      }else if((cubicalRes.Sys_Area!='Coating' && cubicalRes.Sys_Area !='Granulation') && mesRes.ProductType ==1){
        
        let isInCompletePresent = await models.tbl_tab_initialmaster_incomplete.count({
          where: {
            BatchNo: mesRes.BatchID,
            // Repetition: obj.Repetition,
            RepSerNo:menuSequenceTable[`RepSerNo`]
          }
        })
        isInCompletePresent ? container = false :container = true
      }
    } else {
      container = false
    }

    return container

    // let tableNames = objCommonWeightment.getTableName(cubicalRes, menuName, dsNo, tabIp);
    // let Container = mesRes.MesSide == 'LHS' || mesRes.MesSide == 'NA' ? 'LHSContainerNo' : 'RHSContainerNo'
    // let failedRemark = [{ 'Param1_FailRemark': 'NULL' }, { 'Param2_FailRemark': 'NULL' }, { 'Param3_FailRemark': 'NULL' }, { 'Param7_FailRemark': 'NULL' }, { 'Param8_FailRemark': 'NULL' }, { 'Param13_FailRemark': 'NULL' }]
    // let conditions = { [Op.and]: [...failedRemark] }
    // let containerValue = await models[tableNames.masterTableIncomplete].findAll({
    //   attributes: [Container],
    //   where: {
    //     BatchNo: cubicalRes.Sys_Batch,
    //     DsNo: dsNo,
    //     TabIp: tabIp,
    //     ...conditions
    //   }

    // });
    // console.log(containerValue ? containerValue[containerValue.length - 1]?.[Container] : null)
    // if (containerValue.length > 0) {
    //   let containerField = containerValue ? (containerValue[containerValue.length - 1][Container] != 'NA' && containerValue[containerValue.length - 1][Container] != 'Null') ? false : true : true
    //   return containerField
    // } else {

    //   return true;
    // }
  }

  async isValidCertification(Eqp_Date, Eqp_ID, TabIp, DsNo) {
    try {
      let resObj;
      let isValid = moment(Eqp_Date, "YYYY-MM-DD", true).isSameOrBefore(moment(), 'day');//if it is valid it will return false
      if (isValid) {
        resObj = {
          status: "fail",
          message: `${Eqp_ID} Certification has Expired`,
          tabIp: TabIp,
          isExpired: isValid
        }
        return mqttSender.sendData(DsNo, `GetMenuRes:${JSON.stringify(resObj)}`);
      }
    } catch (err) {
      console.log(err);
      return;
    }

  }
}

module.exports = Menu;

