

//modules
const ClearGlobalArrayModel = require('../clearGlobalArrays.model');
const DailyCalibrationModel = require('../Calibration/clsdailyCalibration.model');
const ClassPeriodicCalibration = require('../Calibration/clsPeriodicCalibration.model');
const ClassEccenCalibration = require('../Calibration/clsEccentricity.model');
const RepeatabilityCalibrationModel = require('../Calibration/clsRepeatability.model');
const uncertinityCalibrationModel = require('../Calibration/clsUncertainty.model');
const linearityCalibrationModel = require('../Calibration/clslinearity.model');
const classHmi = require('../hmiDetail.model');
const clsBalanceParsing = require('../InstrumentParsings/clsBalanceParsing');
const clsHardnessParsing = require('../InstrumentParsings/clsHardnessParsing');
const clsMoistureParsing = require('../InstrumentParsings/clsMoistureAnalyserParsing');
const clsLeakParsing = require('../InstrumentParsings/clsLeakParsing');
const GLOBAL_NOMENCLATURE = require('../../global/GLOBAL_NOMENCLATURE');
const clsMqttSender = require('../Mqtt/mqttSender.class')
const clsVernierParsing = require('../InstrumentParsings/clsVernierParsing')
const MenuClass = require("../Menu/MenuRequest.model");
const globalData = require('../../global/globalData')
const serverConfig = require('../../global/serverConfig')
const menuSchema = require('../../validation/menu/menu.Schema');
const clsIpqc = require('../IPQC/ipqc.model');
const clsFriabParsing = require('../InstrumentParsings/clsFriabParsing');
const clsDTParsing = require("../InstrumentParsings/clsDTParsing");


//instances
const objIpqc = new clsIpqc();
const objClearArray = new ClearGlobalArrayModel();
const objHmi = new classHmi();
const objBalanceParsing = new clsBalanceParsing();
const objHardnessParsing = new clsHardnessParsing();
const objMoistureParsing = new clsMoistureParsing();
const objLeakParsing = new clsLeakParsing();
const mqttSender = new clsMqttSender();
const objVernierParsing = new clsVernierParsing();
const objMenu = new MenuClass();
const objFriabilityParsing = new clsFriabParsing();
const objDTParsing = new clsDTParsing();


class MQTTHandler {

    precision(a) {
        if (!isFinite(a)) return 0;
        var e = 1, p = 0;
        while (Math.round(a * e) / e !== a) { e *= 10; p++; }
        return p;
    }

    //
    async handleProtocol(str_Protocol, dsIp) {
        try {
            // loggers.MqttProtocolLogger.info(`protocol : ${str_Protocol} Received from device ${dsIp}`)

            const unWantedProtocols = [
                "ACK_DisableCom".toLowerCase(),
                "ACK_EnableCom".toLowerCase(),
                "Hamster Pro20 not found".toLowerCase(),
                "ACK_Disconnected".toLowerCase(),
                'ack_',
                'nack_'
            ]
            if (str_Protocol == "" ||
                unWantedProtocols.some(el => str_Protocol.toLowerCase().includes(el) || str_Protocol.toLowerCase().startsWith(el))) {
                return;
            }


            if (str_Protocol.toLowerCase() == "Disconnected".toLowerCase()) {
                return;
            }

            let str_ProtocolData = str_Protocol;
            let ProtocolName = str_ProtocolData.split(":")[0];
            let ProtocolPortNo = parseInt(str_ProtocolData.split(":")[1]);
            let tblRpiResult = await objHmi.getRPiData(dsIp, ProtocolPortNo);

            if (!tblRpiResult) {
                console.log("DS is not connected");
                return
            }

            // sendMenu
            if (str_Protocol.split(":")[0].toLowerCase() === GLOBAL_NOMENCLATURE.GetMenu.toLowerCase()) {
                let menuData = str_Protocol.replace(`${GLOBAL_NOMENCLATURE.GetMenu}:`, '');
                menuData = JSON.parse(menuData)
                const { error, value } = menuSchema.ValidateGetMenu().validate(menuData);
                if (error) {
                    let resObj = {
                        statusCode: 400,
                        status: "fail",
                        tabIp: tblRpiResult.TAB_IP,
                        message: error.details[0].message.replace(/"/g, "")
                    }

                    return mqttSender.sendData(tblRpiResult.DS_NUMBER, `GetMenuRes:${JSON.stringify(resObj)}`)
                }
                objMenu.sendMenu(menuData);
                return
            }

            // onAreaSelectionGetBatch
            if (str_Protocol.split(":")[0].toLowerCase() === GLOBAL_NOMENCLATURE.onAreaSelectionGetBatch.toLowerCase()) {
                let ipqcData = str_Protocol.replace(`${GLOBAL_NOMENCLATURE.onAreaSelectionGetBatch}:`, '');
                ipqcData = JSON.parse(ipqcData)

                objIpqc.getBatchlistAccordingToArea(ipqcData)
                return
            }

            // selectList
            if (str_Protocol.split(":")[0].toLowerCase() === GLOBAL_NOMENCLATURE.selectList.toLowerCase()) {
                let selectedList = str_Protocol.replace(`${GLOBAL_NOMENCLATURE.selectList}:`, '');
                selectedList = JSON.parse(selectedList)

                objIpqc.selectedList(selectedList)
                return
            }


            if (tblRpiResult.hasOwnProperty('message')) {
                return mqttSender.sendData(tblRpiResult.DS_NUMBER, `Port ${ProtocolPortNo}:${GLOBAL_NOMENCLATURE.DisplayMessage} ${tblRpiResult.message}`)
            }

            if (!tblRpiResult) {
                console.log('Invalid port')
                return
            }



            const arrCurrentOperation = globalData.arrCurrentOperationStatus.find(k => k.DsNo == tblRpiResult.DS_NUMBER && k.TabIp == tblRpiResult.TAB_IP);
            const arrCalibInProcess = globalData.arrcalibType.find(k => k.DsNo == tblRpiResult.DS_NUMBER && k.TabIp == tblRpiResult.TAB_IP);
            if (arrCurrentOperation != undefined) {
                var selectedMenuDetails = globalData.arrSelectedMenu.find(k => k.DsNo == tblRpiResult.DS_NUMBER && k.TabIp == tblRpiResult.TAB_IP);
                if (!selectedMenuDetails) return;

                var intPortNo1 = selectedMenuDetails.portNo;
                var strInstrumentType = selectedMenuDetails.InstrumentType;
                var strInstrumentId = selectedMenuDetails.instrumentId;
            } else if (arrCalibInProcess != undefined) {
                let hmiDetails = globalData.arrSelectedBalWithHmi.find(k => k.DsNo == tblRpiResult.DS_NUMBER && k.TabIp == tblRpiResult.TAB_IP);
                var intPortNo1 = hmiDetails.portNo;
                var strInstrumentType = hmiDetails.InstrumentType;
                var strInstrumentId = hmiDetails.selectedBal;
            } else {
                return console.log('dont proceedd further')
            }

            let result;
            const __paramObj = {
                Str_Protocol: str_ProtocolData,
                InstrumentId: strInstrumentId,
                ProtocolPortNo: ProtocolPortNo,
                ProtocolName: ProtocolName,
                InstrumentType: strInstrumentType,
                SelectedMenuDetails: selectedMenuDetails,
                currentOpStatus: arrCurrentOperation,
                tempCailibType: arrCalibInProcess,
                TabIp: tblRpiResult.TAB_IP
            }

            if (ProtocolName.toLowerCase() === GLOBAL_NOMENCLATURE.ComRead.toLowerCase()) {
                switch (strInstrumentType) {
                    case GLOBAL_NOMENCLATURE.Balance: {
                        result = await objBalanceParsing.parsingBalanceData(__paramObj);
                        return result;
                    };
                    case GLOBAL_NOMENCLATURE.TabletTester:
                    case GLOBAL_NOMENCLATURE.Hardness: {
                        result = await objHardnessParsing.parseDataAccordingToModelHardness(__paramObj);
                        return result;
                    };
                    case GLOBAL_NOMENCLATURE.Vernier: {
                        result = await objVernierParsing.parsingVernierData(__paramObj);
                        return result;
                    };
                    case "Disintegration":
                    case GLOBAL_NOMENCLATURE.DT: {
                        result = await objDTParsing.parsingDTData(__paramObj);
                        return result;
                    };
                    case (GLOBAL_NOMENCLATURE.Friability): {
                        if (serverConfig.friabilityType == "OF") {
                            result = await objFriabilityParsing.parsingFriabilityData(__paramObj);
                            return result;
                        }

                    };
                    case GLOBAL_NOMENCLATURE.FriabilatorMenu: {
                        result = await objFriabilityParsing.parsingFriabilityBFBO(__paramObj);
                        return result;
                    };
                    case "LOD":
                    case GLOBAL_NOMENCLATURE.MoistureAnalyzer: {
                        // result = await objLeakParsing.parsingLeakData(__paramObj);
                        result = await objMoistureParsing.parsingMoistData(__paramObj);
                        return result;
                    };
                    case GLOBAL_NOMENCLATURE.LeakTester: {
                        result = await objLeakParsing.parsingLeakData(__paramObj);
                        return result;
                    }
                    case GLOBAL_NOMENCLATURE.TappedDensity: {
                        result = await objTappedDensity.parsingTappedDensityData(__paramObj);
                        return result;
                    };
                    case GLOBAL_NOMENCLATURE.PercentageFine: {
                        result = await objBalanceParsing.parsingBalanceData(__paramObj);
                        return result;
                    };
                    case GLOBAL_NOMENCLATURE.ParticalSizing: {
                        result = await objBalanceParsing.parsingBalanceData(__paramObj);
                        return result;
                    };

                }
            }
        } catch (error) {
            // loggers.MqttProtocolLogger.error(`${error} Received in calibDecider function from device : ${strResberryPi}`)
            throw new Error(error)
        }

    }

}

module.exports = MQTTHandler;