const globalData = require('../../global/globalData');
const BulkWeighment = require('../InstrumentParsings/clsHardnessParsing');
const ProtocolHandler = require("../Mqtt/mqttSender.class");
const serverConfig = require('../../../../IncrencyV4DRLTSHConfig.json');
const bulkWeighment = new BulkWeighment();
const protocolHandlerController = new ProtocolHandler();
const net = require('net');

const clients = {};  // Stores active connections per IP

const tcpServer = net.createServer();

tcpServer.on('connection', (connection) => {
    connection.setEncoding('utf8');

    const clientIP = connection.remoteAddress;
    console.log(`New connection from: ${clientIP}`);

    // Store connection
    clients[clientIP] = connection;

    connection.on('data', async (data) => {
        console.log(`===== Start processing data from ${clientIP} =====`);
        console.log(data);

        // Find cubical object based on IP
        let cubicalObj = globalData.arrIdsInfo.find(k => k.IPAddress == clientIP);
        if (!cubicalObj) {
            console.log(`IP ${clientIP} is not registered in Cubical.`);
            return;
        }


        let objHardness = globalData.arrHardness425.find(ht => ht.idsNo == cubicalObj.Sys_IDSNo);
        // if (!objHardness) {
        //     console.log(`No hardness tester linked to system ID: ${cubicalObj.Sys_IDSNo}`);
        // }


        try {
            let sendProtocol = await bulkWeighment.parsingHardnessData_Erweka425(data, cubicalObj);
            console.log(`Processed data for ${clientIP}`);
        } catch (error) {
            console.error(`Error processing data for ${clientIP}:`, error);
        }
        console.log(`===== End processing data from ${clientIP} =====`);
    });

    connection.on('close', () => {
        console.log(`Connection closed for ${clientIP}`);
        delete clients[clientIP]; // Remove from active clients
    });

    connection.on('error', (err) => {
        console.log(`Error from ${clientIP}:`, err.message);
        delete clients[clientIP]; // Remove faulty connection
    });
});

// Error handling for the server itself
tcpServer.on("error", (err) => {
    console.error("Server error:", err);
});

// Start the server
tcpServer.listen({ host: serverConfig.hostApi, port: 9000 }, function () {
    console.log(`TCP SERVER LISTENING ON ${serverConfig.hostApi}:9000`);
});
