const momentObj = require("moment");
const { create, all } = require("mathjs");
const config = {};
const serverConfig = require("../../../../IncrencyV4DRLTSHConfig.json");
const maths = create(all, config);
const globalData = require("../../global/globalData");
const clsActivityLog = require("../clsActivityLog.model");
const objActivityLog = new clsActivityLog();
const GLOBAL_NOMENCLATURE = require("../../global/GLOBAL_NOMENCLATURE");
const MqttModel = require("../Mqtt/mqttSender.class");
// const menuRequestModel = require('../Menu/MenuRequest.model');
const models = require("../../../config/dbConnection").models;
// const clsMesModel = require('../../MES/mes.model');
// const objMesModel = new clsMesModel();
const { Op } = require("sequelize");
const date = require('date-and-time');
const tbl_tab_master2 = require("../../../../IncrencyV4_DRL_Model/models/Report/Tablet/tbl_tab_master2");
const { type } = require("tedious/lib/data-types/null");
const mqttSender = new MqttModel();
// const objMenuRequestModel = new menuRequestModel();

class CommonWeighment {

  createMasterIncompleteObj(objProductDetails, objSelMenu, cubicObj, userObj, obj) {
    try {
      let { check_master_SRno, ProtocolUnit, dsNo, tabIp, ProtocolDecPoint, std_Limit2, side, typeValue, dp, masterTable, equipmentData } = obj;
      let createObj = {
        Unit: objProductDetails.Unit,
        MstSerNo: check_master_SRno,
        BFGCode: cubicObj.Sys_BFGCode,
        SFOID: cubicObj.Sys_SFOID,
        MPN_Code: cubicObj.Sys_MPNCode,
        Repetition: cubicObj.Sys_Repetition,
        ProductName: cubicObj.Sys_ProductName,
        ProductType: cubicObj.ProductType,
        CubicalNo: cubicObj.Sys_CubicNo,
        BatchNo: cubicObj.Sys_Batch,
        CubicleType: cubicObj.Sys_CubType,
        IPQCType: cubicObj.Sys_IPQCType,
        ReportType: cubicObj.Sys_RptType,
        MFGCode: cubicObj.Sys_MfgCode,
        BatchSize: cubicObj.Sys_BatchSize,
        SprayPeriod: cubicObj?.SprayPeriod || "NA",
        // FriabilityID: (cubicObj.Sys_FriabID == 'None') ? 'NA' : cubicObj.Sys_FriabID,
        // HardnessID: (cubicObj.Sys_HardID == 'None') ? 'NA' : cubicObj.Sys_HardID,
        CubicleName: cubicObj.Sys_CubicName,
        MesTestType: cubicObj.MesTestType,
        MesSide: cubicObj.MesSide ? cubicObj.MesSide : 'NA',
        BalanceId: (objSelMenu.instrumentId == 'None') ? 'NA' : objSelMenu.instrumentId,
        VernierId: (objSelMenu.instrumentId == 'None') ? 'NA' : objSelMenu.instrumentId,
        MachineCode: objSelMenu.EquipmentCode,

        Qty: Number(objProductDetails.noOfSamples),
        GrpQty: cubicObj.Sys_RptType == 1 ? Number(objSelMenu.individualsamplecount) : Number(objProductDetails.groupQty),
        StartSampleCount: globalData.arrSelectedMenu[0].StartSampleCount ?? 0,
        CISampleCount: objSelMenu.CISampleCount,
        EGSampleCount: objSelMenu.EGSampleCount,
        PrDate: momentObj().format("YYYY-MM-DD"),
        PrTime: momentObj().format("HH:mm:ss"),
        // PrEndDate: momentObj().format("YYYY-MM-DD"),
        // PrEndTime: momentObj().format("HH:mm:ss"),

        UserId: userObj.UserId,
        UserName: userObj.UserName,

        DsNo: dsNo,
        Idsno: dsNo,
        TabIp: tabIp,
        StdLimit2: std_Limit2,
        Side: side ? side : 'NA',
        // Unit: (ProtocolUnit).toLowerCase(),

        Inprocess: 1,
        GraphType: 0,

        // GrpQty: 0,
        // GrpFreq: 0,
        // BalanceNo: 0,
        // VernierNo: 0,
        // NomEmpty: "0",
        // T1NegEmpty: "0",
        // T1PosEmpty: "0",
        // T2NegEmpty: "0",
        // T2PosEmpty: "0",
        // NomNet: "0",
        // T1NegNet: "0",
        // T1PosNet: "0",
        // T2NegNet: "0",
        // T2PosNet: "0",
        Layer: "NA",
        // Nom_stdtarget: "NULL",
        // PrintNo: 0,
        // IsArchived: 0,
        // BatchComplete: 0,
        // BRepSerNo: 0,
        // AvgWeight: 0,
        // MinWeight: 0,
        // MaxWeight: 0,
        // StdDev: 0,
        // MinPer: 0,
        // MaxPer: 0,
        // NoOfBelow1: 0,
        // NoOfAbove1: 0,
        // NoOfBelow2: 0,
        // NoOfAbove2: 0,
      };

      // Not Getting Data from Cubicle
      createObj.CubicleLocation = cubicObj.Sys_Location
      createObj.PVersion = cubicObj.Sys_PVersion
      createObj.Version = cubicObj.Sys_Version
      createObj.Lot = cubicObj.Sys_LotNo
      createObj.SprayPeriod = cubicObj.SprayPeriod ? cubicObj.SprayPeriod : 'NA';
      createObj.Area = cubicObj.Sys_Area
      // createObj.TOC = cubicObj.TOC ? cubicObj.TOC : 'NA';
      createObj.AvgWeight = cubicObj.MesAWPWT ? cubicObj.MesAWPWT : 'NA';
      createObj.Department = cubicObj.Sys_dept
      createObj.CoatingType = cubicObj.TOC ? cubicObj.TOC : 'NA';
      if (obj.balanceData) {
        createObj.Make = obj.balanceData.Bal_Make
        createObj.Model = obj.balanceData.Bal_Model
        createObj.SerialNo = obj.balanceData.Bal_SrNo
      }


      if (cubicObj.Sys_RptType == 0) {
        createObj.WgmtModeNo = Number(masterTable.split('master')[1])
      }
      let getLimitsObj = this.getLimitsObj(typeValue, cubicObj.Sys_RptType);
      if (cubicObj.Sys_RptType != undefined) {
        createObj.IntervalStartTm = momentObj().format('YYYY-MM-DD HH:mm:ss')
        createObj.NoOfStations = equipmentData?.Machine_Punches;
        // createObj.LHSContainerNo = "NA";
        // createObj.RHSContainerNo = "NA";
        createObj.LHSContainerNo = objSelMenu.LHSContainerNo
        createObj.RHSContainerNo = objSelMenu.RHSContainerNo
        createObj.WgmtModeNo = Number(masterTable.split('master')[1])
      }
      createObj[getLimitsObj.Unit] = ProtocolUnit
      if (cubicObj.Sys_Area != 'Coating') {

        createObj[getLimitsObj.Nom] = maths.round(objProductDetails.Nom, dp).toFixed(dp)
        // createObj[getLimitsObj.Nom] = (objProductDetails.Nom != 99999) ? maths.round(objProductDetails.Nom, dp).toFixed(dp): 0
        createObj[getLimitsObj.T2NegTol] = maths.round(objProductDetails.T2Neg, dp).toFixed(dp)
        createObj[getLimitsObj.T2PosTol] = maths.round(objProductDetails.T2Pos, dp).toFixed(dp);
      }

      createObj[getLimitsObj.DecimalPoint] = ProtocolDecPoint;
      createObj[getLimitsObj.PrDate] = momentObj().format("YYYY-MM-DD")
      createObj[getLimitsObj.PrTime] = momentObj().format("HH:mm:ss")
      createObj[getLimitsObj.NoOfAbove1] = 0
      createObj[getLimitsObj.NoOfBelow1] = 0
      createObj[getLimitsObj.NoOfAbove2] = 0
      createObj[getLimitsObj.NoOfBelow2] = 0


      return createObj

    } catch (err) {
      throw new Error(err);
    }
  }

  getTypeValue(menuName) {
    let typeValue
    switch (menuName) {
      case `${GLOBAL_NOMENCLATURE.IndividualMenu}`:
        typeValue = 1;
        break;
      case `${GLOBAL_NOMENCLATURE.IndLayerMenu}`:
        typeValue = 9;
        break;
      case `${GLOBAL_NOMENCLATURE.IndLayer1Menu}`:
        typeValue = 11;
        break;
      case `${GLOBAL_NOMENCLATURE.ThicknessMenu}`:
      case `${GLOBAL_NOMENCLATURE.Differential}`:
        typeValue = 3;
        break;
      case `${GLOBAL_NOMENCLATURE.LengthMenu}`:
      case GLOBAL_NOMENCLATURE.LockedLength:
        typeValue = 5;
        break;
      case GLOBAL_NOMENCLATURE.GroupMenu:
        typeValue = 2;
        break;
      case GLOBAL_NOMENCLATURE.EmptyGroupMenu:
        typeValue = 19;
        break;
      case GLOBAL_NOMENCLATURE.Friability:
      case GLOBAL_NOMENCLATURE.FriabilatorMenu:
        typeValue = 8;
        break;
      case GLOBAL_NOMENCLATURE.HardnessMenu:
        typeValue = `htd`;
        break;
      case GLOBAL_NOMENCLATURE.DTMenu:
      case `${GLOBAL_NOMENCLATURE.DTMenu} Test`:
        typeValue = 13;
        break;
    }
    return typeValue
  }

  getTableName(cubicObj, menuName, dsNo, tabIp) {
    try {
      let cubType = cubicObj.Sys_CubType;
      let rptType = cubicObj.Sys_RptType;
      let ipqcType = cubicObj.Sys_IPQCType;
      let prdType;
      // if (cubicObj.ProductType) {
      //   prdType = prdType
      // } else {
      let productMasterDetail = globalData.arrProductTypeArray.find(e => e.DsNo == dsNo && e.TabIp == tabIp);
      if (productMasterDetail) {
        prdType = productMasterDetail.productType.ProductType
      }
      // }
      let productType = (prdType == 2) ? 'cap' : 'tab';
      let typeValue = this.getTypeValue(menuName);

      let initialtbl = "initial";
      let tableNo = "";
      if (cubType == 'Coating') {
        initialtbl = "";
        tableNo = typeValue
      }

      let masterTable = `tbl_${productType}_${initialtbl}master${tableNo}`;
      let detailTable = `tbl_${productType}_${initialtbl}detail${typeValue}`
      let masterTableFailed = `tbl_${productType}_${initialtbl}master_failed`
      let detailTableFailed = `tbl_${productType}_${initialtbl}detail${typeValue}_failed`

      // let masterTable = `tbl_${productType}_initialmaster`;
      // let detailTable = `tbl_${productType}_initialdetail${typeValue}`

      let masterTableIncomplete = masterTable.concat("_incomplete");
      let detailTableIncomplete = detailTable.concat("_incomplete");
      let batchSummaryMasterTable = `tbl_batchsummary_master${(menuName == GLOBAL_NOMENCLATURE.Differential) ? 'diff' : typeValue}`;
      let batchSummaryDetailTable = `tbl_batchsummary_detail${(menuName == GLOBAL_NOMENCLATURE.Differential) ? 'diff' : typeValue}`;

      let obj = {
        masterTable: masterTable,
        detailTable: detailTable,
        masterTableIncomplete: masterTableIncomplete,
        detailTableIncomplete: detailTableIncomplete,
        batchSummaryMasterTable: batchSummaryMasterTable,
        batchSummaryDetailTable: batchSummaryDetailTable,
        typeValue: typeValue,
        masterTableFailed:masterTableFailed,
        detailTableFailed:detailTableFailed
      }

      return obj

    } catch (err) {
      throw new Error(err);
    }
  }

  getLimitsObj(typeValue, rptType) {
    try {
      let obj = {};

      let str = (rptType != undefined) ? `Param${typeValue}_` : '';
      let instrumentId;
    switch (typeValue) {
      case 1:
      case 2:
        instrumentId = 'BalanceId'
        break;
    
      case 7:
      case 'htd':
        instrumentId = 'HardnessID'
        break;
    
      case 8:
        instrumentId = 'FriabilityID'
        break;
      case 13:
        instrumentId = 'DTID'
        break;    
      default:
        break;
    }

      // if (typeValue == 2 && rptType != undefined) {
      //   obj.AvgWeight = 'AvgGrpWeight'
      //   obj.MinWeight = 'MinGrpWeight';
      //   obj.MaxWeight = 'MaxGrpWeight';
      // } else {
      obj.AvgWeight = (rptType != undefined) ? `${str}AvgNet` : 'AvgWeight';
      obj.MinWeight = `${str}MinWeight`;
      obj.MaxWeight = `${str}MaxWeight`;
      // }

      obj.Nom = `${str}Nom`;
      obj.T2NegTol = `${str}T2NegTol`;
      obj.T2PosTol = `${str}T2PosTol`;
      obj.Diff = `${str}Diff`;
      obj.StdDev = `${str}StdDev`;
      obj.RStdDev = `${str}RStdDev`;
      obj.Remark = `${str}Remark`;
      obj.FailRemark = `${str}FailRemark`;
      obj.Unit = `${str}Unit`;
      obj.PrDate = `${str}PrDate`;
      obj.PrEndDate = `${str}PrEndDate`;
      obj.PrTime = `${str}PrTime`;
      obj.PrEndTime = `${str}PrEndTime`;
      obj.DecimalPoint = `${str}DecimalPoint`
      obj.NoOfAbove1 = `${str}NoOfAbove1`
      obj.NoOfBelow1 = `${str}NoOfBelow1`
      obj.NoOfAbove2 = `${str}NoOfAbove2`
      obj.NoOfBelow2 = `${str}NoOfBelow2`;
      obj.TotalWeight = `${str}TotalWeight`

      obj.instrumentId = instrumentId

      return obj;

    } catch (err) {
      throw new Error(err);
    }
  }


  manageLimitobjForCoating(obj) {

    for (const key in obj) {
      console.log(obj[key])
      // let value=limitsObj[key].split("_")[1]
      obj[key] = key;
    }
    return obj;
  }



  getDbMenuSeqFromMenu(menu) {
    try {
      let dbMenuName;
      switch (menu) {
        case `${GLOBAL_NOMENCLATURE.IndividualMenu}`:
          dbMenuName = "IND"
          break;
        case `${GLOBAL_NOMENCLATURE.ThicknessMenu}`:
          dbMenuName = "THICK"
          break;
        case `${GLOBAL_NOMENCLATURE.LengthMenu}`:
          dbMenuName = "LEN"
          break;
        case GLOBAL_NOMENCLATURE.GroupMenu:
          dbMenuName = "GRP"
          break;
        case GLOBAL_NOMENCLATURE.EmptyGroupMenu:
          dbMenuName = "EGRP"
          break;
        case GLOBAL_NOMENCLATURE.HardnessMenu:
          dbMenuName = "HARD"
          break;
        case GLOBAL_NOMENCLATURE.Friability:
        case GLOBAL_NOMENCLATURE.FriabilatorMenu:
          dbMenuName = "FRIAB"
          break;
        case GLOBAL_NOMENCLATURE.LockedLength:
          dbMenuName = "LEN"
          break;
        case GLOBAL_NOMENCLATURE.Differential:
          dbMenuName = "NET"
          break;
        case GLOBAL_NOMENCLATURE.DTMenu:
        case "Disintegration Test":
          dbMenuName = "DT"
          break;
        default:
          console.log("No dbmenu found according to menu")
          break;
      }

      return dbMenuName;

    } catch (err) {
      throw new Error(err);
    }
  }

  getMenuNmFromMenuSeq(menuSeq) {
    try {
      let globalMenuName;
      switch (menuSeq) {
        case "IND":
          globalMenuName = GLOBAL_NOMENCLATURE.IndividualMenu;
          break;
        case "GRP":
          globalMenuName = GLOBAL_NOMENCLATURE.GroupMenu;
          break;
        case "THICK":
          globalMenuName = GLOBAL_NOMENCLATURE.ThicknessMenu;
          break;
        case "HARD":
          globalMenuName = GLOBAL_NOMENCLATURE.HardnessMenu;
          break;
        case "LEN":
          globalMenuName = GLOBAL_NOMENCLATURE.LockedLength;
          break;
        case "FRIAB":
          globalMenuName = GLOBAL_NOMENCLATURE.Friability;
          break;
        case "DT":
          globalMenuName = GLOBAL_NOMENCLATURE.DTMenu;
          break;
        case "NET":
          globalMenuName = GLOBAL_NOMENCLATURE.Differential;
          break;
        case "EGRP":
          globalMenuName = GLOBAL_NOMENCLATURE.EmptyGroupMenu;
          break;
        default:
          console.log("No menuName find in menu sequence")
          break;
      }

      return globalMenuName

    } catch (err) {
      throw new Error(err);
    }
  }

  handleMesArr(obj) {
    try {
      let { menuName, dsNo, tabIp, ProtocolPortNo, counter, sampleNo, invalidWeightFlag, invalidUnitFlag, actualWt, rptType, batchId, sfoId, unit, isManual, avg } = obj;
      let mesData = globalData.MESArray.filter(e => e.menuName == menuName && e.DsNo == dsNo && e.TabIp == tabIp && e.portNo == ProtocolPortNo)
      let finalactualWt = actualWt
      if (unit) { finalactualWt = `${actualWt} ${unit}` }
      if (mesData.length == 0) {
        let selectedDSNo = dsNo;
        let arrIPQC = globalData.arr_IPQCRelIds.find(k => k.DsNo == dsNo && k.tabIp == tabIp);
        if (arrIPQC != undefined) {
          selectedDSNo = arrIPQC.selectedDs.dsNo
        }
        let data = {
          menuName: menuName,
          payload: [],
          DsNo: dsNo,
          selectedDSNo: selectedDSNo,
          TabIp: tabIp,
          portNo: ProtocolPortNo,
          isCompleted: false,
          isPosted: false,
          RptType: rptType,
          batchId: batchId,
          sfoId: sfoId,
          Area: obj.Area
        }
        globalData.MESArray.push(data)
        mesData = globalData.MESArray.filter(e => e.menuName == menuName && e.DsNo == dsNo && e.TabIp == tabIp && e.portNo == ProtocolPortNo)
      }

      if (counter < sampleNo && !invalidWeightFlag && !invalidUnitFlag) {
        mesData[0].payload.push({ data: { value: finalactualWt, isMesChecked: false } })
      }

      if (counter == sampleNo && !invalidWeightFlag && !invalidUnitFlag) {
        if (isManual != 1 && obj.Area != 'Coating') {
          mqttSender.sendData(dsNo, `Port ${ProtocolPortNo}:${GLOBAL_NOMENCLATURE.DisplayMessage} ${GLOBAL_NOMENCLATURE.PostingToMES}`)
        }
        if (obj.RepSerNo) mesData[0].RepSerNo = obj.RepSerNo
        mesData[0].payload.push({ data: { value: finalactualWt, isMesChecked: false } })
        mesData[0].mqttProtocol = obj.sideChangeMsg
        mesData[0].isCompleted = true;
        mesData[0].avg = avg;
        mesData[0].cal_data = obj.cal_data == undefined ? "NA" : obj.cal_data
      }

      console.log(globalData.MESArray)
      // return globalData.MESArray

    } catch (err) {
      throw new Error(err)
    }
  }

  async saveMESBatchinCubical(req, mesEntryRes) {
    try {
      let resObj = {};
      let isReqFromXml = (req.Sys_Batch != undefined && req.Sys_RptType != undefined) ? false : true;
      var arrUsers = globalData.arrUsers.find((k) => k.DsNo == req.Sys_DSNumber);
      let objActivity = {
        strUserId: arrUsers?.UserId,
        strUserName: arrUsers?.UserName,
        batch: req.Sys_Batch
      };

      let validatePortSetting = await this.validatePortSetting(mesEntryRes, objActivity, req.Sys_Batch);
      if (validatePortSetting.instrumentFound) {
        let cubicalData = validatePortSetting.data;
        if (isReqFromXml) {
          await models.tbl_mes_data.update({
            CubicleArea: cubicalData.Sys_Area,
            CubicleType: cubicalData.Sys_CubType,
            DS_Number: cubicalData.Sys_DSNumber,
          }, {
            where: {
              BatchID: mesEntryRes.BatchID,
              TestType: mesEntryRes.TestType,
              Repetition: mesEntryRes.Repetition,
              MesTestType: mesEntryRes.MesTestType,
              MesSide: mesEntryRes.MesSide
            }
          })
        }
      }
      if (validatePortSetting.status == "fail") { return validatePortSetting; }

      if (validatePortSetting.data) {
        let cubicalData = validatePortSetting.data;
        // let checkWeighMentStatus = await this.checkWeighMentStatus(cubicalData, objActivity, req);
        // if(checkWeighMentStatus.status == 'fail') { return checkWeighMentStatus }

        let updateCubicalFlag = false;
        if (mesEntryRes.LTID == 'NA' && mesEntryRes.MAID == 'NA') {
          if (req.Sys_Batch == mesEntryRes.BatchID && req.Sys_RptType == mesEntryRes.TestType) {
            updateCubicalFlag = true;
          }
        } else {
          if (req.Sys_Batch == mesEntryRes.BatchID && req.Sys_RptType == mesEntryRes.TestType) {
            updateCubicalFlag = true;
          }
          // if(mesEntryRes?.MAID != 'NA' && req.Sys_Batch == mesEntryRes.BatchID && req.Sys_RptType == mesEntryRes.TestType) {
          //   updateCubicalFlag = true;
          // }
          // if(mesEntryRes?.LTID != 'NA' && req.Sys_Batch == mesEntryRes.BatchID && req.Sys_RptType == mesEntryRes.TestType && req.Sys_Batch_Status == mesEntryRes.MesTestType) {
          //   updateCubicalFlag = true;
          // }
        }

        if (updateCubicalFlag) {
          if (mesEntryRes?.LTID != 'NA') {
            // Update cubical DS number
            await this.updateCubical1(mesEntryRes, cubicalData);

          } else {
            let checkProductData = await this.checkProductData(mesEntryRes, objActivity);
            if (checkProductData.status == "fail") { return checkProductData }
            await this.updateCubical1(mesEntryRes, cubicalData);
            await this.updateSampleNo(cubicalData.Sys_CubicNo, mesEntryRes)

          }
          // Update CubicleArea CubicleType
          await models.tbl_mes_data.update({
            CubicleArea: cubicalData.Sys_Area,
            CubicleType: cubicalData.Sys_CubType,
            DS_Number: cubicalData.Sys_DSNumber,
            isSetInCubical: 1
          }, {
            where: {
              BatchID: mesEntryRes.BatchID,
              TestType: mesEntryRes.TestType,
              Repetition: mesEntryRes.Repetition,
              MesTestType: mesEntryRes.MesTestType,
              MesSide: mesEntryRes.MesSide
            }
          })

          if (!mesEntryRes?.LTID || !mesEntryRes?.MAID) {
            let handleIPQC = this.handleIPQC(cubicalData)
          }

          // const checkPendingRequest = globalData.PendingRequest.find(k => k.DsNo == cubicalData.Sys_DSNumber);
          // if (checkPendingRequest) {
          //   const menuObj = {
          //     dsNo: cubicalData.Sys_DSNumber,
          //     tabIp: checkPendingRequest.TabIp,
          //     userId: checkPendingRequest.userId
          //   }
          //   objMenuRequestModel.sendMenu(menuObj)
          // }

          resObj.status = 'success';
          resObj.message = 'Batch Saved Successfully'
          return resObj
        }
      }

    } catch (err) {
      console.log('err: ', err);
    }
  }

  async validatePortSetting(obj, objActivity, batchId) {
    try {
      let resultObj = {};
      let cubicalRes;
      let instrumentFound = true;
      let Instrument = ''
      // let whereObj = {}
      // if (obj?.AWBID && obj?.AWBID != 'NA') whereObj.Sys_BalID = obj?.AWBID;
      // if (obj?.HTID && obj?.HTID != 'NA') whereObj.Sys_HardID = obj?.HTID;
      // if (obj?.MAID && obj?.MAID != 'NA') whereObj.Sys_MoistID = obj?.MAID;
      // if (obj?.FTID && obj?.FTID != 'NA') whereObj.Sys_FriabID = obj?.FTID;
      // if (obj?.DTID && obj?.DTID != 'NA') whereObj.Sys_DTID = obj?.DTID;
      // if (obj?.VerId && obj?.VerId != 'NA') whereObj.Sys_VernierID = obj?.VerId;
      // if (obj?.LTID && obj?.LTID != 'NA') whereObj.Sys_LeakID = obj?.LTID;
      // if (obj?.MAID && obj?.MAID != 'NA') whereObj.Sys_MoistID = obj?.MAID;
      // if (batchId) whereObj.Sys_Batch = batchId;

      if (obj?.LTID != 'NA' && obj?.LTID != undefined) {
        cubicalRes = await models.tbl_cubical.findAll({
          where: {

            [Op.or]: [
              { Sys_LeakID: (obj?.LTID) ? obj.LTID : "" },
              { Sys_Batch: (obj?.BatchID) ? obj.BatchID : "" },
            ],
          }
        })
      } else if (obj?.MAID != 'NA' && obj?.MAID != undefined) {
        cubicalRes = await models.tbl_cubical.findAll({
          where: {

            [Op.or]: [
              { Sys_MoistID: (obj?.MAID) ? obj.MAID : "" },
              { Sys_Batch: (obj?.BatchID) ? obj.BatchID : "" },
            ],
          }
        })
      } else {
        cubicalRes = await models.tbl_cubical.findAll({
          where: {
            [Op.or]: [
              { Sys_BalID: (obj?.AWBID) ? obj.AWBID : "" },
              // { Sys_BalID2: (obj?.GrpWtEqmID) ? obj.GrpWtEqmID : (obj?.IndWtEqmID) ? obj.IndWtEqmID : "" },
              { Sys_HardID: (obj?.HTID) ? obj.HTID : "" },
              { Sys_MoistID: (obj?.MAID) ? obj.MAID : "" },
              { Sys_VernierID: (obj?.VerId) ? obj.VerId : "" },
              { Sys_FriabID: (obj?.FTID) ? obj.FTID : "" },
              { Sys_DTID: (obj?.DTID) ? obj.DTID : "" },
              { Sys_Batch: (obj?.BatchID) ? obj.BatchID : "" },
            ],
            // Sys_Batch: obj.BatchID,
            // Sys_CubType: { [Op.ne]: "IPQC" }
          }
        })
      }

      if (cubicalRes.length == 0) instrumentFound = false
      let cubicData = cubicalRes.filter(e => e.Sys_Batch == obj.BatchID);
      cubicalRes = (cubicData.length > 0) ? cubicalRes = cubicData[0] : cubicalRes[0];
      if (cubicalRes) {
        // Check for Balance
        if ((obj.AWBID != "NA" && obj.AWBID != 'None') && (obj.AWBID != cubicalRes.Sys_BalID)) {
          cubicalRes.Sys_BalID = 'NA'
          console.log("Balance is not set in cubicle");
          instrumentFound = false;
          Instrument = `Balance: ${obj.AWBID}`
        }

        // Check for DT
        if ((obj.DTID != "NA" && obj.DTID != 'None') && (obj.DTID != cubicalRes.Sys_DTID)) {
          cubicalRes.Sys_DTID = 'NA';
          console.log("DT is not set in cubicle");
          instrumentFound = false;
          Instrument = `Disintigration Tester: ${obj.DTID}`
        }
        // Check for Friability
        if ((obj.FTID != "None" && obj.FTID != "NA") && (obj.FTID != cubicalRes.Sys_FriabID)) {
          console.log("Friability is not set in cubicle");
          instrumentFound = false;
          Instrument = `Friabilator: ${obj.FTID}`
        }
        // Check for Hardness
        if ((obj.HTID != "NA" && obj.HTID != 'None') && (obj.HTID != cubicalRes.Sys_HardID)) {
          cubicalRes.Sys_HardID = 'NA';
          console.log("Hardness is not set in cubicle");
          instrumentFound = false;
          Instrument = `Hardness: ${obj.HTID}`
        }
        // Check for Leak Tester
        if ((obj.LTID != "NA" && obj.LTID != 'None') && (obj.LTID != cubicalRes.Sys_LeakID)) {
          cubicalRes.Sys_LeakID = 'NA';
          console.log("Leak Tester is not set in cubicle");
          instrumentFound = false;
          Instrument = `Leak Tester: ${obj.LTID}`
        }
        // Check for Mositure Analyzer
        if ((obj.MAID != "NA" && obj.MAID != 'None') && (obj.MAID != cubicalRes.Sys_MoistID)) {
          cubicalRes.Sys_MoistID = 'NA';
          console.log("Mositure Analyzer is not set in cubicle");
          instrumentFound = false;
          Instrument = `Mositure Analyzer: ${obj.MAID}`
        }
        // Check for Vernier
        if ((obj.VerId != "NA" && obj.VerId != 'None') && (obj.VerId != cubicalRes.Sys_VernierID)) {
          cubicalRes.Sys_VernierID = 'NA';
          console.log("Vernier is not set in cubicle");
          instrumentFound = false;
          Instrument = `Vernier: ${obj.VerId}`
        }


      }
      // let cubicalRes = await models.tbl_cubical.findOne({ where: whereObj })

      // cubicalRes = cubicalRes[0]
      if (!cubicalRes || !instrumentFound) {
        console.log(`${Instrument}  received from MES is not set in Area Setting`);
        resultObj.status = "fail";
        if (!cubicalRes && !instrumentFound) {
          resultObj.message = `Instrument received from MES is not set in Area Setting`
        } else {
          resultObj.message = `${Instrument}  received from MES is not set in Area Setting`
        }
        if (cubicalRes) { resultObj.data = cubicalRes }
        resultObj.instrumentFound = (cubicalRes) ? true : false
        // resultObj.data = xml;
        objActivity.activity = resultObj.message;
        await objActivityLog.ActivityLogEntry(objActivity);
      } else {
        resultObj.instrumentFound = (cubicalRes) ? true : false
        resultObj.status = "success"
        resultObj.message = "",
          resultObj.data = cubicalRes
      }

      return resultObj

    } catch (err) {
      console.log('err: ', err);
      return err
    }
  }

  async updateCubical1(mesEntryRes, cubicalData, fromMenu = {}) {
    try {

      let dbObj = null;
      if (Object.keys(fromMenu).length != 0) {
        dbObj = {
          ...fromMenu
        }
      } else {
        let productTable = mesEntryRes.ProductType == 2 ? 'tbl_product_capsule' : 'tbl_product_tablet'
        let productData = await models[productTable].findOne({
          where: {
            MPN_Code: mesEntryRes.MPN,
            // SFOID: mesEntryRes.SFOID
          }
        })

        if (mesEntryRes?.LTID != 'NA') {
          dbObj = {
            // Sys_Batch: mesEntryRes.BatchID,
            // Sys_RptType: 0,
            Sys_SFOID: mesEntryRes.SFOID,
            Sys_MPNCode: mesEntryRes.MPN,
            Sys_Batch_Status: mesEntryRes.MesTestType,
            isManual: false,
            MesTestType: mesEntryRes.MesTestType,
            MesSide: mesEntryRes.MesSide,
            Sys_BFGCode: productData.ProductId,
            Sys_ProductName: productData?.ProductName ?? 'NA'
          }
        } else if (mesEntryRes?.MAID != 'NA') {
          dbObj = {
            // Sys_Batch: mesEntryRes.BatchID,
            Sys_Repetition: mesEntryRes.Repetition,
            Sys_SFOID: mesEntryRes.SFOID,
            Sys_MPNCode: mesEntryRes.MPN,
            isManual: false,
            MesTestType: mesEntryRes.MesTestType,
            MesSide: mesEntryRes.MesSide,
            Sys_BFGCode: productData?.ProductId ?? 'NA',
            Sys_ProductName: productData?.ProductName ?? 'NA',
            Sys_LotNo: mesEntryRes?.LotNo || "NA"
          }
        } else {
          dbObj = {
            // Sys_Batch: mesEntryRes.BatchID,
            // Sys_BFGCode: mesEntryRes.ProductId,
            // Sys_ProductName: mesEntryRes.ProductName,
            // Sys_RptType: mesEntryRes.TestType,
            Sys_SFOID: mesEntryRes.SFOID,
            Sys_Repetition: mesEntryRes.Repetition,
            Sys_RotaryType: mesEntryRes.Side,
            Sys_MPNCode: mesEntryRes.MPN,
            isManual: false,
            MesTestType: mesEntryRes.MesTestType,
            MesSide: mesEntryRes.MesSide,
            Sys_LotNo: mesEntryRes?.LotNo || "NA",
            SprayPeriod: mesEntryRes?.SprayPeriod || "NA",
            MesAWPWT: mesEntryRes?.AWPWT || "NA",
            TOC: mesEntryRes?.TOC || "NA",
            Sys_BFGCode: productData?.ProductId || 'NA',
            Sys_ProductName: productData?.ProductName || "NA",

          }
        }

      }

      await models.tbl_cubical.update(dbObj, { where: { Sys_DSNumber: cubicalData.Sys_DSNumber } });

      return;
    } catch (error) {
      console.log('error: ', error);
    }
  }

  async checkProductData(obj, objActivity) {
    try {
      let result = {};
      const productMasterRes = await models.tbl_product_master.findOne({
        where: {
          MPN_Code: obj.MPN,
        }
      })

      if (!productMasterRes) {
        result.status = "fail";
        result.message = 'Product is not set';
        objActivity.activity = result.message
        await objActivityLog.ActivityLogEntry(objActivity);
        return result
      }

      const productType = productMasterRes.ProductType;
      let productTypeTableName = "tbl_product_tablet";
      let productTypeTableNameTemp = "tbl_product_tablet_temp";

      if (productType == 2) {
        productTypeTableName = "tbl_product_capsule"
        productTypeTableNameTemp = "tbl_product_capsule_temp"
      }

      const productLimitRes = await models[productTypeTableName].findOne({
        where: {
          MPN_Code: obj.MPN,
        }
      });
      await models[productTypeTableName].update({ ProductName: productMasterRes.ProductName, ProductId: productMasterRes.ProductId }, { where: { MPN_Code: obj.MPN } })
      if (!productLimitRes) {
        result.status = "fail";
        result.message = 'Product limit not found';
        console.log(`Product limit not found in ${productTypeTableName}`);
        return result
      }

      let checkProductLimits = await this.checkProductLimits(productTypeTableName, productTypeTableNameTemp, obj, productMasterRes, productLimitRes)
      return checkProductLimits

    } catch (err) {
      console.log(err);
      return err
    }
  }

  async checkProductAccordingArea(MPN, Area) {

    try {
      let whereCondition = {
        MPN_Code: MPN,
        IsActive: 1,
        IsReject: 0
      }

      switch (Area) {
        case 'Compression': {
          whereCondition.IsCompress = 1;
          break;
        }
        case 'Capsule Filling': {
          whereCondition.IsCapsuleFilling = 1;
          break;
        }
        case 'Coating': {
          whereCondition.IsCoated = 1;
          break;
        }
        case 'Granulation':
        case 'IPQA Granulation': {
          whereCondition.IsGranulation = 1;
          break;
        }
        case 'IPQA Packing':
        case 'Nasal Filling': {
          whereCondition.IsCompress = 0;
          whereCondition.IsGranulation = 0;
          whereCondition.IsCoated = 0;
          whereCondition.IsCapsuleFilling = 0;
        }

      }

      var finddataMpn = await models.tbl_product_master.findAll({
        where: whereCondition
      })

      return finddataMpn

    } catch (error) {
      throw new Error(error);
    }

  }

  async checkProductLimits(productTypeTableName, productTypeTableNameTemp, obj, productMasterRes, productLimitRes) {
    try {
      let productTabletTempRes = await models[productTypeTableNameTemp].findOne({
        where: {
          MPN_Code: obj.MPN,
        }
      })


      if (!productTabletTempRes) {
        let upperLimit;
        let target;
        let lowerLimit;

        if (obj.LODHigh.includes('NMT')) {
          upperLimit = obj.LODHigh.match(/(\d+(\.\d+)?)/g)[0]

          if (obj.LODHigh.includes('Target of')) {
            target = obj.LODHigh.match(/(\d+(\.\d+)?)/g)[1]

          }
        } else if (obj.LODHigh.split(' ')[0].includes('(')) {
          lowerLimit = obj.LODHigh.match(/(\d+(\.\d+)?)/g)[0]

          upperLimit = obj.LODHigh.match(/(\d+(\.\d+)?)/g)[1]

          if (obj.LODHigh.includes('Target of')) {
            target = obj.LODHigh.match(/(\d+(\.\d+)?)/g)[2]

          }
        }


        if (productMasterRes.ProductType == 1) {
          // tablet
          let prdData = await models[productTypeTableNameTemp].create({
            MPN_Code: obj.MPN,
            // Individual
            Param1_T2Neg: (Number(obj.IndWtLow) && !isNaN(obj.IndWtLow)) ? Number(obj.IndWtLow) : 99999.00000,
            Param1_T2Pos: (Number(obj.IndWtHigh) && !isNaN(obj.IndWtLow)) ? Number(obj.IndWtHigh) : 99999.00000,
            Param1_Unit: obj.IndUnit,
            Param1_Nom: productLimitRes.Param1_Nom,
            // Group
            Param2_T2Neg: (Number(obj.GrpWtLow) && !isNaN(obj.GrpWtLow)) ? Number(obj.GrpWtLow) : 99999.00000,
            Param2_T2Pos: (Number(obj.GrpWtHigh) && !isNaN(obj.GrpWtHigh)) ? Number(obj.GrpWtHigh) : 99999.00000,
            Param2_Unit: obj.GrpUnit,
            Param2_Nom: productLimitRes.Param2_Nom,
            // Thickness
            Param3_T2Neg: (Number(obj.ThicknessLow) && !isNaN(obj.ThicknessLow)) ? Number(obj.ThicknessLow) : 99999.00000,
            Param3_T2Pos: (Number(obj.ThicknessHigh) && !isNaN(obj.ThicknessHigh)) ? Number(obj.ThicknessHigh) : 99999.00000,
            Param3_Unit: obj.ThicknessUnit,
            Param3_Nom: productLimitRes.Param3_Nom,
            // Diameter
            Param6_T2Pos: (Number(obj.DiameterLow) && !isNaN(obj.DiameterLow)) ? Number(obj.DiameterLow) : 99999.00000,
            Param6_T2Neg: (Number(obj.DiameterHigh) && !isNaN(obj.DiameterHigh)) ? Number(obj.DiameterHigh) : 99999.00000,
            Param6_Unit: obj.DiameterUnit,
            Param6_Nom: productLimitRes.Param6_Nom,
            // Length
            Param5_T2Neg: (Number(obj.LengthLow) && !isNaN(obj.LengthLow)) ? Number(obj.LengthLow) : 99999.00000,
            Param5_T2Pos: (Number(obj.LengthHigh) && !isNaN(obj.LengthHigh)) ? Number(obj.LengthHigh) : 99999.00000,
            Param5_Unit: obj.LengthUnit,
            Param5_Nom: productLimitRes.Param5_Nom,
            // Hardness
            Param7_T2Neg: (Number(obj.HardnessLow) && !isNaN(obj.HardnessLow)) ? Number(obj.HardnessLow) : 99999.00000,
            Param7_T2Pos: (Number(obj.HardnessHigh) && !isNaN(obj.HardnessHigh)) ? Number(obj.HardnessHigh) : 99999.00000,
            Param7_Unit: obj.HardUnit,
            Param7_Nom: productLimitRes.Param7_Nom,
            // Friability
            // Param8_T1Neg: (Number(obj.FriabilityLow) && !isNaN(obj.FriabilityLow)) ? Number(obj.FriabilityLow) : 99999,
            // Param8_T1Pos: (Number(obj.FriabilityHigh) && !isNaN(obj.FriabilityHigh)) ? Number(obj.FriabilityHigh) : 99999,
            Param8_Nom: (obj?.FriabilityRange) ? obj.FriabilityRange : "NA", // NMT 0.10 %
            // Param8_T1Pos: (obj?.FriabilitySetRPM) ? obj?.FriabilitySetRPM : "NA", // RPM 00:04:00
            Param8_LimitOn: (obj?.FriabilityRange) ? 1 : "NA", // for percentage
            Param8_Unit: obj.FriabUnit,
            // DT
            // Param13_T1Neg: (Number(obj.DisintegrationLow) && isNaN(obj.DisintegrationLow)) ? Number(obj.DisintegrationLow) : 99999,
            // Param13_T1Pos: (Number(obj.DisintegrationHigh) && isNaN(obj.DisintegrationHigh)) ? Number(obj.DisintegrationHigh) : 99999,
            Param13_Nom: (obj.DisintegrationRange) ? obj.DisintegrationRange : "NA",
            // LOD
            Param16_Nom: target ? target : 99999.00000,
            Param16_T1Neg: lowerLimit ? lowerLimit : 99999.00000,
            Param16_T1Pos: upperLimit ? upperLimit : 99999.00000,
            Param16_Unit: "",
            //ProductName &&  ProductId
            ProductName: productLimitRes.ProductName,
            ProductId: productLimitRes.ProductId
          })

          productTabletTempRes = prdData._previousDataValues

        } else {
          // capsule
         let prdCapData =  await models[productTypeTableNameTemp].create({
            MPN_Code: obj.MPN,
            // Individual
            Param1_T2Neg: (Number(obj.IndWtLow) && !isNaN(obj.IndWtLow)) ? Number(obj.IndWtLow) : 99999.00000,
            Param1_T2Pos: (Number(obj.IndWtHigh) && !isNaN(obj.IndWtLow)) ? Number(obj.IndWtHigh) : 99999.00000,
            Param1_Unit: obj.IndUnit,
            Param1_Nom: productLimitRes.Param1_Nom,
            // Group
            Param2_T2Neg: (Number(obj.GrpWtLow) && !isNaN(obj.GrpWtLow)) ? Number(obj.GrpWtLow) : 99999.00000,
            Param2_T2Pos: (Number(obj.GrpWtHigh) && !isNaN(obj.GrpWtHigh)) ? Number(obj.GrpWtHigh) : 99999.00000,
            Param2_Unit: obj.GrpUnit,
            Param2_Nom: productLimitRes.Param2_Nom,
            // Differential
            Param3_T2Neg: (Number(obj.GrpWtLow) && !isNaN(obj.GrpWtLow)) ? Number(obj.GrpWtLow) : 99999.00000,
            Param3_T2Pos: (Number(obj.GrpWtHigh) && !isNaN(obj.GrpWtHigh)) ? Number(obj.GrpWtHigh) : 99999.00000,
            Param3_Unit: obj.GrpUnit,
            Param3_Nom: productLimitRes.Param3_Nom,
            // Locked Length
            Param5_T2Neg: (Number(obj.LockedLengthLow) && !isNaN(obj.LockedLengthLow)) ? Number(obj.LockedLengthLow) : 99999.00000,
            Param5_T2Pos: (Number(obj.LockedLengthHigh) && !isNaN(obj.LockedLengthHigh)) ? Number(obj.LockedLengthHigh) : 99999.00000,
            Param5_Unit: obj.LengthUnit,
            Param5_Nom: productLimitRes.Param5_Nom,
            // DT
            // Param6_T1Neg: (Number(obj.DisintegrationLow) && isNaN(obj.DisintegrationLow)) ? Number(obj.DisintegrationLow) : 99999,
            // Param6_T1Pos: (Number(obj.DisintegrationHigh) && isNaN(obj.DisintegrationHigh)) ? Number(obj.DisintegrationHigh) : 99999,
            Param6_Nom: (obj.DisintegrationRange) ? obj.DisintegrationRange : "NA",
          })

          productTabletTempRes = prdData._previousDataValues
        }
      } 

      // else {
        // Check product limit and create audit of it and if product limit change upadte it to temp table
        const productLimitStatus = await this.createAuditAndCheckLimit(productLimitRes, obj, productMasterRes.ProductType)
        if (productLimitStatus) {
          await models.tbl_product_master.update({ isLimitChanged: 1 }, { where: { MPN_Code: obj.MPN } })
        } else {
          await models.tbl_product_master.update({ isLimitChanged: 0 }, { where: { MPN_Code: obj.MPN } })
        }
      // }

      return {
        status: 'success',
        message: 'Product Limit Status'
      }

    } catch (err) {
      console.log(err);
      return err
    }
  }

  handleIPQC(cubicalData) {
    try {
      const IPQCList = globalData.IPQCList.find((k) => k.area == cubicalData.Sys_Area);
      if (IPQCList) {
        const batchFound = IPQCList.bathces.findIndex((k) => k.batch == cubicalData.Sys_Batch)
        if (!batchFound || batchFound < 0) {
          IPQCList.bathces.push({
            batch: cubicalData.Sys_Batch,
            dsNo: cubicalData.Sys_DSNumber
          })
        }

        let resObj = {
          status: 'success',
          Area: IPQCList.area,
          batch: IPQCList.bathces,
          tabIp: IPQCList.tabIp,
          isUpdated: true
        }

        console.log("Menu has been send through MQTT. ", JSON.stringify(resObj));
        mqttSender.sendData(IPQCList.dsNo, `onAreaSelectionGetBatch:${JSON.stringify(resObj)}`)
      }
    } catch (err) {
      console.log('err: ', err);
    }
  }

  async createMESDataHistory(obj) {
    try {
      const currentDateTime = date.format(new Date(), 'YYYY-MM-DD HH:mm:ss');

      const mesHistoryRes = await models.tbl_mes_data_history.create({
        prDate: currentDateTime,
        BatchID: obj.BatchID,
        SFOID: obj.SFOID,
        Repetition: obj.Repetition,
        TestType: obj.TestType,
        MPN: obj.MPN,
        // ProductId: obj.ProductId,
        // ProductName: obj.ProductName,
        // ProductType: obj.ProductType,
        Side: obj.Side,
        Container: obj.Container,
        SampleCount: (obj?.SampleCount) ? obj.SampleCount : 0,
        GroupSampleCount: (obj?.GroupSampleCount) ? obj.GroupSampleCount : 0,
        StartSampleCount: (obj?.StartSampleCount) ? obj.StartSampleCount : 0,

        // Balance ID
        AWBID: (obj?.AWBID) ? obj.AWBID : "NA",
        // Vernier ID
        VerId: (obj?.VerId) ? obj.VerId : "NA",
        // LOD (Moisture Analyzer) (No parameter for LOD Test)
        MAID: (obj?.MAID) ? obj.MAID : "NA",

        // Individual
        IndWtLow: ((obj?.IndWtLow || obj?.IndWtLow == 0) && obj?.IndWtLow != 'NA') ? obj.IndWtLow : 99999,
        IndWtHigh: ((obj?.IndWtHigh || obj?.IndWtHigh == 0) && obj?.IndWtHigh != 'NA') ? obj.IndWtHigh : 99999,
        IndUnit: (obj?.IndUnit) ? obj.IndUnit : "",

        // Group
        GrpWtLow: ((obj?.GrpWtLow || obj?.GrpWtLow == 0) && obj?.GrpWtLow != 'NA') ? obj.GrpWtLow : 99999,
        GrpWtHigh: ((obj?.GrpWtHigh || obj.GrpWtHigh == 0) && obj?.GrpWtHigh != 'NA') ? obj.GrpWtHigh : 99999,
        GrpUnit: (obj?.GrpUnit) ? obj.GrpUnit : "",

        // Empty Group
        EmptGrpWtLow: ((obj?.EmptGrpWtLow || obj?.EmptGrpWtLow == 0) && obj?.EmptGrpWtLow != 'NA') ? obj.EmptGrpWtLow : 99999,
        EmptGrpWtHigh: ((obj?.EmptGrpWtHigh || obj.EmptGrpWtHigh == 0) && obj?.EmptGrpWtHigh != 'NA') ? obj.EmptGrpWtHigh : 99999,
        EmptGrpUnit: (obj?.EmptGrpUnit) ? obj.EmptGrpUnit : "",

        // Differential
        DiffWtLow: ((obj?.DiffWtLow || obj?.DiffWtLow == 0) && obj?.DiffWtLow != 'NA') ? obj.DiffWtLow : 99999,
        DiffWtHigh: ((obj?.DiffWtHigh || obj?.DiffWtHigh == 0) && obj?.DiffWtHigh != 'NA') ? obj.DiffWtHigh : 99999,
        DiffUnit: (obj?.DiffUnit) ? obj.DiffUnit : "",

        // Hardness
        HTID: (obj?.HTID) ? obj.HTID : "NA",
        HardnessLow: ((obj?.HardnessLow || obj?.HardnessLow == 0) && obj?.HardnessLow != 'NA') ? obj.HardnessLow : 99999,
        HardnessHigh: ((obj?.HardnessHigh || obj?.HardnessHigh == 0) && obj?.HardnessHigh != 'NA') ? obj.HardnessHigh : 99999,
        HardUnit: (obj?.HardUnit) ? obj.HardUnit : "",

        // Thickness 
        ThicknessLow: ((obj?.ThicknessLow || obj?.ThicknessLow == 0) && obj?.ThicknessLow != 'NA') ? obj.ThicknessLow : 99999,
        ThicknessHigh: ((obj?.ThicknessHigh || obj?.ThicknessHigh == 0) && obj?.ThicknessHigh != 'NA') ? obj.ThicknessHigh : 99999,
        ThicknessUnit: (obj?.ThicknessUnit) ? obj.ThicknessUnit : "",

        // Diameter 
        DiameterLow: ((obj?.DiameterLow || obj?.DiameterLow == 0) && obj?.DiameterLow != 'NA') ? obj.DiameterLow : 99999,
        DiameterHigh: ((obj?.DiameterHigh || obj?.DiameterHigh == 0) && obj?.DiameterHigh != 'NA') ? obj.DiameterHigh : 99999,
        DiameterUnit: (obj?.DiameterUnit) ? obj.DiameterUnit : "",

        // Length 
        LengthLow: ((obj?.LengthLow || obj?.LengthLow == 0) && obj?.LengthLow != 'NA') ? obj.LengthLow : 99999,
        LengthHigh: ((obj?.LengthHigh || obj?.LengthHigh == 0) && obj?.LengthHigh != 'NA') ? obj.LengthHigh : 99999,
        LengthUnit: (obj?.LengthUnit) ? obj.LengthUnit : "",

        // Locked Length 
        LengthLow: ((obj?.LockedLengthLow || obj?.LockedLengthLow == 0) && obj?.LockedLengthLow != 'NA') ? obj.LockedLengthLow : 99999,
        LengthHigh: ((obj?.LockedLengthHigh || obj?.LockedLengthHigh == 0) && obj?.LockedLengthHigh != 'NA') ? obj.LockedLengthHigh : 99999,
        LengthUnit: (obj?.LockedLengthUnit) ? obj.LockedLengthUnit : "",

        // Disintegration Test
        DTID: (obj?.DTID) ? obj.DTID : "NA",
        // DisintegrationLow: (obj?.DisintegrationLow) ? obj.DisintegrationLow : 99999,
        // DisintegrationHigh: (obj.DisintegrationHigh) ? obj.DisintegrationHigh : 99999,
        DisintegrationRange: (obj.DisintegrationRange) ? obj.DisintegrationRange : "NA",

        // Friability Test
        FTID: (obj?.FTID) ? obj.FTID : "NA",
        // FriabilityLow: (obj?.FriabilityLow) ? obj.FriabilityLow : 99999,
        // FriabilityHigh: (obj?.FriabilityHigh) ? obj.FriabilityHigh : 99999,
        FriabilityRange: (obj?.FriabilityRange) ? obj.FriabilityRange : 99999,
        FriabilityRPM: (obj?.FriabilitySetRPM && obj?.FriabilitySetRPM != 'NA') ? obj.FriabilitySetRPM : 99999,
        FriabUnit: (obj?.FriabUnit) ? obj.FriabUnit : "",

        LTID: (obj?.LTID) ? obj.LTID : "NA",

        MesTestType: (obj?.MesTestType) ? obj.MesTestType : '',
        MesSide: (obj?.MesSide) ? obj?.MesSide : '',

        Remark: "MES data received",
        LotNo: (obj?.LotNo) ? obj.LotNo : "NA",
        SprayPeriod: (obj?.SprayPeriod) ? obj.SprayPeriod : "NA",
        AWPWT: (obj?.AWPWT) ? obj.AWPWT : "NA",
        TOC: (obj?.TOC) ? obj.TOC : "NA",
        // GrpWtEqmID: (obj?.GrpWtEqmID) ? obj.GrpWtEqmID : "",
      })

      return mesHistoryRes
    } catch (error) {
      console.log('error: ', error);
    }
  }

  async createAuditAndCheckLimit(productLimitRes, mesEntryRes, productType) {
    let isLimitChanged = false
    const tblProductTabletTempObj = {}

    // Individual
    if (Number(mesEntryRes.IndWtLow) != 99999.00000 && (Number(mesEntryRes.IndWtHigh) != 99999.00000)) {
      // Individual Low
      if ((Number(productLimitRes.Param1_T2Neg) != Number(mesEntryRes.IndWtLow))) {
        if (Number(productLimitRes.Param1_T2Neg) != 99999.00000) {
          isLimitChanged = true
          tblProductTabletTempObj.Param1_T2Neg = Number(mesEntryRes.IndWtLow);
        }
      }

      // Individual High
      if ((Number(productLimitRes.Param1_T2Pos) != Number(mesEntryRes.IndWtHigh))) {
        if (Number(productLimitRes.Param1_T2Pos) != 99999.00000) {
          isLimitChanged = true
          tblProductTabletTempObj.Param1_T2Pos = Number(mesEntryRes.IndWtHigh);
        }
      }
    }

    // Group
    if (Number(mesEntryRes.GrpWtLow) != 99999.00000 && (Number(mesEntryRes.GrpWtHigh) != 99999.00000)) {
      // Group Low
      if ((Number(productLimitRes.Param2_T2Neg) != Number(mesEntryRes.GrpWtLow))) {
        if (Number(productLimitRes.Param2_T2Neg) != 99999.00000) {
          isLimitChanged = true
          tblProductTabletTempObj.Param2_T2Neg = Number(mesEntryRes.GrpWtLow);
        }
      }

      // Group High
      if ((Number(productLimitRes.Param2_T2Pos) != Number(mesEntryRes.GrpWtHigh))) {
        if (Number(productLimitRes.Param2_T2Pos) != 99999.00000) {
          isLimitChanged = true
          tblProductTabletTempObj.Param2_T2Pos = Number(mesEntryRes.GrpWtHigh);
        }
      }
    }

    //Empty Group
    if (Number(mesEntryRes.EmptGrpWtLow) != 99999.00000 && (Number(mesEntryRes.EmptGrpWtHigh) != 99999.00000)) {
      // Group Low
      if ((Number(productLimitRes.Param19_T2Neg) != Number(mesEntryRes.EmptGrpWtLow))) {
        if (Number(productLimitRes.Param19_T2Neg) != 99999.00000) {
          isLimitChanged = true
          tblProductTabletTempObj.Param19_T2Neg = Number(mesEntryRes.GrpWtLow);
        }
      }

      // Group High
      if ((Number(productLimitRes.Param19_T2Pos) != Number(mesEntryRes.EmptGrpWtHigh))) {
        if (Number(productLimitRes.Param19_T2Pos) != 99999.00000) {
          isLimitChanged = true
          tblProductTabletTempObj.Param19_T2Pos = Number(mesEntryRes.EmptGrpWtHigh);
        }
      }
    }

    // Differential
    if (Number(mesEntryRes.DiffWtLow) != 99999.00000 && (Number(mesEntryRes.DiffWtHigh) != 99999.00000) && productType == 2) {
      // Differential Low
      if ((Number(productLimitRes.Param3_T2Neg) != Number(mesEntryRes.DiffWtLow))) {
        if (Number(productLimitRes.Param3_T2Neg) != 99999.00000) {
          isLimitChanged = true
          tblProductTabletTempObj.Param3_T2Neg = Number(mesEntryRes.DiffWtLow);
        }
      }

      // Differential High
      if ((Number(productLimitRes.Param3_T2Pos) != Number(mesEntryRes.DiffWtHigh))) {
        if (Number(productLimitRes.Param3_T2Pos) != 99999.00000) {
          isLimitChanged = true
          tblProductTabletTempObj.Param3_T2Pos = Number(mesEntryRes.DiffWtHigh);
        }
      }
    }

    // Hardness
    if ((Number(mesEntryRes.HardnessLow) != 99999.00000) && (Number(mesEntryRes.HardnessLow) != 99999.00000) && productType == 1) {
      // Hardness Low
      if ((Number(productLimitRes.Param7_T2Neg) != Number(mesEntryRes.HardnessLow))) {
        if (Number(productLimitRes.Param7_T2Neg) != 99999.00000) {
          isLimitChanged = true
          tblProductTabletTempObj.Param7_T2Neg = Number(mesEntryRes.HardnessLow);
        }
      }

      // Hardness High
      if ((Number(productLimitRes.Param7_T2Pos) != Number(mesEntryRes.HardnessHigh))) {
        if (Number(productLimitRes.Param7_T2Pos) != 99999.00000) {
          isLimitChanged = true
          tblProductTabletTempObj.Param7_T2Pos = Number(mesEntryRes.HardnessHigh);
        }
      }
    }

    // Thickness
    if ((Number(mesEntryRes.ThicknessLow) != 99999.00000) && (Number(mesEntryRes.ThicknessHigh) != 99999.00000) && productType == 1) {
      // Thickness Low
      if ((Number(productLimitRes.Param3_T2Neg) != Number(mesEntryRes.ThicknessLow))) {
        if (Number(productLimitRes.Param3_T2Neg) != 99999.00000) {
          isLimitChanged = true
          tblProductTabletTempObj.Param3_T2Neg = Number(mesEntryRes.ThicknessLow);
        }
      }

      // Thickness High
      if ((Number(productLimitRes.Param3_T2Pos) != Number(mesEntryRes.ThicknessHigh))) {
        if (Number(productLimitRes.Param3_T2Pos) != 99999.00000) {
          isLimitChanged = true
          tblProductTabletTempObj.Param3_T2Pos = Number(mesEntryRes.ThicknessHigh);
        }
      }
    }

    // Friability
    if (mesEntryRes.FriabilityRange != 99999.00000) {
      // 1.04%
      if (productLimitRes.Param8_Nom != mesEntryRes.FriabilityRange) {
        isLimitChanged = true
        tblProductTabletTempObj.Param8_Nom = Number(mesEntryRes.FriabilityRange);
      }
    }


    // Friability
    // if ((Number(mesEntryRes.FriabilityLow) != 99999) && (Number(mesEntryRes.FriabilityHigh) != 99999) && productType == 1) {
    //   // Friability Low
    //   if ((Number(productLimitRes.Param8_T1Neg) != Number(mesEntryRes.FriabilityLow))) {
    //     if (Number(productLimitRes.Param8_T1Neg) != 99999) {
    //       isLimitChanged = true
    //       tblProductTabletTempObj.Param8_T1Neg = Number(mesEntryRes.FriabilityLow);
    //     }
    //   }

    //   // Friability High
    //   if ((Number(productLimitRes.Param8_T1Pos) != Number(mesEntryRes.FriabilityHigh))) {
    //     if (Number(productLimitRes.Param8_T1Pos) != 99999) {
    //       isLimitChanged = true
    //       tblProductTabletTempObj.Param8_T1Pos = Number(mesEntryRes.FriabilityHigh);
    //     }
    //   }
    // }

    // Disintegration
    // if (mesEntryRes.DisintegrationRange != 99999) {
    //   let range = "Param13_Nom"; // For tablet
    //   if (productType == 2) {
    //     range = "Param6_Nom"; // For capsule
    //   }

    //   if (mesEntryRes.DisintegrationRange != productLimitRes[range]) {
    //     if (productLimitRes[range] != "NA" && productLimitRes[range] != "NULL") {
    //       isLimitChanged = true
    //       tblProductTabletTempObj[range] = mesEntryRes.DisintegrationRange;
    //     }
    //   }
    // }

    /*
    if (Number(mesEntryRes.DisintegrationLow) != 99999 && (Number(mesEntryRes.DisintegrationHigh) != 99999) && productType == 1) {
      // Disintegration Low
      let posT1 = "Param13_T1Pos"; // For tablet
      let negT1 = "Param13_T1Neg"; // For tablet
      if (productType == 2) {
        posT1 = "Param6_T1Pos"; // For capsule
        negT1 = "Param6_T1Neg"; // For capsule
      }
      if ((Number(productLimitRes[negT1]) != Number(mesEntryRes.DisintegrationLow))) {
        if (Number(productLimitRes[negT1]) != 99999) {
          isLimitChanged = true
          tblProductTabletTempObj[negT1] = Number(mesEntryRes.DisintegrationLow);
        }
      }

      // Disintegration High
      if ((Number(productLimitRes[posT1]) != Number(mesEntryRes.DisintegrationHigh))) {
        if (Number(productLimitRes[posT1]) != 99999) {
          isLimitChanged = true
          tblProductTabletTempObj[posT1] = Number(mesEntryRes.DisintegrationHigh);
        }
      }
    }
    */

    // Length
    if (Number(mesEntryRes.LengthLow) != 99999.00000 && (Number(mesEntryRes.LengthHigh) != 99999.00000)) {
      // Length Low
      if ((Number(productLimitRes.Param5_T2Neg) != Number(mesEntryRes.LengthLow))) {
        if (Number(productLimitRes.Param5_T2Neg) != 99999.00000) {
          isLimitChanged = true
          tblProductTabletTempObj.Param5_T2Neg = Number(mesEntryRes.LengthLow);
        }
      }

      // Length High
      if ((Number(productLimitRes.Param5_T2Pos) != Number(mesEntryRes.LengthHigh))) {
        if (Number(productLimitRes.Param5_T2Pos) != 99999.00000) {
          isLimitChanged = true
          tblProductTabletTempObj.Param5_T2Pos = Number(mesEntryRes.LengthHigh);
        }
      }
    }

    // Locked Length
    if (Number(mesEntryRes.LockedLengthLow) != 99999.00000 && (Number(mesEntryRes.LockedLengthHigh) != 99999.00000)) {
      // Length Low
      if ((Number(productLimitRes.Param5_T2Neg) != Number(mesEntryRes.LockedLengthLow))) {
        if (Number(productLimitRes.Param5_T2Neg) != 99999.00000) {
          isLimitChanged = true
          tblProductTabletTempObj.Param5_T2Neg = Number(mesEntryRes.LockedLengthLow);
        }
      }

      // Length High
      if ((Number(productLimitRes.Param5_T2Pos) != Number(mesEntryRes.LockedLengthHigh))) {
        if (Number(productLimitRes.Param5_T2Pos) != 99999.00000) {
          isLimitChanged = true
          tblProductTabletTempObj.Param5_T2Pos = Number(mesEntryRes.LockedLengthHigh);
        }
      }
    }

    // Diameter
    if ((Number(mesEntryRes.DiameterLow) != 99999.00000) && (Number(mesEntryRes.DiameterHigh) != 99999.00000) && productType == 1) {
      // Diameter Low
      if ((Number(productLimitRes.Param4_T2Neg) != Number(mesEntryRes.DiameterLow))) {
        if (Number(productLimitRes.Param4_T2Neg) != 99999.00000) {
          isLimitChanged = true
          tblProductTabletTempObj.Param4_T2Neg = Number(mesEntryRes.DiameterLow);
        }
      }

      // Diameter High
      if ((Number(productLimitRes.Param4_T2Pos) != Number(mesEntryRes.DiameterHigh))) {
        if (Number(productLimitRes.Param4_T2Pos) != 99999.00000) {
          isLimitChanged = true
          tblProductTabletTempObj.Param4_T2Pos = Number(mesEntryRes.DiameterHigh);
        }
      }
    }

    var lowerLimit = 'NA'
    var upperLimit = 'NA'
    var target = 'NA'

    if (mesEntryRes.LODHigh.includes('NMT')) {
      upperLimit = mesEntryRes.LODHigh.match(/(\d+(\.\d+)?)/g)[0]
      if (upperLimit != productLimitRes.Param16_T1Pos) {
        isLimitChanged = true
        tblProductTabletTempObj.Param16_T1Pos = Number(upperLimit);
      }
      if (productLimitRes.Param16_T1Neg != 99999) {
        isLimitChanged = true;
        tblProductTabletTempObj.Param16_T1Neg = 99999.00000;
      }
      if (mesEntryRes.LODHigh.includes('Target of')) {
        target = mesEntryRes.LODHigh.match(/(\d+(\.\d+)?)/g)[1]
        if (target != productLimitRes.Param16_Nom) {
          isLimitChanged = true
          tblProductTabletTempObj.Param16_Nom = Number(target);
        }
      } else {
        if (productLimitRes.Param16_Nom !== 99999 || productLimitRes.Param16_T1Neg !== 99999) {
          isLimitChanged = true
        }
        tblProductTabletTempObj.Param16_Nom = 99999.00000;
        tblProductTabletTempObj.Param16_T1Neg = 99999.00000;

      }
    } else if (mesEntryRes.LODHigh.split(' ')[0].includes('(')) {
      lowerLimit = mesEntryRes.LODHigh.match(/(\d+(\.\d+)?)/g)[0]
      if (lowerLimit != productLimitRes.Param16_T1Neg) {
        isLimitChanged = true
        tblProductTabletTempObj.Param16_T1Neg = Number(lowerLimit);
      }
      upperLimit = mesEntryRes.LODHigh.match(/(\d+(\.\d+)?)/g)[1]
      if (upperLimit != productLimitRes.Param16_T1Pos) {
        isLimitChanged = true
        tblProductTabletTempObj.Param16_T1Pos = Number(upperLimit);
      }
      if (mesEntryRes.LODHigh.includes('Target of')) {
        target = mesEntryRes.LODHigh.match(/(\d+(\.\d+)?)/g)[2]
        if (target != productLimitRes.Param16_Nom) {
          isLimitChanged = true
          tblProductTabletTempObj.Param16_Nom = Number(target);
        }
      } else {

        if (productLimitRes.Param16_Nom != 99999) {
          isLimitChanged = true
        }
        tblProductTabletTempObj.Param16_Nom = 99999.00000;
      }
    }
    // LOD
    // if (Number(mesEntryRes.InitialWeight) != 99999.00000 && (Number(mesEntryRes.FinalWeight) != 99999)) {
    //   // LOD Low
    //   if ((Number(productLimitRes.Param16_T1Neg) != Number(mesEntryRes.InitialWeight))) {
    //     if (Number(productLimitRes.Param16_T1Neg) != 99999) {
    //       isLimitChanged = true
    //       oldValueComp += `Group - Lower Limit: ${productLimitRes.Param16_T1Neg},`
    //     } else {
    //       if (oldValueComp == 'NA' || oldValueComp == '') {
    //         oldValueComp = 'NA';
    //       }
    //     }
    //     newValueComp += `Group - Lower Limit: ${mesEntryRes.InitialWeight},`
    //   }

    //   // LOD High
    //   if ((Number(productLimitRes.Param16_T1Pos) != Number(mesEntryRes.FinalWeight))) {
    //     if (Number(productLimitRes.Param16_T1Pos) != 99999) {
    //       isLimitChanged = true
    //       oldValueComp += `Upper Limit: ${productLimitRes.Param16_T1Pos},`
    //     } else {
    //       if (oldValueComp == 'NA' || oldValueComp == '') {
    //         oldValueComp = 'NA';
    //       }
    //     }
    //     newValueComp += `Upper Limit: ${mesEntryRes.FinalWeight},`
    //   }
    // }

    let tempTable = "tbl_product_tablet_temp"
    if (productType == 2) {
      tempTable = "tbl_product_capsule_temp"
    }
    tblProductTabletTempObj.ProductName = productLimitRes.ProductName,
      tblProductTabletTempObj.ProductId = productLimitRes.ProductId
    if (isLimitChanged) {
      console.log("Product limits has been changed. Limits received from MES");
      tblProductTabletTempObj.Remark = ""
      await models[tempTable].update(tblProductTabletTempObj, {
        where: {
          // ProductId: productLimitRes.ProductId,
          // ProductName: productLimitRes.ProductName
          MPN_Code: productLimitRes.MPN_Code
        }
      })
    }

    return isLimitChanged;
  }

  async updateSampleNo(cubicNo, mesEntryRes) {
    try {
      let individualSampleCount = (mesEntryRes.GroupSampleCount) ? mesEntryRes.GroupSampleCount : 0;
      let sampleCount = (mesEntryRes.SampleCount) ? mesEntryRes.SampleCount : 0;

      // if (mesEntryRes.TestType == 0) {
      //   commonSampleCount = mesEntryRes.SampleCount;
      // } else {
      //   commonSampleCount = mesEntryRes.StartSampleCount;
      //   grpSampleCount = mesEntryRes.GroupSampleCount;
      // }

      // await models.tbl_cubicle_product_sample.update({
      //   Individual: commonSampleCount,
      //   Group: (mesEntryRes.TestType == 0) ? commonSampleCount : grpSampleCount,
      //   Hardness: commonSampleCount,
      //   Thickness: commonSampleCount,
      //   Diameter: commonSampleCount,
      //   Length: commonSampleCount,
      //   Friability: commonSampleCount,
      //   DT: commonSampleCount,
      // }, {
      //   where: {
      //     Sys_CubicNo: cubicNo,
      //   }
      // });


      // if (mesEntryRes.TestType == 0) {
      //   commonSampleCount = mesEntryRes.SampleCount;
      // } else {
      //   commonSampleCount = mesEntryRes.StartSampleCount;
      //   grpSampleCount = mesEntryRes.GroupSampleCount;
      // }
      await models.tbl_cubicle_product_sample.update({

        Individual: individualSampleCount,
        Group: sampleCount,
        Hardness: serverConfig.plant != "FT03" ? mesEntryRes.StartSampleCount : sampleCount,
        Thickness: serverConfig.plant != "FT03" ? mesEntryRes.StartSampleCount : sampleCount,
        Diameter: sampleCount,
        Length: sampleCount,
        Friability: 'NLT 6.5 g',
        DT: 6,
        Differential: individualSampleCount
      }, {
        where: {
          Sys_CubicNo: cubicNo,
        }
      });
    } catch (error) {
      console.log('error: ', error);

    }
  }


}

module.exports = CommonWeighment;
