const Database = require("../../database/clsQueryProcess");
// const printReport = require('./clsPrintReport');
// const IOnlinePrint = require('../../../Interfaces/IOnlinePrint.model');
const GLOBAL_NOMENCLATURE = require('../../global/Global_Nomenclature');
const globalData = require("../../global/globalData");
const database = new Database();
const clsBatchSummary = require("../Product/clsBatchSummaryOperation");
// const objPrintReport = new printReport();
// const serverConfig = require('../../global/severConfig')
let clsGetMstSrAndSideSr = require("../Product/clsGetMstSrAndSideSr");
const clsCommonWeightment = require("./clsCommonWeightment");
const objCommonWeightment = new clsCommonWeightment();
// const objGetMstSrAndSideSr = new clsGetMstSrAndSideSr()
const date = require("date-and-time");
const momentObj = require("moment");


const check_srNO_ = require("../Product/cls_consolidate_reportOperation");
const check_srNO = new check_srNO_();

const models = require("../../../config/dbConnection").models;
const sequelize = require("../../../config/dbConnection").sequelize;
const { QueryTypes } = require("sequelize");
// const ErrorLog = require('../clsErrorLog');
const objBatchSummary = new clsBatchSummary();
const objGetMstSrAndSideSr = new clsGetMstSrAndSideSr();
// const {modBusModel} = require('../Modbus/modBus.model')


// const OPCops = require('../OPC/opcOps');
// const objOPCops = new OPCops();

class WeighmentDataTransfer {
  /**
   *
   * @param {*} resultdata
   * @param {*} weighmentModeNo
   * @param {*} Idsno
   */

  async saveCommonDataToComplete1(dataObj, resultdata, weighmentModeNo = 0) {
    try {
      let dsNo = dataObj.DsNo;
      let cubicObj = dataObj.cubicObj
      let masterTable = dataObj.masterTable;
      let detailTable = dataObj.detailTable;
      let masterTableIncomplete = dataObj.masterTableIncomplete;
      let detailTableIncomplete = dataObj.detailTableIncomplete;
      let menuName = dataObj.menuName;
      // let selectedDsNo, selectedTabIp;
      // var IPQCObject = globalData.arr_IPQCRelIds.find((k) => k.DsNo == strDsNo && k.TabIp == tabIp);
      // if (IPQCObject != undefined) {
      //   selectedDsNo = IPQCObject.selectedIds;
      //   selectedTabIp = IPQCObject.selectedTabIp;
      // } else {
      //   selectedDsNo = strDsNo;
      //   selectedTabIp = tabIp;
      // }

      // var arrProductType = globalData.arrProductTypeArray.find((k) => k.DsNo == selectedDsNo);
      // var cubicObj = arrProductType.productType;
      // var objMenu = globalData.arrMultihealerMS.find(k => k.idsNo == Idsno);
      let responseObj = {};
      const checkData = await models[masterTable].findAll({
        attributes: [[sequelize.fn("max", sequelize.col("RepSerNo")), "RepSerNo"]],
        attributes: [[sequelize.fn("max", sequelize.col("MstSerNo")), "MstSerNo"]],
        where: {
          MPN_Code: resultdata.incompleteData.MPN_Code,
          // BFGCode: resultdata.incompleteData.BFGCode,
          // ProductName: resultdata.incompleteData.ProductName,
          // PVersion: resultdata.incompleteData.PVersion,
          // Version: resultdata.incompleteData.Version,
          BatchNo: resultdata.incompleteData.BatchNo,
          DsNo: resultdata.incompleteData.DsNo,
        },
      });
      if (cubicObj.ProductType == 3) {
        checkData.condition.push({ str_colName: "TestType", value: dataObj.menuName, comp: "eq" });
      }

      var resultCompleteData = checkData[0];
      var intMstSerNo;
      var MstSerNo = resultdata.incompleteData.MstSerNo
      if (resultCompleteData.RepSerNo == null) {
        intMstSerNo = 1;
      } else {
        var newMstSerNo = resultCompleteData.RepSerNo + 1;
        intMstSerNo = newMstSerNo;
      }

      var masterCompleteData = await models[masterTable].create({
        Unit: resultdata.incompleteData.Unit,
        MstSerNo: MstSerNo, // modified by vivek on 03/04/2020
        SideNo: 1, // added by vivek on 03/04/2020
        BalanceId: resultdata.incompleteData.BalanceId,
        BFGCode: resultdata.incompleteData.BFGCode,
        SFOID: resultdata.incompleteData.SFOID,
        MPN_Code: resultdata.incompleteData.MPN_Code,
        Repetition: resultdata.incompleteData.Repetition,
        ProductName: resultdata.incompleteData.ProductName,
        ProductType: resultdata.incompleteData.ProductType,
        Qty: resultdata.incompleteData.Qty,
        GrpQty: resultdata.incompleteData.GrpQty,
        GrpFreq: resultdata.incompleteData.GrpFreq,
        Idsno: resultdata.incompleteData.DsNo,
        DsNo: resultdata.incompleteData.DsNo,
        TabIp: resultdata.incompleteData.TabIp,
        CubicalNo: resultdata.incompleteData.CubicalNo,
        // InsturmentID: resultdata.incompleteData.InsturmentID,
        // BalanceNo: resultdata.incompleteData.BalanceNo,
        VernierId: resultdata.incompleteData.VernierId,
        // VernierNo: resultdata.incompleteData.VernierNo,
        BatchNo: resultdata.incompleteData.BatchNo,
        UserId: resultdata.incompleteData.UserId,
        UserName: resultdata.incompleteData.UserName,
        PrDate: resultdata.incompleteData.PrDate,
        PrTime: momentObj(resultdata.incompleteData.PrTime).format("HH:mm:ss"),
        PrEndDate: momentObj().format("YYYY-MM-DD"),
        PrEndTime: momentObj().format("HH:mm:ss"),
        Side: cubicObj.ProductType == 2 ? "NA" : resultdata.incompleteData.Side,
        Unit: resultdata.incompleteData.Unit,
        SprayPeriod: resultdata.incompleteData.SprayPeriod,
        // TOC: resultdata.incompleteData.TOC,
        AvgWeight: resultdata.incompleteData.AvgWeight,
        DP: resultdata.incompleteData.DP,
        WgmtModeNo: resultdata.incompleteData.WgmtModeNo,
        Nom: resultdata.incompleteData.Nom,
        // T1NegTol: resultdata.incompleteData.T1NegTol,
        // T1PosTol: resultdata.incompleteData.T1PosTol,
        T2NegTol: resultdata.incompleteData.T2NegTol,
        T2PosTol: resultdata.incompleteData.T2PosTol,
        limitOn: resultdata.incompleteData.LimitOn,
        StdLimit1: resultdata.incompleteData.StdLimit1,
        StdLimit2: resultdata.incompleteData.StdLimit2,
        NomEmpty: resultdata.incompleteData.NomEmpty,
        T1NegEmpty: resultdata.incompleteData.T1NegEmpty,
        T1PosEmpty: resultdata.incompleteData.T1PosEmpty,
        // T2NegEmpty: resultdata.incompleteData.T2NegEmpty,
        // T2PosEmpty: resultdata.incompleteData.T2PosEmpty,
        MinWeight: resultdata.incompleteData.MinWeight,
        MaxWeight: resultdata.incompleteData.MaxWeight,
        MinPer: resultdata.incompleteData.MinPer,
        MaxPer: resultdata.incompleteData.MaxPer,
        StdDev: resultdata.incompleteData.StdDev,
        NoOfAboveT1: resultdata.incompleteData.NoOfAboveT1,
        NoOfAboveT2: resultdata.incompleteData.NoOfAboveT2,
        NoOfBelowT1: resultdata.incompleteData.NoOfBelowT1,
        NoOfBelowT2: resultdata.incompleteData.NoOfBelowT2,
        NomNet: resultdata.incompleteData.NomNet,
        T1NegNet: resultdata.incompleteData.T1NegNet,
        T1PosNet: resultdata.incompleteData.T1PosNet,
        T2NegNet: resultdata.incompleteData.T2NegNet,
        T2PosNet: resultdata.incompleteData.T2PosNet,
        CubicleType: resultdata.incompleteData.CubicleType,
        ReportType: resultdata.incompleteData.ReportType,
        MachineCode: resultdata.incompleteData.MachineCode,
        // MFGCode: resultdata.incompleteData.MFGCode,
        BatchSize: resultdata.incompleteData.BatchSize,
        FriabilityID: resultdata.incompleteData.FriabilityID,
        HardnessID: resultdata.incompleteData.HardnessID,
        CubicleName: resultdata.incompleteData.CubicleName,
        CubicleLocation: resultdata.incompleteData.CubicleLocation,
        RepoLabel10: resultdata.incompleteData.RepoLabel10,
        RepoLabel11: resultdata.incompleteData.RepoLabel11,
        RepoLabel12: resultdata.incompleteData.RepoLabel12,
        RepoLabel13: resultdata.incompleteData.RepoLabel13,
        RepoLabel14: resultdata.incompleteData.RepoLabel14,
        PrintNo: resultdata.incompleteData.PrintNo,
        IsArchived: resultdata.incompleteData.IsArchived,
        GraphType: resultdata.incompleteData.GraphType,
        BatchComplete: resultdata.incompleteData.BatchComplete,
        PVersion: resultdata.incompleteData.PVersion,
        Version: resultdata.incompleteData.Version,
        CheckedByID: resultdata.incompleteData.CheckedByID,
        CheckedByName: resultdata.incompleteData.CheckedByName,
        CheckedByDate: resultdata.incompleteData.CheckedByDate,
        BRepSerNo: resultdata.incompleteData.BRepSerNo,
        // T1NMTTab :resultdata.incompleteDataTab,
        Lot: resultdata.incompleteData.Lot,
        Area: resultdata.incompleteData.Area,
        AppearanceDesc: resultdata.incompleteData.AppearanceDesc,
        MachineSpeed_Min: resultdata.incompleteData.MachineSpeed_Min,
        MachineSpeed_Max: resultdata.incompleteData.MachineSpeed_Max,
        GenericName: resultdata.incompleteData.GenericName,
        BMRNo: resultdata.incompleteData.BMRNo,
        Remark: dataObj.remark,
        MesFlag: 0,
        Layer: resultdata.incompleteData.Layer,
        Make: resultdata.incompleteData.Make,
        Model: resultdata.incompleteData.Model,
        SerialNo: resultdata.incompleteData.SerialNo,
        MesTestType: resultdata.incompleteData.MesTestType,
        CoatingType: resultdata.incompleteData.CoatingType
      });

      // var resultCompleteData = [masterCompleteData];
      var lastInsertedID = masterCompleteData.RepSerNo;
      // var incompleteTableName = resultdata.incompleteTableName

      var objfetchMasterRecord = await models[masterTable].findOne({ where: { RepSerNo: lastInsertedID } });
      var tempdatatcp = [];

      for (const [i, v] of resultdata.detailData.entries()) {
        const insertDetailObj = {
          RepSerNo: lastInsertedID,
          RecSeqNo: i + 1,
          DataValue: v.DataValue,
          DataValue1: v.DataValue1,
          DataValue2: v.DataValue2,
          BatchNo: v.BatchNo,
          DataValue1: v.DataValue1,
          DataValue2: v.DataValue2,
          BatchNo: v.BatchNo,
          DP: v.DP,
          MstSerNo: objfetchMasterRecord.MstSerNo,
          UserId: objfetchMasterRecord.UserId,
          UserName: objfetchMasterRecord.UserName,
          PrDate: momentObj().format("YYYY-MM-DD"),
          PrTime: momentObj().format("HH:mm:ss"),
          PrEndDate: momentObj().format("YYYY-MM-DD"),
          PrEndTime: momentObj().format("HH:mm:ss"),
          isException: v.isException,
          SprayPeriod: v.SprayPeriod,
          Lot: v.Lot
        };


        if (cubicObj.ProductType == 3) {
          insertDetailObj.data.push({ str_colName: "DataValue1", value: v.DataValue1 });
          insertDetailObj.data.push({ str_colName: "NetWeight", value: v.NetWeight });
          insertDetailObj.data.push({ str_colName: "Remark", value: v.Remark });
        } else if ((cubicObj.ProductType == 2 || cubicObj.ProductType == 4) && weighmentModeNo == "D") {
          // insertDetailObj.data.push({ DataValue1: v.DataValue1 })
          Object.assign(insertDetailObj, { DataValue1: v.DataValue1 });
          // insertDetailObj.data.push({NetWeight: v.NetWeight })
          Object.assign(insertDetailObj, { NetWeight: v.NetWeight });
        }
        let res = await models[detailTable].create(insertDetailObj);
        tempdatatcp.push(insertDetailObj.DataValue)
      }

      if (resultdata.garbageData.length > 0) {
        await this.moveToExceptionTable(lastInsertedID, menuName, objfetchMasterRecord, resultdata.garbageData, cubicObj.Sys_RptType, 0)
      }

      await models[masterTableIncomplete].destroy({ where: { RepSerNo: resultdata.incompleteData.RepSerNo } });
      await models[detailTableIncomplete].destroy({ where: { RepSerNo: resultdata.incompleteData.RepSerNo } });
      await models.tbl_mes_data.update({ isTestCompleted: 1 }, { where: { DS_Number: cubicObj.Sys_DSNumber, isSetInCubical: 1 } });
      Object.assign(responseObj, { status: "success", RepSerNo: lastInsertedID });

      return responseObj;
    } catch (err) {
      console.log("Error message : " + err);
      throw new Error(err);
    }
  }

  async moveToExceptionTable(lastInsertedID, menuName, objfetchMasterRecord, exceptionData, rptType, isTerminated) {
    try {
      let obj;

      let createExceptionData = [];
      let typeValue = objCommonWeightment.getTypeValue(menuName);
      let getLimitsObj = objCommonWeightment.getLimitsObj(typeValue, rptType);
      let T2Neg_Tol = objfetchMasterRecord[`Param${typeValue}_T2NegTol`]
      let T2Pos_Tol = objfetchMasterRecord[`Param${typeValue}_T2PosTol`]
      for (let data of exceptionData) {

        if (menuName == 'Hardness') {

          await models.tbl_exception_samplehtd_initial.update(
            {
              // Remark: data.Remark,
              isTerminated: 1
            }, {
            where: {
              RepSerNo: data.RepSerNo,
              SampleNo: data.RecSeqNo,
              BatchNo: data.BatchNo,
              Repetition: data.Repetition,
              SFOID: data.SFOID
            }
          }
          )

          //   obj = {
          //     DsNo: objfetchMasterRecord.DsNO,
          //     TabIp: objfetchMasterRecord.TabIp,
          //     Remark: data.Remark,
          //     DataValueHard: data.DataValueHard,
          //     DataValueThick: data.DataValueHard,
          //     DataValueDiam: data.DataValueHard,
          //     DataValueBL: data.DataValueHard,
          //     DataValueUnit: objfetchMasterRecord[getLimitsObj.Unit],
          //     RepSerNo: lastInsertedID,
          //     MenuName: menuName,
          //     ProductType: objfetchMasterRecord.ProductType,
          //     TypeValue: 1,
          //     BFGCode: data.BFGCode,
          //     ProductName: data.ProductName,
          //     BatchNo: data.BatchNo,
          //     Department: objfetchMasterRecord.Department,
          //     SFOID: objfetchMasterRecord.SFOID,
          //     MachineCode: objfetchMasterRecord.MachineCode,
          //     PrDate: data.PrDate,
          //     prTime: data.PrTime,
          //     Side: objfetchMasterRecord.Side,
          //     InstrumentId: data.InstrumentID,
          //     T1NegTolHard: objfetchMasterRecord.T1NegTolHard,
          //     T1PosTolHard: objfetchMasterRecord.T1PosTolHard,
          //     T1NegTolThick: objfetchMasterRecord.T1NegTolThick,
          //     T1PosTolThick: objfetchMasterRecord.T1PosTolThick,
          //     T1NegTolBL: objfetchMasterRecord.T1NegTolBL,
          //     T1PosTolBL: objfetchMasterRecord.T1PosTolBL,
          //     SampleNo: data.RecSeqNo,
          //     Area: objfetchMasterRecord.Area,
          //     UserID: data.UserId,
          //     UserName: data.UserName,
          //     Repetition: objfetchMasterRecord.Repetition,
          //     BLName: objfetchMasterRecord.BLName
          //   }
          // createExceptionData.push(obj)

        } else {
          let dtMenuNameArr = [`${GLOBAL_NOMENCLATURE.DTMenu} Test`, GLOBAL_NOMENCLATURE.DTMenu]
          obj = {
            DsNo: objfetchMasterRecord.DsNo,
            TabIp: objfetchMasterRecord.TabIp,
            Remark: data.Remark,
            DataValue: menuName == GLOBAL_NOMENCLATURE.Friability ? data.NetValue : data.DataValue,
            DataValueUnit: menuName == GLOBAL_NOMENCLATURE.Friability ? '%' : data.DataValueUnit,
            RepSerNo: lastInsertedID,
            MenuName: menuName,
            ProductType: objfetchMasterRecord.ProductType,
            TypeValue: 1,
            BFGCode: objfetchMasterRecord.BFGCode,
            ProductName: data.ProductName,
            BatchNo: data.BatchNo,
            Department: objfetchMasterRecord.Department,
            SFOID: objfetchMasterRecord.SFOID,
            MachineCode: objfetchMasterRecord.MachineCode,
            PrDate: data.PrDate,
            prTime: data.PrTime,
            Side: objfetchMasterRecord.Side,
            InstrumentId: data.InstrumentID,
            T1NegTol: T2Neg_Tol,
            T1PosTol: T2Pos_Tol,
            SampleNo: data.RecSeqNo,
            Area: objfetchMasterRecord.Area,
            UserID: data.UserId,
            UserName: data.UserName,
            Repetition: objfetchMasterRecord.Repetition,
            DTRange: (dtMenuNameArr.includes(menuName)) ? objfetchMasterRecord[getLimitsObj.Nom] : 'NA',
            FriabRange: menuName == GLOBAL_NOMENCLATURE.Friability ? objfetchMasterRecord[getLimitsObj.Nom] : 'NA',
            DTRange: (dtMenuNameArr.includes(menuName)) ? objfetchMasterRecord[getLimitsObj.Nom] : 'NA',
            FriabRange: menuName == GLOBAL_NOMENCLATURE.Friability ? objfetchMasterRecord[getLimitsObj.Nom] : 'NA',
            isTerminated: isTerminated,
            CubicalName: objfetchMasterRecord.CubicleName,
            CubicalName: objfetchMasterRecord.CubicleName,
            // InstrumentType:objfetchMasterRecord.InstrumentType,
            Nominal: objfetchMasterRecord[getLimitsObj.Nom]
          }
          createExceptionData.push(obj)
        }

      }
      let exceptionTable = 'tbl_exception_sample_initial'
      if (objfetchMasterRecord.CubicleType == "Coating") {
        exceptionTable = "tbl_exception_sample"
      }
      await models[exceptionTable].bulkCreate(createExceptionData);
      return "success";
    } catch (err) {
      throw new Error(err)
    }
  }

  async saveCommonDataToComplete(resultdata, weighmentModeNo = 0, dsNo, remark, menuName, tabIp) {
    try {
      let strDsNo = dsNo;
      let selectedDsNo, selectedTabIp;
      var IPQCObject = globalData.arr_IPQCRelIds.find((k) => k.DsNo == strDsNo && k.TabIp == tabIp);
      if (IPQCObject != undefined) {
        selectedDsNo = IPQCObject.selectedIds;
        selectedTabIp = IPQCObject.selectedTabIp;
      } else {
        selectedDsNo = strDsNo;
        selectedTabIp = tabIp;
      }

      var arrProductType = globalData.arrProductTypeArray.find((k) => k.DsNo == selectedDsNo);
      var productDetail = arrProductType.productType;
      // var objMenu = globalData.arrMultihealerMS.find(k => k.idsNo == Idsno);
      let responseObj = {};
      const checkData = await models[resultdata.completeTableName].findAll({
        attributes: [[sequelize.fn("max", sequelize.col("RepSerNo")), "RepSerNo"]],
        attributes: [[sequelize.fn("max", sequelize.col("MstSerNo")), "MstSerNo"]],
        where: {
          BFGCode: resultdata.incompleteData.BFGCode,
          ProductName: resultdata.incompleteData.ProductName,
          // PVersion: resultdata.incompleteData.PVersion,
          // Version: resultdata.incompleteData.Version,
          BatchNo: resultdata.incompleteData.BatchNo,
          DsNo: resultdata.incompleteData.DsNo,
        },
      });
      if (productDetail.ProductType == 3) {
        checkData.condition.push({
          str_colName: "TestType",
          value: objMenu.menu,
          comp: "eq",
        });
      }

      var resultCompleteData = checkData[0];
      var intMstSerNo;
      var MstSerNo = resultdata.incompleteData.MstSerNo
      if (resultCompleteData.SeqNo == null) {
        intMstSerNo = 1;
      } else {
        var newMstSerNo = resultCompleteData.SeqNo + 1;
        intMstSerNo = newMstSerNo;
      }

      var masterCompleteData = await models[resultdata.completeTableName].create({
        MstSerNo: MstSerNo, // modified by vivek on 03/04/2020
        SideNo: 1, // added by vivek on 03/04/2020
        BalanceId: resultdata.incompleteData.BalanceId,
        BFGCode: resultdata.incompleteData.BFGCode,
        SFOID: resultdata.incompleteData.SFOID,
        MPN_Code: resultdata.incompleteData.MPN_Code,
        Repetition: resultdata.incompleteData.Repetition,
        ProductName: resultdata.incompleteData.ProductName,
        ProductType: resultdata.incompleteData.ProductType,
        Qty: resultdata.incompleteData.Qty,
        GrpQty: resultdata.incompleteData.GrpQty,
        GrpFreq: resultdata.incompleteData.GrpFreq,
        Idsno: resultdata.incompleteData.DsNo,
        DsNo: resultdata.incompleteData.DsNo,
        TabIp: resultdata.incompleteData.TabIp,
        CubicalNo: resultdata.incompleteData.CubicalNo,
        // InsturmentID: resultdata.incompleteData.InsturmentID,
        // BalanceNo: resultdata.incompleteData.BalanceNo,
        // VernierId: resultdata.incompleteData.VernierId,
        // VernierNo: resultdata.incompleteData.VernierNo,
        BatchNo: resultdata.incompleteData.BatchNo,
        UserId: resultdata.incompleteData.UserId,
        UserName: resultdata.incompleteData.UserName,
        PrDate: resultdata.incompleteData.PrDate,
        PrTime: momentObj(resultdata.incompleteData.PrTime).format("HH:mm:ss"),
        PrEndDate: momentObj().format("YYYY-MM-DD"),
        PrEndTime: momentObj().format("HH:mm:ss"),
        Side: productDetail.ProductType == 2 ? "NA" : resultdata.incompleteData.Side,
        Unit: resultdata.incompleteData.Unit,
        DP: resultdata.incompleteData.DP,
        WgmtModeNo: resultdata.incompleteData.WgmtModeNo,
        Nom: resultdata.incompleteData.Nom,
        T1NegTol: resultdata.incompleteData.T1NegTol,
        T1PosTol: resultdata.incompleteData.T1PosTol,
        // T2NegTol: resultdata.incompleteData.T2NegTol,
        // T2PosTol: resultdata.incompleteData.T2PosTol,
        limitOn: resultdata.incompleteData.LimitOn,
        StdLimit1: resultdata.incompleteData.StdLimit1,
        StdLimit2: resultdata.incompleteData.StdLimit2,
        NomEmpty: resultdata.incompleteData.NomEmpty,
        T1NegEmpty: resultdata.incompleteData.T1NegEmpty,
        T1PosEmpty: resultdata.incompleteData.T1PosEmpty,
        // T2NegEmpty: resultdata.incompleteData.T2NegEmpty,
        // T2PosEmpty: resultdata.incompleteData.T2PosEmpty,
        AvgWeight: resultdata.incompleteData.AvgWeight,
        MinWeight: resultdata.incompleteData.MinWeight,
        MaxWeight: resultdata.incompleteData.MaxWeight,
        MinPer: resultdata.incompleteData.MinPer,
        MaxPer: resultdata.incompleteData.MaxPer,
        StdDev: resultdata.incompleteData.StdDev,
        NoOfAboveT1: resultdata.incompleteData.NoOfAboveT1,
        NoOfAboveT2: resultdata.incompleteData.NoOfAboveT2,
        NoOfBelowT1: resultdata.incompleteData.NoOfBelowT1,
        NoOfBelowT2: resultdata.incompleteData.NoOfBelowT2,
        NomNet: resultdata.incompleteData.NomNet,
        T1NegNet: resultdata.incompleteData.T1NegNet,
        T1PosNet: resultdata.incompleteData.T1PosNet,
        T2NegNet: resultdata.incompleteData.T2NegNet,
        T2PosNet: resultdata.incompleteData.T2PosNet,
        CubicleType: resultdata.incompleteData.CubicleType,
        ReportType: resultdata.incompleteData.ReportType,
        MachineCode: resultdata.incompleteData.MachineCode,
        // MFGCode: resultdata.incompleteData.MFGCode,
        BatchSize: resultdata.incompleteData.BatchSize,
        FriabilityID: resultdata.incompleteData.FriabilityID,
        HardnessID: resultdata.incompleteData.HardnessID,
        CubicleName: resultdata.incompleteData.CubicleName,
        CubicleLocation: resultdata.incompleteData.CubicleLocation,
        RepoLabel10: resultdata.incompleteData.RepoLabel10,
        RepoLabel11: resultdata.incompleteData.RepoLabel11,
        RepoLabel12: resultdata.incompleteData.RepoLabel12,
        RepoLabel13: resultdata.incompleteData.RepoLabel13,
        RepoLabel14: resultdata.incompleteData.RepoLabel14,
        PrintNo: resultdata.incompleteData.PrintNo,
        IsArchived: resultdata.incompleteData.IsArchived,
        GraphType: resultdata.incompleteData.GraphType,
        BatchComplete: resultdata.incompleteData.BatchComplete,
        PVersion: resultdata.incompleteData.PVersion,
        Version: resultdata.incompleteData.Version,
        CheckedByID: resultdata.incompleteData.CheckedByID,
        CheckedByName: resultdata.incompleteData.CheckedByName,
        CheckedByDate: resultdata.incompleteData.CheckedByDate,
        BRepSerNo: resultdata.incompleteData.BRepSerNo,
        // T1NMTTab :resultdata.incompleteDataTab,
        Lot: resultdata.incompleteData.Lot,
        Area: resultdata.incompleteData.Area,
        AppearanceDesc: resultdata.incompleteData.AppearanceDesc,
        MachineSpeed_Min: resultdata.incompleteData.MachineSpeed_Min,
        MachineSpeed_Max: resultdata.incompleteData.MachineSpeed_Max,
        GenericName: resultdata.incompleteData.GenericName,
        BMRNo: resultdata.incompleteData.BMRNo,
        Remark: remark,
        MesFlag: 0
      });

      var resultCompleteData = [masterCompleteData];
      var lastInsertedID = resultCompleteData[0].dataValues.RepSerNo;
      // var incompleteTableName = resultdata.incompleteTableName

      var objfetchMasterRecord = await models[resultdata.completeTableName].findOne({ where: { RepSerNo: lastInsertedID } });
      var tempdatatcp = [];

      for (const [i, v] of resultdata.detailData.entries()) {
        const insertDetailObj = {
          RepSerNo: lastInsertedID,
          RecSeqNo: i + 1,
          DataValue: v.DataValue,
          DP: v.DP,
          MstSerNo: objfetchMasterRecord.MstSerNo,
          UserId: objfetchMasterRecord.UserId,
          UserName: objfetchMasterRecord.UserName,
          PrDate: momentObj().format("YYYY-MM-DD"),
          PrTime: momentObj().format("HH:mm:ss"),
          PrEndDate: momentObj().format("YYYY-MM-DD"),
          PrEndTime: momentObj().format("HH:mm:ss"),
          isException: v.isException
        };

        if (productDetail.ProductType == 3) {
          insertDetailObj.data.push({
            str_colName: "DataValue1",
            value: v.DataValue1,
          });
          insertDetailObj.data.push({
            str_colName: "NetWeight",
            value: v.NetWeight,
          });
          insertDetailObj.data.push({ str_colName: "Remark", value: v.Remark });
        } else if (
          (productDetail.ProductType == 2 || productDetail.ProductType == 4) &&
          weighmentModeNo == "D"
        ) {
          // insertDetailObj.data.push({ DataValue1: v.DataValue1 })
          Object.assign(insertDetailObj, { DataValue1: v.DataValue1 });
          // insertDetailObj.data.push({NetWeight: v.NetWeight })
          Object.assign(insertDetailObj, { NetWeight: v.NetWeight });
        }
        let res = await models[resultdata.detailTableName].create(insertDetailObj);
        tempdatatcp.push(insertDetailObj.DataValue)
      }

      let createExceptionData = [];
      if (resultdata.garbageData.length > 0) {
        for (let [i, data] of resultdata.garbageData.entries()) {
          let obj = {
            DsNo: objfetchMasterRecord.DsNO,
            TabIp: objfetchMasterRecord.TabIp,
            Remark: data.Remark,
            DataValue: data.DataValue,
            DataValueUnit: objfetchMasterRecord.Unit,
            RepSerNo: data.RepSerNo,
            MenuName: menuName,
            ProductType: objfetchMasterRecord.ProductType,
            TypeValue: 1,
            BFGCode: data.BFGCode,
            ProductName: data.ProductName,
            BatchNo: data.BatchNo,
            Department: objfetchMasterRecord.Department,
            SFOID: objfetchMasterRecord.SFOID,
            MachineCode: objfetchMasterRecord.MachineCode,
            PrDate: data.PrDate,
            prTime: data.PrTime,
            Side: objfetchMasterRecord.Side,
            InstrumentId: data.InstrumentID,
            T1NegTol: objfetchMasterRecord.T2NegTol,
            T1PosTol: objfetchMasterRecord.T2PosTol,
            SampleNo: data.RecSeqNo,
            Area: objfetchMasterRecord.Area,
            UserID: data.UserId,
            UserName: data.UserName,
            CubicalName: objfetchMasterRecord.CubicalName,
            InstrumentType: objfetchMasterRecord.InstrumentType,
            CubicalName: objfetchMasterRecord.CubicalName,
            InstrumentType: objfetchMasterRecord.InstrumentType
          }
          createExceptionData.push(obj)
        }
      }
      await models.tbl_exception_sample.bulkCreate(createExceptionData);

      await models[resultdata.incompleteTableName].destroy({ where: { RepSerNo: resultdata.incompleteData.RepSerNo } });
      await models[resultdata.incompletedetailTableName].destroy({ where: { RepSerNo: resultdata.incompleteData.RepSerNo } });

      Object.assign(responseObj, { status: "success", RepSerNo: lastInsertedID });

      return responseObj;
    } catch (err) {
      console.log("Error message : " + err);
      // var logError = date.format(new Date(), 'DD-MM-YYYY HH:mm:ss') + " , " + err;
      // logError = logError + err;
      // //commented by vivek on 31-07-2020*********************************** */
      // //ErrorLog.error(logError);
      // ErrorLog.addToErrorLog(logError);
      //******************************************************************* */
      throw new Error(err);
    }
  }

  async saveCommonDataToCompleteHardness(resultdata, weighmentModeNo = 0, DsNo, tabIp) {
    try {

      let side = resultdata.incompleteData.Side
      let strDsNo = DsNo;
      let strTabIp = tabIp
      // var IPQCObject = globalData.arr_IPQCRelIds.find((k) => k.idsNo == Idsno);
      // if (IPQCObject != undefined) {
      //   selectedIdsNo = IPQCObject.selectedIds;
      // } else {
      //   selectedIdsNo = Idsno;
      // }

      var arrProductType = globalData.arrProductTypeArray.find(
        (k) => k.DsNo == strDsNo
      );

      let cubicalObj = globalData.arrIdsInfo.find(k => k.DsNo == strDsNo).cubicalData;

      var productDetail = arrProductType.productType;
      // var objMenu = globalData.arrMultihealerMS.find(k => k.idsNo == Idsno);
      let responseObj = {};

      let tableName = resultdata.completeTableName;

      const checkData = await models[tableName].findAll({
        attributes: [[sequelize.fn("max", sequelize.col("MstSerNo")), "SeqNo"]],
        where: {
          // BFGCode: cubicalObj.Sys_BFGCode,
          MPN_Code: cubicalObj.Sys_MPNCode,
          ProductName: cubicalObj.Sys_ProductName,
          PVersion: cubicalObj.Sys_PVersion,
          Version: cubicalObj.Sys_Version,
          BatchNo: cubicalObj.Sys_Batch,
        },
      });



      var resultCompleteData = checkData

      var intMstSerNo;
      if (resultCompleteData[0].SeqNo == null) {
        intMstSerNo = 1;
      } else {
        var newMstSerNo = resultCompleteData[0].SeqNo + 1;
        intMstSerNo = newMstSerNo;
      }

      // var check_master_SRno = await check_srNO.check_master_SRno({DsNo:strDsNo}, cubicalObj, strDsNo, productDetail, tableName, side)

      const masterCompleteData = await models.tbl_tab_masterhtd.create({
        DsNo: strDsNo,
        MstSerNo: intMstSerNo,
        InstruId: resultdata.incompleteData.InstruId,
        BFGCode: resultdata.incompleteData.BFGCode,
        ProductName: resultdata.incompleteData.ProductName,
        ProductType: resultdata.incompleteData.ProductType,
        Qty: parseInt(resultdata.incompleteData.Qty),
        Department: resultdata.incompleteData.Department,
        GrpQty: 0,
        GrpFreq: 0,
        Idsno: resultdata.incompleteData.Idsno,
        CubicalNo: resultdata.incompleteData.CubicalNo,
        BalanceId: resultdata.incompleteData.BalanceId,
        BalanceNo: resultdata.incompleteData.BalanceNo,
        VernierId: resultdata.incompleteData.VernierId,
        VernierNo: resultdata.incompleteData.VernierNo,
        BatchNo: resultdata.incompleteData.BatchNo,
        UserId: resultdata.incompleteData.UserId,
        UserName: resultdata.incompleteData.UserName,
        PrDate: momentObj().format("YYYY-MM-DD"),
        PrTime: momentObj().format("HH:mm:ss"),
        Side: resultdata.incompleteData.Side,
        Unit: resultdata.incompleteData.Unit,
        DecimalPoint: resultdata.incompleteData.DecimalPoint,
        WgmtModeNo: 7,
        NomThick: resultdata.incompleteData.NomThick,
        PosTolThick: resultdata.incompleteData.PosTolThick,
        NegTolThick: resultdata.incompleteData.NegTolThick,
        T2PosTolThick: resultdata.incompleteData.T2PosTolThick,
        T2NegTolThick: resultdata.incompleteData.T2NegTolThick,
        NomHard: resultdata.incompleteData.NomHard,
        PosTolHard: resultdata.incompleteData.PosTolHard,
        NegTolHard: resultdata.incompleteData.NegTolHard,
        T2PosTolHard: resultdata.incompleteData.T2PosTolHard,
        T2NegTolHard: resultdata.incompleteData.T2NegTolHard,
        NomDOLOBO: resultdata.incompleteData.NomDOLOBO,
        PosTolDOLOBO: resultdata.incompleteData.PosTolDOLOBO,
        NegTolDOLOBO: resultdata.incompleteData.NegTolDOLOBO,
        ColHeadDOLOBO: resultdata.incompleteData.ColHeadDOLOBO,
        CubicleType: resultdata.incompleteData.CubicleType,
        ReportType: resultdata.incompleteData.ReportType,
        MachineCode: resultdata.incompleteData.MachineCode,
        MFGCode: resultdata.incompleteData.MFGCode,
        BatchSize: resultdata.incompleteData.BatchSize,
        HardnessID: resultdata.incompleteData.HardnessID,
        CubicleName: resultdata.incompleteData.CubicleName,
        CubicleLocation: resultdata.incompleteData.CubicleLocation,
        RepoLabel10: resultdata.incompleteData.RepoLabel10,
        RepoLabel11: 0,
        RepoLabel12: "Null",
        RepoLabel13: "Null",
        IsArchived: 0,
        GraphType: 0,
        PVersion: resultdata.incompleteData.PVersion,
        Version: resultdata.incompleteData.Version,
        BRepSerNo: resultdata.incompleteData.BRepSerNo,
        Lot: resultdata.incompleteData.Lot,
        Area: resultdata.incompleteData.Area,
        SFOID: resultdata.incompleteData.SFOID,
        isManual: resultdata.incompleteData.isManual,
        AvgThick: resultdata.incompleteData.AvgThick,
        AvgHard: resultdata.incompleteData.AvgHard,
        AvgDiam: resultdata.incompleteData.AvgDiam,
        AvgBL: resultdata.incompleteData.AvgBL,
        MinWeightHard: resultdata.incompleteData.MinWeightHard,
        MaxWeightHard: resultdata.incompleteData.MaxWeightHard,
        MinWeightThick: resultdata.incompleteData.MinWeightThick,
        MaxWeightThick: resultdata.incompleteData.MaxWeightThick,
        MinWeightDiam: resultdata.incompleteData.MinWeightDiam,
        MaxWeightDiam: resultdata.incompleteData.MaxWeightDiam,
        MinWeightBL: resultdata.incompleteData.MinWeightBL,
        MaxWeightBL: resultdata.incompleteData.MaxWeightBL,
        StdDevHard: resultdata.incompleteData.StdDevHard,
        StdDevThick: resultdata.incompleteData.StdDevThick,
        StdDevDiam: resultdata.incompleteData.StdDevDiam,
        StdDevBL: resultdata.incompleteData.MaxWeightBL,
        Layer: 'NA',
        TabIp: strTabIp,
        Repetition: resultdata.incompleteData.Repetition,
        RemarkHard: resultdata.incompleteData.RemarkHard,
        RemarkThick: resultdata.incompleteData.RemarkThick,
        RemarkDiam: resultdata.incompleteData.RemarkDiam,
        RemarkBL: resultdata.incompleteData.RemarkBL,
        BLName: resultdata.incompleteData.BLName,
        Eqp_Model: resultdata.incompleteData.Eqp_Model,
        Eqp_Make: resultdata.incompleteData.Eqp_Make,
        MPN_Code: resultdata.incompleteData.MPN_Code
      });

      var lastInsertedID = masterCompleteData._previousDataValues.RepSerNo;

      for (let [i, v] of resultdata.detailData.entries()) {
        let tableName = resultdata.detailTableName;
        const insertDetailObj = await models[tableName].create({
          RepSerNo: lastInsertedID,
          RecSeqNo: i + 1,
          DataValueThick: v.DataValueThick,
          DataValueBL: v.DataValueBL,
          // DataValueDOLOBO: v.DataValueDOLOBO,
          DataValueHard: v.DataValueHard,
          // DecimalPointThick: v.DecimalPointThick,
          // DecimalPointDOLOBO: v.DecimalPointDOLOBO,
          // DecimalPointHard: v.DecimalPointHard,
          idsNo: 0,
        });
      }

      for (let [i, v] of resultdata.garbageData.entries()) {

        let data = await models.tbl_exception_samplehtd.findOne({
          where: {
            RepSerNo: v.RepSerNo,
            SampleNo: v.RecSeqNo,
            Remark: 'NULL'
          }
        })

        await models.tbl_exception_samplehtd.update({
          Remark: v.Remark,
          RepSerNo: lastInsertedID
        }, {
          where: {
            RepSerNo: v.RepSerNo,
            id: data.id
          }
        })

      }


      const deleteIncompleteData = await models[
        resultdata.incompleteTableName
      ].destroy({
        where: {
          RepSerNo: resultdata.incompleteData.RepSerNo,
        },
      });

      // const deleteIncompleteData = {
      //     str_tableName: resultdata.incompleteTableName,
      //     condition: [
      //         { str_colName: 'RepSerNo', value: resultdata.incompleteData.RepSerNo, comp: 'eq' },

      //     ]
      // }
      // let res = await database.delete(deleteIncompleteData);

      // const deleteIncompleteDetailData = {
      //     str_tableName: resultdata.incompletedetailTableName,
      //     condition: [
      //         { str_colName: 'RepSerNo', value: resultdata.incompleteData.RepSerNo, comp: 'eq' },
      //     ]
      // }
      // let res1 = await database.delete(deleteIncompleteDetailData);

      const deleteIncompleteDetailData = await models[
        resultdata.incompletedetailTableName
      ].destroy({
        where: {
          RepSerNo: resultdata.incompleteData.RepSerNo,
        },
      });

      Object.assign(responseObj, { status: "success", RepSerNo: lastInsertedID });

      return responseObj;

    } catch (err) {

      console.log("Error message : " + err);
      // var logError = date.format(new Date(), 'DD-MM-YYYY HH:mm:ss') + " , " + err;
      // logError = logError + err;
      // //commented by vivek on 31-07-2020*********************************** */
      // //ErrorLog.error(logError);
      // ErrorLog.addToErrorLog(logError);
      //******************************************************************* */
      throw new Error(err);
    }
  }

  async saveHardnessData8M(resultdata, srno, idsNo, strHmi, tableName) {
    try {
      var mstSerNo = "";
      var sideNo = "";
      let responseObj = {};
      const getIncompleteMasterData = await models[
        "tbl_tab_master_htd_incomplete"
      ].findAll({
        where: {
          RepSerNo: srno,
          Idsno: strHmi, //strHmi
        },
      });

      var masterData = [getIncompleteMasterData];
      var completeMastData = masterData[0][0];


      //idsno to strHmi
      const checkMasterData = await models[tableName].findAll({
        attributes: [[sequelize.fn("max", sequelize.col("RepSerNo")), "RepSerNo"]],
        where: {
          BFGCode: completeMastData.BFGCode,
          ProductName: completeMastData.ProductName,
          PVersion: completeMastData.PVersion,
          Version: completeMastData.Version,
          BatchNo: completeMastData.BatchNo,
          Idsno: strHmi, //strHmi
        },
      });
      var result = [checkMasterData];
      var intMstSerNo;

      if (result[0][0].RepSerNo == null) {
        intMstSerNo = 1;
      } else {
        var newMstSerNo = result[0][0].RepSerNo + 1;
        intMstSerNo = newMstSerNo;
      }
      var mstTblName = "tbl_tab_master_htd";
      if (completeMastData.ReportType == 1) {
        //for Initial
        mstSerNo = intMstSerNo;
        sideNo = 1;
      } else {
        //regular
        let objMt50Like8M = {
          tableName: mstTblName,
          ReportType: 0,
          Side: completeMastData.Side,
          BFGCode: completeMastData.BFGCode,
          ProductName: completeMastData.ProductName,
          PVersion: completeMastData.PVersion,
          Version: completeMastData.Version,
          BatchNo: completeMastData.BatchNo,
          IdsNo: completeMastData.Idsno,
        };
        if (completeMastData.Side == "NA") {
          mstSerNo = await objGetMstSrAndSideSr.getRegularLRMstSerialNo(
            objMt50Like8M
          );
          sideNo = await objGetMstSrAndSideSr.getRegularLRSideNo(objMt50Like8M);

          if (sideNo < 10) {
            sideNo = sideNo + 1;
          } else {
            sideNo = 1;
            mstSerNo = mstSerNo + 1;
          }
        } else {
          mstSerNo = await objGetMstSrAndSideSr.getRegularLRMstSerialNo(
            objMt50Like8M
          );
          sideNo = await objGetMstSrAndSideSr.getRegularLRSideNo(objMt50Like8M);

          if (sideNo < 5) {
            sideNo = sideNo + 1;
          } else {
            sideNo = 1;
            mstSerNo = mstSerNo + 1;
          }
        }
      }

      let now = new Date();

      var remark_forHard;
      if (resultdata.incompleteData.AvgValueHard != 0 && resultdata.incompleteData.AvgValueHard != 'NA') {
        if ((Number(completeMastData.NoOfAboveT2Hard) != 0 || Number(completeMastData.NoOfBelowT2Hard) != 0)) {
          remark_forHard = 'Not Complies';
        } else {
          remark_forHard = 'Complies';
        }
      } else {
        remark_forHard = 'NA';
      }

      var remark_forthick;
      if (resultdata.incompleteData.AvgValueThick != 0 && resultdata.incompleteData.AvgValueThick != 'NA') {
        if ((Number(completeMastData.NoOfAboveT2Thick) != 0 || Number(completeMastData.NoOfBelowT2Thick) != 0)) {
          remark_forthick = 'Not Complies';
        } else {
          remark_forthick = 'Complies';
        }
      } else {
        remark_forthick = 'NA';
      }


      const masterCompleteData = await models["tbl_tab_master_htd"].create({
        MstSerNo: mstSerNo,
        WgmtModeNo: completeMastData.WgmtModeNo,
        Area: completeMastData.Area,
        CubicalNo: completeMastData.CubicalNo,
        CubicleName: completeMastData.CubicleName,
        CubicleType: completeMastData.CubicleType,
        Dept: completeMastData.Dept,
        BMRNo: completeMastData.BMRNo,
        BFGCode: completeMastData.BFGCode,
        BatchNo: completeMastData.BatchNo,
        ProductName: completeMastData.ProductName,
        ProductType: completeMastData.ProductType,
        PVersion: completeMastData.PVersion,
        Version: completeMastData.Version,
        MachineCode: completeMastData.MachineCode,
        BatchSize: completeMastData.BatchSize,
        Qty: completeMastData.Qty,
        Idsno: completeMastData.Idsno,
        InsturmentID: completeMastData.InsturmentID,
        UserId: completeMastData.UserId,
        UserName: completeMastData.UserName,
        PrDate: completeMastData.PrDate,
        PrTime: momentObj(completeMastData.PrTime).format("HH:mm:ss"),
        PrEndDate: momentObj().format("YYYY-MM-DD"),
        PrEndTime: momentObj().format("HH:mm:ss"),
        Side: completeMastData.Side,
        Unit: completeMastData.Unit,
        DP: completeMastData.DP,
        NomHard: completeMastData.NomHard,
        NomThick: completeMastData.NomThick,
        T1NegTolHard: completeMastData.T1NegTolHard,
        T1PosTolHard: completeMastData.T1PosTolHard,
        T2NegTolHard: completeMastData.T2NegTolHard,
        T2PosTolHard: completeMastData.T2PosTolHard,
        T1NegTolThick: completeMastData.T1NegTolThick,
        T1PosTolThick: completeMastData.T1PosTolThick,
        T2NegTolThick: completeMastData.T2NegTolThick,
        T2PosTolThick: completeMastData.T2PosTolThick,
        LimitOn: completeMastData.LimitOn,
        T1NMT: completeMastData.T1NMT,
        ReportType: completeMastData.ReportType,
        AvgValueHard: completeMastData.AvgValueHard,
        MinValueHard: completeMastData.MinValueHard,
        MaxValueHard: completeMastData.MaxValueHard,
        AvgValueThick: completeMastData.AvgValueThick,
        MinValueThick: completeMastData.MinValueThick,
        MaxValueThick: completeMastData.MaxValueThick,
        StdDevHard: completeMastData.StdDevHard,
        StdDevThick: completeMastData.StdDevThick,
        NoOfAboveT1Hard: completeMastData.NoOfAboveT1Hard,
        NoOfAboveT2Hard: completeMastData.NoOfAboveT2Hard,
        NoOfBelowT1Hard: completeMastData.NoOfBelowT1Hard,
        NoOfBelowT2Hard: completeMastData.NoOfBelowT2Hard,
        NoOfAboveT1Thick: completeMastData.NoOfAboveT1Thick,
        NoOfAboveT2Thick: completeMastData.NoOfAboveT2Thick,
        NoOfBelowT1Thick: completeMastData.NoOfBelowT1Thick,
        NoOfBelowT2Thick: completeMastData.NoOfBelowT2Thick,
        RemarkHard: remark_forHard,
        RemarkThick: remark_forthick

      });

      //console.log(masterCompleteData);
      var masterSrno = [masterCompleteData];
      var lastInsertedId = masterCompleteData._previousDataValues.RepSerNo;


      const getIncompleteDetailData = await models[
        "tbl_tab_detailhtd_incomplete"
      ].findAll({
        where: {
          RepSerNo: srno,
        },
      });
      //var completedetailData = [getIncompleteDetailData][0][0];
      var completedetailData = [getIncompleteDetailData][0];


      for (const [i, v] of resultdata.detailData.entries()) {
        const insertDetailObj = await models["tbl_tab_detailhtd"].create({
          RepSerNo: lastInsertedId,
          MstSerNo: 0,
          RecSeqNo: i + 1,
          DataValueHard: v.DataValueHard,
          DataValueThick: v.DataValueThick,
          DP: v.DP,
        });
      }


      const deleteIncompleteMasterData = await models[
        "tbl_tab_master_htd_incomplete"
      ].destroy({
        where: {
          RepSerNo: srno,
          Idsno: strHmi,
        },
      });


      const deleteIncompleteDetailData = await models[
        "tbl_tab_detailhtd_incomplete"
      ].destroy({
        where: {
          RepSerNo: srno,
        },
      });

      Object.assign(responseObj, { status: "success", RepSerNo: lastInsertedId });

      // return remarkRes;
      return responseObj;
    } catch (err) {
      //******************************************************************* */
      console.log("error from Hardness Saving", err);
    }
  }

  async saveDataToCompletePerFineAndParticalSizing(resultdata, weighmentModeNo = 0, Idsno) {
    try {
      let now = new Date();
      var mstSerNo = "";
      var sideNo = "";
      var arrProductType = globalData.arrProductTypeArray.find((k) => k.idsNo == Idsno);
      var productDetail = arrProductType.productType;
      // var objMenu = globalData.arrMultihealerMS.find(k => k.idsNo == Idsno);
      let responseObj = {};
      var str_tableName = resultdata.completeTableName;
      const checkData = await models[str_tableName].findAll({
        attributes: [[sequelize.fn('max', sequelize.col('RepSerNo')), 'RepSerNo']],
        where: {
          BFGCode: resultdata.incompleteData.BFGCode,
          ProductName: resultdata.incompleteData.ProductName,
          PVersion: resultdata.incompleteData.PVersion,
          Version: resultdata.incompleteData.Version,
          BatchNo: resultdata.incompleteData.BatchNo,
          Idsno: resultdata.incompleteData.Idsno
        }
      })
      if (productDetail.ProductType == 3) {
        checkData.condition.push({
          str_colName: "TestType",
          value: objMenu.menu,
          comp: "eq",
        });
      }
      var resultCompleteData = checkData;
      var intMstSerNo;
      if (resultCompleteData[0].SeqNo == null) {
        intMstSerNo = 1;
      } else {
        var newMstSerNo = resultCompleteData[0].SeqNo + 1;
        intMstSerNo = newMstSerNo;
      }

      var masterCompleteData = await models[str_tableName].create({
        MstSerNo: intMstSerNo,
        InstruId: 1,
        BFGCode: resultdata.incompleteData.BFGCode,
        ProductName: resultdata.incompleteData.ProductName,
        ProductType: resultdata.incompleteData.ProductType,
        Qty: resultdata.incompleteData.Qty,
        GrpQty: resultdata.incompleteData.GrpQty,
        GrpFreq: resultdata.incompleteData.GrpFreq,
        Idsno: resultdata.incompleteData.Idsno,
        CubicalNo: resultdata.incompleteData.CubicalNo,
        BalanceId: resultdata.incompleteData.BalanceId,
        VernierId: resultdata.incompleteData.VernierId,
        BatchNo: resultdata.incompleteData.BatchNo,
        UserId: resultdata.incompleteData.UserId,
        UserName: resultdata.incompleteData.UserName,
        PrDate: momentObj().format("YYYY-MM-DD"),
        PrTime: momentObj().format("HH:mm:ss"),
        Side: "NA",
        Unit: resultdata.incompleteData.Unit,
        DecimalPoint: resultdata.incompleteData.DecimalPoint,
        WgmtModeNo: resultdata.incompleteData.WgmtModeNo,
        Nom: 0,
        T1NegTol: resultdata.incompleteData.T1NegTol,
        T1PosTol: resultdata.incompleteData.T1PosTol,
        CubicleType: resultdata.incompleteData.CubicleType,
        ReportType: resultdata.incompleteData.ReportType,
        MachineCode: resultdata.incompleteData.MachineCode,
        MFGCode: resultdata.incompleteData.MFGCode,
        BatchSize: `${resultdata.incompleteData.BatchSize} ${resultdata.incompleteData.Unit}`,
        FriabilityID: resultdata.incompleteData.FriabilityID,
        HardnessID: resultdata.incompleteData.HardnessID,
        CubicleName: resultdata.incompleteData.CubicleName,
        CubicleLocation: resultdata.incompleteData.CubicleLocation,
        RepoLabel10: resultdata.incompleteData.RepoLabel10,
        RepoLabel11: resultdata.incompleteData.RepoLabel11,
        PrintNo: 0,
        IsArchived: 0,
        GraphType: 0,
        BatchComplete: 0,
        PVersion: resultdata.incompleteData.PVersion,
        Version: resultdata.incompleteData.Version,
        Lot: resultdata.incompleteData.Lot, //objLotData.LotNo
        AppearanceDesc: resultdata.incompleteData.AppearanceDesc,
        MachineSpeed_Min: resultdata.incompleteData.MachineSpeed_Min,
        MachineSpeed_Max: resultdata.incompleteData.MachineSpeed_Max,
        GenericName: resultdata.incompleteData.GenericName,
        BMRNo: resultdata.incompleteData.BMRNo,
      })
      var resultCompleteData = masterCompleteData;
      var lastInsertedID = resultCompleteData.dataValues.RepSerNo;

      var fetchMasterRecord = await models[str_tableName].findAll({
        attributes: [[sequelize.fn('max', sequelize.col('RepSerNo')), 'RepSerNo']],
      }, {
        where: {
          RepSerNo: lastInsertedID,
        }
      }
      )
      var objfetchMasterRecord = fetchMasterRecord;

      for (const [i, v] of resultdata.detailData.entries()) {
        const insertDetailObj = await models[resultdata.detailTableName].create({
          RepSerNo: lastInsertedID,
          RecSeqNo: i + 1,
          DataValue: v.DataValue,
          DecimalPoint: v.DecimalPoint,
          MstSerNo: objfetchMasterRecord[0].RepSerNo
        })

        var respose = insertDetailObj;
      }

      const deleteIncompleteData = await models[resultdata.incompleteTableName].destroy({
        where: {
          RepSerNo: resultdata.incompleteData.RepSerNo
        }
      });
      const deleteIncompleteDetailData = await models[resultdata.incompletedetailTableName].destroy({
        where: {
          RepSerNo: resultdata.incompleteData.RepSerNo
        }

      });
      const powerdelete = await models.tbl_powerbackup.destroy({
        where: {
          Sys_Batch: resultdata.incompleteData.BatchNo,
          Idsno: resultdata.incompleteData.Idsno
        }
      })


      Object.assign(responseObj, { status: "success" });

      return responseObj;
    } catch (err) {
      console.log("Error message : " + err);
      throw new Error(err);
    }
  }

  async saveDiffDataToComplete(resultdata, weighmentModeNo = 0, Idsno) {
    try {
      var mstSerNo = '';
      var sideNo = '';
      let strIdsNo = Idsno;
      let selectedIdsNo;


      var arrProductType = globalData.arrProductTypeArray.find(k => k.Hmi == strIdsNo);
      var productDetail = arrProductType.productType;
      // var objMenu = globalData.arrMultihealerMS.find(k => k.idsNo == Idsno);
      let tempUserObject = globalData.arrUsers.find(k => k.Hmi == strIdsNo);
      let responseObj = {};
      const checkData = await models[resultdata.completeTableName].findAll({
        attributes: [[sequelize.fn('max', sequelize.col('MstSerNo')), 'SeqNo']],
        where: {
          BFGCode: resultdata.incompleteData.BFGCode,
          ProductName: resultdata.incompleteData.ProductName,
          PVersion: resultdata.incompleteData.PVersion,
          Version: resultdata.incompleteData.Version,
          BatchNo: resultdata.incompleteData.BatchNo,
          Idsno: resultdata.incompleteData.Idsno,

        }
      })
      var checkData1 = await models[resultdata.incompleteTableName].findAll({
        attributes: [[sequelize.fn('max', sequelize.col('MstSerNo')), 'SeqNo']],
        where: {
          BFGCode: resultdata.incompleteData.BFGCode,
          ProductName: resultdata.incompleteData.ProductName,
          PVersion: resultdata.incompleteData.PVersion,
          Version: resultdata.incompleteData.Version,
          BatchNo: resultdata.incompleteData.BatchNo,
          Idsno: resultdata.incompleteData.Idsno,

        }
      })
      checkData1 = checkData1[0].SeqNo


      if (productDetail.ProductType == 3) {
        checkData.condition.push({ str_colName: 'TestType', value: objMenu.menu, comp: 'eq' })
      }
      var resultCompleteData = [checkData];
      var intMstSerNo;
      if (resultCompleteData[0][0].SeqNo == null) {
        intMstSerNo = 1;
      } else {
        var newMstSerNo = resultCompleteData[0][0].SeqNo + 1;
        intMstSerNo = newMstSerNo;
      }
      intMstSerNo = Math.max(checkData1, intMstSerNo)


      var masterCompleteData = await models[resultdata.completeTableName].create({
        MstSerNo: intMstSerNo,
        SideNo: 0,
        InstruId: resultdata.incompleteData.InstruId,
        BFGCode: resultdata.incompleteData.BFGCode,
        ProductName: resultdata.incompleteData.ProductName,
        ProductType: 2,
        Qty: resultdata.incompleteData.Qty,
        GrpQty: resultdata.incompleteData.GrpQty,
        GrpFreq: resultdata.incompleteData.GrpFreq,
        Idsno: resultdata.incompleteData.Idsno,
        CubicalNo: resultdata.incompleteData.CubicalNo,
        BalanceId: resultdata.incompleteData.BalanceId,
        BalanceNo: resultdata.incompleteData.BalanceNo,
        VernierId: resultdata.incompleteData.VernierId,
        VernierNo: resultdata.incompleteData.VernierNo,
        BatchNo: resultdata.incompleteData.BatchNo,
        UserId: resultdata.incompleteData.UserId,
        UserName: resultdata.incompleteData.UserName,
        PrDate: resultdata.incompleteData.PrDate,
        PrTime: resultdata.incompleteData.PrTime,
        PrEndDate: resultdata.incompleteData.PrEndDate,
        PrEndTime: resultdata.incompleteData.PrEndTime,
        Side: (productDetail.ProductType == 2) ? 'NA' : resultdata.incompleteData.Side,
        Unit: resultdata.incompleteData.Unit,
        DecimalPoint: resultdata.incompleteData.DecimalPoint,
        WgmtModeNo: resultdata.incompleteData.WgmtModeNo,
        Nom: resultdata.incompleteData.Nom,
        T1NegTol: resultdata.incompleteData.T1NegTol,
        T1PosTol: resultdata.incompleteData.T1PosTol,
        T2NegTol: resultdata.incompleteData.T2NegTol,
        T2PosTol: resultdata.incompleteData.T2PosTol,
        limitOn: resultdata.incompleteData.limitOn[0],
        NomEmpty: resultdata.incompleteData.NomEmpty,
        T1NegEmpty: resultdata.incompleteData.T1NegEmpty,
        T1PosEmpty: resultdata.incompleteData.T1PosEmpty,
        T2NegEmpty: resultdata.incompleteData.T2NegEmpty,
        T2PosEmpty: resultdata.incompleteData.T2PosEmpty,
        NomNet: resultdata.incompleteData.NomNet,
        T1NMTTab: resultdata.incompleteData.T1NMTTab,
        CubicleType: resultdata.incompleteData.CubicleType,
        ReportType: resultdata.incompleteData.ReportType,
        MachineCode: resultdata.incompleteData.MachineCode,
        MFGCode: resultdata.incompleteData.MFGCode,
        BatchSize: resultdata.incompleteData.BatchSize,
        FriabilityID: resultdata.incompleteData.FriabilityID,
        HardnessID: resultdata.incompleteData.HardnessID,
        CubicleName: resultdata.incompleteData.CubicleName,
        CubicleLocation: resultdata.incompleteData.CubicleLocation,
        RepoLabel10: resultdata.incompleteData.RepoLabel10,
        RepoLabel11: resultdata.incompleteData.RepoLabel11,
        RepoLabel12: resultdata.incompleteData.RepoLabel12,
        RepoLabel13: resultdata.incompleteData.RepoLabel13,
        RepoLabel14: resultdata.incompleteData.RepoLabel14,
        PrintNo: resultdata.incompleteData.PrintNo,
        IsArchived: resultdata.incompleteData.IsArchived[0],
        GraphType: resultdata.incompleteData.GraphType,
        BatchComplete: 0,
        PVersion: resultdata.incompleteData.PVersion,
        Version: resultdata.incompleteData.Version,
        GraphTypeEmpty: resultdata.incompleteData.GraphTypeEmpty,
        limitOnEmpty: resultdata.incompleteData.limitOnEmpty[0],
        NMTTabEmpty: resultdata.incompleteData.NMTTabEmpty,
        T1NegNet: resultdata.incompleteData.T1NegNet,
        T1PosNet: resultdata.incompleteData.T1PosNet,
        T2NegNet: resultdata.incompleteData.T2NegNet,
        T2PosNet: resultdata.incompleteData.T2PosNet,
        BatchComplete: resultdata.incompleteData.BatchComplete[0],
        PVersion: resultdata.incompleteData.PVersion,
        Version: resultdata.incompleteData.Version,
        CheckedByID: resultdata.incompleteData.CheckedByID,
        CheckedByName: resultdata.incompleteData.CheckedByName,
        CheckedByDate: resultdata.incompleteData.CheckedByDate,
        BRepSerNo: resultdata.incompleteData.BRepSerNo,
        Lot: resultdata.incompleteData.Lot,
        Area: resultdata.incompleteData.Area,
        AppearanceDesc: resultdata.incompleteData.AppearanceDesc,
        MachineSpeed_Min: resultdata.incompleteData.MachineSpeed_Min,
        MachineSpeed_Max: resultdata.incompleteData.MachineSpeed_Max,
        GenericName: resultdata.incompleteData.GenericName,
        BMRNo: resultdata.incompleteData.BMRNo,
        GraphTypeNet: resultdata.incompleteData.GraphTypeNet,
        limitOnNet: resultdata.incompleteData.limitOnNet[0],
        NMTTabNet: resultdata.incompleteData.NMTTabNet

      })


      var resultCompleteData = [masterCompleteData]
      var lastInsertedID = resultCompleteData[0].RepSerNo;
      // var incompleteTableName = resultdata.incompleteTableName

      var fetchMasterRecord = await models[resultdata.completeTableName].findAll({
        where: {
          RepSerNo: lastInsertedID
        }
      })


      var objfetchMasterRecord = fetchMasterRecord

      for (const [i, v] of resultdata.detailData.entries()) {
        const insertDetailObj = {
          RepSerNo: lastInsertedID,
          RecSeqNo: i + 1,
          DataValue: v.DataValue,
          DecimalPoint: v.DecimalPoint,
          MstSerNo: objfetchMasterRecord[0].MstSerNo,
          Side: objfetchMasterRecord[0].Side,
          UserId: objfetchMasterRecord[0].UserId,
          UserName: objfetchMasterRecord[0].UserName

        }

        if (productDetail.ProductType == 3) {
          insertDetailObj.data.push({ str_colName: 'DataValue1', value: v.DataValue1 })
          insertDetailObj.data.push({ str_colName: 'NetWeight', value: v.NetWeight })
          insertDetailObj.data.push({ str_colName: 'Remark', value: v.Remark })
        } else if ((productDetail.ProductType == 2 || productDetail.ProductType == 4) && weighmentModeNo == "D") {
          // insertDetailObj.data.push({ DataValue1: v.DataValue1 })
          Object.assign(insertDetailObj, { DataValue1: v.DataValue1 })
          // insertDetailObj.data.push({NetWeight: v.NetWeight })
          Object.assign(insertDetailObj, { NetWeight: v.NetWeight })
        }
        let res = await models[resultdata.detailTableName].create(insertDetailObj);
      }

      const deleteIncompleteData = await models[resultdata.incompleteTableName].destroy({
        where: {
          RepSerNo: resultdata.incompleteData.RepSerNo,
        }
      })

      let res = [deleteIncompleteData];

      const deleteIncompleteDetailData = await models[resultdata.incompletedetailTableName].destroy({
        where: {
          RepSerNo: resultdata.incompleteData.RepSerNo

        }
      })

      let res1 = deleteIncompleteDetailData;

      Object.assign(responseObj, { status: 'success', RepSerNo: lastInsertedID })

      return responseObj
    } catch (err) {
      console.log("Error message : " + err);

      throw new Error(err);
    }
  }

  async moveToTerminatedExceptionTable(lastInsertedID, menuName, objfetchMasterRecord, exceptionData, rptType, isTerminated) {
    try {
      let obj;

      let createExceptionData = [];
      let typeValue = objCommonWeightment.getTypeValue(menuName);
      let getLimitsObj = objCommonWeightment.getLimitsObj(typeValue, rptType);
      let T2Neg_Tol = objfetchMasterRecord[`Param${typeValue}_T2NegTol`]
      let T2Pos_Tol = objfetchMasterRecord[`Param${typeValue}_T2PosTol`]
      for (let data of exceptionData) {

        if (menuName == 'Hardness') {




          let tableParameters = await models.tbl_exception_samplehtd_initial.findOne({ attributes: { exclude: ['RepSerNo', 'id','isTerminated'] } })
          let whereCondition = `RepSerNo = ${data.RepSerNo} And SampleNo = '${data.RecSeqNo}' And BatchNo='${data.BatchNo}' And Repetition = '${data.Repetition}' And SFOID = '${data.SFOID}'`

          tableParameters = Object.keys(tableParameters).toString();

          var str_Query = `INSERT INTO tbl_exception_samplehtd_failed (${tableParameters},RepSerNo,isTerminated) SELECT ${tableParameters},${lastInsertedID} as RepSerNo, 1 as isTerminated FROM tbl_exception_samplehtd_initial where ${whereCondition}`

          let result = await sequelize.query(str_Query, { type: QueryTypes.INSERT })


          var deleteQuery = `delete tbl_exception_samplehtd_initial where ${whereCondition}`
          await sequelize.query(deleteQuery, { type: QueryTypes.DELETE })

          // await models.tbl_exception_samplehtd_initial.destroy({
          //   where: {
          //     RepSerNo: data.RepSerNo,
          //     SampleNo: data.RecSeqNo,
          //     BatchNo: data.BatchNo,
          //     Repetition: data.Repetition,
          //     SFOID:data.SFOID
          //   }
          // })
        } else {
          let dtMenuNameArr = [`${GLOBAL_NOMENCLATURE.DTMenu} Test`, GLOBAL_NOMENCLATURE.DTMenu]
          obj = {
            DsNo: objfetchMasterRecord.DsNo,
            TabIp: objfetchMasterRecord.TabIp,
            Remark: data.Remark,
            DataValue: menuName == GLOBAL_NOMENCLATURE.Friability ? data.NetValue : data.DataValue,
            DataValueUnit: menuName == GLOBAL_NOMENCLATURE.Friability ? '%' : data.DataValueUnit,
            RepSerNo: lastInsertedID,
            MenuName: menuName,
            ProductType: objfetchMasterRecord.ProductType,
            TypeValue: 1,
            BFGCode: objfetchMasterRecord.BFGCode,
            ProductName: data.ProductName,
            BatchNo: data.BatchNo,
            Department: objfetchMasterRecord.Department,
            SFOID: objfetchMasterRecord.SFOID,
            MachineCode: objfetchMasterRecord.MachineCode,
            PrDate: data.PrDate,
            prTime: data.PrTime,
            Side: objfetchMasterRecord.Side,
            InstrumentId: data.InstrumentID,
            T1NegTol: T2Neg_Tol,
            T1PosTol: T2Pos_Tol,
            SampleNo: data.RecSeqNo,
            Area: objfetchMasterRecord.Area,
            UserID: data.UserId,
            UserName: data.UserName,
            Repetition: objfetchMasterRecord.Repetition,
            DTRange: (dtMenuNameArr.includes(menuName)) ? objfetchMasterRecord[getLimitsObj.Nom] : 'NA',
            FriabRange: menuName == GLOBAL_NOMENCLATURE.Friability ? objfetchMasterRecord[getLimitsObj.Nom] : 'NA',
            DTRange: (dtMenuNameArr.includes(menuName)) ? objfetchMasterRecord[getLimitsObj.Nom] : 'NA',
            FriabRange: menuName == GLOBAL_NOMENCLATURE.Friability ? objfetchMasterRecord[getLimitsObj.Nom] : 'NA',
            isTerminated: isTerminated,
            CubicalName: objfetchMasterRecord.CubicleName,
            CubicalName: objfetchMasterRecord.CubicleName,
            // InstrumentType:objfetchMasterRecord.InstrumentType,
            Nominal: objfetchMasterRecord[getLimitsObj.Nom]
          }
          createExceptionData.push(obj)
        }

      }
      // let exceptionTable = 'tbl_exception_sample_initial'
      let exceptionTable = 'tbl_exception_sample_failed'
      if (objfetchMasterRecord.CubicleType == "Coating") {
        exceptionTable = "tbl_exception_sample"
      }
      await models[exceptionTable].bulkCreate(createExceptionData);
      return "success";
    } catch (err) {
      throw new Error(err)
    }
  }


}

module.exports = WeighmentDataTransfer;
