const date = require('date-and-time');

const globalData = require('../../global/globalData')
const clsActivityLog = require('../clsActivityLog.model');
const clsInstrumentUsage = require('../clsInstrumentUsageLog');
const clsCommonInsertOpt = require('../Product/clsCommonInsertOperation.model');
const clsMqttSender = require('../Mqtt/mqttSender.class');
const DataBase = require('../../database/clsQueryProcess');
const FormulaFunModel = require('../Product/clsformulaFun.model');
const mqttProtocol = require('../../global/GLOBAL_NOMENCLATURE');
const GLOBAL_NOMENCLATURE = require("../../global/GLOBAL_NOMENCLATURE");
const IncompleteReport = require('../Product/clsIncompleteReport');
const clsSaveCompleteHardness = require('../Product/clsWeighmentDataTransfer');
const clsBatchSummary = require('../Product/clsBatchSummaryOperation')
const clsGetMstSrAndSideSr = require('../Product/clsGetMstSrAndSideSr');
const clsProObj = require('../Product/clsProductDetailModel')
const clsPrintOperation = require('../Print/clsPrintOperation')
const clsIndOperation = require('../Product/clsCommonWeightment')
const clsMonit = require("../MonitorSocket/clsMonitSocket");
const cofigSetting = require("../../../../IncrencyV4DRLTSHConfig.json");
const objMonit = new clsMonit();
const objcallPrint = new clsPrintOperation()
const IndOperation = new clsIndOperation()
const moment = require('moment');
const maths = require('mathjs');
const objGetMstSrAndSideSr = new clsGetMstSrAndSideSr();
const objActivityLog = new clsActivityLog();
const objInstrumentUsage = new clsInstrumentUsage();
const objCommonInsertOpt = new clsCommonInsertOpt();
const mqttSender = new clsMqttSender();
const database = new DataBase();
const objformulaFun = new FormulaFunModel();
const objIncompleteReport = new IncompleteReport();
const objSaveCompleteHardness = new clsSaveCompleteHardness();
const objBatchSummary = new clsBatchSummary();
const proObj = new clsProObj();
const check_srNO_ = require("../Product/cls_consolidate_reportOperation");
const check_srNO = new check_srNO_();
const PowerBackup = require('../../Utills/powerBackUp/powerbackup');
const objPowerBackup = new PowerBackup();
const clsCommonUseFunction = require("../clsCommonUseFunction");
const objCommonUseFunc = new clsCommonUseFunction();
const clsCommonWeightment = require("../Product/clsCommonWeightment");
const objCommonWeightment = new clsCommonWeightment()

const models = require('../../../config/dbConnection').models;
const sequelize = require('../../../config/dbConnection').sequelize;
// const ClassweighmentData = require('../clsProcessWeighment.model');

// const objWeighmentData = new ClassweighmentData();

// const clsMonit = require('../MonitorSocket/clsMonitSocket');

// const clsPrintOperation = require('../Print/clsPrintOperation')

// const objcallPrint = new clsPrintOperation()


class HardnessModel {
    /***
     * want to check counter sometimes its going proper sometimes wrong when product get completed 425
     */
    async processHardnessDataVK200(dataObj) {
        try {
            let objActivity = {};
            // let strHmi = dataObj.Hmi;
            let strDsNo = dataObj.DsNo;
            let strTabIp = dataObj.TabIp;
            let data = dataObj.data;
            let port = dataObj.protocolPort;
            const objSelMenu = globalData.arrSelectedMenu.find((k) => k.DsNo == strDsNo && k.TabIp == strTabIp);
            let BLName = objSelMenu.selectedProductDetail.arrHardnessColumn.filter(item => item == 'Length' || item == 'Breadth')[0]
            let HDdata = objSelMenu.selectedProductDetail.arrHardnessColumnDetail.filter(obj => Object.keys(obj) == 'Hardness')[0].Hardness;
            let Thickdata = objSelMenu.selectedProductDetail.arrHardnessColumnDetail.filter(obj => Object.keys(obj) == 'Thickness')[0].Thickness;
            let BLData = objSelMenu.selectedProductDetail.arrHardnessColumnDetail.filter(obj => Object.keys(obj) == BLName)[0] ? objSelMenu.selectedProductDetail.arrHardnessColumnDetail.filter(obj => Object.keys(obj) == BLName)[0][BLName] : undefined;
            let HDsamples = HDdata.noOfSamples
            let Thicksamples = Thickdata.noOfSamples
            let sample = HDsamples > Thicksamples ? Thicksamples : HDsamples;
            let hdp = HDdata.dp
            let Tdp = Thickdata.dp
            let Ldp = BLData?.dp ?? 0
            let T2PosHD = Number(HDdata.T2Pos).toFixed(3)
            let T2NegHD = Number(HDdata.T2Neg).toFixed(3)
            let T2PosTH = Number(Thickdata.T2Pos).toFixed(3)
            let T2NegTH = Number(Thickdata.T2Neg).toFixed(3)
            let T2NegBL = BLData ? Number(BLData.T2Neg).toFixed(3) : null
            let T2PosBL = BLData ? Number(BLData.T2Pos).toFixed(3) : null
            let color = `white`
            let unit = HDdata.Unit;
            let isftp = false;

            let tempUserObject = globalData.arrUsers.find((k) => k.DsNo == strDsNo && k.TabIp == strTabIp);
            let cubicObj = globalData.arrIdsInfo.find(k => k.DsNo == strDsNo).cubicalData;
            let cubicalInfo = globalData.arrIdsInfo.find(k => k.DsNo == strDsNo)

            let getTableName = objCommonWeightment.getTableName(cubicObj, 'Hardness', strDsNo, strTabIp)

            var strTableName = getTableName.masterTable
            var strDetailTbl = getTableName.detailTable
            var typeValue = 7;
            let sideStatus;
            let RecNo = 0

            // Here change the decimal point according to the unite receive
            hdp = (((unit.toLowerCase() == "kp") || (unit.toLowerCase() == "sc")) && objSelMenu.Model == 'TBH 425 TD') ? 2 : hdp
            Tdp = ((unit.toLowerCase() == "sc") && objSelMenu.Model == 'TBH 425 TD') ? 3 : Tdp

            if (objSelMenu.Side === "LHS") sideStatus = 0
            else if (objSelMenu.Side === "RHS") sideStatus = 1
            else sideStatus = 2
            // let selectedIdsNo;
            // var IPQCObject = globalData.arr_IPQCRelIds.find(
            // (k) =>k.DsNo == strDsNo && k.TabIp == strTabIp
            // );
            // if (IPQCObject != undefined) {
            // selectedIdsNo = IPQCObject.selectedIds;
            // } else {
            // selectedIdsNo = strDsNo;
            // }


            let exceptionTableName = 'tbl_exception_samplehtd_initial';
            let hmiDetailsInPMenu = globalData.arrIdsInfo.find(
                (k) => k.DsNo == strDsNo
            ).cubicalData;

            const __parameterHardness = {
                strTableName: strTableName,
                strDetailTbl: strDetailTbl,
                TabIp: strTabIp,
                ProtocolData: dataObj.data,
                strDsNo: strDsNo,
                objProductDetails: objSelMenu,
                SFOID: objSelMenu.SFOID,
                RHSContainerNo: objSelMenu.RHSContainerNo,
                LHSContainerNo: objSelMenu.LHSContainerNo,
            };

            var powerBackup = await models.tbl_powerbackup.findAll({
                where: {
                    Sys_CubType: hmiDetailsInPMenu.Sys_CubType,
                    Sys_BFGCode: hmiDetailsInPMenu.Sys_BFGCode,
                    Sys_Batch: hmiDetailsInPMenu.Sys_Batch,
                    MPN_Code: objSelMenu.MPN,
                    DsNo: strDsNo,
                    TabIp: strTabIp,
                    WeighmentName: objSelMenu.menuName,
                    Before_Count: sideStatus
                },
            });

            var counter;

            if (powerBackup.length == 0) {
                counter = 1;
            } else {
                counter = powerBackup[0].RecSampleNo;
            }

            let InstrumentData = await models.tbl_otherequipment.findOne({
                where: {
                    Eqp_ID: objSelMenu.instrumentId
                }
            })

            // if (Number(sample) < counter) return mqttSender.sendData(strDsNo, `Port ${port}:${mqttProtocol.DisplayResult}: samples received more than expected`);

            var repSerNo;
            if (sample >= counter) {
                // let mesArr = globalData.MESArray.filter(k => k.DsNo == strDsNo && k.TabIp == strTabIp && k.menuName == mqttProtocol.HardnessMenu && k.isCompleted == false)
                // console.log(mesArr)

                let selectedDSNo = strDsNo;
                let arrIPQC = globalData.arr_IPQCRelIds.find(k => k.DsNo == strDsNo && k.tabIp == strTabIp);
                if (arrIPQC != undefined) {
                    selectedDSNo = arrIPQC.selectedDs.dsNo
                    // selectedBatch = arrIPQC.selectedDs.batch
                }

                // if (hmiDetailsInPMenu.isManual == 0) {
                //     if (mesArr.length == 0) {
                //         let data = {
                //             menuName: objSelMenu.menuName,
                //             DsNo: strDsNo,
                //             selectedDSNo: selectedDSNo,
                //             TabIp: strTabIp,
                //             payload: [],
                //             portNo: port,
                //             isCompleted: false,
                //             Area: cubicObj.Sys_Area

                //         }

                //         globalData.MESArray.push(data)

                //     }

                //     // mesArr = globalData.MESArray.filter(k => k.DsNo == strDsNo && k.TabIp == strTabIp && k.menuName == mqttProtocol.HardnessMenu && k.isCompleted == false)
                // }



                if (counter == 1 && powerBackup.length == 0) {
                    __parameterHardness.strHardnessUnit = unit == undefined ? 'kp' : unit;

                    repSerNo = await this.saveDataIncompleteMasterHardnessVK200(
                        __parameterHardness
                    );

                    Object.assign(
                        objActivity,
                        { strUserId: tempUserObject.UserId },
                        { strUserName: tempUserObject.UserName },
                        { batch: hmiDetailsInPMenu.Sys_Batch },
                        { activity: "Hardness Test Started on DS " + strDsNo }
                    );

                    await objActivityLog.ActivityLogEntry(objActivity);


                    await objInstrumentUsage.InstrumentUsage(
                        "Hardness",
                        strDsNo,
                        "tbl_instrumentlog_hardness",
                        "Hardness",
                        "started",
                        strTabIp,
                        tempUserObject,
                        cubicalInfo
                    );

                    var pwbEntry = await models.tbl_powerbackup.create({
                        Sys_CubType: hmiDetailsInPMenu.Sys_CubType,
                        Sys_BFGCode: hmiDetailsInPMenu.Sys_BFGCode,
                        Sys_Batch: hmiDetailsInPMenu.Sys_Batch,
                        CubicalNo: hmiDetailsInPMenu.Sys_CubicNo,
                        DsNo: strDsNo,
                        TabIp: strTabIp,
                        WeighmentName: objSelMenu.menuName,
                        Incomp_RepSerNo: repSerNo,
                        Before_Count: sideStatus,
                        ReportType: hmiDetailsInPMenu.Sys_RptType,
                        Userid: tempUserObject.UserId,
                        WeighmentType: 7,
                        ProductType: 1,
                        MPN_Code: objSelMenu.MPN
                    });

                    console.log(pwbEntry)

                } else {
                    repSerNo = powerBackup[0].Incomp_RepSerNo;


                }

                for (let ele of data) {
                    color = 'White'
                    RecNo = await this.calculatedCounter(repSerNo, objSelMenu.Side, getTableName.detailTableIncomplete, isftp, cubicObj)
                    // RecNo = counter
                    let limitMsg = ''
                    let isOutOfLimit = false
                    var Outoflimit3 = {}
                    let outFlag = false
                    let Outoflimit1 = await objCommonUseFunc.SendCommon1({ dsNo: strDsNo, actualWt: ele.H, minLimitT2: T2NegHD, maxLimitT2: T2PosHD, minLimitT1: undefined, maxLimitT1: undefined, strMenuName: mqttProtocol.HardnessMenu, sampleNo: counter, tabIp: strTabIp })
                    let Outoflimit2 = await objCommonUseFunc.SendCommon1({ dsNo: strDsNo, actualWt: ele.T, minLimitT2: T2NegTH, maxLimitT2: T2PosTH, minLimitT1: undefined, maxLimitT1: undefined, strMenuName: mqttProtocol.HardnessMenu, sampleNo: counter, tabIp: strTabIp })
                    if (InstrumentData.Eqp_Model == 'TBH425') {
                        Outoflimit3 = await objCommonUseFunc.SendCommon1({ dsNo: strDsNo, actualWt: ele.D.value, minLimitT2: T2NegBL, maxLimitT2: T2PosBL, minLimitT1: undefined, maxLimitT1: undefined, strMenuName: mqttProtocol.HardnessMenu, sampleNo: counter, tabIp: strTabIp })
                    } else {
                        Outoflimit3.limit = 'DisplayMessage:Within Limit'
                    }
                    if (!(Outoflimit1.limit.includes('Within')) || !(Outoflimit2.limit.includes('Within')) || !(Outoflimit3.limit.includes('Within'))) {
                        let hardValue = ((Outoflimit1.limit.includes('Within'))) ? 99999 : parseFloat(ele.H).toFixed(1);
                        let thickValue = ((Outoflimit2.limit.includes('Within'))) ? 99999 : maths.round(ele.T, Tdp).toFixed(Tdp)
                        limitMsg = (!Outoflimit2.limit.includes('Within')) ? Outoflimit2.limit : Outoflimit1.limit
                        await models[exceptionTableName].create({
                            RepSerNo: repSerNo,
                            IDSNo: strDsNo,
                            // MstSerNo: 1,
                            DataValueThick: thickValue,
                            DataValueHard: hardValue,
                            DataValueBL: ele.tempDiamVal,
                            T1PosTolHard: T2PosHD,
                            T1NegTolHard: T2NegHD,
                            T1PosTolThick: T2PosTH,
                            T1NegTolThick: T2NegTH,
                            T1PosTolBL: T2PosBL,
                            T1NegTolBL: T2NegBL,
                            Repetition: objSelMenu.repetition,
                            MenuName: dataObj.menuName,
                            HardUnit: unit,
                            ThickUnit: 'mm',
                            BLUnit: 'mm',
                            DsNo: strDsNo,
                            TabIp: strTabIp,
                            BLName: BLName,
                            // TestDate: moment().format("YYYY-MM-DD"),
                            SFOID: objSelMenu.SFOID,
                            Area: hmiDetailsInPMenu.Sys_Area,
                            Area: hmiDetailsInPMenu.Sys_Area,
                            BFGCode: hmiDetailsInPMenu.Sys_BFGCode,
                            BatchNo: hmiDetailsInPMenu.Sys_Batch,
                            ProductName: hmiDetailsInPMenu.Sys_ProductName,
                            MachineCode: objSelMenu.EquipmentCode,
                            InstrumentId: objSelMenu.instrumentId,
                            ProductType: 1,
                            UserID: tempUserObject.UserId,
                            UserName: tempUserObject.UserName,
                            Side: objSelMenu.Side,
                            SampleNo: RecNo,
                            isTerminated: 0,
                            typeValue: 7,
                            PrDate: moment().format("YYYY-MM-DD"),
                            prTime: moment().format("HH:mm:ss"),
                            CubicalName: hmiDetailsInPMenu.Sys_CubicName,
                            HardNom: HDdata?.Nom,
                            ThickNom: Thickdata?.Nom
                        })



                        outFlag = true
                        color = Outoflimit1.Color != 'White' ? Outoflimit1.Color : (Outoflimit2.Color != 'White' ? Outoflimit2.Color : `Orange`)
                        if (cubicObj.isPreStart == 1) counter += 1

                    } else {
                        counter = counter + 1;





                    }

                    await models[getTableName.detailTableIncomplete].create({

                        RepSerNo: repSerNo,
                        MstSerNo: 1,
                        RecSeqNo: RecNo,
                        // RecNo: RecNo,
                        DataValueThick: maths.round(ele.T, Tdp).toFixed(Tdp),
                        DataValueHard: maths.round(ele.H, hdp).toFixed(hdp),
                        DataValueBL: maths.round(ele.H, Ldp).toFixed(Ldp) == NaN ? ele.tempDiamVal : maths.round(ele.H, Ldp).toFixed(Ldp),
                        DataValueDiam: 0,
                        DecimalPointThick: this.precision(Number(ele.T)),
                        DecimalPointDOLOBO: this.precision(Number(ele.D)),
                        DecimalPointHard: this.precision(Number(ele.H)),
                        DsNo: strDsNo,
                        TabIp: strTabIp,
                        isException: outFlag ? 1 : 0,
                        Side: objSelMenu.Side,
                        BatchNo: hmiDetailsInPMenu.Sys_Batch,
                        SFOID: objSelMenu.SFOID,
                        Repetition: hmiDetailsInPMenu.Sys_Repetition
                    });

                    await models.tbl_powerbackup.update(
                        {
                            RecSampleNo: counter,
                            isException: outFlag ? 1 : 0,
                        },
                        {
                            where: {
                                DsNo: strDsNo,
                                WeighmentName: objSelMenu.menuName,
                                Before_Count: sideStatus,
                                Incomp_RepSerNo: repSerNo,
                                ReportType: cubicObj.Sys_RptType
                            }
                        }
                    );

                    if (InstrumentData.Eqp_Model == 'TBH425') {
                        mqttSender.sendData(
                            strDsNo,
                            `Port ${port}:${mqttProtocol.DisplayResult}${RecNo}:${(maths.round(ele.H, hdp).toFixed(hdp))} ${unit}:${(maths.round(ele.T, Tdp).toFixed(Tdp))} mm:${(maths.round(ele.D, Ldp).toFixed(Ldp))} mm:${color}`
                        );
                    } else {
                        mqttSender.sendData(
                            strDsNo,
                            `Port ${port}:${mqttProtocol.DisplayResult}${RecNo}:${(maths.round(ele.H, hdp).toFixed(hdp))} ${unit}:${(maths.round(ele.T, Tdp).toFixed(Tdp))} ${Thickdata.Unit}:${`NA`} mm:${color}`
                        );
                    }

                    // hardness Mes Data
                    //   {
                    //   menuName: 'Hardness',
                    //   payload: [{hardnessdata: { value: "", isMesChecked: false }, thicknessData: { value: "", isMesChecked: false },  }],
                    //   dsNo: '',
                    //   tabIp: '',
                    //   portNo: '',
                    //   isCompleted: false, 
                    //   RepSerNo: ''
                    // }

                    // outFlag ? null : hmiDetailsInPMenu.isManual ? null : mesArr[0].payload.push({ hardnessdata: { value: maths.round(ele.H, hdp).toFixed(hdp), isMesChecked: false }, thicknessData: { value: maths.round(ele.T, Tdp).toFixed(Tdp), isMesChecked: false }, })

                    outFlag ? mqttSender.sendData(strDsNo, `Port ${port}:${limitMsg}`) : null

                    // console.log(mesArr[0])
                    if ((sample + 1) == counter) break;
                }

                if ((sample + 1) == counter) {
                    var detailData = await models[getTableName.detailTableIncomplete].findAll({ where: { RepSerNo: repSerNo, isException: 0, isTerminated: 0 } });
                    var result_ = await this.calculation(detailData, unit, InstrumentData.Eqp_Make, cubicObj.Sys_RptType)
                    let endTime = moment().format('HH:mm:ss');
                    let updateEndTimeAndRemObj = {
                        // Param7_PrEndTime: endTime,
                        // Param7_PrEndDate: moment().format('YYYY-MM-DD'),
                        PrEndDate: moment().format('YYYY-MM-DD'),
                        PrEndTime: endTime,
                        Param7_Remark: 'Within Limit',
                        Param3_Remark: 'Within Limit'
                    }

                    await models.tbl_tab_initialmaster_incomplete.update(updateEndTimeAndRemObj, {
                        where: {
                            RepSerNo: repSerNo
                        }
                    })
                    await this.updatemasterTable(repSerNo, powerBackup, strDsNo, strTabIp, getTableName, objSelMenu.isftp, result_);

                    // let sideStatus;
                    // if (__parameterHardness.objProductDetails.Side === "LHS") sideStatus = 0
                    // else if (__parameterHardness.objProductDetails.Side === "RHS") sideStatus = 1

                    // if (!cubicObj.Sys_RptType) {

                    //     let result = await objIncompleteReport.getIncompleteData(
                    //         __parameterHardness,
                    //         strTableName,
                    //         strDetailTbl,
                    //         strDsNo,
                    //         strTabIp,
                    //         cubicObj,
                    //         sideStatus
                    //     );

                    //     let completeResponse = await objSaveCompleteHardness.saveCommonDataToCompleteHardness(
                    //         result,
                    //         typeValue,
                    //         strDsNo,
                    //         strTabIp
                    //     );

                    //     await this.updateEndDate(strDsNo, strTableName, completeResponse.RepSerNo);

                    //     // await objBatchSummary.saveBatchDataHardness(
                    //     //     result.incompleteData,
                    //     //     result.detailData,
                    //     //     strDsNo
                    //     // );

                    //     hmiDetailsInPMenu.isManual ? null : (mesArr[0].isCompleted = true, mesArr[0].RepSerNo = completeResponse.RepSerNo)
                    //     console.log(mesArr)
                    // } else {
                    // if (sideStatus == 1 || sideStatus == 2) {
                    let finalRemark = (cubicObj.isManual == 1 && cubicObj.isPreStart == 1 && cofigSetting.plant == "PUI") ? 'Test Completed' : 'Report Within Limit';
                    var count = await objCommonInsertOpt.updateMenuSequenceEntry(strDsNo, strTabIp, "Hardness", repSerNo, getTableName.masterTableIncomplete, getTableName.masterTable, cubicObj, port, 'NA', 'NA', finalRemark);


                    // hmiDetailsInPMenu.isManual ? null : (mesArr[0].isCompleted = true, mesArr[0].RepSerNo = completeResponse.RepSerNo)
                    // }
                    // }


                    // const objUpdateValidation = await models.tbl_cubical.update({
                    // 'Sys_Validation': 0
                    // }, {
                    // where: {
                    //     'Sys_rpi': cubicObj.Sys_rpi
                    // }
                    // });




                    await models.tbl_powerbackup.destroy({
                        where: {
                            DsNo: strDsNo,
                            WeighmentName: objSelMenu.menuName,
                            TabIp: strTabIp,
                            ReportType: cubicObj.Sys_RptType
                        },
                    });

                    Object.assign(
                        objActivity,
                        { strUserId: tempUserObject.UserId },
                        { strUserName: tempUserObject.UserName },
                        { batch: hmiDetailsInPMenu.Sys_Batch },
                        { activity: "Hardness Test Completed on DS " + strDsNo }
                    );

                    await objActivityLog.ActivityLogEntry(objActivity);

                    await objInstrumentUsage.InstrumentUsage(
                        "Hardness",
                        strDsNo,
                        "tbl_instrumentlog_hardness",
                        "Hardness",
                        "completed",
                        strTabIp,
                        tempUserObject,
                        cubicalInfo
                    );


                    globalData.arrCurrentOperationStatus.findIndex(
                        (element) => element.DsNo === strDsNo
                    ) == -1
                        ? globalData.arrCurrentOperationStatus
                        : globalData.arrCurrentOperationStatus.splice(
                            globalData.arrCurrentOperationStatus.findIndex(
                                (element) => element.DsNo === strDsNo
                            ),
                            1
                        );

                    globalData.arrSelectedMenu.findIndex((k) => k.DsNo == strDsNo && k.TabIp == strTabIp) == -1
                        ? globalData.arrSelectedMenu
                        : globalData.arrSelectedMenu.splice(
                            globalData.arrSelectedMenu.findIndex((k) => k.DsNo == strDsNo && k.TabIp == strTabIp),
                            1
                        );

                    // if (cubicObj.Sys_RptType == 0) {
                    // mqttSender.sendData(strDsNo, `Port ${port}:${mqttProtocol.TestCompleted}Test Completed`);

                    // if (cubicObj.isManual == 0) {
                    //     if (!cubicObj.Sys_RptType) {
                    //         mqttSender.sendData(strDsNo, `Port ${port}:${mqttProtocol.DisplayMessage} ${mqttProtocol.PostingToMES}`)
                    //     } else if (count == 0) {
                    //         mqttSender.sendData(strDsNo, `Port ${port}:${mqttProtocol.DisplayMessage} ${mqttProtocol.PostingToMES}`)
                    //     }
                    // }

                    // if (__parameterHardness.objProductDetails.Side === "LHS" &&
                    //     hmiDetailsInPMenu.Sys_RotaryType === "Double") {
                    //     setTimeout(() => {
                    //         mqttSender.sendData(strDsNo, `Port ${port}:${mqttProtocol.DisplayMessage}Side Changes to RHS`);
                    //     }, 1000)

                    // }
                    // }
                    return
                }
            }
        } catch (error) {
            throw new Error(error);
        }


    }

    async processHardnessDataFTP(dataObj) {
        try {
            let objActivity = {};
            // let strHmi = dataObj.Hmi;
            let strDsNo = dataObj.DsNo;
            let strTabIp = dataObj.TabIp;
            let data = dataObj.data;
            let port = dataObj.protocolPort;
            const objSelMenu = globalData.arrSelectedMenu.find((k) => k.DsNo == strDsNo && k.TabIp == strTabIp);
            var Indidata = globalData.arr_limits.find((k) => k.DsNo == strDsNo && k.TabIp == strTabIp);
            var decimalrange = this.getUnitObj(GLOBAL_NOMENCLATURE.ThicknessMenu)
            let BLName = objSelMenu.selectedProductDetail.arrHardnessColumn.filter(item => item == 'Length' || item == 'Breadth')[0]

            // const HardnessDetail = globalData.arrWeighmentProductData.find(
            // (k) => k.DsNo == strDsNo && k.TabIp == strTabIp
            // );
            // let HDsamples = Number(HardnessDetail.data.columnDetail.filter(obj=>Object.keys(obj)=='Hardness')[0].Hardness.noOfSamples);
            // let Thicksamples = Number(HardnessDetail.data.columnDetail.filter(obj=>Object.keys(obj)=='Thickness')[0].Thickness.noOfSamples);
            let HDdata = objSelMenu.selectedProductDetail.arrHardnessColumnDetail.filter(obj => Object.keys(obj) == 'Hardness')[0].Hardness;
            let Thickdata = objSelMenu.selectedProductDetail.arrHardnessColumnDetail.filter(obj => Object.keys(obj) == 'Thickness')[0].Thickness;
            var BLData = objSelMenu.selectedProductDetail.arrHardnessColumnDetail.filter(obj => Object.keys(obj) == BLName)[0] ? objSelMenu.selectedProductDetail.arrHardnessColumnDetail.filter(obj => Object.keys(obj) == BLName)[0][BLName] : undefined;
            if (Indidata != undefined) {
                BLData = Indidata.Menus.Individual
            }
            let HDsamples = HDdata.noOfSamples
            let Thicksamples = Thickdata.noOfSamples
            let sample = HDsamples > Thicksamples ? Thicksamples : HDsamples;
            let hdp = HDdata.dp
            let Tdp = Thickdata.dp

            let hardNom = HDdata.Nom;

            let thickNom = Number(Thickdata.Nom).toFixed(decimalrange.target);
            let T2PosHD = Number(HDdata.T2Pos).toFixed(decimalrange.target)
            let T2NegHD = Number(HDdata.T2Neg).toFixed(decimalrange.target)
            let T2PosTH = Number(Thickdata.T2Pos).toFixed(decimalrange.target)
            let T2NegTH = Number(Thickdata.T2Neg).toFixed(decimalrange.target)
            var Bdp, indNom, T2NegBL, T2PosBL, Bunit
            if (BLData != undefined) {
                Bdp = BLData.dp
                indNom = Number(BLData.Nom).toFixed(decimalrange.target);
                T2NegBL = Number(BLData).toFixed(decimalrange.target) ? Number(BLData.T2Neg).toFixed(decimalrange.target) : null
                T2PosBL = Number(BLData).toFixed(decimalrange.target) ? Number(BLData.T2Pos).toFixed(decimalrange.target) : null
                Bunit = BLData.Unit;
            } else {
                Bdp = null
                indNom = null
                T2NegBL = null
                T2PosBL = null
                Bunit = null
            }
            let color = `white`
            let unit = HDdata.Unit;
            let isftp = true;
            let mesData = [];
            let sideStatus

            let tempUserObject = globalData.arrUsers.find((k) => k.DsNo == strDsNo && k.TabIp == strTabIp);
            let cubicObj = globalData.arrIdsInfo.find(k => k.DsNo == strDsNo).cubicalData;
            let cubicalInfo = globalData.arrIdsInfo.find(k => k.DsNo == strDsNo)

            let getTableName = objCommonWeightment.getTableName(cubicObj, 'Hardness', strDsNo, strTabIp)

            var strTableName = getTableName.masterTable
            var strDetailTbl = getTableName.detailTable
            if (objSelMenu.Side === "LHS") sideStatus = 0
            else if (objSelMenu.Side === "RHS") sideStatus = 1
            else sideStatus = 2

            let exceptionTableName = 'tbl_exception_samplehtd_initial';
            let hmiDetailsInPMenu = globalData.arrIdsInfo.find(
                (k) => k.DsNo == strDsNo
            ).cubicalData;

            const __parameterHardness = {
                strTableName: strTableName,
                strDetailTbl: strDetailTbl,
                TabIp: strTabIp,
                ProtocolData: dataObj.data,
                strDsNo: strDsNo,
                objProductDetails: objSelMenu,
                SFOID: objSelMenu.SFOID,
                cal_data: dataObj.cal_data,
                LHSContainerNo: objSelMenu.LHSContainerNo,
                RHSContainerNo: objSelMenu.RHSContainerNo
            };
            var counter = 1;
            var InstrumentData = await models.tbl_otherequipment.findOne({
                where: {
                    Eqp_ID: objSelMenu.instrumentId
                }
            })
            var repSerNo;
            var getTableName_;
            let activity_msg
            var activity_menu
            // this if multitester fetch individual table.
            if (InstrumentData.Eqp_Make == 'Pharmatest' && hmiDetailsInPMenu.Sys_RptType == 0) {
                getTableName_ = objCommonWeightment.getTableName(cubicObj, 'Individual', strDsNo, strTabIp)
                activity_msg = `Individual, Thickness & Hardness Test Started on DS ${strDsNo}`
                activity_msg = (objSelMenu.Side == "NA") ? activity_msg : `${activity_msg} for side ${objSelMenu.Side}`;
                activity_menu = 'Individual, Thickness & Hardness'
            } else {
                activity_msg = `Thickness & Hardness Test Started on DS ${strDsNo}`
                activity_msg = (objSelMenu.Side == "NA") ? activity_msg : `${activity_msg} for side ${objSelMenu.Side}`;
                activity_menu = 'Thickness & Hardness'
            }
            if (sample >= counter) {
                if (counter == 1) {
                    __parameterHardness.strHardnessUnit = unit == undefined ? 'kp' : unit;
                    repSerNo = await this.saveDataIncompleteMasterHardnessVK200(__parameterHardness);
                    Object.assign(
                        objActivity,
                        { strUserId: tempUserObject.UserId },
                        { strUserName: tempUserObject.UserName },
                        { batch: hmiDetailsInPMenu.Sys_Batch },
                        { activity: activity_msg }
                    );

                    await objActivityLog.ActivityLogEntry(objActivity);


                    await objInstrumentUsage.InstrumentUsage(
                        // "Hardness",
                        GLOBAL_NOMENCLATURE.MultiTester,
                        strDsNo,
                        "tbl_instrumentlog_hardness",
                        activity_menu,
                        "started",
                        strTabIp,
                        tempUserObject,
                        cubicalInfo
                    );
                }

                let outFlag = false
                let outOfValueCount = 0;
                let newSampleCount = 0;
                var RecNo_ = 0
                let RecNo;
                var powerbackupexception = false
                var within_counter = 0
                for (let ele of data) {
                    let isOutOfLimit = false
                    var Outoflimit3 = {}
                    color = 'White'
                    RecNo_ += 1;

                    RecNo = await this.calculatedCounter(repSerNo, objSelMenu.Side, getTableName.detailTableIncomplete, isftp, cubicObj)

                    if (RecNo - 1 == sample) break

                    let Outoflimit1 = await objCommonUseFunc.SendCommon1({ dsNo: strDsNo, actualWt: ele.H.value, minLimitT2: T2NegHD, maxLimitT2: T2PosHD, minLimitT1: undefined, maxLimitT1: undefined, strMenuName: mqttProtocol.HardnessMenu, sampleNo: counter, tabIp: strTabIp })
                    let Outoflimit2 = await objCommonUseFunc.SendCommon1({ dsNo: strDsNo, actualWt: ele.T.value, minLimitT2: T2NegTH, maxLimitT2: T2PosTH, minLimitT1: undefined, maxLimitT1: undefined, strMenuName: mqttProtocol.HardnessMenu, sampleNo: counter, tabIp: strTabIp })
                    if (hmiDetailsInPMenu.Sys_RptType == 0) {
                        ele.W.value = ele.W.value / 1000
                        Outoflimit3 = await objCommonUseFunc.SendCommon1({ dsNo: strDsNo, actualWt: ele.W.value, minLimitT2: T2NegBL, maxLimitT2: T2PosBL, minLimitT1: undefined, maxLimitT1: undefined, strMenuName: mqttProtocol.HardnessMenu, sampleNo: counter, tabIp: strTabIp })
                    } else {
                        Outoflimit3.limit = 'DisplayMessage:Within Limit'
                    }
                    if (!(Outoflimit1.limit.includes('Within')) || !(Outoflimit2.limit.includes('Within')) || !(Outoflimit3.limit.includes('Within'))) {
                        if (InstrumentData.Eqp_Make == 'Pharmatest' && hmiDetailsInPMenu.Sys_RptType == 0 && !(Outoflimit3.limit.includes('Within'))) {
                            await models.tbl_exception_sample_initial.create({
                                RepSerNo: repSerNo,
                                IDSNo: strDsNo,
                                // MstSerNo: 1,
                                DataValue: maths.round(ele.W.value, Bdp).toFixed(Bdp),
                                T1PosTol: T2PosBL,
                                T1NegTol: T2NegBL,
                                Repetition: objSelMenu.repetition,
                                // MenuName: GLOBAL_NOMENCLATURE.MultiTester,
                                DataValueUnit: Bunit,
                                DsNo: strDsNo,
                                TabIp: strTabIp,
                                MenuName: GLOBAL_NOMENCLATURE.IndividualMenu,
                                // TestDate: moment().format("YYYY-MM-DD"),
                                SFOID: objSelMenu.SFOID,
                                Area: hmiDetailsInPMenu.Sys_Area,
                                CubicalName: hmiDetailsInPMenu.Sys_CubicName,
                                BFGCode: hmiDetailsInPMenu.Sys_BFGCode,
                                BatchNo: hmiDetailsInPMenu.Sys_Batch,
                                ProductName: hmiDetailsInPMenu.Sys_ProductName,
                                MachineCode: objSelMenu.EquipmentCode,
                                InstrumentId: objSelMenu.instrumentId,
                                ProductType: 1,
                                UserID: tempUserObject.UserId,
                                UserName: tempUserObject.UserName,
                                Side: objSelMenu.Side,
                                SampleNo: RecNo_,
                                TypeValue: 1,
                                Remark: 'NA',
                                PrDate: moment().format("YYYY-MM-DD"),
                                prTime: moment().format("HH:mm:ss"),
                                isTerminated: 0,
                                Nominal: indNom
                            })
                        }

                        let hardValue = ((Outoflimit1.limit.includes('Within'))) ? 99999 : maths.round(ele.H.value, hdp).toFixed(hdp)
                        let thickValue = ((Outoflimit2.limit.includes('Within'))) ? 99999 : maths.round(ele.T.value, Tdp).toFixed(Tdp)
                        let indValue = 99999;
                        if (InstrumentData.Eqp_Make == 'Pharmatest' && hmiDetailsInPMenu.Sys_RptType == 0) {
                            indValue = ((Outoflimit3.limit.includes('Within'))) ? 99999 : maths.round(ele.W.value, Bdp).toFixed(Bdp)
                        }

                        await models[exceptionTableName].create({
                            RepSerNo: repSerNo,
                            IDSNo: strDsNo,
                            // MstSerNo: 1,
                            DataValueThick: thickValue,
                            DataValueHard: hardValue,
                            DataValueBL: indValue,
                            T1PosTolHard: T2PosHD,
                            T1NegTolHard: T2NegHD,
                            T1PosTolThick: T2PosTH,
                            T1NegTolThick: T2NegTH,
                            T1PosTolBL: T2PosBL,
                            T1NegTolBL: T2NegBL,
                            Repetition: objSelMenu.repetition,
                            MenuName: GLOBAL_NOMENCLATURE.MultiTester,
                            HardUnit: unit,
                            ThickUnit: 'mm',
                            BLUnit: Bunit == undefined ? 'g' : Bunit,
                            DsNo: strDsNo,
                            TabIp: strTabIp,
                            BLName: BLName,
                            TypeValue: 7,
                            // TestDate: moment().format("YYYY-MM-DD"),
                            CubicalName: hmiDetailsInPMenu.Sys_CubicName,
                            SFOID: objSelMenu.SFOID,
                            Area: hmiDetailsInPMenu.Sys_Area,
                            Area: hmiDetailsInPMenu.Sys_Area,
                            BFGCode: hmiDetailsInPMenu.Sys_BFGCode,
                            BatchNo: hmiDetailsInPMenu.Sys_Batch,
                            ProductName: hmiDetailsInPMenu.Sys_ProductName,
                            MachineCode: objSelMenu.EquipmentCode,
                            InstrumentId: objSelMenu.instrumentId,
                            ProductType: 1,
                            UserID: tempUserObject.UserId,
                            UserName: tempUserObject.UserName,
                            Side: objSelMenu.Side,
                            SampleNo: RecNo_,
                            Remark: 'NA',
                            PrDate: moment().format("YYYY-MM-DD"),
                            prTime: moment().format("HH:mm:ss"),
                            isTerminated: 0,
                            HardNom: Number(hardNom).toFixed(decimalrange.target),
                            ThickNom: Number(thickNom).toFixed(decimalrange.target),
                            BLNom: Number(indNom).toFixed(decimalrange.target)
                        })
                        isOutOfLimit = true;
                        outFlag = true
                        color = Outoflimit1.Color != 'White' ? Outoflimit1.Color : (Outoflimit2.Color != 'White' ? Outoflimit2.Color : `Orange`)
                        outOfValueCount = outOfValueCount + 1
                        // sample = sample + 1;
                        if (outFlag) {
                            let limit = 'Out Of Limit';
                            if (outOfValueCount == 1) {
                                mqttSender.sendData(strDsNo, `Port ${port}:${mqttProtocol.DisplayMessage}${limit}`);
                            }

                            setTimeout(() => { }, 1000)
                        }
                    } else {
                        isOutOfLimit = false
                    }

                    if ((Outoflimit1.limit.includes('Within')) && (Outoflimit2.limit.includes('Within')) && (Outoflimit3.limit.includes('Within'))) {
                        if (within_counter < sample) {
                            await models[getTableName.detailTableIncomplete].create({

                                RepSerNo: repSerNo,
                                MstSerNo: 1,
                                RecSeqNo: RecNo,
                                // RecNo: RecNo,
                                DataValueThick: maths.round(ele.T.value, Tdp).toFixed(Tdp),
                                DataValueHard: maths.round(ele.H.value, hdp).toFixed(hdp),
                                DataValueBL: maths.round(ele.W.value, Bdp).toFixed(Bdp),
                                DataValueDiam: 0,
                                DecimalPointThick: this.precision(Number(ele.T.value)),
                                DecimalPointDOLOBO: this.precision(Number(ele.W.value)),
                                DecimalPointHard: this.precision(Number(ele.H.value)),
                                DsNo: strDsNo,
                                TabIp: strTabIp,
                                isException: isOutOfLimit ? 1 : 0,
                                Side: objSelMenu.Side,
                            });
                            // if (InstrumentData.Eqp_Make == 'Pharmatest' && hmiDetailsInPMenu.Sys_RptType == 0) {
                            if (InstrumentData.Eqp_Make == 'Pharmatest' && hmiDetailsInPMenu.Sys_RptType == 0) {
                                const insertDetail = await models[getTableName_.detailTableIncomplete].create({
                                    RepSerNo: repSerNo,
                                    MstSerNo: 1,
                                    RecSeqNo: RecNo,
                                    DataValue: maths.round(ele.W.value, Bdp).toFixed(Bdp),
                                    DataValueUnit: Bunit == undefined ? 'g' : Bunit,
                                    DP: Bdp,
                                    UserID: tempUserObject.UserId,
                                    UserName: tempUserObject.UserName,
                                    Side: objSelMenu.Side,
                                    PrDate: moment().format("YYYY-MM-DD"),
                                    PrTime: moment().format("HH:mm:ss"),
                                    PrEndDate: moment().format("YYYY-MM-DD"),
                                    PrEndTime: moment().format("HH:mm:ss"),
                                    BFGCode: "NA",
                                    ProductName: cubicObj.Sys_ProductName,
                                    PVersion: cubicObj.Sys_PVersion,
                                    Version: cubicObj.Sys_Version,
                                    BatchNo: cubicObj.Sys_Batch,
                                    BalanceId: cubicObj.Sys_BalID,
                                    isException: isOutOfLimit ? 1 : 0,
                                });
                            }
                            within_counter = within_counter + 1
                            mesData.push(ele)
                        }
                    }

                    if (InstrumentData.Eqp_Make == 'Pharmatest' && hmiDetailsInPMenu.Sys_RptType == 0) {
                        mqttSender.sendData(
                            strDsNo,
                            `Port ${port}:${mqttProtocol.DisplayResult}${RecNo}:${(maths.round(ele.W.value, Bdp).toFixed(Bdp))} ${Bunit}:${(maths.round(ele.H.value, hdp).toFixed(hdp))} ${unit}:${(maths.round(ele.T.value, Tdp).toFixed(Tdp))} mm:${`NA`} mm:${color}`
                        );
                        let tempPbkupObj = globalData.monitDetail.find(k => k.DsNo == strDsNo);
                        if (tempPbkupObj != undefined) {
                            if (tempPbkupObj.data != undefined) {
                                if (tempPbkupObj.data.length > 0) {
                                    for (var i = 0; i < tempPbkupObj.data.length; i++) {
                                        await objMonit.monit({
                                            case: 'pharTestWeight',
                                            Hmi: strDsNo,
                                            data: {
                                                Weight: {
                                                    wtI: `${tempPbkupObj.data[i].ele.W.value}`, Bunit,
                                                    wtH: `${tempPbkupObj.data[i].ele.H.value}`, unit,
                                                    wtT: `${tempPbkupObj.data[i].ele.T.value}`, unit,
                                                    srNo: i + 1
                                                }
                                            }
                                        });
                                    }
                                    var index = globalData.monitDetail.findIndex(k => k.DsNo == strDsNo);
                                    globalData.monitDetail[index].data = [];
                                }
                            }
                        }

                        await objMonit.monit({
                            case: 'pharTestWeight', Hmi: strDsNo, data: {
                                Weight: {
                                    wtI: `${ele.W.value}`, Bunit,
                                    wtH: `${ele.H.value}`, unit,
                                    wtT: `${ele.T.value}`, unit,
                                    srNo: RecNo
                                }
                            }
                        });
                    } else {
                        mqttSender.sendData(
                            strDsNo,
                            `Port ${port}:${mqttProtocol.DisplayResult}${RecNo}:${(maths.round(ele.H.value, hdp).toFixed(hdp))} ${unit}:${(maths.round(ele.T.value, Tdp).toFixed(Tdp))} mm:${`NA`} mm:${color}`
                        );
                        let tempPbkupObj = globalData.monitDetail.find(k => k.DsNo == strDsNo);
                        if (tempPbkupObj != undefined) {
                            if (tempPbkupObj.data != undefined) {
                                if (tempPbkupObj.data.length > 0) {
                                    for (var i = 0; i < tempPbkupObj.data.length; i++) {
                                        await objMonit.monit({
                                            case: 'pharTestWeight',
                                            Hmi: strDsNo,
                                            data: {
                                                Weight: {
                                                    wtI: `NA`, Bunit,
                                                    wtH: `${tempPbkupObj.data[i].ele.H.value}`, unit,
                                                    wtT: `${tempPbkupObj.data[i].ele.T.value}`, unit,
                                                    srNo: i + 1
                                                }
                                            }
                                        });
                                    }
                                    var index = globalData.monitDetail.findIndex(k => k.DsNo == strDsNo);
                                    globalData.monitDetail[index].data = [];
                                }
                            }
                        }

                        await objMonit.monit({
                            case: 'pharTestWeight', Hmi: strDsNo, data: {
                                Weight: {
                                    wtI: `NA`, Bunit,
                                    wtH: `${ele.H.value}`, unit,
                                    wtT: `${ele.T.value}`, unit,
                                    srNo: RecNo
                                }
                            }
                        });
                    }

                    counter = counter + 1
                    newSampleCount = newSampleCount + 1;
                    if (isOutOfLimit == true) {
                        powerbackupexception = isOutOfLimit
                    }
                }
            }

            console.log("Hardness FTP Within Counter : --------->", within_counter);
            console.log("Total No. Of Samples: ---------->", sample);
            if (powerbackupexception == true) {
                await models.tbl_powerbackup.create({
                    Sys_CubType: hmiDetailsInPMenu.Sys_CubType,
                    Sys_BFGCode: hmiDetailsInPMenu.Sys_BFGCode,
                    Sys_Batch: hmiDetailsInPMenu.Sys_Batch,
                    CubicalNo: hmiDetailsInPMenu.Sys_CubicNo,
                    DsNo: strDsNo,
                    TabIp: strTabIp,
                    WeighmentName: objSelMenu.menuName,
                    Incomp_RepSerNo: repSerNo,
                    Before_Count: sideStatus,
                    ReportType: hmiDetailsInPMenu.Sys_RptType,
                    Userid: tempUserObject.UserId,
                    TableType: objSelMenu.Side,
                    WeighmentType: 7,
                    ProductType: 1,
                    MPN_Code: objSelMenu.MPN,
                    isException: 1
                })
            }

            if (within_counter != sample) {
                if (InstrumentData.Eqp_Make == 'Pharmatest' && hmiDetailsInPMenu.Sys_RptType == 0 && getTableName_) {
                    await models[getTableName_.detailTableIncomplete].update({ isCompleted: 1 }, { where: { RepSerNo: repSerNo } })
                    await models.tbl_exception_sample_initial.update({ isTerminated: 1 }, { where: { RepSerNo: repSerNo } })
                }
                await models[getTableName.detailTableIncomplete].update({ isCompleted: 1 }, { where: { RepSerNo: repSerNo } })
                await models[exceptionTableName].update({ isTerminated: 1 }, { where: { RepSerNo: repSerNo } })
                mqttSender.sendData(strDsNo, `Port ${port}:${mqttProtocol.TestCompleted} Invalid Samples, Please Perform the Test Again:OkBtn true`)
                await objMonit.monit({
                    case: 'ReportStatus', Hmi: strDsNo, data: {
                        message: 'Invalid Samples, Please Perform the Test Again'
                    }
                });
                return
            }

            if (within_counter <= sample) {
                let endTime = moment().format('HH:mm:ss');
                let updateEndTimeAndRemObj = {
                    Param7_PrEndTime: endTime,
                    Param7_PrEndDate: moment().format('YYYY-MM-DD'),
                    PrEndDate: moment().format('YYYY-MM-DD'),
                    PrEndTime: endTime,
                    Param7_Remark: 'Within Limit',
                    Param3_Remark: 'Within Limit'
                }
                if (InstrumentData.Eqp_Make == 'Pharmatest' && hmiDetailsInPMenu.Sys_RptType == 0) {
                    updateEndTimeAndRemObj.Param1_PrEndTime = endTime;
                    updateEndTimeAndRemObj.Param1_PrEndDate = moment().format('YYYY-MM-DD');
                    // updateEndTimeAndRemObj.Param1_Remark = 'Within Limit';
                }
                await models.tbl_tab_initialmaster_incomplete.update(updateEndTimeAndRemObj, {
                    where: {
                        RepSerNo: repSerNo
                    }
                })
                var detailData = await models[getTableName.detailTableIncomplete].findAll({ where: { RepSerNo: repSerNo, isException: 0 } });
                let result_ = this.calculation(detailData, unit, InstrumentData.Eqp_Make, hmiDetailsInPMenu.Sys_RptType);
                const testInfo = await this.updatemasterTable(repSerNo, undefined, strDsNo, strTabIp, getTableName, isftp, result_);
                let count = await objCommonInsertOpt.updateMenuSequenceEntry(strDsNo, strTabIp, "Hardness", repSerNo, getTableName.masterTableIncomplete, getTableName.masterTable, cubicObj, port, 'NA', InstrumentData.Eqp_Make, 'Report Within Limit')
            }

            globalData.hardnessClient[0].isAvailable = false
            if (InstrumentData.Eqp_Make == 'Pharmatest' && hmiDetailsInPMenu.Sys_RptType == 0) {
                getTableName_ = objCommonWeightment.getTableName(cubicObj, 'Individual', strDsNo, strTabIp)
                activity_msg = `Individual, Thickness & Hardness Test Completed on DS ${strDsNo}`
                activity_msg = (objSelMenu.Side == "NA") ? activity_msg : `${activity_msg} for side ${objSelMenu.Side}`;
            } else {
                activity_msg = `Thickness & Hardness Test Completed on DS ${strDsNo}`
                activity_msg = (objSelMenu.Side == "NA") ? activity_msg : `${activity_msg} for side ${objSelMenu.Side}`;
            }
            Object.assign(
                objActivity,
                { strUserId: tempUserObject.UserId },
                { strUserName: tempUserObject.UserName },
                { batch: hmiDetailsInPMenu.Sys_Batch },
                { activity: activity_msg }
            );
            await objMonit.monit({
                case: 'ReportStatus', Hmi: strDsNo, data: {
                    message: 'Hardness Test Completed'
                }
            });
            await objActivityLog.ActivityLogEntry(objActivity);

            await objInstrumentUsage.InstrumentUsage(
                // "Hardness",
                GLOBAL_NOMENCLATURE.MultiTester,
                strDsNo,
                "tbl_instrumentlog_hardness",
                activity_msg,
                "completed",
                strTabIp,
                tempUserObject,
                cubicalInfo
            );

            globalData.arrCurrentOperationStatus.findIndex(
                (element) => element.DsNo === strDsNo
            ) == -1
                ? globalData.arrCurrentOperationStatus
                : globalData.arrCurrentOperationStatus.splice(
                    globalData.arrCurrentOperationStatus.findIndex(
                        (element) => element.DsNo === strDsNo
                    ),
                    1
                );

            globalData.arrSelectedMenu.findIndex((k) => k.DsNo == strDsNo) == -1
                ? globalData.arrSelectedMenu
                : globalData.arrSelectedMenu.splice(
                    globalData.arrSelectedMenu.findIndex((k) => k.DsNo == strDsNo),
                    1
                );

            return
        } catch (error) {
            throw new Error(error);
        }
    }


    async saveDataIncompleteMasterHardnessVK200(dataObj) {
        try {
            console.log(dataObj)
            let now = new Date();
            let SFOID = dataObj.SFOID;
            let strDsNo = dataObj.strDsNo;
            let strTabIp = dataObj.TabIp;
            let side = dataObj.objProductDetails.Side;
            let objProductDetails = dataObj.objProductDetails
            let cubicalObj = globalData.arrIdsInfo.find(k => k.DsNo == strDsNo).cubicalData; //selected

            // let selectedIdsNo;
            // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strIdsNo);
            // if (IPQCObject != undefined) {
            //     selectedIdsNo = IPQCObject.selectedIds;
            // } else {
            //     selectedIdsNo = strIdsNo;
            // }
            var decimalrange = this.getUnitObj(GLOBAL_NOMENCLATURE.ThicknessMenu)
            let hardData = objProductDetails.selectedProductDetail.arrHardnessColumnDetail.filter(obj => Object.keys(obj) == 'Hardness')[0]
            let thickData = objProductDetails.selectedProductDetail.arrHardnessColumnDetail.filter(obj => Object.keys(obj) == 'Thickness')[0]
            let hmiDetailsInPMenu = globalData.arrIdsInfo.find(k => k.DsNo == strDsNo).cubicalData;
            let InstrumentData = await models.tbl_otherequipment.findOne({
                where: {
                    Eqp_ID: objProductDetails.instrumentId
                }
            })
            let productDetail = globalData.arrProductTypeArray.find(k => k.DsNo == strDsNo)
            let users = globalData.arrUsers.find(k => k.DsNo == strDsNo && k.TabIp == strTabIp)
            let doloboNom;
            let doloboNeg;
            let doloboPos;
            let colHeadDolobo;
            let blName = "Length"

            // if (hmiDetailsInPMenu.Sys_RotaryType == "Single" || hmiDetailsInPMenu.Sys_RotaryType == 'NULL') {
            //     side = "NA";
            // }


            //getting tolerances of both Hardness and Thickness
            // let menuDetail = globalData.arr_limits.find(k => k.DsNo == strDsNo && k.TabIp==strTabIp);
            let menuDetail = globalData.arrSelectedMenu.find(k => k.DsNo == strDsNo && k.TabIp == strTabIp)
            let tempObj;
            let thicknessNom, thicknesneg, thicknespos, thicknespos2, thicknesNom, thicknesneg2, hardnessneg2, hardnesspos2, hardnessNom;
            let tempLimObjHardness, tempLimObjThickness, tempLimObjlength, tempLimObjDiameter, tempLimObjBreadth;

            tempLimObjHardness = menuDetail.selectedProductDetail.arrHardnessColumnDetail.filter(obj => Object.keys(obj) == 'Hardness')[0]
            tempLimObjThickness = menuDetail.selectedProductDetail.arrHardnessColumnDetail.filter(obj => Object.keys(obj) == 'Thickness')[0]
            tempLimObjlength = menuDetail.selectedProductDetail.arrHardnessColumnDetail.filter(obj => Object.keys(obj) == 'Length')[0]
            tempLimObjDiameter = menuDetail.selectedProductDetail.arrHardnessColumnDetail.filter(obj => Object.keys(obj) == 'Diameter')[0]
            tempLimObjBreadth = menuDetail.selectedProductDetail.arrHardnessColumnDetail.filter(obj => Object.keys(obj) == 'Breadth')[0]


            // tempLimObjHardness = [menuDetail.Menus].filter(obj => Object.keys(obj) == "Hardness")[0] == undefined ?
            //     undefined : [menuDetail.Menus].filter(obj => Object.keys(obj) == "Hardness")[0]['arrHardnessColumnDetail'];

            // tempLimObjThickness = [menuDetail.Menus].filter(obj => Object.keys(obj) == "Thickness")[0] == undefined ?
            //     undefined : menuDetail.Menus.filter(obj => Object.keys(obj) == "Thickness")[0]['Thickness'];

            // tempLimObjlength = [menuDetail.Menus].filter(obj => Object.keys(obj) == "Length")[0] == undefined ?
            //     undefined : [menuDetail.Menus].filter(obj => Object.keys(obj) == "Length")[0]['Length'];

            // tempLimObjDiameter = [menuDetail.Menus].filter(obj => Object.keys(obj) == "Diameter")[0] == undefined ?
            //     undefined : [menuDetail.Menus].filter(obj => Object.keys(obj) == "Diameter")[0]['Diameter'];

            // tempLimObjBreadth = [menuDetail.Menus.filter](obj => Object.keys(obj) == "Breadth")[0] == undefined ?
            //     undefined : [menuDetail.Menus].filter(obj => Object.keys(obj) == "Breadth")[0]['Breadth'];

            // colHeadDolobo = tempLimObjlength != undefined ? 'Length' : tempLimObjBreadth != undefined ?
            //     'Breadth' : tempLimObjDiameter != undefined ? 'Diameter' : 'NA';



            if (tempLimObjDiameter != undefined) { // diameter
                // doloboNom = (productDetail.productDetail.Param6_Nom != 99999) ? productDetail.productDetail.Param6_Nom : 0;
                doloboNom = productDetail.productDetail.Param6_Nom;
                doloboNeg = productDetail.productDetail.Param6_T1Neg;
                doloboPos = productDetail.productDetail.Param6_T1Pos;
                blName = 'Diameter'
            } else if (tempLimObjlength != undefined) { //length
                // doloboNom = (tempLimObjlength.Length.Nom != 99999) ? tempLimObjlength.Length.Nom : 0;
                doloboNom = tempLimObjlength.Length.Nom;
                doloboNeg = tempLimObjlength.Length.T2Neg;
                doloboPos = tempLimObjlength.Length.T2Pos;
                blName = 'Length'
            }
            else if (tempLimObjBreadth != undefined) {
                // doloboNom = (productDetail.productDetail.Param4_Nom != 99999) ? productDetail.productDetail.Param4_Nom : 0;
                doloboNom = productDetail.productDetail.Param4_Nom;
                doloboNeg = productDetail.productDetail.Param4_T1Neg;
                doloboPos = productDetail.productDetail.Param4_T1Pos;
                blName = 'Breadth'
            }
            else {
                doloboNom = 0;
                doloboNeg = 0;
                doloboPos = 0;
                blName = 'Length'
            }

            if (tempLimObjThickness != undefined) {
                // thicknesNom = (tempLimObjThickness.Thickness.Nom != 99999) ? tempLimObjThickness.Thickness.Nom : 0
                thicknesNom = Number(tempLimObjThickness.Thickness.Nom).toFixed(decimalrange.target);
                thicknespos2 = Number(tempLimObjThickness.Thickness.T2Pos).toFixed(decimalrange.target);
                thicknesneg2 = Number(tempLimObjThickness.Thickness.T2Neg).toFixed(decimalrange.target);
                var unitthick = tempLimObjThickness.Thickness.Unit
            } else {
                thicknesNom = 0
                thicknespos2 = 0;
                thicknesneg2 = 0;
            }

            if (tempLimObjHardness != undefined) {
                // hardnessNom = (tempLimObjHardness.Hardness.Nom != 99999) ? tempLimObjHardness.Hardness.Nom : 0;
                hardnessNom = Number(tempLimObjHardness.Hardness.Nom).toFixed(decimalrange.target);
                hardnesspos2 = Number(tempLimObjHardness.Hardness.T2Pos).toFixed(decimalrange.target);
                hardnessneg2 = Number(tempLimObjHardness.Hardness.T2Neg).toFixed(decimalrange.target);
                var hdp = tempLimObjHardness.Hardness.dp
                var hdp = tempLimObjHardness.Hardness.dp
                var unithard = tempLimObjHardness.Hardness.Unit
            } else {
                hardnessNom = 0;
                hardnesspos2 = 0;
                hardnessneg2 = 0;
            }
            var unitBal = null
            var T2pos = null
            var T2neg = null
            var IndNom = 0;
            var Param1_PrTime
            var Param1_PrDate


            if (hmiDetailsInPMenu.Sys_RptType != undefined) {
                let repSerNo;
                let menuFlag = await models.tbl_menu_sequence.findAll({
                    where: {
                        TabIp: strTabIp,
                        Ds_Number: strDsNo,
                    }
                })
                let hrdStartTime = moment().format('HH:mm:ss');
                var find_repSrno_complete = await models.tbl_tab_initialmaster_incomplete.findAll({
                    where: {
                        RepSerNo: menuFlag[0].RepSerNo
                    },
                })
                if (menuFlag[0].RepSerNo != 0 && hmiDetailsInPMenu.Sys_RptType != 0) {
                    IndNom = Number(find_repSrno_complete[0].Param1_Nom).toFixed(decimalrange.target);
                    unitBal = find_repSrno_complete[0].Param1_Unit
                    T2pos = Number(find_repSrno_complete[0].Param1_T2PosTol).toFixed(decimalrange.target);
                    T2neg = Number(find_repSrno_complete[0].Param1_T2NegTol).toFixed(decimalrange.target);
                    Param1_PrTime = moment(find_repSrno_complete[0].Param1_PrTime).format('HH:mm:ss')
                    Param1_PrDate = moment(find_repSrno_complete[0].Param1_PrDate).format('YYYY-MM-DD')
                }
                if (InstrumentData.Eqp_Make == 'Pharmatest' && hmiDetailsInPMenu.Sys_RptType == 0) {
                    // IndNom = (productDetail.productDetail.Param1_Nom != 99999) ? productDetail.productDetail.Param1_Nom : 0;
                    IndNom = hmiDetailsInPMenu.Sys_RptType == 0 ? productDetail.productDetail.Param1_Nom : 0.00;
                    unitBal = hmiDetailsInPMenu.Sys_RptType == 0 ? productDetail.productDetail.Param1_Unit : null;
                    T2pos = hmiDetailsInPMenu.Sys_RptType == 0 ? productDetail.productDetail.Param1_T2Pos : 0.00;
                    T2neg = hmiDetailsInPMenu.Sys_RptType == 0 ? productDetail.productDetail.Param1_T2Neg : 0.00;
                    Param1_PrTime = hrdStartTime,
                        Param1_PrDate = moment().format('YYYY-MM-DD');
                    T2pos = Number(T2pos).toFixed(decimalrange.target);
                    T2neg = Number(T2neg).toFixed(decimalrange.target);
                    IndNom = Number(IndNom).toFixed(decimalrange.target)
                }
                const equipmentData = await models.tbl_machine.findOne({
                    attributes: ['Machine_Punches'],
                    where: { Machine_ID: hmiDetailsInPMenu.Sys_MachineCode }
                })

                let mastSerNo = await check_srNO.check_master_SRno1({ cubicObj: cubicalObj, masterTable: 'tbl_tab_initialmaster', DsNo: strDsNo, masterTableIncomplete: 'tbl_tab_initialmaster_incomplete' })


                if (menuFlag.length > 0 && menuFlag[0].HARD == 0 && menuFlag[0].RepSerNo != 0) {
                    let jsonDates = {}
                    if (InstrumentData.Eqp_Make == 'Pharmatest' && hmiDetailsInPMenu.Sys_RptType == 0) {
                        jsonDates['Param7_PrTime'] = hrdStartTime
                        jsonDates['Param3_PrTime'] = hrdStartTime
                        jsonDates['Param1_PrTime'] = Param1_PrTime
                        jsonDates['Param7_PrDate'] = moment().format('YYYY-MM-DD')
                        jsonDates['Param3_PrDate'] = moment().format('YYYY-MM-DD')
                        jsonDates['Param1_PrDate'] = moment().format('YYYY-MM-DD')

                        // let parseDatesObj = objCommonInsertOpt.parseJSON(find_repSrno_complete[0].dates_json, jsonDates)
                        await models.tbl_tab_initialmaster_incomplete.update(
                            {
                                Param7_PrTime: moment().format('HH:mm:ss'),
                                Param7_PrDate: moment().format('HH:mm:ss'),
                                Param3_PrDate: moment().format('HH:mm:ss'),
                                Param3_PrTime: moment().format('HH:mm:ss'),
                                Param1_PrTime: moment().format('HH:mm:ss'),
                                Param1_PrDate: moment().format('YYYY-MM-DD'),
                                // Param7_PrTime: objCommonInsertOpt.customDateTimeformatter(find_repSrno_complete[0]?.Param7_PrTime,'HH:mm:ss'),
                                // Param7_PrDate: objCommonInsertOpt.customDateTimeformatter(find_repSrno_complete[0]?.Param7_PrDate,'YYYY-MM-DD'),
                                // Param3_PrDate: objCommonInsertOpt.customDateTimeformatter(find_repSrno_complete[0]?.Param3_PrDate,'YYYY-MM-DD'),
                                // Param3_PrTime: objCommonInsertOpt.customDateTimeformatter(find_repSrno_complete[0]?.Param3_PrTime,'HH:mm:ss'),
                                // Param1_PrTime: objCommonInsertOpt.customDateTimeformatter(find_repSrno_complete[0]?.Param1_PrTime,'HH:mm:ss'),
                                // Param1_PrDate: objCommonInsertOpt.customDateTimeformatter(find_repSrno_complete[0]?.Param1_PrDate,'YYYY-MM-DD'),
                                Param7_Nom: hardnessNom,
                                Param7_T2NegTol: hardnessneg2,
                                Param7_T2PosTol: hardnesspos2,
                                Param3_T2PosTol: thicknespos2,
                                Param3_T2NegTol: thicknesneg2,
                                Param3_Nom: thicknesNom,
                                Param1_T2NegTol: T2neg,
                                Param1_T2PosTol: T2pos,
                                Param1_Nom: IndNom,
                                Param1_Unit: unitBal,
                                Param3_Unit: unitthick,
                                Param7_Unit: unithard,
                                PrDate: moment().format("YYYY-MM-DD"),
                                PrTime: moment().format("HH:mm:ss"),
                                HardnessID: (hmiDetailsInPMenu.Sys_HardID == 'None') ? 'NA' : hmiDetailsInPMenu.Sys_HardID,
                                // Param7_PrEndTime: moment().format('HH:mm:ss'),
                                // Param7_PrEndDate: moment().format('YYYY-MM-DD'),
                                // Param1_PrEndTime: moment().format('HH:mm:ss'),
                                // Param1_PrEndDate: moment().format('YYYY-MM-DD'),
                                // dates_json: parseDatesObj
                            }, {
                            where: {
                                RepSerNo: menuFlag[0].RepSerNo
                            }
                        })




                        repSerNo = menuFlag[0].RepSerNo
                    } else {
                        // jsonDates['Param7_PrTime'] = hrdStartTime
                        // jsonDates['Param3_PrTime'] = hrdStartTime
                        // jsonDates['Param7_PrDate'] = moment().format('YYYY-MM-DD')
                        // jsonDates['Param3_PrDate'] = moment().format('YYYY-MM-DD')
                        // let parseDatesObj = objCommonInsertOpt.parseJSON(find_repSrno_complete[0].dates_json, jsonDates)
                        await models.tbl_tab_initialmaster_incomplete.update(
                            {
                                Param7_PrTime: moment().format('HH:mm:ss'),
                                Param7_PrDate: moment().format('YYYY-MM-DD'),
                                Param3_PrDate: moment().format('YYYY-MM-DD'),
                                Param3_PrTime: moment().format('HH:mm:ss'),
                                // Param7_PrTime: objCommonInsertOpt.customDateTimeformatter(find_repSrno_complete[0].Param7_PrTime,'HH:mm:ss'),
                                // Param7_PrDate: objCommonInsertOpt.customDateTimeformatter(find_repSrno_complete[0].Param7_PrDate,'YYYY-MM-DD'),
                                // Param3_PrDate: objCommonInsertOpt.customDateTimeformatter(find_repSrno_complete[0].Param7_PrDate,'YYYY-MM-DD'),
                                // Param3_PrTime: objCommonInsertOpt.customDateTimeformatter(find_repSrno_complete[0].Param7_PrTime,'HH:mm:ss'),
                                Param7_Nom: hardnessNom,
                                Param7_T2NegTol: hardnessneg2,
                                Param7_T2PosTol: hardnesspos2,
                                Param3_T2PosTol: thicknespos2,
                                Param3_T2NegTol: thicknesneg2,
                                Param3_Nom: thicknesNom,
                                Param3_Unit: unitthick,
                                Param7_Unit: unithard,
                                PrDate: moment().format("YYYY-MM-DD"),
                                PrTime: moment().format("HH:mm:ss"),
                                HardnessID: (hmiDetailsInPMenu.Sys_HardID == 'None') ? 'NA' : hmiDetailsInPMenu.Sys_HardID,
                                StartSampleCount: objProductDetails.StartSampleCount,
                                // Param7_PrEndTime: moment().format('HH:mm:ss'),
                                // Param7_PrEndDate: moment().format('YYYY-MM-DD'),
                                // Param1_PrEndTime: moment().format('HH:mm:ss'),
                                // Param1_PrEndDate: moment().format('YYYY-MM-DD'),
                                // dates_json: parseDatesObj
                            }, {
                            where: {
                                RepSerNo: menuFlag[0].RepSerNo
                            }
                        })

                        repSerNo = menuFlag[0].RepSerNo
                    }


                } else {
                    let mstEntry = await models.tbl_tab_initialmaster_incomplete.create({
                        MstSerNo: mastSerNo,
                        CubicalNo: hmiDetailsInPMenu.Sys_CubicNo,
                        CubicleName: hmiDetailsInPMenu.Sys_CubicName,
                        CubicleType: hmiDetailsInPMenu.Sys_CubType,
                        ProductName: productDetail.productDetail.ProductName,
                        BFGCode: productDetail.productDetail.ProductId,
                        MPN_Code: objProductDetails.MPN,
                        SFOID: SFOID,
                        ProductType: productDetail.productType.ProductType,
                        Area: hmiDetailsInPMenu.Sys_Area,
                        MachineCode: objProductDetails.EquipmentCode,
                        NoOfStations: equipmentData.Machine_Punches,
                        PVersion: hmiDetailsInPMenu.Sys_PVersion,
                        Version: hmiDetailsInPMenu.Sys_Version,
                        BatchNo: hmiDetailsInPMenu.Sys_Batch,
                        BFGCode: hmiDetailsInPMenu.Sys_BFGCode,
                        Param7_Nom: hardnessNom,
                        Param7_T2NegTol: hardnessneg2,
                        Param7_T2PosTol: hardnesspos2,
                        Param7_Unit: unithard,
                        Param3_T2PosTol: thicknespos2,
                        Param3_T2NegTol: thicknesneg2,
                        Param3_Unit: unitthick,
                        Param3_Nom: thicknesNom,
                        Param1_T2NegTol: T2neg,
                        Param1_T2PosTol: T2pos,
                        Param1_Unit: unitBal,
                        Param1_Nom: IndNom,
                        Param1_MaxWeight: 0.00,
                        Param1_MinWeight: 0.00,
                        Param1_AvgNet: 0.00,
                        Param1_StdDev: 0.00,
                        Param1_RStdDev: 0.00,
                        Param7_MinWeight: 0.00,
                        Param7_MaxWeight: 0.00,
                        Param7_StdDev: 0.00,
                        Param7_RStdDev: 0.00,
                        Param7_AvgNet: 0.00,
                        Param3_AvgNet: 0.00,
                        Param3_MinWeight: 0.00,
                        Param3_MaxWeight: 0.00,
                        Param3_StdDev: 0.00,
                        Param3_RStdDev: 0.00,
                        DsNo: strDsNo,
                        TabIp: strTabIp,
                        ProducatName: hmiDetailsInPMenu.Sys_ProductName,
                        UserId: users.UserId,
                        UserName: users.UserName,
                        Idsno: hmiDetailsInPMenu.Sys_DSNumber,
                        Side: objProductDetails.Side,
                        ReportType: objProductDetails.testType,
                        Qty: objProductDetails.noOfSamples,
                        GrpQty: objProductDetails.groupQty,

                        // BalanceId: hmiDetailsInPMenu.Sys_BalID,
                        // VernierId: (hmiDetailsInPMenu.Sys_VernierID == 'None') ? 'NA' : hmiDetailsInPMenu.Sys_VernierID,
                        // FriabilityID: (hmiDetailsInPMenu.Sys_FriabID == 'None') ? 'NA' : hmiDetailsInPMenu.Sys_FriabID,
                        HardnessID: (hmiDetailsInPMenu.Sys_HardID == 'None') ? 'NA' : hmiDetailsInPMenu.Sys_HardID,
                        // DTID: (hmiDetailsInPMenu.Sys_DTID == 'None') ? 'NA' : hmiDetailsInPMenu.Sys_DTID,
                        IntervalStartTm: moment().format('YYYY-MM-DD HH:mm:ss'),
                        Param7_PrDate: moment().format('YYYY-MM-DD'),
                        Param7_PrTime: hrdStartTime,
                        Param1_PrTime: Param1_PrTime,
                        Param1_PrDate: Param1_PrDate,
                        PrDate: moment().format("YYYY-MM-DD"),
                        PrTime: hrdStartTime,
                        Side: hmiDetailsInPMenu.Sys_RotaryType,
                        Repetition: hmiDetailsInPMenu.Sys_Repetition,
                        // Param7_PrEndTime: moment().format('HH:mm:ss'),
                        // Param7_PrEndDate: moment().format('YYYY-MM-DD'),
                        // Param1_PrEndTime: moment().format('HH:mm:ss'),
                        // Param1_PrEndDate: moment().format('YYYY-MM-DD'),
                        LHSContainerNo: dataObj.LHSContainerNo,
                        RHSContainerNo: dataObj.RHSContainerNo,
                        MesTestType: hmiDetailsInPMenu.MesTestType,
                        MesSide: hmiDetailsInPMenu.MesSide,
                        StartSampleCount: objProductDetails.StartSampleCount

                    })

                    repSerNo = mstEntry.RepSerNo;

                    await models.tbl_menu_sequence.update(
                        {
                            RepSerNo: repSerNo
                        }, {
                        where: {
                            TabIp: strTabIp,
                            Ds_Number: strDsNo,
                        }
                    })
                }

                return repSerNo;

            } else {

                // const checkData = await models.tbl_tab_masterhtd_incomplete.findAll({
                //     attributes: [[sequelize.fn("max", sequelize.col("MstSerNo")), "SeqNo"]],
                //     where: {
                //       BFGCode: cubicalObj.Sys_BFGCode,
                //       ProductName: cubicalObj.Sys_ProductName,
                //       PVersion: cubicalObj.Sys_PVersion,
                //       Version: cubicalObj.Sys_Version,
                //       BatchNo: cubicalObj.Sys_Batch,
                //     },
                // });

                var check_master_SRno = await check_srNO.check_master_SRno({ DsNo: strDsNo }, hmiDetailsInPMenu, strDsNo, objProductDetails, `tbl_tab_masterhtd`, side)

                // var resultCompleteData = checkData

                // var intMstSerNo;
                // if (resultCompleteData[0].SeqNo == null) {
                //     intMstSerNo = 1;
                // } else {
                //     var newMstSerNo = resultCompleteData[0].SeqNo + 1;
                //     intMstSerNo = newMstSerNo;
                // }    


                let insertHard = await models.tbl_tab_masterhtd_incomplete.create(
                    {
                        DsNo: strDsNo,
                        MstSerNo: check_master_SRno,
                        WgmtModeNo: 1,
                        ProductType: productDetail.productType.ProductType,
                        Area: hmiDetailsInPMenu.Sys_Area,
                        CubicalNo: hmiDetailsInPMenu.Sys_CubicNo,
                        CubicleName: hmiDetailsInPMenu.Sys_CubicName,
                        CubicleType: hmiDetailsInPMenu.Sys_CubType,
                        // IPQCType:
                        // CoatingType:
                        MachineCode: objProductDetails.EquipmentCode,
                        Department: 'NA',
                        ProductName: hmiDetailsInPMenu.Sys_ProductName,
                        PVersion: hmiDetailsInPMenu.Sys_PVersion,
                        Version: hmiDetailsInPMenu.Sys_Version,
                        BatchNo: hmiDetailsInPMenu.Sys_Batch,
                        BFGCode: hmiDetailsInPMenu.Sys_BFGCode,
                        // BatchSize:
                        // BMRNo:
                        // GraphType:
                        Qty: dataObj.objProductDetails.noOfSamples,
                        GrpQty: 0,
                        GrpFreq: 0,
                        Idsno: null,
                        HardnessID: InstrumentData.Eqp_ID,
                        UserId: users.UserId,
                        UserName: users.UserName,
                        PrDate: date.format(now, 'YYYY-MM-DD'),
                        PrTime: date.format(now, 'HH:mm:ss'),
                        PrEndDate: null,
                        PrEndTime: null,
                        SideNo: null,
                        Side: side,
                        Unit: tempLimObjHardness.Hardness.Unit,
                        DecimalPoint: hdp,
                        LimitOn: 0,
                        // NomHard: productDetail.productDetail.Param7_Nom,
                        // NomThick: thicknessNom,
                        // NomDiam:
                        // NomBL:
                        // T1NegTolHard: productDetail.productDetail.Param7_T1Neg,
                        // T1PosTolHard: productDetail.productDetail.Param7_T1Pos,
                        // T1NegTolThick: thicknesneg,
                        // T1PosTolThick: thicknespos,
                        // T1NegTolDiam:
                        // T1PosTolDiam:
                        // T1NegTolBL:
                        // T1PosTolBL:
                        // T1NegTolActualHard:
                        // T1PosTolActualHard:
                        // T1NegTolActualThick:
                        // T1PosTolActualThick:
                        // T1NegTolActualDiam:
                        // T1PosTolActualDiam:
                        // T1NegTolActualBL:
                        // T1PosTolActualBL:
                        // ReportType:
                        // PrintNo:
                        // IsArchived:
                        // BatchComplete:
                        // CheckedByID:
                        // CheckedByName:
                        // CheckedByDate:
                        // Lot:
                        // AvgHard:
                        // AvgThick:
                        // AvgDiam:
                        // AvgBL:
                        // MinWeightHard:
                        // MaxWeightHard:
                        // MinWeightThick:
                        // MaxWeightThick:
                        // MinWeightDiam:
                        // MaxWeightDiam:
                        // MinWeightBL:
                        // MaxWeightBL::
                        // StdDevHard:
                        // StdDevThick:
                        // StdDevDiam:
                        // StdDevBL:
                        // RemarkHard:
                        // RemarkDiam:
                        // RemarkThick:
                        // RemarkBL:
                        // FailedRemark:
                        // FailedRemarkTSH:
                        // Inprocess:
                        // Layer:
                        // LayerName:
                        // Nom_stdtarget:
                        T2NegTolHard: hardnessneg2,
                        T2PosTolHard: hardnesspos2,
                        T2NegTolThick: thicknesneg2,
                        T2PosTolThick: thicknespos2,
                        // T2NegTolDiam:
                        // T2PosTolDiam:
                        // T2NegTolBL:
                        // T2PosTolBL:
                        // T2NegTolActualHard:
                        // T2PosTolActualHard:
                        // T2NegTolActualThick:
                        // T2PosTolActualThick:
                        // T2NegTolActualDiam:
                        // T2PosTolActualDiam:
                        // T2NegTolActualBL:
                        // T2PosTolActualBL::
                        // T3NegTolHard:
                        // T3PosTolHard:
                        // T3NegTolThick:
                        // T3PosTolThick:
                        // T3NegTolDiam:
                        // T3PosTolDiam:
                        // T3NegTolBL:
                        // T3PosTolBL:
                        // T3NegTolActualHard:
                        // T3PosTolActualHard:
                        // T3NegTolActualThick:
                        // T3PosTolActualThick:
                        // T3NegTolActualDiam:
                        // T3PosTolActualDiam:
                        // T3NegTolActualBL:
                        // T3PosTolActualBL:
                        // CheckedByTime:
                        // Sys_Validation:
                        SFOID: SFOID,
                        isManual: hmiDetailsInPMenu.isManual,
                        Layer: 'NA',
                        Repetition: hmiDetailsInPMenu.Sys_Repetition,
                        BLName: blName,
                        TabIp: strTabIp,
                        Eqp_Model: InstrumentData.Eqp_Model,
                        Eqp_Make: InstrumentData.Eqp_Make,
                        MPN_Code: objProductDetails.MPN,
                        MesTestType: hmiDetailsInPMenu.MesTestType,
                        MesSide: hmiDetailsInPMenu.MesSide,
                        // IsPosted:
                        // Test_Seq:
                    }
                )
                var insertHardIND
                if (InstrumentData.Eqp_Make == 'Pharmatest') {
                    insertHardIND = await models.tbl_tab_master1.create(
                        {
                            DsNo: strDsNo,
                            MstSerNo: check_master_SRno,
                            WgmtModeNo: 1,
                            ProductType: productDetail.productType.ProductType,
                            Area: hmiDetailsInPMenu.Sys_Area,
                            CubicalNo: hmiDetailsInPMenu.Sys_CubicNo,
                            CubicleName: hmiDetailsInPMenu.Sys_CubicName,
                            CubicleType: hmiDetailsInPMenu.Sys_CubType,
                            // IPQCType:
                            // CoatingType:
                            MachineCode: objProductDetails.EquipmentCode,
                            Department: 'NA',
                            ProductName: hmiDetailsInPMenu.Sys_ProductName,
                            PVersion: hmiDetailsInPMenu.Sys_PVersion,
                            Version: hmiDetailsInPMenu.Sys_Version,
                            BatchNo: hmiDetailsInPMenu.Sys_Batch,
                            BFGCode: hmiDetailsInPMenu.Sys_BFGCode,
                            Qty: dataObj.objProductDetails.noOfSamples,
                            GrpQty: 0,
                            GrpFreq: 0,
                            Idsno: null,
                            HardnessID: InstrumentData.Eqp_ID,
                            UserId: users.UserId,
                            UserName: users.UserName,
                            PrDate: date.format(now, 'YYYY-MM-DD'),
                            PrTime: date.format(now, 'HH:mm:ss'),
                            PrEndDate: null,
                            PrEndTime: null,
                            SideNo: null,
                            Side: side,
                            Unit: tempLimObjHardness.Hardness.Unit,
                            DecimalPoint: hdp,
                            LimitOn: 0,
                            T2NegTolHard: hardnessneg2,
                            T2PosTolHard: hardnesspos2,
                            T2NegTolThick: thicknesneg2,
                            T2PosTolThick: thicknespos2,
                            SFOID: SFOID,
                            isManual: hmiDetailsInPMenu.isManual,
                            Layer: 'NA',
                            Repetition: hmiDetailsInPMenu.Sys_Repetition,
                            BLName: blName,
                            TabIp: strTabIp,
                            Eqp_Model: InstrumentData.Eqp_Model,
                            Eqp_Make: InstrumentData.Eqp_Make,
                            MPN_Code: objProductDetails.MPN,
                            // IsPosted:
                            // Test_Seq:
                        }
                    )
                }
                // let insertHardness = await database.save(insertObj);




                console.log(insertHard.RepSerNo)
                var obj = { hard_repsr: insertHard.RepSerNo, ind_Repsr: insertHardIND.RepSerNo }
                return obj;
            }
        } catch (error) {
            throw new Error(error);
        }
    }

    async precision(a) {
        if (!isFinite(a)) return 0;
        var e = 1, p = 0;
        while (Math.round(a * e) / e !== a) { e *= 10; p++; }
        return p;
    }

    async updatemasterTable(repSerNo, powerBackup, DsNo, strTabIp, tableNames, isftp, result_) {
        try {

            let menuDetail = globalData.arr_limits.find((k) => k.DsNo == DsNo && k.TabIp == strTabIp);;
            let hardmenu = menuDetail.Menus.Hardness
            let tempLimObjHardness = hardmenu.arrHardnessColumnDetail.filter((obj) => Object.keys(obj) == "Hardness")[0] == undefined ? undefined : hardmenu.arrHardnessColumnDetail.filter((obj) => Object.keys(obj) == "Hardness")[0].Hardness;
            let tempLimObjThickness = hardmenu.arrHardnessColumnDetail.filter((obj) => Object.keys(obj) == "Thickness")[0] == undefined ? undefined : hardmenu.arrHardnessColumnDetail.filter((obj) => Object.keys(obj) == "Thickness")[0].Thickness;
            let hdp = tempLimObjHardness ? (tempLimObjHardness.dp != undefined ? tempLimObjHardness.dp : 0) : 0;
            let tdp = tempLimObjThickness ? (tempLimObjThickness.dp != undefined ? tempLimObjThickness.dp : 0) : 0;

            let cubicObj = globalData.arrIdsInfo.find(k => k.DsNo == DsNo && k.TabIp == strTabIp).cubicalData;
            var masterData = await models[tableNames.masterTableIncomplete].findOne({
                where: {
                    RepSerNo: repSerNo,
                },
            });

            let whereCondition = { RepSerNo: repSerNo, isException: 0 }
            // if(!isftp) { whereCondition.isException = 0 }

            var detailData = await models[tableNames.detailTableIncomplete].findAll({ where: whereCondition });
            var Param1_PrDate
            var Param1_PrTime
            var Param1_Remark = null
            if (cubicObj.Sys_RptType == 1) {
                result_.balmax_value = masterData.Param1_MaxWeight
                result_.balmin_value = masterData.Param1_MinWeight
                result_.balavg = masterData.Param1_AvgNet
                result_.balstd_value = masterData.Param1_StdDev
                result_.balrsd_value = masterData.Param1_RStdDev
                result_.balDiff = masterData.Param1_Diff
                Param1_PrDate = moment(masterData.Param1_PrDate).format('YYYY-MM-DD')
                Param1_PrTime = moment(masterData.Param1_PrTime).format('HH:mm:ss');
                Param1_Remark = masterData.Param1_Remark
            }

            let jsonDates = {
                Param7_PrEndTime: moment().format('HH:mm:ss'),
                Param7_PrEndDate: moment().format('YYYY-MM-DD'),    
            }

            if (cubicObj.Sys_RptType == 0) {
                jsonDates['Param7_PrEndTime'] = moment().format('HH:mm:ss'),
                jsonDates['Param7_PrEndTime'] = moment().format('HH:mm:ss')

                // let parseDatesObj = objCommonInsertOpt.parseJSON(masterData.dates_json, jsonDates)
                await models.tbl_tab_initialmaster_incomplete.update(
                    {
                        // Param7_PrTime: moment().format('HH:mm:ss'),
                        // Param7_PrDate: moment().format('YYYY-MM-DD'),
                        // Param1_PrTime: Param1_PrTime,
                        // Param1_PrDate: Param1_PrDate,
                        // Param3_PrTime: moment().format('HH:mm:ss'),
                        // Param3_PrDate: moment().format('YYYY-MM-DD'),
                        Param1_MaxWeight: result_?.balmax_value,
                        Param1_MinWeight: result_?.balmin_value,
                        Param1_AvgNet: result_?.balavg,
                        Param1_StdDev: result_?.balstd_value,
                        Param1_RStdDev: result_?.balrsd_value,
                        Param1_TotalWeight: result_?.balfinalSum ?? masterData?.Param1_TotalWeight,
                        Param7_MinWeight: result_.hardmin_value,
                        Param7_MaxWeight: result_.hardmax_value,
                        Param7_StdDev: result_.hardstd_value,
                        Param7_RStdDev: result_.hardrsd_value,
                        Param7_AvgNet: result_.hardavg,
                        Param3_AvgNet: result_.thickavg,
                        Param3_MinWeight: result_.thickmin_value,
                        Param3_MaxWeight: result_.thickmax_value,
                        Param3_StdDev: result_.thickstd_value,
                        Param3_RStdDev: result_.thickrsd_value,
                        Param7_Unit: tempLimObjHardness.Unit,
                        Param3_Unit: tempLimObjThickness.Unit,
                        Param1_Diff: result_.balDiff,
                        Param3_Diff: result_.thickDiff,
                        Param7_Diff: result_.hardDiff,
                        Param1_Remark: Param1_Remark,
                        Param7_PrEndTime: moment().format('HH:mm:ss'),
                        Param3_PrEndTime: moment().format('HH:mm:ss'),
                        Param7_PrEndDate: moment().format('YYYY-MM-DD'),
                        Param3_PrEndDate: moment().format('YYYY-MM-DD'),
                        // Param7_PrEndTime: objCommonInsertOpt.customDateTimeformatter(masterData.Param7_PrEndTime,'HH:mm:ss'),
                        // Param3_PrEndTime: objCommonInsertOpt.customDateTimeformatter(masterData.Param3_PrEndTime,'HH:mm:ss'),
                        // Param7_PrEndDate: objCommonInsertOpt.customDateTimeformatter(masterData.Param7_PrEndDate,'YYYY-MM-DD'),
                        // Param3_PrEndDate: objCommonInsertOpt.customDateTimeformatter(masterData.Param3_PrEndDate,'YYYY-MM-DD'),
                        // dates_json: parseDatesObj,


                    }, {
                    where: {
                        RepSerNo: repSerNo
                    }
                });
                jsonDates = {}
            } else if (cubicObj.Sys_RptType == 1) {                
                // let parseDatesObj = objCommonInsertOpt.parseJSON(masterData.dates_json, jsonDates)

                await models.tbl_tab_initialmaster_incomplete.update(
                    {
                        // Param7_PrTime: moment().format('HH:mm:ss'),
                        // Param7_PrDate: moment().format('YYYY-MM-DD'),
                        // Param1_PrTime: Param1_PrTime,
                        // Param1_PrDate: Param1_PrDate,
                        // Param3_PrTime: moment().format('HH:mm:ss'),
                        // Param3_PrDate: moment().format('YYYY-MM-DD'),
                        // Param1_MaxWeight: result_.balmax_value,
                        // Param1_MinWeight: result_.balmin_value,
                        // Param1_AvgNet: result_.balavg,
                        // Param1_StdDev: result_.balstd_value,
                        // Param1_RStdDev: result_.balrsd_value,
                        // Param1_TotalWeight: result_.balfinalSum,
                        Param7_MinWeight: result_.hardmin_value,
                        Param7_MaxWeight: result_.hardmax_value,
                        Param7_StdDev: result_.hardstd_value,
                        Param7_RStdDev: result_.hardrsd_value,
                        Param7_AvgNet: result_.hardavg,
                        Param3_AvgNet: result_.thickavg,
                        Param3_MinWeight: result_.thickmin_value,
                        Param3_MaxWeight: result_.thickmax_value,
                        Param3_StdDev: result_.thickstd_value,
                        Param3_RStdDev: result_.thickrsd_value,
                        Param7_Unit: tempLimObjHardness.Unit,
                        Param3_Unit: tempLimObjThickness.Unit,
                        // Param1_Diff: result_.balDiff,
                        Param3_Diff: result_.thickDiff,
                        Param7_Diff: result_.hardDiff,
                        // Param1_Remark: Param1_Remark,
                        // dates_json: parseDatesObj,
                        Param7_PrEndTime: moment().format('HH:mm:ss'),
                        Param3_PrEndTime: moment().format('HH:mm:ss'),
                        Param7_PrEndDate: moment().format('YYYY-MM-DD'),
                        Param3_PrEndDate: moment().format('YYYY-MM-DD'),
                        // Param7_PrEndTime: objCommonInsertOpt.customDateTimeformatter(masterData.Param7_PrEndTime,'HH:mm:ss'),
                        // Param3_PrEndTime: objCommonInsertOpt.customDateTimeformatter(masterData.Param3_PrEndTime,'HH:mm:ss'),
                        // Param7_PrEndDate: objCommonInsertOpt.customDateTimeformatter(masterData.Param7_PrEndDate,'YYYY-MM-DD'),
                        // Param3_PrEndDate: objCommonInsertOpt.customDateTimeformatter(masterData.Param3_PrEndDate,'YYYY-MM-DD'),


                    }, {
                    where: {
                        RepSerNo: repSerNo
                    }
                });

                jsonDates = {}
            }
            else {
                if (detailData.length > 0) {
                    var avgHard = maths
                        .round(maths.mean([...detailData.map((k) => k.DataValueHard)]), hdp)
                        .toFixed(3);
                    var minHard = maths
                        .round(maths.min([...detailData.map((k) => k.DataValueHard)]), hdp)
                        .toFixed(3);
                    var maxHard = maths
                        .round(maths.max([...detailData.map((k) => k.DataValueHard)]), hdp)
                        .toFixed(3);
                    var stdHardDeviation = maths
                        .round(maths.std([...detailData.map((k) => k.DataValueHard)]), 1)
                        .toFixed(1);
                    var rstdHardDeviation = Number(Number(stdHardDeviation) / Number(avgHard) * 100).toFixed(3);

                    var remarkHard = detailData.some((k) => Number(masterData.T2NegTolHard) > Number(k.DataValueHard) || Number(k.DataValueHard) > Number(masterData.T2PosTolHard));

                    remarkHard = remarkHard === true ? "Out of Limit" : "Within Limit";
                    if (detailData[0].DataValueHard == 0) remarkHard = 'NA'
                    var avgThick = maths
                        .round(maths.mean([...detailData.map((k) => k.DataValueThick)]), tdp)
                        .toFixed(3); //as per CR
                    var minThick = maths
                        .round(maths.min([...detailData.map((k) => k.DataValueThick)]), tdp)
                        .toFixed(3);
                    var maxThick = maths
                        .round(maths.max([...detailData.map((k) => k.DataValueThick)]), tdp)
                        .toFixed(3);
                    var stdThickDeviation = maths
                        .round(maths.std([...detailData.map((k) => k.DataValueThick)]), tdp)
                        .toFixed(tdp);
                    var rstdThickDeviation = Number(Number(stdThickDeviation) / Number(avgThick) * 100).toFixed(3);

                    var remarkThick = detailData.some((k) => Number(masterData.T2NegTolThick) > Number(k.DataValueThick) || Number(k.DataValueThick) > Number(masterData.T2PosTolThick));

                    remarkThick = remarkThick === true ? "Out of Limit" : "Within Limit";
                    if (detailData[0].DataValueThick == 0) remarkThick = 'NA'
                    var avgPara;
                    var minPara;
                    var maxPara;
                    var stdParaDeviation;
                    var rstdParaDeviation;
                    var remarkDiam = "";
                    var remarkBL = "";

                    // if (powerBackup.TableType === "Diameter") {
                    //     avgPara = maths
                    //         .round(maths.mean([...detailData.map((k) => k.DataValueDiam)]), 2)
                    //         .toFixed(2); //as per CR
                    //     minPara = maths
                    //         .round(maths.min([...detailData.map((k) => k.DataValueDiam)]), 2)
                    //         .toFixed(2);
                    //     maxPara = maths
                    //         .round(maths.max([...detailData.map((k) => k.DataValueDiam)]), 2)
                    //         .toFixed(2);
                    //     stdParaDeviation = maths
                    //         .round(maths.std([...detailData.map((k) => k.DataValueDiam)]), 3)
                    //         .toFixed(3);
                    //     rstdParaDeviation = Number(Number(stdParaDeviation) / Number(avgPara) * 100).toFixed(3);

                    //     remarkDiam = detailData.some((k) => Number(masterData.T3NegTolDiam) > Number(k.DataValueDiam) || Number(k.DataValueDiam) > Number(masterData.T3PosTolDiam));

                    //     remarkDiam = remarkDiam === true ? "Out of Limit" : "Within Limit";
                    //     if (detailData[0].DataValueBL == 0) remarkDiam = 'NA'

                    // } else {

                    avgPara = maths
                        .round(maths.mean([...detailData.map((k) => k.DataValueBL)]), 2)
                        .toFixed(3);
                    minPara = maths
                        .round(maths.min([...detailData.map((k) => k.DataValueBL)]), 2)
                        .toFixed(3);
                    maxPara = maths
                        .round(maths.max([...detailData.map((k) => k.DataValueBL)]), 2)
                        .toFixed(3);
                    stdParaDeviation = maths
                        .round(maths.std([...detailData.map((k) => k.DataValueBL)]), 3)
                        .toFixed(3);

                    remarkBL = detailData.some((k) => Number(masterData.T3NegTolBL) > Number(k.DataValueBL) || Number(k.DataValueBL) > Number(masterData.T3PosTolBL));

                    remarkBL = remarkBL === true ? "Out of Limit" : "Within Limit";
                    if (detailData[0].DataValueBL == 0) remarkBL = 'NA'
                    // }

                    await models.tbl_tab_masterhtd_incomplete.update(
                        {
                            AvgHard: avgHard,
                            AvgThick: avgThick,
                            AvgDiam: 0,
                            AvgBL: avgPara,
                            MinWeightHard: minHard,
                            MaxWeightHard: maxHard,
                            MinWeightThick: minThick,
                            MaxWeightThick: maxThick,
                            MinWeightDiam: 0,
                            MaxWeightDiam: 0,
                            MinWeightBL: minPara,
                            MaxWeightBL: maxPara,
                            StdDevHard: stdHardDeviation,
                            StdDevThick: stdThickDeviation,
                            StdDevDiam: 0,
                            StdDevBL: stdParaDeviation,
                            RemarkHard: remarkHard,
                            RemarkThick: remarkThick,
                            RemarkDiam: 'Null',
                            RemarkBL: remarkBL,
                        },
                        {
                            where: {
                                RepSerNo: repSerNo,
                            },
                        }
                    );

                    return {
                        repSerNo: repSerNo,
                        AvgHard: avgHard,
                        AvgThick: avgThick,
                        AvgDiam: 0,
                        AvgBL: avgPara,
                        MinWeightHard: minHard,
                        MaxWeightHard: maxHard,
                        MinWeightThick: minThick,
                        MaxWeightThick: maxThick,
                        MinWeightDiam: 0,
                        MaxWeightDiam: 0,
                        MinWeightBL: minPara,
                        MaxWeightBL: maxPara,
                        StdDevHard: stdHardDeviation,
                        StdDevThick: stdThickDeviation,
                        StdDevDiam: 0,
                        StdDevBL: stdParaDeviation,
                        RemarkHard: remarkHard,
                        RemarkThick: remarkThick,
                        RemarkDiam: 'Null',
                        RemarkBL: remarkBL,
                        rstdParaDeviation: rstdParaDeviation,
                        rstdThickDeviation: rstdThickDeviation,
                        rstdHardDeviation: rstdHardDeviation
                    }
                }

            }
        } catch (err) {
            throw new Error(err);
        }
    }

    async updateEndDate(strDsNo, strTableName, RepSerNo) {
        try {
            const updateThicknessEndTime = await models[strTableName].update(
                {
                    PrEndDate: moment().format("YYYY-MM-DD"),
                    PrEndTime: moment().format("HH:mm:ss"),
                },
                {
                    where: {
                        RepSerNo: RepSerNo,
                        DsNo: strDsNo,
                    },
                }
            );
            console.log(updateThicknessEndTime)
        } catch (error) {

        }
    }

    async calculatedCounter(repSerNo, side, detailTableIncomplete, isftp, cubicalData) {
        let whereCondition = { RepSerNo: repSerNo, Side: side, isCompleted: 0 }
        if (!isftp) { whereCondition.isException = 0, whereCondition.isTerminated = 0 }
        if (cubicalData.isPreStart == 1) delete whereCondition.isException;

        let entries = await models[detailTableIncomplete].findAll({ where: whereCondition })

        let lastRecNo = entries.length > 0 ? entries[entries.length - 1].RecSeqNo + 1 : 1;
        return lastRecNo;
    }
    calculation(detailData, unitObj, Instrumentmodels, reporttype) {
        try {
            var unitindividual
            var iavgDp = 3, istdDevDp = 3, idecPoint = 3, iminMaxDp = 3
            if (Instrumentmodels == 'Pharmatest' && reporttype == 0) {
                var menuname = GLOBAL_NOMENCLATURE.IndividualMenu
                unitindividual = this.getUnitObj(menuname)
                iavgDp = unitindividual.target, istdDevDp = unitindividual.target, iminMaxDp = unitindividual.target
            }
            var avgDp = 3, stdDevDp = 3, decPoint = 3, minMaxDp = 3
            if (unitObj == 'kp') {
                var haravgDp = 3, harstdDevDp = 3, hardecPoint = 3, harminMaxDp = 3
            } else {
                var haravgDp = 3, harstdDevDp = 3, hardecPoint = 3, harminMaxDp = 3
            }
            let avg, std_value, max_value, min_value, total;
            if (detailData.length > 0) {
                var hardarr = detailData.map(e => e.DataValueHard);
                var thickarr = detailData.map(e => e.DataValueThick);
                var balarr = detailData.map(e => e.DataValueBL);
                var hardmax_value = Number(maths.round(maths.max(hardarr), harminMaxDp)).toFixed(harminMaxDp);
                var hardmin_value = Number(maths.round(maths.min(hardarr), harminMaxDp)).toFixed(harminMaxDp);
                var hardavg = this.avgCalc(hardarr, haravgDp)
                var hardstd_value = Number(maths.round(maths.std(hardarr), harstdDevDp)).toFixed(harstdDevDp);
                var hardrsd_value = Number(hardstd_value) / Number(hardavg) * 100;
                var hardDiff = Number(maths.round((hardmax_value - hardmin_value), harminMaxDp)).toFixed(harminMaxDp);
                hardrsd_value = Number(maths.round(hardrsd_value, harstdDevDp)).toFixed(harstdDevDp)
                var hardtotal = hardarr.reduce((acc, total) => {
                    return Number(total) + Number(acc);
                }, 0);
                //
                var thickmax_value = Number(maths.round(maths.max(thickarr), minMaxDp)).toFixed(minMaxDp);
                var thickmin_value = Number(maths.round(maths.min(thickarr), minMaxDp)).toFixed(minMaxDp);
                var thickavg = this.avgCalc(thickarr, avgDp)
                var thickstd_value = Number(maths.round(maths.std(thickarr), stdDevDp)).toFixed(stdDevDp);
                var thickrsd_value = Number(thickstd_value) / Number(thickavg) * 100;
                var thickDiff = Number(maths.round((thickmax_value - thickmin_value), minMaxDp)).toFixed(minMaxDp);
                thickrsd_value = Number(maths.round(thickrsd_value, stdDevDp)).toFixed(stdDevDp)
                var thicktotal = thickarr.reduce((acc, total) => {
                    return Number(total) + Number(acc);
                }, 0);
                //
                if (Instrumentmodels == 'Pharmatest') {

                    var balmax_value = Number(maths.round(maths.max(balarr), iminMaxDp)).toFixed(iminMaxDp);
                    var balmin_value = Number(maths.round(maths.min(balarr), iminMaxDp)).toFixed(iminMaxDp);
                    var balavg = this.avgCalc(balarr, iavgDp)
                    var balstd_value = Number(maths.round(maths.std(balarr), istdDevDp)).toFixed(istdDevDp);
                    var balrsd_value = Number(balstd_value) / Number(balavg) * 100;
                    var balDiff = Number(maths.round((balmax_value - balmin_value), iminMaxDp)).toFixed(iminMaxDp);
                    balrsd_value = Number(maths.round(balrsd_value, istdDevDp)).toFixed(istdDevDp)
                }

                if (Instrumentmodels == 'Pharmatest' && reporttype == 0) {
                    var baltotal = balarr.reduce((acc, total) => {
                        return Number(total) + Number(acc);
                    }, 0);
                }
                // var minPer_value = ((Number(min_value) - Number(Nominal)) / Number(Nominal)) * 100;
                // minPer_value = Number(maths.round(minPer_value, minMaxPerDp)).toFixed(minMaxPerDp)

                // var maxPer_value = ((Number(max_value) - Number(Nominal)) / Number(Nominal)) * 100;
                // maxPer_value = Number(maths.round(maxPer_value, minMaxPerDp)).toFixed(minMaxPerDp)
            }

            let obj = {
                hardmax_value: hardmax_value,
                hardmin_value: hardmin_value,
                hardavg: hardavg,
                hardstd_value: hardstd_value,
                hardrsd_value: hardrsd_value,
                hardfinalSum: hardtotal,
                hardDiff: hardDiff,
                //
                thickmax_value: thickmax_value,
                thickmin_value: thickmin_value,
                thickavg: thickavg,
                thickstd_value: thickstd_value,
                thickrsd_value: thickrsd_value,
                thickfinalSum: thicktotal,
                thickDiff: thickDiff,
                //
                balmax_value: balmax_value,
                balmin_value: balmin_value,
                balavg: balavg,
                balstd_value: balstd_value,
                balrsd_value: balrsd_value == 'NaN' ? 0.000 : balrsd_value,
                balDiff: balDiff,
                balfinalSum: baltotal ? Number(maths.round(baltotal, decPoint)).toFixed(decPoint) : null,
            }

            return obj;

        } catch (err) {
            throw new Error(err)
        }
    }
    avgCalc(arr, avgDp) {
        try {
            let total = arr.reduce((acc, total) => {
                return Number(total) + Number(acc);
            }, 0);
            let avg = total / arr.length;
            avg = Number(maths.round(maths.abs(avg), avgDp)).toFixed(avgDp);

            return avg

        } catch (err) {
            throw new Error(err);
        }
    }
    getUnitObj(menuName) {
        try {
            let unitObj = {};
            // let minMaxPerDp, avgDp, stdDevDp, minMaxDp;

            switch (menuName) {
                case GLOBAL_NOMENCLATURE.IndividualMenu:
                case GLOBAL_NOMENCLATURE.GroupMenu:
                    unitObj.minMaxPerDp = 3;
                    unitObj.avgDp = 3;
                    unitObj.stdDevDp = 3;
                    unitObj.minMaxDp = 3;
                    unitObj.target = 3;
                    break;
                case GLOBAL_NOMENCLATURE.ThicknessMenu:
                case GLOBAL_NOMENCLATURE.LengthMenu:
                case GLOBAL_NOMENCLATURE.LockedLength:
                    unitObj.minMaxPerDp = 2;
                    unitObj.avgDp = 2;
                    unitObj.stdDevDp = 4;
                    unitObj.minMaxDp = 2;
                    unitObj.target = 3;
                    break;
                case GLOBAL_NOMENCLATURE.LODMenu:
                    unitObj.decPoint = 3;
                    unitObj.lodPerDp = 2;
                    unitObj.tempDp = 1;
                    unitObj.target = 3;
                    break;
            }

            // let unitObj = {
            //   minMaxPerDp: minMaxPerDp,
            //   avgDp: avgDp,
            //   stdDevDp: stdDevDp,
            //   minMaxDp: minMaxDp
            // }

            return unitObj
        } catch (error) {
            throw new Error(error)
        }
    }
    async processIndividualDataFTP(dataObj) {
        try {
            let objActivity = {};
            // let strHmi = dataObj.Hmi;
            let strDsNo = dataObj.DsNo;
            let strTabIp = dataObj.TabIp;
            let data = dataObj.data;
            let port = dataObj.protocolPort;
            const objSelMenu = globalData.arrSelectedMenu.find((k) => k.DsNo == strDsNo && k.TabIp == strTabIp);
            var Indidata = globalData.arr_limits.find((k) => k.DsNo == strDsNo && k.TabIp == strTabIp);
            var BLData = Indidata.Menus.Individual
            let Bdp = BLData.dp
            let indNom = BLData.Nom;
            let T2NegBL = BLData ? Number(BLData.T2Neg).toFixed(3) : null
            let T2PosBL = BLData ? Number(BLData.T2Pos).toFixed(3) : null
            let color = `white`
            let Bunit = 'g';
            let isftp = true;
            let mesData = [];
            var sample = objSelMenu.noOfSamples

            let tempUserObject = globalData.arrUsers.find((k) => k.DsNo == strDsNo && k.TabIp == strTabIp);
            let cubicObj = globalData.arrIdsInfo.find(k => k.DsNo == strDsNo).cubicalData;
            let cubicalInfo = globalData.arrIdsInfo.find(k => k.DsNo == strDsNo)
            var getTableName_ = objCommonWeightment.getTableName(cubicObj, 'Individual', strDsNo, strTabIp)

            var strTableName = getTableName_.masterTable
            var strDetailTbl = getTableName_.detailTable
            var typeValue = 1;
            let sideStatus;
            let RecNo = 0


            if (objSelMenu.Side === "LHS") sideStatus = 0
            else if (objSelMenu.Side === "RHS") sideStatus = 1
            else sideStatus = 2
            let exceptionTableName = 'tbl_exception_samplehtd_initial';
            let hmiDetailsInPMenu = globalData.arrIdsInfo.find(
                (k) => k.DsNo == strDsNo
            ).cubicalData;

            const __parameterHardness = {
                strTableName: strTableName,
                strDetailTbl: strDetailTbl,
                TabIp: strTabIp,
                ProtocolData: dataObj.data,
                strDsNo: strDsNo,
                objProductDetails: objSelMenu,
                SFOID: objSelMenu.SFOID,
                cal_data: dataObj.cal_data,
                LHSContainerNo: objSelMenu.LHSContainerNo,
                RHSContainerNo: objSelMenu.RHSContainerNo
            };

            var powerBackup = await models.tbl_powerbackup.findAll({
                where: {
                    Sys_CubType: hmiDetailsInPMenu.Sys_CubType,
                    Sys_BFGCode: hmiDetailsInPMenu.Sys_BFGCode,
                    Sys_Batch: hmiDetailsInPMenu.Sys_Batch,
                    MPN_Code: objSelMenu.MPN,
                    DsNo: strDsNo,
                    TabIp: strTabIp,
                    WeighmentName: objSelMenu.menuName,
                    Before_Count: sideStatus
                },
            });

            var counter = 1;
            if (sample >= counter) {
                if (counter == 1) {

                    var repSerNo = await this.saveDataIncompleteMasterIndividual(
                        __parameterHardness
                    );
                    repSerNo = repSerNo
                    // if (InstrumentData.Eqp_Make == 'Pharmatest') {
                    // var indRepsr = repSerNo.ind_Repsr
                    // }
                    let activity_msg = `Individual Test Started on DS ${strDsNo}`
                    activity_msg = (objSelMenu.Side == "NA") ? activity_msg : `${activity_msg} for side ${objSelMenu.Side}`;
                    Object.assign(
                        objActivity,
                        { strUserId: tempUserObject.UserId },
                        { strUserName: tempUserObject.UserName },
                        { batch: hmiDetailsInPMenu.Sys_Batch },
                        { activity: activity_msg }
                    );

                    await objActivityLog.ActivityLogEntry(objActivity);


                    await objInstrumentUsage.InstrumentUsage(
                        GLOBAL_NOMENCLATURE.MultiTester,
                        strDsNo,
                        "tbl_instrumentlog_hardness",
                        "Individual",
                        "started",
                        strTabIp,
                        tempUserObject,
                        cubicalInfo
                    );
                }

                let outFlag = false
                let outOfValueCount = 0;
                let newSampleCount = 0;
                var powerbackupexception = false
                var RecNo_ = 0
                var within_counter = 0
                // const sleep = (ms) => new Promise(resolve => setTimeout(resolve, ms));
                for (let ele of data) {
                    let isOutOfLimit = false
                    var Outoflimit3 = {}
                    color = 'White'
                    RecNo_ += 1;
                    ele.W.value = ele.W.value / 1000
                    RecNo = await this.calculatedCounter(repSerNo, objSelMenu.Side, getTableName_.detailTableIncomplete, isftp, cubicObj)
                    Outoflimit3 = await objCommonUseFunc.SendCommon1({ dsNo: strDsNo, actualWt: ele.W.value, minLimitT2: T2NegBL, maxLimitT2: T2PosBL, minLimitT1: undefined, maxLimitT1: undefined, strMenuName: mqttProtocol.HardnessMenu, sampleNo: counter, tabIp: strTabIp })

                    if (RecNo - 1 == sample) break

                    if (!(Outoflimit3.limit.includes('Within'))) {
                        await models.tbl_exception_sample_initial.create({
                            RepSerNo: repSerNo,
                            IDSNo: strDsNo,
                            // MstSerNo: 1,
                            DataValue: maths.round(ele.W.value, Bdp).toFixed(Bdp),
                            T1PosTol: T2PosBL,
                            T1NegTol: T2NegBL,
                            Repetition: objSelMenu.repetition,
                            // MenuName: GLOBAL_NOMENCLATURE.MultiTester,
                            DataValueUnit: Bunit,
                            DsNo: strDsNo,
                            TabIp: strTabIp,
                            MenuName: GLOBAL_NOMENCLATURE.IndividualMenu,
                            // TestDate: moment().format("YYYY-MM-DD"),
                            SFOID: objSelMenu.SFOID,
                            Area: hmiDetailsInPMenu.Sys_Area,
                            Area: hmiDetailsInPMenu.Sys_Area,
                            BFGCode: hmiDetailsInPMenu.Sys_BFGCode,
                            BatchNo: hmiDetailsInPMenu.Sys_Batch,
                            ProductName: hmiDetailsInPMenu.Sys_ProductName,
                            MachineCode: objSelMenu.EquipmentCode,
                            InstrumentId: hmiDetailsInPMenu.Sys_HardID,
                            ProductType: 1,
                            UserID: tempUserObject.UserId,
                            UserName: tempUserObject.UserName,
                            Side: objSelMenu.Side,
                            CubicalName: hmiDetailsInPMenu.Sys_CubicName,
                            SampleNo: RecNo_,
                            Remark: 'NA',
                            PrDate: moment().format("YYYY-MM-DD"),
                            prTime: moment().format("HH:mm:ss"),
                            isTerminated: 0,
                            Nominal: indNom
                        })
                        isOutOfLimit = true;
                        outFlag = true
                        color = `Orange`
                        outOfValueCount = outOfValueCount + 1
                    }

                    // sample = sample + 1;
                    if (outFlag) {
                        var limit = 'Out Of Limit';
                        if (outOfValueCount == 1) {
                            mqttSender.sendData(strDsNo, `Port ${port}:${mqttProtocol.DisplayMessage}${limit}`);
                        }
                        setTimeout(() => { }, 1000)
                        // await sleep(1000);


                    } else {
                        isOutOfLimit = false

                    }


                    if (Outoflimit3.limit.includes('Within')) {
                        if (within_counter < sample) {
                            const insertDetail = await models[getTableName_.detailTableIncomplete].create({
                                RepSerNo: repSerNo,
                                MstSerNo: 1,
                                RecSeqNo: RecNo,
                                DataValue: maths.round(ele.W.value, Bdp).toFixed(Bdp),
                                DataValueUnit: Bunit == undefined ? 'g' : Bunit,
                                DP: Bdp,
                                UserID: tempUserObject.UserId,
                                UserName: tempUserObject.UserName,
                                Side: objSelMenu.Side,
                                PrDate: moment().format("YYYY-MM-DD"),
                                PrTime: moment().format("HH:mm:ss"),
                                PrEndDate: moment().format("YYYY-MM-DD"),
                                PrEndTime: moment().format("HH:mm:ss"),
                                BFGCode: "NA",
                                ProductName: cubicObj.Sys_ProductName,
                                PVersion: cubicObj.Sys_PVersion,
                                Version: cubicObj.Sys_Version,
                                BatchNo: cubicObj.Sys_Batch,
                                BalanceId: cubicObj.Sys_BalID,
                                isException: isOutOfLimit ? 1 : 0,
                            });
                            within_counter = within_counter + 1
                            // await sleep(1000);
                            setTimeout(() => { }, 1000)
                        }
                        mesData.push(ele)
                    }

                    mqttSender.sendData(
                        strDsNo,
                        `Port ${port}:${mqttProtocol.DisplayResult}${RecNo}:${(maths.round(ele.W.value, Bdp).toFixed(Bdp))} ${Bunit}:${color}`
                    );
                    await objMonit.monit({
                        case: 'TestWeight',
                        Hmi: strDsNo,
                        data: {
                            Weight: ele.W.value,
                            srNo: RecNo,
                            message: limit
                        }
                    });
                    counter = counter + 1
                    newSampleCount = newSampleCount + 1;
                    if (isOutOfLimit == true) {
                        powerbackupexception = isOutOfLimit
                    }

                }
            }

            console.log("Individual Within Counter : --------->", within_counter);
            if (powerbackupexception == true) {
                await models.tbl_powerbackup.create({
                    Sys_CubType: hmiDetailsInPMenu.Sys_CubType,
                    Sys_BFGCode: hmiDetailsInPMenu.Sys_BFGCode,
                    Sys_Batch: hmiDetailsInPMenu.Sys_Batch,
                    CubicalNo: hmiDetailsInPMenu.Sys_CubicNo,
                    DsNo: strDsNo,
                    TabIp: strTabIp,
                    WeighmentName: objSelMenu.menuName,
                    Incomp_RepSerNo: repSerNo,
                    Before_Count: sideStatus,
                    ReportType: hmiDetailsInPMenu.Sys_RptType,
                    Userid: tempUserObject.UserId,
                    TableType: objSelMenu.Side,
                    WeighmentType: 1,
                    ProductType: 1,
                    MPN_Code: objSelMenu.MPN,
                    isException: 1
                })
            }
            if (within_counter != sample) {
                await models[getTableName_.detailTableIncomplete].update({ isCompleted: 1 }, { where: { RepSerNo: repSerNo } })
                await models.tbl_exception_sample_initial.update({ isTerminated: 1 }, { where: { RepSerNo: repSerNo } })
                mqttSender.sendData(strDsNo, `Port ${port}:${mqttProtocol.TestCompleted} Invalid Samples, Please Perform the Test Again:OkBtn true`)

                await objMonit.monit({
                    case: 'ReportStatus', Hmi: strDsNo, data: {
                        message: 'Invalid Samples, Please Perform the Test Again'
                    }
                }); return
            }

            if (within_counter <= sample) {
                await models.tbl_tab_initialmaster_incomplete.update(
                    {
                        Param1_PrEndTime: moment().format('HH:mm:ss'),
                        Param1_PrEndDate: moment().format('YYYY-MM-DD'),
                        PrEndDate: moment().format('YYYY-MM-DD'),
                        PrEndTime: moment().format('YYYY-MM-DD')
                    }, {
                    where: {
                        RepSerNo: repSerNo
                    }
                })
                var detailData = await models[getTableName_.detailTableIncomplete].findAll({ where: { RepSerNo: repSerNo, isException: 0 } });
                if (detailData.length != 0) {
                    let result_ = this.indvidualCalculation(detailData, GLOBAL_NOMENCLATURE.IndividualMenu);
                    // For FTP powerbackup is not there so passing undefined
                    const testInfo = await this.indUpdatemasterTable(repSerNo, undefined, strDsNo, strTabIp, getTableName_, isftp, result_);
                    let count = await objCommonInsertOpt.updateMenuSequenceEntry(strDsNo, strTabIp, "Individual", repSerNo, getTableName_.masterTableIncomplete, getTableName_.masterTable, cubicObj, port, objSelMenu.Side, 'NA', 'Report Within Limit')
                }
            }

            globalData.hardnessClient[0].IsIndividual = false
            globalData.hardnessClient[0].isAvailable = false;
            let activity_msg = `Individual Test Completed on DS ${strDsNo}`
            activity_msg = (objSelMenu.Side == "NA") ? activity_msg : `${activity_msg} for side ${objSelMenu.Side}`;
            Object.assign(
                objActivity,
                { strUserId: tempUserObject.UserId },
                { strUserName: tempUserObject.UserName },
                { batch: hmiDetailsInPMenu.Sys_Batch },
                { activity: activity_msg }
            );

            await objActivityLog.ActivityLogEntry(objActivity);

            await objInstrumentUsage.InstrumentUsage(
                GLOBAL_NOMENCLATURE.MultiTester,
                strDsNo,
                "tbl_instrumentlog_hardness",
                "Individual",
                "completed",
                strTabIp,
                tempUserObject,
                cubicalInfo
            );

            await objMonit.monit({
                case: 'ReportStatus', Hmi: strDsNo, data: {
                    message: 'Individual Test Completed'
                }
            });
            globalData.arrCurrentOperationStatus.findIndex(
                (element) => element.DsNo === strDsNo
            ) == -1
                ? globalData.arrCurrentOperationStatus
                : globalData.arrCurrentOperationStatus.splice(
                    globalData.arrCurrentOperationStatus.findIndex(
                        (element) => element.DsNo === strDsNo
                    ),
                    1
                );

            globalData.arrSelectedMenu.findIndex((k) => k.DsNo == strDsNo && k.TabIp == strTabIp) == -1
                ? globalData.arrSelectedMenu
                : globalData.arrSelectedMenu.splice(
                    globalData.arrSelectedMenu.findIndex((k) => k.DsNo == strDsNo && k.TabIp == strTabIp),
                    1
                );
            return

        } catch (error) {
            throw new Error(error);
        }


    }
    async saveDataIncompleteMasterIndividual(dataObj) {
        try {
            console.log(dataObj)
            let now = new Date();
            let SFOID = dataObj.SFOID;
            let strDsNo = dataObj.strDsNo;
            let strTabIp = dataObj.TabIp;
            let side = dataObj.objProductDetails.Side;
            let objProductDetails = dataObj.objProductDetails
            let cubicalObj = globalData.arrIdsInfo.find(k => k.DsNo == strDsNo).cubicalData; //selected




            let hmiDetailsInPMenu = globalData.arrIdsInfo.find(k => k.DsNo == strDsNo).cubicalData;

            let productDetail = globalData.arrProductTypeArray.find(k => k.DsNo == strDsNo)
            let users = globalData.arrUsers.find(k => k.DsNo == strDsNo && k.TabIp == strTabIp)
            let menuDetail = globalData.arrSelectedMenu.find(k => k.DsNo == strDsNo && k.TabIp == strTabIp)

            var unitBal = 'NA'
            var T2pos = 'NA'
            var T2neg = 'NA'
            var IndNom = 0;

            IndNom = productDetail.productDetail.Param1_Nom;
            unitBal = productDetail.productDetail.Param1_Unit
            T2pos = productDetail.productDetail.Param1_T2Pos;
            T2neg = productDetail.productDetail.Param1_T2Neg


            if (hmiDetailsInPMenu.Sys_RptType != undefined) {
                let repSerNo;
                let menuFlag = await models.tbl_menu_sequence.findAll({
                    where: {
                        TabIp: strTabIp,
                        Ds_Number: strDsNo,
                    }
                })

                const equipmentData = await models.tbl_machine.findOne({
                    attributes: ['Machine_Punches'],
                    where: { Machine_ID: hmiDetailsInPMenu.Sys_MachineCode }
                })

                let mastSerNo = await check_srNO.check_master_SRno1({ cubicObj: cubicalObj, masterTable: 'tbl_tab_initialmaster', DsNo: strDsNo, masterTableIncomplete: 'tbl_tab_initialmaster_incomplete' })


                if (menuFlag.length > 0 && menuFlag[0].IND == 0 && menuFlag[0].RepSerNo != 0) {
                    await models.tbl_tab_initialmaster_incomplete.update(
                        {
                            Param1_PrTime: moment().format('HH:mm:ss'),
                            Param1_PrDate: moment().format('YYYY-MM-DD'),
                            Param1_T2NegTol: T2neg,
                            Param1_T2PosTol: T2pos,
                            Param1_Nom: IndNom,
                            Param1_Unit: unitBal,
                            PrDate: moment().format("YYYY-MM-DD"),
                            PrTime: moment().format("HH:mm:ss"),
                            HardnessID: (hmiDetailsInPMenu.Sys_HardID == 'None') ? 'NA' : hmiDetailsInPMenu.Sys_HardID,
                        }, {
                        where: {
                            RepSerNo: menuFlag[0].RepSerNo
                        }
                    })

                    repSerNo = menuFlag[0].RepSerNo

                } else {
                    let mstEntry = await models.tbl_tab_initialmaster_incomplete.create({
                        MstSerNo: mastSerNo,
                        CubicalNo: hmiDetailsInPMenu.Sys_CubicNo,
                        CubicalName: hmiDetailsInPMenu.Sys_CubicName,
                        CubicalType: hmiDetailsInPMenu.Sys_CubType,
                        ProductName: productDetail.productDetail.ProductName,
                        BFGCode: productDetail.productDetail.ProductId,
                        MPN_Code: objProductDetails.MPN,
                        SFOID: SFOID,
                        ProductType: productDetail.productType.ProductType,
                        Area: hmiDetailsInPMenu.Sys_Area,
                        MachineCode: objProductDetails.EquipmentCode,
                        NoOfStations: equipmentData.Machine_Punches,
                        PVersion: hmiDetailsInPMenu.Sys_PVersion,
                        Version: hmiDetailsInPMenu.Sys_Version,
                        BatchNo: hmiDetailsInPMenu.Sys_Batch,
                        BFGCode: hmiDetailsInPMenu.Sys_BFGCode,
                        Param1_T2NegTol: T2neg,
                        Param1_T2PosTol: T2pos,
                        Param1_Unit: unitBal,
                        Param1_Nom: IndNom,
                        Param1_MaxWeight: "",
                        Param1_MinWeight: "",
                        Param1_AvgNet: "",
                        Param1_StdDev: "",
                        Param1_RStdDev: "",
                        DsNo: strDsNo,
                        TabIp: strTabIp,
                        ProducatName: hmiDetailsInPMenu.Sys_ProductName,
                        UserId: users.UserId,
                        UserName: users.UserName,
                        Idsno: hmiDetailsInPMenu.Sys_DSNumber,
                        Side: objProductDetails.Side,
                        ReportType: objProductDetails.testType,
                        Qty: objProductDetails.noOfSamples,
                        GrpQty: objProductDetails.groupQty,
                        Repetition: hmiDetailsInPMenu.Sys_Repetition,

                        // VernierId: (hmiDetailsInPMenu.Sys_VernierID == 'None') ? 'NA' : hmiDetailsInPMenu.Sys_VernierID,
                        // FriabilityID: (hmiDetailsInPMenu.Sys_FriabID == 'None') ? 'NA' : hmiDetailsInPMenu.Sys_FriabID,
                        HardnessID: (hmiDetailsInPMenu.Sys_HardID == 'None') ? 'NA' : hmiDetailsInPMenu.Sys_HardID,
                        // DTID: (hmiDetailsInPMenu.Sys_DTID == 'None') ? 'NA' : hmiDetailsInPMenu.Sys_DTID,
                        IntervalStartTm: moment().format('YYYY-MM-DD HH:mm:ss'),
                        PrDate: moment().format("YYYY-MM-DD"),
                        PrTime: moment().format("HH:mm:ss"),
                        Side: hmiDetailsInPMenu.Sys_RotaryType,
                        LHSContainerNo: dataObj.LHSContainerNo,
                        RHSContainerNo: dataObj.RHSContainerNo,
                        MesTestType: hmiDetailsInPMenu.MesTestType,
                        MesSide: hmiDetailsInPMenu.MesSide,

                    })
                    repSerNo = mstEntry.RepSerNo;

                    await models.tbl_menu_sequence.update(
                        {
                            RepSerNo: repSerNo
                        }, {
                        where: {
                            TabIp: strTabIp,
                            Ds_Number: strDsNo,
                        }
                    })
                }

                return repSerNo;

            } else {
                var obj = {}
                return obj;
            }
        } catch (error) {
            throw new Error(error);
        }
    }
    indvidualCalculation(detailData, menuname) {
        try {
            let avgDp = 3, stdDevDp = 3, decPoint = 3, minMaxDp = 3
            let avg, std_value, max_value, min_value, total;
            if (detailData.length > 0) {
                var balarr = detailData.map(e => e.DataValue);
                var balmax_value = Number(maths.round(maths.max(balarr), minMaxDp)).toFixed(decPoint);
                var balmin_value = Number(maths.round(maths.min(balarr), minMaxDp)).toFixed(decPoint);
                var balavg = this.avgCalc(balarr, avgDp)
                var balstd_value = Number(maths.round(maths.std(balarr), stdDevDp)).toFixed(stdDevDp);
                var balrsd_value = Number(balstd_value) / Number(balavg) * 100;
                var balDiff = Number(maths.round((balmax_value - balmin_value), minMaxDp)).toFixed(decPoint);
                balrsd_value = Number(maths.round(balrsd_value, stdDevDp)).toFixed(stdDevDp)
                var baltotal = balarr.reduce((acc, total) => {
                    return Number(total) + Number(acc);
                }, 0);
            }

            let obj = {
                balmax_value: balmax_value,
                balmin_value: balmin_value,
                balavg: balavg,
                balstd_value: balstd_value,
                balrsd_value: balrsd_value,
                balDiff: balDiff,
                balfinalSum: Number(maths.round(baltotal, decPoint)).toFixed(decPoint),
            }

            return obj;

        } catch (err) {
            throw new Error(err)
        }
    }
    async indUpdatemasterTable(repSerNo, powerBackup, DsNo, strTabIp, tableNames, isftp, result_) {
        try {

            let menuDetail = globalData.arr_limits.find((k) => k.DsNo == DsNo && k.TabIp == strTabIp);
            let hardmenu = menuDetail.Menus.Hardness

            let cubicObj = globalData.arrIdsInfo.find(k => k.DsNo == DsNo && k.TabIp == strTabIp).cubicalData;
            var masterData = await models[tableNames.masterTableIncomplete].findOne({
                where: {
                    RepSerNo: repSerNo,
                },
            });

            let whereCondition = { RepSerNo: repSerNo, isException: 0 }
            // if(!isftp) { whereCondition.isException = 0 }
            var detailData = await models[tableNames.detailTableIncomplete].findAll({ where: whereCondition });
            await models.tbl_tab_initialmaster_incomplete.update(
                {
                    // Param1_PrTime: moment().format('HH:mm:ss'),
                    // Param1_PrDate: moment().format('YYYY-MM-DD'),
                    Param1_PrEndTime: moment().format('HH:mm:ss'),
                    Param1_PrEndDate: moment().format('YYYY-MM-DD'),
                    Param1_MaxWeight: result_.balmax_value,
                    Param1_MinWeight: result_.balmin_value,
                    Param1_AvgNet: result_.balavg,
                    Param1_StdDev: result_.balstd_value,
                    Param1_RStdDev: result_.balrsd_value,
                    Param1_TotalWeight: result_.balfinalSum,
                    Param1_Diff: result_.balDiff,

                }, {
                where: {
                    RepSerNo: repSerNo
                }
            });

        } catch (err) {
            throw new Error(err);
        }
    }
}

module.exports = HardnessModel;