const globalData = require("../../global/globalData");
const clsCommonInsertOpt = require("../Product/clsCommonInsertOperation.model");
const clsIncompleteReport = require("../Product/clsIncompleteReport");
const clsActivityLog = require("../clsActivityLog.model");
const clsInstrumentUsage = require("../clsInstrumentUsageLog");
const FormulaFunModel = require("../Product/clsformulaFun.model");
const GLOBAL_NOMENCLATURE = require("../../global/Global_Nomenclature");
const mqttProtocol = require("../../global/GLOBAL_NOMENCLATURE");
const MqttModel = require("../Mqtt/mqttSender.class");
const Database = require("../../database/clsQueryProcess");
const utillDb = require("../../Utills/db");
const clsProObj = require("../Product/clsProductDetailModel");
const date = require("date-and-time");
const clsBatchSummary = require("../Product/clsBatchSummaryOperation");
const { models } = require("../../../config/dbConnection");
const sequelize = require("../../../config/dbConnection").sequelize;
const { QueryTypes, where } = require("sequelize");
const moment = require('moment');
const { Json } = require("sequelize/lib/utils");
const clsMonit = require("../MonitorSocket/clsMonitSocket");
const objMonit = new clsMonit();

const database = new Database();
const objIncompleteReport = new clsIncompleteReport();
const objCommonInsertOpt = new clsCommonInsertOpt();
const objActivityLog = new clsActivityLog();
const objInstrumentUsage = new clsInstrumentUsage();
const objformulaFun = new FormulaFunModel();
const mqttSender = new MqttModel();
const proObj = new clsProObj();
const objBatchSummary = new clsBatchSummary();

// const OPCops = require("../OPC/opcOps");
// const objOPCops = new OPCops();

class LEAK {
    /**
     * sample is not their in LOD
     * @description LOD Data Come here
     * @param {*} IdsNo
     * @param {*} protocol
     */


    async insertBulkWeighmentLeak(dataObj) {
        try {
            // let dsNo = dataObj.DsNo;
            let cubicObj = dataObj.cubicObjData.cubicalData;
            // const tempUserObject = globalData.arrUsers.find(k => k.DsNo == dsNo);
            let getProductType = await models.tbl_product_master.findOne({ where: { ProductId: cubicObj.Sys_BFGCode, ProductName: cubicObj.Sys_ProductName } })
            if (getProductType) { cubicObj.ProductType = getProductType.ProductType };
            // dataObj.UserData = tempUserObject;
            // dataObj.cubicObj = cubicObj;
            // dataObj.cubicObjData = cubicObjData
            await this.saveLeakData(dataObj);

        } catch (err) {
            throw new Error(err)
        }
    }

    async saveLeakData(dataObj) {
        try {
            let dsNo = dataObj.DsNo;
            let tabIp = dataObj.TabIp;
            // let selectedMenuDetails = dataObj.SelectedMenuDetails
            let { stringObj, UserData, cubicObjData, menuName, ProtocolPortNo, SelectedMenuDetails } = dataObj
            // let productType = cubicObj.ProductType;
            let cubicObj = cubicObjData.cubicalData;

            let layer = 'NA';
            let layerName = 'NA';
            //   let lodPerDp = dataObj.unitObj.lodPerDp
            //   let tempDp = dataObj.unitObj.tempDp
            // let lodData = globalData.arrProtocolData.find(k => k.DsNo == dsNo);

            const batchResult = await models.tbl_leakedtest_master.findAll({
                attributes: [
                    [sequelize.fn('max', sequelize.col('MstSerNo')), 'MstSerNo'],
                ],
                where: {
                    MPN_Code: cubicObj.Sys_MPNCode,
                    // ProductName: cubicObj.Sys_ProductName,
                    BatchNo: cubicObj.Sys_Batch,
                    ReportType: cubicObj.Sys_RptType,
                    DsNo: dsNo,
                    // IPQCType: cubicObj.Sys_IPQCType,
                }
            })

            let mstSerNo = 1;
            if (batchResult[0]) {
                mstSerNo = (batchResult[0].MstSerNo == null) ? 1 : batchResult[0].MstSerNo + 1
            }

            let activityStrt_msg = `${menuName} Started on DS ${dsNo}`
            let __activityObjStrt = {
                strUserId: UserData.UserId,
                strUserName: UserData.UserName,
                activity: activityStrt_msg,
                batch: cubicObj.Sys_Batch,
            };
            await objActivityLog.ActivityLogEntry(__activityObjStrt);
            await objInstrumentUsage.InstrumentUsage(
                GLOBAL_NOMENCLATURE.LeakTester,
                dsNo,
                `tbl_instrumentlog_lt`,
                menuName,
                "started",
                tabIp,
                UserData,
                cubicObjData,
                // stringObj.productName,
                cubicObj.Sys_ProductName
            );
            const arrSelectedMenu = globalData.arrSelectedMenu.find(k => k.DsNo == dsNo && k.TabIp == tabIp);

            let leakObj1 = await models.tbl_otherequipment.findOne({
                where: {
                    Eqp_ID: cubicObj.Sys_LeakID
                }
            })

            if (stringObj.testStatus != 'Aborted') {



                var saveLeakData = await models.tbl_leakedtest_master.create({
                    MstSerNo: mstSerNo,
                    Test_Seq: mstSerNo,
                    Area: cubicObj.Sys_Area,
                    Dept: cubicObj.Sys_dept,
                    CubicalNo: cubicObj.Sys_CubicNo,
                    CubicleName: cubicObj.Sys_CubicName,
                    CubicleType: cubicObj.Sys_CubType,
                    // ProductType: cubicObj.ProductType,
                    ProductType: 1,
                    MPN_Code: cubicObj.Sys_MPNCode,
                    BFGCode: cubicObj.Sys_BFGCode,
                    ProductName: cubicObj.Sys_ProductName,
                    PVersion: cubicObj.Sys_PVersion,
                    Version: cubicObj.Sys_Version,
                    SFOID: cubicObj.Sys_SFOID,
                    BatchNo: cubicObj.Sys_Batch,
                    BMRNo: cubicObj.Sys_BMRNo,
                    isManual: cubicObj.isManual,
                    ReportType: cubicObj.Sys_RptType,
                    Layer: layer,
                    UserId: UserData.UserId,
                    UserName: UserData.UserName,
                    IsArchived: 0,

                    PrEndDate: moment().format('YYYY-MM-DD'),
                    PrEndTime: moment().format('HH:mm:ss'),
                    // MinLimit: '',
                    // MaxLimit: '',
                    LeakTestID: SelectedMenuDetails.instrumentId,
                    BatchStatus: SelectedMenuDetails.batchStatus,
                    Make: dataObj.instrumentMake,
                    // PrDate: moment(stringObj.startDate, 'DD/MM/YYYY').format('YYYY-MM-DD'),
                    // PrTime: moment(stringObj.startTime, 'HH:mm:ss').format('HH:mm:ss'),

                    PrDate: moment().format('YYYY-MM-DD'),
                    PrTime: moment().format('HH:mm:ss'),

                    Model: stringObj.modelNo,
                    SerialNo: leakObj1.Eqp_SerialNo,
                    TestID: stringObj.testId,
                    EORTVacLevel: stringObj.EORT_vacuum_level,
                    EORTVacLevelUnit: stringObj.EORT_vacuum_level_unit,
                    VacBuildTm: stringObj.vaccumeBuildTm,
                    VacReleaseTm: stringObj.vaccumeReleaseTm,
                    NoOfPackages: stringObj.noOfPackage,
                    VacRetentionTm: stringObj.vaccumeRetentionTm,
                    MtdName: stringObj.methodName,
                    VacLevel: stringObj.vaccumeLevel,
                    VacLevelUnit: stringObj.vaccumeLevel_unit,
                    VacPenetrationTm: stringObj.vaccumePenetrationTm,
                    DesicatorSize: stringObj.desicatorSize,
                    PackageType: stringObj.packageType,
                    DosageUnit: stringObj.dosageUnit,
                    DosageForm: stringObj.dosageForm,
                    Remark: stringObj.result,
                    Limit: stringObj.limit,
                    LimitUnit: stringObj.limit_unit,
                    TestStatus: stringObj.testStatus,
                    GroupName: stringObj.groupName,
                    ProductDescription: stringObj.ProductDescription,
                    // ProductName: stringObj.productName,
                    ProductName: cubicObj.Sys_ProductName,
                    // Unit: '',
                    // DecimalPoint: '',
                    BatchComplete: 0,
                    // CheckedByID: '',
                    // CheckedByName: '',
                    // CheckedByDate: '',
                    // Inprocess: '',
                    LayerName: layerName,
                    WgmtModeNo: "20",
                    // FailedRemark: '',
                    // CheckedByTime: '',
                    // ModeOfWgmt: '',
                    DsNo: dsNo,
                    TabIp: tabIp,
                    isTestCompleted: (dataObj.isTestAborted) ? 0 : 1
                })


                const leakObj = await models.tbl_leakedtest_master.findAll({
                    where: {
                        MstSerNo: mstSerNo,
                    }
                })


                let activity_msg = `${menuName} ${stringObj.testStatus} on DS ${dsNo}`
                let __activityObj = {
                    strUserId: UserData.UserId,
                    strUserName: UserData.UserName,
                    activity: activity_msg,
                    batch: cubicObj.Sys_Batch
                };
                await objActivityLog.ActivityLogEntry(__activityObj);

                mqttSender.sendData(
                    dsNo, `Port ${ProtocolPortNo}:${mqttProtocol.DisplayResult}${JSON.stringify([stringObj])}`
                );

                mqttSender.sendData(
                    dsNo,
                    `Port ${ProtocolPortNo}:${GLOBAL_NOMENCLATURE.TestCompleted} Test ${stringObj.testStatus}:OkBtn true`
                );

                let mesData = globalData.MESArray.filter(e => e.menuName == menuName && e.dsNo == dsNo && e.portNo == ProtocolPortNo)
                if (cubicObj.isManual == 0) {
                    let data = { menuName: menuName, payload: { data: saveLeakData.dataValues }, DsNo: dsNo, tabIp: tabIp, portNo: ProtocolPortNo, isCompleted: true, isPosted: false, Area: cubicObj.Sys_Area, RepSerNo: leakObj[leakObj.length - 1].RepSerNo }
                    globalData.MESArray.push(data)
                    mesData = globalData.MESArray.filter(e => e.menuName == menuName && e.dsNo == dsNo && e.portNo == ProtocolPortNo)
                    mqttSender.sendData(dsNo, `Port ${ProtocolPortNo}:${GLOBAL_NOMENCLATURE.DisplayMessage} ${GLOBAL_NOMENCLATURE.PostingToMES}`)
                }

                await objInstrumentUsage.InstrumentUsage(
                    GLOBAL_NOMENCLATURE.LeakTester,
                    dsNo,
                    `tbl_instrumentlog_lt`,
                    menuName,
                    "completed",
                    tabIp,
                    UserData,
                    cubicObjData,
                    // stringObj.productName
                    cubicObj.Sys_ProductName
                );

                await objMonit.monit({
                    case: 'TestWeight',
                    Hmi: dsNo,
                    data: {
                        Weight: `${JSON.stringify([stringObj])}`,
                        srNo: 1,
                        message: 'Leak Test Completed'
                    }
                });
                await objMonit.monit({
                    case: 'ReportStatus', Hmi: dsNo, data: {
                        message: `${menuName} Test Completed`
                    }
                });

                globalData.arrCurrentOperationStatus.findIndex((k) => k.DsNo == dsNo && k.TabIp == tabIp) == -1
                    ? globalData.arrCurrentOperationStatus
                    : globalData.arrCurrentOperationStatus.splice(
                        globalData.arrCurrentOperationStatus.findIndex((k) => k.DsNo == dsNo && k.TabIp == tabIp),
                        1
                    );

                globalData.arrSelectedMenu.findIndex((k) => k.DsNo == dsNo && k.TabIp == tabIp) == -1
                    ? globalData.arrSelectedMenu
                    : globalData.arrSelectedMenu.splice(
                        globalData.arrSelectedMenu.findIndex((k) => k.DsNo == dsNo && k.TabIp == tabIp),
                        1
                    );

            } else {
                let activityStrt_msg = `${menuName} Aborted string recieved on DS ${dsNo}`
                let __activityObjStrt = {
                    strUserId: UserData.UserId,
                    strUserName: UserData.UserName,
                    activity: activityStrt_msg,
                    batch: cubicObj.Sys_Batch,
                };
                await objActivityLog.ActivityLogEntry(__activityObjStrt);
                mqttSender.sendData(
                    dsNo,
                    `Port ${ProtocolPortNo}:${GLOBAL_NOMENCLATURE.DisplayMessage} Invalid String recieved :OkBtn false`
                );
            }
            (globalData.arrProtocolData.findIndex((element) => element.DsNo === dsNo)) == -1 ?
                globalData.arrProtocolData :
                globalData.arrProtocolData.splice(globalData.arrProtocolData.findIndex((element) => element.DsNo === dsNo), 1);






        } catch (err) {
            throw new Error(err)
        }
    }
}
module.exports = LEAK;
