const date = require('date-and-time');

const globalData = require('../../global/globalData')
const clsActivityLog = require('../clsActivityLog.model');
const clsInstrumentUsage = require('../clsInstrumentUsageLog');
const clsCommonInsertOpt = require('../Product/clsCommonInsertOperation.model');
const clsMqttSender = require('../Mqtt/mqttSender.class');
const FormulaFunModel = require('../Product/clsformulaFun.model');
const GLOBAL_NOMENCLATURE = require('../../global/GLOBAL_NOMENCLATURE');
const clsCommonUseFunction = require('../clsCommonUseFunction');
const PowerBackup = require('../../Utills/powerBackUp/powerbackup');
const models = require('../../../config/dbConnection').models;
const clsCalculation = require('../clsCalculationOperation');

const objActivityLog = new clsActivityLog();
const objInstrumentUsage = new clsInstrumentUsage();
const objCommonInsertOpt = new clsCommonInsertOpt();
const mqttSender = new clsMqttSender();
const objformulaFun = new FormulaFunModel();
const objCommonUseFunc = new clsCommonUseFunction();
const objPowerBackup = new PowerBackup();
const objcalc = new clsCalculation();


class VernierModel {

    async processVernierData(dataObj) {
        try {
            let objActivity = {};
            let typeValue;
            let __parameterVernier;
            const strHmi = dataObj.Hmi;
            const strIdsNo = dataObj.idsNo;
            const menuName = dataObj.menuName;
            let actualWt = dataObj.actualWt;

            var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strIdsNo);
            let SelectedIdsNo = (IPQCObject) ? IPQCObject.selectedIds : strHmi;
            const objSelMenu = globalData.arrSelectedMenu.find(k => k.idsNo == strIdsNo);
            let intProductType = objSelMenu.selectedProductDetail.ProductType;
            const VernierDetail = globalData.arrWeighmentProductData.find(k => k.Hmi == strHmi);
            let sample = parseFloat(VernierDetail.data.noOfSample);
            let batchNo = VernierDetail.data.Batch;
            let tempCounterObj = globalData.arrWeighmentCounter.find(k => k.Hmi == strHmi);
            let tempUserObject = globalData.arrUsers.find(k => k.Hmi === strHmi);
            let tableName = "tbl_powerbackup";
            let _cubicalData = globalData.arrIdsInfo.find(k => k.idsNo == strIdsNo).cubicalData;
            if (!tempCounterObj) globalData.arrWeighmentCounter.push({ 'Hmi': strHmi, 'counter': 0 })
            tempCounterObj = globalData.arrWeighmentCounter.find(k => k.Hmi == strHmi);
            var Side = VernierDetail.data.Side

            switch (menuName) {
                case GLOBAL_NOMENCLATURE.ThicknessMenu:
                    typeValue = 3;
                    break;
                case GLOBAL_NOMENCLATURE.BreadthMenu:
                    typeValue = 4;
                    break;
                case GLOBAL_NOMENCLATURE.DiameterMenu:
                    typeValue = 6;
                    break
                case GLOBAL_NOMENCLATURE.LengthMenu:
                    typeValue = 5;
                    break
            }
            let strTableName = `tbl_tab_master${typeValue}`;
            let strDetailTbl = `tbl_tab_detail${typeValue}`;
            let maxLimitT1 = 0, minLimitT1 = 0;
            let maxLimitT2 = objSelMenu.selectedProductDetail.T2Pos;
            let minLimitT2 = objSelMenu.selectedProductDetail.T2Neg;

            const __ParamRemark = {
                idsNo: strIdsNo,
                menuName: menuName,
                batchNo: batchNo,
                tableName: strTableName,
            }

            if (sample >= tempCounterObj.counter) {
                tempCounterObj.counter += 1;
                __parameterVernier = {
                    strTableName: strTableName,
                    strDetailTbl: strDetailTbl,
                    objProductDetails: VernierDetail.data,
                    uniqueSerialNumber: strIdsNo,
                    strBalId: dataObj.instrumentId,
                    ProtocolData: dataObj.actualWt,
                    ProtocolUnit: dataObj.unit,
                    ProtocolDecPoint: dataObj.decPoint,
                    StdDevDp: dataObj.StdDevDp,
                    avgDp: dataObj.avgDp,
                    minMaxDp: dataObj.minMaxDp,
                    strHmi: strHmi,
                    seqNoOfWt: tempCounterObj.counter,
                    productType: objSelMenu.selectedProductDetail
                }

                var powerbackupobj = {
                    strTableName: strTableName,
                    strDetailTbl: strDetailTbl,
                    cubicaNo: _cubicalData.Sys_CubicNo,
                    cubicType: _cubicalData.Sys_CubType,
                    cubicSysBFGcode: _cubicalData.Sys_BFGCode,
                    cubicBatch: _cubicalData.Sys_Batch,
                    menuName: VernierDetail.data.menuName,
                    ProductType: objSelMenu.selectedProductDetail.ProductType,
                    Userid: tempUserObject.UserId,
                    idsNo: strIdsNo,
                    Hmi: strHmi,
                    Incomp_RepSerNo: tempCounterObj.counter,
                    ReportType: _cubicalData.Sys_RptType,
                    RecSampleNo: tempCounterObj.counter,
                    SelectedIds: SelectedIdsNo
                }

                let _check_combination = await objPowerBackup._check_combination_pow(objSelMenu, powerbackupobj, tableName);
                if (_check_combination !== undefined) {
                    tempCounterObj.counter = _check_combination.RecSampleNo + 1;
                    powerbackupobj.RecSampleNo = tempCounterObj.counter;
                }

                if (tempCounterObj.counter == 1) {
                    var RepSerno = await objCommonInsertOpt.insert_Into_Incomplete_Master(__parameterVernier);
                    powerbackupobj.Incomp_RepSerNo = RepSerno.srno;
                    await objPowerBackup.getStatusoFTestForPowerBackup(powerbackupobj);

                    var act = `${menuName} Weighment Started on TSH ${strHmi} `;
                    let DoubleRotarySide = ['LHS', 'RHS'];
                    if (DoubleRotarySide.includes(Side)) act += `for side ${Side}`;

                    Object.assign(objActivity,
                        { strUserId: tempUserObject.UserId },
                        { strUserName: tempUserObject.UserName },
                        { batch: _cubicalData.Sys_Batch },
                        { activity: act });
                    await objActivityLog.ActivityLogEntry(objActivity);
                    await objInstrumentUsage.InstrumentUsage('Vernier', strIdsNo, 'tbl_instrumentlog_vernier', menuName, 'started');
                    await objCommonInsertOpt.InsertIncompleteRemarkEntry(__ParamRemark);

                }
                //insert data into detail table
                console.log(tempCounterObj.counter);
                var decimal = await objCommonInsertOpt.insert_Into_Incomplete_Detail(__parameterVernier);
                powerbackupobj.Incomp_RepSerNo = decimal.repSerNo;
                await objPowerBackup.getStatusoFTestForPowerBackup(powerbackupobj);
                var incompRepSerNo = await objPowerBackup.updateTestCount(objSelMenu, powerbackupobj, tableName);
                var updateData = await objcalc.calculation_operation(__parameterVernier, decimal.repSerNo);
                // mqttSender.sendData(strHmi, `DisplayResult:${tempCounterObj.counter}:${Number(dataObj.actualWt).toFixed(decimal)} ${dataObj.unit}`)
                let sampleNo = tempCounterObj.counter
                let limitObjResp = await objCommonUseFunc.SendCommon({ strHmi, actualWt, minLimitT2, maxLimitT2, minLimitT1, maxLimitT1, menuName, sampleNo })
                let color = limitObjResp.Color;
                let limit = limitObjResp.limit;

                mqttSender.sendData(strHmi, `${GLOBAL_NOMENCLATURE.DisplayResult}${tempCounterObj.counter}:${actualWt} ${dataObj.unit}:${color}`);
                mqttSender.sendData(strHmi, limit);
            }



            if (sample == tempCounterObj.counter) {
                //move data from incomplete to complete 
                //remove outOfLimit Flag
                //check nmt range
                var updateData = await objcalc.calculation_operation(__parameterVernier, decimal.repSerNo);

                var response = await objCommonInsertOpt.saveCompleteData(__parameterVernier, typeValue);
                // await objCommonInsertOpt.updateEndDate(strIdsNo, strHmi, strTableName);
                await models.tbl_cubical.update({ 'Sys_Validation': 0 }, { where: { 'Sys_rpi': _cubicalData.Sys_rpi } });
                if (updateData == "Complies") {
                    var printObj = {
                        RepSerNo: response.RepSerNo,
                        Side: Side,
                        batchNo: _cubicalData.Sys_Batch,
                        cubicleType: _cubicalData.Sys_CubType,
                        int_ReportFormat: 1,
                        printNo: 0,
                        recordFrom: "Current",
                        reportOption: menuName,
                        reportType: "Complete",
                        testType: "Regular",
                        userId: tempUserObject.UserId,
                        username: tempUserObject.UserName,
                        str_url: objSelMenu.selectedProductDetail.ProductType === 1 ? "Tablet" : "Capsule"

                    }

                    await printOperations.callViewTabReport(printObj, intProductType, strHmi);

                }

                await models.tbl_powerbackup.destroy({ where: { Idsno: strHmi, Sys_Batch: _cubicalData.Sys_Batch, WeighmentName: menuName } })
                let reportLimitMsg = (updateData == "Not Complies") ? "Report Out Of Limit" : "Report Within Limit"

                var act = `${menuName} Weighment Completed on TSH ${strHmi} `;
                let DoubleRotarySide = ['LHS', 'RHS'];
                if (DoubleRotarySide.includes(Side)) act += `for side ${Side}`;
                Object.assign(objActivity,
                    { strUserId: tempUserObject.UserId },
                    { strUserName: tempUserObject.UserName },
                    { batch: _cubicalData.Sys_Batch },
                    { activity: act });
                await objActivityLog.ActivityLogEntry(objActivity);
                await objInstrumentUsage.InstrumentUsage('Vernier', strIdsNo, 'tbl_instrumentlog_vernier', '', 'completed');
                console.log(tempCounterObj.counter);
                // if(Side == 'LHS'){
                //     mqttSender.sendData(strHmi, `${GLOBAL_NOMENCLATURE.SideChange}: ${Side} And ${GLOBAL_NOMENCLATURE.SideChanges} RHS`);
                // }

                //clear counter array
                globalData.arrWeighmentCounter.findIndex(k => k.Hmi == strHmi) == -1 ?
                    globalData.arrWeighmentCounter :
                    globalData.arrWeighmentCounter.splice(globalData.arrWeighmentCounter.findIndex(k => k.Hmi == strHmi), 1);

                (globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrCurrentOperationStatus :
                    globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi === strHmi), 1);
                //test splice if rotarty is not double
                (globalData.arrOutFlagForTest.findIndex((element) => element.Hmi === strHmi)) == -1 ? globalData.arrOutFlagForTest :
                    globalData.arrOutFlagForTest.splice(globalData.arrOutFlagForTest.findIndex((element) => element.Hmi === strHmi), 1);

                globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi) == -1 ?
                    globalData.arrSelectedMenu :
                    globalData.arrSelectedMenu.splice(globalData.arrSelectedMenu.findIndex(k => k.Hmi == strHmi), 1);

                mqttSender.sendData(strHmi, `${GLOBAL_NOMENCLATURE.TestCompleted}${reportLimitMsg}`);
                return
            }
        } catch (error) {
            throw new Error(error);
        }
    }


}

module.exports = VernierModel;