const clsHmiDetails = require("./hmiDetail.model");
const clsDatabase = require("../database/clsQueryProcess");
const globalData = require("../global/globalData");
const clsIndividual = require("./Test/clsIndividual.model");
const clsGroup = require("./Test/clsGroup.model");
const clsThickness = require("./Test/clsThickness.model");
const clsHardness = require("./Test/clsHardness.model");
const clsFriab = require("./Test/clsFriability.model")
const clsLod = require("./Test/clsLod.method");
const clsLeak = require("./Test/clsLeak.model");
const serverConfig = require("../global/serverConfig");
const ConfigFile = require("../../../IncrencyV4DRLTSHConfig.json");
const GLOBAL_NOMENCLATURE = require("../global/GLOBAL_NOMENCLATURE")
const clsConfigSettings = require("./clsConfigSettings");
const clsCommonInsertOperation = require("./Product/clsCommonInsertOperation.model");
const clsCommonWeightment = require("./Product/clsCommonWeightment");
const { tbl_cubical, tbl_cubicle_product_sample } =
  require("../../config/dbConnection").models;
const sequelize = require("../../config/dbConnection").sequelize;
const clsActivityLog = require("./clsActivityLog.model");
const clsMonit = require("./MonitorSocket/clsMonitSocket");
const objMonit = new clsMonit();
const models = require("../../config/dbConnection").models;
const clsVernier = require('./Test/clsVernier.model');
const PowerBackup = require("../Utills/powerBackUp/powerbackup");
const moment = require("moment");
const { unit } = require("mathjs");
const mqttProtocol = require("../global/GLOBAL_NOMENCLATURE");
// const clsCommonInsertOpt = require('../Product/clsCommonInsertOperation.model');
const clsCommonInsertOpt = require('./Product/clsCommonInsertOperation.model');
const objCommonInsertOpt = new clsCommonInsertOpt();
const check_srNO_ = require("./Product/cls_consolidate_reportOperation");
const check_srNO = new check_srNO_();
const MqttModel = require('../model/Mqtt/mqttSender.class');
const clsInstrumentUsage = require("./clsInstrumentUsageLog");
const mqttSender = new MqttModel();


const objActivityLog = new clsActivityLog();
const objHmi = new clsHmiDetails();
const objIndividual = new clsIndividual();
const objGroup = new clsGroup();
const objThickness = new clsThickness();
const objHardness = new clsHardness();
const objFriab = new clsFriab()
const objLod = new clsLod();
const objLeak = new clsLeak();
const objConfigSettings = new clsConfigSettings();
const objCommonInsert = new clsCommonInsertOperation();
const objCommonWeightment = new clsCommonWeightment();
const objVernier = new clsVernier();
const objPowerBackup = new PowerBackup();
const objInstrumentUsage = new clsInstrumentUsage();
const { Op } = require("sequelize");
const { QueryTypes } = require("sequelize");

// const clsWeighmentModel = require("../../model/clsProcessWeighment.model");
// const objWeighmentMOdel = new clsWeighmentModel();

class WeighmentModel {

  getUnitObj(menuName) {
    try {
      let unitObj = {};
      // let minMaxPerDp, avgDp, stdDevDp, minMaxDp;

      switch (menuName) {
        case GLOBAL_NOMENCLATURE.IndividualMenu:
        case GLOBAL_NOMENCLATURE.GroupMenu:
        case GLOBAL_NOMENCLATURE.EmptyGroupMenu:
        case GLOBAL_NOMENCLATURE.Differential:
          unitObj.minMaxPerDp = ConfigFile.plant == "PUI" ? 4 : 3;
          unitObj.avgDp = ConfigFile.plant == "PUI" ? 4 : 3;
          unitObj.stdDevDp = ConfigFile.plant == "PUI" ? 4 : 3;
          unitObj.minMaxDp = ConfigFile.plant == "PUI" ? 4 : 3;
          break;
        case GLOBAL_NOMENCLATURE.ThicknessMenu:
        case GLOBAL_NOMENCLATURE.LengthMenu:
        case GLOBAL_NOMENCLATURE.LockedLength:
          unitObj.minMaxPerDp = 2;
          unitObj.avgDp = 2;
          unitObj.stdDevDp = 4;
          unitObj.minMaxDp = 2;
          break;
        case GLOBAL_NOMENCLATURE.LODMenu:
          unitObj.decPoint = 3;
          unitObj.lodPerDp = 2;
          unitObj.tempDp = 1;
          break;
      }

      // let unitObj = {
      //   minMaxPerDp: minMaxPerDp,
      //   avgDp: avgDp,
      //   stdDevDp: stdDevDp,
      //   minMaxDp: minMaxDp
      // }

      return unitObj
    } catch (error) {
      throw new Error(error)
    }
  }

  async doubleRotary(data) {
    try {
      var responseobj = {};
      //globalData.arrside = data.Side;

      var tmppbckupobj = globalData.arrside.find((k) => k.Hmi == data.Hmi);
      if (tmppbckupobj == undefined) {
        globalData.arrside.push({
          Hmi: data.Hmi,
          Side: data.Side,
        });
      } else {
        var index = globalData.arrside.findIndex((k) => k.Hmi == data.Hmi);
        globalData.arrside[index].Side = data.Side;
      }
      if (data.Side != "" && data.Side != null) {
        Object.assign(
          responseobj,
          { status: "success" },
          { result: "Side set to " + data.Side }
        );
      }
      return responseobj;
    } catch (error) {
      throw new Error(error);
    }
  }

  async OnTestStart(value) {
    try {
      // let strHmi = value.Hmi;
      // let arrPortDetailForStart = await objHmi.getResbPiNoFromHmi(strHmi);
      // let intIdsNo = arrPortDetailForStart[0].Sys_IDSNo;
      // let intPortNo = arrPortDetailForStart[0].Sys_PortNo;
      const DsNo = value.dsNo;
      const TabIp = value.tabIp;
      let strstatus = "Weighment";
      let productData = value;
      let menuName = productData.menuName;
      let tempSample = productData.noOfSample;
      let sampleNo = parseFloat(productData.noOfSample);
      let instrumentName = "";
      let responseObj = {};
      // const isFTP = false
      const isFTP = value.isFTP
      const side = value.Side
      const containerId = value.containerId
      const rotary = value.Rotary;
      const repetitionNo = value.repetition;
      // var Ip = value.Ip;
      let selectedDsNo = DsNo;
      let batchStatus = value.batchStatus;
      var IPQCObject = globalData.arr_IPQCRelIds.find(
        (k) => k.DsNo == DsNo && k.tabIp == TabIp
      );

      const cubicData = await models.tbl_cubical.findOne({
        where: {
          Sys_DSNumber: DsNo,
          Sys_Area: value.Area || value.Sys_CubType,
          Sys_Batch: value.Batch || value.Sys_Batch,
          // Sys_Repetition: value.repetition
        }
      })

      if (IPQCObject != undefined) {
        selectedDsNo = IPQCObject.selectedDs.dsNo;
      } else {
        selectedDsNo = DsNo;
      }

      if (sampleNo !== "" && sampleNo !== undefined && !isNaN(sampleNo)) {
        let prodtDetail1 = globalData.arr_limits.find((k) => k.DsNo == DsNo && k.TabIp == TabIp);

        // if (Array.isArray(prodtDetail1.Menus)) {
        //     if (prodtDetail1.Menus.filter(k => k.hasOwnProperty(menuName))) {
        //         prodtDetail1.Menus.filter(k => k.hasOwnProperty(menuName))[0][menuName].noOfSamples = sample;
        //     }
        // }
        // else {
        //     prodtDetail1.Menus.noOfSamples = sample;
        // }
        let menuSample;
        // if (Array.isArray(prodtDetail1.Menus)) {
        //   if (prodtDetail1.Menus.filter((k) => k.hasOwnProperty(menuName))) {
        //     menuSample = prodtDetail1.Menus.filter(
        //       (obj) => Object.keys(obj) == menuName
        //     )[0][menuName].noOfSamples;
        //   }
        // } else {
        //   menuSample = prodtDetail1.Menus.noOfSample;
        //   menuSample = menuSample == undefined ? "000" : menuSample;
        // }

        //power back up resume activity log;
        // /
        // if (!value.isPowerBackup) {
        //   var sampleno = await objCommonInsert.updateSample(
        //     sampleNo,
        //     DsNo,
        //     menuName,
        //     TabIp
        //   );
        //   var act = `${menuName} Sample Changes From ${menuSample} To ${tempSample} Update on DS ${DsNo}`;
        //   if (menuName == "Hardness") {
        //     var act = `${menuName}/Thickness Sample Changes From ${menuSample} To ${tempSample} Update on DS ${DsNo}`;
        //   }
        //   if (menuSample != sampleNo) {
        //     let objActivity = {};
        //     Object.assign(
        //       objActivity,
        //       { strUserId: value.userId },
        //       { strUserName: value.userName },
        //       { activity: act }
        //     );
        //     await objActivityLog.ActivityLogEntry(objActivity);
        //   }
        // }
        // var IPQCObject = globalData.arr_IPQCRelIds.find(k => k.idsNo == strHmi);
        //             if (IPQCObject != undefined) {
        //                 strHmi = IPQCObject.selectedIds.Idsno;
        //             } else {
        //                 strHmi = strHmi;
        //             }

        // if (value.isPowerBackup) {
        //   //sample no
        //   const SampleObj = await models.tbl_cubicle_product_sample.findAll({
        //     where: {
        //       Sys_CubicNo: value.CubicalNo,
        //     },
        //   });
        //   var sampleno = SampleObj[0][`${menuName}`];
        //   let tempPbkupObj = globalData.monitDetail.find(
        //     (k) => k.TabIp == TabIp && k.DsIp == DsIp
        //   );
        //   let sample = tempPbkupObj.data.length;
        //   let sampleExist = "";
        //   if (sample != 0) {
        //     sampleExist = `from Sample No. ${sample} `;
        //   }
        //   // let hmiDetails = globalData.arrWeighmentProductData.find(k => k.Hmi == data.Hmi);

        //   if (menuName == "Individual") {
        //     var act = `${menuName} Test Resumed on TSH ${DsNo} ${sampleExist} through PowerBackup`;
        //     if (value.Side != "NA") {
        //       var act = `${menuName} Test Resumed on TSH ${DsNo} ${sampleExist} through PowerBackup for side ${value.Side}`;
        //     }
        //   } else {
        //     var act = `${menuName}/Thickness Test Resumed on TSH ${DsNo} ${sampleExist} through PowerBackup`;
        //     if (value.Side != "NA") {
        //       var act = `${menuName}/Thickness Test Resumed on TSH ${DsNo} ${sampleExist} through PowerBackup for side ${value.Side}`;
        //     }
        //   }

        //   let objActivity = {};
        //   Object.assign(
        //     objActivity,
        //     { strUserId: value.userId },
        //     { strUserName: value.userName },
        //     { activity: act }
        //   );

        //   await objActivityLog.ActivityLogEntry(objActivity);
        // }

        // if (Array.isArray(prodtDetail1.Menus)) {
        //   if (prodtDetail1.Menus.filter((k) => k.hasOwnProperty(menuName))) {
        //     prodtDetail1.Menus.filter((k) => k.hasOwnProperty(menuName))[0][
        //       menuName
        //     ].noOfSamples = sampleno;
        //   }
        // } else {
        //   prodtDetail1.Menus.noOfSample = sampleno;
        // }
      }

      console.log("OnTestStart", value);
      var menu
      if (value.hardnessVarient != undefined) {
        if (value.hardnessVarient == 1) {
          menu = 'Pharmatest'
          menuName = GLOBAL_NOMENCLATURE.MultiTester
        } else {
          menu = menuName
        }
      } else {
        menu = menuName
      }

      await objMonit.monit({
        case: "TestStart",
        Hmi: DsNo,
        data: {
          Product: productData.productId,
          Batch: productData.Batch,
          TestType: menu,
        },
      });
      menuName = menuName == 'FRIAB' ? 'Friability' : menuName
      if (value.FTPModel == 'WHT4' || value.FTPModel == 'WHT 4') {
        menuName = GLOBAL_NOMENCLATURE.MultiTester
      }
      switch (menuName) {
        case GLOBAL_NOMENCLATURE.LengthMenu:
        case GLOBAL_NOMENCLATURE.LockedLength:
        case GLOBAL_NOMENCLATURE.ThicknessMenu:
        case GLOBAL_NOMENCLATURE.BreadthMenu:
        case GLOBAL_NOMENCLATURE.DiameterMenu:
          instrumentName = GLOBAL_NOMENCLATURE.Vernier;
          break;
        case GLOBAL_NOMENCLATURE.EmptyShell:
        case GLOBAL_NOMENCLATURE.IndividualMenu:
        case GLOBAL_NOMENCLATURE.IndLayerMenu:
        case GLOBAL_NOMENCLATURE.IndLayer1Menu:
        case GLOBAL_NOMENCLATURE.GroupMenu:
        case GLOBAL_NOMENCLATURE.EmptyGroupMenu:
        case GLOBAL_NOMENCLATURE.GroupIndividual:
        case GLOBAL_NOMENCLATURE.GroupLayerMenu:
        case GLOBAL_NOMENCLATURE.GroupLayer1Menu:
        case GLOBAL_NOMENCLATURE.PercentageFine:
        case GLOBAL_NOMENCLATURE.ParticalSizing:
          instrumentName = GLOBAL_NOMENCLATURE.Balance;
          break;
        case GLOBAL_NOMENCLATURE.HardnessMenu:
        case GLOBAL_NOMENCLATURE.TabletTesterMenu:
          instrumentName = GLOBAL_NOMENCLATURE.Hardness;
          break;
        case GLOBAL_NOMENCLATURE.DTMenu:
        case "Disintegration Test":
          instrumentName = GLOBAL_NOMENCLATURE.DT;
          break;
        case GLOBAL_NOMENCLATURE.MoistureAnalyzer:
          instrumentName = GLOBAL_NOMENCLATURE.MoistureAnalyzer;

          break;
        case GLOBAL_NOMENCLATURE.MultiTester:
          instrumentName = GLOBAL_NOMENCLATURE.MultiTester;

          break;
        case GLOBAL_NOMENCLATURE.Friability:
        case GLOBAL_NOMENCLATURE.FriabilatorMenu:
          if (menuName == GLOBAL_NOMENCLATURE.FriabilatorMenu) {
            instrumentName = "Friabilator";
          } else {
            if (serverConfig.friabilityType == "OF") {
              instrumentName = "Friabilator";
            } else {
              instrumentName = GLOBAL_NOMENCLATURE.Balance;
            }
          }

          break;
        case GLOBAL_NOMENCLATURE.TappedDensity:
          instrumentName = GLOBAL_NOMENCLATURE.TappedDensity;
          break;
        case GLOBAL_NOMENCLATURE.PercentageFine:
          instrumentName = GLOBAL_NOMENCLATURE.Balance;
          break;
        case GLOBAL_NOMENCLATURE.Differential:
          instrumentName = GLOBAL_NOMENCLATURE.Balance;
          break;
        case GLOBAL_NOMENCLATURE.MoistureAnalyzer:
        case "LOD":
        case "Loss on Dry":
        case GLOBAL_NOMENCLATURE.granulationDry:
        case GLOBAL_NOMENCLATURE.granulationLub:
        case GLOBAL_NOMENCLATURE.lay1Dry:
        case GLOBAL_NOMENCLATURE.lay1Lub:
        case GLOBAL_NOMENCLATURE.lay2Dry:
        case GLOBAL_NOMENCLATURE.lay2Lub:
          instrumentName = GLOBAL_NOMENCLATURE.MoistureAnalyzer;
          break;
        case "IPCWC":
          instrumentName = GLOBAL_NOMENCLATURE.IPCBalance;
          var ipcWeighment = await selectedBin(value);
          return ipcWeighment;
        // break;
        case GLOBAL_NOMENCLATURE.LeakTestMenu:
          instrumentName = GLOBAL_NOMENCLATURE.LeakTester;
          break;
      }
      if (menuName == GLOBAL_NOMENCLATURE.MultiTester) {
        menuName = "Hardness"
        instrumentName = GLOBAL_NOMENCLATURE.MultiTester;
      }

      // if (cubicData.Sys_Area == "Compression" && (cubicData.Sys_Port2 == "Multi Tester" || cubicData.Sys_Port3 == "Multi Tester" || cubicData.Sys_Port4 == "Multi Tester")) {
      //   menuName = GLOBAL_NOMENCLATURE.MultiTester
      //   instrumentName = GLOBAL_NOMENCLATURE.MultiTester;
      // }
      var configSetting
      // if(isFTP == true && menuName=="Hardness"){
      //   configSetting = [{instrumentType: "Hardness", mode: "FTP", portNo: "FTP"}]
      // }else{
      configSetting = await objConfigSettings.GetConfigSetting(
        DsNo,
        instrumentName,
        TabIp
      );

      // }

      const portNo = configSetting.find(k => k.TabIp == TabIp && k.DsNo == DsNo).portNo;


      let hmiEntryinConfig = globalData.arrConfigSettings.find(
        (k) => k.TabIp == TabIp && k.DsNo == DsNo
      );
      if (hmiEntryinConfig == undefined) {
        globalData.arrConfigSettings.push({
          DsNo,
          configSetting: configSetting,
          TabIp,
        });
      } else {
        (hmiEntryinConfig.configSetting = configSetting),
          (hmiEntryinConfig.TabIp = TabIp);
      }

      let hmiDetails = globalData.arrWeighmentProductData.find(
        (k) => k.TabIp == TabIp && k.DsNo == DsNo
      );
      if (hmiDetails == undefined) {
        globalData.arrWeighmentProductData.push({
          TabIp,
          data: productData,
          DsNo,
        });
      } else {
        hmiDetails.data = productData;
      }

      if (strstatus === "Weighment") {
        let tempObj = globalData.arrCurrentOperationStatus.find(
          (k) => k.TabIp == TabIp && DsNo == DsNo
        );
        if (tempObj === undefined) {
          globalData.arrCurrentOperationStatus.push({
            DsNo,
            Weighment: "1",
            testType: "Weighment",
            TabIp,
          });
        } else {
          tempObj.DsNo = DsNo;
          tempObj.TabIp = TabIp;
          tempObj.testType = "Weighment";
          tempObj.Weighment = "1";
        }

        var tshIP = await models.tbl_rpi.findAll({
          where: {
            DS_NUMBER: DsNo,
          },
        });

        var obj;
        var cubicalData = globalData.arrIdsInfo.find((k) => k.DsNo == DsNo && k.TabIp == TabIp);
        if (menuName == "LOD") {
          var cubicalData = globalData.arrIdsInfo.find((k) => k.DsNo == DsNo && k.TabIp == TabIp);

          obj = await models.tbl_otherequipment.findOne({
            where: {
              Eqp_ID: cubicalData.cubicalData.Sys_MoistID,
            },
          });

          obj = obj.Eqp_Model;
        }

        // await models.tbl_ds_binding.update({
        //   PortNo: portNo
        // }, {
        //   where: {
        //     TAB_IP: TabIp,
        //     DS_NUMBER: DsNo
        //   }
        // })

        // Get menu name
        // const dsBindingRes = await models.tbl_ds_binding.findOne({
        //   where: {
        //     TAB_IP: TabIp,
        //     DS_NUMBER: DsNo
        //   }
        // })

        // if(dsBindingRes.MenuName == "Hardness"){

        // }

        // let isFTP = ""

        let objSelMenu = globalData.arrSelectedMenu.find((k) => k.TabIp == TabIp && k.DsNo == DsNo);
        objSelMenu.Side = side;
        objSelMenu.batchStatus = batchStatus;
        objSelMenu.containerId = containerId;
        if (side == 'NA') {
          objSelMenu.LHSContainerNo = side == 'NA' ? containerId : 'NA'
        } else {
          objSelMenu.LHSContainerNo = side == 'LHS' ? containerId : 'NA'
        }
        objSelMenu.RHSContainerNo = side == 'RHS' ? containerId : 'NA'
        if (rotary) objSelMenu.rotary = rotary;

        if (menuName === "Hardness" && isFTP === true) {
          globalData.hardnessClient[0].isAvailable = true
          globalData.hardnessClient[0].DsNo = DsNo
          globalData.hardnessClient[0].TabIp = TabIp
          globalData.hardnessClient[0].IsIndividual = false
          globalData.hardnessClient[0].protocolPort = portNo
        }
        if (menuName === "Individual" && isFTP === true && cubicalData.cubicalData.Sys_RptType == 1) {
          globalData.hardnessClient[0].isAvailable = true
          globalData.hardnessClient[0].DsNo = DsNo
          globalData.hardnessClient[0].TabIp = TabIp
          globalData.hardnessClient[0].IsIndividual = true
          globalData.hardnessClient[0].protocolPort = portNo
        }

        return Object.assign(responseObj, {
          status: "success",
          configsetting: configSetting,
          DsNo,
          TabIp,
          DS_IP: tshIP[0].DS_IP,
          instMake: obj,
          isFTP
        });
      } else {
        return Object.assign(responseObj, {
          status: "fail",
          message: "Status is not weighment",
        });
      }
    } catch (error) {
      throw new Error(error);
    }
  }

  async ParsingTestData(instrumentType, __parameterObj) {
    try {
      let result;
      let dsNo = __parameterObj.DsNo;
      let dsIp = __parameterObj.DsIp;
      var tabIp = __parameterObj.TabIp;
      // const objSelMenu = globalData.arrSelectedMenu.find((k) => k.Ip == Ip);
      let strSelectedMenuName = __parameterObj.menuName;
      // __parameterObj.menuName = strSelectedMenuName;
      var tempCubicInfo = globalData.arrIdsInfo.find(k => k.DsNo == dsNo && k.TabIp == tabIp);
      const SampleRemark = globalData.arrSampleRemarkForAllTest.find((k) => k.DsNo == dsNo && k.TabIp == tabIp);
      if (!SampleRemark) globalData.arrSampleRemarkForAllTest.push({ DsNo: dsNo, OutOfRemark: false, DsIp: dsIp, TabIp: tabIp });
      strSelectedMenuName = strSelectedMenuName.replace(/\_/g, " ");
      switch (strSelectedMenuName) {
        case GLOBAL_NOMENCLATURE.Differential:
        case GLOBAL_NOMENCLATURE.IndividualMenu:
        case GLOBAL_NOMENCLATURE.GroupMenu:
        case GLOBAL_NOMENCLATURE.EmptyGroupMenu:
        case GLOBAL_NOMENCLATURE.LengthMenu:
        case GLOBAL_NOMENCLATURE.LockedLength:
        case GLOBAL_NOMENCLATURE.DiameterMenu:
        case GLOBAL_NOMENCLATURE.ThicknessMenu: {
          if (strSelectedMenuName == GLOBAL_NOMENCLATURE.GroupMenu && tempCubicInfo.cubicalData.Sys_Area == 'Coating') {
            result = await objGroup.processGroupData(instrumentType, __parameterObj);
            return result;
          }
          else {
            result = await objIndividual.processData(instrumentType, __parameterObj);
            // result = await objIndividual.processIndividualData(__parameterObj);
            return result;
          }

        }

        // case GLOBAL_NOMENCLATURE.GroupMenu: {
        //   result = await objGroup.processGroupData(__parameterObj);
        //   return result;
        // } 
        case GLOBAL_NOMENCLATURE.DTMenu: {
          result = await this.saveDTData(__parameterObj);
          return result;
        }

        case GLOBAL_NOMENCLATURE.GroupLayerMenu: {
          result = await objGroup.processGroupData(__parameterObj);
          return result;
        }

        case GLOBAL_NOMENCLATURE.GroupIndividual: {
          result = await objIndividual.processIndividualData(__parameterObj);
          return result;
        }

        case GLOBAL_NOMENCLATURE.GroupLayer1Menu: {
          result = await objGroup.processGroupData(__parameterObj);
          return result;
        }

        case GLOBAL_NOMENCLATURE.HardnessMenu: {
          // result = await objHardness.processHardnessData(__parameterObj);
          result = await objHardness.processHardnessDataVK200(__parameterObj);
          return result;
        }
        case GLOBAL_NOMENCLATURE.MoistureAnalyzer:
        case GLOBAL_NOMENCLATURE.LODMenu: {
          result = await objLod.insertBulkWeighmentLOD(__parameterObj);
          return result;
        }

        case GLOBAL_NOMENCLATURE.LeakTestMenu:
          result = await objLeak.insertBulkWeighmentLeak(__parameterObj);
          return result;

        case GLOBAL_NOMENCLATURE.Friability: {
          if (serverConfig.friabilityType == "OF") {
            // result = await objFriab.processBalanceFriabilityInitial(__parameterObj)
            result = await objFriab.processFriability(__parameterObj)
            console.log(result)
            return result
          } else {
            result = await objFriab.processBalanceFriabilityInitialNextButtonFunctionality(__parameterObj)
            return result

          }
        }
        // case GLOBAL_NOMENCLATURE.Friability: {
        //   // result = await objFriab.processBalanceFriabilityInitial(__parameterObj)

        // }


        default:
          console.log("Unknown ", strSelectedMenuName);
      }
    } catch (error) {
      throw new Error(error);
    }
  }

  async verifyLoginAfterTest(values) {
    try {
      const { Hmi: strHmi, userId: strUserId, userPass: strPassword } = values;
      let loginCheck = await this.checkUser(strUserId, strPassword);
      if (loginCheck == undefined) {
        return { status: "fail", result: "Incorrect Credentials" };
      }
      const arrUsers = globalData.arrUsers.find((k) => k.Hmi == strHmi);
      if (arrUsers == undefined) {
        console.log("no user it must be error");
        return { status: "fail", message: "No user detail" };
      }
      //user which has login on system
      const preLoginUser = arrUsers.UserId;
      if (!(preLoginUser.trim() == strUserId.trim())) {
        return { status: "fail", message: "Incorrect Credentials" };
      }
      return { status: "success", message: "User Matched" };
    } catch (error) {
      throw new Error(error);
    }
  }

  async checkUser(userID, pwd) {
    try {
      const usrDetailsObj = {
        str_tableName: "tbl_users",
        data: "*",
        condition: [
          { str_colName: "userId", value: userID },
          { str_colName: "realPassword", value: pwd },
        ],
      };
      let result = await database.select(usrDetailsObj);

      if (result[0][0] != undefined) {
        return result[0][0];
      } else {
        return undefined;
      }
    } catch (error) {
      throw new Error(error);
    }
  }

  async fileException(value) {
    try {
      let menuName = value.menuName.replace(/\_/g, " ");
      let dsNo = value.dsNo;
      let tabIp = value.tabIp;
      let remark = value.remark;
      let side = value.side ? value.side : 'NA'
      let cubicObj = globalData.arrIdsInfo.find((k) => k.DsNo == dsNo).cubicalData;
      let tempUserObject = globalData.arrUsers.find((k) => k.DsNo == dsNo && k.TabIp == tabIp);
      let obj = { cubicObj: cubicObj, UserData: tempUserObject, menuName: menuName, DsNo: dsNo, TabIp: tabIp }
      let getTableName = objCommonWeightment.getTableName(cubicObj, menuName, dsNo, tabIp);
      let masterTable = getTableName.masterTable;
      let detailTable = getTableName.detailTable;
      let masterTableIncomplete = getTableName.masterTableIncomplete;
      let detailTableIncomplete = getTableName.detailTableIncomplete;
      if (menuName == GLOBAL_NOMENCLATURE.IndividualMenu && value.ftp == 'true') {
        let resp = await this.exceptionFTPIndividual(obj, getTableName, remark)
        return { status: "success" };
      }
      if (menuName == GLOBAL_NOMENCLATURE.HardnessMenu) {
        let resp = await this.exceptionFTPHardness(obj, getTableName, remark)
      } else {
        let repSerNo;
        let recSerNo;
        if ((menuName == `${GLOBAL_NOMENCLATURE.DTMenu} Test` || menuName == GLOBAL_NOMENCLATURE.GroupMenu) && cubicObj.Sys_Area != 'Coating') {
          let getMenuSeq = await models.tbl_menu_sequence.findOne({
            where: {
              DS_Number: dsNo,
              TabIp: tabIp
            }
          })
          if (getMenuSeq) {
            repSerNo = getMenuSeq.RepSerNo
            recSerNo = 1;
          }
        }

        else {
          let getPowerbackupData = await objPowerBackup.getPowerbackupData(obj)
          if (getPowerbackupData) {
            repSerNo = getPowerbackupData.Incomp_RepSerNo
            recSerNo = getPowerbackupData.RecSampleNo;
          }
        }
        let whereCondiition = {
          DsNo: dsNo,
          ...(repSerNo ? { RepSerNo: repSerNo } : {})
        }

        let masterData = await models[masterTableIncomplete].findAll({
          attributes: [[sequelize.fn('max', sequelize.col('RepSerNo')), 'RepSerNo']],
          where: whereCondiition
        })

        if (masterData.length > 0) {
          let detailData = await models[detailTableIncomplete].findAll({
            attributes: [[sequelize.fn('max', sequelize.col('RecNo')), 'RecNo']],
            where: {
              RepSerNo: masterData[0].RepSerNo
            }
          });
          if (detailData.length > 0) {
            await models[detailTableIncomplete].update({ Remark: remark, isException: 1 }, { where: { RecNo: detailData[0].RecNo } })
            await models.tbl_powerbackup.update({ isException: 1 }, { where: { Incomp_RepSerNo: masterData[0].RepSerNo } })
            await models.tbl_activity_log.create({
              dt: moment().format('YYYY-MM-DD'),
              tm: moment().format('HH:mm:ss'),
              userid: tempUserObject.UserId,
              username: tempUserObject.UserName,
              activity: `${menuName} Sample No. ${recSerNo} Cleared 
              with remark: ${remark}`
            })

            await models.tbl_batch_log.create({
              dt: moment().format('YYYY-MM-DD'),
              tm: moment().format('HH:mm:ss'),
              userid: tempUserObject.UserId,
              username: tempUserObject.UserName,
              BatchNo: cubicObj.Sys_Batch,
              activity: `${menuName} Sample No. ${recSerNo} Cleared 
              with remark: ${remark}`
            })
          }
          if (menuName == 'Disintegration Test') {
            await models.tbl_powerbackup.destroy({
              where: {
                DsNo: dsNo,
                TabIp: tabIp,
                WeighmentName: "Disintegration"
              }
            });
          }
        }
      }
      if (menuName == GLOBAL_NOMENCLATURE.Friability && serverConfig.friabilityType != "OF") {
        await models.tbl_powerbackup.destroy({
          where: {
            DsNo: dsNo,
            TabIp: tabIp,
            WeighmentName: "FRIAB"
          }
        });

      }

      return { status: "success" };

    } catch (err) {
      throw new Error(err);
    }
  }

  async exceptionFTPHardness(obj, getTableName, remark) {

    try {
      let cubicalData = obj.cubicObj
      let menuName = obj.menuName
      let DsNo = obj.DsNo
      let TabIp = obj.TabIp
      let tempUserObject = obj.UserData
      let masterTable = getTableName.masterTable;
      let exceptionTable = 'tbl_exception_samplehtd_initial';


      let menuSequenceTable = await models.tbl_menu_sequence.findOne({
        attributes: { exclude: ['DS_Number', 'UserId', 'RecNo', 'RepSerNo', 'TabIp'] },
        where: {
          DS_Number: DsNo,
          TabIp: TabIp
        }
      })

      var count = 0;
      var IndFlag = 0
      for (let ele in menuSequenceTable) {
        if (menuSequenceTable[`${ele}`] == 0) count++
        if (ele == 'IND' && menuSequenceTable[`${ele}` == 1]) IndFlag = 1
      }

      if (count != 0) {
        masterTable = getTableName.masterTableIncomplete

      }

      let masterData = await models[masterTable].findAll({
         // attributes: ['BatchNo', 'DsNo',[sequelize.fn('max', sequelize.col('RepSerNo')), 'RepSerNo']],
        where: {
          DsNo: DsNo,
          TabIp: TabIp,
          MPN_Code: cubicalData.Sys_MPNCode,
          BatchNo: cubicalData.Sys_Batch,
          Repetition:cubicalData.Sys_Repetition,
          SFOID: cubicalData.Sys_SFOID

        },
        //  group: ['BatchNo', 'DsNo']
         order: [['RepSerNo', 'DESC']]
      })

      if (masterData.length > 0) {

        let InstrumentData = await models.tbl_otherequipment.findOne({
          attributes: ['Eqp_Make'],
          where: {
            Eqp_ID: cubicalData.Sys_HardID
          }
        })
        if (InstrumentData.Eqp_Make == 'Pharmatest' && !IndFlag && cubicalData.Sys_RptType == 0) {
          await models.tbl_exception_sample_initial.update({
            Remark: remark
          }, {
            where: {
              RepSerNo: masterData[0].RepSerNo,
              BatchNo: masterData[0].BatchNo,
              // IDSNo: masterData[0].DsNo,
              Repetition:masterData[0].Repetition,
              SFOID: masterData[0].SFOID
            }
          })
        }
        let whereCondition = { 
          RepSerNo: masterData[0].RepSerNo,
          BatchNo: masterData[0].BatchNo,
          // IDSNo: masterData[0].DsNo, 
          Repetition: masterData[0].Repetition,
          SFOID:masterData[0].SFOID,
          isTerminated:0
        }
        if (menuName == 'Hardness' && InstrumentData.Eqp_Make == 'Vankel') {
          whereCondition.Remark = 'NULL'
          // await models.tbl_tab_initialdetailhtd_incomplete.update({
          //   Remark: remark
          // }, {
          //   where: {
          //     RepSerNo: masterData[0].RepSerNo,
          //     Remark: 'NULL',
          //     isException:1
          //   }

          // })

          await models.tbl_powerbackup.update(
            { isException: 0 }
            , {
              where: {
                Incomp_RepSerNo: masterData[0].RepSerNo,
                DsNo: DsNo,
                TabIp: TabIp,
                WeighmentName: "Hardness"
              }
            });
        }
        await models[exceptionTable].update({
          Remark: remark
        }, {
          where: whereCondition

        })




        await models.tbl_activity_log.create({
          dt: moment().format('YYYY-MM-DD'),
          tm: moment().format('HH:mm:ss'),
          userid: tempUserObject.UserId,
          username: tempUserObject.UserName,
          activity: `${menuName} Sample Cleared 
          with remark: ${remark}`
        })

        await models.tbl_batch_log.create({
          dt: moment().format('YYYY-MM-DD'),
          tm: moment().format('HH:mm:ss'),
          userid: tempUserObject.UserId,
          username: tempUserObject.UserName,
          BatchNo: cubicalData.Sys_Batch,
          activity: `${menuName} Sample Cleared 
          with remark: ${remark}`
        })
        if (InstrumentData.Eqp_Make == 'Pharmatest') {

          await models.tbl_powerbackup.destroy({
            where: {
              DsNo: DsNo,
              TabIp: TabIp,
              WeighmentName: "Hardness"
            }
          });
        }
      }

      return { status: "success" };
    } catch (error) {
      console.log(error)
    }



  }

  async saveDTData(value) {
    try {
      let prodDetail;
      let detail_Incomplete;
      let param;
      console.log('value: ', value);
      let currentRepSrNo = 0;

      // let getTableName = objCommonWeightment.getTableName(value.menuName)
      // User data
      const userObj = globalData.arrUsers.find(k => k.DsNo == value.dsNo && k.TabIp == value.tabIp);
      let objSelMenu = globalData.arrSelectedMenu.find((k) => k.TabIp == value.tabIp && k.DsNo == value.dsNo);
      // Cubicle data
      let cubicObjData = globalData.arrIdsInfo.find((k) => k.DsNo == value.dsNo && k.TabIp == value.tabIp)
      const cubicalRes = cubicObjData.cubicalData;
      // Product master data
      const productMasterRes = await models.tbl_product_master.findOne({
        where: {
          MPN_Code: cubicalRes.Sys_MPNCode
        }
      })


      let getTableName = objCommonWeightment.getTableName(cubicalRes, value.menuName, cubicObjData.DsNo, cubicObjData.TabIp);
      // Product detail data

      if (productMasterRes.ProductType == 1) {
        prodDetail = 'tbl_product_tablet'
        param = 'Param13_Nom'
        detail_Incomplete = 'tbl_tab_initialdetail13_incomplete'
      } else {
        prodDetail = 'tbl_product_capsule'
        param = 'Param6_Nom'
        detail_Incomplete = 'tbl_cap_initialdetail13_incomplete'
      }
      const productDetailsRes = await models[prodDetail].findOne({
        where: {
          MPN_Code: cubicalRes.Sys_MPNCode,
          // ProductId: productMasterRes.ProductId
        }
      })

      // Product sample no
      const productSampleRes = await models.tbl_cubicle_product_sample.findOne({
        where: {
          Sys_CubicNo: cubicalRes.Sys_CubicNo,
        }
      })

      const menuSeqRes = await models.tbl_menu_sequence.findOne({
        where: {
          DS_Number: value.dsNo,
          TabIp: value.tabIp,
          RepSerNo: {
            [Op.and]: {
              [Op.ne]: null,
              [Op.ne]: 0
            }
          }
        }
      })

      // Get NoOfStation
      const equipmentData = await models.tbl_machine.findOne({
        attributes: ['Machine_Punches'],
        where: { Machine_ID: cubicalRes.Sys_MachineCode }
      })

      let DtObj = await models.tbl_otherequipment.findOne({
        where: {
          Eqp_ID: cubicalRes.Sys_DTID
        }
      })

      // Define the two times as strings
      let dtLimit = productDetailsRes[param].split(":");
      let time1 = (dtLimit.length > 2) ? productDetailsRes[param] : '00:' + productDetailsRes[param]
      // if(dtLimit.length > 1) {
      //   time1 = productDetailsRes.Param13_Nom
      // }
      // let time1 = '00:' + productDetailsRes.Param13_Nom;
      let dt = value.dtValue.split(":");
      let time2 = (dt.length > 2) ? value.dtValue : '00:' + value.dtValue;
      // let time2 = '00:' + value.dtValue;

      // Parse the times using moment
      let parsedTime1 = moment(time1, "HH:mm:ss");
      let parsedTime2 = moment(time2, "HH:mm:ss");

      // Compare if time2 is greater than time1
      var dtRemark = "";
      if (parsedTime2.isAfter(parsedTime1)) {
        dtRemark = "Out of limit"
      } else {
        dtRemark = "Within limit"
      }

      let activity_msg = `${value.menuName} Started on DS ${value.dsNo}`
      activity_msg = (cubicalRes.Sys_RotaryType == "NA") ? activity_msg : `${activity_msg} for side ${cubicalRes.Sys_RotaryType}`;

      let __activityObj = {
        strUserId: userObj.UserId,
        strUserName: userObj.UserName,
        batch: cubicalRes.Sys_Batch,
        activity: activity_msg,
      };

      await objActivityLog.ActivityLogEntry(__activityObj);
      await objInstrumentUsage.InstrumentUsage(
        "DT",
        value.dsNo,
        `tbl_instrumentlog_dt`,
        value.menuName,
        "started",
        value.tabIp,
        userObj,
        cubicObjData,
      );

      if (DtObj.Eqp_Model == "EDI2SA" && dtRemark == "Out of limit") {
        mqttSender.sendData(value.dsNo, `Port ${value.ProtocolPortNo}:${mqttProtocol.DisplayMessage}${dtRemark}: OkBtn true`);
        mqttSender.sendData(value.dsNo, `Port ${value.ProtocolPortNo}:${GLOBAL_NOMENCLATURE.DisplayMessage}${dtRemark}`);
      }

      if (menuSeqRes) {
        let detailEntryFound = await models[detail_Incomplete].findOne({ where: { RepSerNo: menuSeqRes.RepSerNo, isException: 1 } })
        if (!detailEntryFound) {
          await models[getTableName.masterTableIncomplete].update({
            DTID: cubicalRes.Sys_DTID,
            Param13_Nom: productDetailsRes[param],
            Param13_PrDate: moment().format("YYYY-MM-DD"),
            Param13_PrTime: moment().format("HH:mm:ss"),
          }, {
            where: {
              RepSerNo: menuSeqRes.RepSerNo
            }
          });
        }
        currentRepSrNo = menuSeqRes.RepSerNo
      } else {
        const response = await models[getTableName.masterTableIncomplete].create({
          ProductType: productMasterRes.ProductType,
          Area: cubicalRes.Sys_Area,
          CubicalNo: cubicalRes.Sys_CubicNo,
          CubicleName: cubicalRes.Sys_CubicName,
          CubicleType: cubicalRes.Sys_CubType,
          SFOID: cubicalRes.Sys_SFOID,
          LHSContainerNo: objSelMenu.LHSContainerNo,
          RHSContainerNo: objSelMenu.RHSContainerNo,
          NoOfStations: equipmentData.Machine_Punches,
          IPQCType: cubicalRes.Sys_IPQCType,
          CoatingType: "NA",
          MachineCode: cubicalRes.Sys_MachineCode,
          Department: cubicalRes.Sys_dept,
          MPN_Code: cubicalRes.Sys_MPNCode,
          BFGCode: cubicalRes.Sys_BFGCode,
          ProductName: cubicalRes.Sys_ProductName,
          PVersion: cubicalRes.Sys_PVersion,
          Version: cubicalRes.Sys_Version,
          BatchNo: cubicalRes.Sys_Batch,
          BatchSize: cubicalRes.Sys_BatchSize,
          Repetition: cubicalRes.Sys_Repetition,
          Test_Seq: 0,
          BMRNo: "",
          GraphType: "",
          Qty: productSampleRes.Individual,
          GrpQty: productSampleRes.Group,
          GrpFreq: "",
          Idsno: cubicalRes.Sys_IDSNo,
          DTID: (cubicalRes.Sys_DTID == 'None') ? 'NA' : cubicalRes.Sys_DTID,
          // FriabilityID: (cubicalRes.Sys_FriabID == 'None') ? 'NA' : cubicalRes.Sys_FriabID,
          // HardnessID: (cubicalRes.Sys_HardID == 'None') ? 'NA' : cubicalRes.Sys_HardID,
          // BalanceId: (cubicalRes.Sys_BalID == 'None') ? 'NA' : cubicalRes.Sys_BalID,
          // VernierId: (cubicalRes.Sys_VernierID == 'None') ? 'NA' : cubicalRes.Sys_VernierID,
          UserId: userObj.UserId,
          UserName: userObj.UserName,
          Param13_PrDate: moment().format("YYYY-MM-DD"),
          Param13_PrTime: moment().format("HH:mm:ss"),
          PrDate: moment().format("YYYY-MM-DD"),
          PrTime: moment().format("HH:mm:ss"),
          PrEndDate: moment().format("YYYY-MM-DD"),
          PrEndTime: moment().format("HH:mm:ss"),
          IntervalStartTm: moment().format('YYYY-MM-DD HH:mm:ss'),
          SideNo: 0,
          Side: cubicalRes.Sys_RotaryType,
          Stage: "NA",
          LimitOn: 0,
          NMT: 0,
          Param13_Nom: productDetailsRes[param],
          Param13_Remark: dtRemark,
          Param13_FailRemark: dtRemark,
          Lot: cubicalRes.Sys_LotNo,
          Inprocess: 1,
          DsNo: value.dsNo,
          TabIp: value.tabIp,
          ReportType: cubicalRes.Sys_RptType,
          LHSContainerNo: objSelMenu.LHSContainerNo,
          RHSContainerNo: objSelMenu.RHSContainerNo,
          MesTestType: cubicalRes.MesTestType,
          MesSide: cubicalRes.MesSide,
        })

        currentRepSrNo = response._previousDataValues.RepSerNo
        await models.tbl_menu_sequence.update({
          RepSerNo: currentRepSrNo
        }, {
          where: {
            DS_Number: value.dsNo,
          }
        })
      }

      let dataObj = {
        cubicObj: cubicalRes,
        masterTable: getTableName.masterTable,
        masterTableIncomplete: getTableName.masterTableIncomplete,
        DsNo: value.dsNo
      }

      let check_master_SRno = await check_srNO.check_master_SRno1(dataObj)

      // let repSerNo = await this.lastInsertedRecords1(cubicalRes.Sys_Batch, cubicalRes.Sys_MPNCode, cubicalRes.Sys_RptType, dataObj.masterTableIncomplete, value.dsNo, value.tabIp);

      await models[detail_Incomplete].create({
        RepSerNo: currentRepSrNo,
        MstSerNo: check_master_SRno,
        RecSeqNo: 1,
        DataValue: value.dtValue,
        UserId: userObj.UserId,
        UserName: userObj.UserName,
        PrDate: moment().format("YYYY-MM-DD"),
        PrTime: moment().format("HH:mm:ss"),
        PrEndDate: moment().format("YYYY-MM-DD"),
        PrEndTime: moment().format("HH:mm:ss"),
        BFGCode: cubicalRes.Sys_BFGCode,
        ProductName: cubicalRes.Sys_ProductName,
        Version: cubicalRes.Sys_PVersion,
        PVersion: cubicalRes.Sys_Version,
        Side: cubicalRes.Sys_RotaryType,
        BatchNo: cubicalRes.Sys_Batch,
        InstrumentID: cubicalRes.Sys_DTID,
        Remark: 'NA',
        DataValueUnit: "mm:ss",
        isException: (dtRemark == 'Within limit') ? 0 : 1,
        Repetition: cubicalRes.Sys_Repetition,
        SFOID: cubicalRes.Sys_SFOID
      })

      let updateTimeInMaster = await models[getTableName.masterTableIncomplete].update({
        Param13_PrEndDate: moment().format("YYYY-MM-DD"),
        Param13_PrEndTime: moment().format("HH:mm:ss"),
        IntervalStopTm: moment().format('YYYY-MM-DD HH:mm:ss'),
        Param13_AvgNet: value.dtValue,
        Param13_MinWeight: value.dtValue,
        Param13_MaxWeight: value.dtValue,
        Param13_Remark: dtRemark,
      }, {
        where: {
          RepSerNo: currentRepSrNo
        }
      });



      if (DtObj.Eqp_Model == "EDI2SA") {
        mqttSender.sendData(
          value.dsNo, `Port ${value.ProtocolPortNo}:${mqttProtocol.DisplayResult}${value.dtValue}`
        );
      }

      let succesMsg = { status: 'success' }
      await objMonit.monit({
        case: 'TestDTWeight',
        Hmi: value.dsNo,
        data: {
          Weight: value.dtValue + " " + "mm:ss",
          Jar: cubicalRes.Sys_RotaryType,
          message: dtRemark
        }
      });
      let finalResult = dtRemark;
      if (dtRemark == 'Within limit') {
        finalResult = 'Test Completed'


        var count = await objCommonInsertOpt.updateMenuSequenceEntry(value.dsNo, value.tabIp, value.menuName, currentRepSrNo, getTableName.masterTableIncomplete, getTableName.masterTable, cubicalRes, objSelMenu.portNo, 'NA', 'NA', finalResult)
        succesMsg.PostingToMES = GLOBAL_NOMENCLATURE.PostingToMES

        await objMonit.monit({
          case: 'ReportStatus',
          Hmi: value.dsNo,
          data: {
            message: "DT Test Completed"
          }
        });


        await objMonit.monit({
          case: 'ReportStatus',
          Hmi: value.dsNo,
          data: {
            message: "DT Test Completed"
          }
        });
        await models.tbl_powerbackup.destroy({
          where: {
            DsNo: value.dsNo,
            TabIp: value.tabIp,
            WeighmentName: "Differential"
          }
        });

        let activity_msg = `${value.menuName} Completed on DS ${value.dsNo}`
        activity_msg = (cubicalRes.Sys_RotaryType == "NA") ? activity_msg : `${activity_msg} for side ${cubicalRes.Sys_RotaryType}`;

        let __activityObj = {
          strUserId: userObj.UserId,
          strUserName: userObj.UserName,
          batch: cubicalRes.Sys_Batch,
          activity: activity_msg,
        };

        await objActivityLog.ActivityLogEntry(__activityObj);
        await objInstrumentUsage.InstrumentUsage(
          "DT",
          value.dsNo,
          `tbl_instrumentlog_dt`,
          value.menuName,
          "completed",
          value.tabIp,
          userObj,
          cubicObjData,
        );

        if (cubicalRes.isManual == 1) {
          mqttSender.sendData(value.dsNo, `Port ${objSelMenu.portNo}:${GLOBAL_NOMENCLATURE.TestCompleted} ${finalResult}:OkBtn true`)
        }
      }

      succesMsg.message = finalResult
      // mqttSender.sendData(value.dsNo, `Port ${portNo}:${GLOBAL_NOMENCLATURE.TestCompleted} ${finalResult}:OkBtn false`)


      if (finalResult === "Out of limit") {
        let newRecord = await models["tbl_powerbackup"].create({
          DsNo: value.dsNo,
          TabIp: value.tabIp,
          isException: 1,
          menuName: value.menuName,
          WeighmentType: 1,
          ProductType: productMasterRes.ProductType,
          CubicalNo: cubicalRes.Sys_CubicNo,
          WeighmentName: GLOBAL_NOMENCLATURE.DTMenu, // it should be DT
          Userid: userObj.UserId,
          Sys_BFGCode: cubicalRes.Sys_BFGCode,
          Sys_Batch: cubicalRes.Sys_Batch,
          MPN_Code: cubicalRes.Sys_MPNCode,
          Sys_CubType: cubicalRes.Sys_CubType,
          ReportType: cubicalRes.Sys_RptType,
          Incomp_RepSerNo: currentRepSrNo,

        });

        console.log(newRecord);
      }

      return succesMsg
    } catch (error) {
      console.log(error)
    }



  }
  async skipMenu(value) {
    var dbMenuName = value.menuName
    dbMenuName = objCommonWeightment.getDbMenuSeqFromMenu(dbMenuName);


    var dsNo = value.dsNo
    var tabIp = value.tabIp

    var quer = `UPDATE tbl_menu_sequence SET ${dbMenuName}=null where DS_Number='${dsNo}' or TabIp = '${tabIp}'`;
    await sequelize.query(quer, { type: QueryTypes.UPDATE });

    // var menuSequenceTable_ = await models.tbl_menu_sequence.findAll({
    //   attributes: { exclude: ['DS_Number', 'UserId', 'RecNo', 'RepSerNo', 'TabIp'] },
    // })
    var menuSequenceTable = await models.tbl_menu_sequence.findOne({
      attributes: { exclude: ['DS_Number', 'UserId', 'RecNo', 'TabIp'] },
      where: {
        DS_Number: dsNo,
        TabIp: tabIp
      }
    })

    if (menuSequenceTable.RepSerNo != 0) {
      var count = 0;
      for (let ele in menuSequenceTable) {
        if (menuSequenceTable[`${ele}`] == 0 && ele !== 'RepSerNo') count++
      }
      if (count == 0) {
        let skip = true

        var repSerNo = await models.tbl_tab_initialmaster_incomplete.findAll({
          where: { RepSerNo: menuSequenceTable.RepSerNo }
        })

        // let portNo =repSerNo[0].portNo
        if (repSerNo.length != 0) {
          let side = repSerNo[0].Side
          repSerNo = menuSequenceTable.RepSerNo
          const cubicObj = globalData.arrIdsInfo.find((k) => k.DsNo == dsNo && k.TabIp == tabIp).cubicalData;
          let newRepSrno = await objCommonInsertOpt.moveIncompleteToCompleteInitial(repSerNo, menuSequenceTable, dsNo, tabIp, 'tbl_tab_initialmaster_incomplete', 'tbl_tab_initialmaster', cubicObj, "portNo", side, "eqpModel", skip)
          await objCommonInsertOpt.saveCompleteBatchData({ menuSequenceTable, dsNo, tabIp, cubicObj, newRepSrno })
        }
        else {
          await models.tbl_menu_sequence.destroy({ where: { DS_Number: dsNo, TabIp: tabIp } })
        }
      }
    }

    return { "status": "success", result: "Menu skip successfully" }
  }
  async exceptionFTPIndividual(obj, getTableName, remark) {

    try {
      let cubicalData = obj.cubicObj
      let menuName = obj.menuName
      let DsNo = obj.DsNo
      let TabIp = obj.TabIp
      let tempUserObject = obj.UserData
      let masterTable = getTableName.masterTable;
      let exceptionTable = 'tbl_exception_sample_initial';


      let menuSequenceTable = await models.tbl_menu_sequence.findOne({
        attributes: { exclude: ['DS_Number', 'UserId', 'RecNo', 'RepSerNo', 'TabIp'] },
        where: {
          DS_Number: DsNo,
          TabIp: TabIp
        }
      })

      var count = 0;

      for (let ele in menuSequenceTable) {
        if (menuSequenceTable[`${ele}`] == 0) count++

      }

      if (count != 0) {
        masterTable = getTableName.masterTableIncomplete
      }

      let masterData = await models[masterTable].findAll({
        // attributes: ['BatchNo','IDSNo',[sequelize.fn('max', sequelize.col('RepSerNo')), 'RepSerNo']],
        where: {
          DsNo: DsNo,
          TabIp: TabIp,
          MPN_Code: cubicalData.Sys_MPNCode,
          BatchNo: cubicalData.Sys_Batch,
          SFOID: cubicalData.Sys_SFOID,
          Repetition : cubicalData.Sys_Repetition
        },
        //  group: ['BatchNo', 'DsNo']
         order: [['RepSerNo', 'DESC']]
      })

      if (masterData.length > 0) {

        // let InstrumentData = await models.tbl_otherequipment.findOne({
        //   attributes : ['Eqp_Make'],
        //   where: {
        //       Eqp_ID: cubicalData.Sys_HardID
        //   }
        // })

        // if(InstrumentData.Eqp_Make == 'Pharmatest'){
        // await models.tbl_exception_sample_initial.update({
        //   Remark: remark
        // }, {
        //   where: {
        //     RepSerNo: masterData[0].RepSerNo
        //   }
        // })
        // }

        await models[exceptionTable].update({
          Remark: remark
        }, {
          where: {
            RepSerNo: masterData[0].RepSerNo,
            BatchNo: masterData[0].BatchNo,
            // IDSNo: masterData[0].DsNo,
            Repetition: masterData[0].Repetition,
            SFOID: masterData[0].SFOID
          }
        })



        await models.tbl_activity_log.create({
          dt: moment().format('YYYY-MM-DD'),
          tm: moment().format('HH:mm:ss'),
          userid: tempUserObject.UserId,
          username: tempUserObject.UserName,
          activity: `${menuName} Sample Cleared 
          with remark: ${remark}`
        })

        await models.tbl_batch_log.create({
          dt: moment().format('YYYY-MM-DD'),
          tm: moment().format('HH:mm:ss'),
          userid: tempUserObject.UserId,
          username: tempUserObject.UserName,
          BatchNo: cubicalData.Sys_Batch,
          activity: `${menuName} Sample Cleared 
          with remark: ${remark}`
        })
        await models.tbl_powerbackup.destroy({
          where: {
            DsNo: DsNo,
            TabIp: TabIp,
            WeighmentName: "Individual"
          }
        });
      }

      return { status: "success" };
    } catch (error) {
      console.log(error)
    }



  }
  // async fileException(value) {
  //   try {
  //     let menuName = value.menuName.replace(/\_/g, " ");
  //     let dsNo = value.dsNo;
  //     let tabIp = value.tabIp;
  //     let remark = value.remark;
  //     let side = value.side ? value.side : 'LHS'
  //     let typeValue;
  //     switch (menuName) {
  //       case GLOBAL_NOMENCLATURE.IndividualMenu:
  //         typeValue = 1;
  //         break;
  //       case GLOBAL_NOMENCLATURE.GroupMenu:
  //         typeValue = 2;
  //         break;
  //     }

  //     let cubicObj = globalData.arrIdsInfo.find((k) => k.DsNo == dsNo).cubicalData;
  //     let productType = (cubicObj.Sys_CubType == "Capsule Filling" || cubicObj.Sys_IPQCType == "Capsule Filling") ? 'cap' : 'tab';
  //     let masterTableName;
  //     let detailTableName;

  //     switch (menuName) {
  //       case GLOBAL_NOMENCLATURE.GroupMenu:
  //         masterTableName = `tbl_${productType}_master${typeValue}`;
  //         detailTableName = `tbl_${productType}_detail${typeValue}`;
  //         break;

  //       default:
  //         masterTableName = `tbl_${productType}_master${typeValue}_incomplete`;
  //         detailTableName = `tbl_${productType}_detail${typeValue}_incomplete`
  //         break;
  //     }


  //     if (menuName == GLOBAL_NOMENCLATURE.GroupMenu) {
  //       let masterData = await models[masterTableName].findAll({
  //         attributes: [[sequelize.fn('max', sequelize.col('RepSerNo')), 'RepSerNo']],
  //         where: {
  //           BFGCode: cubicObj.Sys_BFGCode,
  //           ProductName: cubicObj.Sys_ProductName,
  //           PVersion: cubicObj.Sys_PVersion,
  //           Version: cubicObj.Sys_Version,
  //           BatchNo: cubicObj.Sys_Batch,
  //           CubicleType: cubicObj.Sys_CubType,
  //           ReportType: cubicObj.Sys_RptType,
  //           Side: side,
  //         }
  //       })

  //       if (masterData.length > 0) {
  //         let Id = await models.tbl_exception_sample.findAll({
  //           attributes: [[sequelize.fn('max', sequelize.col('id')), 'ID']],
  //           where: {
  //             RepSerNo: masterData[0].RepSerNo,
  //             MenuName: GLOBAL_NOMENCLATURE.GroupMenu,
  //           }
  //         })

  //         if (Id.length > 0) {
  //           await models.tbl_exception_sample.update(
  //             {
  //               Remark: remark
  //             }, {
  //             where: {
  //               id: Id[0].ID
  //             }
  //           }
  //           )
  //         }

  //         return { status: "success" };
  //       }
  //     }

  //     let masterData = await models[masterTableName].findAll({
  //       attributes: [[sequelize.fn('max', sequelize.col('RepSerNo')), 'RepSerNo']],
  //       where: { DsNo: dsNo, TabIp: tabIp }
  //     })
  //     if (masterData.length > 0) {
  //       let detailData = await models[detailTable].findAll({
  //         attributes: [[sequelize.fn('max', sequelize.col('RecNo')), 'RecNo']],
  //         where: {
  //           RepSerNo: masterData[0].RepSerNo
  //         }
  //       });
  //       if (detailData.length > 0) {
  //         await models[detailTable].update({ Remark: remark, isException: 1 }, { where: { RecNo: detailData[0].RecNo } })
  //         await models.tbl_powerbackup.update({ isException: 1 }, { where: { Incomp_RepSerNo: masterData[0].RepSerNo } })
  //       }
  //     }

  //     return { status: "success" };

  //   } catch (err) {
  //     throw new Error(err);
  //   }
  // }

  async fraibilityNext(value) {
    console.log('Next button :', value)

    if (!value.proceed || value.proceed == 'false') {
      let userInfo = globalData.arrUsers.find(k => k.DsNo == value.dsNo && k.TabIp == value.tabIp)
      let cubicInfo = globalData.arrIdsInfo.find(k => k.DsNo == value.dsNo)
      let objActivity = {}
      Object.assign(objActivity,
        { strUserId: userInfo.UserId },
        { strUserName: userInfo.UserName },
        { batch: cubicInfo.Sys_Batch },
        { activity: `Friability reperform for ${value.after ? 'after' : 'before'} weight : ${value.weight}` });

      await objActivityLog.ActivityLogEntry(objActivity);
      return { statusCode: 200, status: 'success' }
    } else {
      let selectedmenu = globalData.arrSelectedMenu.find(k => k.DsNo == value.dsNo && k.TabIp == value.tabIp)
      selectedmenu.nextFlag = value.proceed
      let cubicaldata = await models.tbl_cubical.findOne({
        where: {
          Sys_DSNumber: value.dsNo
        }
      })


      let Instrument = await models.tbl_balance.findOne({
        where: {
          Bal_ID: cubicaldata.Sys_BalID
        }
      })
      let strProtocol = (Instrument.Bal_Model == 'BSA423') ? `ComRead:${value.portNo}:1 + ${value.weight}` : `ComRead:${value.portNo}:${value.weight}`
      let response = mqttSender.sendData(value.dsNo, strProtocol)
      console.log(response)

    }
  }

  findMaxKeyNonNull(obj) {
    let maxVal = -Infinity;
    let maxKey = null;

    for (const [key, value] of Object.entries(obj)) {
      const numValue = value !== null ? Number(value) : null;
      if (numValue !== null && numValue > maxVal) {
        maxVal = numValue;
        maxKey = key;
      }
    }

    return { maxKey: maxKey, maxVal: maxVal };
  }
}

module.exports = WeighmentModel;
