
const { number } = require('mathjs');
const Database = require('../database/clsQueryProcess');
const database = new Database();


// const sequelize = require('../../models').sequelize

// const { tbl_idsport_details } = require('../../models/init-models').initModels(sequelize)

// const { tbl_idsport_details } = require('../../config/dbConnection').models;
// const sequelize  = require('../../config/dbConnection').sequelize


const models = require('../../config/dbConnection').models;
const sequelize = require('../../config/dbConnection').sequelize;
const { QueryTypes } = require('sequelize');


class Hmi {

    async getHMIStatus(value) {
        let hmi = value.hmi;
        let resObj = {};
        const connectHmiDetailObj = await models.IdsPortDetails.findAll({
            where:
                { 'HMI': hmi },
        });
        let arrResult = await database.select(connectHmiDetailObj);
        if (arrResult[0][0] == undefined || arrResult[0][0] == "") {
            Object.assign(resObj, { status: "fail" }, { result: 'IDS Not Connected' });
            return resObj;
        }
        else {
            Object.assign(resObj, { status: "success" }, { result: arrResult[0][0] });
            return resObj;
        }
    }

    async getResbPiNoFromHmi(strHmi) {
        let hmiDetails = await models.tbl_rpi.findAll({ where: { "DS_NUMBER": strHmi } })
        hmiDetails[0].DS_IP = hmiDetails[0].DS_IP
        return [hmiDetails[0]];
        // let arrRes = await database.select(objHmi);
        //return arrRes[0];
    }


    async getRPiData(dsIp, ProtocolPortNo) {
        try {
            let rpiData = await models.tbl_rpi.findOne({ where: { DS_IP: dsIp } })
            let dsBindingDetail;
            if (rpiData && !isNaN(ProtocolPortNo)) {
                dsBindingDetail = await models.tbl_ds_binding.findAll({ where: { DS_NUMBER: rpiData.DS_NUMBER } })
                if (dsBindingDetail.length > 0) {
                    let filterPort = dsBindingDetail.filter(e => e.PortNo == ProtocolPortNo);
                    if (filterPort.length > 0) {
                        dsBindingDetail = filterPort[0]
                    } else {
                        return { message: "Invalid Port Received", DS_NUMBER: rpiData.DS_NUMBER };
                    }
                }
                return dsBindingDetail
            } else {
                return rpiData
            }

        } catch (error) {
            console.log(`Error getDsNoFromDsIp: ${error}`);
        }
    }

    async idsPortSetting(strHmi) {
        try {
            //to exclude idsport detail usage

            let objIdsPortDetails = await models.tbl_idsport_details.findAll({
                where:
                {
                    HMI: strHmi
                }

            })
            let resIdsPort = [objIdsPortDetails[0]]
            return resIdsPort[0]

        } catch (error) {

        }
    }
    async getAliasOfRPI(RPi) {
        try {
            let objIdsPortDetails = await models.tbl_rpi.findAll({
                where:
                {
                    RPIID: RPi
                }

            })
            let resIdsPort = [objIdsPortDetails[0]]
            return resIdsPort[0].IDSNo

        } catch (error) {

        }
    }

}
module.exports = Hmi;