//packages
const Joi = require('joi');

class MenuSchema {

    static ValidateGetMenu(value) {
        const ValidateSchema = Joi.object({
            dsNo: Joi.string().trim().required().not('', null, 'undefined'),
            userId: Joi.string().trim().required().not('', null, 'undefined'),
            // userName: Joi.string().trim().required().not('', null, 'undefined'),
            tabIp: Joi.string().trim().required().not('', null, 'undefined')
        })
        return ValidateSchema;
    }

    static ValidatesubGetMenu(value) {
        const ValidateSchema = Joi.object({
            Hmi: Joi.string().trim().required().not('', null, 'undefined'),
            userId: Joi.string().trim().required().not('', null, 'undefined'),
            userName: Joi.string().trim().required().not('', null, 'undefined'),
            menuName: Joi.string().trim().required().not('', null, 'undefined'),
        })
        return ValidateSchema;
    }

    static ValidateOnMenuStart(value) {
        const ValidateSchema = Joi.object({
            dsNo: Joi.string().required().not('', null, 'undefined'),
            tabIp: Joi.string().required().not('', null, 'undefined'),
            menuName: Joi.string().required().not('', null, 'undefined'),
            isPowerBackup: Joi.boolean().required(),
            isFTP: Joi.boolean().required()
        })
        return ValidateSchema;
    }

    static ValidateGetBarcodeData(value) {
        const ValidateSchema = Joi.object({
            dsNo: Joi.string().trim().required().not('', null, 'undefined'),
            tabIp: Joi.string().trim().required().not('', null, 'undefined'),
            userId: Joi.string().trim().required().not('', null, 'undefined'),
            // productId: Joi.string().trim().required().not('', null, 'undefined'),
            // productName: Joi.string().trim().required().not('', null, 'undefined'),
            mpr: Joi.string().trim().required().not('', null, 'undefined'),
            batch: Joi.string().trim().required().not('', null, 'undefined'),
            sfoId: Joi.string().trim().required().not('', null, 'undefined'),
            // userName: Joi.string().trim().required().not('', null, 'undefined'),
        })
        return ValidateSchema;
    }
}

module.exports = MenuSchema;
