//packages
const Joi = require('joi');

class WeighmentSchema {

    static ValidateTestStart() {
        const validateSchema = Joi.object().keys({
            dsNo: Joi.string().required().trim().not('', null, 'undefined'),
            userId: Joi.string().required().trim().not('', null, 'undefined'),
            userName: Joi.string().required().trim().not('', null, 'undefined'),
            menuName: Joi.string().required().trim().not('', null, 'undefined'),
            noOfSample: Joi.string().not(null).required().allow(''),
            Rotary: Joi.string().required().trim().not('', null, 'undefined'),
            Side: Joi.string().required().trim().not('', null, 'undefined'),
            ProductId: Joi.string().required().trim().not('', null, 'undefined'),
            ProductName: Joi.string().required().trim().not('', null, 'undefined'),
            Batch: Joi.string().required().trim().not('', null, 'undefined'),
            Nominal: Joi.string().required().trim().not('', null, 'undefined'),
            Dp: Joi.string().required().trim().not('', null, 'undefined'),
            T1Neg: Joi.string().required().trim().not('', null, 'undefined'),
            T1Pos: Joi.string().required().trim().not('', null, 'undefined'),
            T2Neg: Joi.string().not(null).required().allow(''),
            T2Pos: Joi.string().not(null).required().allow(''),
            containerId : Joi.string().not(null).required().allow(''),
            // IP: Joi.string().not(null).required().allow(''),
            // column: Joi.array().not(null).allow(''),
            // type: Joi.string().not(null).allow(''),
            // LotNo: Joi.string().not(null),
            AirVibrationLimit: Joi.string().required().trim().not('', null, 'undefined'),
            editableSide: Joi.boolean().not(null).allow(''),
            editableSampleNo: Joi.boolean().not(null).allow(''),
        })
        return validateSchema
    }
    static ValidateDoubleRotary() {
        const doubledata = Joi.object().keys({
            Hmi: Joi.string().required().not(['', null, 'undefined']),
            Side: Joi.string().required().not(['', null, 'undefined']),
        });
        return doubledata;
    }

    static ValidateIPCTestStart(value) {
        const validateIpcSchema = Joi.object({
            dsNo: Joi.string().required().not([null, 'undefined']),
            userid: Joi.string().required().not([null, 'undefined']),
            userName: Joi.string().required().not([null, 'undefined']),
            menuName: Joi.string().required().not([null, 'undefined']),
            BFGCode: Joi.string().required().not([null, 'undefined']),
            ProdName: Joi.string().required().not([null, 'undefined']),
            ProdVersion: Joi.string().required().not([null, 'undefined']),
            Version: Joi.string().required().not([null, 'undefined']),
            batch: Joi.string().required().not([null, 'undefined']),
            TareWt: Joi.string().required().not([null, 'undefined']),
            menuName: Joi.string().required().not([null, 'undefined']),

        })

        return validateIpcSchema.validate(value);
    }

    static ValidateFileException(value) {
        const validateFileExceptionSchema = Joi.object({
            remark: Joi.string().trim().required().not('', null, 'undefined'),
            dsNo: Joi.string().trim().required().not('', null, 'undefined'),
            tabIp: Joi.string().trim().required().not('', null, 'undefined'),
            menuName: Joi.string().trim().required().not('', null, 'undefined'),
            menuName: Joi.string().trim().optional().not('', null, 'undefined'),
            side: Joi.string().trim().optional().not('', null, 'undefined'),
            ftp: Joi.string().trim().optional().not('', null, 'undefined'),
        })

        return validateFileExceptionSchema.validate(value);
    }

    static validateDTData(value) {
        const validateFileExceptionSchema = Joi.object({
            dsNo: Joi.string().trim().required().not('', null, 'undefined'),
            tabIp: Joi.string().trim().required().not('', null, 'undefined'),
            menuName: Joi.string().trim().required().not('', null, 'undefined'),
            side: Joi.string().trim().optional().not('', null, 'undefined'),
            dtValue: Joi.string().trim().optional().not('', null, 'undefined'),
        })

        return validateFileExceptionSchema.validate(value);
    }
    static ValidateskipMenu(value) {
        const ValidateskipMenu = Joi.object({
            dsNo: Joi.string().trim().required().not('', null, 'undefined'),
            tabIp: Joi.string().trim().required().not('', null, 'undefined'),
            menuName: Joi.string().trim().required().not('', null, 'undefined'),
        })

        return ValidateskipMenu.validate(value);
    }
    
    static ValidateFriabilityNext(value){
        const validateFriabilityNext = Joi.object({
            // remark: Joi.string().trim().required().not('', null, 'undefined'),
            dsNo: Joi.string().trim().required().not('', null, 'undefined'),
            tabIp: Joi.string().trim().required().not('', null, 'undefined'),
            menuName: Joi.string().trim().required().not('', null, 'undefined'),
            side: Joi.string().trim().optional().not('', null, 'undefined'),
            weight : Joi.string().trim().optional().not('',null,'undefined'),
            proceed: Joi.boolean().invalid('',null, 'undefined'),
            after: Joi.boolean().invalid('',null, 'undefined'),
            // before: Joi.boolean().invalid('',null, 'undefined'),
            dsIp: Joi.string().trim().optional().not('',null,'undefined'),
            portNo: Joi.string().trim().optional().not('',null,'undefined')
            // ftp: Joi.string().trim().optional().not('', null, 'undefined'),
        })

        return validateFriabilityNext.validate(value)
    }

}

module.exports = WeighmentSchema;
