const express = require("express");
const path = require("path");
const app = express();
const ackApp = express();
const cors = require("cors");
const bodyParser = require("body-parser");
const sequelize = require("./config/dbConnection").sequelize;
const { QueryTypes } = require("sequelize");
const mssql = require("mssql");
const xmlparser = require("express-xml-bodyparser");
 
//Middleware for Interface XML Routes
app.use(express.static(path.join(__dirname, "")));
app.use(cors({ credentials: true, origin: true }));
app.use(bodyParser.json());
app.use(express.json());
app.use(express.urlencoded({ extended: false }));
app.use(xmlparser());

ackApp.use(express.static(path.join(__dirname, "")));
ackApp.use(cors({ credentials: true, origin: true }));
ackApp.use(bodyParser.json());
ackApp.use(express.json());
ackApp.use(express.urlencoded({ extended: false }));
ackApp.use(xmlparser());

//module import
require("./INTERFACE/model/Mqtt/mqtt.model");
require('./INTERFACE/model/processHardnessInstrument')
const serverConfig = require("./INTERFACE/global/serverConfig");
const calibrationStatus = require('./INTERFACE/routes/calibrationStatusRoute.js');
const login = require("./INTERFACE/routes/login.route");
const menuRequest = require("./INTERFACE/routes/menu_Request_Route");
const weighmentRoute = require("./INTERFACE/routes/weighment.route");
const exceptionRoute = require("./INTERFACE/routes/exceptionFromAndriod");
const mesRoutes = require("./INTERFACE/routes/mes.route");
const ackRoutes = require("./INTERFACE/routes/ack.route");
const ipqcRoute = require('./INTERFACE/routes/ipqc.route');
const routes = require("./INTERFACE/routes/mes_api.route.js");
// const tcp = require('./INTERFACE/model/Mqtt/tcpServer.js');
const { re } = require("mathjs");


//Middleware for Interface Routes
app.use('/INTERFACE/CalibrationStatus', calibrationStatus);
app.use("/INTERFACE/login", login);
app.use("/INTERFACE/Menu", menuRequest);
app.use("/INTERFACE/Weighment", weighmentRoute);
app.use("/INTERFACE/AndriodException", exceptionRoute);
app.use('/INTERFACE/IPQC', ipqcRoute)
app.use("/api", mesRoutes);
app.use("/MES", routes);

ackApp.use("/api", ackRoutes);


app.listen(serverConfig.INTERFACE_NO, serverConfig.HOST_IP, async () => {
  // await sequelize.query(`update tbl_users set active = 0,loginatmpt = 0,autoEnbl = 0,Status = 0,suspensionPeriod = 0 where (source = "hardware"|| source ="")`, { type: QueryTypes.UPDATE })
  var quer = `UPDATE tbl_users SET active = 0,loginatmpt = 0,autoEnbl = 0,Status = 0 WHERE source = 'Hardware'`;
  await sequelize.query(quer, { type: QueryTypes.UPDATE });
  console.log(
    `INTERFACE SERVER STARTED ON : ${serverConfig.HOST_IP}:${serverConfig.INTERFACE_NO}....`
  );
  app.listen(serverConfig.MESPort, serverConfig.HOST_IP, async () => {
    console.log(
      `MES SERVER STARTED ON : ${serverConfig.HOST_IP}:${serverConfig.MESPort}....`
    );
  });
  ackApp.listen(serverConfig.MESPortAck, serverConfig.HOST_IP, async () => {
    console.log(
      `MES ACK SERVER STARTED ON : ${serverConfig.HOST_IP}:${serverConfig.MESPortAck}....`
    );
  });
  app.listen(4000, serverConfig.HOST_IP, async () => {
    console.log(
      `MES SERVER STARTED ON : ${serverConfig.HOST_IP}:${4000}....`
    );
  });
  ackApp.listen(4001, serverConfig.HOST_IP, async () => {
    console.log(
      `MES ACK SERVER STARTED ON : ${serverConfig.HOST_IP}:${4001}....`
    );
  });
  app.listen(5000, serverConfig.HOST_IP, async () => {
    console.log(
      `MES SERVER STARTED ON : ${serverConfig.HOST_IP}:${5000}....`
    );
  });
  ackApp.listen(5001, serverConfig.HOST_IP, async () => {
    console.log(
      `MES ACK SERVER STARTED ON : ${serverConfig.HOST_IP}:${5001}....`
    );
  });
  app.listen(6000, serverConfig.HOST_IP, async () => {
    console.log(
      `MES SERVER STARTED ON : ${serverConfig.HOST_IP}:${6000}....`
    );
  });
  ackApp.listen(6001, serverConfig.HOST_IP, async () => {
    console.log(
      `MES ACK SERVER STARTED ON : ${serverConfig.HOST_IP}:${6001}....`
    );
  });
});
process.on('uncaughtException', (err, origin) => {
  console.log(err);
  console.log('error came');
})
