import { TokenClaims } from "./TokenClaims";
/**
 * Account object with the following signature:
 * - homeAccountId          - Home account identifier for this account object
 * - environment            - Entity which issued the token represented by the domain of the issuer (e.g. login.microsoftonline.com)
 * - tenantId               - Full tenant or organizational id that this account belongs to
 * - username               - preferred_username claim of the id_token that represents this account
 * - localAccountId         - Local, tenant-specific account identifer for this account object, usually used in legacy cases
 * - name                   - Full name for the account, including given name and family name
 * - idToken                - raw ID token
 * - idTokenClaims          - Object contains claims from ID token
 * - localAccountId         - The user's account ID
 * - nativeAccountId        - The user's native account ID
 */
export declare type AccountInfo = {
    homeAccountId: string;
    environment: string;
    tenantId: string;
    username: string;
    localAccountId: string;
    name?: string;
    idToken?: string;
    idTokenClaims?: TokenClaims & {
        [key: string]: string | number | string[] | object | undefined | unknown;
    };
    nativeAccountId?: string;
    authorityType?: string;
};
export declare type ActiveAccountFilters = {
    homeAccountId: string;
    localAccountId: string;
};
//# sourceMappingURL=AccountInfo.d.ts.map