/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.barcode4j;

import net.sf.jasperreports.components.barcode4j.BarcodeComponent;
import net.sf.jasperreports.components.barcode4j.BarcodeUtils;
import net.sf.jasperreports.components.barcode4j.BarcodeVisitor;
import net.sf.jasperreports.components.barcode4j.CodabarComponent;
import net.sf.jasperreports.components.barcode4j.Code128Component;
import net.sf.jasperreports.components.barcode4j.Code39Component;
import net.sf.jasperreports.components.barcode4j.DataMatrixComponent;
import net.sf.jasperreports.components.barcode4j.EAN128Component;
import net.sf.jasperreports.components.barcode4j.EAN13Component;
import net.sf.jasperreports.components.barcode4j.EAN8Component;
import net.sf.jasperreports.components.barcode4j.FourStateBarcodeComponent;
import net.sf.jasperreports.components.barcode4j.Interleaved2Of5Component;
import net.sf.jasperreports.components.barcode4j.PDF417Component;
import net.sf.jasperreports.components.barcode4j.POSTNETComponent;
import net.sf.jasperreports.components.barcode4j.RoyalMailCustomerComponent;
import net.sf.jasperreports.components.barcode4j.UPCAComponent;
import net.sf.jasperreports.components.barcode4j.UPCEComponent;
import net.sf.jasperreports.components.barcode4j.USPSIntelligentMailComponent;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JasperReportsContext;
import org.krysalis.barcode4j.BaselineAlignment;
import org.krysalis.barcode4j.ChecksumMode;
import org.krysalis.barcode4j.HumanReadablePlacement;
import org.krysalis.barcode4j.impl.AbstractBarcodeBean;
import org.krysalis.barcode4j.impl.codabar.CodabarBean;
import org.krysalis.barcode4j.impl.code128.Code128Bean;
import org.krysalis.barcode4j.impl.code128.EAN128Bean;
import org.krysalis.barcode4j.impl.code39.Code39Bean;
import org.krysalis.barcode4j.impl.datamatrix.DataMatrixBean;
import org.krysalis.barcode4j.impl.datamatrix.SymbolShapeHint;
import org.krysalis.barcode4j.impl.fourstate.AbstractFourStateBean;
import org.krysalis.barcode4j.impl.fourstate.RoyalMailCBCBean;
import org.krysalis.barcode4j.impl.fourstate.USPSIntelligentMailBean;
import org.krysalis.barcode4j.impl.int2of5.Interleaved2Of5Bean;
import org.krysalis.barcode4j.impl.pdf417.PDF417Bean;
import org.krysalis.barcode4j.impl.postnet.POSTNETBean;
import org.krysalis.barcode4j.impl.upcean.EAN13Bean;
import org.krysalis.barcode4j.impl.upcean.EAN8Bean;
import org.krysalis.barcode4j.impl.upcean.UPCABean;
import org.krysalis.barcode4j.impl.upcean.UPCEBean;
import org.krysalis.barcode4j.tools.UnitConv;

public abstract class AbstractBarcodeEvaluator
implements BarcodeVisitor {
    protected final JasperReportsContext jasperReportsContext;
    protected final JRComponentElement componentElement;
    protected final BarcodeComponent barcodeComponent;
    protected final JRDefaultStyleProvider defaultStyleProvider;
    protected String message;
    protected AbstractBarcodeBean barcode;

    protected AbstractBarcodeEvaluator(JasperReportsContext jasperReportsContext, JRComponentElement componentElement, JRDefaultStyleProvider defaultStyleProvider) {
        this.jasperReportsContext = jasperReportsContext;
        this.componentElement = componentElement;
        this.barcodeComponent = (BarcodeComponent)componentElement.getComponent();
        this.defaultStyleProvider = defaultStyleProvider;
    }

    protected AbstractBarcodeEvaluator(JRComponentElement componentElement, JRDefaultStyleProvider defaultStyleProvider) {
        this(DefaultJasperReportsContext.getInstance(), componentElement, defaultStyleProvider);
    }

    public void evaluateBarcode() {
        BarcodeComponent barcodeComponent = (BarcodeComponent)this.componentElement.getComponent();
        barcodeComponent.receive(this);
    }

    public String getMessage() {
        return this.message;
    }

    public AbstractBarcodeBean getBarcode() {
        return this.barcode;
    }

    protected void setBaseAttributes(BarcodeComponent barcodeComponent) {
        Double vQuietZone;
        Double quietZone;
        String textPlacement;
        Double moduleWidth;
        JRStyle style = this.getElementStyle();
        if (style != null) {
            Float fontSize;
            String fontName = style.getFontName();
            if (fontName != null) {
                this.barcode.setFontName(fontName);
            }
            if ((fontSize = style.getFontsize()) != null) {
                double barFontSize = UnitConv.pt2mm((double)fontSize.floatValue());
                this.barcode.setFontSize(barFontSize);
            }
        }
        if ((moduleWidth = barcodeComponent.getModuleWidth()) != null) {
            this.barcode.setModuleWidth(UnitConv.pt2mm((double)moduleWidth));
        }
        if ((textPlacement = barcodeComponent.getTextPosition()) != null) {
            this.barcode.setMsgPosition(HumanReadablePlacement.byName((String)textPlacement));
        }
        if ((quietZone = barcodeComponent.getQuietZone()) != null) {
            this.barcode.doQuietZone(true);
            this.barcode.setQuietZone(UnitConv.pt2mm((double)quietZone));
        }
        if ((vQuietZone = barcodeComponent.getVerticalQuietZone()) != null) {
            this.barcode.setVerticalQuietZone(UnitConv.pt2mm((double)vQuietZone));
        }
        double barcodeHeight = BarcodeUtils.isVertical(barcodeComponent) ? UnitConv.pt2mm((double)this.componentElement.getWidth()) : UnitConv.pt2mm((double)this.componentElement.getHeight());
        this.barcode.setHeight(barcodeHeight);
    }

    protected JRStyle getElementStyle() {
        JRStyle style = this.componentElement.getStyle();
        if (style == null) {
            style = this.defaultStyleProvider.getDefaultStyle();
        }
        return style;
    }

    @Override
    public void visitCodabar(CodabarComponent codabar) {
        CodabarBean codabarBean = new CodabarBean();
        this.barcode = codabarBean;
        this.evaluateCodabar(codabar);
        this.setBaseAttributes(codabar);
        if (codabar.getWideFactor() != null) {
            codabarBean.setWideFactor(codabar.getWideFactor().doubleValue());
        }
    }

    protected abstract void evaluateCodabar(CodabarComponent var1);

    @Override
    public void visitCode128(Code128Component code128) {
        this.barcode = new Code128Bean();
        this.evaluateCode128(code128);
        this.setBaseAttributes(code128);
    }

    protected abstract void evaluateCode128(Code128Component var1);

    @Override
    public void visitDataMatrix(DataMatrixComponent dataMatrix) {
        DataMatrixBean dataMatrixBean = new DataMatrixBean();
        this.barcode = dataMatrixBean;
        this.evaluateDataMatrix(dataMatrix);
        this.setBaseAttributes(dataMatrix);
        if (dataMatrix.getShape() != null) {
            dataMatrixBean.setShape(SymbolShapeHint.byName((String)dataMatrix.getShape()));
        }
    }

    protected abstract void evaluateDataMatrix(DataMatrixComponent var1);

    @Override
    public void visitEANCode128(EAN128Component ean128) {
        EAN128Bean ean128Bean = new EAN128Bean();
        this.barcode = ean128Bean;
        this.evaluateEANCode128(ean128);
        this.setBaseAttributes(ean128);
        if (ean128.getChecksumMode() != null) {
            ean128Bean.setChecksumMode(ChecksumMode.byName((String)ean128.getChecksumMode()));
        }
    }

    protected abstract void evaluateEANCode128(EAN128Component var1);

    @Override
    public void visitCode39(Code39Component code39) {
        Code39Bean code39Bean = new Code39Bean();
        this.barcode = code39Bean;
        this.evaluateCode39(code39);
        this.setBaseAttributes(code39);
        if (code39.getChecksumMode() != null) {
            code39Bean.setChecksumMode(ChecksumMode.byName((String)code39.getChecksumMode()));
        }
        if (code39.isDisplayChecksum() != null) {
            code39Bean.setDisplayChecksum(code39.isDisplayChecksum().booleanValue());
        }
        if (code39.isDisplayStartStop() != null) {
            code39Bean.setDisplayStartStop(code39.isDisplayStartStop().booleanValue());
        }
        if (code39.isExtendedCharSetEnabled() != null) {
            code39Bean.setExtendedCharSetEnabled(code39.isExtendedCharSetEnabled().booleanValue());
        }
        if (code39.getIntercharGapWidth() != null) {
            code39Bean.setIntercharGapWidth(code39.getIntercharGapWidth().doubleValue());
        }
        if (code39.getWideFactor() != null) {
            code39Bean.setWideFactor(code39.getWideFactor().doubleValue());
        }
    }

    protected abstract void evaluateCode39(Code39Component var1);

    protected abstract void evaluateInterleaved2Of5(Interleaved2Of5Component var1);

    @Override
    public void visitInterleaved2Of5(Interleaved2Of5Component interleaved2Of5) {
        Interleaved2Of5Bean interleaved2Of5Bean = new Interleaved2Of5Bean();
        this.barcode = interleaved2Of5Bean;
        this.evaluateInterleaved2Of5(interleaved2Of5);
        this.setBaseAttributes(interleaved2Of5);
        if (interleaved2Of5.getChecksumMode() != null) {
            interleaved2Of5Bean.setChecksumMode(ChecksumMode.byName((String)interleaved2Of5.getChecksumMode()));
        }
        if (interleaved2Of5.isDisplayChecksum() != null) {
            interleaved2Of5Bean.setDisplayChecksum(interleaved2Of5.isDisplayChecksum().booleanValue());
        }
        if (interleaved2Of5.getWideFactor() != null) {
            interleaved2Of5Bean.setWideFactor(interleaved2Of5.getWideFactor().doubleValue());
        }
    }

    @Override
    public void visitUPCA(UPCAComponent upcA) {
        UPCABean upcABean = new UPCABean();
        this.barcode = upcABean;
        this.evaluateUPCA(upcA);
        this.setBaseAttributes(upcA);
        if (upcA.getChecksumMode() != null) {
            upcABean.setChecksumMode(ChecksumMode.byName((String)upcA.getChecksumMode()));
        }
    }

    protected abstract void evaluateUPCA(UPCAComponent var1);

    @Override
    public void visitUPCE(UPCEComponent upcE) {
        UPCEBean upcEBean = new UPCEBean();
        this.barcode = upcEBean;
        this.evaluateUPCE(upcE);
        this.setBaseAttributes(upcE);
        if (upcE.getChecksumMode() != null) {
            upcEBean.setChecksumMode(ChecksumMode.byName((String)upcE.getChecksumMode()));
        }
    }

    protected abstract void evaluateUPCE(UPCEComponent var1);

    @Override
    public void visitEAN13(EAN13Component ean13) {
        EAN13Bean ean13Bean = new EAN13Bean();
        this.barcode = ean13Bean;
        this.evaluateEAN13(ean13);
        this.setBaseAttributes(ean13);
        if (ean13.getChecksumMode() != null) {
            ean13Bean.setChecksumMode(ChecksumMode.byName((String)ean13.getChecksumMode()));
        }
    }

    protected abstract void evaluateEAN13(EAN13Component var1);

    @Override
    public void visitEAN8(EAN8Component ean8) {
        EAN8Bean ean8Bean = new EAN8Bean();
        this.barcode = ean8Bean;
        this.evaluateEAN8(ean8);
        this.setBaseAttributes(ean8);
        if (ean8.getChecksumMode() != null) {
            ean8Bean.setChecksumMode(ChecksumMode.byName((String)ean8.getChecksumMode()));
        }
    }

    protected abstract void evaluateEAN8(EAN8Component var1);

    @Override
    public void visitRoyalMailCustomer(RoyalMailCustomerComponent royalMailCustomer) {
        RoyalMailCBCBean mailBean = new RoyalMailCBCBean();
        this.barcode = mailBean;
        this.evaluateRoyalMailCustomer(royalMailCustomer);
        this.setBaseAttributes(royalMailCustomer);
        this.setFourStateAttributes(royalMailCustomer, (AbstractFourStateBean)mailBean);
    }

    protected void setFourStateAttributes(FourStateBarcodeComponent barcodeComponent, AbstractFourStateBean barcodeBean) {
        if (barcodeComponent.getChecksumMode() != null) {
            barcodeBean.setChecksumMode(ChecksumMode.byName((String)barcodeComponent.getChecksumMode()));
        }
        if (barcodeComponent.getAscenderHeight() != null) {
            barcodeBean.setAscenderHeight(UnitConv.pt2mm((double)barcodeComponent.getAscenderHeight()));
        }
        if (barcodeComponent.getIntercharGapWidth() != null) {
            barcodeBean.setIntercharGapWidth(UnitConv.pt2mm((double)barcodeComponent.getIntercharGapWidth()));
        }
        if (barcodeComponent.getTrackHeight() != null) {
            barcodeBean.setTrackHeight(UnitConv.pt2mm((double)barcodeComponent.getTrackHeight()));
        }
    }

    protected abstract void evaluateRoyalMailCustomer(RoyalMailCustomerComponent var1);

    @Override
    public void visitUSPSIntelligentMail(USPSIntelligentMailComponent intelligentMail) {
        USPSIntelligentMailBean mailBean = new USPSIntelligentMailBean();
        this.barcode = mailBean;
        this.evaluateUSPSIntelligentMail(intelligentMail);
        this.setBaseAttributes(intelligentMail);
        this.setFourStateAttributes(intelligentMail, (AbstractFourStateBean)mailBean);
    }

    protected abstract void evaluateUSPSIntelligentMail(USPSIntelligentMailComponent var1);

    @Override
    public void visitPostnet(POSTNETComponent postnet) {
        POSTNETBean postnetBean = new POSTNETBean();
        this.barcode = postnetBean;
        this.evaluatePOSTNET(postnet);
        this.setBaseAttributes(postnet);
        if (postnet.getShortBarHeight() != null) {
            postnetBean.setShortBarHeight(UnitConv.pt2mm((double)postnet.getShortBarHeight()));
        }
        if (postnet.getBaselinePosition() != null) {
            postnetBean.setBaselinePosition(BaselineAlignment.byName((String)postnet.getBaselinePosition()));
        }
        if (postnet.getChecksumMode() != null) {
            postnetBean.setChecksumMode(ChecksumMode.byName((String)postnet.getChecksumMode()));
        }
        if (postnet.getDisplayChecksum() != null) {
            postnetBean.setDisplayChecksum(postnet.getDisplayChecksum().booleanValue());
        }
        if (postnet.getIntercharGapWidth() != null) {
            postnetBean.setIntercharGapWidth(UnitConv.pt2mm((double)postnet.getIntercharGapWidth()));
        }
    }

    protected abstract void evaluatePOSTNET(POSTNETComponent var1);

    @Override
    public void visitPDF417(PDF417Component pdf417) {
        PDF417Bean pdf417Bean = new PDF417Bean();
        this.barcode = pdf417Bean;
        this.evaluatePDF417(pdf417);
        this.setBaseAttributes(pdf417);
        if (pdf417.getMinColumns() != null) {
            pdf417Bean.setMinCols(pdf417.getMinColumns().intValue());
        }
        if (pdf417.getMaxColumns() != null) {
            pdf417Bean.setMaxCols(pdf417.getMaxColumns().intValue());
        }
        if (pdf417.getMinRows() != null) {
            pdf417Bean.setMinRows(pdf417.getMinRows().intValue());
        }
        if (pdf417.getMaxRows() != null) {
            pdf417Bean.setMaxRows(pdf417.getMaxRows().intValue());
        }
        if (pdf417.getWidthToHeightRatio() != null) {
            pdf417Bean.setWidthToHeightRatio(pdf417.getWidthToHeightRatio().doubleValue());
        }
        if (pdf417.getErrorCorrectionLevel() != null) {
            pdf417Bean.setErrorCorrectionLevel(pdf417.getErrorCorrectionLevel().intValue());
        }
    }

    protected abstract void evaluatePDF417(PDF417Component var1);
}

