'use strict'

const fs = require('fs')
const path = require('path')

const text = fs.readFileSync(path.join(__dirname, 'evolution-filter.txt'))
  .toString('utf8')
  .replace(/(\s+)\(/g, '(')
  .replace(/\s\)/, ')')
  .replaceAll('\n', '')

/**
 * This is the byte representation of the filter defined in
 * `evolution-filter.txt`. Said filter is part of the original "laundry.test"
 * suite in the `node-ldapjs` code (through at least `ldapjs@2`).
 *
 * @type {Buffer}
 */
const bytes = Buffer.from([
  0xa1, 0x82, 0x04, 0xa3, // sequence, 1187 bytes (OR filter: 0xa1, length: 0x04a3)

  0xa4, 0x0b, // substring filter, 11 bytes
  0x04, 0x02, // string, 2 bytes
  // "cn"
  0x63, 0x6e,
  0x30, 0x05, // sequence, 5 bytes
  0x80, 0x03, // subinitial string, 3 bytes
  // "ogo"
  0x6f, 0x67, 0x6f,

  0xa4, 0x12, // substring filter, 18 bytes
  0x04, 0x09, // string 9 bytes
  // "givenname"
  0x67, 0x69, 0x76, 0x65, 0x6e, 0x6e, 0x61, 0x6d, 0x65,
  0x30, 0x05, // sequence, 5 bytes
  0x80, 0x03, // string, 3 bytes
  // "ogo"
  0x6f, 0x67, 0x6f,

  // The above pattern repeats for all of the clauses in the
  // filter. Each pattern is chunked below as above, but not commented.

  0xa4, 0x0b,
  0x04, 0x02,
  0x73, 0x6e,
  0x30, 0x05,
  0x80, 0x03, 0x6f, 0x67, 0x6f,

  0xa4, 0x0d,
  0x04, 0x04,
  0x6d, 0x61, 0x69, 0x6c,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x0f,
  0x04, 0x06,
  0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x15,
  0x04, 0x0c,
  0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x70, 0x68, 0x6f, 0x6e, 0x65,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x18,
  0x04, 0x0f,
  0x74, 0x65, 0x6c, 0x65, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x12,
  0x04, 0x09,
  0x68, 0x6f, 0x6d, 0x65, 0x70, 0x68, 0x6f, 0x6e, 0x65,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x0f,
  0x04, 0x06,
  0x6d, 0x6f, 0x62, 0x69, 0x6c, 0x65,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x11,
  0x04, 0x08,
  0x63, 0x61, 0x72, 0x70, 0x68, 0x6f, 0x6e, 0x65,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x21,
  0x04, 0x18,
  0x66, 0x61, 0x63, 0x73, 0x69,
  0x6d, 0x69, 0x6c, 0x65, 0x74,
  0x65, 0x6c, 0x65, 0x70, 0x68,
  0x6f, 0x6e, 0x65, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x25,
  0x04, 0x1c,
  0x68, 0x6f, 0x6d, 0x65, 0x66,
  0x61, 0x63, 0x73, 0x69, 0x6d,
  0x69, 0x6c, 0x65, 0x74, 0x65,
  0x6c, 0x65, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x6e, 0x75,
  0x6d, 0x62, 0x65, 0x72,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x13,
  0x04, 0x0a,
  0x6f, 0x74, 0x68, 0x65, 0x72,
  0x70, 0x68, 0x6f, 0x6e, 0x65,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x26,
  0x04, 0x1d,
  0x6f, 0x74, 0x68, 0x65, 0x72,
  0x66, 0x61, 0x63, 0x73, 0x69,
  0x6d, 0x69, 0x6c, 0x65, 0x74,
  0x65, 0x6c, 0x65, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x6e,
  0x75, 0x6d, 0x62, 0x65, 0x72,
  0x30, 0x05,
  0x80, 0x03, 0x6f, 0x67, 0x6f,

  0xa4, 0x20,
  0x04, 0x17,
  0x69, 0x6e, 0x74, 0x65, 0x72,
  0x6e, 0x61, 0x74, 0x69, 0x6f,
  0x6e, 0x61, 0x6c, 0x69, 0x73,
  0x64, 0x6e, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x0e,
  0x04, 0x05,
  0x70, 0x61, 0x67, 0x65, 0x72,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x0e,
  0x04, 0x05,
  0x72, 0x61, 0x64, 0x69, 0x6f,
  0x30, 0x05,
  0x80, 0x03, 0x6f, 0x67, 0x6f,

  0xa4, 0x0e,
  0x04, 0x05,
  0x74, 0x65, 0x6c, 0x65, 0x78,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x17,
  0x04, 0x0e, 0x61, 0x73, 0x73,
  0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x70, 0x68, 0x6f,
  0x6e, 0x65,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x15,
  0x04, 0x0c,
  0x63, 0x6f, 0x6d, 0x70, 0x61, 0x6e, 0x79,
  0x70, 0x68, 0x6f, 0x6e, 0x65,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x16,
  0x04, 0x0d,
  0x63, 0x61, 0x6c, 0x6c,
  0x62, 0x61, 0x63, 0x6b, 0x70, 0x68, 0x6f, 0x6e, 0x65,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x0c,
  0x04, 0x03,
  0x74, 0x74, 0x79,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x0a,
  0x04, 0x01,
  0x6f,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x0b,
  0x04, 0x02,
  0x6f, 0x75,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x13,
  0x04, 0x0a,
  0x72,
  0x6f, 0x6f, 0x6d, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x0e,
  0x04, 0x05,
  0x74, 0x69, 0x74, 0x6c, 0x65,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x15,
  0x04, 0x0c,
  0x62, 0x75, 0x73, 0x69,
  0x6e, 0x65, 0x73, 0x73, 0x72, 0x6f, 0x6c, 0x65,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x14,
  0x04, 0x0b,
  0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x16,
  0x04, 0x0d,
  0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74,
  0x6e, 0x61, 0x6d, 0x65,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x16,
  0x04, 0x0d,
  0x70, 0x6f, 0x73, 0x74, 0x61,
  0x6c, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x0a,
  0x04, 0x01,
  0x6c,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x0b,
  0x04, 0x02,
  0x73, 0x74,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x16,
  0x04, 0x0d,
  0x70, 0x6f, 0x73, 0x74, 0x6f, 0x66,
  0x66, 0x69, 0x63, 0x65, 0x62, 0x6f, 0x78,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x13,
  0x04, 0x0a,
  0x70, 0x6f, 0x73, 0x74, 0x61, 0x6c, 0x63, 0x6f, 0x64, 0x65,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x0a,
  0x04, 0x01,
  0x63,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x1a,
  0x04, 0x11,
  0x68, 0x6f, 0x6d, 0x65, 0x70, 0x6f, 0x73, 0x74, 0x61,
  0x6c, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x20,
  0x04, 0x17,
  0x6d, 0x6f, 0x7a, 0x69, 0x6c, 0x6c, 0x61, 0x68, 0x6f, 0x6d, 0x65,
  0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x6e, 0x61,
  0x6d, 0x65,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x19,
  0x04, 0x10,
  0x6d, 0x6f, 0x7a, 0x69, 0x6c, 0x6c, 0x61,
  0x68, 0x6f, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x74, 0x65,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x1e,
  0x04, 0x15,
  0x6d, 0x6f, 0x7a, 0x69, 0x6c, 0x6c, 0x61, 0x68, 0x6f, 0x6d,
  0x65, 0x70, 0x6f, 0x73, 0x74, 0x61, 0x6c, 0x63, 0x6f, 0x64,
  0x65,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x1f,
  0x04, 0x16,
  0x6d, 0x6f, 0x7a, 0x69, 0x6c, 0x6c, 0x61, 0x68,
  0x6f, 0x6d, 0x65, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79,
  0x6e, 0x61, 0x6d, 0x65,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x1b,
  0x04, 0x12,
  0x6f, 0x74, 0x68, 0x65, 0x72,
  0x70, 0x6f, 0x73, 0x74, 0x61, 0x6c, 0x61, 0x64, 0x64, 0x72,
  0x65, 0x73, 0x73,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x12,
  0x04, 0x09,
  0x6a, 0x70, 0x65, 0x67, 0x70, 0x68,
  0x6f, 0x74, 0x6f,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x18,
  0x04, 0x0f, 0x75, 0x73, 0x65, 0x72, 0x63, 0x65,
  0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x13,
  0x04, 0x0a,
  0x6c, 0x61, 0x62, 0x65, 0x6c, 0x65, 0x64, 0x75, 0x72, 0x69,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x14,
  0x04, 0x0b,
  0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x6e, 0x61,
  0x6d, 0x65,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x13,
  0x04, 0x0a,
  0x73, 0x70, 0x6f, 0x75, 0x73, 0x65, 0x6e,
  0x61, 0x6d, 0x65, 0x30, 0x05, 0x80, 0x03, 0x6f, 0x67, 0x6f,
  0xa4, 0x0d, 0x04, 0x04, 0x6e, 0x6f, 0x74, 0x65,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x14,
  0x04, 0x0b,
  0x61, 0x6e, 0x6e, 0x69, 0x76, 0x65, 0x72, 0x73, 0x61, 0x72, 0x79,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x12,
  0x04, 0x09,
  0x62, 0x69, 0x72, 0x74, 0x68, 0x64, 0x61, 0x74, 0x65,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x0f,
  0x04, 0x06, 0x6d, 0x61, 0x69, 0x6c, 0x65, 0x72,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x0f,
  0x04, 0x06,
  0x66, 0x69, 0x6c, 0x65, 0x61, 0x73,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x11,
  0x04, 0x08,
  0x63, 0x61, 0x74, 0x65, 0x67,
  0x6f, 0x72, 0x79,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x12,
  0x04, 0x09,
  0x63, 0x61, 0x6c, 0x63, 0x61, 0x6c,
  0x75, 0x72, 0x69,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x11,
  0x04, 0x08,
  0x63, 0x61, 0x6c, 0x66, 0x62, 0x75,
  0x72, 0x6c,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f,

  0xa4, 0x14,
  0x04, 0x0b,
  0x69, 0x63, 0x73, 0x63, 0x61, 0x6c, 0x65,
  0x6e, 0x64, 0x61, 0x72,
  0x30, 0x05,
  0x80, 0x03,
  0x6f, 0x67, 0x6f
])

module.exports = { text, bytes }
