<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function ceil

Round a value towards plus infinity
If `x` is complex, both real and imaginary part are rounded towards plus infinity.
For matrices, the function is evaluated element wise.


## Syntax

```js
math.ceil(x)
math.ceil(x, n)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | number &#124; BigNumber &#124; Fraction &#124; Complex &#124; Array &#124; Matrix | Number to be rounded
`n` | number &#124; BigNumber &#124; Array | Number of decimals Default value: 0.

### Returns

Type | Description
---- | -----------
number &#124; BigNumber &#124; Fraction &#124; Complex &#124; Array &#124; Matrix | Rounded value


## Examples

```js
math.ceil(3.2)               // returns number 4
math.ceil(3.8)               // returns number 4
math.ceil(-4.2)              // returns number -4
math.ceil(-4.7)              // returns number -4

math.ceil(3.212, 2)          // returns number 3.22
math.ceil(3.288, 2)          // returns number 3.29
math.ceil(-4.212, 2)         // returns number -4.21
math.ceil(-4.782, 2)         // returns number -4.78

const c = math.complex(3.24, -2.71)
math.ceil(c)                 // returns Complex 4 - 2i
math.ceil(c, 1)              // returns Complex 3.3 - 2.7i

math.ceil([3.2, 3.8, -4.7])  // returns Array [4, 4, -4]
math.ceil([3.21, 3.82, -4.71], 1)  // returns Array [3.3, 3.9, -4.7]
```


## See also

[floor](floor.md),
[fix](fix.md),
[round](round.md)
