/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.util.List;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.export.ExporterFilter;
import net.sf.jasperreports.engine.export.ResetableExporterFilter;

public class ExporterFilterContainer
implements ResetableExporterFilter {
    private final List<ExporterFilter> filters;

    public ExporterFilterContainer(List<ExporterFilter> filters) {
        if (filters == null) {
            throw new JRRuntimeException("Null filters list");
        }
        this.filters = filters;
    }

    @Override
    public boolean isToExport(JRPrintElement element) {
        boolean export = true;
        for (ExporterFilter filter : this.filters) {
            if (filter.isToExport(element)) continue;
            export = false;
            break;
        }
        return export;
    }

    @Override
    public void reset() {
        for (ExporterFilter filter : this.filters) {
            if (!(filter instanceof ResetableExporterFilter)) continue;
            ((ResetableExporterFilter)filter).reset();
        }
    }
}

