/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.Serializable;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetListener;
import javax.sql.rowset.Joinable;

abstract class OracleRowSet
implements Serializable,
Cloneable,
Joinable {
    protected String dataSource;
    protected String dataSourceName;
    protected String url;
    protected String username;
    protected String password;
    protected Map typeMap;
    protected int maxFieldSize;
    protected int maxRows;
    protected int queryTimeout;
    protected int fetchSize;
    protected int transactionIsolation;
    protected boolean escapeProcessing;
    protected String command;
    protected int concurrency;
    protected boolean readOnly;
    protected int fetchDirection;
    protected int rowsetType;
    protected boolean showDeleted;
    protected Vector listener;
    protected RowSetEvent rowsetEvent;
    protected Vector matchColumnIndexes;
    protected Vector matchColumnNames;

    protected OracleRowSet() throws SQLException {
        this.initializeProperties();
        this.matchColumnIndexes = new Vector(10);
        this.matchColumnNames = new Vector(10);
        this.listener = new Vector();
        this.rowsetEvent = new RowSetEvent((RowSet)((Object)this));
    }

    protected void initializeProperties() {
        this.command = null;
        this.concurrency = 1007;
        this.dataSource = null;
        this.dataSourceName = null;
        this.escapeProcessing = true;
        this.fetchDirection = 1002;
        this.fetchSize = 0;
        this.maxFieldSize = 0;
        this.maxRows = 0;
        this.queryTimeout = 0;
        this.readOnly = true;
        this.showDeleted = false;
        this.transactionIsolation = 2;
        this.rowsetType = 1005;
        this.typeMap = new HashMap();
        this.username = null;
        this.password = null;
        this.url = null;
    }

    public String getCommand() {
        return this.command;
    }

    public int getConcurrency() throws SQLException {
        return this.concurrency;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public boolean getEscapeProcessing() throws SQLException {
        return this.escapeProcessing;
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public String getPassword() {
        return this.password;
    }

    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    public boolean getReadOnly() {
        return this.isReadOnly();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean getShowDeleted() {
        return this.showDeleted;
    }

    public int getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public int getType() throws SQLException {
        return this.rowsetType;
    }

    public Map getTypeMap() throws SQLException {
        return this.typeMap;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setCommand(String string) throws SQLException {
        this.command = string;
    }

    public void setConcurrency(int n) throws SQLException {
        if (n != 1007 && n != 1008) {
            throw new SQLException("Invalid concurrancy mode");
        }
        this.concurrency = n;
    }

    public void setDataSource(String string) {
        this.dataSource = string;
    }

    public void setDataSourceName(String string) throws SQLException {
        this.dataSourceName = string;
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.escapeProcessing = bl;
    }

    public void setFetchDirection(int n) throws SQLException {
        this.fetchDirection = n;
    }

    public void setFetchSize(int n) throws SQLException {
        this.fetchSize = n;
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.maxFieldSize = n;
    }

    public void setMaxRows(int n) throws SQLException {
        this.maxRows = n;
    }

    public void setPassword(String string) throws SQLException {
        this.password = string;
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.queryTimeout = n;
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.readOnly = bl;
    }

    public void setShowDeleted(boolean bl) throws SQLException {
        this.showDeleted = bl;
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.transactionIsolation = n;
    }

    public void setType(int n) throws SQLException {
        if (n != 1003 && n != 1004 && n != 1005) {
            throw new SQLException("Unknown RowSet type");
        }
        this.rowsetType = n;
    }

    public void setTypeMap(Map map) throws SQLException {
        this.typeMap = map;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public void setUsername(String string) throws SQLException {
        this.username = string;
    }

    public void addRowSetListener(RowSetListener rowSetListener) {
        for (int i = 0; i < this.listener.size(); ++i) {
            if (!this.listener.elementAt(i).equals(rowSetListener)) continue;
            return;
        }
        this.listener.add(rowSetListener);
    }

    public void removeRowSetListener(RowSetListener rowSetListener) {
        for (int i = 0; i < this.listener.size(); ++i) {
            if (!this.listener.elementAt(i).equals(rowSetListener)) continue;
            this.listener.remove(i);
        }
    }

    protected synchronized void notifyCursorMoved() {
        int n = this.listener.size();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                ((RowSetListener)this.listener.elementAt(i)).cursorMoved(this.rowsetEvent);
            }
        }
    }

    protected void notifyRowChanged() {
        int n = this.listener.size();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                ((RowSetListener)this.listener.elementAt(i)).rowChanged(this.rowsetEvent);
            }
        }
    }

    protected void notifyRowSetChanged() {
        int n = this.listener.size();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                ((RowSetListener)this.listener.elementAt(i)).rowSetChanged(this.rowsetEvent);
            }
        }
    }

    public int[] getMatchColumnIndexes() throws SQLException {
        int[] nArray;
        if (this.matchColumnIndexes.size() == 0 && this.matchColumnNames.size() == 0) {
            throw new SQLException("No match column indexes were set");
        }
        if (this.matchColumnNames.size() > 0) {
            String[] stringArray = this.getMatchColumnNames();
            int n = stringArray.length;
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = this.findColumn(stringArray[i]);
            }
        } else {
            int n = this.matchColumnIndexes.size();
            nArray = new int[n];
            int n2 = -1;
            for (int i = 0; i < n; ++i) {
                try {
                    n2 = (Integer)this.matchColumnIndexes.get(i);
                }
                catch (Exception exception) {
                    throw new SQLException("Invalid match column index");
                }
                if (n2 <= 0) {
                    throw new SQLException("Invalid match column index");
                }
                nArray[i] = n2;
            }
        }
        return nArray;
    }

    public String[] getMatchColumnNames() throws SQLException {
        this.checkIfMatchColumnNamesSet();
        int n = this.matchColumnNames.size();
        String[] stringArray = new String[n];
        String string = null;
        for (int i = 0; i < n; ++i) {
            try {
                string = (String)this.matchColumnNames.get(i);
            }
            catch (Exception exception) {
                throw new SQLException("Invalid match column name");
            }
            if (string == null || string.equals("")) {
                throw new SQLException("Invalid match column name");
            }
            stringArray[i] = string;
        }
        return stringArray;
    }

    public void setMatchColumn(int n) throws SQLException {
        if (n <= 0) {
            throw new SQLException("The match column index should be greater than 0");
        }
        try {
            this.matchColumnIndexes.clear();
            this.matchColumnNames.clear();
            this.matchColumnIndexes.add(0, new Integer(n));
        }
        catch (Exception exception) {
            throw new SQLException("The match column index could not be set");
        }
    }

    public void setMatchColumn(int[] nArray) throws SQLException {
        this.matchColumnIndexes.clear();
        this.matchColumnNames.clear();
        if (nArray == null) {
            throw new SQLException("The match column parameter is null");
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= 0) {
                throw new SQLException("The match column index should be greater than 0");
            }
            try {
                this.matchColumnIndexes.add(i, new Integer(nArray[i]));
                continue;
            }
            catch (Exception exception) {
                throw new SQLException("The match column index could not be set");
            }
        }
    }

    public void setMatchColumn(String string) throws SQLException {
        if (string == null || string.equals("")) {
            throw new SQLException("The match column name should be non-empty");
        }
        try {
            this.matchColumnIndexes.clear();
            this.matchColumnNames.clear();
            this.matchColumnNames.add(0, string.trim());
        }
        catch (Exception exception) {
            throw new SQLException("The match column name could not be set");
        }
    }

    public void setMatchColumn(String[] stringArray) throws SQLException {
        this.matchColumnIndexes.clear();
        this.matchColumnNames.clear();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || stringArray[i].equals("")) {
                throw new SQLException("The match column name should be non-empty");
            }
            try {
                this.matchColumnNames.add(i, stringArray[i].trim());
                continue;
            }
            catch (Exception exception) {
                throw new SQLException("The match column name could not be set");
            }
        }
    }

    public void unsetMatchColumn(int n) throws SQLException {
        this.checkIfMatchColumnIndexesSet();
        if (n <= 0) {
            throw new SQLException("The match column index should be greater than 0");
        }
        int n2 = -1;
        try {
            n2 = (Integer)this.matchColumnIndexes.get(0);
        }
        catch (Exception exception) {
            throw new SQLException("No match column indexes were set");
        }
        if (n2 != n) {
            throw new SQLException("The column index being unset has not been set");
        }
        this.matchColumnIndexes.clear();
        this.matchColumnNames.clear();
    }

    public void unsetMatchColumn(int[] nArray) throws SQLException {
        this.checkIfMatchColumnIndexesSet();
        if (nArray == null) {
            throw new SQLException("The match column parameter is null");
        }
        int n = -1;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= 0) {
                throw new SQLException("The match column index should be greater than 0");
            }
            try {
                n = (Integer)this.matchColumnIndexes.get(i);
            }
            catch (Exception exception) {
                throw new SQLException("No match column indexes were set");
            }
            if (n == nArray[i]) continue;
            throw new SQLException("The column index being unset has not been set");
        }
        this.matchColumnIndexes.clear();
        this.matchColumnNames.clear();
    }

    public void unsetMatchColumn(String string) throws SQLException {
        this.checkIfMatchColumnNamesSet();
        if (string == null || string.equals("")) {
            throw new SQLException("The match column name should be non-empty");
        }
        String string2 = null;
        try {
            string2 = (String)this.matchColumnNames.get(0);
        }
        catch (Exception exception) {
            throw new SQLException("No match column names were set");
        }
        if (!string2.equals(string.trim())) {
            throw new SQLException("The column name being unset has not been set");
        }
        this.matchColumnIndexes.clear();
        this.matchColumnNames.clear();
    }

    public void unsetMatchColumn(String[] stringArray) throws SQLException {
        this.checkIfMatchColumnNamesSet();
        if (stringArray == null) {
            throw new SQLException("The match column parameter is null");
        }
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || stringArray[i].equals("")) {
                throw new SQLException("The match column name should be non-empty");
            }
            try {
                string = (String)this.matchColumnNames.get(i);
            }
            catch (Exception exception) {
                throw new SQLException("No match column names were set");
            }
            if (string.equals(stringArray[i])) continue;
            throw new SQLException("The column name being unset has not been set");
        }
        this.matchColumnIndexes.clear();
        this.matchColumnNames.clear();
    }

    protected void checkIfMatchColumnIndexesSet() throws SQLException {
        if (this.matchColumnIndexes.size() == 0) {
            throw new SQLException("No match column indexes were set");
        }
    }

    protected void checkIfMatchColumnNamesSet() throws SQLException {
        if (this.matchColumnNames.size() == 0) {
            throw new SQLException("No match column names were set");
        }
    }

    public abstract int findColumn(String var1) throws SQLException;

    public abstract ResultSetMetaData getMetaData() throws SQLException;

    abstract String getTableName() throws SQLException;
}

