const objmoment = require('moment');
const globalData = require('../../global/globalData');
const clsActivityLog = require('../clsActivityLog.model');
const clsdailycalibration = require('../InstrumentParsings/ph.model');
const clslogin = require('../Login/login.model');
const clsconfigsetting = require('../clsConfigSetting');
const { models } = require('../../../config/dbConnection');
const sequelize = require('../../../config/dbConnection').sequelize;
const object = require('joi/lib/types/object');
const objActivityLog = new clsActivityLog();
const calibration = new clsdailycalibration();
const objlogin = new clslogin();
const objConfigSettings = new clsconfigsetting();
const GLOBAL_NOMENCLATURE = require('../../global/GLOBAL_NOMENCLATURE');

class Calibration {
    async getcalibration(value) {
        try {
            let objActivity = {};
            let resObj = {};
            var strUserId = value.userId;
            var strPassword = value.userPass;
            var strHmi = value.Hmi;
            var arrBal = await this.getCubicalData(strHmi); //Fetching ids setting data 
            arrBal = [arrBal]
            let cubDetails = await models.tbl_ids_setting.findAll({
                where: {
                    'Sys_IDSNo': strHmi
                }
            })
            let strResbPiNo = cubDetails[0].Sys_HMIID;
            let arrBalList = await this.pushBalList(strResbPiNo, strHmi, arrBal[0][0]);
            let arr = globalData.arrOfBalListWithPortNumber.find(k => k.Hmi == strHmi).BalList;
            console.log(arrBalList);
            globalData.arrIdsInfo.splice(globalData.arrIdsInfo.findIndex((element) => element.Hmi == strHmi), 1);
            let CurrentCubicInfo = globalData.arrIdsInfo.find(k => k.Hmi == strHmi); //empty
            if (CurrentCubicInfo == undefined) {
                globalData.arrIdsInfo.push({
                    Hmi: arrBal[0][0].Sys_HMIID,
                    idsNo: strHmi,
                    cubicalData: arrBal[0][0]
                })
            } else {
                CurrentCubicInfo.cubicalData = arrBal[0][0];
            }

            CurrentCubicInfo = globalData.arrIdsInfo.find(K => K.idsNo == strHmi).cubicalData;

            await this.CalibrationInProcess(CurrentCubicInfo.Sys_IDSNo); // flag Update
            let tempUserObj = globalData.arrUsers.find(k => k.Hmi == strHmi);
            let tempRightsObj = globalData.arrUserRights.find(k => k.Hmi == strHmi);
            var strReturnProtocol = await this.checkDailyCalibrationPending(strHmi);

            if (!strReturnProtocol.includes('Calibration')) {
                var update_calibflag = await models.tbl_ids_setting.update({
                    Sys_CalibInProcess: 0,
                },
                    {
                        where: { Sys_IDSNo: strHmi }

                    })
            } else if (strReturnProtocol.includes('Calibration') && strReturnProtocol.includes('Test')) {
                var update_calibflag = await models.tbl_ids_setting.update({
                    Sys_CalibInProcess: 1,
                    Sys_WeighmentInProcess: 1
                },
                    {
                        where: { Sys_IDSNo: strHmi }

                    })
            } else {
                var update_calibflag = await models.tbl_ids_setting.update({
                    Sys_WeighmentInProcess: 0,
                },
                    {
                        where: { Sys_IDSNo: strHmi }

                    })

            }

            // if (!tempRightsObj.rights.includes('Calibration')) {
            //     Object.assign(
            //         objActivity,
            //         { strUserId: tempUserObj.UserId },
            //         { strUserName: tempUserObj.UserName },
            //         { activity: `User does'nt have Calibration Right` }
            //     );
            //     await objActivityLog.ActivityLogEntry(objActivity)

            //     return { status: 'Fail', result: "You dont have Calibration Rights", Hmi: strHmi }
            // }
            return { status: 'success', Hmi: strHmi, rasbpi: arrBal[0][0].Sys_HMIID, protocol_list: strReturnProtocol.split(',') }
        } catch (error) {
            throw new Error(error)

        }
    }
    async getCubicalData(Hmi) {
        try {
            let cubicalData = await models.tbl_ids_setting.findAll({
                where: {
                    'Sys_IDSNo': Hmi
                }
            });
            return [cubicalData[0]];
        } catch (error) {
            throw new Error(error)

        }
    }
    async CalibrationInProcess(Hmi) {
        try {
            let cubicalData = await models.tbl_ids_setting.update({
                Sys_CalibInProcess: 1
            }, {
                where: {
                    Sys_IDSNo: Hmi
                }
            });
            return [cubicalData[0]];

        } catch (error) {
            throw new Error(error)

        }
    }
    async checkDailyCalibrationPending(IDSSrNo) {
        try {
            var objarrpHMeter = globalData.arrpHMeter.find(k => k.IdsNo == parseInt(IDSSrNo));
            if (objarrpHMeter == undefined) {
                globalData.arrpHMeter.push({ IdsNo: IDSSrNo, arrPHvalues: [], arrChannelFromString: [] })
            }
            else {
                objarrpHMeter.arrPHvalues = [];
                objarrpHMeter.arrChannelFromString = [];
            }

            var objArrISEMeter = globalData.arrISEMeter.find(k => k.IdsNo == parseInt(IDSSrNo));
            if (objArrISEMeter == undefined) {
                globalData.arrISEMeter.push({
                    IdsNo: IDSSrNo,
                    arrISEvalues: [],
                    arrChannelFromString: [],
                    pHwtinISEflg: false,
                    wtreport: false
                })
            }
            else {
                objArrISEMeter.arrISEvalues = [];
                objArrISEMeter.arrChannelFromString = [];
                objArrISEMeter.pHwtinISEflg = false,
                    objArrISEMeter.wtreport = false
            }

            // conductivity weighment array 
            var condtData = globalData.arrConductivityWdata.find(k => k.idsNo == parseInt(IDSSrNo));
            if (condtData == undefined) {
                globalData.arrConductivityWdata.push({ idsNo: IDSSrNo, Conductivity: 0, Conductance: 0, Temp: 0, TempCoeff: 0, TempRef: 0, k: 0 });
            } else {
                condtData.Conductivity = 0;
                condtData.Conductance = 0;
                condtData.Temp = 0;
                condtData.TempCoeff = 0;
                condtData.TempRef = 0;
                condtData.k = 0;
            }

            // temperature weighment array 
            // var tempData = globalData.arrTempWdata.find(k => k.idsNo == parseInt(IDSSrNo));
            // if (tempData == undefined) {
            //     globalData.arrTempWdata.push({ idsNo: IDSSrNo, RefTemp: 0, ActualTemp: 0});
            // } else {
            //     tempData.RefTemp = 0;
            //     tempData.ActualTemp = 0;
            // }
            var objarrSelectedChanelIDS = globalData.arrSelectedChanelIDS.find(k => k.IdsNo == parseInt(IDSSrNo));
            if (objarrSelectedChanelIDS == undefined) {
                globalData.arrSelectedChanelIDS.push({ IdsNo: IDSSrNo, selectedChannelIDS: [], currentChannel: '' })
            }
            else {
                objarrSelectedChanelIDS.selectedChannelIDS = [];
                objarrSelectedChanelIDS.currentChannel = ''
            }

            var objSwappStringToIDS = globalData.SwappStringToIDS.find(k => k.IdsNo == parseInt(IDSSrNo));
            if (objSwappStringToIDS == undefined) {
                globalData.SwappStringToIDS.push({ IdsNo: IDSSrNo, ChnnelFromIDS: '', ChaneltoBeSwap: '' })
            }
            else {
                objSwappStringToIDS.ChnnelFromIDS = '',
                    objSwappStringToIDS.ChaneltoBeSwap = ''
            }


            //to store Data of selected channel
            var objarrChaneelData = globalData.arrChaneelData.find(k => k.IdsNo == parseInt(IDSSrNo));
            if (objarrChaneelData == undefined) {
                globalData.arrChaneelData.push({ IdsNo: IDSSrNo, selectedChannelData: [] })
            }
            else {
                objarrChaneelData.selectedChannelData = [];
            }


            // fetching Current cubicle information
            var objarrPHCalibData = globalData.arrPHCalibData.find(k => k.IdsNo == parseInt(IDSSrNo));
            if (objarrPHCalibData == undefined) {
                globalData.arrPHCalibData.push(
                    {
                        IdsNo: IDSSrNo,
                        arrPHvalues: [],
                        arrSlope: [],
                        arrEo: [],
                        strAvgslope: [],
                        PHflag: '',
                        avgSlopeflg: '',
                    })
            }
            else {
                objarrPHCalibData.arrPHvalues = [];
                objarrPHCalibData.arrSlope = [];
                objarrPHCalibData.arrEo = [];
                objarrPHCalibData.strAvgslope = [];
                objarrPHCalibData.PHflag = '';
                objarrPHCalibData.avgSlopeflg = '';
            }
            // Conductivity Calibration Data
            var objarrCondCalibData = globalData.arrConductivityCalibData.find(k => k.IdsNo == parseInt(IDSSrNo));
            if (objarrCondCalibData == undefined) {
                globalData.arrConductivityCalibData.push({ IdsNo: IDSSrNo, arrConductivity: [], arrConductance: [], arrTemp: [], arrCalibType: [], arrK: [], arrAvgK: [], arrOffset: [], dataFlag: false });
            }
            else {
                objarrCondCalibData.arrConductivity = [];
                objarrCondCalibData.arrConductance = [];
                objarrCondCalibData.arrTemp = [];
                objarrCondCalibData.arrK = [];
                objarrCondCalibData.arrAvgK = [];
                objarrCondCalibData.arrOffset = [];
                objarrCondCalibData.arrCalibType = [];
                objarrCondCalibData.dataFlag = false;
            }

            // Temperature Calibration Data 
            var objarrTempCalibData = globalData.arrTempCalibData.find(k => k.IdsNo == parseInt(IDSSrNo));
            if (objarrTempCalibData == undefined) {
                globalData.arrTempCalibData.push({ IdsNo: IDSSrNo, RefTemp: 0, ActualTemp: 0, Offset: 0, dataFlag: false });
            }
            else {
                objarrTempCalibData.RefTemp = 0;
                objarrTempCalibData.ActualTemp = 0;
                objarrTempCalibData.Offset = 0;
                objarrTempCalibData.dataFlag = false;
            }

            // Do Calibration Array
            var objarrDOCalibData = globalData.arrDoCalibData.find(k => k.IdsNo == parseInt(IDSSrNo));
            if (objarrDOCalibData == undefined) {
                globalData.arrDoCalibData.push({
                    idsNo: IDSSrNo, saturation: 0, current: 0, zeroCurrent: 0,
                    tempSolution: 0, tempMembrane: 0, calibType: 0, BioPressure: 0, slope: 0, dataRead: false
                })
            } else {
                objarrDOCalibData.saturation = 0;
                objarrDOCalibData.slope = 0;
                objarrDOCalibData.dataRead = false;
                objarrDOCalibData.current = 0;
                objarrDOCalibData.zeroCurrent = 0;
                objarrDOCalibData.tempSolution = 0;
                objarrDOCalibData.tempMembrane = 0;
                objarrDOCalibData.calibType = 0;
                objarrDOCalibData.BioPressure = 0;
            }

            var arrISECalibData = globalData.arrISECalibData.find(k => k.IdsNo == parseInt(IDSSrNo));
            if (arrISECalibData == undefined) {
                globalData.arrISECalibData.push(
                    {
                        IdsNo: IDSSrNo,
                        Concentration: [],
                        mV: [],
                        Temperature: [],
                        Slope: [],
                        Eo: [],
                        avgSlope: "",
                        BlankValue: "",
                        ISEflag: false,
                        avgSlopeflg: false,
                        strInsrtumentTypeFromString: "",
                        strChannelFromString: "",
                        calibrepflg: false,
                        pHinISEflg: false

                    })
            }
            else {
                arrISECalibData.Concentration = [];
                arrISECalibData.mV = [];
                arrISECalibData.Temperature = [];
                arrISECalibData.Slope = [];
                arrISECalibData.Eo = [];
                arrISECalibData.avgSlope = '';
                arrISECalibData.ISEflag = '';
                arrISECalibData.avgSlopeflg = '';
                arrISECalibData.BlankValue = "";
                arrISECalibData.strInsrtumentTypeFromString = "";
                arrISECalibData.strChannelFromString = "";
                arrISECalibData.pHinISEflg = false;
                arrISECalibData.calibrepflg = false;

            }

            var objDOWData = globalData.arrDOWData.find(k => k.IdsNo == parseInt(IDSSrNo));
            if (objDOWData == undefined) {
                globalData.arrDOWData.push({
                    idsNo: IDSSrNo, Slope: 0, Saturation: 0,
                    Concentration: 0, Current: 0, TempSolution: 0, TempMembrane: 0,
                    BioPressure: 0, SalinityCorrection: 0, PartialPressure: 0
                })
            } else {
                objDOWData.Slope = 0;
                objDOWData.Saturation = 0;
                objDOWData.Concentration = 0;
                objDOWData.Current = 0;
                objDOWData.TempSolution = 0;
                objDOWData.TempMembrane = 0;
                objDOWData.BioPressure = 0;
                objDOWData.SalinityCorrection = 0;
                objDOWData.PartialPressure = 0;
            }
            const tempCubicInfo = globalData.arrIdsInfo.find(k => k.idsNo == parseInt(IDSSrNo));
            var strBalId = tempCubicInfo.balanceID; //balnce ID undefined
            var result = await this.checkCalibrtion(IDSSrNo)
            return result

        } catch (error) {
            return error;
        }

    }

    async checkCalibrtion(IDSSrNo) {
        try {
            const tempCubicInfo = globalData.arrIdsInfo.find(k => k.idsNo == parseInt(IDSSrNo));
            var SYS_MeterId = tempCubicInfo.cubicalData.Sys_Meter;

            //to reset ids staus for calibration*********************/
            //to reset IDs status for Weighment*********************/
            var update_calibflag = await models.tbl_ids_setting.update({
                Sys_CalibInProcess: 0,
                Sys_WeighmentInProcess: 0
            },
                {
                    where: { Sys_IDSNo: IDSSrNo }

                })
            //****************************************************/
            var pendingCalibChannelList = ''
            var strSql = ''
            for (var i = 1; i <= 4; i++) {
                var SelectedinstrID = tempCubicInfo.cubicalData[`Sys_Port${i}_ID`]
                var SelectedinstrType = tempCubicInfo.cubicalData[`Sys_Port${i}_Type`]
                var selectedChennelRealib = tempCubicInfo.cubicalData[`Sys_ISRecalib${i}`]
                if (SelectedinstrType != 'None' && SelectedinstrType != null && SelectedinstrType != 'NULL') {
                    var result = await this.CheckCalibrationStatus(SelectedinstrType, SelectedinstrID, IDSSrNo, selectedChennelRealib, SYS_MeterId)
                    var rightObj = globalData.arrUserRights.find(k => k.Hmi == IDSSrNo);

                    if (result != 'NA') {
                        if (!rightObj.rights.includes('Calibration')) {
                            console.log("Calibration Right Not Assigned")
                            var msg = "Calibration Right Not Assigned";
                        } else {
                            var msg = "Calibration Right Assigned";
                        }
                        if(SelectedinstrType === "UPW Conductivity"){
                            SelectedinstrType = "UPWConductivity"
                        }
                        pendingCalibChannelList = pendingCalibChannelList + `,Calib Channel-${i} ${SelectedinstrType}:${SelectedinstrID}:${msg}`
                    }
                    else {
                        if (!rightObj.rights.includes('Test')) {
                            console.log("Test Right Not Assigned")
                            var msg = "Test Right Not Assigned";
                        } else {
                            var msg = "Test Right Assigned";
                        }
                        if(SelectedinstrType === "Temperature"){

                        }
                        else{
                            if(SelectedinstrType === "UPW Conductivity"){
                                SelectedinstrType = "UPWConductivity"
                            }
                            pendingCalibChannelList = pendingCalibChannelList + `,Test Channel-${i} ${SelectedinstrType}:${msg}`
                        }
                    }
                }

            }
            await models.tbl_ids_setting.update({
                Sys_CalibInProcess: 1,
                Sys_WeighmentInProcess: 1
            }, { where: { Sys_IDSNo: IDSSrNo } })
            pendingCalibChannelList = pendingCalibChannelList.substring(1, pendingCalibChannelList.length);
            let productObj = globalData.arrMaterialProductSelected.find(k => k.idsNo == IDSSrNo);
            if (productObj != undefined) {
                await this.setProductInProcess(productObj.ProductSelected, 0);
            }
            console.log(pendingCalibChannelList.split(','));
            return `${pendingCalibChannelList.split(',')}` //send channel list with "calibartion  or test"
        } catch (err) {
            var logQ = objmoment().format(new Date(), 'DD-MM-YYYY HH:mm:ss') + " ," + err;
            clsErrorLog.addToErrorLog(logQ);
        }
    }

    async CheckCalibrationStatus(SelectedinstrType, SelectedinstrID, idsNo, selectedChennelRealib, SYS_MeterID) {
        try {
            var str_tempTableName = ''
            let tempRightsObj = globalData.arrUserRights.find(k => k.Hmi == parseInt(idsNo));
            // let hmiDetails = globalData.arrSelectedBalWithHmi.find(k => k.Hmi == strHmi);
            //if (SelectedinstrType = 'pH' || SelectedinstrType == 'pH/ISE') {
            str_tempTableName = ''
            switch (SelectedinstrType) {
                case GLOBAL_NOMENCLATURE.ph:
                    str_tempTableName = 'tbl_calibration_master_ph'
                    break;
                case GLOBAL_NOMENCLATURE.Conductivity:
                    str_tempTableName = 'tbl_calibration_master_conductivity'
                    break;
                case GLOBAL_NOMENCLATURE.Temperature:
                    str_tempTableName = 'tbl_calibration_master_temperature'
                    break;
                case GLOBAL_NOMENCLATURE.UPW:
                    str_tempTableName = 'tbl_calibration_master_conductivity'
                    break;
                case GLOBAL_NOMENCLATURE.ISE:
                    //added by vatsal if ISE data is present in ph table, ph table will be considered to check for daily calib data for ISE.
                    //  let ISEcalibInpH  = `SELECT * FROM tbl_calibration_master_ph WHERE ProbID='${SelectedinstrID}' AND PrDate='${date.format(now, 'YYYY-MM-DD')}' AND Remark = 'Pass'`
                    //  ISEcalibInpH = await database.execute(ISEcalibInpH)
                    var ISEcalibInpH = await models.tbl_calibration_master_ph.findAll({
                        where: {
                            ProbID: SelectedinstrID,
                            PrDate: objmoment().format('YYYY-MM-DD'),
                            Remark: 'Pass'
                        }

                    })
                    if (ISEcalibInpH[0] == undefined) {
                        str_tempTableName = 'tbl_calibration_master_ph_ise'
                    } else {
                        str_tempTableName = 'tbl_calibration_master_ph'
                    }
                    // if (ISEcalibInpH[0].length > 0) {
                    //     str_tempTableName = 'tbl_calibration_master_ph'
                    // }
                    // else {
                    //     str_tempTableName = 'tbl_calibration_master_ph_ise'
                    // }
                    break;
                case GLOBAL_NOMENCLATURE.DO:
                    str_tempTableName = 'tbl_calibration_master_do'
                    break;
                case GLOBAL_NOMENCLATURE.RDO:
                    str_tempTableName = 'tbl_calibration_master_rdo'

                default:
                    break;
            }
            //}


            //fetch detail of the attched instrument to the meter
            var strchkDailySelected = await models.tbl_meter_weights.findAll({  //meterwt instrument entry check
                where: {
                    meterwt_ProbID: SelectedinstrID,
                    meterwt_ID: SYS_MeterID
                }
            })

            var query = await models[str_tempTableName].findAll({
                where: {
                    ProbID: SelectedinstrID,
                    PrDate: objmoment().format('YYYY-MM-DD'),
                    Remark: 'Pass'
                }
            })
            //  `SELECT * FROM ${str_tempTableName} WHERE ProbID='${SelectedinstrID}' AND PrDate='${date.format(now, 'YYYY-MM-DD')}' AND Remark = 'Pass'`; //removed check max rep no coondition
            var selRes = query
            // if (SelectedinstrType == "DO/RDO") {
            //     let query1 = await models[str_tempTableName1].findAll({
            //         where: {
            //             ProbID: SelectedinstrID,
            //             PrDate: objmoment().format('YYYY-MM-DD'),
            //             Remark: 'Pass'
            //         }
            //     })

            //     // `SELECT * FROM ${str_tempTableName1} WHERE ProbID='${SelectedinstrID}' AND PrDate='${date.format(now, 'YYYY-MM-DD')}' AND Remark = 'Pass'`;
            //     var selRes1 = query1
            //     if (selRes != 0) {
            //         selRes = selRes
            //     } else if (selRes1 != 0) {
            //         selRes = selRes1
            //     }
            // }


            // var selectObj = await models[str_tempTableName].findAll({
            //     where: {
            //         ProbID: SelectedinstrID,
            //         PrDate: objmoment().format('YYYY-MM-DD'),
            //         Remark: 'Pass'
            //     }
            // })
            // var found = globalData.calibrationStatus.some(function (el) {
            //     return el.BalId === strBalId;
            // }); 
            // var Max_Rec = await models[str_tempTableName].findAll({
            //     attributes: [[sequelize.fn('max', sequelize.col('RecNo')), 'RecNo']],
            //     where: {
            //         ProbID: SelectedinstrID
            //     }
            // })
            // let query = `SELECT * FROM ${str_tempTableName} WHERE ProbID='${SelectedinstrID}' AND PrDate='${date.format(now, 'YYYY-MM-DD')}' AND Remark = 'Pass' AND RecNo=(SELECT MAX(RecNo)FROM ${str_tempTableName})`;
            // var selRes = await models[str_tempTableName].findAll({
            //     where: {
            //         ProbID: SelectedinstrID,
            //         PrDate: objmoment().format('YYYY-MM-DD'),
            //         Remark: 'Pass',
            //         RecNo: Max_Rec[0].RecNo//(SELECT MAX(RecNo)FROM ${str_tempTableName})
            //     }
            // })
            // let strrasbpi = await models.tbl_ids_setting.findAll({
            //     where: {
            //         Sys_IDSNo: idsNo
            //     }
            // })
            // let strHmi = strrasbpi[0].Sys_HMIID
            globalData.arrCurrentOperationStatus.splice(globalData.arrCurrentOperationStatus.findIndex((element) => element.Hmi == idsNo), 1);
            if (selRes[0] != undefined || strchkDailySelected[0].meterwt_Daily == 0) {

                if (selectedChennelRealib == 1) {
                    let TempCalibType = globalData.arrcalibType.find(k => k.idsNo == idsNo);
                    if (TempCalibType != undefined) {
                        TempCalibType.calibType = 'daily';
                    } else {
                        globalData.arrcalibType.push({ idsNo: idsNo, calibType: 'daily' })
                    }
                    return "CALIB PENDING";
                }
                else {
                    return 'NA';
                }

            }
            else {
                // setting global variable to 'daily' in order to identify CP, CB coming for which CalibType
                let TempCalibType = globalData.arrcalibType.find(k => k.idsNo == idsNo);
                if (TempCalibType != undefined) {
                    TempCalibType.calibType = 'daily';
                } else {
                    globalData.arrcalibType.push({ idsNo: idsNo, calibType: 'daily' })
                }
                // let hmiDetails = globalData.arrSelectedBalWithHmi.find(k => k.Hmi == idsNo);
                // if (hmiDetails == undefined) {
                //     globalData.arrSelectedBalWithHmi.push({
                //         "Hmi": idsNo,
                //         "rasbpi": strHmi,
                //         "selectedBal": SelectedinstrID,
                //         // "port": strPortNo,
                //         "InstrumentType": SelectedinstrType,
                //     })
                // } else {
                //     // hmiDetails.rasbpi = strHmi;
                //     // hmiDetails.selectedBal = SelectedinstrID;
                //     // // hmiDetails.port = strPortNo;
                //     // hmiDetails.InstrumentType = SelectedinstrType;
                //     var index = globalData.arrSelectedBalWithHmi.findIndex(k =>k.Hmi==idsNo);
                //     globalData.arrSelectedBalWithHmi[index].rasbpi = strHmi;
                //     globalData.arrSelectedBalWithHmi[index].selectedBal = SelectedinstrID;
                //     globalData.arrSelectedBalWithHmi[index].InstrumentType = SelectedinstrType;
                // }

                // console.log(globalData.arrSelectedBalWithHmi)

                return "CALIB PENDING";

            }


        } catch (err) {
            console.log(err);
            throw new Error(err)
        }
    }

    // Api After Select Daily Or periodic 
    async selectPendingCalib(value) {
        try {
            let strCalibType = value.CalibType;
            let strHmi = value.Hmi;
            let strBalId = value.BalId;
            let powerflag = value.Power_calib
            var rightObj = globalData.arrUserRights.find(k => k.Hmi == strHmi);
            // if (!rightObj.rights.includes('Calibration')) {
            //     return { status: 'Fail', message: "Calibration Right Not Assigned" }
            // }

            let objTempCalibData = globalData.arrTolForTempCalibData.find(k => k.idsNo == strHmi);
            if (objTempCalibData == undefined) {
                globalData.arrTolForTempCalibData.push({ idsNo: strHmi, negTol: value.Conduct_NegTol, posTol: value.Conduct_PosTol })
            } else {
                objTempCalibData.negTol = value.Conduct_NegTol
                objTempCalibData.posTol = value.Conduct_PosTol;
                objTempCalibData.idsNo = strHmi;
            }
            objTempCalibData = globalData.arrTolForTempCalibData.find(k => k.idsNo == strHmi);

            // arrTolForISECalibData
            let objISECalibData = globalData.arrTolForISECalibData.find(k => k.idsNo == strHmi);
            if (objISECalibData == undefined) {
                globalData.arrTolForISECalibData.push({ idsNo: strHmi, negTol: value.Conduct_NegTol, posTol: value.Conduct_PosTol })
            } else {
                objISECalibData.negTol = value.Conduct_NegTol
                objISECalibData.posTol = value.Conduct_PosTol;
                objISECalibData.idsNo = strHmi;
            }
            objISECalibData = globalData.arrTolForISECalibData.find(k => k.idsNo == strHmi);

            var UserNames = globalData.arrUsers.find(k => k.Hmi == strHmi);
            if (objTempCalibData != undefined) {
                let objAudit = await models.tbl_audit_idsvalues_log.create({
                    dt: objmoment().format('YYYY-MM-DD'),
                    tm: objmoment().format('HH:mm:ss'),
                    userid: value.userId,
                    username: UserNames.UserName,
                    // EnteredValues: `Conductivity Calibration Tolerances: Pos:${value.Conduct_PosTol} Neg:${value.Conduct_NegTol}`,
                    Type: 1
                })
            }
            if (objISECalibData != undefined) {
                let objAudit = await models.tbl_audit_idsvalues_log.create({
                    dt: objmoment().format('YYYY-MM-DD'),
                    tm: objmoment().format('HH:mm:ss'),
                    userid: value.userId,
                    username: UserNames.UserName,
                    // EnteredValues: `Conductivity Calibration Tolerances: Pos:${value.Conduct_PosTol} Neg:${value.Conduct_NegTol}`,
                    Type: 1
                })
            }

            let objConductivityTolCalib = globalData.arrTolForConductivityCalib.find(k => k.idsNo == strHmi);
            if (objConductivityTolCalib == undefined) {
                globalData.arrTolForConductivityCalib.push({ idsNo: strHmi})
                // globalData.arrTolForConductivityCalib.push({ idsNo: strHmi, negTol: value.Conduct_NegTol, posTol: value.Conduct_PosTol })
            } else {
                // objConductivityTolCalib.negTol = value.Conduct_NegTol
                // objConductivityTolCalib.posTol = value.Conduct_PosTol;
                objConductivityTolCalib.idsNo = strHmi;
            }
            objConductivityTolCalib = globalData.arrTolForConductivityCalib.find(k => k.idsNo == strHmi);
            var UserNames = globalData.arrUsers.find(k => k.Hmi == strHmi);
            if (objConductivityTolCalib != undefined) {
                let objAudit = await models.tbl_audit_idsvalues_log.create({
                    dt: objmoment().format('YYYY-MM-DD'),
                    tm: objmoment().format('HH:mm:ss'),
                    userid: value.userId,
                    username: UserNames.UserName,
                    // EnteredValues: `Conductivity Calibration Tolerances: Pos:${value.Conduct_PosTol} Neg:${value.Conduct_NegTol}`,
                    Type: 1
                })
            }
            let CalibApiHit = globalData.arrCalibApiHit.find(k => k.Hmi == strHmi);
            if (CalibApiHit == undefined) {
                globalData.arrCalibApiHit.push({
                    Hmi: strHmi,
                    BalId: strBalId,
                    Time: objmoment().format('YY-MM-DD HH:mm:ss'),
                })
            } else {
                CalibApiHit.BalId = strBalId;
                CalibApiHit.Time = objmoment();
            }

            var resHmi = await models.tbl_ids_setting.findAll({
                where: {
                    Sys_IDSNo: strHmi
                }
            })
            let rasbpiNO = resHmi[0].Sys_HMIID
            let rasbpi = globalData.arrOfBalListWithPortNumber.find(k => k.Hmi == strHmi);
            let strPortNo = globalData.arrOfBalListWithPortNumber.find(k => k.Hmi == strHmi).BalList //.find(i => i.BalanceId == strBalId).PortNo;

            // await tbl_idsport_details.update({
            //     'Sys_PortNo': strPortNo,
            //     'Instrument_type': 'Balance',
            //     'Instrument_id': strBalId
            // }, {
            //     where: {
            //         'Sys_IDSNo': strHmi
            //     }
            // })

            //decide which calib is peding and sedig the first wt
            //verify the wt
            //ask for next wt.
            var objBal = await calibration.calibPendingDecider(strCalibType, strHmi, strBalId, rasbpi)
            console.log(objBal);
            var objBalWt = [];
            // objBalWt.objBalance = objBal
            objBalWt.push({ objBal })
            const tempCubicInfo = globalData.arrIdsInfo.find(k => k.idsNo == strHmi);
            var strselectedInsrtumentType;
            for (let ele in tempCubicInfo.cubicalData) {

                if (tempCubicInfo.cubicalData[ele] == strBalId && ele.includes('ID')) {
                    strselectedInsrtumentType = ele
                    break
                }

            }
            var a = strselectedInsrtumentType.split('Port')
            var ab = (a[1].split('_'))
            var port = ab[0];
            var i = 0;

            let allBal = globalData.arrOfBalListWithPortNumber.find(k => k.Hmi == strHmi)
            var setting = [];
            for (i; i < allBal.BalList.length; i++) {
                let balance_list = allBal;
                let balance = balance_list.BalList[i].type + '_Id';
                let PortNo = balance_list.BalList[i].PortNo;
                let Instrument_type = balance_list.BalList[i].type
                let bal_setting = await objConfigSettings.getConfiSetting(strHmi, Instrument_type, PortNo);
                setting.push(bal_setting);
            }
            var configsetting;
            configsetting = setting[0];
            // configsetting.push(setting)
            //configSetting:configSetting
            let hmiEntryinConfig = globalData.arrConfigSettings.find(k => k.Hmi == strHmi);
            if (hmiEntryinConfig == undefined) {
                globalData.arrConfigSettings.push({
                    Hmi: strHmi,
                    configSetting: setting
                })
            } else {
                hmiEntryinConfig.configSetting = setting
            }
            objBalWt.Hmi = strHmi
            return Object.assign({ status: 'success', objBal, configsetting })
            // let resObj = {}
            // resObj = {
            //     status: 'success',
            //     Data:objBalWt
            // }
            // return resObj;
        } catch (error) {
            console.log(error);
        }


    }

    async pushBalList(strResbPiNo, Hmi, ObjBalList) {
        try {
            let objOfBallist = this.clean(ObjBalList);

            let arrDetailOfallBalance = [];
            let arrAllListOfBal = [];
            let i = 1;
            for (let obj in objOfBallist) {
                if (objOfBallist[`Sys_Port${i}_Type`] == undefined || objOfBallist[`Sys_Port${i}_Type`] == "None") {
                    i++;
                    continue;
                }
                else {
                    if (objOfBallist[`Sys_Port${i}_Type`] == "pH") {
                        arrDetailOfallBalance.push(
                            { "PHId": objOfBallist[`Sys_Port${i}_ID`], "PortNo": i, "type": objOfBallist[`Sys_Port${i}_Type`] }
                        )

                        arrAllListOfBal.push(objOfBallist[`Sys_Port${i}_ID`]);
                    } else if (objOfBallist[`Sys_Port${i}_Type`] == "Conductivity") {
                        arrDetailOfallBalance.push(
                            { "ConductivityId": objOfBallist[`Sys_Port${i}_ID`], "PortNo": i, "type": objOfBallist[`Sys_Port${i}_Type`] }
                        )

                        arrAllListOfBal.push(objOfBallist[`Sys_Port${i}_ID`]);
                    } else if (objOfBallist[`Sys_Port${i}_Type`] == "UPW Conductivity") {
                        arrDetailOfallBalance.push(
                            { "UPW ConductivityId": objOfBallist[`Sys_Port${i}_ID`], "PortNo": i, "type": objOfBallist[`Sys_Port${i}_Type`] }
                        )

                        arrAllListOfBal.push(objOfBallist[`Sys_Port${i}_ID`]);
                    } else if (objOfBallist[`Sys_Port${i}_Type`] == "pH/ISE") {
                        arrDetailOfallBalance.push(
                            { "pH/ISEId": objOfBallist[`Sys_Port${i}_ID`], "PortNo": i, "type": objOfBallist[`Sys_Port${i}_Type`] }
                        )

                        arrAllListOfBal.push(objOfBallist[`Sys_Port${i}_ID`]);
                    } else if (objOfBallist[`Sys_Port${i}_Type`] == "DO") {
                        arrDetailOfallBalance.push(
                            { "DOId": objOfBallist[`Sys_Port${i}_ID`], "PortNo": i, "type": objOfBallist[`Sys_Port${i}_Type`] }
                        )

                        arrAllListOfBal.push(objOfBallist[`Sys_Port${i}_ID`]);
                    } else if (objOfBallist[`Sys_Port${i}_Type`] == "RDO") {
                        arrDetailOfallBalance.push(
                            { "RDOId": objOfBallist[`Sys_Port${i}_ID`], "PortNo": i, "type": objOfBallist[`Sys_Port${i}_Type`] }
                        )

                        arrAllListOfBal.push(objOfBallist[`Sys_Port${i}_ID`]);
                    } else if (objOfBallist[`Sys_Port${i}_Type`] == "Temperature") {
                        arrDetailOfallBalance.push(
                            { "TemperatureId": objOfBallist[`Sys_Port${i}_ID`], "PortNo": i, "type": objOfBallist[`Sys_Port${i}_Type`] }
                        )

                        arrAllListOfBal.push(objOfBallist[`Sys_Port${i}_ID`]);
                    }
                    // if (objOfBallist[`Sys_Port${i}_ID`] == "IPC Balance") {
                    //     arrDetailOfallBalance.push(
                    //         { "BalanceId": objOfBallist[`Sys_BinBalID`], "PortNo": i, "type": "IPC Balance" }
                    //     )

                    //     arrAllListOfBal.push(objOfBallist[`Sys_BinBalID`]);
                    // }

                    i++;
                }
            }

            let arrOfBalList = globalData.arrOfBalListWithPortNumber.find(k => k.Hmi == Hmi)
            //pushing balanceId with their port number gollbally
            if (arrOfBalList == undefined) {

                globalData.arrOfBalListWithPortNumber.push({
                    "ResbPi": strResbPiNo,
                    "Hmi": Hmi,
                    "BalList": arrDetailOfallBalance
                })
            } else {
                arrOfBalList.ResbPi = strResbPiNo;
                arrOfBalList.BalList = arrDetailOfallBalance;
            }
            console.log(globalData.arrOfBalListWithPortNumber);

            return arrAllListOfBal;
        } catch (error) {
            console.log(error)
        }
    }

    clean(obj) {
        for (let key in obj) {
            if (obj[key] == null || obj[key] == undefined || obj[key] == "None") {
                delete obj[key];
            }
        }
        return obj;
    }

    async setProductInProcess(product, flag = 0) {
        var updateObject = await models.tbl_product.update({
            InProcess: flag
        }, {
            where: {
                productName: product
            }
        })

        return updateObject;

    }


}
module.exports = Calibration;