const globalData = require('../../global/globalData');
const clsActivityLog = require('../clsActivityLog.model');
const clsInstrumentUsage = require('../clsInstrumentUsageLog')
const dbCon = require('../../global/dbCon');
const MqttModel = require('../Mqtt/mqttSender.class');
const mqttSender = new MqttModel();
const mqttProtocol = require('../../global/GLOBAL_NOMENCLATURE');
const objActivityLog = new clsActivityLog();
const objclsInstrumentUsageLog = new clsInstrumentUsage();
const date = require('date-and-time');
const clspH = require('../InstrumentParsings/ph.model')
const objph = new clspH();
const momentObj = require('moment');
const { models } = require('../../../config/dbConnection');
const clsPrint = require('../Weighment/clsonlineprint');
const objPrint = new clsPrint();

class DoCalibration {
  async Do_Calibration_Parsing(str_Do_Channel) {
    try {
      var actualProtocol = str_Do_Channel.str_Protocol;
      let str_1 = str_Do_Channel.str_Protocol.split("\n");
      var mqtt_Port = str_Do_Channel.ProtocolPortNo;
      let obj = {}
      let flag = 0
      var strHmi = str_Do_Channel.strHmi
      var strInstrId = str_Do_Channel.instrumentId
      var tempCubicInfo = globalData.arrIdsInfo.find(k => k.idsNo == strHmi).cubicalData;
      var str_Protocol;
      var strselectedInsrtumentType;
      var typee = "";

      for (var ele in tempCubicInfo) {

        if (tempCubicInfo[ele] == strInstrId && ele.includes('ID')) {
          strselectedInsrtumentType = ele
          break
        }

      }

      var a = strselectedInsrtumentType.split('Port')
      var ab = (a[1].split('_'))
      var currentChannel = ab[0];
      var strBal = tempCubicInfo[`Sys_Meter`]
      var ProbType = tempCubicInfo[`Sys_Port${currentChannel}_Type`]
      for (var i = 0; i < str_1.length; i++) {
        await objclsInstrumentUsageLog.InstrumentUsage(strInstrId, ProbType, strHmi, 'DO Calibration', 1)
        await objph.ActivityLog(strHmi, "Calibration Started");
        // if (str_1[i].includes("Channel")) {
        //   obj["Channel"] = currentChannel;
        // }
        var strChannelFromString = []
        // for (var j = 0; j < str_1.length; j++) { //logic TSH
        if (i == 0) {
          for (let j = 0; j < str_1.length; j++) {
            if (str_1[j].includes(' RDO Calibration Report ')) {
              return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
            }
          }
        }
        if (str_1[i].includes("Channel")) {
          var slope_1 = str_1[i].replace('Channel', ' ').trim().split(' ');
          slope_1 = slope_1[0]
          obj[`Channel`] = slope_1;
          if (currentChannel != slope_1) {  // channel validation
            var strActivity = `Data Received from Channel ${slope_1} Instead of Channel ${currentChannel}`
            var strResult = await objph.ActivityLog(strHmi, strActivity)
            return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage} ${strActivity}`);
            // var strResult = await this.ActivityLog(IdsNo, strActivity)
          }
          // if (mqtt_Port != slope_1) {
          //   var strActivity = `Data Received from Port ${mqtt_Port} Instead of Port ${slope_1}`
          //   var strResult = await objph.ActivityLog(strHmi, strActivity)
          //   mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage} ${strActivity}`);
          //   return mqttSender.sendData(IdsNo, strActivity);
          // }
          // strChannelFromString.push({ "Channel": currentChannel });
        }
        // }

        //Time Validations
        if (actualProtocol.search('Time') == -1) {
          return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
        }
        // if (actualProtocol.search('Operator') == -1 || actualProtocol.search('Signature') == -1) {
        //   return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
        // }
        // if (actualProtocol.search('Operator') == -1 || actualProtocol.search('Signature') == -1) {
        //   return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
        // }
        if (str_1[i].includes('Time')) {
          var Time = str_1[i].replace(/[ ]{1,}/g, " ").split(" ").splice(1).join(" ");;
          Time = Time.split('Time')[1]
          obj[`Time`] = Time;
          var valid = await objph.PHDateValidator(Time);
          if (valid == false) {
            return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);

          }
        }

        if ((str_Do_Channel.str_Protocol.includes('Saturation') == true) || (str_Do_Channel.str_Protocol.includes('Concentration') == true)) {

          // if (str_Do_Channel.str_Protocol.Saturation == undefined){
          //   return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
          // }

          if (str_1[i].includes("DO Calibration Report")) {
            flag = 1
            if (flag == 1) {
              var Do = str_1[i].replace('-- DO Calibration Report --', ' ').trim();
            }
          }

          // *************Saturation*************//
          if (str_1[i].includes("Saturation")) {
            let b = str_1[i].replace('Saturation', ' ').trim().split();
            b = b[0]
            if (isNaN(parseInt(b)) == true) {
              return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
            }
            // if (b == '') {
            //   return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
            // }
            b = str_1[i].replace('Saturation', ' ').trim().split();
            obj["Saturation"] = b[0];
            typee = "Saturation"
          }

          
          // *************Concentration*************//
          else if(str_1[i].includes("Concentration")) {
            let b = str_1[i].replace('Concentration', ' ').trim().split();
            b = b[0]
            if (isNaN(parseInt(b)) == true) {
              return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
            }
            // if (b == '') {
            //   return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
            // }
            b = str_1[i].replace('Concentration', ' ').trim().split();
            obj["Concentration"] = b[0];
            typee = "Concentration"
          }


          // // *************Current*************//
          if (str_1[i].includes("Current")) {
            if (str_1[i].includes("Zero Current")) {
              let c = str_1[i].replace('Zero Current', ' ').trim().split(' ');
              c = c[0];
              // if (isNaN(parseInt(c)) == true) {
              //   return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
              // }
              obj["Zero_Current"] = c;
            } else {
              var current = str_1[i].replace('Current', ' ').trim().split();
              current = current[0];
              if (isNaN(parseInt(current)) == true) {
                return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
              }
              obj["Current"] = current;
            }
          }



          // // *************Temp. Solution*************//
          if (str_1[i].includes("Temp. Solution")) {
            // console.log(str_1[i].replace('Point', ' ').trim().split(' '));
            let d = str_1[i].replace('Temp. Solution', ' ').trim().split();
            d = d[0]
            if (isNaN(parseInt(d)) == true) {
              return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
            }
            obj["Temp_Solution"] = d;
          }

          // *************Temp. Membrane*************//
          if (str_1[i].includes("Temp. Membrane")) {
            let e = str_1[i].replace('Temp. Membrane', ' ').trim().split();
            e = e[0]
            if (isNaN(parseInt(e)) == true) {
              return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
            }
            obj["Temp_Membrane"] = e;
          }

          // *************Calibration Type*************//
          if (str_1[i].includes("Calibration Type")) {
            let CT = str_1[i].replace('Calibration Type', ' ').trim().split(' ');
            CT = CT[0]
            if (CT == 'Auto' || CT == 'Manual') {
              obj["Calibration_Type"] = CT;
            } else {
              return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
            }

          }

          // *************Barometric Pressure*************//
          if (str_1[i].includes("Barometric Pressure")) {
            let f = str_1[i].replace('Barometric Pressure', ' ').trim().split();
            f = f[0]
            if (isNaN(parseInt(f)) == true) {
              return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
            }
            obj["Barometric_Pressure"] = f;
          }

          // *************Slope*************//
          if (str_1[i].includes("Slope")) {
            // console.log(str_1[i].replace('Point', ' ').trim().split(' '));
            let g = str_1[i].replace('Slope', ' ').trim().split();
            g = g[0]
            if (isNaN(parseInt(g)) == true) {
              return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
            }
            obj["Slope"] = g;
          }

          //**********Cal #*********//
          if (str_1[i].includes('Cal #')) {
            let cal = str_1[i].replace('Cal #', ' ').trim().split(' ');
            cal = cal[0]
            if (isNaN(parseInt(cal)) == true) {
              return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
            }
            obj["Cal #"] = cal;
          }
        } else {
          // var Error = "Invalid String"
          // console.log(Error)
          return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
        }
        if (str_1[i].includes('User ID')) {
          str_1.splice(i, 1);
        }
        if (str_1[i].includes('Probe S/n')) {
          str_1.splice(i, 1);
        }
      }

      var newStringData = str_1.join('\n');
      newStringData = newStringData.slice(newStringData.lastIndexOf('Thermo Scientific (c) 2011'), newStringData.lastIndexOf('Operator'))

      var selectrange = await models.tbl_meter_weights.findAll({
        where: {
          meterwt_ID: strBal,
          meterwt_ProbID: strInstrId,
          meterwt_ProbType: ProbType,
          meterwt_ChannelNo: currentChannel
        }
      })
      var result;
      var NegTol = selectrange[0].meterwt_NegTol;
      var PosTol = selectrange[0].meterwt_PosTol;
      // await this.SaveDOcalibData(result = 'Pass', obj, strHmi, strInstrId, NegTol, PosTol);

      // } catch (error) {
      //   console.log(error);
      // }

      if (selectrange.length > 0) {

        var flgOutOfLimit = false;
        // var Obj;
        if (parseFloat(obj[typee]) >= selectrange[0].meterwt_NegTol && parseFloat(obj[typee]) <= selectrange[0].meterwt_PosTol) {

          console.log("Calibration Successful");
          var result = await this.SaveDOcalibData(result = 'Pass', obj, strHmi, strInstrId, NegTol, PosTol, newStringData, typee);
          var object = await objclsInstrumentUsageLog.InstrumentUsage(strInstrId, ProbType, strHmi, 'DO Calibration', 0);
          await objph.ActivityLog(strHmi, "Calibration Completed");
          mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Calibration Successful`);
          mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${JSON.stringify(obj)}`)
          return;
        } else {
          console.log("Calibration Failed");
          await this.SaveDOcalibData(result = 'Fail', obj, strHmi, strInstrId, NegTol, PosTol, newStringData, typee);
          var object = await objclsInstrumentUsageLog.InstrumentUsage(strInstrId, ProbType, strHmi, 'DO Calibration', 0);
          await objph.ActivityLog(strHmi, "Calibration Completed");
          mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage} Calibration Failed`);
          mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${JSON.stringify(obj)}`)
          return;
        }
      }
      else {
        obj.Saturation = 0;
        obj.Slope = 0;
        obj.dataRead = false;
        obj.Current = 0;
        obj.Zero_Current = 0;
        obj.Temp_Solution = 0;
        obj.Temp_Membrane = 0;
        obj.Calibration_Type = 0;
        obj.Barometric_Pressure = 0;
        obj.PartialPressure = 0;

        mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage} Calibration Failed`);

      }
    }
    catch (err) {
      console.log(err)
      throw new Error(err)
    }
  }
  async RDo_Calibration_Parsing(str_Do_Channel) {
    try {
      var actualProtocol = str_Do_Channel.str_Protocol;
      let str_1 = str_Do_Channel.str_Protocol.split("\n");
      var mqtt_Port = str_Do_Channel.ProtocolPortNo;
      let obj = {}
      let flag = 0
      var strHmi = str_Do_Channel.strHmi
      var strInstrId = str_Do_Channel.instrumentId
      var tempCubicInfo = globalData.arrIdsInfo.find(k => k.idsNo == strHmi).cubicalData;
      var str_Protocol;
      var strselectedInsrtumentType;
      var typee = " "

      for (var ele in tempCubicInfo) {

        if (tempCubicInfo[ele] == strInstrId && ele.includes('ID')) {
          strselectedInsrtumentType = ele
          break
        }

      }

      var a = strselectedInsrtumentType.split('Port')
      var ab = (a[1].split('_'))
      var currentChannel = ab[0];
      var strBal = tempCubicInfo[`Sys_Meter`]
      var ProbType = tempCubicInfo[`Sys_Port${currentChannel}_Type`]
      for (var i = 0; i < str_1.length; i++) {
        await objclsInstrumentUsageLog.InstrumentUsage(strInstrId, ProbType, strHmi, 'RDO Calibration', 1)
        await objph.ActivityLog(strHmi, "Calibration Started");
        // if (str_1[i].includes("Channel")) {
        //   obj["Channel"] = currentChannel;
        // }
        var strChannelFromString = []
        // for (var j = 0; j < str_1.length; j++) { //logic TSH
        if (str_1[i].includes("Channel")) {
          var slope_1 = str_1[i].replace('Channel', ' ').trim().split(' ');
          slope_1 = slope_1[0]
          obj[`Channel`] = slope_1;
          if (currentChannel != slope_1) {  // channel validation
            var strActivity = `Data Received from Channel ${slope_1} Instead of Channel ${currentChannel}`
            var strResult = await objph.ActivityLog(strHmi, strActivity)
            return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage} ${strActivity}`);
          }
          // if (mqtt_Port != slope_1) {
          //   var strActivity = `Data Received from Port ${mqtt_Port} Instead of Port ${slope_1}`
          //   var strResult = await objph.ActivityLog(strHmi, strActivity)
          //   mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage} ${strActivity}`);
          //   return mqttSender.sendData(IdsNo, strActivity);
          // }
          // strChannelFromString.push({ "Channel": currentChannel });
        }
        if (i == 0) {
          for (let j = 0; j < str_1.length; j++) {
            if (str_1[j].includes(' DO Calibration Report ')) {
              return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
            }
          }
        }
        // }

        //Time Validations
        if (actualProtocol.search('Time') == -1) {
          return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
        }
        // if (actualProtocol.search('Operator') == -1 || actualProtocol.search('Signature') == -1) {
        //   return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
        // }
        // if (actualProtocol.search('Operator') == -1 || actualProtocol.search('Signature') == -1) {
        //   return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
        // }
        if (str_1[i].includes('Time')) {
          var Time = str_1[i].replace(/[ ]{1,}/g, " ").split(" ").splice(1).join(" ");;
          Time = Time.split('Time')[1]
          obj[`Time`] = Time;
          var valid = await objph.PHDateValidator(Time);
          if (valid == false) {
            return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);

          }
        }

        if ((str_Do_Channel.str_Protocol.includes('Saturation') == true) || (str_Do_Channel.str_Protocol.includes('Concentration') == true)) {

          // if (str_Do_Channel.str_Protocol.Saturation == undefined){
          //   return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
          // }
          if (str_1[i].includes("RDO Calibration Report")) {
            flag = 1
            if (flag == 1) {
              var Do = str_1[i].replace('-- RDO Calibration Report --', ' ').trim();
            }
          }
          if (str_Do_Channel.str_Protocol.includes('Saturation') == true) {
            // *************Saturation*************//
            typee = "Saturation"
            if (str_1[i].includes("Saturation")) {
              let b = str_1[i].replace('Saturation', ' ').trim().split();
              b = b[0]
              if (isNaN(parseInt(b)) == true) {
                return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
              }
              // if (b == '') {
              //   return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
              // }
              b = str_1[i].replace('Saturation', ' ').trim().split();
              obj["Saturation"] = b[0];
            }
          }
          else if (str_Do_Channel.str_Protocol.includes('Concentration') == true) {
            // *************Concentration*************//
            typee = "Concentration"
            if (str_1[i].includes("Concentration")) {
              let b = str_1[i].replace('Concentration', ' ').trim().split();
              b = b[0]
              if (isNaN(parseInt(b)) == true) {
                return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
              }
              // if (b == '') {
              //   return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
              // }
              b = str_1[i].replace('Concentration', ' ').trim().split();
              obj["Concentration"] = b[0];
            }
          }



          // // *************Current*************//
          if (str_1[i].includes("Current")) {
            if (str_1[i].includes("Zero Current")) {
              let c = str_1[i].replace('Zero Current', ' ').trim().split(' ');
              c = c[0];
              // if (isNaN(parseInt(c)) == true) {
              //   return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
              // }
              obj["Zero_Current"] = c;
            } else {
              var current = str_1[i].replace('Current', ' ').trim().split();
              current = current[0];
              if (isNaN(parseInt(current)) == true) {
                return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
              }
              obj["Current"] = current;
            }
          }



          // // *************Temp. Solution*************//
          if (str_1[i].includes("Temp. Solution")) {
            // console.log(str_1[i].replace('Point', ' ').trim().split(' '));
            let d = str_1[i].replace('Temp. Solution', ' ').trim().split();
            d = d[0]
            if (isNaN(parseInt(d)) == true) {
              return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
            }
            obj["Temp_Solution"] = d;
          }

          // *************Temp. Membrane*************//
          if (str_1[i].includes("Temp. Membrane")) {
            let e = str_1[i].replace('Temp. Membrane', ' ').trim().split();
            e = e[0]
            if (isNaN(parseInt(e)) == true) {
              return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
            }
            obj["Temp_Membrane"] = e;
          }

          // *************Calibration Type*************//
          if (str_1[i].includes("Calibration Type")) {
            let CT = str_1[i].replace('Calibration Type', ' ').trim().split(' ');
            CT = CT[0]
            if (CT == 'Auto' || CT == 'Manual') {
              obj["Calibration_Type"] = CT;
            } else {
              return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
            }

          }

          // *************Barometric Pressure*************//
          if (str_1[i].includes("Barometric Pressure")) {
            let f = str_1[i].replace('Barometric Pressure', ' ').trim().split();
            f = f[0]
            if (isNaN(parseInt(f)) == true) {
              return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
            }
            obj["Barometric_Pressure"] = f;
          }

          // *************Slope*************//
          if (str_1[i].includes("Slope")) {
            // console.log(str_1[i].replace('Point', ' ').trim().split(' '));
            let g = str_1[i].replace('Slope', ' ').trim().split();
            g = g[0]
            if (isNaN(parseInt(g)) == true) {
              return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
            }
            obj["Slope"] = g;
          }

          //**********Cal #*********//
          if (str_1[i].includes('Cal #')) {
            let cal = str_1[i].replace('Cal #', ' ').trim().split(' ');
            cal = cal[0]
            if (isNaN(parseInt(cal)) == true) {
              return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
            }
            obj["Cal #"] = cal;
          }
        } else {
          // var Error = "Invalid String"
          // console.log(Error)
          return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
        }
        if (str_1[i].includes('User ID')) {
          str_1.splice(i, 1);
        }
        if (str_1[i].includes('Probe S/n')) {
          str_1.splice(i, 1);
        }

      }
      var newStringData = str_1.join('\n');
      newStringData = newStringData.slice(newStringData.lastIndexOf('Thermo Scientific (c) 2011'), newStringData.lastIndexOf('Operator'))

      var selectrange = await models.tbl_meter_weights.findAll({
        where: {
          meterwt_ID: strBal,
          meterwt_ProbID: strInstrId,
          meterwt_ProbType: ProbType,
          meterwt_ChannelNo: currentChannel
        }
      })
      var result;
      var NegTol = selectrange[0].meterwt_NegTol;
      var PosTol = selectrange[0].meterwt_PosTol;
      // await this.SaveDOcalibData(result = 'Pass', obj, strHmi, strInstrId, NegTol, PosTol);

      // } catch (error) {
      //   console.log(error);
      // }

      if (selectrange.length > 0) {

        var flgOutOfLimit = false;
        // var Obj;
        if (parseFloat(obj[typee]) >= selectrange[0].meterwt_NegTol && parseFloat(obj[typee]) <= selectrange[0].meterwt_PosTol) {

          console.log("Calibration Successful");
          var result = await this.SaveRDOcalibData(result = 'Pass', obj, strHmi, strInstrId, NegTol, PosTol, newStringData, typee);
          var object = await objclsInstrumentUsageLog.InstrumentUsage(strInstrId, ProbType, strHmi, 'RDO Calibration', 0);
          await objph.ActivityLog(strHmi, "Calibration Completed");
          mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Calibration Successful`);
          mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${JSON.stringify(obj)}`)
          return;
        }
        else {
          console.log("Calibration Failed");
          await this.SaveRDOcalibData(result = 'Fail', obj, strHmi, strInstrId, NegTol, PosTol, newStringData, typee);
          var object = await objclsInstrumentUsageLog.InstrumentUsage(strInstrId, ProbType, strHmi, 'RDO Calibration', 0);
          await objph.ActivityLog(strHmi, "Calibration Completed");
          mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage} Calibration Failed`);
          mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${JSON.stringify(obj)}`)
          return;
        }
      }
      else {
        obj[typee] = 0;
        obj.Slope = 0;
        obj.dataRead = false;
        obj.Current = 0;
        obj.Zero_Current = 0;
        obj.Temp_Solution = 0;
        obj.Temp_Membrane = 0;
        obj.Calibration_Type = 0;
        obj.Barometric_Pressure = 0;
        obj.PartialPressure = 0;

        mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage} Calibration Failed`);

      }
    }
    catch (err) {
      console.log(err)
      throw new Error(err)
    }
  }




  // async ActivityLog(idsNo, Activity) {
  //   var objUserInfo = globalData.arrUsers.find(k => k.Hmi == idsNo);
  //   var objActivity = {};
  //   Object.assign(objActivity,
  //     { strUserId: objUserInfo.UserId },
  //     { strUserName: objUserInfo.UserName },
  //     { activity: Activity })
  //   await objActivityLog.ActivityLogEntry(objActivity)
  // }

  async SaveDOcalibData(result, ObjCalibration, IdsNo, strBalId, NegTol, PosTol, newStringData, typee) {
    try {
      var strDbResult = ''
      var strSql = ''
      var ChannelNo = ObjCalibration.Channel
      const tempUserObject = globalData.arrUsers.find(k => k.Hmi == IdsNo);
      var objLastInsertedRepserNo = globalData.LastInsertedRepserNo.find(k => k.idsNo == IdsNo)
      var objarrSelectedChanelIDS = globalData.arrSelectedChanelIDS.find(k => k.IdsNo == parseInt(IdsNo));
      var tempCubicInfo = globalData.arrIdsInfo.find(k => k.idsNo == IdsNo).cubicalData;
      var strselectedInsrtumentType;
      var strPrintingMode = globalData.arrsAllParameters[0].tbl_PrintingMode == 'NULL' ? 'Auto' : globalData.arrsAllParameters[0].tbl_PrintingMode

      for (var ele in tempCubicInfo) {

        if (tempCubicInfo[ele] == strBalId && ele.includes('ID')) {
          strselectedInsrtumentType = ele
          break
        }

      }

      var a = strselectedInsrtumentType.split('Port')
      var ab = (a[1].split('_'))
      var currentChannel = ab[0];
      var objarrSelectedChanelIDS = globalData.arrSelectedChanelIDS.find(k => k.IdsNo == parseInt(IdsNo));
      if (objarrSelectedChanelIDS != undefined) {
        globalData.arrSelectedChanelIDS.splice(globalData.arrSelectedChanelIDS.findIndex((element) => element.Hmi == IdsNo), 1);
      }
      globalData.arrSelectedChanelIDS.push({ IdsNo: IdsNo, selectedChannelIDS: [], currentChannel: currentChannel })
      if (objarrSelectedChanelIDS != undefined) {
        globalData.arrSelectedChanelIDS.splice(globalData.arrSelectedChanelIDS.findIndex((element) => element.Hmi == IdsNo), 1);
      }
      globalData.arrSelectedChanelIDS.push({ IdsNo: IdsNo, selectedChannelIDS: [], currentChannel: currentChannel })
      var strProbeType = tempCubicInfo[`Sys_Port${currentChannel}_Type`]
      var strProbeID = tempCubicInfo[`Sys_Port${currentChannel}_ID`]
      var strBalId = tempCubicInfo[`Sys_Meter`]
      // NEED TO ADD BalanceRecalibStatusObject
      let strDP = 0;
      if (ObjCalibration[typee].split('').includes('.') == true) {
        var strArrSaturationVal = ObjCalibration[typee].split(' ')[0].trim().split('.')
        strDP = strArrSaturationVal[1].length
      }
      var now = new Date();

      if (ObjCalibration["Barometric_Pressure"] != 0 && ObjCalibration["Barometric_Pressure"] != undefined) {

        var masterData = await models.tbl_calibration_master_do.create({
          PrDate: momentObj().format('YYYY-MM-DD'),
          PrTime: momentObj().format('HH:mm:ss'),
          MeterID: strBalId,
          ProbID: strProbeID,
          NegTol: (`${parseFloat(NegTol).toFixed(0)} %`),
          PosTol: (`${parseFloat(PosTol).toFixed(0)} %`),
          DP: strDP,
          Slope: ObjCalibration.Slope,
          Remark: result,
          UserID: tempUserObject.UserId,
          UserName: tempUserObject.UserName,
          ChannelNo: ChannelNo,
          IDSNo: IdsNo,
          PrinterName: tempCubicInfo.Sys_Printer,
          PrintNo: 0,
          Saturation: ObjCalibration[typee],
          Current: ObjCalibration.Current,
          ZeroCurrent: ObjCalibration.Zero_Current,
          TempSolution: ObjCalibration.Temp_Solution,
          TempMembrane: ObjCalibration.Temp_Membrane,
          CalibType: ObjCalibration.Calibration_Type,
          BioPressure: ObjCalibration.Barometric_Pressure, //Barometric Pressure in recent string need to confirm with sir
          AllData: newStringData
        })

      }
      // else {
      //   var masterData = await models.tbl_calibration_master_rdo.create({
      //     PrDate: momentObj().format('YYYY-MM-DD'),
      //     PrTime: momentObj().format('HH:mm:ss'),
      //     MeterID: strBalId,
      //     ProbID: strProbeID,
      //     NegTol: (`${parseFloat(NegTol).toFixed(0)} %`),
      //     PosTol: (`${parseFloat(PosTol).toFixed(0)} %`),
      //     DP: strDP,//
      //     Slope: ObjCalibration.slope,
      //     Remark: result,
      //     UserID: tempUserObject.UserId,
      //     UserName: tempUserObject.UserName,
      //     ChannelNo: ChannelNo,
      //     IDSNo: IdsNo,
      //     PrinterName: tempCubicInfo.Sys_Printer,
      //     PrintNo: 0,
      //     Saturation: ObjCalibration.saturation,
      //     Current: ObjCalibration.current,
      //     ZeroCurrent: ObjCalibration.zeroData,
      //     TempSolution: ObjCalibration.tempSolution,
      //     TempMembrane: ObjCalibration.tempMembrane,
      //     CalibType: ObjCalibration.calibType,
      //     BioPressure: ObjCalibration.BioPressure,
      //     PartialPressure: ObjCalibration.PartialPressure,
      //   })


      // }

      var lastInsertedID = masterData.RecNo;
      if (objLastInsertedRepserNo == undefined) {
        globalData.LastInsertedRepserNo.push({
          IdsNo: IdsNo,
          LastInsertedRepserNo: lastInsertedID
        })

      }
      else {
        objLastInsertedRepserNo.LastInsertedRepserNo = lastInsertedID
      }

      //setting Recalibration to 0 *****************************************/
      if (result == 'Pass') {
        // strSql = `update tbl_ids_setting set Sys_ISRecalib${objarrSelectedChanelIDS.currentChannel}=0 where Sys_IDSNo=${IdsNo}`

        var strSql = await models.tbl_ids_setting.update({
          [`Sys_ISRecalib${currentChannel}`]: 0
        }, {
          where: {
            Sys_IDSNo: IdsNo
          }
        })
        // strDbResult = await Database.execute(strSql)
        tempCubicInfo[`Sys_ISRecalib${currentChannel}`] = 0//reseing Recalibration flag in tbl_ids_setting array
      }
      //******************************************************************* */
      //to release ids from calibration***************************************/
      strDbResult = ''
      strSql = ''
      strSql = `update tbl_ids_setting set Sys_CalibInProcess = 0 where Sys_IDSNo =${IdsNo}`
      // strDbResult = await Database.execute(strSql)
      //**************************************************************************/
      // mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayResult}${ObjCalibration}`)
      var objarrDOCalibData;
      if (objarrDOCalibData != undefined) {
        objarrDOCalibData.saturation = 0;
        objarrDOCalibData.slope = 0;
        objarrDOCalibData.dataRead = false;
        objarrDOCalibData.current = 0;
        objarrDOCalibData.zeroData = 0;
        objarrDOCalibData.tempSolution = 0;
        objarrDOCalibData.tempMembrane = 0;
        objarrDOCalibData.calibType = 0;
        objarrDOCalibData.BioPressure = 0;
        objarrDOCalibData.PartialPressure = 0;
      }
      if (strPrintingMode == 'Auto') {
        var Print_Protocol = await objPrint.AutoPrint(IdsNo, "Calibration");

        if (Print_Protocol == undefined) {
          Print_Protocol = 'Calibration Successful';
          console.log('ProcessPhMeter where print mode is auto')
        }
        return Print_Protocol;
      }
      else {
        return Print_Protocol;
      }
      // return;
    }
    catch (error) {
      console.log('error from SaveDOcalidData : ' + error)
      throw new Error(error)
    }
  }
  async SaveRDOcalibData(result, ObjCalibration, IdsNo, strBalId, NegTol, PosTol, newStringData, typee) {
    try {
      var strDbResult = ''
      var strSql = ''
      var ChannelNo = ObjCalibration.Channel
      const tempUserObject = globalData.arrUsers.find(k => k.Hmi == IdsNo);
      var objLastInsertedRepserNo = globalData.LastInsertedRepserNo.find(k => k.idsNo == IdsNo)
      var objarrSelectedChanelIDS = globalData.arrSelectedChanelIDS.find(k => k.IdsNo == parseInt(IdsNo));
      var tempCubicInfo = globalData.arrIdsInfo.find(k => k.idsNo == IdsNo).cubicalData;
      var strselectedInsrtumentType;
      var strPrintingMode = globalData.arrsAllParameters[0].tbl_PrintingMode == 'NULL' ? 'Auto' : globalData.arrsAllParameters[0].tbl_PrintingMode

      for (var ele in tempCubicInfo) {

        if (tempCubicInfo[ele] == strBalId && ele.includes('ID')) {
          strselectedInsrtumentType = ele
          break
        }

      }

      var a = strselectedInsrtumentType.split('Port')
      var ab = (a[1].split('_'))
      var currentChannel = ab[0];
      var objarrSelectedChanelIDS = globalData.arrSelectedChanelIDS.find(k => k.IdsNo == parseInt(IdsNo));
      if (objarrSelectedChanelIDS != undefined) {
        globalData.arrSelectedChanelIDS.splice(globalData.arrSelectedChanelIDS.findIndex((element) => element.Hmi == IdsNo), 1);
      }
      globalData.arrSelectedChanelIDS.push({ IdsNo: IdsNo, selectedChannelIDS: [], currentChannel: currentChannel })
      if (objarrSelectedChanelIDS != undefined) {
        globalData.arrSelectedChanelIDS.splice(globalData.arrSelectedChanelIDS.findIndex((element) => element.Hmi == IdsNo), 1);
      }
      globalData.arrSelectedChanelIDS.push({ IdsNo: IdsNo, selectedChannelIDS: [], currentChannel: currentChannel })
      var strProbeType = tempCubicInfo[`Sys_Port${currentChannel}_Type`]
      var strProbeID = tempCubicInfo[`Sys_Port${currentChannel}_ID`]
      var strBalId = tempCubicInfo[`Sys_Meter`]
      // NEED TO ADD BalanceRecalibStatusObject
      let strDP = 0;
      if (ObjCalibration[typee].split('').includes('.') == true) {
        var strArrSaturationVal = ObjCalibration[typee].split(' ')[0].trim().split('.')
        strDP = strArrSaturationVal[1].length
      }
      var now = new Date();

      // if (ObjCalibration["Barometric_Pressure"] != 0 && ObjCalibration["Barometric_Pressure"] != undefined) {

      //   var masterData = await models.tbl_calibration_master_do.create({
      //     PrDate: momentObj().format('YYYY-MM-DD'),
      //     PrTime: momentObj().format('HH:mm:ss'),
      //     MeterID: strBalId,
      //     ProbID: strProbeID,
      //     NegTol: (`${parseFloat(NegTol).toFixed(0)} %`),
      //     PosTol: (`${parseFloat(PosTol).toFixed(0)} %`),
      //     DP: strDP,
      //     Slope: ObjCalibration.Slope,
      //     Remark: result,
      //     UserID: tempUserObject.UserId,
      //     UserName: tempUserObject.UserName,
      //     ChannelNo: ChannelNo,
      //     IDSNo: IdsNo,
      //     PrinterName: tempCubicInfo.Sys_Printer,
      //     PrintNo: 0,
      //     Saturation: ObjCalibration.Saturation,
      //     Current: ObjCalibration.Current,
      //     ZeroCurrent: ObjCalibration.Zero_Current,
      //     TempSolution: ObjCalibration.Temp_Solution,
      //     TempMembrane: ObjCalibration.Temp_Membrane,
      //     CalibType: ObjCalibration.Calibration_Type,
      //     BioPressure: ObjCalibration.Barometric_Pressure, //Barometric Pressure in recent string need to confirm with sir

      //   })

      // }
      // else {
      var masterData = await models.tbl_calibration_master_rdo.create({
        PrDate: momentObj().format('YYYY-MM-DD'),
        PrTime: momentObj().format('HH:mm:ss'),
        MeterID: strBalId,
        ProbID: strProbeID,
        NegTol: (`${parseFloat(NegTol).toFixed(0)} %`),
        PosTol: (`${parseFloat(PosTol).toFixed(0)} %`),
        DP: strDP,//
        Slope: ObjCalibration.slope,
        Remark: result,
        UserID: tempUserObject.UserId,
        UserName: tempUserObject.UserName,
        ChannelNo: ChannelNo,
        IDSNo: IdsNo,
        PrinterName: tempCubicInfo.Sys_Printer,
        PrintNo: 0,
        Saturation: ObjCalibration[typee],
        Current: ObjCalibration.current,
        ZeroCurrent: ObjCalibration.zeroData,
        TempSolution: ObjCalibration.tempSolution,
        TempMembrane: ObjCalibration.tempMembrane,
        CalibType: ObjCalibration.calibType,
        BioPressure: ObjCalibration.BioPressure,
        PartialPressure: ObjCalibration.PartialPressure,
        AllData: newStringData
      })

      // }

      var lastInsertedID = masterData.RecNo;
      if (objLastInsertedRepserNo == undefined) {
        globalData.LastInsertedRepserNo.push({
          IdsNo: IdsNo,
          LastInsertedRepserNo: lastInsertedID
        })

      }
      else {
        objLastInsertedRepserNo.LastInsertedRepserNo = lastInsertedID
      }

      //setting Recalibration to 0 *****************************************/
      if (result == 'Pass') {
        // strSql = `update tbl_ids_setting set Sys_ISRecalib${objarrSelectedChanelIDS.currentChannel}=0 where Sys_IDSNo=${IdsNo}`

        var strSql = await models.tbl_ids_setting.update({
          [`Sys_ISRecalib${currentChannel}`]: 0
        }, {
          where: {
            Sys_IDSNo: IdsNo
          }
        })
        // strDbResult = await Database.execute(strSql)
        tempCubicInfo[`Sys_ISRecalib${currentChannel}`] = 0//reseing Recalibration flag in tbl_ids_setting array
      }
      //******************************************************************* */
      //to release ids from calibration***************************************/
      strDbResult = ''
      strSql = ''
      strSql = `update tbl_ids_setting set Sys_CalibInProcess = 0 where Sys_IDSNo =${IdsNo}`
      // strDbResult = await Database.execute(strSql)
      //**************************************************************************/
      // mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayResult}${ObjCalibration}`)
      var objarrDOCalibData;
      if (objarrDOCalibData != undefined) {
        objarrDOCalibData[typee] = 0;
        objarrDOCalibData.slope = 0;
        objarrDOCalibData.dataRead = false;
        objarrDOCalibData.current = 0;
        objarrDOCalibData.zeroData = 0;
        objarrDOCalibData.tempSolution = 0;
        objarrDOCalibData.tempMembrane = 0;
        objarrDOCalibData.calibType = 0;
        objarrDOCalibData.BioPressure = 0;
        objarrDOCalibData.PartialPressure = 0;
      }
      if (strPrintingMode == 'Auto') {
        var Print_Protocol = await objPrint.AutoPrint(IdsNo, "Calibration");

        if (Print_Protocol == undefined) {
          Print_Protocol = 'Calibration Successful';
          console.log('ProcessPhMeter where print mode is auto')
        }
        return Print_Protocol;
      }
      else {
        return Print_Protocol;
      }
      // return;
    }
    catch (error) {
      console.log('error from SaveDOcalidData : ' + error)
      throw new Error(error)
    }
  }

  async PHISE_Calibration_Parsing(str_PHISE_Channel) {
    try {
      let str_1 = str_PHISE_Channel.split("\n");
      let arr = [];
      let obj = {}
      let flag = 0
      // console.log(str_1);
      let hmi = await models.tbl_ids_setting.findAll({
        where: {
          Sys_HMIID: IdsNo
        }
      })
      let strHmi = hmi[0].Sys_IDSNo;
      for (i = 0; i < str_1.length; i++) {
        if (str_1[i].includes("Channel")) {
          arr.push({ "Channel": 3 });
        }

        if (str_1[i].includes("pH Calibration Report")) flag = 1

        if (flag == 1) {

          // *************CONCENTRATION*************//
          if (str_1[i].includes("pH")) {
            if (str_1[i].includes("-- pH Calibration Report --")) {
              let pH = str_1[i].replace('-- pH Calibration Report --', ' ').trim();
              // console.log (pH);
            } else {
              // console.log(str_1[i].replace('Point', ' ').trim().split(' '));
              let b = str_1[i].replace('pH', ' ').trim().split(' ');
              b = b[0]
              // arr.push(a);
              obj["pH"] = b;
              // console.log(arr);
            }
          }
          if (str_1[i].includes("Point")) {
            // console.log(str_1[i].replace('Point', ' ').trim().split(' '));
            let a = str_1[i].replace('Point', ' ').trim().split(' ');
            a = a[0]
            // arr.push(a);
            // console.log("Point",a)
            obj["Point"] = a;
            // console.log(arr);
          }
          // }

          // // *************mV*************//
          if (str_1[i].includes("mV")) {
            // console.log(str_1[i].replace('Point', ' ').trim().split(' '));
            let c = str_1[i].replace('mV', ' ').trim().split(' ');
            c = c[0]
            // arr.push(a);
            obj["mV"] = c;
            // console.log(arr);

          }


          // // *************Temperature*************//
          if (str_1[i].includes("Temperature")) {
            // console.log(str_1[i].replace('Point', ' ').trim().split(' '));
            let d = str_1[i].replace('Temperature', ' ').trim().split(' ');
            d = d[0]
            // arr.push(a);
            obj["Temperature"] = d;
            // console.log(arr);

          }


          if (str_1[i].includes("Calibration Type")) {
            arr.push(obj)
            obj = {}

          }

          //**********SLOPE 1 **** *****/
          if (str_1[i].includes('Slope 1')) {
            // console.log(str_1[i].replace('Point', ' ').trim().split(' '));
            let slope_1 = str_1[i].replace('Slope 1', ' ').trim().split(' ');
            slope_1 = slope_1[0]
            // arr.push(a);
            obj["Slope 1"] = slope_1;
            // arr.push(obj);
            // console.log(obj);

          }

          //**********SLOPE 2 **** *****/
          if (str_1[i].includes('Slope 2')) {
            // console.log(str_1[i].replace('Point', ' ').trim().split(' '));
            let slope_2 = str_1[i].replace('Slope 2', ' ').trim().split(' ');
            slope_2 = slope_2[0]
            // arr.push(a);
            obj["Slope 2"] = slope_2;
            // arr.push(obj);
            // console.log(obj);

          }

          //**********SLOPE 3 **** *****/
          if (str_1[i].includes('Slope 3')) {
            // console.log(str_1[i].replace('Point', ' ').trim().split(' '));
            let slope_3 = str_1[i].replace('Slope 3', ' ').trim().split(' ');
            slope_3 = slope_3[0]
            // arr.push(a);
            obj["Slope 3"] = slope_3;
            // arr.push(obj);
            // console.log(obj);

          }

          //**********SLOPE 4 **** *****/
          if (str_1[i].includes('Slope 4')) {
            // console.log(str_1[i].replace('Point', ' ').trim().split(' '));
            let slope_4 = str_1[i].replace('Slope 4', ' ').trim().split(' ');
            slope_4 = slope_4[0]
            // arr.push(a);
            obj["Slope 4"] = slope_4;
            // arr.push(obj);
            // console.log(obj);
          }

          //**********Eo 1 **** *****/
          if (str_1[i].includes('Eo    1')) {
            // console.log(str_1[i].replace('Point', ' ').trim().split(' '));
            let EO_1 = str_1[i].replace('Eo    1', ' ').trim().split(' ');
            EO_1 = EO_1[0]
            // arr.push(a);
            obj["Eo    1"] = EO_1;
            // arr.push(obj);
            // console.log(obj);
          }

          //**********Eo 2 **** *****/
          if (str_1[i].includes('Eo    2')) {
            // console.log(str_1[i].replace('Point', ' ').trim().split(' '));
            let EO_2 = str_1[i].replace('Eo    2', ' ').trim().split(' ');
            EO_2 = EO_2[0]
            // arr.push(a);
            obj["Eo    2"] = EO_2;
            // arr.push(obj);
            // console.log(obj);
          }

          //**********Eo 3 **** *****/
          if (str_1[i].includes('Eo    3')) {
            // console.log(str_1[i].replace('Point', ' ').trim().split(' '));
            let EO_3 = str_1[i].replace('Eo    3', ' ').trim().split(' ');
            EO_3 = EO_3[0]
            // arr.push(a);
            obj["Eo    3"] = EO_3;
            // arr.push(obj);
            // console.log(obj);
          }

          //**********Eo 4 **** *****/
          if (str_1[i].includes('Eo    4')) {
            // console.log(str_1[i].replace('Point', ' ').trim().split(' '));
            let EO_4 = str_1[i].replace('Eo    4', ' ').trim().split(' ');
            EO_4 = EO_4[0]
            // arr.push(a);
            obj["Eo    4"] = EO_4;
            // arr.push(obj);
            // console.log(obj);
          }

          //**********Average Slope **** *****/
          if (str_1[i].includes('Average Slope')) {
            // console.log(str_1[i].replace('Point', ' ').trim().split(' '));
            let avg = str_1[i].replace('Average Slope', ' ').trim().split(' ');
            avg = avg[0]
            // arr.push(a);
            obj["Average Slope"] = avg;
            // arr.push(obj);
            // console.log(obj);
          }

          //**********Cal #*********//
          if (str_1[i].includes('Cal #')) {
            // console.log(str_1[i].replace('Point', ' ').trim().split(' '));
            let cal = str_1[i].replace('Cal #', ' ').trim().split(' ');
            cal = cal[0]
            // arr.push(a);
            obj["Cal #"] = cal;
            arr.push(obj);
          }
        }
      }


    } catch (error) {
      console.log(error);
    }
  }

  async SavePHISEcalidData(result = 'Pass', ObjCalibration, IdsNo, strBalId, NegTol = '', PosTol = '') {
    try {
      var strDbResult = ''
      var strSql = ''
      var ChannelNo = ''
      const tempUserObject = globalData.arrUsers.find(k => k.IdsNo == IdsNo);
      var objarrSelectedChanelIDS = globalData.arrSelectedChanelIDS.find(k => k.IdsNo == parseInt(IdsNo));
      var tempCubicInfo = globalData.arrIdsInfo.find(k => k.Sys_IDSNo === parseInt(IdsNo));
      ChannelNo = objarrSelectedChanelIDS.currentChannel
      var strProbeType = tempCubicInfo[`Sys_Port${ChannelNo}_Type`]
      var strProbeID = tempCubicInfo[`Sys_Port${ChannelNo}_ID`]
      var strBalId = tempCubicInfo[`Sys_Meter`]
      // NEED TO ADD BalanceRecalibStatusObject
      let strDP = 0;
      if (ObjCalibration.saturation.split(' ')[0].includes('.')) {
        var strArrSaturationVal = ObjCalibration.saturation.split(' ')[0].trim().split('.')
        strDP = strArrSaturationVal[1].length
      }
      var now = new Date();

      if (ObjCalibration.PartialPressure != 0 && ObjCalibration.PartialPressure != undefined) {
        var masterData = await models.tbl_calibration_master_rdo.create({
          PrDate: momentObj().format('YYYY-MM-DD'),
          PrTime: momentObj().format('HH:mm:ss'),
          MeterID: strBalId,
          ProbID: strProbeID,
          NegTol: (`${parseFloat(NegTol).toFixed(0)} %`),
          PosTol: (`${parseFloat(PosTol).toFixed(0)} %`),
          DP: strDP,//
          Slope: ObjCalibration.slope,
          Remark: result,
          UserID: tempUserObject.UserId,
          UserName: tempUserObject.UserName,
          ChannelNo: ChannelNo,
          IDSNo: IdsNo,
          PrinterName: tempCubicInfo.Sys_Printer,
          PrintNo: 0,
          Saturation: ObjCalibration.saturation,
          Current: ObjCalibration.current,
          ZeroCurrent: ObjCalibration.zeroData,
          TempSolution: ObjCalibration.tempSolution,
          TempMembrane: ObjCalibration.tempMembrane,
          CalibType: ObjCalibration.calibType,
          BioPressure: ObjCalibration.BioPressure,
          PartialPressure: ObjCalibration.PartialPressure,
        })
      }



      else {
        var masterData = await models.tbl_calibration_master_do.create({
          PrDate: date.format(now, 'YYYY-MM-DD'),
          PrTime: date.format(now, 'HH:mm:ss'),
          MeterID: strBalId,
          ProbID: strProbeID,
          NegTol: (`${parseFloat(NegTol).toFixed(0)} %`),
          PosTol: (`${parseFloat(PosTol).toFixed(0)} %`),
          DP: strDP,
          Slope: ObjCalibration.slope,
          Remark: result,
          UserID: tempUserObject.UserId,
          UserName: tempUserObject.UserName,
          ChannelNo: ChannelNo,
          IDSNo: IdsNo,
          PrinterName: tempCubicInfo.Sys_Printer,
          PrintNo: 0,
          Saturation: ObjCalibration.saturation,
          Current: ObjCalibration.current,
          ZeroCurrent: ObjCalibration.zeroData,
          TempSolution: ObjCalibration.tempSolution,
          TempMembrane: ObjCalibration.tempMembrane,
          CalibType: ObjCalibration.calibType,
          BioPressure: ObjCalibration.BioPressure,

        })

      }
    } catch (error) {
      console.log(error);
    }




    var lastInsertedID = masterData[0].insertId;
    //setting Recalibration to 0 *****************************************/
    if (result == 'Pass') {
      strSql = `update tbl_ids_setting set Sys_ISRecalib${objarrSelectedChanelIDS.currentChannel}=0 where Sys_IDSNo=${IdsNo}`
      strDbResult = await Database.execute(strSql)
      tempCubicInfo[`Sys_ISRecalib${objarrSelectedChanelIDS.currentChannel}`] = 0//reseing Recalibration flag in tbl_ids_setting array
    }
    //******************************************************************* */
    //to release ids from calibration***************************************/
    strDbResult = ''
    strSql = ''
    strSql = `update tbl_ids_setting set Sys_CalibInProcess = 0 where Sys_IDSNo =${IdsNo}`
    strDbResult = await Database.execute(strSql)
    //**************************************************************************/

    if (objarrDOCalibData != undefined) {
      objarrDOCalibData.saturation = 0;
      objarrDOCalibData.slope = 0;
      objarrDOCalibData.dataRead = false;
      objarrDOCalibData.current = 0;
      objarrDOCalibData.zeroData = 0;
      objarrDOCalibData.tempSolution = 0;
      objarrDOCalibData.tempMembrane = 0;
      objarrDOCalibData.calibType = 0;
      objarrDOCalibData.BioPressure = 0;
      objarrDOCalibData.PartialPressure = 0;
    }
    return;
  }
  catch(error) {
    console.log('error from SavePHISEcalidData : ' + error)
    throw new Error(error)
  }


}
module.exports = DoCalibration;
