const serverConfig = require('../../../../IonLinkProConfig.json');
const { models } = require('../../../config/dbConnection');
const requestIp = require('request-ip');
const axios = require('axios');
const mysql = require('mysql2');
const globalData = require('../../global/globalData');
const clsActivityLog = require('../clsActivityLog.model');
const dbCon = require('../../global/dbCon');
const dbConfig = require('../../global/serverConfig');
const mqtt = require('../Mqtt/MQTTHandler.model');
const objActivityLog = new clsActivityLog();
const date = require('date-and-time');
const clscleararray = require("../clearGlobalArrays");
const objClearArray = new clscleararray;
const sequelize = require('../../../config/dbConnection').sequelize;
const { QueryTypes } = require('sequelize');
const { Op } = require('sequelize');
const MqttModel = require('../Mqtt/mqttSender.class');
const mqttSender = new MqttModel();
let sha1 = require('sha1');

const moment = require('moment');
const momentObj = require('moment');
const object = require('joi/lib/types/object');
const connection = mysql.createConnection({
    host: dbConfig.dbHost,
    database: dbConfig.dbDatabase,
    user: dbConfig.dbUserId,
    password: dbConfig.dbPwd,
    multipleStatements: true
});


class LoginModel {

    async getIDSNo(req) {
        try {
            var FullIp = requestIp.getClientIp(req);

            console.log(req.body.rpiId);
            var resHmi = await models.tbl_rpi.findAll({
                where: {
                    RPIID: req.body.rpiId
                }
            })

            if (resHmi[0] == undefined) {
                return { 'status': "Fail", Message: "TSH not configured" };
            }

            var strHmi = resHmi[0].IDSNo;
            let arrusers = globalData.arrUsers.find(k => k.Hmi == strHmi);
            if (arrusers != undefined) {

                var userId = arrusers.UserId;
                var userName = arrusers.UserName;
                var Hmi = strHmi
                console.log("65-login.model.js -> blank source and active 0 -> userId", userId);
                let lastLoginDate = await this.convertDateTime(new Date())

                await models.tbl_users.update({
                    active: 0,
                    source: '',
                    lstActvtyTime: lastLoginDate,
                    HostName: strHmi
                }, {
                    where: {
                        UserID: userId

                    }
                })
                await models.tbl_activity_log.create({
                    'dt': moment().format('YYYY-MM-DD'),
                    'tm': moment().format('HH:mm:ss'),
                    'userid': userId,
                    'username': userName,
                    'activity': `Power On/Off on TSH ${Hmi}`
                });

                let CurrentCubicalObj = globalData.arrIdsInfo.find(k => k.Hmi == strHmi)


            }

            return { status: "success", result: resHmi }
        } catch (error) {
            console.log(error)
        }
    }

    async loginApi(value) {
        var userId = value.userId;
        var userName = value.userName;
        var userPass = value.userPass;
        var rpi = value.respbi;
        var strHmi = value.Hmi;
        let responseObj = {};

        var user = await models.tbl_users.findAll({
            where: { userID: userId, }
        })
        //To check if user have put correct user id 
        if (user.length == 0) {
            return { status: "Fail", result: "Incorrect User ID or Password" }
        }
        var getParameter = await this.getParameterData();
        globalData.arrsAllParameters.push(getParameter);
        var now = new Date();
        // var ClientIp = Ip;
        var ClientIp;
        if (ClientIp === undefined) {
            ClientIp = '127.0.0.1';
        } else {
            ClientIp = ClientIp;
        }
        var ip = ClientIp;
        if (serverConfig.isLDAP == true) {
            var strReturnProtocol = await this.validateUserLDAP(userId, userPass, strHmi, ip);
            if (strReturnProtocol.status == 'success' && typeof (strReturnProtocol.result) == 'object') {
                mqttSender.sendData(strHmi, `RelayControl:On`);
            }
            return strReturnProtocol;
        } else {
            //     var strReturnProtocol = await this.nonvalidateUserLDAP(userId, userPass, strHmi, ip);
            // }
            // return strReturnProtocol;

            // var userActive = await models.tbl_users.update({ active: 1 }, { where: { userID: userId } })
            if (user[0] != undefined) {
                var data = user[0];
                // var addLoginAttampt = await this.addLoginAttamptValue(userId, "Hardware", userPass, ClientIp); //Store Procedure 
                var userName = user[0].UserName;
                if (data.active == 1) { //active user msg 
                    if (data.source == "Hardware") {
                        // Object.assign(responseObj, { status: 'Fail' }, { result: `User is Already Active On TSH` });
                        Object.assign(responseObj, { status: 'Fail' }, { result: `User is Already Active On Console` });
                        return responseObj;
                    } else {
                        Object.assign(responseObj, { status: 'Fail' }, { result: 'User Already Active On Software' }, { userName: userName });
                        return responseObj;
                    }
                } else if ((data.locked[0] == 1) && (data.Role != "SuperAdmin") && (data.userType != 1)) {
                    Object.assign(responseObj, { status: 'Fail' }, { result: 'User Locked, Please contact Admin' }, { userName: userName })
                    return responseObj;
                } else if (data.realPassword !== userPass) {
                    const auditUnauthorizedUser = await models.tbl_audit_unauthorized_user.create({
                        dt: date.format(now, 'YYYY-MM-DD'),
                        tm: date.format(now, 'HH:mm:ss'),
                        userid: userId,
                        // username: user[0].UserInitials,
                        username: user[0].UserName,
                        Host: ClientIp
                    });
                    var addLoginAttampt = await this.addLoginAttamptValue(userId, "Hardware", userPass, ClientIp); //Store Procedure 
                    if (addLoginAttampt == 'success') {
                        addLoginAttampt = "Unauthorized user "
                    }
                    Object.assign(responseObj, { status: 'Fail' }, { result: addLoginAttampt }, { userName: userName })
                    return responseObj;

                } else if ((data.Status == 1) && (data.Role != "SuperAdmin") && (data.userType != 1)) {
                    // Object.assign(responseObj, { status: 'Fail' }, { result: 'User Temporary Disabled, Contact Admin' }, { userName: userName })
                    Object.assign(responseObj, { status: 'Fail' }, { result: 'User Disabled, Contact Authorized Person' }, { userName: userName })
                    return responseObj;
                } else if ((data.Status == 2) && (data.Role != "SuperAdmin") && (data.userType != 1)) {
                    // Object.assign(responseObj, { status: 'Fail' }, { result: 'User Permanent Disabled, Contact Admin' }, { userName: userName })
                    Object.assign(responseObj, { status: 'Fail' }, { result: 'User Disabled, Contact Authorized Person' }, { userName: userName })
                    return responseObj;
                } else if ((data.Status == 4) && (data.Role != "SuperAdmin") && (data.userType != 1)) {
                    Object.assign(responseObj, { status: 'Fail' }, { result: 'User Auto Disabled, Change Password' }, { userName: userName })
                    return responseObj;
                } else if ((data.PwdExpStauts[0] != 1) && (data.Status == 6) && (data.Role != "SuperAdmin") && (data.userType != 1)) {
                    // Object.assign(responseObj, { status: 'Fail' }, { result: 'User Locked, Please contact Admin' }, { userName: userName })
                    Object.assign(responseObj, { status: 'Fail' }, { result: 'User Locked, Contact Authorized Person' }, { userName: userName })
                    return responseObj;
                } else if ((data.PwdExpStauts[0] == 1) && (data.Status == 6) && (data.Role != "SuperAdmin") && (data.userType != 1)) {
                    Object.assign(responseObj, { status: 'Fail' }, { result: 'Auto Enable Chances Exhausted, Contact Authorized Person' }, { userName: userName })
                    return responseObj;
                } else if ((data.PwdChg[0] == 1) && (data.Role != "SuperAdmin") && (data.userType != 1)) {
                    Object.assign(responseObj, { status: 'Fail' }, { result: 'Please Change Your Password' }, { userName: userName })
                    return responseObj;
                } else if ((data.PwdExpStauts[0] == 1) && (data.Role != "SuperAdmin") && (data.userType != 1)) {
                    Object.assign(responseObj, { status: 'Fail' }, { result: 'Password Expired, Please Change Your Password' }, { userName: userName })
                    return responseObj;
                } else if ((data.Role != "SuperAdmin") && (data.userType != 1)) {
                    var getParameter = await this.getParameterData();
                    // const checkPwdExpiryDay = await this.CheckPwdExpiryDays(userId, userPass, "Hardware", ClientIp);
                    var getUserDetailData = await this.checkIfUserDataExist(userId, userPass, strHmi, userName);
                    const checkPwdExpiryDay = await this.CheckPwdExpiryDays(userId, getParameter);//08/12/22
                    if (checkPwdExpiryDay != 0) {
                        var PwdExpMessage = "Your Password Expire in " + checkPwdExpiryDay + " Days";
                        var objUpdateLoginData = await models.tbl_users.update({
                            active: 1,
                            HostName: "IDS-" + strHmi,
                            source: 'Hardware',
                            LastLoginDt: date.format(new Date(), 'YYYY-MM-DD'),
                            lstActvtyTime: date.format(new Date(), 'YYYY-MM-DD HH:mm:ss')
                        }, { where: { userID: userId } })

                        let timeout = getUserDetailData.result.timeOut = getParameter.tbl_config_TimeoutPeriod;
                        Object.assign(responseObj, { status: 'success' }, { result: { message: PwdExpMessage, UserName: userName, timeOut: timeout } })
                        console.log(responseObj)
                        return responseObj;
                    } else {
                        var getUserDetailData = await this.checkIfUserDataExist(userId, userPass, strHmi, userName);
                        let objActivity = {};
                        var tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);
                        var objUpdateLoginData = await models.tbl_users.update({
                            active: 1,
                            HostName: "IDS-" + strHmi,
                            source: 'Hardware',
                            LastLoginDt: date.format(new Date(), 'YYYY-MM-DD'),
                            lstActvtyTime: date.format(new Date(), 'YYYY-MM-DD HH:mm:ss')
                        }, { where: { userID: userId } })

                        Object.assign(objActivity,
                            { strUserId: tempUserObject.UserId },
                            { strUserName: tempUserObject.UserName },
                            { activity: 'Login On TSH' + " " + strHmi }
                        );
                        await objActivityLog.ActivityLogEntry(objActivity);
                        mqttSender.sendData(strHmi, `RelayControl:On`);

                        getUserDetailData.result.timeOut = getParameter.tbl_config_TimeoutPeriod;
                        return getUserDetailData;
                    }
                } else {
                    var getUserDetailData = await this.checkIfUserDataExist(userId, userPass, strHmi, userName);
                    var getParameter = await this.getParameterData();
                    const checkPwdExpiryDay = await this.CheckPwdExpiryDays(userId, getParameter);
                    if (checkPwdExpiryDay != 0) {
                        var PwdExpMessage = "Your Password Expire in " + checkPwdExpiryDay + " Days";
                        console.log(PwdExpMessage);
                        var objUpdateLoginData = await models.tbl_users.update({
                            active: 1,
                            HostName: "IDS-" + strHmi,
                            source: 'Hardware',
                            LastLoginDt: date.format(new Date(), 'YYYY-MM-DD'),
                            lstActvtyTime: date.format(new Date(), 'YYYY-MM-DD HH:mm:ss')
                        }, { where: { userID: userId } })

                        let timeout = getUserDetailData.result.timeOut = getParameter.tbl_config_TimeoutPeriod;
                        Object.assign(responseObj, { status: 'success' }, { result: { message: PwdExpMessage, UserName: userName, timeOut: timeout } })
                        return responseObj;
                    } else {
                        var getUserDetailData = await this.checkIfUserDataExist(userId, userPass, strHmi, userName);
                        let objActivity = {};
                        var tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);
                        var objUpdateLoginData = await models.tbl_users.update({
                            active: 1,
                            HostName: "IDS-" + strHmi,
                            source: 'Hardware',
                            LastLoginDt: date.format(new Date(), 'YYYY-MM-DD'),
                            lstActvtyTime: date.format(new Date(), 'YYYY-MM-DD HH:mm:ss')
                        }, { where: { userID: userId } })

                        Object.assign(objActivity,
                            { strUserId: tempUserObject.UserId },
                            { strUserName: tempUserObject.UserName },
                            { activity: 'Login On TSH' + " " + strHmi }
                        );
                        await objActivityLog.ActivityLogEntry(objActivity);
                        getUserDetailData.result.timeOut = getParameter.tbl_config_TimeoutPeriod;
                        // return getUserDetailData;
                    }
                    var getUserDetailData = await this.checkIfUserDataExist(userId, userPass, strHmi, userName);
                    if (Object.keys(getUserDetailData).length != 0) {
                        let objActivity = {};
                        var tempUserObject = globalData.arrUsers.find(k => k.Hmi == strHmi);
                        //var strResbPi = await this.RaspberryDetailsWithHmi(strHmi);
                        var objUpdateLoginData = await models.tbl_users.update({
                            active: 1,
                            HostName: "IDS-" + strHmi,
                            source: 'Hardware',
                            LastLoginDt: date.format(new Date(), 'YYYY-MM-DD'),
                            lstActvtyTime: date.format(new Date(), 'YYYY-MM-DD HH:mm:ss')

                        },
                            { where: { UserID: userId } });

                        Object.assign(objActivity,
                            { strUserId: tempUserObject.UserId },
                            { strUserName: tempUserObject.UserName },
                            { activity: 'Login On TSH' + " " + strHmi }
                        );
                        await objActivityLog.ActivityLogEntry(objActivity);
                    }
                    let timeout = await models.tbl_setallparameter.findAll();
                    timeout = timeout[0].tbl_config_TimeoutPeriod;
                    getUserDetailData.result.timeOut = timeout;
                    mqttSender.sendData(strHmi, `RelayControl:On`);
                    return getUserDetailData;
                }
            } else {
                console.log("User not Valid");
                return { status: "Fail", result: "Validate User on Software And Try Again" }
            }
        }
    }


    async logout(value) {

        try {

            var strHmi = value.Hmi;
            var userName = value.userName;
            var userId = value.userId;
            var autoLogout = value.autoLogout;

            // update monit data about Logout operaion and clear weightment status
            var user = await models.tbl_users.findAll({
                where: { userID: userId, }
            })
            userName = user[0].UserInitials
            // var cubicleObj = globalData.arrIdsInfo.find(k => k.idsNo == strHmi)
            // var cubicleNo = cubicleObj.cubicalData.Sys_CubicNo
            await models.tbl_ids_setting.update({
                Sys_WeighmentInProcess: 0,
                Sys_CalibInProcess: 0
            }, { where: { Sys_IDSNo: strHmi } })

            var objUpdateLoginData = await models.tbl_users.update({
                active: 0,
                HostName: '',
                source: '',
                lstActvtyTime: momentObj().format('YYYY-MM-DD HH:mm:ss')
            }, {
                where: {
                    UserId: userId
                }
            })
            objUpdateLoginData;

            var msg = '';
            (autoLogout) ? msg = `Auto Logout from TSH ${strHmi}` : msg = `Logout from TSH ${strHmi}`
            await objClearArray.clearDetails(strHmi);

            await models.tbl_activity_log.create({
                dt: momentObj().format('YYYY-MM-DD'),
                tm: momentObj().format('HH:mm:ss'),
                userid: userId,
                username: userName,
                activity: msg
            })


            var result = { status: "success", message: 'User logout Successfully.' }

            console.log(`${userName} logout Successfully from TSH ${strHmi}`)
            mqttSender.sendData(strHmi, `RelayControl:Off`);
            return result;
        }
        catch (error) {
            console.log(error)
            throw new Error(error);
        }
    }

    // async logoutUser(userId) {
    //     try {
    //         var objUpdateLoginData = await models.tbl_users.update({
    //             'active': 0,
    //             'HostName': 0,
    //             'source': 0,
    //             'lstActvtyTime': momentObj().format('YYYY-MM-DD HH:mm:ss')
    //         }, {
    //             where: {
    //                 UserId: userId
    //             }
    //         })
    //         objUpdateLoginData;
    //     } catch (error) {
    //         throw new Error(error)
    //     }
    // }
    //get parameter
    async getParameterData() {
        try {
            const parameterObj = await models.tbl_setallparameter.findAll({
                where: {
                    config_id: 1
                }
            })
            if (parameterObj.length > 0) {
                var data = parameterObj[0];
                return data;
            } else {
                return false;
            }
        } catch (error) {
            return error;
        }
    }
    //check for password expire days
    // async CheckPwdExpiryDays(userId, userPass, source, ip) {
    //     try {
    //         var responseObj = {};
    //         var now = new Date();
    //         //var userManagementData = await this.userManagement(userId, userPass, source, ip);
    //         console.log("SP.source", source, "-ip", ip);
    //         var userManagementData = await this.userManagement(userId, userPass, source, ip, date.format(now, 'HH:mm:ss'), date.format(now, 'YYYY-MM-DD'));
    //         var message = userManagementData[1][0]['@message'];
    //         var userName = userManagementData[1][0]['@userName'];
    //         // var date = userManagementData[1]
    //         Object.assign(responseObj, { status: 'success' }, { result: message }, { userName: userName })
    //         return responseObj;
    //         //return message;
    //     } catch (error) {
    //         return error;
    //     }
    // }
    // async userManagement(userId, userPass, source, ip, time,dates){
    //     try {
    //         let storedProcedureQuery = `CALL userManagement('${userId}','${userPass}','${source}','${ip}',@message,@userName);SELECT @message,@userName;`;    
    //         var result = await sequelize.query(storedProcedureQuery,{ type: QueryTypes.SELECT });
    //         Object.assign(result,{time:time,date:dates})
    //         return result;
    //     } catch (error) {
    //         console.log("Error : ",error);
    //     }
    // }
    async CheckPwdExpiryDays(userId, getParameter) {
        try {
            var now = new Date();
            var currentDate = date.format(now, 'YYYY-MM-DD');
            var pwdExpDays = getParameter.tbl_config_PasswordExpPeriod;
            var pwdReminderDays = getParameter.tbl_config_ReminderPassword;
            var totalDiff = parseInt(pwdExpDays) - parseInt(pwdReminderDays);

            var SqlQuery = `SELECT PwdChgDate as PwdChgDate FROM tbl_users where DATE_ADD(PwdChgDate,INTERVAL ${totalDiff} DAY)<='${currentDate}'`
            SqlQuery = SqlQuery + ` and UserID='${userId} ' and userType<>1 and PwdExpStauts<>1 and Role != 'SuperAdmin'`
            var objresult = await sequelize.query(SqlQuery, {
                type: QueryTypes.SELECT
            });
            // var objresult = await dbCon.query(SqlQuery)

            if (objresult.length > 0) {
                var objpwdchgDate = moment(objresult[0].PwdChgDate, 'YYYY-MM-DD').format('YYYY-MM-DD')

                var dt1 = new Date(objpwdchgDate);
                var dt2 = new Date(currentDate);
                var daysDiff = Math.floor((Date.UTC(dt2.getFullYear(), dt2.getMonth(), dt2.getDate()) - Date.UTC(dt1.getFullYear(), dt1.getMonth(), dt1.getDate())) / (1000 * 60 * 60 * 24));

                var pwdexpDaysLeft = pwdExpDays - daysDiff;
                return pwdexpDaysLeft;
            }
            else {
                return pwdexpDaysLeft = 0;
            }
        } catch (error) {
            return error;
        }
    }
    // async addLoginAttamptValue(userId, source, userPass, ClientIp) {
    //     try {
    //         var userManagementData = await this.userManagement(userId, source, userPass, ClientIp);
    //         var message = userManagementData[1][0]['@message'];
    //         return message;
    //     } catch (error) {
    //         return error;
    //     }
    // }

    //Check If user Data Exist
    async checkIfUserDataExist(userId, userPass, strHmi) {
        try {
            var responseObj = {};
            const selectUserObj = await models.tbl_users.findAll({
                where: { UserID: userId, realPassword: userPass }
            })

            var result = selectUserObj;
            if (result[0] != undefined) {
                let data = [];
                data = result[0];
                const roleName = data.Role;
                // var userName = data.UserInitials;
                var userName = data.UserName;
                let allRoleRights = [], allSplRights = [], allRemoveRights = [];
                var roleRights = await this.roleRight(roleName);
                var splRights = await this.splRight(userId);
                var removeRights = await this.removeRight(userId);
                for (let i = 0; i < roleRights.length; i++) {
                    allRoleRights.push(roleRights[i].role_rights)
                }
                for (let i = 0; i < splRights.length; i++) {
                    allSplRights.push(splRights[i].spl_right)
                }
                for (let i = 0; i < removeRights.length; i++) {
                    allRemoveRights.push(removeRights[i].removed_right)
                }

                var tmpUserobj = globalData.arrUsers.find(k => k.Hmi == strHmi);
                if (tmpUserobj == undefined) {
                    globalData.arrUsers.push({
                        Hmi: strHmi,
                        UserId: userId,
                        UserName: userName,
                        UserPass: userPass,
                    });
                } else {
                    tmpUserobj.UserId = userId;
                    tmpUserobj.UserName = userName;
                    tmpUserobj.UserPass = userPass;
                }
                await this.checkForRights(strHmi, userId);

                const userCridentialDetail = {
                    UserID: data.UserID,
                    UserName: data.UserName,
                    realPassword: data.realPassword,
                }

                Object.assign(responseObj, { status: 'success' }, { result: userCridentialDetail })
                // Object.assign(data[0], { rights: allRoleRights }, { splRights: allSplRights }, { removeRights: allRemoveRights })
                // Object.assign(responseObj, { status: 'success' }, { result: data[0] }, { userName: userName })
                return responseObj;
            } else {
                return false;
            }

        } catch (error) {
            return error;
        }
    }
    // userManagement(userId, source, userPass, ClientIp) {
    //     return new Promise((resolve, reject) => {
    //         let strquery = "CALL userManagement('" + userId + "','" + userPass + "','" + source + "','" + ClientIp + "'," + "@message" + "," + "@userName);" +
    //             "SELECT @message;";
    //         connection.query(strquery, function (err, rows, fields) {
    //             if (err) {
    //                 console.log(err);
    //             }
    //             //console.log(rows);
    //             resolve(rows);
    //         });

    //         //connection.end();

    //     })
    // }
    //
    async roleRight(roleName) {
        var role = await models.tbl_role.findAll({
            where: { role_name: roleName }
        })
        return role;
        //     return dbCon.execute("SELECT `role_rights` FROM `tbl_role` WHERE `role_name` = ?", [roleName]);
    }
    async splRight(userId) {
        var right = await models.tbl_rights_special.findAll({ where: { userid: userId } })
        return right;
        // return dbCon.execute("SELECT `spl_right` FROM `tbl_rights_special` WHERE `userid`=?", [userId]);
    }
    async removeRight(userId) {
        var remove_right = await models.tbl_rights_removed.findAll({ where: { userid: userId } })
        return remove_right;
        // return dbCon.execute("SELECT `removed_right` FROM `tbl_rights_removed` WHERE `userid`=?", [userId]);
    }


    //check for right 
    async checkForRights(strHmi, strUserId) {
        try {
            var arr_rights = [];
            let selectRole = await models.tbl_users.findAll({
                where: {
                    UserID: strUserId
                }
            })
            let roleResult = selectRole;
            let roleName = roleResult[0].Role;
            // For role Rights
            let selectRights = await models.tbl_role.findAll({
                where: {
                    role_name: roleName,
                    locked: 0
                }
            })

            let roleRights = selectRights;
            // arr_rights = arr_rights.concat(roleRights[0]).map(k => k.role_rights);
            arr_rights = arr_rights.concat(roleRights).map(k => k.role_rights);
            // For special rights
            let selectSpecialRights = await models.tbl_rights_special.findAll({
                where: {
                    userid: strUserId,

                }
            })

            let specialRights = selectSpecialRights;
            let tempSplArr = specialRights.map(k => k.spl_right)
            arr_rights = arr_rights.concat(tempSplArr);
            // For remove rights
            let selectRemoveRights = await models.tbl_rights_removed.findAll({
                where: {
                    userid: strUserId,

                }
            })
            let removeRights = selectRemoveRights;
            let tempRmvArr = removeRights.map(k => k.removed_right);
            arr_rights = arr_rights.filter(
                item => tempRmvArr.indexOf(item) < 0
            );
            let tempRightObj = globalData.arrUserRights.find(t => t.Hmi == strHmi);
            if (tempRightObj == undefined) {
                globalData.arrUserRights.push({
                    Hmi: strHmi,
                    UserId: strUserId,
                    rights: arr_rights
                })
            } else {
                tempRightObj.UserId = strUserId;
                tempRightObj.rights = arr_rights;
            }
            return 1;
        } catch (error) {
            throw new Error(error)
        }
    }
    async convertDateTime(dateInUTCFormat) {
        var dec = momentObj(dateInUTCFormat);
        var normalDate = dec.tz('Asia/Kolkata').format('YYYY-MM-DD HH:mm:ss');  // GMT +5:30 (India)
        return normalDate;
    }
    async validateUserLDAP(userId, userPass, strHmi, ip) {
        try {
            let dt = new Date();
            let now = new Date();
            strHmi = strHmi.toString();
            let user = await models.tbl_users.findAll({
                where: {
                    UserID: userId,
                },
            });
            if (user[0] == undefined) {
                console.log("User not Valid");
                let obj = {
                    status: "fail",
                    result: "Incorrect User ID Or Password",
                };
                return obj;
            }
            if (user[0].realPassword == "VALIDATED") {
                var username = user[0].UserName;
                let obj = { username, userPass };
                const responses = await axios.post(
                    `http://${serverConfig.hostApi}:${serverConfig.APIPORT}/API_V1/ldap/validate`,
                    {
                        strUserName: username,
                        strPassword: userPass,
                        // source: source,
                        // ip : `IDS-${strHmi}`
                    }
                );
                if (responses.data.response == "Authenticated") {
                    const response = await axios.post(
                        `http://${serverConfig.hostApi}:${serverConfig.APIPORT}/API_V1/login/loginMain`,
                        {
                            userId: userId,
                            userPass: "VALIDATED",
                            //  username:userName,
                            source: 'hardware',
                            ip: `${strHmi}`,
                        }
                    );

                    // }
                    if (response.data.result == "Please Change Your Password") {
                        response.data.result = response.data.data;
                        response.data.data.active = 1;
                        let user1 = await models.tbl_users.update(
                            {
                                active: 1,
                            },
                            {
                                where: {
                                    UserID: userId,
                                },
                            }
                        );
                        username = user[0].UserInitials
                        userId = user[0].UserID
                        await models.tbl_activity_log.create({
                            dt: date.format(now, "YYYY-MM-DD"),
                            tm: date.format(now, "HH:mm:ss"),
                            userid: userId,
                            username: username,
                            activity: 'Login On TSH' + " " + strHmi
                        });
                    }
                    if (
                        response.data.result == "User Temporary Disabled, Contact Admin" ||
                        response.data.result == "User Locked, Please contact Admin"
                    ) {
                        response.data.result = "User Disabled Contact Authorized Person";
                    }
                    if (
                        response.data.result ==
                        "Password Expired, Please Change Your Password"
                    ) {
                        response.data.result = response.data.data;
                        response.data.result.active = 1;
                        let user = await models.tbl_users.update(
                            {
                                active: 1,
                            },
                            {
                                where: {
                                    UserID: userId,
                                },
                            }
                        );
                        await models.tbl_activity_log.create({
                            dt: date.format(now, "YYYY-MM-DD"),
                            tm: date.format(now, "HH:mm:ss"),
                            userid: userId,
                            username: username,
                            activity: 'Login On TSH' + " " + strHmi
                        });
                    }

                    if (response != undefined) {
                        if (
                            response.data.result.active != undefined ||
                            response.data.active == 1
                        ) {
                            if (response.data.result.active == 1) {
                                var tmpUserobj = globalData.arrUsers.find(
                                    (k) => k.Hmi == strHmi
                                );
                                if (tmpUserobj == undefined) {
                                    globalData.arrUsers.push({
                                        Hmi: strHmi,
                                        UserId: userId,
                                        UserName: response.data.result.UserInitials,
                                        UserPass: userPass,
                                    });
                                } else {
                                    tmpUserobj.UserId = userId;
                                    (tmpUserobj.UserName = response.data.result.UserInitials),
                                        (tmpUserobj.UserPass = userPass);
                                }
                                let Objright = await this.checkForRights(strHmi, userId)
                                // var tmpUserRightobj = globalData.arrUserRights.find(
                                //     (k) => k.Hmi == strHmi
                                // );

                                // if (tmpUserRightobj == undefined) {
                                //     globalData.arrUserRights.push({
                                //         Hmi: strHmi,
                                //         rights: response.data.result.rights.concat(
                                //             response.data.result.splRights
                                //         ),
                                //         splRights: response.data.result.splRights,
                                //         removeRights: response.data.result.removeRights,
                                //     });
                                // } else {
                                //     tmpUserRightobj.rights = response.data.result.rights.concat(
                                //         response.data.result.splRights
                                //     );
                                //     (tmpUserRightobj.splRight = response.data.result.splRights),
                                //         (tmpUserRightobj.removeRight =
                                //             response.data.result.removeRights);
                                // }
                            }
                        }
                    }
                    if (
                        response.data.result.active != undefined ||
                        response.data.active == 1
                    ) {
                    }
                    let timeout = await models.tbl_setallparameter.findAll();
                    timeout = timeout[0].tbl_config_TimeoutPeriod;
                    response.data.timeOut = timeout;
                    // console.log(response);
                    console.log(response.data.userName + " Logged in")
                    let obj = {
                        status: "success",
                        timeOut: response.data.timeOut,
                        userName: response.data.userName,
                        result: response.data.result,
                    };
                    return obj;
                }
                if (responses.data.response == "Authenticated failed") {
                    let obj = {
                        status: "fail",
                        result: "Incorrect User ID Or Password",
                    };
                    return obj;
                }
            } else {
                console.log("User not Valid");
                let obj = {
                    status: "fail",
                    result: "Validate User on Software And Try Again",
                };
                return obj;
            }
        } catch (error) {
            console.error(error);
        }
    }
    async addLoginAttamptValue(userId, source, userPass, ip) {
        try {
            var responseObj = {};
            var userManagementData = await this.userManagement(userId, source, userPass, ip);
            var message = userManagementData[1][0]['@message'];
            var userName = userManagementData[1][0]['@userName'];
            if (message.toLowerCase().startsWith("suspicious activity found")) {
                message = "Auto Enable Chances Exhausted, Contact Authorized Person"
            }
            Object.assign(responseObj, { status: 'success' }, { result: message }, { userName: userName })
            return responseObj;
            //return message;
        } catch (error) {
            return error;
        }
    }

    userManagement(userId, userPass, source, ip) {
        return new Promise((resolve, reject) => {
            let strquery = "CALL userManagement('" + userId + "','" + userPass + "','" + source + "','" + ip + "'," + "@message,@userName);" +
                "SELECT @message,@userName;";
            connection.query(strquery, function (err, rows, fields) {
                if (err) {
                    console.log(err);
                }
                //console.log(rows);
                resolve(rows);
            });

            //connection.end();

        })
    }
    async nonvalidateUserLDAP(userId, userPass, strHmi, ip) {
        try {
            let dt = new Date();
            let now = new Date();
            strHmi = strHmi.toString();
            var responseObj = {};
            let user = await models.tbl_users.findAll({
                where: {
                    UserID: userId,
                },
            });
            if (user[0] == undefined) {
                console.log("User not Valid");
                let obj = {
                    status: "fail",
                    result: "Incorrect User ID Or Password",
                };
                return obj;
            }
            const response = await axios.post(
                `http://${serverConfig.hostApi}:${serverConfig.APIPORT}/API_V1/login/loginMain`,
                {
                    userId: userId,
                    userPass: userPass,
                    //  username:userName,
                    source: "Hardware",
                    // ip: `${strHmi}`,
                }
            );

            // if (response.data.result.includes('User is Locked for')) {
            //     Object.assign(responseObj, { status: 'success' }, { result: response.data.result })
            //     return responseObj;
            // }
            // if (response.data.result == 'User Already Active On Software'||  'User Already Active On IDS') {
            //     // response.data.result = response.data.result
            //     Object.assign(responseObj, { status: 'success' }, { result: response.data.result })
            //     return responseObj;
            // }
            if (response.data.result.active != undefined || response.data.active == 1) {
                let timeout = await models.tbl_setallparameter.findAll();
                timeout = timeout[0].tbl_config_TimeoutPeriod;
                response.data.timeOut = timeout;
                console.log(response);
                let obj = {
                    status: "success",
                    timeOut: response.data.timeOut,
                    userName: response.data.userName,
                    result: response.data.result,
                };
                var tmpUserobj = globalData.arrUsers.find(k => k.Hmi == strHmi);
                if (tmpUserobj == undefined) {
                    globalData.arrUsers.push({
                        Hmi: strHmi,
                        UserId: userId,
                        UserName: response.data.userName,
                        UserPass: userPass,
                    });
                } else {
                    tmpUserobj.UserId = userId;
                    tmpUserobj.UserName = response.data.userName;
                    tmpUserobj.UserPass = userPass;
                }
                await this.checkForRights(strHmi, userId);

                Object.assign(responseObj, { status: 'success' }, { result: obj })
                return responseObj;
                // return obj;
            }


            // }
            // if (response.data.result == "Please Change Your Password") {
            //     response.data.result = response.data.data;
            //     response.data.data.active = 1;
            //     let user = await models.tbl_users.update(
            //         {
            //             active: 1,
            //         },
            //         {
            //             where: {
            //                 UserID: userId,
            //             },
            //         }
            //     );
            //     await models.tbl_activity_log.create({
            //         dt: date.format(now, "YYYY-MM-DD"),
            //         tm: date.format(now, "HH:mm:ss"),
            //         userid: userId,
            //         username: username,
            //         activity: 'Login On TSH' + " " + strHmi
            //     });
            // }
            // if (
            //     response.data.result == "User Temporary Disabled, Contact Admin" ||
            //     response.data.result == "User Locked, Please contact Admin"
            // ) {
            //     response.data.result = "User Disabled Contact Authorized Person";
            // }
            // if (response.data.result =="Password Expired, Please Change Your Password" ) {
            //     response.data.result = response.data.data;
            //     response.data.result.active = 1;
            //     let user = await models.tbl_users.update(
            //         {
            //             active: 1,
            //         },
            //         {
            //             where: {
            //                 UserID: userId,
            //             },
            //         }
            //     );
            //     await models.tbl_activity_log.create({
            //         dt: date.format(now, "YYYY-MM-DD"),
            //         tm: date.format(now, "HH:mm:ss"),
            //         userid: userId,
            //         username: username,
            //         activity: 'Login On TSH' + " " + strHmi
            //     });
            // }

            // if (response != undefined) {
            //     if (
            //         response.data.result.active != undefined ||
            //         response.data.active == 1
            //     ) {
            //         if (response.data.result.active == 1) {
            //             var tmpUserobj = globalData.arrUsers.find(
            //                 (k) => k.Hmi == strHmi
            //             );
            //             if (tmpUserobj == undefined) {
            //                 globalData.arrUsers.push({
            //                     Hmi: strHmi,
            //                     UserId: userId,
            //                     UserName: response.data.result.UserInitials,
            //                     UserPass: userPass,
            //                 });
            //             } else {
            //                 tmpUserobj.UserId = userId;
            //                 (tmpUserobj.UserName = response.data.result.UserInitials),
            //                     (tmpUserobj.UserPass = userPass);
            //             }

            //             var tmpUserRightobj = globalData.arrUserRights.find(
            //                 (k) => k.Hmi == strHmi
            //             );
            //             if (tmpUserRightobj == undefined) {
            //                 globalData.arrUserRights.push({
            //                     Hmi: strHmi,
            //                     rights: response.data.result.rights.concat(
            //                         response.data.result.splRights
            //                     ),
            //                     splRights: response.data.result.splRights,
            //                     removeRights: response.data.result.removeRights,
            //                 });
            //             } else {
            //                 tmpUserRightobj.rights = response.data.result.rights.concat(
            //                     response.data.result.splRights
            //                 );
            //                 (tmpUserRightobj.splRight = response.data.result.splRights),
            //                     (tmpUserRightobj.removeRight =
            //                         response.data.result.removeRights);
            //             }
            //         }
            //     }
            // }
            // if (response.data.result = 'User Already Active On Software') {
            //     response.data.result = 'User Already Active On Software'
            //     Object.assign()
            // }
            // let timeout = await models.tbl_setallparameter.findAll();
            // timeout = timeout[0].tbl_config_TimeoutPeriod;
            // response.data.timeOut = timeout;
            // console.log(response);
            let obj = {
                status: "success",
                timeOut: response.data.timeOut,
                UserId: userId,
                result: response.data.result,
            };
            return obj;
        } catch (error) {
            console.error(error);
        }
    }

    async passwordHistory(req) {
        try {
            //var responseObj = {};
            var data = [];
            var result = await models.tbl_setallparameter.findAll({ where: { config_id: 1 } })
            // sequelize.execute("SELECT * FROM tbl_setallparameter");
            data = result[0];
            var pwdCount = data.tbl_config_PwdHistoryCount;
            // var result1 = await sequelize.execute("SELECT * FROM tbl_pwd_history WHERE userid = ? ORDER BY pwdChgDate DESC LIMIT ?", [req.body.userId, pwdCount]);
            // return result1[0];
            var result1 = `SELECT * FROM tbl_pwd_history WHERE userid = '${req.body.userId}' ORDER BY pwdChgDate DESC LIMIT ${pwdCount}`
            result1 = await sequelize.query(result1, {
                type: QueryTypes.SELECT
            });
            return result1;
        } catch (error) {
            return error;
        }
    }

    async updatepassword(req) {
        try {
            var responseObj = {};
            var now = new Date();
            const getuserObj = await models.tbl_users.findAll({
                where: {
                    UserID: req.body.userId,
                    realPassword: req.body.userOldPassword
                }
            })
            var result = getuserObj;

            // var result = await dbCon.execute(`SELECT * FROM tbl_users WHERE UserID = '${req.body.userId}' AND BINARY realPassword = BINARY '${req.body.userOldPassword}'`)

            if (result[0] != undefined) {
                const userObj = await models.tbl_users.update({
                    Pwd: sha1(req.body.userPassword),
                    PwdChgDate: momentObj().format('YYYY-MM-DD'),
                    Status: 0,
                    LastLoginDt: momentObj().format('YYYY-MM-DD'),
                    PwdChg: 0,
                    active: 0,
                    PwdExpStauts: 0,
                    realPassword: req.body.userPassword
                }, {
                    where: {
                        UserID: req.body.userId
                    }
                })

                var result1 = userObj[0];
                console.log("result1", result1);
                const insertPasswordObj = await models.tbl_pwd_history.create({
                    userid: req.body.userId,
                    password: sha1(req.body.userPassword),
                    pwdChgDate: momentObj().format('YYYY-MM-DD'),
                    addedTime: momentObj().format('YYYY-MM-DD HH:mm:ss'),
                    realPassword: req.body.userPassword
                })
                var result2 = insertPasswordObj[0];
                console.log("result2", result2);
                /******03042021*******/
                let DoneByUserID = req.body.userId;
                let DoneByUserName = req.body.userName;
                let AffectedUserID = req.body.userId;
                let AffectedUserName = req.body.userName;
                let OldValue = req.body.userOldPassword;
                let NewValue = req.body.userPassword;
                let Remark = req.body.remark;
                /*****03042021********/
                // req.body.status : 1 = Admin (SuperAdmin) | 2 = normal user

                // let Action = "Change Own Password";
                var result = await models.tbl_audit_change_password.create({
                    DoneByUserID: DoneByUserID,
                    DoneByUserName: DoneByUserName,
                    AffectedUserID: AffectedUserID,
                    AffectedUserName: AffectedUserName,
                    OldValue: sha1(OldValue),
                    NewValue: sha1(NewValue),
                    ACTION: "Change Own Password",
                    Remark: Remark
                })
                // var result = dbCon.execute(`INSERT INTO tbl_audit_change_password (DoneByUserID, DoneByUserName, AffectedUserID, AffectedUserName, OldValue, NewValue, ACTION, Remark)
                // VALUES ('${DoneByUserID}','${DoneByUserName}','${AffectedUserID}','${AffectedUserName}',MD5('${OldValue}'),MD5('${NewValue}'),'${Action}','${Remark}')`);


                const passwordChangeActivity = await models.tbl_activity_log.create({
                    dt: momentObj().format('YYYY-MM-DD'),
                    tm: momentObj().format('HH:mm:ss'),
                    userid: req.body.userId,
                    username: req.body.userName,
                    activity: 'Password Change'
                })
                Object.assign(responseObj, { status: 'success' }, { result: 'Password Changed Successfully' })
                return responseObj;
            } else {
                Object.assign(responseObj, { status: 'success' }, { result: 'Old Password is Wrong' })
                return responseObj;
            }
        } catch (error) {
            return (error);
        }
    }
    async getResponsefromids(Data) {
        var { userId, Hmi } = Data
        await models.tbl_users.update({ loginCounter: 0 },
            {
                where: { UserID: userId }
            });
        console.log(`TSH Connect to ${Hmi},${userId}`)
        return `TSH Connect to ${Hmi}`

    }
}

module.exports = LoginModel;