//modules
const loggers = require('../winstonLogger');
const objmoment = require('moment');
const GLOBAL_NOMENCLATURE = require('../../global/GLOBAL_NOMENCLATURE');
const clsMqttSender = require('./mqttSender.class');
const serverConfig = require('../../global/serverConfig');
const { models } = require('../../../config/dbConnection');
const sequelize = require('../../../config/dbConnection').sequelize;
const clsph = require('../InstrumentParsings/ph.model');
const globalData = require('../../global/globalData.js');
const clsActivityLog = require('../clsActivityLog.model');
const clsdailycalibration = require('../InstrumentParsings/ph.model');
const DoInstrumentParsing = require("../InstrumentParsings/DoCalibrationParsing")
const weightmentDORdo = require('../Weighment/Weighment_Parsing')
const clsweighment = require('../Weighment/Weighment_Parsing')
// const clslogin = require('../../../Interface/model/Login/login.model');
const configSetting = require('../clsConfigSetting');
const rdodoParsingtest = new weightmentDORdo()
const DoInsParsing = new DoInstrumentParsing()
const PHISEParsing = new DoInstrumentParsing()
const objWeighment = new clsweighment()

const objActivityLog = new clsActivityLog();
// const calibration = new clsdailycalibration();


//instances
const mqttSender = new clsMqttSender();
const objdaily = new clsdailycalibration();
// const objlogin = new clslogin();
const objConfigSettings = new configSetting();
const objph = new clsph();



class MQTTHandler {

    precision(a) {
        if (!isFinite(a)) return 0;
        var e = 1, p = 0;
        while (Math.round(a * e) / e !== a) { e *= 10; p++; }
        return p;
    }

    //
    async handleProtocol(str_Protocol, strResberryPi) {
        try {

            //mqttSender.sendData(104,"data")
            loggers.MqttProtocolLogger.info(`protocol : ${str_Protocol} recieved from device ${strResberryPi}`);


            const unWantedProtocols = [
                "ACK_DisableCom".toLowerCase(),
                "ACK_EnableCom".toLowerCase(),
                "Hamster Pro20 not found".toLowerCase(),
                "ACK_Disconnected".toLowerCase(),
                'ack_',
                'nack_'
            ]
            if (str_Protocol == "" ||
                unWantedProtocols.some(el => str_Protocol.toLowerCase().includes(el) || str_Protocol.toLowerCase().startsWith(el))) {
                return;
            }

            // if (str_Protocol.toLowerCase() == "Disconnected".toLowerCase()) {

            //     return;
            // }

            // let strHmi = await objHmi.getHmiNoFromResbPi(strResberryPi);
            let Hmi = await models.tbl_ids_setting.findAll({
                where: {
                    Sys_HMIID: strResberryPi
                }
            })
            let strHmi = Hmi[0].Sys_IDSNo
            strHmi =  strHmi.toString()
            loggers.IdsActivityLogger(strHmi).info(`Protocol:${str_Protocol} from device ${strResberryPi} having alias ${strHmi}`)
            // console.log(module)
            let str_ProtocolData = str_Protocol;
            let ProtocolName = str_ProtocolData.split(":")[0];
            let ProtocolPortNo = str_ProtocolData.split(":")[1];
            const arrCurrentOperation = globalData.arrCurrentOperationStatus.find(k => k.Hmi == strHmi);
            const arrCalibInProcess = globalData.arrcalibType.find(k => k.idsNo == strHmi);
            if (arrCurrentOperation != undefined) {
                var arrSelectedMenu = globalData.arrSelectedMenu.find(k => k.Hmi == strHmi);
                var intPortNo1 = arrSelectedMenu.portNo;
                var strInstrumentType = arrSelectedMenu.InstrumentType;
                var strInstrumentId = arrSelectedMenu.instrumentId;
            } else if (arrCalibInProcess != undefined) {
                let hmiDetails = globalData.arrSelectedBalWithHmi.find(k => k.Hmi == strHmi);
                var intPortNo1 = hmiDetails.port;
                var strInstrumentType = hmiDetails.InstrumentType;
                var strInstrumentId = hmiDetails.selectedBal;
            } else {
                console.log('dont proceedd further')
            }
            let result;
            const __paramObj = {
                strHmi: strHmi,
                str_Protocol: str_ProtocolData,
                instrumentId: strInstrumentId,
                ProtocolPortNo: ProtocolPortNo,
                strResberryPi: strResberryPi,
                ProtocolName: ProtocolName,
                Parsedata : ""
            }
            if (arrCalibInProcess != undefined && arrCurrentOperation == undefined ) {
                if (ProtocolName.toLowerCase() === GLOBAL_NOMENCLATURE.ComRead.toLowerCase()) {
                    switch (strInstrumentType) {
                        case GLOBAL_NOMENCLATURE.ph:
                        case GLOBAL_NOMENCLATURE.ISE: {
                            result = await objph.processPHCalibration(__paramObj);
                            return result;
                        }
                        case GLOBAL_NOMENCLATURE.Conductivity: {
                            result = await objph.processConductivityCalibration(__paramObj);
                            return result;
                        }
                        case GLOBAL_NOMENCLATURE.UPW: {
                            result = await objph.processConductivityCalibration(__paramObj);
                            return result;
                        }
                        case GLOBAL_NOMENCLATURE.Temperature: {
                            result = await objph.processTemperatureCalibration(__paramObj);
                            return result;
                        }
                        // case GLOBAL_NOMENCLATURE.ISE: {
                        //     // result = await objBalanceParsing.parsingBalanceData(__paramObj);
                        //     result = await PHISEParsing.PHISE_Calibration_Parsing(__paramObj);
                        //     return result;
                        // }
                        case GLOBAL_NOMENCLATURE.DO: {
                            // result = await objBalanceParsing.parsingBalanceData(__paramObj);
                            result = await DoInsParsing.Do_Calibration_Parsing(__paramObj);
                            return result;
                        }
                        case GLOBAL_NOMENCLATURE.RDO: {
                            // result = await objBalanceParsing.parsingBalanceData(__paramObj);
                            result = await DoInsParsing.RDo_Calibration_Parsing(__paramObj);
                            return result;
                        }

                    }
                }
            } else if (arrCurrentOperation != undefined) {
                switch (strInstrumentType) {
                    case GLOBAL_NOMENCLATURE.ph:{
                    // case GLOBAL_NOMENCLATURE.ISE: {
                      
                        result = await objWeighment.PH_Test_Parsing(__paramObj);
                        return result;
                    }
                    case GLOBAL_NOMENCLATURE.ISE: {
                        result = await objWeighment.PH_ISE_Test_Parsing(__paramObj);
                        return result;
                    }
                    case GLOBAL_NOMENCLATURE.Conductivity: {
                        result = await objWeighment.Conductivity_Test_Parsing(__paramObj);
                        return result;
                    }
                    case 'UPWConductivity': {
                        result = await objWeighment.Conductivity_Test_Parsing(__paramObj);
                        return result;
                    }
                    case GLOBAL_NOMENCLATURE.DO:{
                        result = await rdodoParsingtest.Do_Test_Parsing(__paramObj);
                        return result;
                    }
                    case GLOBAL_NOMENCLATURE.RDO:{
                        result = await rdodoParsingtest.RDo_Test_Parsing(__paramObj);
                        return result;
                    }
                    case GLOBAL_NOMENCLATURE.Temperature:{
                        result = await objWeighment.Temperature_Test_Parsing(__paramObj);
                        return result;
                    }
                    // case GLOBAL_NOMENCLATURE.RDO: {
                    //     result = await rdodoParsingtest.PH_Test_Parsing(__paramObj);
                    //     return result;
                    // }
                }
            } else {
                console.log('dont proceedd further')
            }
        } catch (error) {
            loggers.MqttProtocolLogger.error(`${error} recieved in calibDecider function from device : ${strResberryPi}`)
            throw new Error(error)
        }

    }

}

module.exports = MQTTHandler;