const globalData = require('../../global/globalData');
const clsActivityLog = require('../clsActivityLog.model');
const clsInstrumentUsage = require('../clsInstrumentUsageLog')
const dbCon = require('../../global/dbCon');
const MqttModel = require('../Mqtt/mqttSender.class');
const mqttSender = new MqttModel();
const mqttProtocol = require('../../global/GLOBAL_NOMENCLATURE');
const savingObject = require('../Weighment/clsweighmentsave')
const datasave = new savingObject()
const objActivityLog = new clsActivityLog();
const objclsInstrumentUsageLog = new clsInstrumentUsage();
const date = require('date-and-time');

const momentObj = require('moment');
const { models } = require('../../../config/dbConnection');


class Weighment {
    async Do_Test_Parsing(str_Do_Channel) {
        try {

            let strParse = str_Do_Channel.str_Protocol.split('\n');
            let arr = [];
            let obj = {};
            var strHmi = str_Do_Channel.strHmi;
            var strBalId = str_Do_Channel.instrumentId;
            var tempCubicInfo = globalData.arrIdsInfo.find(k => k.idsNo == strHmi).cubicalData;
            var objarrSelectedChanelIDS = globalData.arrSelectedChanelIDS.find(k => k.IdsNo == parseInt(strHmi));
            var strselectedInsrtumentType;
            for (let ele in tempCubicInfo) {

                if (tempCubicInfo[ele] == strBalId && ele.includes('ID')) {
                    strselectedInsrtumentType = ele
                    break
                }

            }
            var a = strselectedInsrtumentType.split('Port')
            var ab = (a[1].split('_'))
            var currentChannel = ab[0];
            // if (str_Do_Channel.str_Protocol.search('Operator') == -1 || str_Do_Channel.str_Protocol.search('Signature') == -1) {
            //     return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
            // }
            for (let i = 0; i < strParse.length; i++) {
                if (strParse[i].includes("Channel -")) {
                    var slope_1 = strParse[i].replace('Channel -', ' ').trim().split(' ');
                    slope_1 = slope_1[0]
                    if (isNaN(parseInt(slope_1)) == true) {
                        console.log("Channel Invalid String")
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj[`Channel`] = slope_1;
                    if (currentChannel != slope_1) {  // channel validation
                        var strActivity = `Data Received from Channel ${slope_1} Instead of Channel ${currentChannel}`
                        var strResult = await this.ActivityLog(strHmi, strActivity)
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage} ${strActivity}`);
                    }
                }

                if (strParse[i].includes("Concentration")) {
                    let conc = strParse[i].replace('Concentration', ' ').trim();
                    conc = conc
                    if (isNaN(parseInt(conc.split(' ')[0])) == true) {
                        console.log("Concentration Invalid String")
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["Concentration"] = conc;
                }

                if (strParse[i].includes("Saturation")) {
                    let sat = strParse[i].replace('Saturation', ' ').trim();
                    sat = sat
                    if (isNaN(parseInt(sat.split(' ')[0])) == true) {
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["Saturation"] = sat;
                }

                if (strParse[i].includes("Current")) {
                    let Curr = strParse[i].replace('Current', ' ').trim();
                    Curr = Curr
                    if (isNaN(parseInt(Curr.split(' ')[0])) == true) {
                        console.log("Current Invalid String")
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["Current"] = Curr;
                }
                if (strParse[i].includes("Partial")) {
                    let Partial = strParse[i].replace('Partial', ' ').trim();
                    Partial = Partial
                    if (isNaN(parseInt(Partial.split(' ')[0])) == true) {
                        console.log("Partial Invalid String")
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["PartialPressure"] = Partial;
                }

                if (strParse[i].includes("Solution Temp")) {
                    let ST = strParse[i].replace('Solution Temp', ' ').trim();
                    ST = ST
                    if (isNaN(parseInt(ST.split(' ')[0])) == true) {
                        console.log("Solution Temp Invalid String")
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["Solution_Temp"] = ST;
                }

                if (strParse[i].includes("Membrane Temp")) {
                    let MT = strParse[i].replace('Membrane Temp', ' ').trim();
                    MT = MT
                    if (isNaN(parseInt(MT.split(' ')[0])) == true) {
                        console.log("Membrane Temp Invalid String")
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["Membrane_Temp"] = MT;
                }

                if (strParse[i].includes("Barometric Pressure")) {
                    let BP = strParse[i].replace('Barometric Pressure', ' ').trim();
                    BP = BP
                    if (isNaN(parseInt(BP.split(' ')[0])) == true) {
                        console.log("Barometric Pressure Invalid String")
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["Barometric_Pressure"] = BP;
                }

                if (strParse[i].includes("Salinity Correction")) {
                    let SC = strParse[i].replace('Salinity Correction', ' ').trim();
                    SC = SC
                    if (isNaN(parseInt(SC.split(' ')[0])) == true) {
                        console.log("Salinity Correction Invalid String")
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["Salinity_Correction"] = SC;
                }

                if (strParse[i].includes("Slope")) {
                    let slope = strParse[i].replace('Slope', ' ').trim();
                    slope = slope
                    if (isNaN(parseInt(slope.split(' ')[0])) == true) {
                        console.log("Slope Invalid String")
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["Slope"] = slope;
                    arr.push(obj)
                }
                if(strParse[i].includes("Probe S/n ")){
                    strParse.splice(i, 1);
                }
                if(strParse[i].includes("Sample ID")){
                    strParse.splice(i, 1);
                }
                if(strParse[i].includes("User ID")){
                    strParse.splice(i, 1);
                }
            }
            console.log(arr);
            var newStringData = strParse.join('\n');
            newStringData = newStringData.slice(newStringData.lastIndexOf('Thermo Scientific (c) 2011'),newStringData.lastIndexOf('Operator '))

            str_Do_Channel.Parsedata = obj
            let returnData = await datasave.saveDOWdata(str_Do_Channel, newStringData, 'Do');
            mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${JSON.stringify(obj)}`)

            var objDOWData = globalData.arrDOWData.find(k => k.idsNo == parseInt(strHmi));
            if (objDOWData == undefined) {
                globalData.arrDOWData.push({
                    idsNo: IdsNo, Slope: 0, Saturation: 0,
                    Concentration: 0, Current: 0, TempSolution: 0, TempMembrane: 0,
                    BioPressure: 0, SalinityCorrection: 0, PartialPressure: 0,
                });
            } else {
                objDOWData.Saturation = 0;
                objDOWData.Concentration = 0;
                objDOWData.Current = 0;
                objDOWData.TempSolution = 0;
                objDOWData.TempMembrane = 0;
                objDOWData.BioPressure = 0;
                objDOWData.SalinityCorrection = 0;
                objDOWData.PartialPressure = 0;
            }
            return;



        }
        catch (error) {
            console.log(error)
        }
    }
    
    async RDo_Test_Parsing(str_Do_Channel) {
        try {

            let strParse = str_Do_Channel.str_Protocol.split('\n');
            let arr = [];
            let obj = {};
            var strHmi = str_Do_Channel.strHmi;
            var strBalId = str_Do_Channel.instrumentId;
            var tempCubicInfo = globalData.arrIdsInfo.find(k => k.idsNo == strHmi).cubicalData;
            var objarrSelectedChanelIDS = globalData.arrSelectedChanelIDS.find(k => k.IdsNo == parseInt(strHmi));
            var strselectedInsrtumentType;
            for (let ele in tempCubicInfo) {

                if (tempCubicInfo[ele] == strBalId && ele.includes('ID')) {
                    strselectedInsrtumentType = ele
                    break
                }

            }
            var a = strselectedInsrtumentType.split('Port')
            var ab = (a[1].split('_'))
            var currentChannel = ab[0];
            // if (str_Do_Channel.str_Protocol.search('Operator') == -1 || str_Do_Channel.str_Protocol.search('Signature') == -1) {
            //     return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
            // }
            for (let i = 0; i < strParse.length; i++) {
                if (strParse[i].includes("Channel -")) {
                    var slope_1 = strParse[i].replace('Channel -', ' ').trim().split(' ');
                    slope_1 = slope_1[0]
                    if (isNaN(parseInt(slope_1)) == true) {
                        console.log("Channel Invalid String")
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj[`Channel`] = slope_1;
                    if (currentChannel != slope_1) {  // channel validation
                        var strActivity = `Data Received from Channel ${slope_1} Instead of Channel ${currentChannel}`
                        var strResult = await this.ActivityLog(strHmi, strActivity)
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage} ${strActivity}`);
                    }
                }

                if (strParse[i].includes("Concentration")) {
                    let conc = strParse[i].replace('Concentration', ' ').trim();
                    conc = conc
                    if (isNaN(parseInt(conc.split(' ')[0])) == true) {
                        console.log("Concentration Invalid String")
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["Concentration"] = conc;
                }

                // if (strParse[i].includes("Saturation")) {
                //     let sat = strParse[i].replace('Saturation', ' ').trim();
                //     sat = sat
                //     if (isNaN(parseInt(sat.split(' ')[0])) == true) {
                //         return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                //     }
                //     obj["Saturation"] = sat;
                // }

                if (strParse[i].includes("Current")) {
                    let Curr = strParse[i].replace('Current', ' ').trim();
                    Curr = Curr
                    if (isNaN(parseInt(Curr.split(' ')[0])) == true) {
                        console.log("Current Invalid String")
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["Current"] = Curr;
                }
                if (strParse[i].includes("Partial")) {
                    let Partial = strParse[i].replace('Partial Pressure', ' ').trim();
                    Partial = Partial
                    if (isNaN(parseInt(Partial.split(' ')[0])) == true) {
                        console.log("Partial Invalid String")
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["PartialPressure"] = Partial;
                }

                if (strParse[i].includes("Solution Temp")) {
                    let ST = strParse[i].replace('Solution Temp', ' ').trim();
                    ST = ST
                    if (isNaN(parseInt(ST.split(' ')[0])) == true) {
                        console.log("Solution Temp Invalid String")
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["Solution_Temp"] = ST;
                }

                if (strParse[i].includes("Membrane Temp")) {
                    let MT = strParse[i].replace('Membrane Temp', ' ').trim();
                    MT = MT
                    if (isNaN(parseInt(MT.split(' ')[0])) == true) {
                        console.log("Membrane Temp Invalid String")
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["Membrane_Temp"] = MT;
                }

                if (strParse[i].includes("Barometric Pressure")) {
                    let BP = strParse[i].replace('Barometric Pressure', ' ').trim();
                    BP = BP
                    if (isNaN(parseInt(BP.split(' ')[0])) == true) {
                        console.log("Barometric Pressure Invalid String")
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["Barometric_Pressure"] = BP;
                }

                if (strParse[i].includes("Salinity Correction")) {
                    let SC = strParse[i].replace('Salinity Correction', ' ').trim();
                    SC = SC
                    if (isNaN(parseInt(SC.split(' ')[0])) == true) {
                        console.log("Salinity Correction Invalid String")
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["Salinity_Correction"] = SC;
                }

                if (strParse[i].includes("Slope")) {
                    let slope = strParse[i].replace('Slope', ' ').trim();
                    slope = slope
                    if (isNaN(parseInt(slope.split(' ')[0])) == true) {
                        console.log("Slope Invalid String")
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["Slope"] = slope;
                    arr.push(obj)
                }
                if(strParse[i].includes("Probe S/n ")){
                    strParse.splice(i, 1);
                }
                if(strParse[i].includes("Sample ID")){
                    strParse.splice(i, 1);
                }
                if(strParse[i].includes("User ID")){
                    strParse.splice(i, 1);
                }
            }
            console.log(arr);
            var newStringData = strParse.join('\n');
            newStringData = newStringData.slice(newStringData.lastIndexOf('Versa Star Pro'),newStringData.lastIndexOf('Operator '))
            str_Do_Channel.Parsedata = obj
            let returnData = await datasave.saveDOWdata(str_Do_Channel, newStringData, "RDo");
            mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${JSON.stringify(obj)}`)

            var objDOWData = globalData.arrDOWData.find(k => k.idsNo == parseInt(strHmi));
            if (objDOWData == undefined) {
                globalData.arrDOWData.push({
                    idsNo: IdsNo, Slope: 0, Saturation: 0,
                    Concentration: 0, Current: 0, TempSolution: 0, TempMembrane: 0,
                    BioPressure: 0, SalinityCorrection: 0, PartialPressure: 0,
                });
            } else {
                objDOWData.Saturation = 0;
                objDOWData.Concentration = 0;
                objDOWData.Current = 0;
                objDOWData.TempSolution = 0;
                objDOWData.TempMembrane = 0;
                objDOWData.BioPressure = 0;
                objDOWData.SalinityCorrection = 0;
                objDOWData.PartialPressure = 0;
            }
            return;



        }
        catch (error) {
            console.log(error)
        }
    }


    async Temperature_Test_Parsing(str_Temp_Channel){
        
    }

    async PHDateValidator(Calibdatedata) {
        var ActualDate;
        var str = Calibdatedata.replace(/\s/g, '');
        var stored1 = str
        var final_Date = stored1.split(',')[0]
        var CalibDate;
        var str_CalibDate = momentObj(final_Date).format('L');
        str_CalibDate = momentObj(str_CalibDate).format('D-MM-YY');
        str_CalibDate = momentObj(str_CalibDate).format('DD-MM-YY');
        // var str_CalibDate = momentObj(final_Date).format('DD-MM-YY');
        if (str_CalibDate == 'Invalid date') {
            CalibDate = final_Date //Ex.25-11-22

        } else {
            CalibDate = str_CalibDate //Ex.25-Nov-22
        }
        var CalibTime = stored1.split(',')[1];
        ActualDate = momentObj().format("DD-MM-YY");
        ActualPlusOne = momentObj();
        //let current_time1 = moment().format("HH:mm")
        //const current_time = moment(current_time1, ["h:mm A"]).format("HH:mm");
        var currentplus = momentObj().add(30, 'minutes').format("HH:mm")
        var currentplus1 = momentObj(currentplus, ["h:mm A"]).format("HH:mm");
        var currentminus = momentObj().subtract(30, 'minutes').format("HH:mm");
        var currentminus1 = momentObj(currentminus, ["h:mm A"]).format("HH:mm");
        var ActualPlusOne = momentObj(ActualDate, "DD-MM-YY").add(1, 'days');
        var ActualPlusOne = ActualPlusOne.format("DD-MM-YY");
        if (CalibTime.includes('PM') == true || CalibTime.includes('AM') == true) {
            if (CalibTime.includes('PM') == true) {
                CalibTime = CalibTime.split('PM')[0]
            } else {
                CalibTime = CalibTime.split('AM')[0]
            }

        }

        // CalibTime = CalibTime.replace('00','24');
        CalibTime = CalibTime.split(":")[0].includes('00') ? CalibTime.replace('00','24') : CalibTime;
        currentminus1 = currentminus1.split(":")[0].includes('00') ? currentminus1.replace('00','24') : currentminus1;
        currentplus1 = currentplus1.split(":")[0].includes('00') ? currentplus1.replace('00','24') : currentplus1;

        if (((CalibDate == ActualDate)) && ((CalibTime >= currentminus1) && (CalibTime <= currentplus1))) {
            return true;
        } else if (((CalibDate.split("-")[0] == ActualDate.split("-")[0] - 1)) && ((CalibTime >= currentminus1) && (CalibTime <= currentplus1))) {
            return true;
        } else {
            return false;
        }
    }
    async PH_Test_Parsing(str_PH_Channel) {
        try {

            var strHmi = str_PH_Channel.strHmi;
            var str_pH = str_PH_Channel.str_Protocol;
            var strBalId = str_PH_Channel.instrumentId;
            var stringData = str_pH.split("\n");
            var obj = {}
            var newObj = {}
            // var pHParse = str_PH_Channel.str_Protocol.split("/n");//pH_Test.split('\n');
            var arr = [];
            var tempCubicInfo = globalData.arrIdsInfo.find(k => k.idsNo == strHmi).cubicalData;
            var objarrSelectedChanelIDS = globalData.arrSelectedChanelIDS.find(k => k.IdsNo == parseInt(strHmi));
            var strselectedInsrtumentType;
            for (let ele in tempCubicInfo) {

                if (tempCubicInfo[ele] == strBalId && ele.includes('ID')) {
                    strselectedInsrtumentType = ele
                    break
                }

            }
            var a = strselectedInsrtumentType.split('Port')
            var ab = (a[1].split('_'))
            var currentChannel = ab[0];
            // if (str_PH_Channel.str_Protocol.search('Operator') == -1 || str_PH_Channel.str_Protocol.search('Signature') == -1) {
            //     return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
            // }
            for (var i = 0; i < stringData.length; i++) {

                if (stringData[i].includes(":") && stringData[i].includes("-") && stringData[i].includes(",") && !stringData[i].includes("Last Cal")) {
                    var Time = stringData[i];
                    obj[`Time`] = Time;
                    console.log("time")
                    var valid = await this.PHDateValidator(Time);
                    if (valid == false) {
                        console.log("DateValidator Invalid String")
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    Time = Time.split(",")
                    newObj[`date`] = Time[0];
                    newObj[`time`] = Time[1];
                    stringData.splice(i, 1)
                }

                if (stringData[i].includes("Channel -")) {
                    var slope_1 = stringData[i].replace('Channel -', ' ').trim().split(' ');
                    slope_1 = slope_1[0]
                    if (isNaN(slope_1) == true || slope_1 == '') {
                        console.log("Channel Invalid String")
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj[`Channel`] = slope_1;
                    if (currentChannel != slope_1) {  // channel validation
                        var strActivity = `Data Received from Channel ${slope_1} Instead of Channel ${currentChannel}`
                        var strResult = await this.ActivityLog(strHmi, strActivity)
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage} ${strActivity}`);
                    }
                }
                if (stringData[i].includes("pH") && !stringData[i].includes("Mode") && !stringData[i].includes("mV")) {
                    let pH = stringData[i].replace('pH', ' ').trim();
                    // pH = pH
                    var value = pH.replace('pH', ' ').trim();
                    // if (isNaN(parseInt(pH.split(' ')[0])) == true) {
                    //     return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    // }
                    if (isNaN(value) == true || pH == '') {
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    if (isNaN(parseInt(pH)) == true || pH.includes('pH') == false) {
                        console.log('Unit not received');
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["pH"] = pH;
                }

                if (stringData[i].includes("mV")) {
                    let mV = stringData[i].replace('mV', ' ').trim();
                    // mV = mV
                    var value = mV.replace('mV', ' ').trim();
                    // if (isNaN(parseInt(mV.split(' ')[0])) == true) {
                    //     return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    // }
                    if (isNaN(value) == true || mV == '') {
                        console.log("mV Invalid String")
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    if (isNaN(parseInt(mV)) == true || mV.includes('mV') == false) {
                        console.log('Unit not received');
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["mV"] = mV;
                }

                if (stringData[i].includes("Temperature")) {
                    let Temp = stringData[i].replace('Temperature', ' ').trim();
                    // Temp = Temp
                    var value = Temp.replace('C (ATC)', ' ').trim();
                    if (isNaN(value)) {
                        var value = Temp.replace('C (MAN)', ' ').trim();
                    }
                    // if (isNaN(parseInt(Temp.split(' ')[0])) == true) {
                    //     return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    // }
                    if (isNaN(value) == true || Temp == '') {
                        console.log("Temperature Invalid String")
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    // if (isNaN(parseInt(Temp)) == true || Temp.includes('C (ATC)') == false) {
                    //     console.log('Unit not received');
                    //     return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    // }
                    obj["Temperature"] = Temp;
                }

                if (stringData[i].includes("Average Slope")) {
                    let AS = stringData[i].replace('Average Slope', ' ').trim();
                    AS = AS
                    if (isNaN(parseInt(AS.split(' ')[0])) == true) {
                        console.log("Average Slope Invalid String")
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    if (AS.includes('%') == false) {
                        console.log('Unit not received');
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["Average_Slope"] = AS;
                    arr.push(obj);
                }

                if (stringData[i].includes("Probe S/n")) {
                    stringData.splice(i, 1);
                }
                if (stringData[i].includes("Sample ID")) {
                    stringData.splice(i, 1)
                }
                if (stringData[i].includes("User ID")) {
                    stringData.splice(i, 1)
                }

            }

            var newStringData = stringData.join('\n');

            newStringData = newStringData.slice(
                newStringData.lastIndexOf("Thermo Scientific (c) 2011"),
                newStringData.lastIndexOf("Operator"),
            );

            console.log(arr);
            console.log(newStringData);
            var phdata_present = arr.find(k => {
                return (k.hasOwnProperty('Channel') &&
                    k.hasOwnProperty('pH') &&
                    k.hasOwnProperty('mV') &&
                    k.hasOwnProperty('Temperature')

                )
            })
            if (phdata_present == undefined) {
                console.log("phdata Invalid String")
                return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
            }
            str_PH_Channel.Parsedata = arr[0];
            await datasave.savePHdata(str_PH_Channel, newStringData, newObj)
            mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${JSON.stringify(obj)}`);
            mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}: Report Generated`);
        }
        catch (error) {
            console.log(error)
        }

    }

    async Conductivity_Test_Parsing(str_Conduct_Channel) {
        try {

            var strHmi = str_Conduct_Channel.strHmi;
            var str_Conduct = str_Conduct_Channel.str_Protocol;
            var strBalId = str_Conduct_Channel.instrumentId;
            var CondParse = str_Conduct.split("\n");
            var obj = {}
            var newObj = {}
            var arr = [];
            var mode = 'NA';
            var tempCubicInfo = globalData.arrIdsInfo.find(k => k.idsNo == strHmi).cubicalData;
            var objarrSelectedChanelIDS = globalData.arrSelectedChanelIDS.find(k => k.IdsNo == parseInt(strHmi));
            if (!str_Conduct.includes('Channel')) {
                return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                
            }
            var strselectedInsrtumentType;
            for (let ele in tempCubicInfo) {
                
                if (tempCubicInfo[ele] == strBalId && ele.includes('ID')) {
                    strselectedInsrtumentType = ele
                    break
                }
                
            }
            var a = strselectedInsrtumentType.split('Port')
            var ab = (a[1].split('_'))
            var currentChannel = ab[0];
            
            var ProbType = tempCubicInfo[`Sys_Port${currentChannel}_Type`]
            
            for (var i = 0; i < CondParse.length; i++) {

                if (CondParse[i].includes("Channel -")) {
                    var slope_1 = CondParse[i].replace('Channel -', ' ').trim().split(' ');
                    slope_1 = slope_1[0]
                    if (isNaN(slope_1) == true || slope_1 == '') {
                        console.log("Channel Invalid String")
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj[`Channel`] = slope_1;
                    if (currentChannel != slope_1) {  // channel validation
                        var strActivity = `Data Received from Channel ${slope_1} Instead of Channel ${currentChannel}`
                        var strResult = await this.ActivityLog(strHmi, strActivity)
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage} ${strActivity}`);
                    }
                }

                if (CondParse[i].includes("Mode ")) {
                    var modee = CondParse[i].replace('Mode ', ' ').trim().split(' ');
                    mode = modee[0];
                }

                if(mode == 'Resistivity'){
                    if(CondParse[i].includes("Resistivity  ")){
                        var resis = CondParse[i].replace('Resistivity  ', ' ').trim().split(' ');
                        if(resis[1] != 'KOhm-cm'){
                            console.log("KOhm-cm Invalid String")
                        }
                        else{
                            obj['Resistivity'] = resis[0] + " " + resis[1];
                            obj['Mode'] = "Resistivity"
                            // arr.push(obj);
                        }
                    }
                }
                if(mode == 'Salinity'){
                    if(CondParse[i].includes("Salinity  ")){
                        var salin = CondParse[i].replace('Salinity  ', ' ').trim().split(' ');
                        if(salin[1] != 'psu'){
                            console.log("psu Invalid String")
                        }
                        else{
                            obj['Salinity'] = salin[0] + " " + salin[1];
                            obj['Mode'] = "Salinity"
                            // arr.push(obj);
                        }
                    }
                }
                if(mode == 'TDS'){
                    if(CondParse[i].includes("TDS  ")){
                        var tds = CondParse[i].replace('TDS  ', ' ').trim().split(' ');
                        if(tds[1] != 'ppm'){
                            console.log("ppm Invalid String")
                        }
                        else{
                            obj['TDS'] = tds[0] + " " + tds[1];
                            obj['Mode'] = "TDS"
                            // arr.push(obj);
                        }
                    }
                    if(CondParse[i].includes("TDS Factor ")){
                        var tdsfac = CondParse[i].replace('TDS Factor ', ' ').trim().split(' ');
                            obj['TDS Factor'] = tdsfac[0] + " " + tdsfac[1];
                            // arr.push(obj);
                    }
                }
                if (CondParse[i].includes("Conductivity") && !CondParse[i].includes("Mode")) {
                    let cond_1 = CondParse[i].replace('Conductivity', ' ').trim();
                    // cond_1 = cond_1
                    var value = cond_1.replace('uS/cm', ' ').trim();
                    if (isNaN(value)) {
                        value = cond_1.replace('mS/cm', ' ').trim();
                    }
                    // if (isNaN(parseInt(cond_1.split(' ')[0])) == true) {
                    //     return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    // }
                    if (isNaN(value) == true || cond_1 == '') {
                        console.log('Unit not received');
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    // if (isNaN(parseInt(cond_1)) == true || cond_1.includes('uS/cm') == false) {
                    //     console.log('Unit not received');
                    //     return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    // }
                    obj["Conductivity"] = cond_1;
                }

                if (CondParse[i].includes("Conductance")) {
                    let cond_2 = CondParse[i].replace('Conductance', ' ').trim();
                    // cond_2 = cond_2
                    var value = cond_2.replace('uS', ' ').trim();
                    // if (isNaN(parseInt(cond_2.split(' ')[0])) == true) {
                    //     return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    // }
                    if (isNaN(value) == true || cond_2 == '') {
                        console.log("Conductance Invalid String")
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    if (isNaN(parseInt(cond_2)) == true || cond_2.includes('uS') == false) {
                        console.log('Unit not received');
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["Conductance"] = cond_2;
                }

                if (CondParse[i].includes("Temperature")) {
                    let Temp = CondParse[i].replace('Temperature', ' ').trim();
                    // Temp = Temp
                    var value = Temp.replace('C (ATC)', ' ').trim();
                    if (isNaN(value)) {
                        var value = Temp.replace('C (MAN)', ' ').trim();
                    }
                    // if (isNaN(parseInt(Temp.split(' ')[0])) == true) {
                    //     return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    // }
                    if (isNaN(value) == true || Temp == '') {
                        console.log("Temperature Invalid String")
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    // if (isNaN(parseInt(Temp)) == true || Temp.includes('C (ATC)') == false) {
                    //     console.log('Unit not received');
                    //     return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    // }
                    obj["Temperature"] = Temp;
                }

                if (CondParse[i].includes("Temp. Coefficient")) {
                    let TC = CondParse[i].replace('Temp. Coefficient', ' ').trim();
                    // TC = TC
                    var value = TC.replace('%/C', ' ').trim();
                    // if (isNaN(parseInt(TC.split(' ')[0])) == true) {
                    //     return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    // }
                    if (value != 'Off') {
                        if (isNaN(value) == true || TC == '') {
                            console.log("Temp. Coefficient Invalid String")
                            return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                        }
                        if (isNaN(parseInt(TC)) == true || TC.includes('%/C') == false) {
                            console.log('Unit not received');
                            return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                        }
                    }
                    obj["Temp_Coefficient"] = TC;

                }

                if (CondParse[i].includes("Temp. Reference")) {
                    let TR = CondParse[i].replace('Temp. Reference', ' ').trim();
                    // TR = TR
                    var value = TR.replace('C', ' ').trim();
                    // if (isNaN(parseInt(TR.split(' ')[0])) == true) {
                    //     return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    // }
                    if (isNaN(value) == true || TR == '') {
                        console.log("Temp. Reference Invalid String")
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    if (isNaN(parseInt(TR)) == true || TR.includes('C') == false) {
                        console.log('Unit not received');
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["Temp_Reference"] = TR;
                }

                if (CondParse[i].includes("Cell Constant")) {
                    var K_Flag = 0
                    let K = CondParse[i].replace('Cell Constant', ' ').trim();
                    // K = K
                    var value = K.replace('/cm', ' ').trim();
                    // if (isNaN(parseInt(K.split(' ')[0])) == true) {
                    //     return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    // }
                    if (isNaN(value) == true || K == '') {
                        console.log("Cell Constant Invalid String")
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    if (isNaN(parseInt(K)) == true || K.includes('/cm') == false) {
                        console.log('Unit not received');
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["Cell_Constant"] = K;
                    arr.push(obj);
                } else if (CondParse[i].includes("K ")) {
                    var K_Flag = 1
                    let K = CondParse[i].replace('K ', ' ').trim();
                    // K = K
                    var value = K.replace('/cm', ' ').trim();
                    // if (isNaN(parseInt(K.split(' ')[0])) == true) {
                    //     return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    // }
                    if (isNaN(value) == true || K == '') {
                        console.log("K Invalid String")
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    if (isNaN(parseInt(K)) == true || K.includes('/cm') == false) {
                        console.log('Unit not received');
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["K"] = K;
                    arr.push(obj);
                }

                if (CondParse[i].includes("Probe S/n")) {
                    CondParse.splice(i, 1)
                }
                if (CondParse[i].includes("Sample ID")) {
                    CondParse.splice(i, 1)
                }
                if (CondParse[i].includes("User ID")) {
                    CondParse.splice(i, 1)
                }
                if (CondParse[i].includes('-') && CondParse[i].includes(':') && CondParse[i].includes(',') && !CondParse[i].includes('Last Cal')) {
                    var Time = CondParse[i];
                    obj[`Time`] = Time;
                    console.log("time")
                    var valid = await this.PHDateValidator(Time);
                    if (valid == false) {
                        console.log("DateValidator Invalid String")
                        return mqttSender.sendData(objarrSelectedChanelIDS.IdsNo, `${mqttProtocol.DisplayMessage}Invalid String`);

                    }
                    Time = Time.split(",")
                    newObj[`date`] = Time[0];
                    newObj[`time`] = Time[1];
                    CondParse.splice(i, 1)
                }



            }

            var newStringData = CondParse.join('\n');

            newStringData = newStringData.slice(
                newStringData.lastIndexOf("Thermo Scientific (c) 2011"),
                newStringData.lastIndexOf("Operator"),
            );


            console.log(arr);
            console.log(arr);
            // let conductdata = arr.filter((e) => e.hasOwnProperty('Channel'))
            if (arr[0].K != undefined) {
                if(mode == 'Resistivity'){
                    var data_present = arr.find(k => {
                        return (k.hasOwnProperty('Channel') &&
                            k.hasOwnProperty('Conductance') &&
                            k.hasOwnProperty('Resistivity') &&
                            k.hasOwnProperty('K') &&
                            k.hasOwnProperty('Temp_Coefficient') &&
                            // k.hasOwnProperty('Temp_Reference') &&
                            k.hasOwnProperty('Temperature')
    
                        )
                    })
                }else if(mode == 'Salinity'){
                    var data_present = arr.find(k => {
                        return (k.hasOwnProperty('Channel') &&
                            k.hasOwnProperty('Conductance') &&
                            k.hasOwnProperty('Salinity') &&
                            k.hasOwnProperty('K') &&
                            // k.hasOwnProperty('Temp_Coefficient') &&
                            k.hasOwnProperty('Temp_Reference') &&
                            k.hasOwnProperty('Temperature')
    
                        )
                    })
                }else if(mode == 'TDS'){
                    var data_present = arr.find(k => {
                        return (k.hasOwnProperty('Channel') &&
                            k.hasOwnProperty('Conductance') &&
                            k.hasOwnProperty('TDS') &&
                            k.hasOwnProperty('TDS Factor') &&
                            k.hasOwnProperty('K') &&
                            k.hasOwnProperty('Temp_Coefficient') &&
                            // k.hasOwnProperty('Temp_Reference') &&
                            k.hasOwnProperty('Temperature')
    
                        )
                    })
                }else if(mode == 'Conductivity'){
                    var data_present = arr.find(k => {
                        return (k.hasOwnProperty('Channel') &&
                            k.hasOwnProperty('Conductance') &&
                            k.hasOwnProperty('Conductivity') &&
                            k.hasOwnProperty('K') &&
                            k.hasOwnProperty('Temp_Coefficient') &&
                            // k.hasOwnProperty('Temp_Reference') &&
                            k.hasOwnProperty('Temperature')
    
                        )
                    })
                }
            } else {
                if(mode == 'Resistivity'){
                    var data_present = arr.find(k => {
                        return (k.hasOwnProperty('Channel') &&
                            k.hasOwnProperty('Conductance') &&
                            k.hasOwnProperty('Resistivity') &&
                            k.hasOwnProperty('K') &&
                            k.hasOwnProperty('Temp_Coefficient') &&
                            // k.hasOwnProperty('Temp_Reference') &&
                            k.hasOwnProperty('Temperature')
    
                        )
                    })
                }else if(mode == 'Salinity'){
                    var data_present = arr.find(k => {
                        return (k.hasOwnProperty('Channel') &&
                            k.hasOwnProperty('Conductance') &&
                            k.hasOwnProperty('Salinity') &&
                            k.hasOwnProperty('K') &&
                            // k.hasOwnProperty('Temp_Coefficient') &&
                            k.hasOwnProperty('Temp_Reference') &&
                            k.hasOwnProperty('Temperature')
    
                        )
                    })
                }else if(mode == 'TDS'){
                    var data_present = arr.find(k => {
                        return (k.hasOwnProperty('Channel') &&
                            k.hasOwnProperty('Conductance') &&
                            k.hasOwnProperty('TDS') &&
                            k.hasOwnProperty('TDS Factor') &&
                            k.hasOwnProperty('K') &&
                            k.hasOwnProperty('Temp_Coefficient') &&
                            // k.hasOwnProperty('Temp_Reference') &&
                            k.hasOwnProperty('Temperature')
    
                        )
                    })
                }else if(mode == 'Conductivity'){
                    var data_present = arr.find(k => {
                        return (k.hasOwnProperty('Channel') &&
                            k.hasOwnProperty('Conductance') &&
                            k.hasOwnProperty('Conductivity') &&
                            k.hasOwnProperty('K') &&
                            k.hasOwnProperty('Temp_Coefficient') &&
                            // k.hasOwnProperty('Temp_Reference') &&
                            k.hasOwnProperty('Temperature')
    
                        )
                    })
                }
            }
            if (data_present == undefined) {
                console.log("data_present Invalid String")
                return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
            }
            str_Conduct_Channel.Parsedata = arr[0];
            await datasave.saveConductivitycalidData(str_Conduct_Channel, K_Flag, newStringData, newObj, mode, ProbType)
            mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${JSON.stringify(obj)}`);
            mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}: Report Generated`);
        }
        catch (error) {
            console.log(error)
        }

    }

    async PH_ISE_Test_Parsing(str_ISE_Channel) {
        try {

            var strHmi = str_ISE_Channel.strHmi;
            var str_pH = str_ISE_Channel.str_Protocol;
            var strBalId = str_ISE_Channel.instrumentId;
            var stringData = str_pH.split("\n");
            var obj = {}
            // var pHParse = str_PH_Channel.str_Protocol.split("/n");//pH_Test.split('\n');
            var arr = [];
            var tempCubicInfo = globalData.arrIdsInfo.find(k => k.idsNo == strHmi).cubicalData;
            var objarrSelectedChanelIDS = globalData.arrSelectedChanelIDS.find(k => k.IdsNo == parseInt(strHmi));
            var strselectedInsrtumentType;
            for (let ele in tempCubicInfo) {

                if (tempCubicInfo[ele] == strBalId && ele.includes('ID')) {
                    strselectedInsrtumentType = ele
                    break
                }

            }
            var a = strselectedInsrtumentType.split('Port')
            var ab = (a[1].split('_'))
            var currentChannel = ab[0];
            for (var i = 0; i < stringData.length; i++) {
                if (stringData[i].includes("Meter S/N")) {
                    var MeterSN = stringData[i].replace('Meter S/N', ' ').trim().split(' ');
                    MeterSN = MeterSN[0]
                    obj[`Meter S/N`] = MeterSN;
                }
                if (stringData[i].includes("SW Rev")) {
                    var SWRev = stringData[i].replace('SW Rev', ' ').trim().split(' ');
                    SWRev = SWRev[0]
                    obj[`SW Rev`] = SWRev;
                }

                //Module S/n #
                if (stringData[i].includes("Module S/n #")) {
                    var Module = stringData[i].replace('Module S/n #', ' ').trim().split(' ');
                    Module = Module[0]
                    obj[`Module S/n #`] = Module;
                }

                //Method
                if (stringData[i].includes("Method")) {
                    var Method = stringData[i].replace('Method', ' ').trim().split(' ');
                    Method = Method[0]
                    obj[`Method`] = Method;
                }

                //CalLog #
                if (stringData[i].includes("CalLog #")) {
                    var calLog = stringData[i].replace('CalLog #', ' ').trim().split(' ');
                    calLog = calLog[0]
                    obj[`CalLog #`] = calLog;
                }

                if (stringData[i].includes("Channel -")) {
                    var slope_1 = stringData[i].replace('Channel -', ' ').trim().split(' ');
                    slope_1 = slope_1[0]
                    if (isNaN(parseInt(slope_1.split(' ')[0])) == true) {
                        console.log("Channel Invalid String")
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj[`Channel`] = slope_1;
                    if (currentChannel != slope_1) {  // channel validation
                        var strActivity = `Data Received from Channel ${slope_1} Instead of Channel ${currentChannel}`
                        var strResult = await this.ActivityLog(strHmi, strActivity)
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage} ${strActivity}`);
                    }
                }

                if (stringData[i].includes("Electrode Type")) {
                    let Ele_Type = stringData[i].replace('Electrode Type', ' ').trim();
                    Ele_Type = Ele_Type
                    // if (isNaN(parseInt(Ele_Type.split(' ')[0])) == true) {
                    //     return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    // }
                    obj["Electrode_Type"] = Ele_Type;
                }
                if (stringData[i].includes("Concentration")) {
                    let conce = stringData[i].replace('Concentration', ' ').trim();
                    conce = conce
                    if (isNaN(parseInt(conce.split(' ')[0])) == true) {
                        console.log("Concentration Invalid String")
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["Concentration"] = conce;
                }
                if (stringData[i].includes("pH") && !stringData[i].includes("Mode") && !stringData[i].includes("mV")) {
                    let pH = stringData[i].replace('pH', ' ').trim();
                    pH = pH
                    if (isNaN(parseInt(pH.split(' ')[0])) == true) {
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["pH"] = pH;
                }
                if (stringData[i].includes("mV") && !stringData[i].includes("Slope")) {
                    let mV = stringData[i].replace('mV', ' ').trim();
                    mV = mV
                    if (isNaN(parseInt(mV.split(' ')[0])) == true) {
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["mV"] = mV;
                }

                if (stringData[i].includes("Temperature")) {
                    let Temp = stringData[i].replace('Temperature', ' ').trim();
                    Temp = Temp
                    if (isNaN(parseInt(Temp.split(' ')[0])) == true) {
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["Temperature"] = Temp;
                }

                if (stringData[i].includes("Slope")) {
                    if (stringData[i].includes('Average Slope')) {
                        let avg = stringData[i].replace('Average Slope', ' ').trim().split();
                        avg = avg[0]
                        if (isNaN(parseInt(avg.split(' ')[0])) == true) {
                            return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                        }
                        // arr.push(a);
                        obj["Average_Slope"] = avg;
                    } else {
                        let AS = stringData[i].replace('Slope', ' ').trim();
                        AS = AS
                        if (isNaN(parseInt(AS.split(' ')[0])) == true) {
                            return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                        }
                        obj["Slope"] = AS;
                        // arr.push(obj);
                    }
                    arr.push(obj);
                }
                if (stringData[i].includes("Probe S/n")) {
                    stringData.splice(i, 1);
                }
                if (stringData[i].includes("Sample ID")) {
                    stringData.splice(i, 1)
                }
                if (stringData[i].includes("User ID")) {
                    stringData.splice(i, 1)
                }

            }
            
            var newStringData = stringData.join('\n');

            newStringData = newStringData.slice(
                newStringData.lastIndexOf("Thermo Scientific (c) 2011"),
                newStringData.lastIndexOf("Operator"),
            );

            console.log(obj);
            console.log(newStringData);

            str_ISE_Channel.Parsedata = arr[0];
            await datasave.savePH_ISEdata(str_ISE_Channel, newStringData)
            mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${JSON.stringify(obj)}`)
        } catch (err) {
            console.log(err);

        }

    }

    async ActivityLog(idsNo, Activity) {
        var objUserInfo = globalData.arrUsers.find(k => k.Hmi == idsNo);
        var objActivity = {};
        Object.assign(objActivity,
            { strUserId: objUserInfo.UserId },
            { strUserName: objUserInfo.UserName },
            { activity: Activity })
        await objActivityLog.ActivityLogEntry(objActivity)
    }
}
module.exports = Weighment;