var request = require('request');
const globalData = require('../../global/globalData');
const date = require('date-and-time');
const date1 = require('date-and-time');
let now = new Date();
const clsActivityLog = require('../clsActivityLog.model');
const objActivityLog = new clsActivityLog();
const Database = require('../../database/clsQueryProcess');
// const DailyCalibrationModel = require('../InstrumentParsings/ph.model');
// const dailyCalibrationModel = new DailyCalibrationModel();
const clsInstrumentUsageLog = require('../../model/clsInstrumentUsageLog');
const objclsInstrumentUsageLog = new clsInstrumentUsageLog();
// const clsErrorLog = require('../../model/clsErrorlog');
const serverConfig = require('../../global/serverConfig');
const { models } = require('../../../config/dbConnection');
const objDatabase = new Database();
const axios = require('axios').default;
var moment = require("moment")

class onlinePrint {
    async AutoPrint(idsNo, Type, lastInsertedID, reporttype) {
        try {
            var returnProtocol = ''
            var objarrSelectedChanelIDS = globalData.arrSelectedChanelIDS.find(k => k.IdsNo == parseInt(idsNo));
            let tempCubicleObject = globalData.arrIdsInfo.find(k => k.idsNo == idsNo).cubicalData;
            var objLastInsertedRepserNo = globalData.LastInsertedRepserNo.find(k => k.IdsNo == idsNo)
            var ObjUser = globalData.arrUsers.find(k => k.Hmi == idsNo);
            var SelectedinstrType = tempCubicleObject[`Sys_Port${objarrSelectedChanelIDS.currentChannel}_Type`]
            var strPrintingMode = globalData.arrsAllParameters[0].tbl_PrintingMode == 'NULL' ? 'Auto' : globalData.arrsAllParameters[0].tbl_PrintingMode
            const tempCubicInfo = globalData.arrIdsInfo.find(k => k.idsNo == idsNo);
            if (tempCubicleObject.Sys_Printer == 'NA') {
                console.log("Printer set NA")
                returnProtocol = 'RST Report Generated,,,,';
                return returnProtocol;
            } else {
                var viewObject = {
                    RepSerNo: lastInsertedID,
                    ReportName: `Repo_${SelectedinstrType}_${Type}`,
                    isVerifyApplicable: 'false',
                    PrintNo: 0,
                    online: true,
                    UserID: ObjUser.UserId,
                    UserName: ObjUser.UserName
                }


                switch (SelectedinstrType) {
                    case "pH":
                        if (reporttype == "Single") {
                            viewObject.ReportName = `Repo_${SelectedinstrType}_${Type}_Single`
                        } else {
                            viewObject.ReportName = `Repo_${SelectedinstrType}_${Type}_AllData`
                        }
                        break;

                    case "pH/ISE":
                        if (globalData.arrISEMeter.pHwtinISEflg == true) {
                            var SelectedinstrType = 'pH'
                            viewObject.ReportName = `Repo_${SelectedinstrType}_${Type}`
                        }
                        else {
                            var SelectedinstrType = 'pHISE'
                            viewObject.ReportName = `Repo_${SelectedinstrType}_${Type}`
                        }

                        break;

                    case "Conductivity":
                        viewObject.ReportName = `Repo_${SelectedinstrType}_${Type}_AllData`
                        break;

                    case "DO/RDO":

                        if (globalData.arrDOWData.rdoindoflag == true) {

                            viewObject.ReportName = `Repo_${SelectedinstrType}_${Type}`

                        }
                        else {
                            var SelectedinstrType = "DO";
                            viewObject.ReportName = `Repo_${SelectedinstrType}_${Type}`
                        }
                        break;

                    default:
                        break;
                }
                globalData.arrDOWData.rdoindoflag = false
                globalData.arrISEMeter.pHwtinISEflg = false
                var res = await axios.post(`http://${serverConfig.HOST_IP}:${serverConfig.APIPORT_NO}/API_V1/phTestReport/viewPHMeterReport`, viewObject);
                if (res.data.filepath != "") {
                    var filepath = res.data.filepath;
                    var strSelectedPrinter = tempCubicleObject.Sys_Printer;
                    var printObj = {
                        strSelectedPrinter: strSelectedPrinter,
                        filepath: filepath
                    }
                    var PrintRes = await axios.post(`http://${serverConfig.HOST_IP}:${serverConfig.APIPORT_NO}/API_V1/report/PrintReport`, printObj);
                    var objPrintCountUP = {
                        RepSerNo: lastInsertedID,
                        MeterID: tempCubicInfo.cubicalData.Sys_Meter,
                        ProbeType: SelectedinstrType,
                        int_printNo: 1,
                        UserID: ObjUser.UserId,
                        UserName: ObjUser.UserName,
                        Reason: "-"
                    }
                }
                globalData.LastInsertedRepserNo.splice(globalData.LastInsertedRepserNo.findIndex((element) => element.IdsNo == idsNo), 1);
                console.log('PrintStatus:', PrintRes.data.Message, strSelectedPrinter)
                if (PrintRes.data.Message == 'Print Successfull' || PrintRes.data.status.toLowerCase() == 'success') {
                    if (Type.toLowerCase() === "calibration") {
                        objPrintCountUP = {
                            BalanceID: tempCubicInfo.cubicalData.Sys_Meter,
                            calibrationType: "Daily",
                            // date: "2024-01-28T18:30:00.000Z" ,
                            date: moment().format("YYYY-MM-DDTHH:mm:ss") + ".000Z",
                            printNo: 0,
                            probeType: SelectedinstrType,
                            repSrNo: lastInsertedID,
                            reportType: "Complete",
                            strReason: "-",
                            userID: ObjUser.UserId,
                            username: ObjUser.UserName
                        }
                        var res = await axios.post(`http://${serverConfig.HOST_IP}:${serverConfig.APIPORT_NO}/API_V1/report/printCountUpCalibration`, objPrintCountUP);
                    } else {
                        var res = await axios.post(`http://${serverConfig.HOST_IP}:${serverConfig.APIPORT_NO}/API_V1/report/printcountupPHTest`, objPrintCountUP);
                    }
                }
                returnProtocol = 'RST Report Generated,,,,';
                return returnProtocol;
            }
        }
        catch (err) {
            console.log('error from AutoPrint :' + err)
            var strSql = await models.tbl_ids_setting.update({
                Sys_WeighmentInProcess: 0
            }, {
                where: {
                    Sys_IDSNo: idsNo
                }
            })

            return;
            // throw new Error('RST Report Generated,,,')
        }
    }
}
module.exports = onlinePrint