const { models } = require('../../config/dbConnection');
const GLOBAL_NOMENCLATURE = require('../global/GLOBAL_NOMENCLATURE')
const { tbl_balance, tbl_vernier, tbl_socoge } = require('../../config/dbConnection').models;


class clsConfigSetting {
    async getConfigdata(table_Name, column_Name, prop_Name, type, value, port) {
        // let configobj = await table_Name.findAll({
        //     where:{
        //         [`${column_Name}`] :  value 
        //     }
        // })
        if (value == 'None') {
            return
        }
        // let queryTable = table_Name;
        // if (type == GLOBAL_NOMENCLATURE.Balance) {
        //     queryTable = tbl_ids_setting;
        // } else if (type == GLOBAL_NOMENCLATURE.Vernier) {
        //     queryTable = tbl_vernier;
        // } else {
        //     queryTable = tbl_socoge;
        // }
        let getDetails = await models.tbl_ids_setting.findAll({
            where: {
                [`${column_Name}`]: value
            }
        })
        getDetails = [getDetails];
        let R_timeout = prop_Name + '_receiveTimeout';
        let B_Mode = prop_Name + '_bulkMode';
        let B_Rate = prop_Name + '_buadRate';
        let D_Bit = prop_Name + '_databit';
        let parity = prop_Name + ' _parity';
        let S_Bit = prop_Name + '_stopbit';
        let Stability_Treshold_Value = prop_Name + '_stability_treshold';
        let balModeProperty = prop_Name + '_Model'
        let Bal_Min_Treshold = null;
        let Received_Timeout = getDetails[0][R_timeout];
        let Bulk_Mode = getDetails[0][B_Mode];
        let Baud_Rate = getDetails[0][0][B_Rate];
        let Data_Bit = getDetails[0][0][D_Bit];
        let Parity = getDetails[0][0][parity];
        let Stop_Bit = getDetails[0][0][S_Bit];
        let Stability_Treshold = getDetails[0][0][Stability_Treshold_Value];
        let balModel = getDetails[0][0][balModeProperty];

        // if (port == 1 && type == 'Balance') {
        //     Baud_Rate = 9600
        // } else if (port == 2 && type == 'Vernier' || port == 3 && type == 'Socoge gauge') {
        //     Baud_Rate = 4800;
        //     Data_Bit = 7;
        //     Parity = 'even'

        // }

        const ConfigSetting = {
            type: type,
            portNo: 1,//Number(port),
            Receive_Timeout: Received_Timeout === undefined ? 1500 : Received_Timeout,
            Bulk_Mode: 1,
            Baud_Rate: Baud_Rate == null ? 9600 : Baud_Rate,
            Data_Bit: Data_Bit == null ? 8 : Data_Bit,
            Parity: Parity == null ? "None" : Parity,
            Stop_Bit: Stop_Bit == null ? 1 : Stop_Bit,
            Min_Threshold: Bal_Min_Treshold == null ? parseFloat(1.0) : Bal_Min_Treshold,
            Stability_Threshold: Stability_Treshold == undefined ? 0 : Stability_Treshold,
            instrumentId: value,


        }
        return ConfigSetting;


    }

    async getConfiSetting(intTSHno, InstrumentType, PortNo) {
        try {
            let cubDetails = await models.tbl_ids_setting.findAll({
                where: {
                    'Sys_IDSNo': intTSHno
                }
            })
            let cubicalDetails = cubDetails[0];
            let i = PortNo;

            let arrAllListOfBal = [];
            let mainsetting = [];
            let arrDetailOfallBalance = [];
            let arrDetailOfallVernier = [];
            let arrDetailOfallSocoge = [];

            for (let obj in cubicalDetails) {
                if (`Sys_Port${i}_Type` == undefined || `Sys_Port${i}_Type` == null || `Sys_Port${i}_Type` == 'NULL' || `Sys_Port${i}` == 'None') {
                    i++;
                    continue;

                }
                else {
                    let type = cubicalDetails[`Sys_Port${i}_Type`];
                    if (cubicalDetails[`Sys_Port${i}_Type`] == GLOBAL_NOMENCLATURE.ph) {
                        let obj = { "PHID": cubicalDetails[`Sys_Port${i}_ID`], 'PortNo': i }
                        let PH_id = obj.PHID;
                        let Port = `${i}`
                        let PH_Setting = await this.getConfigdata('tbl_ids_setting', `Sys_Port${i}_ID`, 'pH', type, PH_id, Port)
                        if (PH_Setting != undefined) {
                            mainsetting.push(PH_Setting);
                        }

                    } else if (cubicalDetails[`Sys_Port${i}_Type`] == GLOBAL_NOMENCLATURE.DO) {
                        let obj = { "DOID": cubicalDetails[`Sys_Port${i}_ID`], 'PortNo': i }
                        let DO_id = obj.DOID;
                        let Port = `${i}`
                        let DO_Setting = await this.getConfigdata('tbl_ids_setting', `Sys_Port${i}_ID`, 'DO', type, DO_id, Port)
                        if (DO_Setting != undefined) {
                            mainsetting.push(DO_Setting);
                        }

                    } else if (cubicalDetails[`Sys_Port${i}_Type`] == GLOBAL_NOMENCLATURE.UPW) {
                        let obj = { "UPWID": cubicalDetails[`Sys_Port${i}_ID`], 'PortNo': i }
                        let DO_id = obj.UPWID;
                        let Port = `${i}`
                        let DO_Setting = await this.getConfigdata('tbl_ids_setting', `Sys_Port${i}_ID`, 'UPW', type, DO_id, Port)
                        if (DO_Setting != undefined) {
                            mainsetting.push(DO_Setting);
                        }

                    } else if (cubicalDetails[`Sys_Port${i}_Type`] == GLOBAL_NOMENCLATURE.RDO) {
                        let obj = { "RDOID": cubicalDetails[`Sys_Port${i}_ID`], 'PortNo': i }
                        let DO_id = obj.RDOID;
                        let Port = `${i}`
                        let DO_Setting = await this.getConfigdata('tbl_ids_setting', `Sys_Port${i}_ID`, 'RDO', type, DO_id, Port)
                        if (DO_Setting != undefined) {
                            mainsetting.push(DO_Setting);
                        }

                    } else if (cubicalDetails[`Sys_Port${i}_Type`] == GLOBAL_NOMENCLATURE.ISE) {
                        let obj = { "ISEID": cubicalDetails[`Sys_Port${i}_ID`], 'PortNo': i }
                        let ISE_id = obj.ISEID;
                        let Port = `${i}`
                        let ISE_Setting = await this.getConfigdata('tbl_ids_setting', `Sys_Port${i}_ID`, 'ISE', type, ISE_id, Port)
                        if (ISE_Setting != undefined) {
                            mainsetting.push(ISE_Setting);
                        }

                    } else if (cubicalDetails[`Sys_Port${i}_Type`] == GLOBAL_NOMENCLATURE.Temperature) {
                        let obj = { "Temperature": cubicalDetails[`Sys_Port${i}_ID`], 'PortNo': i }
                        let ISE_id = obj.Temperature;
                        let Port = `${i}`
                        let ISE_Setting = await this.getConfigdata('tbl_ids_setting', `Sys_Port${i}_ID`, 'Temperature', type, ISE_id, Port)
                        if (ISE_Setting != undefined) {
                            mainsetting.push(ISE_Setting);
                        }

                    } else if (cubicalDetails[`Sys_Port${i}_Type`] == GLOBAL_NOMENCLATURE.Conductivity) {
                        let obj = { "ConID": cubicalDetails[`Sys_Port${i}_ID`], 'PortNo': i }
                        let Con_id = obj.ConID;
                        let Port = `${i}`
                        let Con_Setting = await this.getConfigdata('tbl_ids_setting', `Sys_Port${i}_ID`, 'Conductivity', type, Con_id, Port)
                        if (Con_Setting != undefined) {
                            mainsetting.push(Con_Setting);
                        }

                    }
                }
                i++;
            }
            let menuDetails = mainsetting.filter(k => k.type == InstrumentType);
            return menuDetails;

        }
        catch (err) {
            throw new Error(err);
        } finally {

        }
    }
}


module.exports = clsConfigSetting

