const express = require('express');
const path = require('path');
const app = express();
const cors = require('cors');
const bodyParser = require('body-parser');
const sequelize = require('./config/dbConnection').sequelize
const { QueryTypes } = require('sequelize');
//middlewares
app.use(express.static(path.join(__dirname, '')));
app.use(cors({ credentials: true, origin: true }))
app.use(bodyParser.json());
app.use(express.json());

//module import
require('./Interface/model/Mqtt/mqtt.model');
const serverConfig = require('./Interface/global/serverConfig');
const login = require('./Interface/routes/login.route');
const calibration = require('./Interface/routes/calibrationroute');
const Weighment = require('./Interface/routes/weightment.route');
const passwordcomplexity = require('./Interface/routes/pwdcomplexityRoute')

//Middleware for Interface Routes
app.use('/Interface/login', login);
app.use('/Interface/calibration', calibration);
app.use('/Interface/Weighment', Weighment);
app.use('/Interface/pwdcomplexity', passwordcomplexity);


app.listen(serverConfig.INTERFACE_NO, serverConfig.HOST_IP, async () => {
    //await sequelize.query(str_Query, { type: QueryTypes.INSERT })
    // await sequelize.query(`update tbl_users set active = 0 where (source = "hardware"|| source ="")`, { type: QueryTypes.UPDATE })
    console.log(`Interface SERVER STARTED ON : ${serverConfig.HOST_IP}:${serverConfig.INTERFACE_NO}....`);
});

process.on('uncaughtException', (err, origin) => {
    console.log(err);
    console.log('error came');
})
