const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('tbl_calibration_detail_ph', {
    RecNo: {
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true
    },
    RepSerNo: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    RecSeqNo: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    Slope: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    Eo: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    }
  }, {
    sequelize,
    tableName: 'tbl_calibration_detail_ph',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "RecNo" },
        ]
      },
    ]
  });
};
