const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('tbl_calibration_master_ph', {
    RecNo: {
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true
    },
    PrDate: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    PrTime: {
      type: DataTypes.TIME,
      allowNull: true
    },
    MeterID: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "NULL"
    },
    ProbID: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "NULL"
    },
    NegTol: {
      type: DataTypes.STRING(30),
      allowNull: true
    },
    PosTol: {
      type: DataTypes.STRING(30),
      allowNull: true
    },
    DP: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    AvgSlope: {
      type: DataTypes.STRING(30),
      allowNull: true,
      defaultValue: "0"
    },
    Remark: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    UserID: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "NULL"
    },
    UserName: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "NULL"
    },
    ChannelNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    IDSNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    ProbType: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "pH"
    },
    ProdID: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "NULL"
    },
    PrinterName: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "NULL"
    },
    PrintNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    CheckedByID:{
      type: DataTypes.STRING(500),
    },
    CheckedByName:{
      type: DataTypes.STRING(500),
    },
    CheckedByDate:{
      type: DataTypes.STRING(500),
    },
    VerifyRemark:{
      type: DataTypes.STRING(500),
    },
    AllData:{
      type: DataTypes.TEXT,
    }
  }, {
    sequelize,
    tableName: 'tbl_calibration_master_ph',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "RecNo" },
        ]
      },
    ]
  });
};
