const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('tbl_fp', {
    id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true
    },
    HMI_ip: {
      type: DataTypes.STRING(10),
      allowNull: true,
      defaultValue: "0"
    },
    IDS_ip: {
      type: DataTypes.STRING(10),
      allowNull: true,
      defaultValue: "0"
    },
    isBiometric: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    biometricMode: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "HMI",
      comment: "HMI OR IDS"
    },
    isRIMode: {
      type: DataTypes.STRING(10),
      allowNull: true,
      defaultValue: "R",
      comment: "Registration Or Iddentification"
    }
  }, {
    sequelize,
    tableName: 'tbl_fp',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id" },
        ]
      },
    ]
  });
};
