const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('tbl_ids_setting', {
    Sys_RecNo: {
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true
    },
    Sys_IDSNo: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    Sys_Meter: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    Sys_Printer: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "NA"
    },
    Sys_Port1_Type: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "None"
    },
    Sys_Port2_Type: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "None"
    },
    Sys_Port3_Type: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "None"
    },
    Sys_Port4_Type: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "None"
    },
    Sys_Port1_ID: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "None"
    },
    Sys_Port2_ID: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "None"
    },
    Sys_Port3_ID: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "None"
    },
    Sys_Port4_ID: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "None"
    },
    Sys_ISRecalib1: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Sys_ISRecalib2: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Sys_ISRecalib3: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Sys_ISRecalib4: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Sys_RecalibDate1: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    Sys_RecalibDate2: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    Sys_RecalibDate3: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    Sys_RecalibDate4: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    Sys_CalibInProcess: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Sys_WeighmentInProcess: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    locked: {
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: false
    },
    editCounter: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    Sys_Port1_unit: {
      type: DataTypes.STRING(20),
      allowNull: true,
      defaultValue: "NULL"
    },
    Sys_Port2_unit: {
      type: DataTypes.STRING(20),
      allowNull: true,
      defaultValue: "NULL"
    },
    Sys_Port3_unit: {
      type: DataTypes.STRING(20),
      allowNull: true,
      defaultValue: "NULL"
    },
    Sys_Port4_unit: {
      type: DataTypes.STRING(20),
      allowNull: true,
      defaultValue: "NULL"
    },
    Sys_HMIID: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    }
  }, {
    sequelize,
    tableName: 'tbl_ids_setting',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "Sys_RecNo" },
        ]
      },
    ]
  });
};
