const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('tbl_versionhistory', {
    id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true
    },
    A: {
      type: DataTypes.TINYINT,
      allowNull: true,
      comment: "Major"
    },
    B: {
      type: DataTypes.TINYINT,
      allowNull: true,
      comment: "Minor"
    },
    C: {
      type: DataTypes.TINYINT,
      allowNull: true,
      comment: "Build"
    },
    D: {
      type: DataTypes.SMALLINT,
      allowNull: true,
      comment: "All Bugs from client"
    },
    E: {
      type: DataTypes.SMALLINT,
      allowNull: true,
      comment: "All Bugs from tester"
    },
    F: {
      type: DataTypes.STRING(2000),
      allowNull: true,
      defaultValue: "NULL",
      comment: "Description"
    },
    DeveloperName: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "NULL"
    },
    DateTime: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: Sequelize.Sequelize.literal('CURRENT_TIMESTAMP')
    }
  }, {
    sequelize,
    tableName: 'tbl_versionhistory',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id" },
        ]
      },
    ]
  });
};
