const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('tbl_audit_conductivity_buffer', {
    RecNo: {
      autoIncrement: true,
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true
    },
    CB_dt: {
      type: DataTypes.DATEONLY,
      allowNull: false
    },
    CB_tm: {
      type: DataTypes.TIME,
      allowNull: false
    },
    CB_userid: {
      type: DataTypes.STRING(50),
      allowNull: false,
      defaultValue: "NULL"
    },
    CB_username: {
      type: DataTypes.STRING(255),
      allowNull: false,
      defaultValue: "NULL"
    },
    CB_ACT: {
      type: DataTypes.STRING(50),
      allowNull: false,
      defaultValue: "NULL"
    },
    CB_Remark: {
      type: DataTypes.STRING(300),
      allowNull: false,
      defaultValue: "NULL"
    },
    CB_oldValue: {
      type: DataTypes.STRING(1000),
      allowNull: false,
      defaultValue: "NULL"
    },
    CB_newValue: {
      type: DataTypes.STRING(1000),
      allowNull: false,
      defaultValue: "NULL"
    },
    CB_BufferName: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "NULL"
    }
  }, {
    sequelize,
    tableName: 'tbl_audit_conductivity_buffer',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "RecNo" },
        ]
      },
    ]
  });
};
