const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('tbl_meter', {
    Id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true
    },
    meter_ID: {
      type: DataTypes.STRING(50),
      allowNull: false,
      defaultValue: "NULL"
    },
    meter_Make: {
      type: DataTypes.STRING(50),
      allowNull: false,
      defaultValue: "NULL"
    },
    meter_Model: {
      type: DataTypes.STRING(50),
      allowNull: false,
      defaultValue: "NULL"
    },
    meter_SerialNo: {
      type: DataTypes.STRING(50),
      allowNull: false,
      defaultValue: "NULL"
    },
    meter_locked: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    meter_EditCounter: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    meter_isActivate: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    meter_UserID: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "NULL"
    },
    meter_IsApproved: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    meter_ApprovedBy: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "NULL"
    }
  }, {
    sequelize,
    tableName: 'tbl_meter',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "Id" },
        ]
      },
    ]
  });
};
