const Sequelize = require('sequelize');
module.exports = function (sequelize, DataTypes) {
  return sequelize.define('tbl_weighment_detail_conductivity', {
    RecNo: {
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true
    },
    RepSerNo: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    RecSeqNo: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    Modee: {
      type: DataTypes.STRING(100),
      allowNull: false,
      defaultValue: "0"
    },
    Conductivity: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    Conductance: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    Temp: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    TempCoeff: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    TempRef: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    K: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    K_Flag: {
      type: DataTypes.BOOLEAN,
      allowNull: false,
      defaultValue: true
    },
  }, {
    sequelize,
    tableName: 'tbl_weighment_detail_conductivity',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "RecNo" },
        ]
      },
    ]
  });
};
