const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('tbl_weighment_master_ph_archived', {
    RecNo: {
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true
    },
    dt: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    tm: {
      type: DataTypes.TIME,
      allowNull: true
    },
    AllData:{
      type: DataTypes.TEXT,
    },
    NegTol: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    PosTol: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    ProductName: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "NULL"
    },
    SampleID: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "NULL"
    },
    ArNo: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "NULL"
    },
    ProductType: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "NULL"
    },
    MeterID: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "NULL"
    },
    ProbID: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "NULL"
    },
    ChannelNo: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "NULL"
    },
    PrinterName: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "NULL"
    },
    UserID: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "NULL"
    },
    UserName: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "NULL"
    },
    DP: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    PrintNo: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    IDSNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    ProbType: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "pH"
    },
    ProdID: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "NULL"
    },
    archived: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    }
  }, {
    sequelize,
    tableName: 'tbl_weighment_master_ph_archived',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "RecNo" },
        ]
      },
    ]
  });
};
