const momentObj = require('moment');
const Joi = require('joi');
const clsCalibrationSchema = require('../validations/calibration.schema');

const clsCalibration = require('../model/Calibration/clsdaily.calibration');

const objCalibration = new clsCalibration();
exports.getCalibration = (req, res) => {
   
    Joi.validate(req.body, clsCalibrationSchema.ValidateGetCalibrationSchema(), (err, value) => {
        if (err) {
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail',
                message: err.details[0].message.replace(/"/g, "")
            })
            res.send(responseObj);
        } else {
            objCalibration.getcalibration(req.body).then((result) => {
                res.statusCode = 200;
                res.send(result);
               
            }).catch((err) => {
                console.log(err);
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail',
                    message: 'Internal server error'
                })
                res.send(responseObj);
            })
        }
    })

}
exports.selCalib = (req, res) => {
    let responseObj = {};
    Joi.validate(req.body, clsCalibrationSchema.ValidateSelectCalib(), (err, value) => {
        console.log(req.body);
        if (err) {
            res.statusCode = 400;
            let responseObj = {}
            Object.assign(responseObj, {
                status: 'fail',
                message: err.details[0].message.replace(/"/g, "")
            })
            res.send(responseObj);
        } else {
            objCalibration.selectPendingCalib(req.body).then((result) => {
                res.statusCode = 200;
                res.send(result);
            }).catch((err) => {
                console.log(err);
                res.statusCode = 500;
                let responseObj = {}
                Object.assign(responseObj, {
                    status: 'fail',
                    message: 'Internal server error'
                })
                res.send(responseObj);
            })
        }
    })
}