const globalData = require('../../global/globalData');
const clsActivityLog = require('../clsActivityLog.model');
const clsInstrumentUsage = require('../clsInstrumentUsageLog')
const dbCon = require('../../global/dbCon');
const MqttModel = require('../Mqtt/mqttSender.class');
const mqttSender = new MqttModel();
const mqttProtocol = require('../../global/GLOBAL_NOMENCLATURE');
const objActivityLog = new clsActivityLog();
const objclsInstrumentUsageLog = new clsInstrumentUsage();
const date = require('date-and-time');
const GLOBAL_NOMENCLATURE = require('../../global/GLOBAL_NOMENCLATURE');
const momentObj = require('moment');
const { models } = require('../../../config/dbConnection');
const { where } = require('sequelize');
const clsPrint = require('../Weighment/clsonlineprint');
const objPrint = new clsPrint();

class calibration {
    async calibPendingDecider(strCalibType, strHmi, strBalId, rasbpi) {
        try {
            var strHCCubicInfo = globalData.arrIdsInfo.find(K => K.idsNo == strHmi).cubicalData;
            var strHCSelectedChanelIDS = globalData.arrSelectedChanelIDS.find(k => k.IdsNo == strHmi);
            var strselectedInsrtumentType;
            for (let ele in strHCCubicInfo) {

                if (strHCCubicInfo[ele] == strBalId && ele.includes('ID')) {
                    strselectedInsrtumentType = ele
                    break
                }

            }
            var a = strselectedInsrtumentType.split('Port')
            var ab = (a[1].split('_'))
            var currentChannel = ab[0];
            var Type = 'Sys_Port' + currentChannel + '_Type'
            var InstrumentType = strHCCubicInfo[Type]
            if (InstrumentType == `Conductivity`) {// if user selected conductivity then send message to select buffer

                var returnProtocol = `Transfer Calibration Report From Channel-${currentChannel}`
            }
            else {
                returnProtocol = `Transfer Calibration Report From Channel-${currentChannel}`
            }
            var obj_Tol = await models.tbl_meter_weights.findAll({
                where: {
                    meterwt_ID: strHCCubicInfo.Sys_Meter,
                    meterwt_ProbID: strBalId,
                    meterwt_ProbType: strHCCubicInfo[Type]
                }
            })
            var hmiDetails = globalData.arrSelectedBalWithHmi.find(k => k.Hmi == strHmi);
            if (hmiDetails == undefined) {
                globalData.arrSelectedBalWithHmi.push({
                    "Hmi": strHmi,
                    "rasbpi": rasbpi,
                    "selectedBal": strBalId,
                    // "port": strPortNo,
                    "InstrumentType": InstrumentType,
                })
            } else {
                hmiDetails.rasbpi = strHmi;
                hmiDetails.selectedBal = strBalId;
                hmiDetails.port = currentChannel;
                hmiDetails.InstrumentType = InstrumentType;
                // var index = globalData.arrSelectedBalWithHmi.findIndex(k =>k.Hmi==idsNo);
                // globalData.arrSelectedBalWithHmi[index].rasbpi = strHmi;
                // globalData.arrSelectedBalWithHmi[index].selectedBal = SelectedinstrID;
                // globalData.arrSelectedBalWithHmi[index].InstrumentType = SelectedinstrType;
            }


            var detail_obj = {};
            var obj_API = globalData.ConductTol[0]
            if (obj_API == undefined) {
                detail_obj = {
                    Meter_ID: strHCCubicInfo.Sys_Meter,
                    Prob_ID: strHCCubicInfo[strselectedInsrtumentType],
                    Neg_Tol: Number(obj_Tol[0].meterwt_NegTol).toFixed(obj_Tol[0].meterwt_dp),
                    Pos_Tol: Number(obj_Tol[0].meterwt_PosTol).toFixed(obj_Tol[0].meterwt_dp)
                }
            } else {
                detail_obj = {
                    Meter_ID: strHCCubicInfo.Sys_Meter,
                    Prob_ID: strHCCubicInfo[strselectedInsrtumentType],
                    Neg_Tol: Number(obj_API.NegTol).toFixed(obj_Tol[0].meterwt_dp),
                    Pos_Tol: Number(obj_API.PosTol).toFixed(obj_Tol[0].meterwt_dp)
                }
            }
            globalData.ConductTol
            return { returnProtocol, obj_Detail: detail_obj };
        } catch (err) {
            throw new Error(err)
        }

    }

    async processPHCalibration(protocol) { //(IdsNo, protocol, strselectedInsrtumentType)
        try {

            var actualProtocol = protocol.str_Protocol;
            var str_pH = actualProtocol;
            var stringData = str_pH.split("\n");
            var mqtt_Port = protocol.ProtocolPortNo;
            var HCValue = actualProtocol.substring(0, 8);//starting 
            var protocolData = actualProtocol.substring(11, actualProtocol.length);//starting 
            //var ObjarrPhCalibFlag = globalData.arrPhCalibFlag.find(k => k.IdsNo == IdsNo);
            var IdsNo = protocol.strHmi;
            var strBalId = protocol.instrumentId;
            var obj = {}
            var flag = 0
            var objarrPHCalibData = globalData.arrPHCalibData.find(k => k.IdsNo == IdsNo);

            const tempCubicInfo = globalData.arrIdsInfo.find(k => k.idsNo == IdsNo);
            var objarrSelectedChanelIDS = globalData.arrSelectedChanelIDS.find(k => k.IdsNo == parseInt(IdsNo));
            var strselectedInsrtumentType;
            for (let ele in tempCubicInfo.cubicalData) {

                if (tempCubicInfo.cubicalData[ele] == strBalId && ele.includes('ID')) {
                    strselectedInsrtumentType = ele
                    break
                }

            }
            var a = strselectedInsrtumentType.split('Port')
            var ab = (a[1].split('_'))
            var currentChannel = ab[0];
            var strBal = tempCubicInfo.cubicalData[`Sys_Meter`]
            var ProbType = tempCubicInfo.cubicalData[`Sys_Port${currentChannel}_Type`]
            //if pHinISEflg is true probID will be selected by the id present in string so that tolerance value can be set of Ph instead of ph/ise
            if (globalData.arrISECalibData[0].pHinISEflg == true) {
                var selectph = await models.tbl_meter_weights.findAll({
                    meterwt_ProbType: 'pH',
                    meterwt_ID: strBalId
                })

                var objselectrange = selectph
                var ProbID = objselectrange[0].meterwt_ProbID
            }
            else {
                var ProbID = tempCubicInfo.cubicalData[`Sys_Port${currentChannel}_ID`]
            }
            var objActivity = {};

            await objclsInstrumentUsageLog.InstrumentUsage(strBalId, ProbType, IdsNo, 'pH Calibration', 1)
            await this.ActivityLog(IdsNo, "Calibration Started");
            // if (HCValue == "ComRead:") {
            var obj = {}
            var arr = [];
            var Slope_arr = [];
            var E_arr = [];
            for (var i = 0; i < stringData.length; i++) {
                // if (stringData[i].includes('Channel') == true) {
                var strChannelFromString = []

                // for (var j = 0; j < stringData.length; j++) { //logic TSH
                if (stringData[i].includes("Channel")) {
                    var slope_1 = stringData[i].replace('Channel', ' ').trim().split(' ');
                    slope_1 = slope_1[0]
                    obj[`Channel`] = slope_1;
                    if (currentChannel != slope_1) {  // channel validation
                        var strActivity = `Data Received from Channel ${slope_1} Instead of Channel ${currentChannel}`
                        var strResult = await this.ActivityLog(IdsNo, strActivity)
                        return mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage} ${strActivity}`);
                    }
                    // if (mqtt_Port != slope_1) {
                    //     var strActivity = `Data Received from Port ${mqtt_Port} Instead of Port ${slope_1}`
                    //     var strResult = await this.ActivityLog(IdsNo, strActivity)
                    //     mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage} ${strActivity}`);
                    //     return mqttSender.sendData(IdsNo, strActivity);
                    // }

                    // strChannelFromString.push({ "Channel": currentChannel });
                }
                //Time Validations
                if (actualProtocol.search('Time') == -1) {
                    return mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}Invalid String`);
                }
                if (actualProtocol.search('Operator') == -1 || actualProtocol.search('Signature') == -1) {
                    return mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}Invalid String`);
                }

                if (stringData[i].includes('Time')) {
                    var Time = stringData[i].replace(/[ ]{1,}/g, " ").split(" ").splice(1).join(" ");;
                    Time = Time.split('Time')[1]
                    obj[`Time`] = Time;
                    var valid = await this.PHDateValidator(Time);
                    if (valid == false) {
                        return mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}Invalid String`);

                    }
                }
                // }
                // }
                // if(currentChannel!=){}
                if (stringData[i].includes("pH")) {
                    flag = 1
                    if (flag == 1) {

                        // *************CONCENTRATION*************//
                        // if (stringData[i].includes("pH")) {
                        if (stringData[i].includes("-- pH Calibration Report --")) {
                            var pH = stringData[i].replace('-- pH Calibration Report --', ' ').trim();
                            // console.log (pH);
                        } else {
                            // console.log(str_1[i].replace('Point', ' ').trim().split(' '));
                            let b = stringData[i].replace('pH', ' ').trim().split(' ');
                            b = b[0]
                            // arr.push(a);
                            if (isNaN(parseInt(b)) == true) {
                                return mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}Invalid String`);
                            }
                            obj["pH"] = b;
                            // objarrPHCalibData.arrPHvalues.push(obj)
                            // objarrPHCalibData.PHflag = false
                            // console.log(arr);
                        }
                        // }
                    }
                }
                if (stringData[i].includes("Point")) {
                    // console.log(str_1[i].replace('Point', ' ').trim().split(' '));
                    var P_val = stringData[i].replace('Point', ' ').trim().split(' ');
                    P_val = P_val
                    // arr.push(a);
                    // console.log("Point",a)
                    if (isNaN(parseInt(P_val[0])) == true) {
                        return mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj[`Point_${P_val}`] = P_val[0];
                    arr.push(obj);

                    // console.log(arr);
                }
                // }

                if (stringData[i].includes("Concentration")) {
                    let b = stringData[i].replace('Concentration', ' ').trim().split();
                    b = b[0]
                    if (isNaN(parseInt(b)) == true) {
                        return mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    // arr.push(a);
                    obj[`Concentration_${P_val}`] = b;
                    // console.log (pH);

                }
                // // *************mV*************//
                if (stringData[i].includes("mV") && !stringData[i].includes('Average Slope') && !stringData[i].includes('Slope') && !stringData[i].includes('Eo')) {
                    // console.log(str_1[i].replace('Point', ' ').trim().split(' '));
                    for (var l = 0; l < stringData.length; l++) { //logic TSH
                        if (stringData[l].includes('mV')) {
                            // var mV_1 = stringData[i].replace('mV', ' ').trim().split();
                            // mV_1 = mV_1
                            // strChannelFromString.push({ "Channel": 1 });
                            var mV_1 = stringData[i].replace(/[ ]{1,}/g, " ").split(" ").splice(1).join(" ");
                            if (isNaN(parseInt(mV_1)) == true) {
                                return mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}Invalid String`);
                            }
                            obj[`mV_${P_val}`] = mV_1
                        }
                    }


                }


                // // *************Temperature*************//
                if (stringData[i].includes("Temperature")) {
                    // console.log(str_1[i].replace('Point', ' ').trim().split(' '));
                    let d = stringData[i].replace('Temperature', ' ').trim().split();
                    d = d[0]
                    // arr.push(a);
                    if (isNaN(parseInt(d)) == true) {
                        return mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj[`Temperature_${P_val}`] = d;
                    // console.log(arr);

                }


                if (stringData[i].includes("Calibration Type")) {
                    let CT = stringData[i].replace('Calibration Type', ' ').trim().split(' ');
                    CT = CT[0]
                    if (CT == 'Auto' || CT == 'Manual') {
                        obj[`Calibration_Type_${P_val}`] = CT;
                    } else {
                        return mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                }

                //**********SLOPE 1 **** *****/
                if (stringData[i].includes('Slope')) {

                    if (stringData[i].includes('Average Slope')) {
                        let avg = stringData[i].replace('Average Slope', ' ').trim().split();
                        avg = avg[0]
                        // arr.push(a);
                        if (isNaN(parseFloat(avg)) == true) {
                            return mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}Invalid String`);
                        }
                        obj["Average_Slope"] = avg;
                        objarrPHCalibData.arrSlope.push(obj)
                        objarrPHCalibData.strAvgslope.push(obj)
                    } else {
                        // if (stringData[k].includes('Slope')) {
                        var slope_1 = stringData[i].replace('Slope', ' ').trim().split(' ');
                        slope_1 = slope_1[0]
                        if (isNaN(parseFloat(slope_1)) == true) {
                            return mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}Invalid String`);
                        }
                        // strChannelFromString.push({ "Channel": 1 });
                        var unit_check = stringData[i].replace(/[ ]{1,}/g, " ").split(" ").splice(2).join(" ");
                        if (unit_check.includes('%') == false) {
                            console.log('Unit not reveived');
                            return mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}Invalid String`);
                        }
                        obj[`Slope_${slope_1}`] = stringData[i].replace(/[ ]{1,}/g, " ").split(" ").splice(2).join(" ");
                        Slope_arr.push([`Slope_${slope_1}`]);
                    }
                }

                //**********Eo 1 **** *****/
                if (stringData[i].includes('Eo')) {

                    // for (var k = 0; k < stringData.length; k++) { //logic TSH
                    //     if (stringData[k].includes('Eo')) {
                    var slope_1 = stringData[i].replace('Eo', ' ').trim().split(' ');
                    slope_1 = slope_1[0]
                    if (isNaN(parseFloat(slope_1)) == true) {
                        return mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    // strChannelFromString.push({ "Channel": 1 });
                    var slop_unit = stringData[i].replace(/[ ]{1,}/g, " ").split(" ").splice(2).join(" ");
                    if (slop_unit.includes('mV') == false) {
                        console.log('Unit not reveived');
                        return mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj[`Eo_${slope_1}`] = stringData[i].replace(/[ ]{1,}/g, " ").split(" ").splice(2).join(" ");
                    E_arr.push([`Eo_${slope_1}`]);
                }

                //**********Average Slope **** *****/
                // if (stringData[i].includes('Average Slope')) {

                //     let avg = stringData[i].replace('Average Slope', ' ').trim().split();
                //     avg = avg[0]
                //     // arr.push(a);
                //     obj["Average_Slope"] = avg;
                //     objarrPHCalibData.arrSlope.push(obj)
                //     objarrPHCalibData.strAvgslope.push(obj)

                // }

                //**********Blank**** *****/
                if (stringData[i].includes('Blank')) {
                    // console.log(str_1[i].replace('Point', ' ').trim().split(' '));
                    let blank = stringData[i].replace('Blank', ' ').trim().split();
                    blank = blank[0]
                    // arr.push(a);
                    if (isNaN(parseFloat(blank)) == true) {
                        return mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["Blank"] = blank;
                    // arr.push(obj);
                    // console.log(obj);
                }

                //**********Cal #*********//
                if (stringData[i].includes('Cal #')) {
                    // console.log(str_1[i].replace('Point', ' ').trim().split(' '));
                    let cal = stringData[i].replace('Cal #', ' ').trim().split(' ');
                    cal = cal[0]
                    // arr.push(a);
                    obj["Cal #"] = cal;
                    arr.push(obj);
                }
            }
            console.log(obj);
            // }
            console.log(obj);
            //validation for Slope,E0,AVG_SLOP..Start27/06/23
            if (Slope_arr.length != 0) {
                for (var SL = 1; SL <= Slope_arr.length; SL++) {
                    if (Slope_arr[SL - 1].includes('Slope_' + SL)) {
                        console.log(`Slope_${SL} found`);
                    } else {
                        console.log(`Slope_${SL} not found`);
                        return mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}Invalid String`);

                    }

                }
            }
            if (E_arr.length != 0) {
                for (var E_val = 1; E_val <= E_arr.length; E_val++) {
                    if (E_arr[E_val - 1].includes('Eo_' + E_val)) {
                        console.log(`Eo_${E_val} found`);
                    } else {
                        console.log(`Eo_${E_val} not found`);
                        return mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}Invalid String`);

                    }

                }
            }
            var AVG_Slope = [];
            AVG_Slope.push(obj);
            var AVG = AVG_Slope.find(k => { return (k.hasOwnProperty('Average_Slope')) });
            if (AVG == undefined) {
                return mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}Invalid String`);
            }
            //END
            //Compaire
            if (objarrPHCalibData.strAvgslope == null || objarrPHCalibData.strAvgslope == '' || objarrPHCalibData.arrSlope.length == 0) {
                var strActivity = `Invalid Data`
                var strResult = await this.ActivityLog(IdsNo, strActivity)
                return strActivity
            }
            var objselectrange = await models.tbl_meter_weights.findAll({
                where: {
                    meterwt_ProbID: ProbID,
                    meterwt_ID: strBal
                }
            })

            if (ProbType == 'pH') {
                var tbl_Name = `tbl_calibration_master_ph`
            } else {
                var tbl_Name = `tbl_calibration_master_ph_ise`
            }

            if (objselectrange.length > 0) {
                var strSlopval;
                var flgOutOfLimit = false;


                let a = 1
                for (const [i, slopeVal] of objarrPHCalibData.arrSlope.entries()) {
                    for (let ele in slopeVal) {
                        if (ele.includes(`Slope_${a}`)) {
                            strSlopval = ele
                            break

                        }


                        if (objarrPHCalibData.arrSlope[0][`Slope_${a}`] != undefined) {
                            if (parseFloat(objarrPHCalibData.arrSlope[0][`Slope_${a}`]) >= objselectrange[0].meterwt_NegTol &&
                                parseFloat(objarrPHCalibData.arrSlope[0][`Slope_${a}`]) <= objselectrange[0].meterwt_PosTol) {
                                flgOutOfLimit == false ? flgOutOfLimit = false : flgOutOfLimit = true;
                            }
                            else {
                                flgOutOfLimit = true;
                            }
                        }
                        a++
                    }
                }

                if (parseFloat(obj.Average_Slope) >= objselectrange[0].meterwt_NegTol &&
                    parseFloat(obj.Average_Slope) <= objselectrange[0].meterwt_PosTol && flgOutOfLimit == false) {
                    var result = await this.SavePHcalidDataWithSlope('Pass', objarrPHCalibData, IdsNo, strBalId, objselectrange[0].meterwt_NegTol, objselectrange[0].meterwt_PosTol)
                    var object = await objclsInstrumentUsageLog.InstrumentUsage(strBalId, ProbType, IdsNo, 'pH Calibration', 0)
                    await this.ActivityLog(IdsNo, "Calibration Completed")
                    console.log("Calibration Successful")
                    mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}Calibration Successful`);
                    mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayResult}${JSON.stringify(obj)}`);
                    return;

                } else {
                    var result = await this.SavePHcalidDataWithSlope('Fail', objarrPHCalibData, IdsNo, strBalId, objselectrange[0].meterwt_NegTol, objselectrange[0].meterwt_PosTol)
                    var object = await objclsInstrumentUsageLog.InstrumentUsage(strBalId, ProbType, ProbID, IdsNo, 'pH Calibration', 0)
                    await this.ActivityLog(IdsNo, "Calibration Completed")
                    console.log("Calibration Failed")
                    mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}Calibration Failed`);
                    mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayResult}${JSON.stringify(obj)}`)
                    return;
                }

            }
            else {
                return mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}Invalid String`);
            }

        } catch (err) {
            console.log(err)
            throw new Error(err)
        }

    }

    async ActivityLog(idsNo, Activity) {
        var objUserInfo = globalData.arrUsers.find(k => k.Hmi == idsNo);
        var objActivity = {};
        Object.assign(objActivity,
            { strUserId: objUserInfo.UserId },
            { strUserName: objUserInfo.UserName },
            { activity: Activity })
        await objActivityLog.ActivityLogEntry(objActivity)
    }

    //stored PH CALIBRATION Data with Slope
    async SavePHcalidDataWithSlope(result, ObjCalibration, IdsNo, strBalId, SlopeMin, SlopeMax, BufferStdValue = '',
        BufferNegTol = '', BufferPosTol = '', SelectedBuffer, buffNeg, buffPos) {
        try {
            var strDbResult = ''
            var strSql = ''
            // var ChannelNo = ''
            const tempUserObject = globalData.arrUsers.find(k => k.Hmi == IdsNo);
            var objarrSelectedChanelIDS = globalData.arrSelectedChanelIDS.find(k => k.IdsNo == IdsNo);
            var tempCubicInfo = globalData.arrIdsInfo.find(k => k.idsNo == IdsNo).cubicalData;
            var Channel = ObjCalibration.strAvgslope[0].Channel;
            var objLastInsertedRepserNo = globalData.LastInsertedRepserNo.find(k => k.idsNo == IdsNo);
            var strPrintingMode = globalData.arrsAllParameters[0].tbl_PrintingMode == 'NULL' ? 'Auto' : globalData.arrsAllParameters[0].tbl_PrintingMode
            var data = ObjCalibration.strAvgslope[0];
            for (let ele in tempCubicInfo) {

                if (tempCubicInfo[ele] == strBalId && ele.includes('ID')) {
                    Channel = ele
                    break
                }

            }
            var a = Channel.split('Port')
            var ab = (a[1].split('_'))
            var currentChannel = ab[0];
            var objarrSelectedChanelIDS = globalData.arrSelectedChanelIDS.find(k => k.IdsNo == parseInt(IdsNo));
            if (objarrSelectedChanelIDS != undefined) {
                globalData.arrSelectedChanelIDS.splice(globalData.arrSelectedChanelIDS.findIndex((element) => element.Hmi == IdsNo), 1);
            }
            globalData.arrSelectedChanelIDS.push({ IdsNo: IdsNo, selectedChannelIDS: [], currentChannel: currentChannel })
            var strProbeType = tempCubicInfo[`Sys_Port${currentChannel}_Type`]
            var strProbeID = tempCubicInfo[`Sys_Port${currentChannel}_ID`]
            var strBalId = tempCubicInfo[`Sys_Meter`]
            // NEED TO ADD BalanceRecalibStatusObject
            var now = new Date();
            var objselectrange = await models.tbl_meter_weights.findAll({
                where: {
                    meterwt_ProbID: strProbeID,
                    meterwt_ID: strBalId
                }
            })
            var unit = objselectrange[0].meterwt_unit;



            if (strProbeType == 'pH') {
                var masterData = await models.tbl_calibration_master_ph.create({
                    PrDate: date.format(now, 'YYYY-MM-DD'),
                    PrTime: date.format(now, 'HH:mm:ss'),
                    UserID: tempUserObject.UserId,
                    UserName: tempUserObject.UserName,
                    PrintNo: 0,
                    MeterID: strBalId,
                    IDSNo: IdsNo,
                    ChannelNo: currentChannel,
                    ProbID: strProbeID,
                    Remark: result,
                    CalibType: ObjCalibration.Calibration_Type_1,
                    NegTol: `${parseFloat(SlopeMin).toFixed(0)}` + unit,
                    PosTol: `${parseFloat(SlopeMax).toFixed(0)}` + unit,
                    AvgSlope: ObjCalibration.strAvgslope[0].Average_Slope,

                })

            }


            if (strProbeType == 'pH/ISE') {
                if (data["Blank"] != undefined) {
                    var masterData = await models.tbl_calibration_master_ph_ise.create({
                        PrDate: momentObj().format('YYYY-MM-DD'),
                        PrTime: momentObj().format('HH:mm:ss'),
                        UserID: tempUserObject.UserId,
                        UserName: tempUserObject.UserName,
                        PrintNo: 0,
                        MeterID: strBalId,
                        IDSNo: IdsNo,
                        ChannelNo: currentChannel,
                        ProbID: strProbeID,
                        Remark: result,
                        Blank: ObjCalibration.strAvgslope[0].Blank,
                        CalibType: ObjCalibration.strAvgslope[0].Calibration_Type,
                        NegTol: `${parseFloat(SlopeMin).toFixed(0)}` + unit,
                        PosTol: `${parseFloat(SlopeMax).toFixed(0)}` + unit,
                        AvgSlope: ObjCalibration.strAvgslope[0].Average_Slope,

                    })
                } else {
                    var masterData = await models.tbl_calibration_master_ph.create({
                        PrDate: date.format(now, 'YYYY-MM-DD'),
                        PrTime: date.format(now, 'HH:mm:ss'),
                        UserID: tempUserObject.UserId,
                        UserName: tempUserObject.UserName,
                        PrintNo: 0,
                        MeterID: strBalId,
                        IDSNo: IdsNo,
                        ChannelNo: currentChannel,
                        ProbID: strProbeID,
                        Remark: result,
                        CalibType: ObjCalibration.Calibration_Type_1,
                        NegTol: `${parseFloat(SlopeMin).toFixed(0)}` + unit,
                        PosTol: `${parseFloat(SlopeMax).toFixed(0)}` + unit,
                        AvgSlope: ObjCalibration.strAvgslope[0].Average_Slope,

                    })
                    globalData.arrISEMeter.pHwtinISEflg = true;
                }
            }
            var lastInsertedID = masterData.RecNo;
            if (objLastInsertedRepserNo == undefined) {
                globalData.LastInsertedRepserNo.push({
                    IdsNo: IdsNo,
                    LastInsertedRepserNo: lastInsertedID
                })

            }
            else {
                objLastInsertedRepserNo.LastInsertedRepserNo = lastInsertedID
            }
            //Inserting Slope Values 
            var i = 0;
            var arrCalibValues = [];
            arrCalibValues.push(ObjCalibration);
            // var globalData.arrCalibValues.find(k => k.Hmi == IdsNo);

            // for (var calibVal of ObjCalibration.arrSlope) {
            //     await models.tbl_calibration_detail_ph.create({
            //         RepSerNo: lastInsertedID,
            //         RecSeqNo: i + 1,
            //         Slope: ObjCalibration.arrSlope[0][`Slope${i + 1}`],
            //         Eo: ObjCalibration.arrSlope[0][`Eo${i + 1}`]

            //     })
            //     i = i + 1;
            // }

            var a = 1;

            if (strProbeType == GLOBAL_NOMENCLATURE.ph) {
                for (let ele in arrCalibValues[0].arrSlope[0]) {
                    if (ele.includes('Eo')) {

                        await models.tbl_calibration_detail_ph.create({
                            RepSerNo: lastInsertedID,
                            RecSeqNo: a,
                            Slope: arrCalibValues[0].arrSlope[0][`Slope_${a}`],
                            Eo: arrCalibValues[0].arrSlope[0][`Eo_${a}`]
                        })
                        a++
                    }
                }
            }

            if (strProbeType == GLOBAL_NOMENCLATURE.ISE) {
                if (data['Blank'] != undefined) {
                    for (var calibVal in arrCalibValues[0].arrSlope[0]) {
                        if (calibVal.includes('mV_')) {
                            const insertDetailObj = await models.tbl_calibration_detail_ph_ise.create({
                                RepSerNo: lastInsertedID,
                                RecSeqNo: a,
                                Concentration: arrCalibValues[0].arrSlope[0][`Concentration_${a}`],
                                mVValue: arrCalibValues[0].arrSlope[0][`mV_${a}`],
                                Temp: arrCalibValues[0].arrSlope[0][`Temperature_${a}`],
                                Slope: arrCalibValues[0].arrSlope[0][`Slope_${a}`] == undefined || 0 ? null : arrCalibValues[0].arrSlope[0][`Slope_${a}`],
                                Eo: arrCalibValues[0].arrSlope[0][`Eo_${a}`] == undefined || 0 ? null : arrCalibValues[0].arrSlope[0][`Eo_${a}`]
                            })
                            a++
                        }
                    }
                } else {
                    for (let ele in arrCalibValues[0].arrSlope[0]) {
                        if (ele.includes('Eo')) {

                            await models.tbl_calibration_detail_ph.create({
                                RepSerNo: lastInsertedID,
                                RecSeqNo: a,
                                Slope: arrCalibValues[0].arrSlope[0][`Slope_${a}`],
                                Eo: arrCalibValues[0].arrSlope[0][`Eo_${a}`]
                            })
                            a++
                        }
                    }

                }

                // i = i + 1;
            }


            if (result == 'Pass') {
                strSql = await models.tbl_ids_setting.update({
                    [`Sys_ISRecalib${currentChannel}`]: 0
                }, { where: { Sys_IDSNo: IdsNo } })
                // strSql = `update tbl_ids_setting set Sys_ISRecalib${objarrSelectedChanelIDS.currentChannel}=0 where Sys_IDSNo=${IdsNo}`
                // strDbResult = await Database.execute(strSql)
                tempCubicInfo[`Sys_ISRecalib${currentChannel}`] = 0//reseing Recalibration flag in tbl_ids_setting array
            }
            //******************************************************************* */
            //to release ids from calibration***************************************/
            strSql = await models.tbl_ids_setting.update({
                Sys_CalibInProcess: 0
            }, { where: { Sys_IDSNo: IdsNo } })
            //**************************************************************************/
            arrCalibValues.splice(arrCalibValues.findIndex((element) => element.IdsNo == IdsNo), 0)
            globalData.arrPHCalibData.splice(globalData.arrPHCalibData.findIndex((element) => element.Hmi == IdsNo), 1);
            //Autoprint
            // if (strPrintingMode == 'Auto') {
            //     var Print_Protocol = await objPrint.AutoPrint(IdsNo, "Calibration");

            //     if (Print_Protocol == undefined) {
            //         Print_Protocol = 'Report Generated';
            //         console.log('ProcessPhMeter where print mode is auto')
            //     }
            //     return Print_Protocol;
            // }
            // else {
            //     return Print_Protocol;
            // }
            // if (ObjCalibration != undefined) {
            //     ObjCalibration.arrPHvalues = [];
            //     ObjCalibration.arrSlope = [];
            //     ObjCalibration.strAvgslope = [];
            // }
            return

        }
        catch (error) {
            console.log('error from SavePHcalidData : ' + error)
            throw new Error(error)
        }

    }

    //Conductivity Calibration
    async processConductivityCalibration(protocol) {
        try {
            var actualProtocol = protocol.str_Protocol;
            var str_pH = actualProtocol;
            var mqtt_Port = protocol.ProtocolPortNo;
            var stringData = str_pH.split("\n");
            var HCValue = actualProtocol.substring(0, 8);//starting 
            var protocolData = actualProtocol.substring(11, actualProtocol.length);//starting 
            //var ObjarrPhCalibFlag = globalData.arrPhCalibFlag.find(k => k.IdsNo == IdsNo);
            var IdsNo = protocol.strHmi;
            var strBalId = protocol.instrumentId;
            var obj = {}
            var flag = 0
            var objarrCondCalibData = globalData.arrConductivityWdata.find(k => k.idsNo == IdsNo);
            const tempCubicInfo = globalData.arrIdsInfo.find(k => k.idsNo == IdsNo);
            var objarrSelectedChanelIDS = globalData.arrSelectedChanelIDS.find(k => k.IdsNo == parseInt(IdsNo));
            var strselectedInsrtumentType;
            for (let ele in tempCubicInfo.cubicalData) {

                if (tempCubicInfo.cubicalData[ele] == strBalId && ele.includes('ID')) {
                    strselectedInsrtumentType = ele
                    break
                }

            }
            var a = strselectedInsrtumentType.split('Port')
            var ab = (a[1].split('_'))
            var currentChannel = ab[0];
            var strBal = tempCubicInfo.cubicalData[`Sys_Meter`]
            var ProbType = tempCubicInfo.cubicalData[`Sys_Port${currentChannel}_Type`]


            // if (HCValue == "ComRead:") {
            await objclsInstrumentUsageLog.InstrumentUsage(strBalId, ProbType, IdsNo, 'Conductvity Calibration', 1);
            await this.ActivityLog(IdsNo, "Calibration Started")
            var obj = {}
            var arr = [];
            for (var i = 0; i < stringData.length; i++) {
                //Channel
                if (stringData[i].includes('Channel') == true) {

                    var strChannelFromString = []
                    for (var j = 0; j < stringData.length; j++) { //logic TSH
                        if (stringData[j].includes("Channel")) {
                            var slope_1 = stringData[i].replace('Channel', ' ').trim().split(' ');
                            slope_1 = slope_1[0]
                            obj[`Channel`] = slope_1;
                            if (currentChannel != slope_1) {  // channel validation
                                var strActivity = `Data Received from Channel ${slope_1} Instead of Channel ${currentChannel}`
                                var strResult = await this.ActivityLog(IdsNo, strActivity)
                                return mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage} ${strActivity}`);
                            }
                            // if (mqtt_Port != slope_1) {
                            //     var strActivity = `Data Received from Port ${mqtt_Port} Instead of Port ${slope_1}`
                            //     var strResult = await this.ActivityLog(IdsNo, strActivity)
                            //     mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage} ${strActivity}`);
                            //     return mqttSender.sendData(IdsNo, strActivity);
                            // }

                        }
                    }


                }

                //Time Validations
                if (actualProtocol.search('Time') == -1) {
                    return mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}Invalid String`);
                }
                if (actualProtocol.search('Operator') == -1 || actualProtocol.search('Signature') == -1) {
                    return mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}Invalid String`);
                }
                if (stringData[i].includes('Time')) {
                    var Time = stringData[i].replace(/[ ]{1,}/g, " ").split(" ").splice(1).join(" ");;
                    Time = Time.split('Time')[1]
                    obj[`Time`] = Time;
                    var valid = await this.PHDateValidator(Time);
                    if (valid == false) {
                        return mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}Invalid String`);

                    }
                }
                //Point
                if (stringData[i].includes('Point') == true) {
                    // var Data =[];
                    // // var P_val = stringData[i].replace('Point', ' ').trim()
                    objarrCondCalibData.dataFlag = true;
                }
                if (objarrCondCalibData.dataFlag == true) {
                    var strConvalue, strConductance, strTemp, CType;
                    //Conductivity
                    for (var j = 0; j < stringData.length; j++) {
                        //Point
                        if (stringData[j].includes('Point') == true) {
                            var P_val = stringData[j].replace('Point', ' ').trim()
                            if (isNaN(parseInt(P_val)) == true) {
                                return mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}Invalid String`);
                            }
                            obj[`Point_${P_val}`] = P_val;
                            // arr.push(obj);
                            objarrCondCalibData.dataFlag = true;
                        }
                        if (stringData[j].includes('Conductivity')) {
                            let d = stringData[j].replace('Conductivity', ' ').trim();
                            // d = d
                            if (isNaN(parseInt(d)) == true) {
                                return mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}Invalid String`);
                            }
                            if (d.includes('uS/cm') == false) {
                                console.log('Unit not reveived');
                                return mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}Invalid String`);
                            }
                            obj[`Conductivity_${P_val}`] = d;
                            // objarrCondCalibData.arrConductivity.Conductivity = obj.Conductivity
                            // var Data = [];
                            // var obj['Conductivity'] = d 

                            objarrCondCalibData.arrConductivity = obj;


                        }
                        if (stringData[j].includes('Conductance')) {
                            let con = stringData[j].replace('Conductance', ' ').trim();
                            if (isNaN(parseInt(con)) == true) {
                                return mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}Invalid String`);
                            }
                            if (con.includes('uS') == false) {
                                console.log('Unit not reveived');
                                return mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}Invalid String`);
                            }
                            obj[`Conductance_${P_val}`] = con;
                            // objarrCondCalibData.arrConductance = obj.Conductance
                            // var obj = { 'Conductance': con }
                            objarrCondCalibData.arrConductance = con;

                        }
                        if (stringData[j].includes('Temperature')) {
                            let Temp = stringData[j].replace('Temperature', ' ').trim().split(" ")[0];
                            if (isNaN(parseInt(Temp)) == true) {
                                return mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}Invalid String`);
                            }
                            Temp = stringData[j].replace('Temperature', ' ').trim()
                            if (Temp.includes('C (ATC)') == false) {
                                console.log('Unit not reveived');
                                return mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}Invalid String`);
                            }
                            obj[`Temperature_${P_val}`] = Temp;
                            // objarrCondCalibData.arrTemp = obj.Temperature
                            // var obj = { 'Temperature': Temp }
                            objarrCondCalibData.arrTem = Temp;

                        }
                        if (stringData[j].includes('Calibration Type')) {
                            var Cal_Type = stringData[j].replace('Calibration Type', ' ').trim();
                            // Cal_Type = Cal_Type
                            if (Cal_Type == 'Auto' || Cal_Type == 'Manual') {
                                obj[`Calibration_Type_${P_val}`] = Cal_Type;
                            } else {
                                return mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}Invalid String`);
                            }

                            objarrCondCalibData.arrCalibType = Cal_Type
                            objarrCondCalibData.dataFlag = false;
                        }
                        // console.log(obj)
                    }
                    console.log(obj)
                }
                if (stringData[i].includes('Average.K')) {
                    // var strAK = actualProtocol.substring(5, actualProtocol.length - 2).trim();
                    // strAK = `${strAK.split(' ')[strAK.split(' ').length - 2]} ${strAK.split(' ')[strAK.split(' ').length - 1]}`
                    // objarrCondCalibData.arrAvgK.push(strAK);
                    if (stringData[i].includes('Average.K')) {
                        var strAK = stringData[i].replace('Average.K', ' ').trim().split(" ")[0];
                        if (isNaN(parseInt(strAK)) == true) {
                            return mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}Invalid String`);
                        }
                        strAK = stringData[i].replace('Average.K', ' ').trim()
                        // var AVG_unit = stringData[i].replace('Average.K', ' ').trim()
                        if (strAK.includes('/cm') == false) {
                            console.log('Unit not reveived');
                            return mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}Invalid String`);
                        }
                        obj["Average.K"] = strAK;
                        objarrCondCalibData.arrAvgK = strAK;
                    }
                }
                //         //**********K **** *****/
                if (stringData[i].includes('K ') && !stringData[i].includes('Average.K')) {
                    var k_stored = [];
                    for (var d = 0; d < stringData.length; d++) { //logic TSH
                        if (stringData[d].includes('K ') && !stringData[d].includes('Average.K')) {
                            var strK = stringData[d].replace('K ', ' ').trim().split(' ');
                            strK = strK[0];
                            if (isNaN(parseInt(strK)) == true) {
                                return mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}Invalid String`);
                            }
                            // strChannelFromString.push({ "Channel": 1 });
                            var K_unit = stringData[d].replace(/[ ]{1,}/g, " ").split(" ").splice(2).join(" ");
                            if (K_unit.includes('/cm') == false) {
                                console.log('Unit not reveived');
                                return mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}Invalid String`);
                            }
                            obj[`k${strK}`] = stringData[d].replace(/[ ]{1,}/g, " ").split(" ").splice(2).join(" ");
                            k_stored.push([`k${strK}`])
                            objarrCondCalibData.arrK = [`k${strK}`];
                        }

                    }
                }
                //**********'Offset**** *****/
                if (stringData[i].includes('Offset')) {
                    var offset_stored = [];
                    for (var f = 0; f < stringData.length; f++) { //logic TSH
                        if (stringData[f].includes('Offset')) {
                            var offset = stringData[f].replace('Offset', ' ').trim().split(' ');
                            offset = offset[0];
                            if (isNaN(parseInt(offset)) == true) {
                                return mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}Invalid String`);
                            }
                            // strChannelFromString.push({ "Channel": 1 });
                            var off_unit = stringData[f].replace(/[ ]{1,}/g, " ").split(" ").splice(2).join(" ");
                            if (off_unit.includes('uS/cm') == false) {
                                console.log('Unit not reveived');
                                return mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}Invalid String`);
                            }
                            obj[`Offset_${offset}`] = stringData[f].replace(/[ ]{1,}/g, " ").split(" ").splice(2).join(" ");
                            offset_stored.push([`Offset_${offset}`]);
                            objarrCondCalibData.arrOffset = [`Offset ${offset}`];
                        }
                    }
                }

            }
            //validation for k1....23/06/23 s
            if (k_stored.length != 0) {
                for (var ad = 1; ad <= k_stored.length; ad++) {

                    if (k_stored[ad - 1].includes('k' + ad)) {
                        console.log(`K${ad} found`);
                    } else {
                        console.log(`K${ad} not found`);
                        return mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}Invalid String`);

                    }

                }
            }
            if (offset_stored.length != 0) {
                for (var abc = 1; abc <= offset_stored.length; abc++) {

                    if (offset_stored[abc - 1].includes('Offset_' + abc)) {
                        console.log(`Offset_${abc} found`);
                    } else {
                        console.log(`Offset_${abc} not found`);
                        return mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}Invalid String`);

                    }

                }
            }

            var AVG_K = [];
            AVG_K.push(obj);
            var AVG = AVG_K.find(k => { return (k.hasOwnProperty('Average.K')) })
            if (AVG == undefined) {
                return mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}Invalid String`);
            }
            //END
            if (objarrCondCalibData == undefined) {
                let strActivity = `Invalid Data`
                let strResult = await this.ActivityLog(IdsNo, strActivity)
                return strActivity
            }
            var selectrange = await models.tbl_meter_weights.findAll({
                where: {
                    meterwt_ID: strBal,
                    meterwt_ProbID: strBalId,
                    meterwt_ProbType: ProbType,
                    meterwt_ChannelNo: currentChannel
                }
            })
            var objConductivityTolCalib = globalData.arrTolForConductivityCalib.find(k => k.idsNo == IdsNo);
            var strUpperLimit = objConductivityTolCalib.posTol;//Math.abs(this.FormatNumberString((((strStdValue * strPosTol) / 100) + strStdValue), strDP));
            var strLowerLimit = objConductivityTolCalib.negTol;//Math.abs(this.FormatNumberString((((strStdValue * strNegTol) / 100) - strStdValue), strDP));
            // var arrConductivityVal = parseFloat(objarrCondCalibData.arrConductivity.split(' '));
            var calibResult = 'Pass';
            var strConductval;
            var flgOutOfLimit = false;
            //for multipal Conductivity Compair
            //25/11/22 S
            objarrCondCalibData.arrConductivity = [objarrCondCalibData.arrConductivity]
            var c = 1;
            for (const [i, slopeVal] of objarrCondCalibData.arrConductivity.entries()) {
                for (let ele in slopeVal) {
                    if (ele.includes(`Conductivity_${c}`)) {
                        strConductval = ele
                        break

                    }

                    if (objarrCondCalibData.arrConductivity[0][`Conductivity_${c}`] != undefined) {
                        if (parseFloat(objarrCondCalibData.arrConductivity[0][`Conductivity_${c}`]) >= strLowerLimit &&
                            parseFloat(objarrCondCalibData.arrConductivity[0][`Conductivity_${c}`]) <= strUpperLimit) {
                            flgOutOfLimit == false ? flgOutOfLimit = false : flgOutOfLimit = true;
                        }
                        else {
                            flgOutOfLimit = true;
                        }
                    }
                    c++
                }
            }
            //25/11/22 E
            if (flgOutOfLimit == false) {
                calibResult = 'Pass'
            } else {
                calibResult = 'fail'
            }
            // if (arrConductivityVal != undefined) {
            //     if (parseFloat(arrConductivityVal) < parseFloat(strLowerLimit) || parseFloat(arrConductivityVal) > parseFloat(strUpperLimit)) {
            //         calibResult = 'Fail';

            //     }
            // }
            var result = await this.SaveConductivitycalidData(calibResult, obj, IdsNo, strBalId, strLowerLimit, strUpperLimit)
            var object = await objclsInstrumentUsageLog.InstrumentUsage(strBalId, ProbType, IdsNo, 'Conductivity Calibration', 0)
            await this.ActivityLog(IdsNo, "Calibration Completed");
            if (calibResult == 'Pass') {
                console.log('Calibration Successful')
                mqttSender.sendData(IdsNo, `${GLOBAL_NOMENCLATURE.DisplayMessage}Calibration Successful`)
                console.log("Calibration Successful");
            } else {
                console.log('Calibration Failed');
                await this.ActivityLog(IdsNo, "Calibration Completed");
                mqttSender.sendData(IdsNo, `${GLOBAL_NOMENCLATURE.DisplayMessage}Calibration Failed`)
                console.log("Calibration Failed");
            }
            mqttSender.sendData(IdsNo, `${GLOBAL_NOMENCLATURE.DisplayResult}${JSON.stringify(obj)}`)
            globalData.arrTolForConductivityCalib.splice(globalData.arrTolForConductivityCalib.findIndex((element) => element.Hmi == IdsNo), 1);
            return;
            // }

        } catch (err) {
            console.log('error from processPHCalibration : ' + err)
            throw new Error(err)
        }

    }

    //save conductivity data
    async SaveConductivitycalidData(result = 'Pass', ObjCalibration, IdsNo, strBalId, NegTol, PosTol) {
        try {
            var strDbResult = ''
            var strSql = ''
            // var ChannelNo = ''
            const tempUserObject = globalData.arrUsers.find(k => k.Hmi == IdsNo);
            var objarrSelectedChanelIDS = globalData.arrSelectedChanelIDS.find(k => k.IdsNo == parseInt(IdsNo));
            var tempCubicInfo = globalData.arrIdsInfo.find(k => k.idsNo == IdsNo);
            var objLastInsertedRepserNo = globalData.LastInsertedRepserNo.find(k => k.idsNo == IdsNo);
            var strPrintingMode = globalData.arrsAllParameters[0].tbl_PrintingMode == 'NULL' ? 'Auto' : globalData.arrsAllParameters[0].tbl_PrintingMode
            var strselectedInsrtumentType;
            for (let ele in tempCubicInfo.cubicalData) {

                if (tempCubicInfo.cubicalData[ele] == strBalId && ele.includes('ID')) {
                    strselectedInsrtumentType = ele
                    break
                }

            }
            var a = strselectedInsrtumentType.split('Port')
            var ab = (a[1].split('_'))
            var currentChannel = ab[0];
            var objarrSelectedChanelIDS = globalData.arrSelectedChanelIDS.find(k => k.IdsNo == parseInt(IdsNo));
            if (objarrSelectedChanelIDS != undefined) {
                globalData.arrSelectedChanelIDS.splice(globalData.arrSelectedChanelIDS.findIndex((element) => element.Hmi == IdsNo), 1);
            }
            globalData.arrSelectedChanelIDS.push({ IdsNo: IdsNo, selectedChannelIDS: [], currentChannel: currentChannel })
            var strProbeType = tempCubicInfo.cubicalData[`Sys_Port${currentChannel}_Type`]
            var strProbeID = tempCubicInfo.cubicalData[`Sys_Port${currentChannel}_ID`]
            var strBalId = tempCubicInfo.cubicalData[`Sys_Meter`]
            // NEED TO ADD BalanceRecalibStatusObject
            let Dp = 0;
            if (ObjCalibration.Conductivity_1.split(' ')) {
                Dp = ObjCalibration.Conductivity_1.split(' ')[0].trim().split('.');
                Dp = Dp[1].length;
            }
            var now = new Date();
            var masterData = await models.tbl_calibration_master_conductivity.create({
                PrDate: date.format(now, 'YYYY-MM-DD'),
                PrTime: date.format(now, 'HH:mm:ss'),
                UserID: tempUserObject.UserId,
                UserName: tempUserObject.UserName,
                DP: Dp,
                NegTol: `${NegTol}`,
                PosTol: `${PosTol}`,
                MeterID: strBalId,
                IDSNo: IdsNo,
                ChannelNo: currentChannel,
                ProbID: strProbeID,
                Remark: result,
                PrinterName: tempCubicInfo.Sys_Printer
            })
            var lastInsertedID = masterData.RecNo;
            if (objLastInsertedRepserNo == undefined) {
                globalData.LastInsertedRepserNo.push({
                    IdsNo: IdsNo,
                    LastInsertedRepserNo: lastInsertedID
                })

            }
            else {
                objLastInsertedRepserNo.LastInsertedRepserNo = lastInsertedID
            }
            // for await (let [i, v] of ObjCalibration) {
            //     const insertDetailObj = await models.tbl_calibration_detail_conductivity.create({
            //         RepSerNo: lastInsertedID,
            //         RecSeqNo: i + 1,
            //         Conductivity: ObjCalibration.Conductivity[i].Conductivity,
            //         Conductance: ObjCalibration.Conductance[i].Conductance,
            //         Temp: ObjCalibration.arrTemp[i].Temperature,
            //         CalibType: ObjCalibration.arrCalibType[i].type,
            //         K: ObjCalibration.arrK[i],
            //         AvgK: ObjCalibration.arrAvgK[0],
            //         Offset: ObjCalibration.arrOffset[i]
            //     })

            // }
            //Inserting Values 
            var i = 0;
            var arrCalibValues = [];
            arrCalibValues.push(ObjCalibration);
            for (let ele in arrCalibValues[0]) {
                if (ele.includes('Conductivity_')) {
                    const insertDetailObj = await models.tbl_calibration_detail_conductivity.create({
                        RepSerNo: lastInsertedID,
                        RecSeqNo: i + 1,
                        Conductivity: ObjCalibration[`Conductivity_${i + 1}`],
                        Conductance: ObjCalibration[`Conductance_${i + 1}`],
                        Temp: ObjCalibration[`Temperature_${i + 1}`],
                        CalibType: ObjCalibration[`Calibration_Type_${i + 1}`],
                        K: ObjCalibration[`k${i + 1}`],
                        AvgK: ObjCalibration[`Average.K`],
                        Offset: ObjCalibration[`Offset_${i + 1}`]
                    })
                    i++
                }

            }
            //setting Recalibration to 0 *****************************************/
            if (result == 'Pass') {
                strSql = await models.tbl_ids_setting.update({
                    [`Sys_ISRecalib${currentChannel}`]: 0
                }, { where: { Sys_IDSNo: IdsNo } })
                tempCubicInfo[`Sys_ISRecalib${currentChannel}`] = 0//reseing Recalibration flag in tbl_ids_setting array
            }
            //******************************************************************* */
            //to release ids from calibration***************************************/
            strSql = await models.tbl_ids_setting.update({
                Sys_CalibInProcess: 0
            }, { where: { Sys_IDSNo: IdsNo } })
            //**************************************************************************/

            if (tempCubicInfo != undefined) {
                tempCubicInfo.arrConductivity = [];
                tempCubicInfo.arrConductance = [];
                tempCubicInfo.arrTemp = [];
                tempCubicInfo.arrK = [];
                tempCubicInfo.arrAvgK = [];
                tempCubicInfo.arrOffset = [];
                tempCubicInfo.arrCalibType = [];
            }
            //Autoprint
            // if (strPrintingMode == 'Auto') {
            //     var Print_Protocol = await objPrint.AutoPrint(IdsNo, "Calibration");

            //     if (Print_Protocol == undefined) {
            //         Print_Protocol = 'Report Generated';
            //         console.log('ProcessPhMeter where print mode is auto')
            //     }
            //     return Print_Protocol;
            // }
            // else {
            // return Print_Protocol;
            // }
            return;
        }
        catch (error) {
            console.log('error from SaveCondcalidData : ' + error)
            throw new Error(error)
        }

    }

    async PHDateValidator(Calibdatedata) {
        var ActualDate;
        var str = Calibdatedata.replace(/\s/g, '');
        var stored1 = str
        var final_Date = stored1.split(',')[0]
        var CalibDate;
        var str_CalibDate = momentObj(final_Date).format('L');
        str_CalibDate = momentObj(str_CalibDate).format('D-MM-YY');
        str_CalibDate = momentObj(str_CalibDate).format('DD-MM-YY');
        // var str_CalibDate = momentObj(final_Date).format('DD-MM-YY');
        if (str_CalibDate == 'Invalid date') {
            CalibDate = final_Date //Ex.25-11-22

        } else {
            CalibDate = str_CalibDate //Ex.25-Nov-22
        }
        var CalibTime = stored1.split(',')[1];
        ActualDate = momentObj().format("DD-MM-YY");
        ActualPlusOne = momentObj();
        //let current_time1 = moment().format("HH:mm")
        //const current_time = moment(current_time1, ["h:mm A"]).format("HH:mm");
        var currentplus = momentObj().add(30, 'minutes').format("HH:mm")
        const currentplus1 = momentObj(currentplus, ["h:mm A"]).format("HH:mm");
        var currentminus = momentObj().subtract(30, 'minutes').format("HH:mm");
        const currentminus1 = momentObj(currentminus, ["h:mm A"]).format("HH:mm");
        var ActualPlusOne = momentObj(ActualDate, "DD-MM-YY").add(1, 'days');
        var ActualPlusOne = ActualPlusOne.format("DD-MM-YY");
        if (CalibTime.includes('PM') == true || CalibTime.includes('AM') == true) {
            if (CalibTime.includes('PM') == true) {
                CalibTime = CalibTime.split('PM')[0]
            } else {
                CalibTime = CalibTime.split('AM')[0]
            }

        }


        if (((CalibDate == ActualDate)) && ((CalibTime >= currentminus1) && (CalibTime <= currentplus1))) {
            return true;
        } else {
            return false;
        }
    }
    // async PHDateValidator(Calibdatedata) {
    //     var ActualDate;
    //     var str = Calibdatedata.replace(/\s/g, '');
    //     var stored1 = str
    //     var CalibDate = stored1.split(',')[0]
    //     var CalibTime = stored1.split(',')[1];
    //     ActualDate = momentObj().format("DD-MM-YY");
    //     ActualPlusOne = momentObj();
    //     //let current_time1 = moment().format("HH:mm")
    //     //const current_time = moment(current_time1, ["h:mm A"]).format("HH:mm");
    //     var currentplus = momentObj().add(30, 'minutes').format("HH:mm")
    //     const currentplus1 = momentObj(currentplus, ["h:mm A"]).format("HH:mm");
    //     var currentminus = momentObj().subtract(30, 'minutes').format("HH:mm");
    //     const currentminus1 = momentObj(currentminus, ["h:mm A"]).format("HH:mm");
    //     var ActualPlusOne = momentObj(ActualDate, "DD-MM-YY").add(1, 'days');
    //     var ActualPlusOne = ActualPlusOne.format("DD-MM-YY");

    //     if (((CalibDate == ActualDate)) && ((CalibTime >= currentminus1) && (CalibTime <= currentplus1))) {
    //         return true;
    //     } else {
    //         return false;
    //     }
    // }
}
module.exports = calibration;