const globalData = require('../../global/globalData');
const clsActivityLog = require('../clsActivityLog.model');
const clsInstrumentUsage = require('../clsInstrumentUsageLog')
const dbCon = require('../../global/dbCon');
const MqttModel = require('../Mqtt/mqttSender.class');
const mqttSender = new MqttModel();
const mqttProtocol = require('../../global/GLOBAL_NOMENCLATURE');
const savingObject = require('../Weighment/clsweighmentsave')
const datasave = new savingObject()
const objActivityLog = new clsActivityLog();
const objclsInstrumentUsageLog = new clsInstrumentUsage();
const date = require('date-and-time');

const momentObj = require('moment');
const { models } = require('../../../config/dbConnection');


class Weighment {
    async Do_Test_Parsing(str_Do_Channel) {
        try {

            let strParse = str_Do_Channel.str_Protocol.split('\n');
            let arr = [];
            let obj = {};
            var strHmi = str_Do_Channel.strHmi;
            var strBalId = str_Do_Channel.instrumentId;
            var tempCubicInfo = globalData.arrIdsInfo.find(k => k.idsNo == strHmi).cubicalData;
            var objarrSelectedChanelIDS = globalData.arrSelectedChanelIDS.find(k => k.IdsNo == parseInt(strHmi));
            var strselectedInsrtumentType;
            for (let ele in tempCubicInfo) {

                if (tempCubicInfo[ele] == strBalId && ele.includes('ID')) {
                    strselectedInsrtumentType = ele
                    break
                }

            }
            var a = strselectedInsrtumentType.split('Port')
            var ab = (a[1].split('_'))
            var currentChannel = ab[0];
            if (str_Do_Channel.str_Protocol.search('Operator') == -1 || str_Do_Channel.str_Protocol.search('Signature') == -1) {
                return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
            }
            for (let i = 0; i < strParse.length; i++) {
                if (strParse[i].includes("Channel -")) {
                    var slope_1 = strParse[i].replace('Channel -', ' ').trim().split(' ');
                    slope_1 = slope_1[0]
                    if (isNaN(parseInt(slope_1)) == true) {
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj[`Channel`] = slope_1;
                    if (currentChannel != slope_1) {  // channel validation
                        var strActivity = `Data Received from Channel ${slope_1} Instead of Channel ${currentChannel}`
                        var strResult = await this.ActivityLog(strHmi, strActivity)
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage} ${strActivity}`);
                    }
                }

                if (strParse[i].includes("Concentration")) {
                    let conc = strParse[i].replace('Concentration', ' ').trim();
                    conc = conc
                    if (isNaN(parseInt(conc.split(' ')[0])) == true) {
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["Concentration"] = conc;
                }

                if (strParse[i].includes("Saturation")) {
                    let sat = strParse[i].replace('Saturation', ' ').trim();
                    sat = sat
                    if (isNaN(parseInt(sat.split(' ')[0])) == true) {
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["Saturation"] = sat;
                }

                if (strParse[i].includes("Current")) {
                    let Curr = strParse[i].replace('Current', ' ').trim();
                    Curr = Curr
                    if (isNaN(parseInt(Curr.split(' ')[0])) == true) {
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["Current"] = Curr;
                }
                if (strParse[i].includes("Partial")) {
                    let Partial = strParse[i].replace('Partial', ' ').trim();
                    Partial = Partial
                    if (isNaN(parseInt(Partial.split(' ')[0])) == true) {
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["PartialPressure"] = Partial;
                }

                if (strParse[i].includes("Solution Temp")) {
                    let ST = strParse[i].replace('Solution Temp', ' ').trim();
                    ST = ST
                    if (isNaN(parseInt(ST.split(' ')[0])) == true) {
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["Solution_Temp"] = ST;
                }

                if (strParse[i].includes("Membrane Temp")) {
                    let MT = strParse[i].replace('Membrane Temp', ' ').trim();
                    MT = MT
                    if (isNaN(parseInt(MT.split(' ')[0])) == true) {
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["Membrane_Temp"] = MT;
                }

                if (strParse[i].includes("Barometric Pressure")) {
                    let BP = strParse[i].replace('Barometric Pressure', ' ').trim();
                    BP = BP
                    if (isNaN(parseInt(BP.split(' ')[0])) == true) {
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["Barometric_Pressure"] = BP;
                }

                if (strParse[i].includes("Salinity Correction")) {
                    let SC = strParse[i].replace('Salinity Correction', ' ').trim();
                    SC = SC
                    if (isNaN(parseInt(SC.split(' ')[0])) == true) {
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["Salinity_Correction"] = SC;
                }

                if (strParse[i].includes("Slope")) {
                    let slope = strParse[i].replace('Slope', ' ').trim();
                    slope = slope
                    if (isNaN(parseInt(slope.split(' ')[0])) == true) {
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["Slope"] = slope;
                    arr.push(obj)
                }
            }
            console.log(arr);
            str_Do_Channel.Parsedata = obj
            let returnData = await datasave.saveDOWdata(str_Do_Channel);
            mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${JSON.stringify(obj)}`)

            var objDOWData = globalData.arrDOWData.find(k => k.idsNo == parseInt(IdsNo));
            if (objDOWData == undefined) {
                globalData.arrDOWData.push({
                    idsNo: IdsNo, Slope: 0, Saturation: 0,
                    Concentration: 0, Current: 0, TempSolution: 0, TempMembrane: 0,
                    BioPressure: 0, SalinityCorrection: 0, PartialPressure: 0,
                });
            } else {
                objDOWData.Saturation = 0;
                objDOWData.Concentration = 0;
                objDOWData.Current = 0;
                objDOWData.TempSolution = 0;
                objDOWData.TempMembrane = 0;
                objDOWData.BioPressure = 0;
                objDOWData.SalinityCorrection = 0;
                objDOWData.PartialPressure = 0;
            }
            return;



        }
        catch (error) {
        }
    }
    async PH_Test_Parsing(str_PH_Channel) {
        try {

            var strHmi = str_PH_Channel.strHmi;
            var str_pH = str_PH_Channel.str_Protocol;
            var strBalId = str_PH_Channel.instrumentId;
            var stringData = str_pH.split("\n");
            var obj = {}
            // var pHParse = str_PH_Channel.str_Protocol.split("/n");//pH_Test.split('\n');
            var arr = [];
            var tempCubicInfo = globalData.arrIdsInfo.find(k => k.idsNo == strHmi).cubicalData;
            var objarrSelectedChanelIDS = globalData.arrSelectedChanelIDS.find(k => k.IdsNo == parseInt(strHmi));
            var strselectedInsrtumentType;
            for (let ele in tempCubicInfo) {

                if (tempCubicInfo[ele] == strBalId && ele.includes('ID')) {
                    strselectedInsrtumentType = ele
                    break
                }

            }
            var a = strselectedInsrtumentType.split('Port')
            var ab = (a[1].split('_'))
            var currentChannel = ab[0];
            if (str_PH_Channel.str_Protocol.search('Operator') == -1 || str_PH_Channel.str_Protocol.search('Signature') == -1) {
                return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
            }
            for (var i = 0; i < stringData.length; i++) {

                if (stringData[i].includes("Channel -")) {
                    var slope_1 = stringData[i].replace('Channel -', ' ').trim().split(' ');
                    slope_1 = slope_1[0]
                    if (isNaN(parseInt(slope_1)) == true) {
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj[`Channel`] = slope_1;
                    if (currentChannel != slope_1) {  // channel validation
                        var strActivity = `Data Received from Channel ${slope_1} Instead of Channel ${currentChannel}`
                        var strResult = await this.ActivityLog(strHmi, strActivity)
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage} ${strActivity}`);
                    }
                }
                if (stringData[i].includes("pH") && !stringData[i].includes("Mode") && !stringData[i].includes("mV")) {
                    let pH = stringData[i].replace('pH', ' ').trim();
                    pH = pH
                    if (isNaN(parseInt(pH.split(' ')[0])) == true) {
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    if (pH.includes('pH') == false) {
                        console.log('Unit not reveived');
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["pH"] = pH;
                }

                if (stringData[i].includes("mV")) {
                    let mV = stringData[i].replace('mV', ' ').trim();
                    mV = mV
                    if (isNaN(parseInt(mV.split(' ')[0])) == true) {
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    if (mV.includes('mV') == false) {
                        console.log('Unit not reveived');
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["mV"] = mV;
                }

                if (stringData[i].includes("Temperature")) {
                    let Temp = stringData[i].replace('Temperature', ' ').trim();
                    Temp = Temp
                    if (isNaN(parseInt(Temp.split(' ')[0])) == true) {
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    if (Temp.includes('C (ATC)') == false) {
                        console.log('Unit not reveived');
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["Temperature"] = Temp;
                }

                if (stringData[i].includes("Average Slope")) {
                    let AS = stringData[i].replace('Average Slope', ' ').trim();
                    AS = AS
                    if (isNaN(parseInt(AS.split(' ')[0])) == true) {
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    if (AS.includes('%') == false) {
                        console.log('Unit not reveived');
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["Average_Slope"] = AS;
                    arr.push(obj);
                }
            }


            console.log(arr);
            console.log(arr);
            var phdata_present = arr.find(k => {
                return (k.hasOwnProperty('Channel') &&
                    k.hasOwnProperty('pH') &&
                    k.hasOwnProperty('mV') &&
                    k.hasOwnProperty('Temperature')

                )
            })
            if (phdata_present == undefined) {
                return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
            }
            str_PH_Channel.Parsedata = arr[0];
            await datasave.savePHdata(str_PH_Channel)
            mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${JSON.stringify(obj)}`);
            mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}: Report Generated`);
        }
        catch (error) {

        }

    }

    async Conductivity_Test_Parsing(str_Conduct_Channel) {
        try {

            var strHmi = str_Conduct_Channel.strHmi;
            var str_Conduct = str_Conduct_Channel.str_Protocol;
            var strBalId = str_Conduct_Channel.instrumentId;
            var CondParse = str_Conduct.split("\n");
            var obj = {}
            var arr = [];
            var tempCubicInfo = globalData.arrIdsInfo.find(k => k.idsNo == strHmi).cubicalData;
            var objarrSelectedChanelIDS = globalData.arrSelectedChanelIDS.find(k => k.IdsNo == parseInt(strHmi));
            if (!str_Conduct.includes('Channel')) {
                return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);

            }
            var strselectedInsrtumentType;
            for (let ele in tempCubicInfo) {

                if (tempCubicInfo[ele] == strBalId && ele.includes('ID')) {
                    strselectedInsrtumentType = ele
                    break
                }

            }
            var a = strselectedInsrtumentType.split('Port')
            var ab = (a[1].split('_'))
            var currentChannel = ab[0];
            for (var i = 0; i < CondParse.length; i++) {

                if (CondParse[i].includes("Channel -")) {
                    var slope_1 = CondParse[i].replace('Channel -', ' ').trim().split(' ');
                    slope_1 = slope_1[0]
                    if (isNaN(parseInt(slope_1)) == true) {
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj[`Channel`] = slope_1;
                    if (currentChannel != slope_1) {  // channel validation
                        var strActivity = `Data Received from Channel ${slope_1} Instead of Channel ${currentChannel}`
                        var strResult = await this.ActivityLog(strHmi, strActivity)
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage} ${strActivity}`);
                    }
                }

                if (CondParse[i].includes("Conductivity") && !CondParse[i].includes("Mode")) {
                    let cond_1 = CondParse[i].replace('Conductivity', ' ').trim();
                    cond_1 = cond_1
                    if (isNaN(parseInt(cond_1.split(' ')[0])) == true) {
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    if (cond_1.includes('uS/cm') == false) {
                        console.log('Unit not reveived');
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["Conductivity"] = cond_1;
                }

                if (CondParse[i].includes("Conductance")) {
                    let cond_2 = CondParse[i].replace('Conductance', ' ').trim();
                    cond_2 = cond_2
                    if (isNaN(parseInt(cond_2.split(' ')[0])) == true) {
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    if (cond_2.includes('uS') == false) {
                        console.log('Unit not reveived');
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["Conductance"] = cond_2;
                }

                if (CondParse[i].includes("Temperature")) {
                    let Temp = CondParse[i].replace('Temperature', ' ').trim();
                    Temp = Temp
                    if (isNaN(parseInt(Temp.split(' ')[0])) == true) {
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    if (Temp.includes('C (ATC)') == false) {
                        console.log('Unit not reveived');
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["Temperature"] = Temp;
                }

                if (CondParse[i].includes("Temp. Coefficient")) {
                    let TC = CondParse[i].replace('Temp. Coefficient', ' ').trim();
                    TC = TC
                    if (isNaN(parseInt(TC.split(' ')[0])) == true) {
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    if (TC.includes('%/C') == false) {
                        console.log('Unit not reveived');
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["Temp_Coefficient"] = TC;
                }

                if (CondParse[i].includes("Temp. Reference")) {
                    let TR = CondParse[i].replace('Temp. Reference', ' ').trim();
                    TR = TR
                    if (isNaN(parseInt(TR.split(' ')[0])) == true) {
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    if (TR.includes('C') == false) {
                        console.log('Unit not reveived');
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["Temp_Reference"] = TR;
                }

                if (CondParse[i].includes("K")) {
                    let K = CondParse[i].replace('K', ' ').trim();
                    K = K
                    if (isNaN(parseInt(K.split(' ')[0])) == true) {
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    if (K.includes('/cm') == false) {
                        console.log('Unit not reveived');
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["K"] = K;
                    arr.push(obj);
                }
            }
            console.log(arr);
            console.log(arr);
            // let conductdata = arr.filter((e) => e.hasOwnProperty('Channel'))
            var data_present = arr.find(k => {
                return (k.hasOwnProperty('Channel') &&
                    k.hasOwnProperty('Conductance') &&
                    k.hasOwnProperty('Conductivity') &&
                    k.hasOwnProperty('K') &&
                    k.hasOwnProperty('Temp_Coefficient') &&
                    k.hasOwnProperty('Temp_Reference') &&
                    k.hasOwnProperty('Temperature')

                )
            })
            if (data_present == undefined) {
                return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
            }
            str_Conduct_Channel.Parsedata = arr[0];
            await datasave.saveConductivitycalidData(str_Conduct_Channel)
            mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${JSON.stringify(obj)}`);
            mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}: Report Generated`);
        }
        catch (error) {

        }

    }

    async PH_ISE_Test_Parsing(str_ISE_Channel) {
        try {

            var strHmi = str_ISE_Channel.strHmi;
            var str_pH = str_ISE_Channel.str_Protocol;
            var strBalId = str_ISE_Channel.instrumentId;
            var stringData = str_pH.split("\n");
            var obj = {}
            // var pHParse = str_PH_Channel.str_Protocol.split("/n");//pH_Test.split('\n');
            var arr = [];
            var tempCubicInfo = globalData.arrIdsInfo.find(k => k.idsNo == strHmi).cubicalData;
            var objarrSelectedChanelIDS = globalData.arrSelectedChanelIDS.find(k => k.IdsNo == parseInt(strHmi));
            var strselectedInsrtumentType;
            for (let ele in tempCubicInfo) {

                if (tempCubicInfo[ele] == strBalId && ele.includes('ID')) {
                    strselectedInsrtumentType = ele
                    break
                }

            }
            var a = strselectedInsrtumentType.split('Port')
            var ab = (a[1].split('_'))
            var currentChannel = ab[0];
            for (var i = 0; i < stringData.length; i++) {
                if (stringData[i].includes("Channel -")) {
                    var slope_1 = stringData[i].replace('Channel -', ' ').trim().split(' ');
                    slope_1 = slope_1[0]
                    if (isNaN(parseInt(slope_1.split(' ')[0])) == true) {
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj[`Channel`] = slope_1;
                    if (currentChannel != slope_1) {  // channel validation
                        var strActivity = `Data Received from Channel ${slope_1} Instead of Channel ${currentChannel}`
                        var strResult = await this.ActivityLog(strHmi, strActivity)
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage} ${strActivity}`);
                    }
                }

                if (stringData[i].includes("Electrode Type")) {
                    let Ele_Type = stringData[i].replace('Electrode Type', ' ').trim();
                    Ele_Type = Ele_Type
                    // if (isNaN(parseInt(Ele_Type.split(' ')[0])) == true) {
                    //     return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    // }
                    obj["Electrode_Type"] = Ele_Type;
                }
                if (stringData[i].includes("Concentration")) {
                    let conce = stringData[i].replace('Concentration', ' ').trim();
                    conce = conce
                    if (isNaN(parseInt(conce.split(' ')[0])) == true) {
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["Concentration"] = conce;
                }
                if (stringData[i].includes("pH") && !stringData[i].includes("Mode") && !stringData[i].includes("mV")) {
                    let pH = stringData[i].replace('pH', ' ').trim();
                    pH = pH
                    if (isNaN(parseInt(pH.split(' ')[0])) == true) {
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["pH"] = pH;
                }
                if (stringData[i].includes("mV") && !stringData[i].includes("Slope")) {
                    let mV = stringData[i].replace('mV', ' ').trim();
                    mV = mV
                    if (isNaN(parseInt(mV.split(' ')[0])) == true) {
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["mV"] = mV;
                }

                if (stringData[i].includes("Temperature")) {
                    let Temp = stringData[i].replace('Temperature', ' ').trim();
                    Temp = Temp
                    if (isNaN(parseInt(Temp.split(' ')[0])) == true) {
                        return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                    }
                    obj["Temperature"] = Temp;
                }

                if (stringData[i].includes("Slope")) {
                    if (stringData[i].includes('Average Slope')) {
                        let avg = stringData[i].replace('Average Slope', ' ').trim().split();
                        avg = avg[0]
                        if (isNaN(parseInt(avg.split(' ')[0])) == true) {
                            return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                        }
                        // arr.push(a);
                        obj["Average_Slope"] = avg;
                    } else {
                        let AS = stringData[i].replace('Slope', ' ').trim();
                        AS = AS
                        if (isNaN(parseInt(AS.split(' ')[0])) == true) {
                            return mqttSender.sendData(strHmi, `${mqttProtocol.DisplayMessage}Invalid String`);
                        }
                        obj["Slope"] = AS;
                        // arr.push(obj);
                    }
                    arr.push(obj);
                }


            }
            console.log(obj);
            console.log(obj);
            str_ISE_Channel.Parsedata = arr[0];
            await datasave.savePH_ISEdata(str_ISE_Channel)
            mqttSender.sendData(strHmi, `${mqttProtocol.DisplayResult}${JSON.stringify(obj)}`)
        } catch (err) {
            console.log(err);

        }
    }

    async ActivityLog(idsNo, Activity) {
        var objUserInfo = globalData.arrUsers.find(k => k.Hmi == idsNo);
        var objActivity = {};
        Object.assign(objActivity,
            { strUserId: objUserInfo.UserId },
            { strUserName: objUserInfo.UserName },
            { activity: Activity })
        await objActivityLog.ActivityLogEntry(objActivity)
    }
}
module.exports = Weighment;