const objmoment = require('moment');
const globalData = require('../../global/globalData');
const clsActivityLog = require('../clsActivityLog.model');
const clsdailycalibration = require('../InstrumentParsings/ph.model');
const clslogin = require('../Login/login.model');
const clsconfigsetting = require('../clsConfigSetting');
const { models } = require('../../../config/dbConnection');
const sequelize = require('../../../config/dbConnection').sequelize;
const object = require('joi/lib/types/object');
const objActivityLog = new clsActivityLog();
const calibration = new clsdailycalibration();
const objlogin = new clslogin();
const objConfigSettings = new clsconfigsetting();

class Test {
    async ARNo(value) {
        var strHmi = value.Hmi;
        var strresbpi = value.resbpi;
        var Test_Name = value.Test_Type;
        var ProductType = value.Product_Type;
        var ProductName = value.Product_Name;
        var Product_Id = value.Product_ID;
        var ARNo = value.AR_No;
        var SampleId = value.Sample_Id;
        var BatchNo = value.Batch_No;
        var arrBal = await this.getCubicalData(strHmi); //Fetching ids setting data 
        arrBal = [arrBal]
        var a = Test_Name.split(" ")[1]
        var currentChannel = (a.split('-')[1]);
        var strBalId = arrBal[0][0][`Sys_Port${currentChannel}_ID`];
        var Instrument_Type = Test_Name.split(" ")[2];
        var Meter_ID = arrBal[0].Sys_Meter;
        var obj = {}
        obj = {
            Hmi: strHmi,
            resbpi: strresbpi,
            Test_Type: Test_Name,
            Product_Type: ProductType,
            Product_Name: ProductName,
            AR_No: ARNo,
            Sample_Id: SampleId,
            Batch_No: BatchNo,
            Product_ID: Product_Id
            // InstrumentType: Instrument_Type,
            // instrumentId: strBalId
        }

        var arrSelectedMenu = globalData.arrSelectedMenu.find(k => k.Hmi == strHmi);
        if (arrSelectedMenu == undefined) {
            globalData.arrSelectedMenu.push({
                Hmi: strHmi,
                respbi: strresbpi,
                selectedProductDetail: obj,
                instrumentId: strBalId,
                InstrumentType: Instrument_Type,
                portNo: currentChannel,
                BalID: Meter_ID,
            })
        } else {
            arrSelectedMenu.BalID = Meter_ID
            arrSelectedMenu.selectedProductDetail = obj
            arrSelectedMenu.instrumentId = strBalId
            arrSelectedMenu.InstrumentType = Instrument_Type
            arrSelectedMenu.portNo = currentChannel
        }

        var objProduct = globalData.arrMaterialProductSelected.find(k => k.idsNo == strHmi);
        if (objProduct == undefined) {
            var object = {
                idsNo: strHmi,
                ProuductID: Product_Id,
                ProductSelected: ProductName,
                Productype: ProductType,
                // productPrefix:arrProductName[0].productPrefix,
                Channel: currentChannel
            }
            globalData.arrMaterialProductSelected.push(object);
            
        }
        else {
            objProduct.ProuductID = Product_Id;
            objProduct.ProductSelected = ProductName;
            objProduct.Productype = ProductType;
            // objProduct.productPrefix = arrProductName[0].productPrefix;
            objProduct.Channel = currentChannel;

        }


        let arrBalList = await this.pushBalList(arrBal[0][0].Sys_HMIID, strHmi, arrBal[0][0]);
        console.log(arrBalList);
        var i = 0;

        let allBal = globalData.arrOfBalListWithPortNumber.find(k => k.Hmi == strHmi)
        var setting = [];
        for (i; i < allBal.BalList.length; i++) {
            let balance_list = allBal;
            let balance = balance_list.BalList[i].type + '_Id';
            let PortNo = balance_list.BalList[i].PortNo;
            let Instrument_type = balance_list.BalList[i].type
            let bal_setting = await objConfigSettings.getConfiSetting(strHmi, Instrument_type, PortNo);
            setting.push(bal_setting[0]);
        }
        var configsetting;
        configsetting = setting.filter(k => k.type == Instrument_Type);;

        var objActivity_Ptype = {};
        var objActivity_Product = {};
        var objActivity_ARNo = {};
        var objActivity_Sample = {};
        var objActivity_Batch = {};
        var objUserInfo = globalData.arrUsers.find(k => k.Hmi == strHmi);
        //Activity For Product Type,Product,ARNo,Sample No, Batch
        Object.assign(objActivity_Ptype,
            { strUserId: objUserInfo.UserId },
            { strUserName: objUserInfo.UserName },
            { activity: ProductType + ' Product Type Selected by user on TSH ' + strHmi })
        await objActivityLog.ActivityLogEntry(objActivity_Ptype)
        Object.assign(objActivity_Product,
            { strUserId: objUserInfo.UserId },
            { strUserName: objUserInfo.UserName },
            { activity: ProductName + ' Product Selected by user on TSH ' + strHmi })
        await objActivityLog.ActivityLogEntry(objActivity_Product)
        Object.assign(objActivity_ARNo,
            { strUserId: objUserInfo.UserId },
            { strUserName: objUserInfo.UserName },
            { activity: ARNo + ' AR Number Selected by user on TSH ' + strHmi })
        await objActivityLog.ActivityLogEntry(objActivity_ARNo)
        Object.assign(objActivity_Sample,
            { strUserId: objUserInfo.UserId },
            { strUserName: objUserInfo.UserName },
            { activity: SampleId + ' Sample ID Selected by user on TSH ' + strHmi })
        await objActivityLog.ActivityLogEntry(objActivity_Sample)
        Object.assign(objActivity_Batch,
            { strUserId: objUserInfo.UserId },
            { strUserName: objUserInfo.UserName },
            { activity: BatchNo + ' Batch No Selected by user on TSH ' + strHmi })
        await objActivityLog.ActivityLogEntry(objActivity_Batch)
        

        return { status: 'success', Obj: obj, Configsetting: configsetting };

    }

    async getCubicalData(strHmi) {
        try {
            let cubicalData = await models.tbl_ids_setting.findAll({
                where: {
                    'Sys_IDSNo': strHmi
                }
            });
            return [cubicalData[0]];
        } catch (error) {
            throw new Error(error)

        }
    }

    async pushBalList(strResbPiNo, Hmi, ObjBalList) {
        try {
            let objOfBallist = this.clean(ObjBalList);

            let arrDetailOfallBalance = [];
            let arrAllListOfBal = [];
            let i = 1;
            for (let obj in objOfBallist) {
                if (objOfBallist[`Sys_Port${i}_Type`] == undefined || objOfBallist[`Sys_Port${i}_Type`] == "None") {
                    i++;
                    continue;
                }
                else {
                    if (objOfBallist[`Sys_Port${i}_Type`] == "pH") {
                        arrDetailOfallBalance.push(
                            { "PHId": objOfBallist[`Sys_Port${i}_ID`], "PortNo": i, "type": objOfBallist[`Sys_Port${i}_Type`] }
                        )

                        arrAllListOfBal.push(objOfBallist[`Sys_Port${i}_ID`]);
                    } else if (objOfBallist[`Sys_Port${i}_Type`] == "Conductivity") {
                        arrDetailOfallBalance.push(
                            { "ConductivityId": objOfBallist[`Sys_Port${i}_ID`], "PortNo": i, "type": objOfBallist[`Sys_Port${i}_Type`] }
                        )

                        arrAllListOfBal.push(objOfBallist[`Sys_Port${i}_ID`]);
                    } else if (objOfBallist[`Sys_Port${i}_Type`] == "pH/ISE") {
                        arrDetailOfallBalance.push(
                            { "pH/ISEId": objOfBallist[`Sys_Port${i}_ID`], "PortNo": i, "type": objOfBallist[`Sys_Port${i}_Type`] }
                        )

                        arrAllListOfBal.push(objOfBallist[`Sys_Port${i}_ID`]);
                    } else if (objOfBallist[`Sys_Port${i}_Type`] == "DO/RDO") {
                        arrDetailOfallBalance.push(
                            { "DO/RDOId": objOfBallist[`Sys_Port${i}_ID`], "PortNo": i, "type": objOfBallist[`Sys_Port${i}_Type`] }
                        )

                        arrAllListOfBal.push(objOfBallist[`Sys_Port${i}_ID`]);
                    }
                    // if (objOfBallist[`Sys_Port${i}_ID`] == "IPC Balance") {
                    //     arrDetailOfallBalance.push(
                    //         { "BalanceId": objOfBallist[`Sys_BinBalID`], "PortNo": i, "type": "IPC Balance" }
                    //     )

                    //     arrAllListOfBal.push(objOfBallist[`Sys_BinBalID`]);
                    // }

                    i++;
                }
            }

            let arrOfBalList = globalData.arrOfBalListWithPortNumber.find(k => k.Hmi == Hmi)
            //pushing balanceId with their port number gollbally
            if (arrOfBalList == undefined) {

                globalData.arrOfBalListWithPortNumber.push({
                    "resbpi": strResbPiNo,
                    "strHmi": Hmi,
                    "BalList": arrDetailOfallBalance
                })
            } else {
                arrOfBalList.ResbPi = strResbPiNo;
                arrOfBalList.BalList = arrDetailOfallBalance;
            }
            console.log(globalData.arrOfBalListWithPortNumber);

            return arrAllListOfBal;
        } catch (error) {
            console.log(error)
        }
    }

    clean(obj) {
        for (let key in obj) {
            if (obj[key] == null || obj[key] == undefined || obj[key] == "None") {
                delete obj[key];
            }
        }
        return obj;
    }
    async Product_Type(value) {
        var strHmi = value.Hmi;
        var strresbpi = value.resbpi;
        var Test_Name = value.Test_Type;
        var strSql = await models.tbl_ids_setting.update({ Sys_WeighmentInProcess: 1 }, {
            where: { Sys_IDSNo: strHmi }
        })
        var tempCubicInfo = globalData.arrIdsInfo.find(k => k.idsNo == strHmi).cubicalData;
        var a = Test_Name.split(" ")[1]
        var currentChannel = (a.split('-')[1]);
        var objUserInfo = globalData.arrUsers.find(k => k.Hmi == strHmi);
        var rightObj = globalData.arrUserRights.find(k => k.Hmi == strHmi);
        var objarrSelectedChanelIDS = globalData.arrSelectedChanelIDS.find(k => k.IdsNo == strHmi);
        if (rightObj.rights.includes('Test')) {
            var obj = currentChannel //channel no find
            objarrSelectedChanelIDS.selectedChannelIDS.push(obj)
            objarrSelectedChanelIDS.currentChannel = obj
            // return mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}:Enter Product Type Initials`);
            console.log("Enter Product Type Initials");
        }
        // else {
        //     console.log("Test Right Not Assigned");
        //     return { status: 'Fail', message: "Test Right Not Assigned"}
        // }

        var Pr_TypeDetails = await models.tbl_producttype.findAll({
        })

        Pr_TypeDetails = Pr_TypeDetails.map(k => k.PT_productType != "" ? k.PT_productType : "").filter(k => k != "NULL" && k != "" && k != "null")

        //**********Product Type*********/
        var objTypeSelected = globalData.arrTypeSelected.find(k => k.idsNo == strHmi);
        if (objTypeSelected == undefined) {
            var TypeSel = Pr_TypeDetails[0];
            globalData.arrTypeSelected.push({
                idsNo: strHmi,
                TypeSelected: Pr_TypeDetails[0]
            });
        }
        else {
            objTypeSelected.idsNo = strHmi,
                objTypeSelected.TypeSelected = Pr_TypeDetails[0]
        }
        // mqttSender.sendData(IdsNo, `${mqttProtocol.DisplayMessage}:Enter Product Type Initials`);

        globalData.arrcalibType.splice(globalData.arrcalibType.findIndex((element) => element.Hmi == strHmi), 1);
        var arrcurrentOperation = globalData.arrCurrentOperationStatus.find(k => k.Hmi == strHmi);
        if (arrcurrentOperation == undefined) {
            globalData.arrCurrentOperationStatus.push({
                Hmi: strHmi,
                respbi: strresbpi,
                weightment: "1",
                testType: "weightment"
            })
        }
        var objActivity = {};

        // Object.assign(objActivity,
        //     { strUserId: objUserInfo.UserId },
        //     { strUserName: objUserInfo.UserName },
        //     { activity: Pr_TypeDetails[0] + ' selected by user on TSH ' + strHmi })
        // await objActivityLog.ActivityLogEntry(objActivity)
        return { status: "success", result: Pr_TypeDetails };

    }

    //**********Product*********/
    async Product(value) {
        var strHmi = value.Hmi;
        var Product_Type = value.Product_Type;
        var objUserInfo = globalData.arrUsers.find(k => k.Hmi == strHmi);
        var ProductDetails = await models.tbl_product.findAll({
            attributes: { exclude: ['RecNo', 'productType', 'locked', 'editCounter', 'InProcess'] },
            where: {
                productType: Product_Type
            }
        })

        // var objActivity = {};

        // Object.assign(objActivity,
        //     { strUserId: objUserInfo.UserId },
        //     { strUserName: objUserInfo.UserName },
        //     { activity: Pr_TypeDetails[0] + ' selected by user on TSH ' + strHmi })
        // await objActivityLog.ActivityLogEntry(objActivity)
        return { status: "success", result: ProductDetails };

    }

}
module.exports = Test;